/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.nfi.backend.panama.ArgumentNode;
import com.oracle.truffle.nfi.backend.panama.ArgumentNodeFactory;
import com.oracle.truffle.nfi.backend.panama.ClosureArgumentNode;
import com.oracle.truffle.nfi.backend.panama.ClosureArgumentNodeFactory;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

class PanamaType {
    final MemoryLayout nativeLayout;
    final Class<?> javaType;
    final Class<?> javaRetType;
    final NativeSimpleType type;

    PanamaType(NativeSimpleType type) throws UnsupportedOperationException {
        this.type = type;
        switch (type) {
            case VOID: {
                this.nativeLayout = null;
                this.javaType = Void.TYPE;
                this.javaRetType = this.javaType;
                break;
            }
            case UINT8: 
            case SINT8: {
                this.nativeLayout = ValueLayout.JAVA_BYTE;
                this.javaType = Byte.TYPE;
                this.javaRetType = this.javaType;
                break;
            }
            case UINT16: 
            case SINT16: {
                this.nativeLayout = ValueLayout.JAVA_SHORT;
                this.javaType = Short.TYPE;
                this.javaRetType = this.javaType;
                break;
            }
            case UINT32: 
            case SINT32: {
                this.nativeLayout = ValueLayout.JAVA_INT;
                this.javaType = Integer.TYPE;
                this.javaRetType = this.javaType;
                break;
            }
            case UINT64: 
            case SINT64: 
            case POINTER: {
                this.nativeLayout = ValueLayout.JAVA_LONG;
                this.javaType = Long.TYPE;
                this.javaRetType = this.javaType;
                break;
            }
            case FP80: {
                throw new UnsupportedOperationException("FP80 not implemented");
            }
            case FLOAT: {
                this.nativeLayout = ValueLayout.JAVA_FLOAT;
                this.javaType = Float.TYPE;
                this.javaRetType = this.javaType;
                break;
            }
            case DOUBLE: {
                this.nativeLayout = ValueLayout.JAVA_DOUBLE;
                this.javaType = Double.TYPE;
                this.javaRetType = this.javaType;
                break;
            }
            case STRING: {
                this.javaType = MemorySegment.class;
                this.javaRetType = MemorySegment.class;
                this.nativeLayout = ValueLayout.ADDRESS;
                break;
            }
            case OBJECT: {
                this.javaType = Object.class;
                throw CompilerDirectives.shouldNotReachHere((String)"OBJ not implemented");
            }
            case NULLABLE: {
                throw CompilerDirectives.shouldNotReachHere((String)"Nullable not implemented");
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere((String)"Type does not exist.");
            }
        }
    }

    public ArgumentNode createArgumentNode() {
        switch (this.type) {
            case VOID: {
                return ArgumentNodeFactory.ToVOIDNodeGen.create(this);
            }
            case UINT8: 
            case SINT8: {
                return ArgumentNodeFactory.ToINT8NodeGen.create(this);
            }
            case UINT16: 
            case SINT16: {
                return ArgumentNodeFactory.ToINT16NodeGen.create(this);
            }
            case UINT32: 
            case SINT32: {
                return ArgumentNodeFactory.ToINT32NodeGen.create(this);
            }
            case UINT64: 
            case SINT64: {
                return ArgumentNodeFactory.ToINT64NodeGen.create(this);
            }
            case POINTER: {
                return ArgumentNodeFactory.ToPointerNodeGen.create(this);
            }
            case FP80: {
                throw new UnsupportedOperationException();
            }
            case FLOAT: {
                return ArgumentNodeFactory.ToFLOATNodeGen.create(this);
            }
            case DOUBLE: {
                return ArgumentNodeFactory.ToDOUBLENodeGen.create(this);
            }
            case STRING: {
                return ArgumentNodeFactory.ToSTRINGNodeGen.create(this);
            }
            case OBJECT: {
                throw CompilerDirectives.shouldNotReachHere((String)"OBJ not imple");
            }
            case NULLABLE: {
                throw CompilerDirectives.shouldNotReachHere((String)"Nullable not imple");
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Type does not exist.");
    }

    public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
        switch (this.type) {
            case VOID: 
            case UINT8: 
            case SINT8: 
            case UINT16: 
            case SINT16: 
            case UINT32: 
            case SINT32: 
            case UINT64: 
            case SINT64: 
            case POINTER: 
            case FP80: 
            case FLOAT: 
            case DOUBLE: {
                return ClosureArgumentNodeFactory.GenericClosureArgumentNodeGen.create(this, arg);
            }
            case STRING: {
                return ClosureArgumentNodeFactory.StringClosureArgumentNodeGen.create(this, arg);
            }
            case OBJECT: {
                throw CompilerDirectives.shouldNotReachHere((String)"OBJ not imple");
            }
            case NULLABLE: {
                throw CompilerDirectives.shouldNotReachHere((String)"Nullable not imple");
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Type does not exist.");
    }
}

