/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.HtmlElement;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.ParseStatus;

class HtmlAutoCloseElement
extends HtmlElement {
    protected final char[][] autoCloseRequired;
    protected final char[][] autoCloseLimits;

    HtmlAutoCloseElement(String name, String[] autoCloseElements, String[] autoCloseLimits) {
        super(name);
        Object autoCloseLimitsCharArray;
        if (autoCloseElements == null) {
            throw new IllegalArgumentException("The array of auto-close elements cannot be null");
        }
        char[][] autoCloseElementsCharArray = new char[autoCloseElements.length][];
        for (int i = 0; i < autoCloseElementsCharArray.length; ++i) {
            autoCloseElementsCharArray[i] = autoCloseElements[i].toCharArray();
        }
        if (autoCloseLimits != null) {
            autoCloseLimitsCharArray = new char[autoCloseLimits.length][];
            for (int i = 0; i < ((char[][])autoCloseLimitsCharArray).length; ++i) {
                autoCloseLimitsCharArray[i] = autoCloseLimits[i].toCharArray();
            }
        } else {
            autoCloseLimitsCharArray = null;
        }
        this.autoCloseRequired = autoCloseElementsCharArray;
        this.autoCloseLimits = autoCloseLimitsCharArray;
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if (autoCloseEnabled && !status.isAutoOpenCloseDone()) {
            status.setAutoCloseRequired(this.autoCloseRequired, this.autoCloseLimits);
            return;
        }
        handler.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if (autoCloseEnabled && !status.isAutoOpenCloseDone()) {
            status.setAutoCloseRequired(this.autoCloseRequired, this.autoCloseLimits);
            return;
        }
        handler.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }
}

