/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search_shards;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardStoreIndex
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardStoreIndex> {
    @Nonnull
    private final List<String> aliases;
    @Nullable
    private final Query filter;
    public static final JsonpDeserializer<ShardStoreIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoreIndex::setupShardStoreIndexDeserializer);

    private ShardStoreIndex(Builder builder) {
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.filter = builder.filter;
    }

    public static ShardStoreIndex of(Function<Builder, ObjectBuilder<ShardStoreIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> aliases() {
        return this.aliases;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (String item0 : this.aliases) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardStoreIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "aliases");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.aliases);
        result = 31 * result + Objects.hashCode(this.filter);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStoreIndex other = (ShardStoreIndex)o;
        return Objects.equals(this.aliases, other.aliases) && Objects.equals(this.filter, other.filter);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardStoreIndex> {
        @Nullable
        private List<String> aliases;
        @Nullable
        private Query filter;

        public Builder() {
        }

        private Builder(ShardStoreIndex o) {
            this.aliases = Builder._listCopy(o.aliases);
            this.filter = o.filter;
        }

        private Builder(Builder o) {
            this.aliases = Builder._listCopy(o.aliases);
            this.filter = o.filter;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aliases(List<String> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        @Nonnull
        public final Builder aliases(String value, String ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        @Nonnull
        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        @Override
        @Nonnull
        public ShardStoreIndex build() {
            this._checkSingleUse();
            return new ShardStoreIndex(this);
        }
    }
}

