"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyResultMapper = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const anomalyResultMapper = anomalyResults => {
  let resultData = {
    anomalies: [],
    featureData: {}
  };
  if (anomalyResults.length === 0) return resultData;
  //initialize features list.
  const firstAnomaly = anomalyResults[0];
  Object.values(firstAnomaly.featureData).forEach(feature => {
    resultData.featureData[feature.featureId] = [];
  });
  anomalyResults.forEach(({
    featureData,
    ...rest
  }) => {
    resultData.anomalies.push({
      ...rest,
      anomalyGrade: rest.anomalyGrade != null && rest.anomalyGrade > 0 ? Number.parseFloat(rest.anomalyGrade).toFixed(2) : 0,
      confidence: rest.confidence != null && rest.confidence > 0 ? Number.parseFloat(rest.confidence).toFixed(2) : 0,
      plotTime: rest.dataStartTime + Math.floor((rest.dataEndTime - rest.dataStartTime) / 2)
    });
    featureData.forEach(feature => {
      resultData.featureData[feature.featureId].push({
        startTime: rest.dataStartTime,
        endTime: rest.dataEndTime,
        plotTime: rest.dataStartTime + Math.floor((rest.dataEndTime - rest.dataStartTime) / 2),
        data: feature.data
      });
    });
  });
  return resultData;
};
exports.anomalyResultMapper = anomalyResultMapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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