var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/atn/EpsilonTransition.ts
var EpsilonTransition_exports = {};
__export(EpsilonTransition_exports, {
  EpsilonTransition: () => EpsilonTransition
});
module.exports = __toCommonJS(EpsilonTransition_exports);

// src/atn/Transition.ts
var Transition = class {
  static {
    __name(this, "Transition");
  }
  static INVALID = 0;
  static EPSILON = 1;
  static RANGE = 2;
  static RULE = 3;
  static PREDICATE = 4;
  // e.g., {isType(input.LT(1))}
  static ATOM = 5;
  static ACTION = 6;
  static SET = 7;
  // ~(A|B) or ~atom, wildcard, which convert to next
  static NOT_SET = 8;
  static WILDCARD = 9;
  static PRECEDENCE = 10;
  /** The target of this transition. */
  target;
  constructor(target) {
    this.target = target;
  }
  /**
   * Determines if the transition is an "epsilon" transition.
   *
   * The default implementation returns `false`.
   *
   * @returns `true` if traversing this transition in the ATN does not
   * consume an input symbol; otherwise, `false` if traversing this
   * transition consumes (matches) an input symbol.
   */
  get isEpsilon() {
    return false;
  }
  get label() {
    return null;
  }
  toString() {
    return "";
  }
};

// src/atn/EpsilonTransition.ts
var EpsilonTransition = class extends Transition {
  static {
    __name(this, "EpsilonTransition");
  }
  #outermostPrecedenceReturn;
  constructor(target, outermostPrecedenceReturn = -1) {
    super(target);
    this.#outermostPrecedenceReturn = outermostPrecedenceReturn;
  }
  /**
   * @returns the rule index of a precedence rule for which this transition is
   * returning from, where the precedence value is 0; otherwise, -1.
   *
   * @see ATNConfig.isPrecedenceFilterSuppressed()
   * @see ParserATNSimulator.applyPrecedenceFilter(ATNConfigSet)
   * @since 4.4.1
   */
  get outermostPrecedenceReturn() {
    return this.#outermostPrecedenceReturn;
  }
  get isEpsilon() {
    return true;
  }
  get transitionType() {
    return Transition.EPSILON;
  }
  matches() {
    return false;
  }
  toString() {
    return "epsilon";
  }
};
