/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.channels;

import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.core.action.ActionListener;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpResponse;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.listener.TraceableActionListener;

public class TraceableHttpChannel
implements HttpChannel {
    private final HttpChannel delegate;
    private final Span span;
    private final Tracer tracer;

    private TraceableHttpChannel(HttpChannel delegate, Span span, Tracer tracer) {
        this.span = Objects.requireNonNull(span);
        this.delegate = Objects.requireNonNull(delegate);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public static HttpChannel create(HttpChannel delegate, Span span, Tracer tracer) {
        if (tracer.isRecording()) {
            return new TraceableHttpChannel(delegate, span, tracer);
        }
        return delegate;
    }

    @Override
    public void handleException(Exception ex) {
        this.span.addEvent("The HttpChannel was closed without sending the response");
        this.span.setError(ex);
        this.span.endSpan();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.delegate.addCloseListener(listener);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        this.delegate.sendResponse(response, TraceableActionListener.create(listener, this.span, this.tracer));
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public <T> Optional<T> get(String name, Class<T> clazz) {
        return this.delegate.get(name, clazz);
    }
}

