/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.Comparator;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.core.index.shard.ShardId;

public final class SearchShard
implements Comparable<SearchShard> {
    @Nullable
    private final String clusterAlias;
    private final ShardId shardId;

    public SearchShard(@Nullable String clusterAlias, ShardId shardId) {
        this.clusterAlias = clusterAlias;
        this.shardId = shardId;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    @Override
    public int compareTo(SearchShard o) {
        int cmp = Objects.compare(this.clusterAlias, o.clusterAlias, Comparator.nullsFirst(Comparator.naturalOrder()));
        return cmp != 0 ? cmp : this.shardId.compareTo(o.shardId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShard that = (SearchShard)o;
        return Objects.equals(this.clusterAlias, that.clusterAlias) && this.shardId.equals((Object)that.shardId);
    }

    public int hashCode() {
        return Objects.hash(this.clusterAlias, this.shardId);
    }

    public String toString() {
        return "SearchShard{clusterAlias='" + this.clusterAlias + "', shardId=" + String.valueOf(this.shardId) + "}";
    }
}

