/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public interface Monitor {
    public CloseableLock getMonitorLock();

    public static CloseableLock newDefaultLock() {
        return CloseableLock.wrap(new ReentrantLock());
    }

    default public CloseableLock acquireCloseableLock() {
        this.acquireLock();
        return this.getMonitorLock();
    }

    default public void acquireLock() {
        this.getMonitorLock().lock.lock();
    }

    default public void releaseLock() {
        this.getMonitorLock().lock.unlock();
    }

    default public boolean isReentrantLock() {
        return true;
    }

    default public void assertLockHeldByCurrentThread() {
        Lock lock = this.getMonitorLock().lock;
        if (this.isReentrantLock() && !1.$assertionsDisabled && !((ReentrantLock)lock).isHeldByCurrentThread()) {
            throw new AssertionError();
        }
    }

    public static Monitor newInstance() {
        class MonitorImpl
        implements Monitor,
        Serializable {
            private static final long serialVersionUID = -2318644678533776943L;
            private final CloseableLock monitorLock = Monitor.newDefaultLock();

            MonitorImpl() {
            }

            @Override
            public CloseableLock getMonitorLock() {
                return this.monitorLock;
            }
        }
        return new MonitorImpl();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class CloseableLock
    implements Lock,
    AutoCloseable,
    Serializable {
        private static final long serialVersionUID = -285233395800863550L;
        private final Lock lock;

        private CloseableLock(Lock lock) {
            this.lock = lock;
        }

        public static CloseableLock wrap(Lock lock) {
            return new CloseableLock(lock);
        }

        @Override
        public void close() {
            this.lock.unlock();
        }

        @Override
        public void lock() {
            this.lock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.lock.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.lock.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }

        @Override
        public Condition newCondition() {
            return this.lock.newCondition();
        }
    }

    public static interface WaitableMonitor
    extends Monitor {
        public Condition getMonitorCondition();

        default public Condition newMonitorCondition() {
            return this.getMonitorLock().lock.newCondition();
        }

        default public void monitorWait() throws InterruptedException {
            this.getMonitorCondition().await();
        }

        default public void monitorWait(long timeoutMillis) throws InterruptedException {
            this.monitorWait(timeoutMillis, 0);
        }

        default public void monitorWait(long timeout, int nanos) throws InterruptedException {
            if (!1.$assertionsDisabled && timeout < 0L) {
                throw new AssertionError((Object)"Negative millisecond timeout");
            }
            if (!1.$assertionsDisabled && nanos < 0) {
                throw new AssertionError((Object)"Negative nanosecond timeout");
            }
            this.getMonitorCondition().awaitNanos(TimeUnit.MILLISECONDS.toNanos(timeout) + (long)nanos);
        }

        default public void monitorNotify() {
            this.getMonitorCondition().signal();
        }

        default public void monitorNotifyAll() {
            this.getMonitorCondition().signalAll();
        }
    }
}

