# -*- coding: binary -*-

module Rex
module Oui

  def self.lookup_oui_fullname(mac)
    check_mac(mac)
    mac = mac.upcase.gsub(':','')[0,6]
    oui = OUI_LIST[mac]
    if oui
      fullname = oui[0]
      fullname = oui[0] + ' / ' + oui[1] if oui[1] != ""
      return fullname
    else
      return 'UNKNOWN'
    end
  end

  def self.lookup_oui_company_name(mac)
    check_mac(mac)
    mac = mac.upcase.gsub(':','')[0,6]
    oui = OUI_LIST[mac]
    if oui
      fullname = oui[0]
      fullname = oui[1] if oui[1] != ""
      return fullname
    else
      return 'UNKNOWN'
    end
  end

  def self.check_mac(mac)
    unless mac =~ /(^([A-Fa-f0-9]{2}:){2,5}[A-Fa-f0-9]{2}$)|(^([A-Fa-f0-9]{2}){3,6}$)/
      raise "Mac address is not in a correct format"
    end
  end
  # List acquired from wireshark manuf file
  OUI_LIST = {
      "000000" => ["Xerox", "XEROX CORPORATION"],
      "000001" => ["Xerox", "XEROX CORPORATION"],
      "000002" => ["Xerox", "XEROX CORPORATION"],
      "000003" => ["Xerox", "XEROX CORPORATION"],
      "000004" => ["Xerox", "XEROX CORPORATION"],
      "000005" => ["Xerox", "XEROX CORPORATION"],
      "000006" => ["Xerox", "XEROX CORPORATION"],
      "000007" => ["Xerox", "XEROX CORPORATION"],
      "000008" => ["Xerox", "XEROX CORPORATION"],
      "000009" => ["Xerox", "XEROX CORPORATION"],
      "00000A" => ["OmronTat", "OMRON TATEISI ELECTRONICS CO."],
      "00000B" => ["Matrix", "MATRIX CORPORATION"],
      "00000C" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00000D" => ["Fibronic", "FIBRONICS LTD."],
      "00000E" => ["Fujitsu", "FUJITSU LIMITED"],
      "00000F" => ["Next", "NEXT, INC."],
      "000010" => ["Hughes",""],
      "000011" => ["Tektrnix",""],
      "000012" => ["Informat", "INFORMATION TECHNOLOGY LIMITED"],
      "000013" => ["Camex",""],
      "000014" => ["Netronix",""],
      "000015" => ["Datapoin", "DATAPOINT CORPORATION"],
      "000016" => ["DuPontPi", "DU PONT PIXEL SYSTEMS."],
      "000017" => ["Tekelec",""],
      "000018" => ["WebsterC", "WEBSTER COMPUTER CORPORATION"],
      "000019" => ["AppliedD", "APPLIED DYNAMICS INTERNATIONAL"],
      "00001A" => ["AMD",""],
      "00001B" => ["Novell", "NOVELL INC."],
      "00001C" => ["BellTech", "BELL TECHNOLOGIES"],
      "00001D" => ["Cabletro", "CABLETRON SYSTEMS, INC."],
      "00001E" => ["TelsistI", "TELSIST INDUSTRIA ELECTRONICA"],
      "00001F" => ["Telco", "Telco Systems, Inc."],
      "000020" => ["DIAB",""],
      "000021" => ["SC&C",""],
      "000022" => ["VisualTe", "VISUAL TECHNOLOGY INC."],
      "000023" => ["AbbIndus", "ABB INDUSTRIAL SYSTEMS AB"],
      "000024" => ["Olicom",""],
      "000025" => ["Ramtek", "RAMTEK CORP."],
      "000026" => ["Sha-Ken", "SHA-KEN CO., LTD."],
      "000027" => ["JapanRad", "JAPAN RADIO COMPANY"],
      "000028" => ["Prodigy", "PRODIGY SYSTEMS CORPORATION"],
      "000029" => ["ImcNetwo", "IMC NETWORKS CORP."],
      "00002A" => ["Trw-Sedd", "TRW - SEDD/INP"],
      "00002B" => ["CrispAut", "CRISP AUTOMATION, INC"],
      "00002C" => ["Autotote", "AUTOTOTE LIMITED"],
      "00002D" => ["Chromati", "CHROMATICS INC"],
      "00002E" => ["SocieteE", "SOCIETE EVIRA"],
      "00002F" => ["Timeplex", "TIMEPLEX INC."],
      "000030" => ["VgLabora", "VG LABORATORY SYSTEMS LTD"],
      "000031" => ["QpsxComm", "QPSX COMMUNICATIONS PTY LTD"],
      "000032" => ["Marconi", "Marconi plc"],
      "000033" => ["EganMach", "EGAN MACHINERY COMPANY"],
      "000034" => ["NetworkR", "NETWORK RESOURCES CORPORATION"],
      "000035" => ["Spectrag", "SPECTRAGRAPHICS CORPORATION"],
      "000036" => ["Atari", "ATARI CORPORATION"],
      "000037" => ["OxfordMe", "OXFORD METRICS LIMITED"],
      "000038" => ["CssLabs", "CSS LABS"],
      "000039" => ["Toshiba", "TOSHIBA CORPORATION"],
      "00003A" => ["Chyron", "CHYRON CORPORATION"],
      "00003B" => ["IControl", "i Controls, Inc."],
      "00003C" => ["Auspex", "AUSPEX SYSTEMS INC."],
      "00003D" => ["AT&T",""],
      "00003E" => ["Simpact",""],
      "00003F" => ["Syntrex", "SYNTREX, INC."],
      "000040" => ["Applicon", "APPLICON, INC."],
      "000041" => ["Ice", "ICE CORPORATION"],
      "000042" => ["MetierMa", "METIER MANAGEMENT SYSTEMS LTD."],
      "000043" => ["MicroTec", "MICRO TECHNOLOGY"],
      "000044" => ["Castelle", "CASTELLE CORPORATION"],
      "000045" => ["FordAero", "FORD AEROSPACE & COMM. CORP."],
      "000046" => ["ISC-BR",""],
      "000047" => ["NicoletI", "NICOLET INSTRUMENTS CORP."],
      "000048" => ["SeikoEps", "SEIKO EPSON CORPORATION"],
      "000049" => ["ApricotC", "APRICOT COMPUTERS, LTD"],
      "00004A" => ["AdcCoden", "ADC CODENOLL TECHNOLOGY CORP."],
      "00004B" => ["APT",""],
      "00004C" => ["Nec", "NEC CORPORATION"],
      "00004D" => ["Dci", "DCI CORPORATION"],
      "00004E" => ["Ampex", "AMPEX CORPORATION"],
      "00004F" => ["Logicraf", "LOGICRAFT, INC."],
      "000050" => ["Radisys", "RADISYS CORPORATION"],
      "000051" => ["HobElect", "HOB ELECTRONIC GMBH & CO. KG"],
      "000052" => ["Intrusio", "Intrusion.com, Inc."],
      "000053" => ["Compucor", "COMPUCORP"],
      "000054" => ["Modicon", "MODICON, INC."],
      "000055" => ["AT&T",""],
      "000056" => ["DrBStruc", "DR. B. STRUCK"],
      "000057" => ["Scitex", "SCITEX CORPORATION LTD."],
      "000058" => ["RacoreCo", "RACORE COMPUTER PRODUCTS INC."],
      "000059" => ["Hellige", "HELLIGE GMBH"],
      "00005A" => ["Syskonne", "SysKonnect GmbH"],
      "00005B" => ["EltecEle", "ELTEC ELEKTRONIK AG"],
      "00005C" => ["Telemati", "TELEMATICS INTERNATIONAL INC."],
      "00005D" => ["CsTeleco", "CS TELECOM"],
      "00005E" => ["UscInfor", "USC INFORMATION SCIENCES INST"],
      "00005F" => ["Sumitomo", "SUMITOMO ELECTRIC IND., LTD."],
      "000060" => ["KontronE", "KONTRON ELEKTRONIK GMBH"],
      "000061" => ["GatewayC", "GATEWAY COMMUNICATIONS"],
      "000062" => ["Hneywell	", "Honeywell"],
      "000063" => ["HP",""],
      "000064" => ["Yokogawa", "YOKOGAWA DIGITAL COMPUTER CORP"],
      "000065" => ["NetworkG", "Network General Corporation"],
      "000066" => ["Talaris", "TALARIS SYSTEMS, INC."],
      "000067" => ["Soft*Rit", "SOFT * RITE, INC."],
      "000068" => ["Rosemoun", "ROSEMOUNT CONTROLS"],
      "000069" => ["SGI",""],
      "00006A" => ["Computer", "COMPUTER CONSOLES INC."],
      "00006B" => ["MIPS",""],
      "00006C" => ["Private",""],
      "00006D" => ["CrayComm", "CRAY COMMUNICATIONS, LTD."],
      "00006E" => ["Artisoft", "ARTISOFT, INC."],
      "00006F" => ["Madge", "Madge Ltd."],
      "000070" => ["Hcl", "HCL LIMITED"],
      "000071" => ["Adra", "ADRA SYSTEMS INC."],
      "000072" => ["Miniware", "MINIWARE TECHNOLOGY"],
      "000073" => ["Siecor", "SIECOR CORPORATION"],
      "000074" => ["Ricoh", "RICOH COMPANY LTD."],
      "000075" => ["NortelNe", "Nortel Networks"],
      "000076" => ["AbekasVi", "ABEKAS VIDEO SYSTEM"],
      "000077" => ["Interpha", "INTERPHASE CORPORATION"],
      "000078" => ["Labtam", "LABTAM LIMITED"],
      "000079" => ["Networth", "NETWORTH INCORPORATED"],
      "00007A" => ["Ardent",""],
      "00007B" => ["Research", "RESEARCH MACHINES"],
      "00007C" => ["Ampere", "AMPERE INCORPORATED"],
      "00007D" => ["Cray",""],
      "00007E" => ["Clustrix", "CLUSTRIX CORPORATION"],
      "00007F" => ["Linotype", "LINOTYPE-HELL AG"],
      "000080" => ["CrayComm", "CRAY COMMUNICATIONS A/S"],
      "000081" => ["BayNetwo", "BAY NETWORKS"],
      "000082" => ["LectraSy", "LECTRA SYSTEMES SA"],
      "000083" => ["TadpoleT", "TADPOLE TECHNOLOGY PLC"],
      "000084" => ["Supernet",""],
      "000085" => ["Canon", "CANON INC."],
      "000086" => ["Megahert", "MEGAHERTZ CORPORATION"],
      "000087" => ["Hitachi", "HITACHI, LTD."],
      "000088" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "000089" => ["Cayman", "CAYMAN SYSTEMS INC."],
      "00008A" => ["Datahous", "DATAHOUSE INFORMATION SYSTEMS"],
      "00008B" => ["Infotron",""],
      "00008C" => ["AlloyCom", "Alloy Computer Products (Australia) Pty Ltd"],
      "00008D" => ["Cryptek", "Cryptek Inc."],
      "00008E" => ["Solbourn", "SOLBOURNE COMPUTER, INC."],
      "00008F" => ["Raytheon",""],
      "000090" => ["Microcom",""],
      "000091" => ["Anritsu", "ANRITSU CORPORATION"],
      "000092" => ["CogentDa", "COGENT DATA TECHNOLOGIES"],
      "000093" => ["Proteon", "PROTEON INC."],
      "000094" => ["AsanteTe", "ASANTE TECHNOLOGIES"],
      "000095" => ["SonyTekt", "SONY TEKTRONIX CORP."],
      "000096" => ["MarconiE", "MARCONI ELECTRONICS LTD."],
      "000097" => ["Emc", "EMC Corporation"],
      "000098" => ["Crosscom", "CROSSCOMM CORPORATION"],
      "000099" => ["Mtx", "MTX, INC."],
      "00009A" => ["RcComput", "RC COMPUTER A/S"],
      "00009B" => ["Informat", "INFORMATION INTERNATIONAL, INC"],
      "00009C" => ["RolmMil-", "ROLM MIL-SPEC COMPUTERS"],
      "00009D" => ["LocusCom", "LOCUS COMPUTING CORPORATION"],
      "00009E" => ["MarliSA", "MARLI S.A."],
      "00009F" => ["Amerista", "AMERISTAR TECHNOLOGIES INC."],
      "0000A0" => ["SanyoEle", "SANYO Electric Co., Ltd."],
      "0000A1" => ["Marquett", "MARQUETTE ELECTRIC CO."],
      "0000A2" => ["BayNetwo", "BAY NETWORKS"],
      "0000A3" => ["NAT",""],
      "0000A4" => ["AcornCom", "ACORN COMPUTERS LIMITED"],
      "0000A5" => ["CSC",""],
      "0000A6" => ["NetworkG", "NETWORK GENERAL CORPORATION"],
      "0000A7" => ["NCD",""],
      "0000A8" => ["StratusC", "STRATUS COMPUTER INC."],
      "0000A9" => ["NetSys		", "Network Systems"],
      "0000AA" => ["Xerox", "XEROX CORPORATION"],
      "0000AB" => ["LogicMod", "LOGIC MODELING CORPORATION"],
      "0000AC" => ["ConwareC", "CONWARE COMPUTER CONSULTING"],
      "0000AD" => ["BrukerIn", "BRUKER INSTRUMENTS INC."],
      "0000AE" => ["Dassault", "DASSAULT ELECTRONIQUE"],
      "0000AF" => ["NuclearD", "NUCLEAR DATA INSTRUMENTATION"],
      "0000B0" => ["Rnd-RadN", "RND-RAD NETWORK DEVICES"],
      "0000B1" => ["AlphaMic", "ALPHA MICROSYSTEMS INC."],
      "0000B2" => ["Televide", "TELEVIDEO SYSTEMS, INC."],
      "0000B3" => ["Cimlinc", "CIMLINC INCORPORATED"],
      "0000B4" => ["EdimaxCo", "EDIMAX COMPUTER COMPANY"],
      "0000B5" => ["Databili", "DATABILITY SOFTWARE SYS. INC."],
      "0000B6" => ["Micro-Ma", "MICRO-MATIC RESEARCH"],
      "0000B7" => ["DoveComp", "DOVE COMPUTER CORPORATION"],
      "0000B8" => ["Seikosha", "SEIKOSHA CO., LTD."],
      "0000B9" => ["Mcdonnel", "MCDONNELL DOUGLAS COMPUTER SYS"],
      "0000BA" => ["Siig", "SIIG, INC."],
      "0000BB" => ["Tri-Data",""],
      "0000BC" => ["Rockwell", "Rockwell Automation"],
      "0000BD" => ["Mitsubis", "MITSUBISHI CABLE COMPANY"],
      "0000BE" => ["NtiGroup", "THE NTI GROUP"],
      "0000BF" => ["Symmetri", "SYMMETRIC COMPUTER SYSTEMS"],
      "0000C0" => ["WesternD", "WESTERN DIGITAL CORPORATION"],
      "0000C1" => ["Madge", "Madge Ltd."],
      "0000C2" => ["Informat", "INFORMATION PRESENTATION TECH."],
      "0000C3" => ["HarrisCo", "HARRIS CORP COMPUTER SYS DIV"],
      "0000C4" => ["WatersDi", "WATERS DIV. OF MILLIPORE"],
      "0000C5" => ["Farallon", "FARALLON COMPUTING/NETOPIA"],
      "0000C6" => ["Eon", "EON SYSTEMS"],
      "0000C7" => ["Arix", "ARIX CORPORATION"],
      "0000C8" => ["AltosCom", "ALTOS COMPUTER SYSTEMS"],
      "0000C9" => ["Emulex", "Emulex Corporation"],
      "0000CA" => ["ArrisInt", "ARRIS International"],
      "0000CB" => ["Compu-Sh", "COMPU-SHACK ELECTRONIC GMBH"],
      "0000CC" => ["Densan", "DENSAN CO., LTD."],
      "0000CD" => ["AlliedTe", "Allied Telesis Labs Ltd"],
      "0000CE" => ["Megadata", "MEGADATA CORP."],
      "0000CF" => ["HayesMic", "HAYES MICROCOMPUTER PRODUCTS"],
      "0000D0" => ["Develcon", "DEVELCON ELECTRONICS LTD."],
      "0000D1" => ["Adaptec", "ADAPTEC INCORPORATED"],
      "0000D2" => ["Sbe", "SBE, INC."],
      "0000D3" => ["WangLabo", "WANG LABORATORIES INC."],
      "0000D4" => ["PureData", "PURE DATA LTD."],
      "0000D5" => ["Microgno", "MICROGNOSIS INTERNATIONAL"],
      "0000D6" => ["PunchLin", "PUNCH LINE HOLDING"],
      "0000D7" => ["Dartmout", "DARTMOUTH COLLEGE"],
      "0000D8" => ["Novell", "NOVELL, INC."],
      "0000D9" => ["NipponTe", "NIPPON TELEGRAPH & TELEPHONE"],
      "0000DA" => ["Atex",""],
      "0000DB" => ["BritishT", "British Telecommunications plc"],
      "0000DC" => ["HayesMic", "HAYES MICROCOMPUTER PRODUCTS"],
      "0000DD" => ["Gould",""],
      "0000DE" => ["Unigraph",""],
      "0000DF" => ["BellHowe", "BELL & HOWELL PUB SYS DIV"],
      "0000E0" => ["Quadram", "QUADRAM CORP."],
      "0000E1" => ["Hitachi",""],
      "0000E2" => ["AcerTech", "ACER TECHNOLOGIES CORP."],
      "0000E3" => ["Integrat", "INTEGRATED MICRO PRODUCTS LTD"],
      "0000E4" => ["In2Group", "IN2 GROUPE INTERTECHNIQUE"],
      "0000E5" => ["Sigmex", "SIGMEX LTD."],
      "0000E6" => ["AptorPro", "APTOR PRODUITS DE COMM INDUST"],
      "0000E7" => ["StarGate", "STAR GATE TECHNOLOGIES"],
      "0000E8" => ["AcctonTe", "ACCTON TECHNOLOGY CORP."],
      "0000E9" => ["Isicad", "ISICAD, INC."],
      "0000EA" => ["Upnod", "UPNOD AB"],
      "0000EB" => ["Matsushi", "MATSUSHITA COMM. IND. CO. LTD."],
      "0000EC" => ["Micropro", "MICROPROCESS"],
      "0000ED" => ["April",""],
      "0000EE" => ["NetworkD", "NETWORK DESIGNERS, LTD."],
      "0000EF" => ["Kti",""],
      "0000F0" => ["SamsungE", "SAMSUNG ELECTRONICS CO., LTD."],
      "0000F1" => ["MagnaCom", "MAGNA COMPUTER CORPORATION"],
      "0000F2" => ["SpiderCo", "SPIDER COMMUNICATIONS"],
      "0000F3" => ["GandalfD", "GANDALF DATA LIMITED"],
      "0000F4" => ["AlliedTe", "Allied Telesis"],
      "0000F5" => ["DiamondS", "DIAMOND SALES LIMITED"],
      "0000F6" => ["Madge",""],
      "0000F7" => ["YouthKee", "YOUTH KEEP ENTERPRISE CO LTD"],
      "0000F8" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "0000F9" => ["Quotron", "QUOTRON SYSTEMS INC."],
      "0000FA" => ["Microsag", "MICROSAGE COMPUTER SYSTEMS INC"],
      "0000FB" => ["RechnerZ", "RECHNER ZUR KOMMUNIKATION"],
      "0000FC" => ["Meiko",""],
      "0000FD" => ["HighLeve", "HIGH LEVEL HARDWARE"],
      "0000FE" => ["Annapoli", "ANNAPOLIS MICRO SYSTEMS"],
      "0000FF" => ["CamtecEl", "CAMTEC ELECTRONICS LTD."],
      "000100" => ["EquipTra", "EQUIP\'TRANS"],
      "000101" => ["Private",""],
      "000102" => ["3com", "3COM CORPORATION"],
      "000103" => ["3com", "3COM CORPORATION"],
      "000104" => ["Dvico", "DVICO Co., Ltd."],
      "000105" => ["Beckhoff", "Beckhoff Automation GmbH"],
      "000106" => ["TewsDate", "Tews Datentechnik GmbH"],
      "000107" => ["Leiser", "Leiser GmbH"],
      "000108" => ["AvlabTec", "AVLAB Technology, Inc."],
      "000109" => ["NaganoJa", "Nagano Japan Radio Co., Ltd."],
      "00010A" => ["CisTechn", "CIS TECHNOLOGY INC."],
      "00010B" => ["SpaceCyb", "Space CyberLink, Inc."],
      "00010C" => ["SystemTa", "System Talks Inc."],
      "00010D" => ["Coreco", "CORECO, INC."],
      "00010E" => ["Bri-Link", "Bri-Link Technologies Co., Ltd"],
      "00010F" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "000110" => ["GothamNe", "Gotham Networks"],
      "000111" => ["Idigm", "iDigm Inc."],
      "000112" => ["SharkMul", "Shark Multimedia Inc."],
      "000113" => ["Olympus", "OLYMPUS CORPORATION"],
      "000114" => ["KandaTsu", "KANDA TSUSHIN KOGYO CO., LTD."],
      "000115" => ["Extratec", "EXTRATECH CORPORATION"],
      "000116" => ["Netspect", "Netspect Technologies, Inc."],
      "000117" => ["Canal+", "CANAL +"],
      "000118" => ["EzDigita", "EZ Digital Co., Ltd."],
      "000119" => ["RtunetAu", "RTUnet (Australia)"],
      "00011A" => ["EehDatal", "EEH DataLink GmbH"],
      "00011B" => ["UnizoneT", "Unizone Technologies, Inc."],
      "00011C" => ["Universa", "Universal Talkware Corporation"],
      "00011D" => ["Centilli", "Centillium Communications"],
      "00011E" => ["Precidia", "Precidia Technologies, Inc."],
      "00011F" => ["RcNetwor", "RC Networks, Inc."],
      "000120" => ["Oscilloq", "OSCILLOQUARTZ S.A."],
      "000121" => ["Watchgua", "Watchguard Technologies, Inc."],
      "000122" => ["TrendCom", "Trend Communications, Ltd."],
      "000123" => ["DigitalE", "DIGITAL ELECTRONICS CORP."],
      "000124" => ["Acer", "Acer Incorporated"],
      "000125" => ["YaesuMus", "YAESU MUSEN CO., LTD."],
      "000126" => ["PacLabs", "PAC Labs"],
      "000127" => ["OpenNetw", "OPEN Networks Pty Ltd"],
      "000128" => ["Enjoyweb", "EnjoyWeb, Inc."],
      "000129" => ["Dfi", "DFI Inc."],
      "00012A" => ["Telemati", "Telematica Sistems Inteligente"],
      "00012B" => ["Telenet", "TELENET Co., Ltd."],
      "00012C" => ["AravoxTe", "Aravox Technologies, Inc."],
      "00012D" => ["KomodoTe", "Komodo Technology"],
      "00012E" => ["PcPartne", "PC Partner Ltd."],
      "00012F" => ["Twinhead", "Twinhead International Corp"],
      "000130" => ["ExtremeN", "Extreme Networks"],
      "000131" => ["BoschSec", "Bosch Security Systems, Inc."],
      "000132" => ["Dranetz-", "Dranetz - BMI"],
      "000133" => ["KyowaEle", "KYOWA Electronic Instruments C"],
      "000134" => ["Selectro", "Selectron Systems AG"],
      "000135" => ["Kdc", "KDC Corp."],
      "000136" => ["Cybertan", "CyberTAN Technology, Inc."],
      "000137" => ["ItFarm", "IT Farm Corporation"],
      "000138" => ["XaviTech", "XAVi Technologies Corp."],
      "000139" => ["PointMul", "Point Multimedia Systems"],
      "00013A" => ["ShelcadC", "SHELCAD COMMUNICATIONS, LTD."],
      "00013B" => ["Bna", "BNA SYSTEMS"],
      "00013C" => ["Tiw", "TIW SYSTEMS"],
      "00013D" => ["Riscstat", "RiscStation Ltd."],
      "00013E" => ["AscomTat", "Ascom Tateco AB"],
      "00013F" => ["Neighbor", "Neighbor World Co., Ltd."],
      "000140" => ["Sendtek", "Sendtek Corporation"],
      "000141" => ["CablePri", "CABLE PRINT"],
      "000142" => ["Cisco", "Cisco Systems, Inc."],
      "000143" => ["Cisco", "Cisco Systems, Inc."],
      "000144" => ["Emc", "EMC Corporation"],
      "000145" => ["Winsyste", "WINSYSTEMS, INC."],
      "000146" => ["TescoCon", "Tesco Controls, Inc."],
      "000147" => ["ZhoneTec", "Zhone Technologies"],
      "000148" => ["X-Traweb", "X-traWeb Inc."],
      "000149" => ["TDTTrans", "T.D.T. Transfer Data Test GmbH"],
      "00014A" => ["Sony", "Sony Corporation"],
      "00014B" => ["Ennovate", "Ennovate Networks, Inc."],
      "00014C" => ["Berkeley", "Berkeley Process Control"],
      "00014D" => ["ShinKinE", "Shin Kin Enterprises Co., Ltd"],
      "00014E" => ["WinEnter", "WIN Enterprises, Inc."],
      "00014F" => ["Adtran", "ADTRAN INC"],
      "000150" => ["GilatCom", "GILAT COMMUNICATIONS, LTD."],
      "000151" => ["Ensemble", "Ensemble Communications"],
      "000152" => ["Chromate", "CHROMATEK INC."],
      "000153" => ["ArchtekT", "ARCHTEK TELECOM CORPORATION"],
      "000154" => ["G3m", "G3M Corporation"],
      "000155" => ["PromiseT", "Promise Technology, Inc."],
      "000156" => ["Firewire", "FIREWIREDIRECT.COM, INC."],
      "000157" => ["Syswave", "SYSWAVE CO., LTD"],
      "000158" => ["ElectroI", "Electro Industries/Gauge Tech"],
      "000159" => ["S1", "S1 Corporation"],
      "00015A" => ["DigitalV", "Digital Video Broadcasting"],
      "00015B" => ["ItaltelS", "ITALTEL S.p.A/RF-UP-I"],
      "00015C" => ["Cadant", "CADANT INC."],
      "00015D" => ["Oracle", "Oracle Corporation"],
      "00015E" => ["BestTech", "BEST TECHNOLOGY CO., LTD."],
      "00015F" => ["DigitalD", "DIGITAL DESIGN GmbH"],
      "000160" => ["Elmex", "ELMEX Co., LTD."],
      "000161" => ["MetaMach", "Meta Machine Technology"],
      "000162" => ["CygnetTe", "Cygnet Technologies, Inc."],
      "000163" => ["Cisco", "Cisco Systems, Inc."],
      "000164" => ["Cisco", "Cisco Systems, Inc."],
      "000165" => ["Airswitc", "AirSwitch Corporation"],
      "000166" => ["TcGroup", "TC GROUP A/S"],
      "000167" => ["HiokiEE", "HIOKI E.E. CORPORATION"],
      "000168" => ["Vitana", "VITANA CORPORATION"],
      "000169" => ["Celestix", "Celestix Networks Pte Ltd."],
      "00016A" => ["Alitec",""],
      "00016B" => ["Lightchi", "LightChip, Inc."],
      "00016C" => ["Foxconn",""],
      "00016D" => ["Carrierc", "CarrierComm Inc."],
      "00016E" => ["Conklin", "Conklin Corporation"],
      "00016F" => ["Inkel", "Inkel Corp."],
      "000170" => ["EseEmbed", "ESE Embedded System Engineer\'g"],
      "000171" => ["AlliedDa", "Allied Data Technologies"],
      "000172" => ["Technola", "TechnoLand Co., LTD."],
      "000173" => ["Amcc",""],
      "000174" => ["Cyberopt", "CyberOptics Corporation"],
      "000175" => ["RadiantC", "Radiant Communications Corp."],
      "000176" => ["OrientSi", "Orient Silver Enterprises"],
      "000177" => ["Edsl",""],
      "000178" => ["Margi", "MARGI Systems, Inc."],
      "000179" => ["Wireless", "WIRELESS TECHNOLOGY, INC."],
      "00017A" => ["ChengduM", "Chengdu Maipu Electric Industrial Co., Ltd."],
      "00017B" => ["Heidelbe", "Heidelberger Druckmaschinen AG"],
      "00017C" => ["Ag-E", "AG-E GmbH"],
      "00017D" => ["Thermoqu", "ThermoQuest"],
      "00017E" => ["AdtekSys", "ADTEK System Science Co., Ltd."],
      "00017F" => ["Experien", "Experience Music Project"],
      "000180" => ["Aopen", "AOpen, Inc."],
      "000181" => ["NortelNe", "Nortel Networks"],
      "000182" => ["DicaTech", "DICA TECHNOLOGIES AG"],
      "000183" => ["AniteTel", "ANITE TELECOMS"],
      "000184" => ["SiebMeye", "SIEB & MEYER AG"],
      "000185" => ["HitachiA", "Hitachi Aloka Medical, Ltd."],
      "000186" => ["UweDisch", "Uwe Disch"],
      "000187" => ["I2se", "i2SE GmbH"],
      "000188" => ["LxcoTech", "LXCO Technologies ag"],
      "000189" => ["Refracti", "Refraction Technology, Inc."],
      "00018A" => ["RoiCompu", "ROI COMPUTER AG"],
      "00018B" => ["Netlinks", "NetLinks Co., Ltd."],
      "00018C" => ["MegaVisi", "Mega Vision"],
      "00018D" => ["AudesiTe", "AudeSi Technologies"],
      "00018E" => ["Logitec", "Logitec Corporation"],
      "00018F" => ["Kenetec", "Kenetec, Inc."],
      "000190" => ["Smk-M",""],
      "000191" => ["SyredDat", "SYRED Data Systems"],
      "000192" => ["TexasDig", "Texas Digital Systems"],
      "000193" => ["HanbyulT", "Hanbyul Telecom Co., Ltd."],
      "000194" => ["CapitalE", "Capital Equipment Corporation"],
      "000195" => ["SenaTech", "Sena Technologies, Inc."],
      "000196" => ["Cisco", "Cisco Systems, Inc."],
      "000197" => ["Cisco", "Cisco Systems, Inc."],
      "000198" => ["DarimVis", "Darim Vision"],
      "000199" => ["HeiseiEl", "HeiSei Electronics"],
      "00019A" => ["Leunig", "LEUNIG GmbH"],
      "00019B" => ["KyotoMic", "Kyoto Microcomputer Co., Ltd."],
      "00019C" => ["JdsUniph", "JDS Uniphase Inc."],
      "00019D" => ["E-Contro", "E-Control Systems, Inc."],
      "00019E" => ["EssTechn", "ESS Technology, Inc."],
      "00019F" => ["Readynet",""],
      "0001A0" => ["Infinili", "Infinilink Corporation"],
      "0001A1" => ["Mag-Tek", "Mag-Tek, Inc."],
      "0001A2" => ["Logical", "Logical Co., Ltd."],
      "0001A3" => ["GenesysL", "GENESYS LOGIC, INC."],
      "0001A4" => ["Microlin", "Microlink Corporation"],
      "0001A5" => ["Nextcomm", "Nextcomm, Inc."],
      "0001A6" => ["Scientif", "Scientific-Atlanta Arcodan A/S"],
      "0001A7" => ["UnexTech", "UNEX TECHNOLOGY CORPORATION"],
      "0001A8" => ["Welltech", "Welltech Computer Co., Ltd."],
      "0001A9" => ["Bmw", "BMW AG"],
      "0001AA" => ["AirspanC", "Airspan Communications, Ltd."],
      "0001AB" => ["MainStre", "Main Street Networks"],
      "0001AC" => ["SitaraNe", "Sitara Networks, Inc."],
      "0001AD" => ["CoachMas", "Coach Master International  d.b.a. CMI Worldwide, Inc."],
      "0001AE" => ["TrexEnte", "Trex Enterprises"],
      "0001AF" => ["EmersonN", "Emerson Network Power"],
      "0001B0" => ["FulltekT", "Fulltek Technology Co., Ltd."],
      "0001B1" => ["GeneralB", "General Bandwidth"],
      "0001B2" => ["DigitalP", "Digital Processing Systems, Inc."],
      "0001B3" => ["Precisio", "Precision Electronic Manufacturing"],
      "0001B4" => ["Wayport", "Wayport, Inc."],
      "0001B5" => ["TurinNet", "Turin Networks, Inc."],
      "0001B6" => ["SaejinT&", "SAEJIN T&M Co., Ltd."],
      "0001B7" => ["Centos", "Centos, Inc."],
      "0001B8" => ["Netsensi", "Netsensity, Inc."],
      "0001B9" => ["SkfCondi", "SKF Condition Monitoring"],
      "0001BA" => ["Ic-Net", "IC-Net, Inc."],
      "0001BB" => ["Frequent", "Frequentis"],
      "0001BC" => ["Brains", "Brains Corporation"],
      "0001BD" => ["Peterson", "Peterson Electro-Musical Products, Inc."],
      "0001BE" => ["Gigalink", "Gigalink Co., Ltd."],
      "0001BF" => ["Teleforc", "Teleforce Co., Ltd."],
      "0001C0" => ["Compulab", "CompuLab, Ltd."],
      "0001C1" => ["VitesseS", "Vitesse Semiconductor Corporation"],
      "0001C2" => ["ArkResea", "ARK Research Corp."],
      "0001C3" => ["Acromag", "Acromag, Inc."],
      "0001C4" => ["Neowave", "NeoWave, Inc."],
      "0001C5" => ["SimplerN", "Simpler Networks"],
      "0001C6" => ["QuarryTe", "Quarry Technologies"],
      "0001C7" => ["Cisco", "Cisco Systems, Inc."],
      "0001C8" => ["ThomasCo", "THOMAS CONRAD CORP."],
      "0001C9" => ["Cisco", "Cisco Systems, Inc."],
      "0001CA" => ["GeocastN", "Geocast Network Systems, Inc."],
      "0001CB" => ["Evr",""],
      "0001CC" => ["JapanTot", "Japan Total Design Communication Co., Ltd."],
      "0001CD" => ["Artem",""],
      "0001CE" => ["CustomMi", "Custom Micro Products, Ltd."],
      "0001CF" => ["AlphaDat", "Alpha Data Parallel Systems, Ltd."],
      "0001D0" => ["Vitalpoi", "VitalPoint, Inc."],
      "0001D1" => ["ConetCom", "CoNet Communications, Inc."],
      "0001D2" => ["Inxtron", "inXtron, Inc."],
      "0001D3" => ["Paxcomm", "PAXCOMM, Inc."],
      "0001D4" => ["LeisureT", "Leisure Time, Inc."],
      "0001D5" => ["HaedongI", "HAEDONG INFO & COMM CO., LTD"],
      "0001D6" => ["Manrolan", "manroland AG"],
      "0001D7" => ["F5Networ", "F5 Networks, Inc."],
      "0001D8" => ["Teltroni", "Teltronics, Inc."],
      "0001D9" => ["Sigma", "Sigma, Inc."],
      "0001DA" => ["Wincomm", "WINCOMM Corporation"],
      "0001DB" => ["FreecomT", "Freecom Technologies GmbH"],
      "0001DC" => ["Activete", "Activetelco"],
      "0001DD" => ["AvailNet", "Avail Networks"],
      "0001DE" => ["Trango", "Trango Systems, Inc."],
      "0001DF" => ["IsdnComm", "ISDN Communications, Ltd."],
      "0001E0" => ["Fast", "Fast Systems, Inc."],
      "0001E1" => ["KinpoEle", "Kinpo Electronics, Inc."],
      "0001E2" => ["AndoElec", "Ando Electric Corporation"],
      "0001E3" => ["Siemens", "Siemens AG"],
      "0001E4" => ["Sitera", "Sitera, Inc."],
      "0001E5" => ["Supernet", "Supernet, Inc."],
      "0001E6" => ["Hewlett-", "Hewlett-Packard Company"],
      "0001E7" => ["Hewlett-", "Hewlett-Packard Company"],
      "0001E8" => ["Force10N", "Force10 Networks, Inc."],
      "0001E9" => ["LittonMa", "Litton Marine Systems B.V."],
      "0001EA" => ["Cirilium", "Cirilium Corp."],
      "0001EB" => ["C-Com", "C-COM Corporation"],
      "0001EC" => ["Ericsson", "Ericsson Group"],
      "0001ED" => ["Seta", "SETA Corp."],
      "0001EE" => ["ComtrolE", "Comtrol Europe, Ltd."],
      "0001EF" => ["CamtelTe", "Camtel Technology Corp."],
      "0001F0" => ["Tridium", "Tridium, Inc."],
      "0001F1" => ["Innovati", "Innovative Concepts, Inc."],
      "0001F2" => ["MarkOfUn", "Mark of the Unicorn, Inc."],
      "0001F3" => ["Qps", "QPS, Inc."],
      "0001F4" => ["Enterasy", "Enterasys Networks"],
      "0001F5" => ["ErimSA", "ERIM S.A."],
      "0001F6" => ["Associat", "Association of Musical Electronics Industry"],
      "0001F7" => ["ImageDis", "Image Display Systems, Inc."],
      "0001F8" => ["Adherent", "Adherent Systems, Ltd."],
      "0001F9" => ["Teraglob", "TeraGlobal Communications Corp."],
      "0001FA" => ["Compaq",""],
      "0001FB" => ["DotopTec", "DoTop Technology, Inc."],
      "0001FC" => ["Keyence", "Keyence Corporation"],
      "0001FD" => ["DigitalV", "Digital Voice Systems, Inc."],
      "0001FE" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "0001FF" => ["DataDire", "Data Direct Networks, Inc."],
      "000200" => ["NetSys", "Net & Sys Co., Ltd."],
      "000201" => ["IfmElect", "IFM Electronic gmbh"],
      "000202" => ["AminoCom", "Amino Communications, Ltd."],
      "000203" => ["Woonsang", "Woonsang Telecom, Inc."],
      "000204" => ["Novell",""],
      "000205" => ["HitachiD", "Hitachi Denshi, Ltd."],
      "000206" => ["TelitalR", "Telital R&D Denmark A/S"],
      "000207" => ["Visiongl", "VisionGlobal Network Corp."],
      "000208" => ["UnifyNet", "Unify Networks, Inc."],
      "000209" => ["Shenzhen", "Shenzhen SED Information Technology Co., Ltd."],
      "00020A" => ["Gefran", "Gefran Spa"],
      "00020B" => ["NativeNe", "Native Networks, Inc."],
      "00020C" => ["Metro-Op", "Metro-Optix"],
      "00020D" => ["Micronpc", "Micronpc.com"],
      "00020E" => ["EciTelec", "ECI Telecom, Ltd., NSD-US"],
      "00020F" => ["Aatr",""],
      "000210" => ["Fenecom",""],
      "000211" => ["NatureWo", "Nature Worldwide Technology Corp."],
      "000212" => ["Sierraco", "SierraCom"],
      "000213" => ["SDEL", "S.D.E.L."],
      "000214" => ["Dtvro",""],
      "000215" => ["CotasCom", "Cotas Computer Technology A/B"],
      "000216" => ["Cisco", "Cisco Systems, Inc."],
      "000217" => ["Cisco", "Cisco Systems, Inc."],
      "000218" => ["Advanced", "Advanced Scientific Corp"],
      "000219" => ["ParalonT", "Paralon Technologies"],
      "00021A" => ["ZumaNetw", "Zuma Networks"],
      "00021B" => ["Kollmorg", "Kollmorgen-Servotronix"],
      "00021C" => ["NetworkE", "Network Elements, Inc."],
      "00021D" => ["DataGene", "Data General Communication Ltd."],
      "00021E" => ["SimtelSR", "SIMTEL S.R.L."],
      "00021F" => ["Aculab", "Aculab PLC"],
      "000220" => ["CanonFin", "CANON FINETECH INC."],
      "000221" => ["DspAppli", "DSP Application, Ltd."],
      "000222" => ["Chromisy", "Chromisys, Inc."],
      "000223" => ["Clicktv",""],
      "000224" => ["C-Cor",""],
      "000225" => ["OneStop", "One Stop Systems"],
      "000226" => ["Xesystem", "XESystems, Inc."],
      "000227" => ["EsdElect", "ESD Electronic System Design GmbH"],
      "000228" => ["Necsom", "Necsom, Ltd."],
      "000229" => ["Adtec", "Adtec Corporation"],
      "00022A" => ["AsoundEl", "Asound Electronic"],
      "00022B" => ["Saxa", "SAXA, Inc."],
      "00022C" => ["AbbBomem", "ABB Bomem, Inc."],
      "00022D" => ["Agere", "Agere Systems"],
      "00022E" => ["TeacR&D", "TEAC Corp. R& D"],
      "00022F" => ["P-Cube", "P-Cube, Ltd."],
      "000230" => ["Intersof", "Intersoft Electronics"],
      "000231" => ["Axis",""],
      "000232" => ["Avision", "Avision, Inc."],
      "000233" => ["MantraCo", "Mantra Communications, Inc."],
      "000234" => ["Imperial", "Imperial Technology, Inc."],
      "000235" => ["ParagonN", "Paragon Networks International"],
      "000236" => ["Init", "INIT GmbH"],
      "000237" => ["CosmoRes", "Cosmo Research Corp."],
      "000238" => ["SeromeTe", "Serome Technology, Inc."],
      "000239" => ["Visicom",""],
      "00023A" => ["ZskStick", "ZSK Stickmaschinen GmbH"],
      "00023B" => ["Ericsson",""],
      "00023C" => ["Creative", "Creative Technology, Ltd."],
      "00023D" => ["Cisco", "Cisco Systems, Inc."],
      "00023E" => ["SeltaTel", "Selta Telematica S.p.a"],
      "00023F" => ["CompalEl", "Compal Electronics, Inc."],
      "000240" => ["Seedek", "Seedek Co., Ltd."],
      "000241" => ["AmerCom", "Amer.com"],
      "000242" => ["Videofra", "Videoframe Systems"],
      "000243" => ["Raysis", "Raysis Co., Ltd."],
      "000244" => ["SurecomT", "SURECOM Technology Co."],
      "000245" => ["Lampus", "Lampus Co, Ltd."],
      "000246" => ["All-WinT", "All-Win Tech Co., Ltd."],
      "000247" => ["GreatDra", "Great Dragon Information Technology (Group) Co., Ltd."],
      "000248" => ["Pilz", "Pilz GmbH & Co."],
      "000249" => ["AvivInfo", "Aviv Infocom Co, Ltd."],
      "00024A" => ["Cisco", "Cisco Systems, Inc."],
      "00024B" => ["Cisco", "Cisco Systems, Inc."],
      "00024C" => ["Sibyte", "SiByte, Inc."],
      "00024D" => ["Mannesma", "Mannesman Dematic Colby Pty. Ltd."],
      "00024E" => ["Datacard", "Datacard Group"],
      "00024F" => ["IpmDatac", "IPM Datacom S.R.L."],
      "000250" => ["GeyserNe", "Geyser Networks, Inc."],
      "000251" => ["SomaNetw", "Soma Networks, Inc."],
      "000252" => ["Carrier", "Carrier Corporation"],
      "000253" => ["Televide", "Televideo, Inc."],
      "000254" => ["Worldgat", "WorldGate"],
      "000255" => ["Ibm", "IBM Corp"],
      "000256" => ["AlphaPro", "Alpha Processor, Inc."],
      "000257" => ["Microcom", "Microcom Corp."],
      "000258" => ["FlyingPa", "Flying Packets Communications"],
      "000259" => ["TsannKue", "Tsann Kuen China (Shanghai)Enterprise Co., Ltd. IT Group"],
      "00025A" => ["CatenaNe", "Catena Networks"],
      "00025B" => ["Cambridg", "Cambridge Silicon Radio"],
      "00025C" => ["SciKunsh", "SCI Systems (Kunshan) Co., Ltd."],
      "00025D" => ["CalixNet", "Calix Networks"],
      "00025E" => ["HighTech", "High Technology Ltd"],
      "00025F" => ["NortelNe", "Nortel Networks"],
      "000260" => ["Accordio", "Accordion Networks, Inc."],
      "000261" => ["Tilgin", "Tilgin AB"],
      "000262" => ["SoyoGrou", "Soyo Group Soyo Com Tech Co., Ltd"],
      "000263" => ["UpsManuf", "UPS Manufacturing SRL"],
      "000264" => ["Audioram", "AudioRamp.com"],
      "000265" => ["Virditec", "Virditech Co. Ltd."],
      "000266" => ["Thermalo", "Thermalogic Corporation"],
      "000267" => ["NodeRunn", "NODE RUNNER, INC."],
      "000268" => ["HarrisGo", "Harris Government Communications"],
      "000269" => ["Nadatel", "Nadatel Co., Ltd"],
      "00026A" => ["CocessTe", "Cocess Telecom Co., Ltd."],
      "00026B" => ["BcmCompu", "BCM Computers Co., Ltd."],
      "00026C" => ["PhilipsC", "Philips CFT"],
      "00026D" => ["AdeptTel", "Adept Telecom"],
      "00026E" => ["NegenAcc", "NeGeN Access, Inc."],
      "00026F" => ["SenaoInt", "Senao International Co., Ltd."],
      "000270" => ["Crewave", "Crewave Co., Ltd."],
      "000271" => ["ZhoneTec", "Zhone Technologies"],
      "000272" => ["Cc&CTech", "CC&C Technologies, Inc."],
      "000273" => ["Coriolis", "Coriolis Networks"],
      "000274" => ["TommyTec", "Tommy Technologies Corp."],
      "000275" => ["SmartTec", "SMART Technologies, Inc."],
      "000276" => ["PrimaxEl", "Primax Electronics Ltd."],
      "000277" => ["CashSyst", "Cash Systemes Industrie"],
      "000278" => ["SamsungE", "Samsung Electro-Mechanics Co., Ltd."],
      "000279" => ["ControlA", "Control Applications, Ltd."],
      "00027A" => ["IoiTechn", "IOI Technology Corporation"],
      "00027B" => ["AmplifyN", "Amplify Net, Inc."],
      "00027C" => ["Trilithi", "Trilithic, Inc."],
      "00027D" => ["Cisco", "Cisco Systems, Inc."],
      "00027E" => ["Cisco", "Cisco Systems, Inc."],
      "00027F" => ["Ask-Tech", "ask-technologies.com"],
      "000280" => ["MuNet", "Mu Net, Inc."],
      "000281" => ["Madge", "Madge Ltd."],
      "000282" => ["Viaclix", "ViaClix, Inc."],
      "000283" => ["Spectrum", "Spectrum Controls, Inc."],
      "000284" => ["ArevaT&D", "AREVA T&D"],
      "000285" => ["Riversto", "Riverstone Networks"],
      "000286" => ["OccamNet", "Occam Networks"],
      "000287" => ["Adapcom",""],
      "000288" => ["GlobalVi", "GLOBAL VILLAGE COMMUNICATION"],
      "000289" => ["DneTechn", "DNE Technologies"],
      "00028A" => ["AmbitMic", "Ambit Microsystems Corporation"],
      "00028B" => ["VdslOy", "VDSL Systems OY"],
      "00028C" => ["Micrel-S", "Micrel-Synergy Semiconductor"],
      "00028D" => ["MovitaTe", "Movita Technologies, Inc."],
      "00028E" => ["Rapid5Ne", "Rapid 5 Networks, Inc."],
      "00028F" => ["Globetek", "Globetek, Inc."],
      "000290" => ["Woorigis", "Woorigisool, Inc."],
      "000291" => ["OpenNetw", "Open Network Co., Ltd."],
      "000292" => ["LogicInn", "Logic Innovations, Inc."],
      "000293" => ["SolidDat", "Solid Data Systems"],
      "000294" => ["TokyoSok", "Tokyo Sokushin Co., Ltd."],
      "000295" => ["IpAccess", "IP.Access Limited"],
      "000296" => ["Lectron", "Lectron Co,. Ltd."],
      "000297" => ["C-CorNet", "C-COR.net"],
      "000298" => ["Broadfra", "Broadframe Corporation"],
      "000299" => ["Apex", "Apex, Inc."],
      "00029A" => ["StorageA", "Storage Apps"],
      "00029B" => ["KreatelC", "Kreatel Communications AB"],
      "00029C" => ["3com",""],
      "00029D" => ["Merix", "Merix Corp."],
      "00029E" => ["Informat", "Information Equipment Co., Ltd."],
      "00029F" => ["L-3Commu", "L-3 Communication Aviation Recorders"],
      "0002A0" => ["Flatstac", "Flatstack Ltd."],
      "0002A1" => ["WorldWid", "World Wide Packets"],
      "0002A2" => ["Hilscher", "Hilscher GmbH"],
      "0002A3" => ["AbbSwitz", "ABB Switzerland Ltd, Power Systems"],
      "0002A4" => ["AddpacTe", "AddPac Technology Co., Ltd."],
      "0002A5" => ["Hewlett-", "Hewlett-Packard Company"],
      "0002A6" => ["Effinet", "Effinet Systems Co., Ltd."],
      "0002A7" => ["VivaceNe", "Vivace Networks"],
      "0002A8" => ["AirLinkT", "Air Link Technology"],
      "0002A9" => ["RacomSRO", "RACOM, s.r.o."],
      "0002AA" => ["Plcom", "PLcom Co., Ltd."],
      "0002AB" => ["CtcUnion", "CTC Union Technologies Co., Ltd."],
      "0002AC" => ["3parData", "3PAR data"],
      "0002AD" => ["Hoya", "HOYA Corporation"],
      "0002AE" => ["ScannexE", "Scannex Electronics Ltd."],
      "0002AF" => ["Telecruz", "TeleCruz Technology, Inc."],
      "0002B0" => ["HokubuCo", "Hokubu Communication & Industrial Co., Ltd."],
      "0002B1" => ["Anritsu", "Anritsu, Ltd."],
      "0002B2" => ["Cablevis", "Cablevision"],
      "0002B3" => ["Intel", "Intel Corporation"],
      "0002B4" => ["Daphne",""],
      "0002B5" => ["Avnet", "Avnet, Inc."],
      "0002B6" => ["Acrosser", "Acrosser Technology Co., Ltd."],
      "0002B7" => ["Watanabe", "Watanabe Electric Industry Co., Ltd."],
      "0002B8" => ["WhiKonsu", "WHI KONSULT AB"],
      "0002B9" => ["Cisco", "Cisco Systems, Inc."],
      "0002BA" => ["Cisco", "Cisco Systems, Inc."],
      "0002BB" => ["Continuo", "Continuous Computing Corp"],
      "0002BC" => ["Lvl7", "LVL 7 Systems, Inc."],
      "0002BD" => ["Bionet", "Bionet Co., Ltd."],
      "0002BE" => ["TotsuEng", "Totsu Engineering, Inc."],
      "0002BF" => ["Dotrocke", "dotRocket, Inc."],
      "0002C0" => ["BencentT", "Bencent Tzeng Industry Co., Ltd."],
      "0002C1" => ["Innovati", "Innovative Electronic Designs, Inc."],
      "0002C2" => ["NetVisio", "Net Vision Telecom"],
      "0002C3" => ["Arelnet", "Arelnet Ltd."],
      "0002C4" => ["VectorIn", "Vector International BVBA"],
      "0002C5" => ["EvertzMi", "Evertz Microsystems Ltd."],
      "0002C6" => ["DataTrac", "Data Track Technology PLC"],
      "0002C7" => ["AlpsElec", "ALPS ELECTRIC Co., Ltd."],
      "0002C8" => ["Technoco", "Technocom Communications Technology (pte) Ltd"],
      "0002C9" => ["Mellanox", "Mellanox Technologies"],
      "0002CA" => ["Endpoint", "EndPoints, Inc."],
      "0002CB" => ["Tristate", "TriState Ltd."],
      "0002CC" => ["MCCI", "M.C.C.I"],
      "0002CD" => ["Teledrea", "TeleDream, Inc."],
      "0002CE" => ["Foxjet", "FoxJet, Inc."],
      "0002CF" => ["ZygateCo", "ZyGate Communications, Inc."],
      "0002D0" => ["Comdial", "Comdial Corporation"],
      "0002D1" => ["Vivotek", "Vivotek, Inc."],
      "0002D2" => ["Workstat", "Workstation AG"],
      "0002D3" => ["Netbotz", "NetBotz, Inc."],
      "0002D4" => ["PdaPerip", "PDA Peripherals, Inc."],
      "0002D5" => ["Acr",""],
      "0002D6" => ["Nice", "NICE Systems"],
      "0002D7" => ["Empeg", "EMPEG Ltd"],
      "0002D8" => ["BrecisCo", "BRECIS Communications Corporation"],
      "0002D9" => ["Reliable", "Reliable Controls"],
      "0002DA" => ["ExioComm", "ExiO Communications, Inc."],
      "0002DB" => ["Netsec",""],
      "0002DC" => ["FujitsuG", "Fujitsu General Limited"],
      "0002DD" => ["BromaxCo", "Bromax Communications, Ltd."],
      "0002DE" => ["Astrodes", "Astrodesign, Inc."],
      "0002DF" => ["NetCom", "Net Com Systems, Inc."],
      "0002E0" => ["Etas", "ETAS GmbH"],
      "0002E1" => ["Integrat", "Integrated Network Corporation"],
      "0002E2" => ["NdcInfar", "NDC Infared Engineering"],
      "0002E3" => ["Lite-OnC", "LITE-ON Communications, Inc."],
      "0002E4" => ["JcHyun", "JC HYUN Systems, Inc."],
      "0002E5" => ["Timeware", "Timeware Ltd."],
      "0002E6" => ["GouldIns", "Gould Instrument Systems, Inc."],
      "0002E7" => ["Cab", "CAB GmbH & Co KG"],
      "0002E8" => ["ED&A", "E.D.&A."],
      "0002E9" => ["CsSystem", "CS Systemes De Securite - C3S"],
      "0002EA" => ["FocusEnh", "Focus Enhancements"],
      "0002EB" => ["PicoComm", "Pico Communications"],
      "0002EC" => ["Maschoff", "Maschoff Design Engineering"],
      "0002ED" => ["DxoTelec", "DXO Telecom Co., Ltd."],
      "0002EE" => ["NokiaDan", "Nokia Danmark A/S"],
      "0002EF" => ["CccNetwo", "CCC Network Systems Group Ltd."],
      "0002F0" => ["AmeOptim", "AME Optimedia Technology Co., Ltd."],
      "0002F1" => ["Pinetron", "Pinetron Co., Ltd."],
      "0002F2" => ["Edevice", "eDevice, Inc."],
      "0002F3" => ["MediaSer", "Media Serve Co., Ltd."],
      "0002F4" => ["Pctel", "PCTEL, Inc."],
      "0002F5" => ["ViveSyne", "VIVE Synergies, Inc."],
      "0002F6" => ["EquipeCo", "Equipe Communications"],
      "0002F7" => ["Arm",""],
      "0002F8" => ["SeakrEng", "SEAKR Engineering, Inc."],
      "0002F9" => ["MimosSem", "Mimos Semiconductor SDN BHD"],
      "0002FA" => ["DxAntenn", "DX Antenna Co., Ltd."],
      "0002FB" => ["Baumulle", "Baumuller Aulugen-Systemtechnik GmbH"],
      "0002FC" => ["Cisco", "Cisco Systems, Inc."],
      "0002FD" => ["Cisco", "Cisco Systems, Inc."],
      "0002FE" => ["Viditec", "Viditec, Inc."],
      "0002FF" => ["HandanBr", "Handan BroadInfoCom"],
      "000300" => ["Barracud", "Barracuda Networks, Inc."],
      "000301" => ["AvantasN", "Avantas Networks Corporation"],
      "000302" => ["CharlesI", "Charles Industries, Ltd."],
      "000303" => ["JamaElec", "JAMA Electronics Co., Ltd."],
      "000304" => ["PacificB", "Pacific Broadband Communications"],
      "000305" => ["MscVertr", "MSC Vertriebs GmbH"],
      "000306" => ["FusionIn", "Fusion In Tech Co., Ltd."],
      "000307" => ["SecureWo", "Secure Works, Inc."],
      "000308" => ["AmCommun", "AM Communications, Inc."],
      "000309" => ["TexcelTe", "Texcel Technology PLC"],
      "00030A" => ["ArgusTec", "Argus Technologies"],
      "00030B" => ["HunterTe", "Hunter Technology, Inc."],
      "00030C" => ["Telesoft", "Telesoft Technologies Ltd."],
      "00030D" => ["UniwillC", "Uniwill Computer Corp."],
      "00030E" => ["CoreComm", "Core Communications Co., Ltd."],
      "00030F" => ["DigitalC", "Digital China (Shanghai) Networks Ltd."],
      "000310" => ["ItxE-Glo", "ITX E-Globaledge Corporation"],
      "000311" => ["MicroTec", "Micro Technology Co., Ltd."],
      "000312" => ["Tr-Syste", "TR-Systemtechnik GmbH"],
      "000313" => ["AccessMe", "Access Media SPA"],
      "000314" => ["Teleware", "Teleware Network Systems"],
      "000315" => ["Cidco", "Cidco Incorporated"],
      "000316" => ["NobellCo", "Nobell Communications, Inc."],
      "000317" => ["Merlin", "Merlin Systems, Inc."],
      "000318" => ["Cyras", "Cyras Systems, Inc."],
      "000319" => ["Infineon", "Infineon AG"],
      "00031A" => ["BeijingB", "Beijing Broad Telecom Ltd., China"],
      "00031B" => ["Cellvisi", "Cellvision Systems, Inc."],
      "00031C" => ["SvenskaH", "Svenska Hardvarufabriken AB"],
      "00031D" => ["TaiwanCo", "Taiwan Commate Computer, Inc."],
      "00031E" => ["Optranet", "Optranet, Inc."],
      "00031F" => ["Condev", "Condev Ltd."],
      "000320" => ["Xpeed", "Xpeed, Inc."],
      "000321" => ["RecoRese", "Reco Research Co., Ltd."],
      "000322" => ["Idis", "IDIS Co., Ltd."],
      "000323" => ["CornetTe", "Cornet Technology, Inc."],
      "000324" => ["SanyoCon", "SANYO Consumer Electronics Co., Ltd."],
      "000325" => ["ArimaCom", "Arima Computer Corp."],
      "000326" => ["IwasakiI", "Iwasaki Information Systems Co., Ltd."],
      "000327" => ["ActL", "ACT\'L"],
      "000328" => ["MaceGrou", "Mace Group, Inc."],
      "000329" => ["F3", "F3, Inc."],
      "00032A" => ["UnidataC", "UniData Communication Systems, Inc."],
      "00032B" => ["GaiDaten", "GAI Datenfunksysteme GmbH"],
      "00032C" => ["AbbSwitz", "ABB Switzerland Ltd"],
      "00032D" => ["IbaseTec", "IBASE Technology, Inc."],
      "00032E" => ["ScopeInf", "Scope Information Management, Ltd."],
      "00032F" => ["GlobalSu", "Global Sun Technology, Inc."],
      "000330" => ["Imagenic", "Imagenics, Co., Ltd."],
      "000331" => ["Cisco", "Cisco Systems, Inc."],
      "000332" => ["Cisco", "Cisco Systems, Inc."],
      "000333" => ["Digitel", "Digitel Co., Ltd."],
      "000334" => ["NewportE", "Newport Electronics"],
      "000335" => ["MiraeTec", "Mirae Technology"],
      "000336" => ["ZetesTec", "Zetes Technologies"],
      "000337" => ["Vaone", "Vaone, Inc."],
      "000338" => ["OakTechn", "Oak Technology"],
      "000339" => ["Eurologi", "Eurologic Systems, Ltd."],
      "00033A" => ["SiliconW", "Silicon Wave, Inc."],
      "00033B" => ["TamiTech", "TAMI Tech Co., Ltd."],
      "00033C" => ["Daiden", "Daiden Co., Ltd."],
      "00033D" => ["IlshinLa", "ILSHin Lab"],
      "00033E" => ["Tateyama", "Tateyama System Laboratory Co., Ltd."],
      "00033F" => ["BigbandN", "BigBand Networks, Ltd."],
      "000340" => ["FlowareW", "Floware Wireless Systems, Ltd."],
      "000341" => ["AxonDigi", "Axon Digital Design"],
      "000342" => ["NortelNe", "Nortel Networks"],
      "000343" => ["MartinPr", "Martin Professional A/S"],
      "000344" => ["Tietech", "Tietech.Co., Ltd."],
      "000345" => ["RoutrekN", "Routrek Networks Corporation"],
      "000346" => ["HitachiK", "Hitachi Kokusai Electric, Inc."],
      "000347" => ["Intel", "Intel Corporation"],
      "000348" => ["NorscanI", "Norscan Instruments, Ltd."],
      "000349" => ["Vidicode", "Vidicode Datacommunicatie B.V."],
      "00034A" => ["Rias", "RIAS Corporation"],
      "00034B" => ["NortelNe", "Nortel Networks"],
      "00034C" => ["Shanghai", "Shanghai DigiVision Technology Co., Ltd."],
      "00034D" => ["ChiaroNe", "Chiaro Networks, Ltd."],
      "00034E" => ["PosData", "Pos Data Company, Ltd."],
      "00034F" => ["Sur-Gard", "Sur-Gard Security"],
      "000350" => ["Bticino", "BTICINO SPA"],
      "000351" => ["Diebold", "Diebold, Inc."],
      "000352" => ["Colubris", "Colubris Networks"],
      "000353" => ["Mitac", "Mitac, Inc."],
      "000354" => ["FiberLog", "Fiber Logic Communications"],
      "000355" => ["Terabeam", "TeraBeam Internet Systems"],
      "000356" => ["WincorNi", "Wincor Nixdorf International GmbH"],
      "000357" => ["Intervoi", "Intervoice-Brite, Inc."],
      "000358" => ["HanyangD", "Hanyang Digitech Co., Ltd."],
      "000359" => ["Digitals", "DigitalSis"],
      "00035A" => ["Photron", "Photron Limited"],
      "00035B" => ["Bridgewa", "BridgeWave Communications"],
      "00035C" => ["SaintSon", "Saint Song Corp."],
      "00035D" => ["BosungHi", "Bosung Hi-Net Co., Ltd."],
      "00035E" => ["Metropol", "Metropolitan Area Networks, Inc."],
      "00035F" => ["Prueftec", "Prueftechnik Condition Monitoring GmbH & Co. KG"],
      "000360" => ["PacInter", "PAC Interactive Technology, Inc."],
      "000361" => ["Widcomm", "Widcomm, Inc."],
      "000362" => ["VodtelCo", "Vodtel Communications, Inc."],
      "000363" => ["Miraesys", "Miraesys Co., Ltd."],
      "000364" => ["ScenixSe", "Scenix Semiconductor, Inc."],
      "000365" => ["KiraInfo", "Kira Information & Communications, Ltd."],
      "000366" => ["AsmPacif", "ASM Pacific Technology"],
      "000367" => ["JasmineN", "Jasmine Networks, Inc."],
      "000368" => ["Embedone", "Embedone Co., Ltd."],
      "000369" => ["NipponAn", "Nippon Antenna Co., Ltd."],
      "00036A" => ["Mainnet", "Mainnet, Ltd."],
      "00036B" => ["Cisco", "Cisco Systems, Inc."],
      "00036C" => ["Cisco", "Cisco Systems, Inc."],
      "00036D" => ["Runtop", "Runtop, Inc."],
      "00036E" => ["NiconPty", "Nicon Systems (Pty) Limited"],
      "00036F" => ["Telsey", "Telsey SPA"],
      "000370" => ["Nxtv", "NXTV, Inc."],
      "000371" => ["AcomzNet", "Acomz Networks Corp."],
      "000372" => ["Ulan",""],
      "000373" => ["AselsanA", "Aselsan A.S"],
      "000374" => ["ControlM", "Control Microsystems"],
      "000375" => ["Netmedia", "NetMedia, Inc."],
      "000376" => ["Graphtec", "Graphtec Technology, Inc."],
      "000377" => ["GigabitW", "Gigabit Wireless"],
      "000378" => ["Humax", "HUMAX Co., Ltd."],
      "000379" => ["Proscend", "Proscend Communications, Inc."],
      "00037A" => ["TaiyoYud", "Taiyo Yuden Co., Ltd."],
      "00037B" => ["IdecIzum", "IDEC IZUMI Corporation"],
      "00037C" => ["CoaxMedi", "Coax Media"],
      "00037D" => ["Stellcom",""],
      "00037E" => ["PortechC", "PORTech Communications, Inc."],
      "00037F" => ["AtherosC", "Atheros Communications, Inc."],
      "000380" => ["SshCommu", "SSH Communications Security Corp."],
      "000381" => ["Ingenico", "Ingenico International"],
      "000382" => ["A-One", "A-One Co., Ltd."],
      "000383" => ["MeteraNe", "Metera Networks, Inc."],
      "000384" => ["Aeta",""],
      "000385" => ["ActelisN", "Actelis Networks, Inc."],
      "000386" => ["HoNet", "Ho Net, Inc."],
      "000387" => ["BlazeNet", "Blaze Network Products"],
      "000388" => ["Fastfame", "Fastfame Technology Co., Ltd."],
      "000389" => ["Plantron", "Plantronics"],
      "00038A" => ["AmericaO", "America Online, Inc."],
      "00038B" => ["Plus-One", "PLUS-ONE I&T, Inc."],
      "00038C" => ["TotalImp", "Total Impact"],
      "00038D" => ["PcsReven", "PCS Revenue Control Systems, Inc."],
      "00038E" => ["Atoga", "Atoga Systems, Inc."],
      "00038F" => ["Weinsche", "Weinschel Corporation"],
      "000390" => ["DigitalV", "Digital Video Communications, Inc."],
      "000391" => ["Advanced", "Advanced Digital Broadcast, Ltd."],
      "000392" => ["HyundaiT", "Hyundai Teletek Co., Ltd."],
      "000393" => ["AppleCom", "Apple Computer, Inc."],
      "000394" => ["ConnectO", "Connect One"],
      "000395" => ["Californ", "California Amplifier"],
      "000396" => ["EzCast", "EZ Cast Co., Ltd."],
      "000397" => ["Watchfro", "Watchfront Limited"],
      "000398" => ["Wisi",""],
      "000399" => ["DongjuIn", "Dongju Informations & Communications Co., Ltd."],
      "00039A" => ["Siconnec", "SiConnect"],
      "00039B" => ["NetchipT", "NetChip Technology, Inc."],
      "00039C" => ["Optimigh", "OptiMight Communications, Inc."],
      "00039D" => ["Qisda", "Qisda Corporation"],
      "00039E" => ["TeraSyst", "Tera System Co., Ltd."],
      "00039F" => ["Cisco", "Cisco Systems, Inc."],
      "0003A0" => ["Cisco", "Cisco Systems, Inc."],
      "0003A1" => ["HiperInf", "HIPER Information & Communication, Inc."],
      "0003A2" => ["Catapult", "Catapult Communications"],
      "0003A3" => ["Mavix", "MAVIX, Ltd."],
      "0003A4" => ["Imation", "Imation Corp."],
      "0003A5" => ["Medea", "Medea Corporation"],
      "0003A6" => ["TraxitTe", "Traxit Technology, Inc."],
      "0003A7" => ["UnixtarT", "Unixtar Technology, Inc."],
      "0003A8" => ["IdotComp", "IDOT Computers, Inc."],
      "0003A9" => ["AxcentMe", "AXCENT Media AG"],
      "0003AA" => ["Watlow",""],
      "0003AB" => ["BridgeIn", "Bridge Information Systems"],
      "0003AC" => ["FroniusS", "Fronius Schweissmaschinen"],
      "0003AD" => ["EmersonE", "Emerson Energy Systems AB"],
      "0003AE" => ["AlliedAd", "Allied Advanced Manufacturing Pte, Ltd."],
      "0003AF" => ["ParageaC", "Paragea Communications"],
      "0003B0" => ["XsenseTe", "Xsense Technology Corp."],
      "0003B1" => ["Hospira", "Hospira Inc."],
      "0003B2" => ["Radware",""],
      "0003B3" => ["IaLink", "IA Link Systems Co., Ltd."],
      "0003B4" => ["Macrotek", "Macrotek International Corp."],
      "0003B5" => ["EntraTec", "Entra Technology Co."],
      "0003B6" => ["Qsi", "QSI Corporation"],
      "0003B7" => ["Zaccess", "ZACCESS Systems"],
      "0003B8" => ["NetkitSo", "NetKit Solutions, LLC"],
      "0003B9" => ["HualongT", "Hualong Telecom Co., Ltd."],
      "0003BA" => ["Oracle", "Oracle Corporation"],
      "0003BB" => ["SignalCo", "Signal Communications Limited"],
      "0003BC" => ["Cot", "COT GmbH"],
      "0003BD" => ["Omniclus", "OmniCluster Technologies, Inc."],
      "0003BE" => ["Netility",""],
      "0003BF" => ["Centerpo", "Centerpoint Broadband Technologies, Inc."],
      "0003C0" => ["Rftnc", "RFTNC Co., Ltd."],
      "0003C1" => ["PacketDy", "Packet Dynamics Ltd"],
      "0003C2" => ["Solphone", "Solphone K.K."],
      "0003C3" => ["Micronik", "Micronik Multimedia"],
      "0003C4" => ["TomraAsa", "Tomra Systems ASA"],
      "0003C5" => ["Mobotix", "Mobotix AG"],
      "0003C6" => ["Icue", "ICUE Systems, Inc."],
      "0003C7" => ["HopfElek", "hopf Elektronik GmbH"],
      "0003C8" => ["CmlEmerg", "CML Emergency Services"],
      "0003C9" => ["Tecom", "TECOM Co., Ltd."],
      "0003CA" => ["Mts", "MTS Systems Corp."],
      "0003CB" => ["NipponDe", "Nippon Systems Development Co., Ltd."],
      "0003CC" => ["Momentum", "Momentum Computer, Inc."],
      "0003CD" => ["Cloverte", "Clovertech, Inc."],
      "0003CE" => ["EtenTech", "ETEN Technologies, Inc."],
      "0003CF" => ["Muxcom", "Muxcom, Inc."],
      "0003D0" => ["Koankeis", "KOANKEISO Co., Ltd."],
      "0003D1" => ["Takaya", "Takaya Corporation"],
      "0003D2" => ["Crossbea", "Crossbeam Systems, Inc."],
      "0003D3" => ["Internet", "Internet Energy Systems, Inc."],
      "0003D4" => ["Alloptic", "Alloptic, Inc."],
      "0003D5" => ["Advanced", "Advanced Communications Co., Ltd."],
      "0003D6" => ["Radvisio", "RADVision, Ltd."],
      "0003D7" => ["NextnetW", "NextNet Wireless, Inc."],
      "0003D8" => ["ImpathNe", "iMPath Networks, Inc."],
      "0003D9" => ["Secheron", "Secheron SA"],
      "0003DA" => ["Takamisa", "Takamisawa Cybernetics Co., Ltd."],
      "0003DB" => ["ApogeeEl", "Apogee Electronics Corp."],
      "0003DC" => ["LexarMed", "Lexar Media, Inc."],
      "0003DD" => ["Comark", "Comark Corp."],
      "0003DE" => ["OtcWirel", "OTC Wireless"],
      "0003DF" => ["Desana", "Desana Systems"],
      "0003E0" => ["Motorola", "Motorola, Inc."],
      "0003E1" => ["WinmateC", "Winmate Communication, Inc."],
      "0003E2" => ["Comspace", "Comspace Corporation"],
      "0003E3" => ["Cisco", "Cisco Systems, Inc."],
      "0003E4" => ["Cisco", "Cisco Systems, Inc."],
      "0003E5" => ["Hermsted", "Hermstedt SG"],
      "0003E6" => ["Entone", "Entone, Inc."],
      "0003E7" => ["Logostek", "Logostek Co. Ltd."],
      "0003E8" => ["Waveleng", "Wavelength Digital Limited"],
      "0003E9" => ["AkaraCan", "Akara Canada, Inc."],
      "0003EA" => ["MegaSyst", "Mega System Technologies, Inc."],
      "0003EB" => ["Atrica",""],
      "0003EC" => ["IcgResea", "ICG Research, Inc."],
      "0003ED" => ["Shinkawa", "Shinkawa Electric Co., Ltd."],
      "0003EE" => ["Mknet", "MKNet Corporation"],
      "0003EF" => ["Oneline", "Oneline AG"],
      "0003F0" => ["RedfernB", "Redfern Broadband Networks"],
      "0003F1" => ["CicadaSe", "Cicada Semiconductor, Inc."],
      "0003F2" => ["SenecaNe", "Seneca Networks"],
      "0003F3" => ["DazzleMu", "Dazzle Multimedia, Inc."],
      "0003F4" => ["Netburne", "NetBurner"],
      "0003F5" => ["Chip2chi", "Chip2Chip"],
      "0003F6" => ["AllegroN", "Allegro Networks, Inc."],
      "0003F7" => ["Plast-Co", "Plast-Control GmbH"],
      "0003F8" => ["Sancastl", "SanCastle Technologies, Inc."],
      "0003F9" => ["Pleiades", "Pleiades Communications, Inc."],
      "0003FA" => ["TimetraN", "TiMetra Networks"],
      "0003FB" => ["Enegate", "ENEGATE Co.,Ltd."],
      "0003FC" => ["Intertex", "Intertex Data AB"],
      "0003FD" => ["Cisco", "Cisco Systems, Inc."],
      "0003FE" => ["Cisco", "Cisco Systems, Inc."],
      "0003FF" => ["Microsof", "Microsoft Corporation"],
      "000400" => ["LexmarkI", "LEXMARK INTERNATIONAL, INC."],
      "000401" => ["OsakiEle", "Osaki Electric Co., Ltd."],
      "000402" => ["NexsanTe", "Nexsan Technologies, Ltd."],
      "000403" => ["Nexsi", "Nexsi Corporation"],
      "000404" => ["MakinoMi", "Makino Milling Machine Co., Ltd."],
      "000405" => ["AcnTechn", "ACN Technologies"],
      "000406" => ["FaMetabo", "Fa. Metabox AG"],
      "000407" => ["TopconPo", "Topcon Positioning Systems, Inc."],
      "000408" => ["SankoEle", "Sanko Electronics Co., Ltd."],
      "000409" => ["CratosNe", "Cratos Networks"],
      "00040A" => ["Sage", "Sage Systems"],
      "00040B" => ["3comEuro", "3com Europe Ltd."],
      "00040C" => ["KannoWor", "KANNO Work\'s Ltd."],
      "00040D" => ["Avaya", "Avaya, Inc."],
      "00040E" => ["Avm", "AVM GmbH"],
      "00040F" => ["AsusNetw", "Asus Network Technologies, Inc."],
      "000410" => ["Spinnake", "Spinnaker Networks, Inc."],
      "000411" => ["InkraNet", "Inkra Networks, Inc."],
      "000412" => ["Wavesmit", "WaveSmith Networks, Inc."],
      "000413" => ["SnomTech", "SNOM Technology AG"],
      "000414" => ["UmezawaM", "Umezawa Musen Denki Co., Ltd."],
      "000415" => ["Rasteme", "Rasteme Systems Co., Ltd."],
      "000416" => ["ParksCom", "Parks S/A Comunicacoes Digitais"],
      "000417" => ["Elau", "ELAU AG"],
      "000418" => ["Teltroni", "Teltronic S.A.U."],
      "000419" => ["Fibercyc", "Fibercycle Networks, Inc."],
      "00041A" => ["InesTest", "Ines Test and Measurement GmbH & CoKG"],
      "00041B" => ["Bridgewo", "Bridgeworks Ltd."],
      "00041C" => ["Ipdialog", "ipDialog, Inc."],
      "00041D" => ["CoregaOf", "Corega of America"],
      "00041E" => ["ShikokuI", "Shikoku Instrumentation Co., Ltd."],
      "00041F" => ["SonyComp", "Sony Computer Entertainment, Inc."],
      "000420" => ["SlimDevi", "Slim Devices, Inc."],
      "000421" => ["OcularNe", "Ocular Networks"],
      "000422" => ["GordonKa", "Gordon Kapes, Inc."],
      "000423" => ["Intel", "Intel Corporation"],
      "000424" => ["TmcSRL", "TMC s.r.l."],
      "000425" => ["Atmel", "Atmel Corporation"],
      "000426" => ["Autosys",""],
      "000427" => ["Cisco", "Cisco Systems, Inc."],
      "000428" => ["Cisco", "Cisco Systems, Inc."],
      "000429" => ["Pixord", "Pixord Corporation"],
      "00042A" => ["Wireless", "Wireless Networks, Inc."],
      "00042B" => ["ItAccess", "IT Access Co., Ltd."],
      "00042C" => ["Minet", "Minet, Inc."],
      "00042D" => ["Sarian", "Sarian Systems, Ltd."],
      "00042E" => ["NetousTe", "Netous Technologies, Ltd."],
      "00042F" => ["Internat", "International Communications Products, Inc."],
      "000430" => ["Netgem",""],
      "000431" => ["Globalst", "GlobalStreams, Inc."],
      "000432" => ["VoyetraT", "Voyetra Turtle Beach, Inc."],
      "000433" => ["Cyberboa", "Cyberboard A/S"],
      "000434" => ["Accelent", "Accelent Systems, Inc."],
      "000435" => ["ComptekI", "Comptek International, Inc."],
      "000436" => ["ElansatT", "ELANsat Technologies, Inc."],
      "000437" => ["PowinInf", "Powin Information Technology, Inc."],
      "000438" => ["NortelNe", "Nortel Networks"],
      "000439" => ["RoscoEnt", "Rosco Entertainment Technology, Inc."],
      "00043A" => ["Intellig", "Intelligent Telecommunications, Inc."],
      "00043B" => ["LavaComp", "Lava Computer Mfg., Inc."],
      "00043C" => ["Sonos", "SONOS Co., Ltd."],
      "00043D" => ["Indel", "INDEL AG"],
      "00043E" => ["Telencom", "Telencomm"],
      "00043F" => ["EsteemWi", "ESTeem Wireless Modems, Inc"],
      "000440" => ["Cyberpix", "cyberPIXIE, Inc."],
      "000441" => ["HalfDome", "Half Dome Systems, Inc."],
      "000442" => ["Nact",""],
      "000443" => ["AgilentT", "Agilent Technologies, Inc."],
      "000444" => ["WesternM", "Western Multiplex Corporation"],
      "000445" => ["LmsSkala", "LMS Skalar Instruments GmbH"],
      "000446" => ["Cyzentec", "CYZENTECH Co., Ltd."],
      "000447" => ["Acrowave", "Acrowave Systems Co., Ltd."],
      "000448" => ["Polaroid", "Polaroid Corporation"],
      "000449" => ["Mapletre", "Mapletree Networks"],
      "00044A" => ["IpolicyN", "iPolicy Networks, Inc."],
      "00044B" => ["Nvidia",""],
      "00044C" => ["Jenoptik",""],
      "00044D" => ["Cisco", "Cisco Systems, Inc."],
      "00044E" => ["Cisco", "Cisco Systems, Inc."],
      "00044F" => ["Leukhard", "Leukhardt Systemelektronik GmbH"],
      "000450" => ["DmdCompu", "DMD Computers SRL"],
      "000451" => ["Medrad", "Medrad, Inc."],
      "000452" => ["Rocketlo", "RocketLogix, Inc."],
      "000453" => ["Yottayot", "YottaYotta, Inc."],
      "000454" => ["Quadriga", "Quadriga UK"],
      "000455" => ["AntaraNe", "ANTARA.net"],
      "000456" => ["CambiumN", "Cambium Networks Limited"],
      "000457" => ["Universa", "Universal Access Technology, Inc."],
      "000458" => ["FusionX", "Fusion X Co., Ltd."],
      "000459" => ["Veristar", "Veristar Corporation"],
      "00045A" => ["LinksysG", "The Linksys Group, Inc."],
      "00045B" => ["TechsanE", "Techsan Electronics Co., Ltd."],
      "00045C" => ["Mobiwave", "Mobiwave Pte Ltd"],
      "00045D" => ["BekaElek", "BEKA Elektronik"],
      "00045E" => ["Polytrax", "PolyTrax Information Technology AG"],
      "00045F" => ["EvalueTe", "Evalue Technology, Inc."],
      "000460" => ["KnilinkT", "Knilink Technology, Inc."],
      "000461" => ["EpoxComp", "EPOX Computer Co., Ltd."],
      "000462" => ["DakosDat", "DAKOS Data & Communication Co., Ltd."],
      "000463" => ["BoschSec", "Bosch Security Systems"],
      "000464" => ["Fantasma", "Fantasma Networks, Inc."],
      "000465" => ["ISTIsdn-", "i.s.t isdn-support technik GmbH"],
      "000466" => ["Armitel", "ARMITEL Co."],
      "000467" => ["WuhanRes", "Wuhan Research Institute of MII"],
      "000468" => ["Vivity", "Vivity, Inc."],
      "000469" => ["Innocom", "Innocom, Inc."],
      "00046A" => ["NaviniNe", "Navini Networks"],
      "00046B" => ["PalmWire", "Palm Wireless, Inc."],
      "00046C" => ["CyberTec", "Cyber Technology Co., Ltd."],
      "00046D" => ["Cisco", "Cisco Systems, Inc."],
      "00046E" => ["Cisco", "Cisco Systems, Inc."],
      "00046F" => ["DigitelI", "Digitel S/A Industria Eletronica"],
      "000470" => ["Ipunplug", "ipUnplugged AB"],
      "000471" => ["Iprad",""],
      "000472" => ["Telelynx", "Telelynx, Inc."],
      "000473" => ["Photonex", "Photonex Corporation"],
      "000474" => ["Legrand",""],
      "000475" => ["3Com", "3 Com Corporation"],
      "000476" => ["3Com", "3 Com Corporation"],
      "000477" => ["Scalant", "Scalant Systems, Inc."],
      "000478" => ["GStarTec", "G. Star Technology Corporation"],
      "000479" => ["Radius", "Radius Co., Ltd."],
      "00047A" => ["Axxessit", "AXXESSIT ASA"],
      "00047B" => ["Schlumbe", "Schlumberger"],
      "00047C" => ["Skidata", "Skidata AG"],
      "00047D" => ["Pelco",""],
      "00047E" => ["SiquraBV", "Siqura B.V."],
      "00047F" => ["ChrMayr", "Chr. Mayr GmbH & Co. KG"],
      "000480" => ["BrocadeC", "Brocade Communications Systems, Inc"],
      "000481" => ["Econolit", "Econolite Control Products, Inc."],
      "000482" => ["Medialog", "Medialogic Corp."],
      "000483" => ["DeltronT", "Deltron Technology, Inc."],
      "000484" => ["Amann", "Amann GmbH"],
      "000485" => ["Picoligh", "PicoLight"],
      "000486" => ["IttcUniv", "ITTC, University of Kansas"],
      "000487" => ["CogencyS", "Cogency Semiconductor, Inc."],
      "000488" => ["Eurother", "Eurotherm Controls"],
      "000489" => ["YafoNetw", "YAFO Networks, Inc."],
      "00048A" => ["TemiaVer", "Temia Vertriebs GmbH"],
      "00048B" => ["Poscon", "Poscon Corporation"],
      "00048C" => ["NaynaNet", "Nayna Networks, Inc."],
      "00048D" => ["ToneComm", "Tone Commander Systems, Inc."],
      "00048E" => ["OhmTechL", "Ohm Tech Labs, Inc."],
      "00048F" => ["Td", "TD Systems Corporation"],
      "000490" => ["OpticalA", "Optical Access"],
      "000491" => ["Technovi", "Technovision, Inc."],
      "000492" => ["HiveInte", "Hive Internet, Ltd."],
      "000493" => ["Tsinghua", "Tsinghua Unisplendour Co., Ltd."],
      "000494" => ["Breezeco", "Breezecom, Ltd."],
      "000495" => ["TejasNet", "Tejas Networks India Limited"],
      "000496" => ["ExtremeN", "Extreme Networks"],
      "000497" => ["Macrosys", "MacroSystem Digital Video AG"],
      "000498" => ["MahiNetw", "Mahi Networks"],
      "000499" => ["Chino", "Chino Corporation"],
      "00049A" => ["Cisco", "Cisco Systems, Inc."],
      "00049B" => ["Cisco", "Cisco Systems, Inc."],
      "00049C" => ["Surgient", "Surgient Networks, Inc."],
      "00049D" => ["IpanemaT", "Ipanema Technologies"],
      "00049E" => ["Wirelink", "Wirelink Co., Ltd."],
      "00049F" => ["Freescal", "Freescale Semiconductor"],
      "0004A0" => ["VerityIn", "Verity Instruments, Inc."],
      "0004A1" => ["PathwayC", "Pathway Connectivity"],
      "0004A2" => ["LSIJapan", "L.S.I. Japan Co., Ltd."],
      "0004A3" => ["Microchi", "Microchip Technology, Inc."],
      "0004A4" => ["Netenabl", "NetEnabled, Inc."],
      "0004A5" => ["BarcoPro", "Barco Projection Systems NV"],
      "0004A6" => ["SafTehni", "SAF Tehnika Ltd."],
      "0004A7" => ["Fabiatec", "FabiaTech Corporation"],
      "0004A8" => ["Broadmax", "Broadmax Technologies, Inc."],
      "0004A9" => ["Sandstre", "SandStream Technologies, Inc."],
      "0004AA" => ["Jetstrea", "Jetstream Communications"],
      "0004AB" => ["Comverse", "Comverse Network Systems, Inc."],
      "0004AC" => ["Ibm", "IBM Corp"],
      "0004AD" => ["MalibuNe", "Malibu Networks"],
      "0004AE" => ["Sullair", "Sullair Corporation"],
      "0004AF" => ["DigitalF", "Digital Fountain, Inc."],
      "0004B0" => ["Elesign", "ELESIGN Co., Ltd."],
      "0004B1" => ["SignalTe", "Signal Technology, Inc."],
      "0004B2" => ["EssegiSr", "ESSEGI SRL"],
      "0004B3" => ["Videotek", "Videotek, Inc."],
      "0004B4" => ["Ciac",""],
      "0004B5" => ["Equitrac", "Equitrac Corporation"],
      "0004B6" => ["StratexN", "Stratex Networks, Inc."],
      "0004B7" => ["AmbIT", "AMB i.t. Holding"],
      "0004B8" => ["Kumahira", "Kumahira Co., Ltd."],
      "0004B9" => ["SISoubou", "S.I. Soubou, Inc."],
      "0004BA" => ["KddMedia", "KDD Media Will Corporation"],
      "0004BB" => ["Bardac", "Bardac Corporation"],
      "0004BC" => ["Giantec", "Giantec, Inc."],
      "0004BD" => ["Motorola", "Motorola Mobility, Inc."],
      "0004BE" => ["Optxcon", "OptXCon, Inc."],
      "0004BF" => ["Versalog", "VersaLogic Corp."],
      "0004C0" => ["Cisco", "Cisco Systems, Inc."],
      "0004C1" => ["Cisco", "Cisco Systems, Inc."],
      "0004C2" => ["Magnipix", "Magnipix, Inc."],
      "0004C3" => ["CastorIn", "CASTOR Informatique"],
      "0004C4" => ["AllenHea", "Allen & Heath Limited"],
      "0004C5" => ["AseTechn", "ASE Technologies, USA"],
      "0004C6" => ["YamahaMo", "Yamaha Motor Co., Ltd."],
      "0004C7" => ["Netmount",""],
      "0004C8" => ["LibaMasc", "LIBA Maschinenfabrik GmbH"],
      "0004C9" => ["MicroEle", "Micro Electron Co., Ltd."],
      "0004CA" => ["Freems", "FreeMs Corp."],
      "0004CB" => ["TdsoftCo", "Tdsoft Communication, Ltd."],
      "0004CC" => ["PeekTraf", "Peek Traffic B.V."],
      "0004CD" => ["Informed", "Informedia Research Group"],
      "0004CE" => ["PatriaAi", "Patria Ailon"],
      "0004CF" => ["SeagateT", "Seagate Technology"],
      "0004D0" => ["Softlink", "Softlink s.r.o."],
      "0004D1" => ["DrewTech", "Drew Technologies, Inc."],
      "0004D2" => ["AdconTel", "Adcon Telemetry GmbH"],
      "0004D3" => ["Toyokeik", "Toyokeiki Co., Ltd."],
      "0004D4" => ["ProviewE", "Proview Electronics Co., Ltd."],
      "0004D5" => ["HitachiI", "Hitachi Information & Communication Engineering, Ltd."],
      "0004D6" => ["TakagiIn", "Takagi Industrial Co., Ltd."],
      "0004D7" => ["OmitecIn", "Omitec Instrumentation Ltd."],
      "0004D8" => ["Ipwirele", "IPWireless, Inc."],
      "0004D9" => ["TitanEle", "Titan Electronics, Inc."],
      "0004DA" => ["RelaxTec", "Relax Technology, Inc."],
      "0004DB" => ["TellusGr", "Tellus Group Corp."],
      "0004DC" => ["NortelNe", "Nortel Networks"],
      "0004DD" => ["Cisco", "Cisco Systems, Inc."],
      "0004DE" => ["Cisco", "Cisco Systems, Inc."],
      "0004DF" => ["TeracomT", "Teracom Telematica Ltda."],
      "0004E0" => ["ProcketN", "Procket Networks"],
      "0004E1" => ["Infinior", "Infinior Microsystems"],
      "0004E2" => ["SmcNetwo", "SMC Networks, Inc."],
      "0004E3" => ["AcctonTe", "Accton Technology Corp."],
      "0004E4" => ["Daeryung", "Daeryung Ind., Inc."],
      "0004E5" => ["Glonet", "Glonet Systems, Inc."],
      "0004E6" => ["BanyanNe", "Banyan Network Private Limited"],
      "0004E7" => ["Lightpoi", "Lightpointe Communications, Inc"],
      "0004E8" => ["Ier", "IER, Inc."],
      "0004E9" => ["Infinisw", "Infiniswitch Corporation"],
      "0004EA" => ["Hewlett-", "Hewlett-Packard Company"],
      "0004EB" => ["PaxonetC", "Paxonet Communications, Inc."],
      "0004EC" => ["MemoboxS", "Memobox SA"],
      "0004ED" => ["BillionE", "Billion Electric Co., Ltd."],
      "0004EE" => ["LincolnE", "Lincoln Electric Company"],
      "0004EF" => ["Polestar", "Polestar Corp."],
      "0004F0" => ["Internat", "International Computers, Ltd"],
      "0004F1" => ["Wherenet",""],
      "0004F2" => ["Polycom",""],
      "0004F3" => ["FsForth-", "FS FORTH-SYSTEME GmbH"],
      "0004F4" => ["Infinite", "Infinite Electronics Inc."],
      "0004F5" => ["Snowshor", "SnowShore Networks, Inc."],
      "0004F6" => ["Amphus",""],
      "0004F7" => ["OmegaBan", "Omega Band, Inc."],
      "0004F8" => ["Qualicab", "QUALICABLE TV Industria E Com., Ltda"],
      "0004F9" => ["XteraCom", "Xtera Communications, Inc."],
      "0004FA" => ["NbsTechn", "NBS Technologies Inc."],
      "0004FB" => ["Commtech", "Commtech, Inc."],
      "0004FC" => ["StratusC", "Stratus Computer (DE), Inc."],
      "0004FD" => ["JapanCon", "Japan Control Engineering Co., Ltd."],
      "0004FE" => ["PelagoNe", "Pelago Networks"],
      "0004FF" => ["Acronet", "Acronet Co., Ltd."],
      "000500" => ["Cisco", "Cisco Systems, Inc."],
      "000501" => ["Cisco", "Cisco Systems, Inc."],
      "000502" => ["AppleCom", "APPLE COMPUTER"],
      "000503" => ["Iconag",""],
      "000504" => ["NarayInf", "Naray Information & Communication Enterprise"],
      "000505" => ["Integrat", "Systems Integration Solutions, Inc."],
      "000506" => ["ReddoNet", "Reddo Networks AB"],
      "000507" => ["FineAppl", "Fine Appliance Corp."],
      "000508" => ["Inetcam", "Inetcam, Inc."],
      "000509" => ["AvocNish", "AVOC Nishimura Ltd."],
      "00050A" => ["Ics", "ICS Spa"],
      "00050B" => ["Sicom", "SICOM Systems, Inc."],
      "00050C" => ["NetworkP", "Network Photonics, Inc."],
      "00050D" => ["Midstrea", "Midstream Technologies, Inc."],
      "00050E" => ["3ware", "3ware, Inc."],
      "00050F" => ["TanakaS/", "Tanaka S/S Ltd."],
      "000510" => ["Infinite", "Infinite Shanghai Communication Terminals Ltd."],
      "000511" => ["Compleme", "Complementary Technologies Ltd"],
      "000512" => ["Meshnetw", "MeshNetworks, Inc."],
      "000513" => ["VtlinxMu", "VTLinx Multimedia Systems, Inc."],
      "000514" => ["Kdt", "KDT Systems Co., Ltd."],
      "000515" => ["Nuark", "Nuark Co., Ltd."],
      "000516" => ["SmartMod", "SMART Modular Technologies"],
      "000517" => ["Shellcom", "Shellcomm, Inc."],
      "000518" => ["Jupiters", "Jupiters Technology"],
      "000519" => ["SiemensB", "Siemens Building Technologies AG,"],
      "00051A" => ["3comEuro", "3Com Europe Ltd."],
      "00051B" => ["MagicCon", "Magic Control Technology Corporation"],
      "00051C" => ["XnetTech", "Xnet Technology Corp."],
      "00051D" => ["Airocon", "Airocon, Inc."],
      "00051E" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "00051F" => ["TaijinMe", "Taijin Media Co., Ltd."],
      "000520" => ["Smartron", "Smartronix, Inc."],
      "000521" => ["ControlM", "Control Microsystems"],
      "000522" => ["Lea*D", "LEA*D Corporation, Inc."],
      "000523" => ["AvlList", "AVL List GmbH"],
      "000524" => ["BtlSyste", "BTL System (HK) Limited"],
      "000525" => ["PuretekI", "Puretek Industrial Co., Ltd."],
      "000526" => ["Ipas", "IPAS GmbH"],
      "000527" => ["SjTek", "SJ Tek Co. Ltd"],
      "000528" => ["NewFocus", "New Focus, Inc."],
      "000529" => ["Shanghai", "Shanghai Broadan Communication Technology Co., Ltd"],
      "00052A" => ["IkegamiT", "Ikegami Tsushinki Co., Ltd."],
      "00052B" => ["Horiba", "HORIBA, Ltd."],
      "00052C" => ["SupremeM", "Supreme Magic Corporation"],
      "00052D" => ["ZoltrixI", "Zoltrix International Limited"],
      "00052E" => ["CintaNet", "Cinta Networks"],
      "00052F" => ["LevitonN", "Leviton Network Solutions"],
      "000530" => ["Andiamo", "Andiamo Systems, Inc."],
      "000531" => ["Cisco", "Cisco Systems, Inc."],
      "000532" => ["Cisco", "Cisco Systems, Inc."],
      "000533" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "000534" => ["Northsta", "Northstar Engineering Ltd."],
      "000535" => ["ChipPc", "Chip PC Ltd."],
      "000536" => ["DanamCom", "Danam Communications, Inc."],
      "000537" => ["NetsTech", "Nets Technology Co., Ltd."],
      "000538" => ["Merilus", "Merilus, Inc."],
      "000539" => ["ABrandNe", "A Brand New World in Sweden AB"],
      "00053A" => ["Willowgl", "Willowglen Services Pte Ltd"],
      "00053B" => ["HarbourN", "Harbour Networks Ltd., Co. Beijing"],
      "00053C" => ["Xircom",""],
      "00053D" => ["Agere", "Agere Systems"],
      "00053E" => ["KidSyste", "KID Systeme GmbH"],
      "00053F" => ["Visionte", "VisionTek, Inc."],
      "000540" => ["Fast", "FAST Corporation"],
      "000541" => ["Advanced", "Advanced Systems Co., Ltd."],
      "000542" => ["Otari", "Otari, Inc."],
      "000543" => ["IqWirele", "IQ Wireless GmbH"],
      "000544" => ["ValleyTe", "Valley Technologies, Inc."],
      "000545" => ["Internet", "Internet Photonics"],
      "000546" => ["KddiNetw", "KDDI Network & Solultions Inc."],
      "000547" => ["StarentN", "Starent Networks"],
      "000548" => ["Disco", "Disco Corporation"],
      "000549" => ["SaliraOp", "Salira Optical Network Systems"],
      "00054A" => ["ArioData", "Ario Data Networks, Inc."],
      "00054B" => ["EatonAut", "Eaton Automation AG"],
      "00054C" => ["RfInnova", "RF Innovations Pty Ltd"],
      "00054D" => ["BransTec", "Brans Technologies, Inc."],
      "00054E" => ["Philips",""],
      "00054F" => ["Private",""],
      "000550" => ["VcommsCo", "Vcomms Connect Limited"],
      "000551" => ["FSElektr", "F & S Elektronik Systeme GmbH"],
      "000552" => ["XycotecC", "Xycotec Computer GmbH"],
      "000553" => ["Dvc", "DVC Company, Inc."],
      "000554" => ["Rangesta", "Rangestar Wireless"],
      "000555" => ["JapanCas", "Japan Cash Machine Co., Ltd."],
      "000556" => ["360", "360 Systems"],
      "000557" => ["AgileTv", "Agile TV Corporation"],
      "000558" => ["Synchron", "Synchronous, Inc."],
      "000559" => ["Intracom", "Intracom S.A."],
      "00055A" => ["PowerDsi", "Power Dsine Ltd."],
      "00055B" => ["CharlesI", "Charles Industries, Ltd."],
      "00055C" => ["Kowa", "Kowa Company, Ltd."],
      "00055D" => ["D-Link", "D-Link Systems, Inc."],
      "00055E" => ["Cisco", "Cisco Systems, Inc."],
      "00055F" => ["Cisco", "Cisco Systems, Inc."],
      "000560" => ["LeaderCo", "LEADER COMM.CO., LTD"],
      "000561" => ["NacImage", "nac Image Technology, Inc."],
      "000562" => ["DigitalV", "Digital View Limited"],
      "000563" => ["J-Works", "J-Works, Inc."],
      "000564" => ["Tsinghua", "Tsinghua Bitway Co., Ltd."],
      "000565" => ["TailynCo", "Tailyn Communication Company Ltd."],
      "000566" => ["SecuiCom", "Secui.com Corporation"],
      "000567" => ["Etymonic", "Etymonic Design, Inc."],
      "000568" => ["Piltofis", "Piltofish Networks AB"],
      "000569" => ["Vmware", "VMware, Inc."],
      "00056A" => ["HeuftSys", "Heuft Systemtechnik GmbH"],
      "00056B" => ["CPTechno", "C.P. Technology Co., Ltd."],
      "00056C" => ["HungChan", "Hung Chang Co., Ltd."],
      "00056D" => ["Pacific", "Pacific Corporation"],
      "00056E" => ["National", "National Enhance Technology, Inc."],
      "00056F" => ["Innomedi", "Innomedia Technologies Pvt. Ltd."],
      "000570" => ["Baydel", "Baydel Ltd."],
      "000571" => ["SeiwaEle", "Seiwa Electronics Co."],
      "000572" => ["Deonet", "Deonet Co., Ltd."],
      "000573" => ["Cisco", "Cisco Systems, Inc."],
      "000574" => ["Cisco", "Cisco Systems, Inc."],
      "000575" => ["Cds-Elec", "CDS-Electronics BV"],
      "000576" => ["NsmTechn", "NSM Technology Ltd."],
      "000577" => ["SmInform", "SM Information & Communication"],
      "000578" => ["Private",""],
      "000579" => ["Universa", "Universal Control Solution Corp."],
      "00057A" => ["Overture", "Overture Networks"],
      "00057B" => ["ChungNam", "Chung Nam Electronic Co., Ltd."],
      "00057C" => ["RcoSecur", "RCO Security AB"],
      "00057D" => ["SunCommu", "Sun Communications, Inc."],
      "00057E" => ["Eckelman", "Eckelmann Steuerungstechnik GmbH"],
      "00057F" => ["AcqisTec", "Acqis Technology"],
      "000580" => ["Fibrolan", "Fibrolan Ltd."],
      "000581" => ["Snell",""],
      "000582" => ["Clearcub", "ClearCube Technology"],
      "000583" => ["Imagecom", "ImageCom Limited"],
      "000584" => ["Absolute", "AbsoluteValue Systems, Inc."],
      "000585" => ["JuniperN", "Juniper Networks, Inc."],
      "000586" => ["LucentTe", "Lucent Technologies"],
      "000587" => ["Locus", "Locus, Incorporated"],
      "000588" => ["Sensoria", "Sensoria Corp."],
      "000589" => ["National", "National Datacomputer"],
      "00058A" => ["Netcom", "Netcom Co., Ltd."],
      "00058B" => ["Ipmental", "IPmental, Inc."],
      "00058C" => ["Opentech", "Opentech Inc."],
      "00058D" => ["LynxPhot", "Lynx Photonic Networks, Inc."],
      "00058E" => ["Flextron", "Flextronics International GmbH & Co. Nfg. KG"],
      "00058F" => ["Clcsoft", "CLCsoft co."],
      "000590" => ["Swissvoi", "Swissvoice Ltd."],
      "000591" => ["ActiveSi", "Active Silicon Ltd."],
      "000592" => ["Pultek", "Pultek Corp."],
      "000593" => ["GrammarE", "Grammar Engine Inc."],
      "000594" => ["IxxatAut", "IXXAT Automation GmbH"],
      "000595" => ["Alesis", "Alesis Corporation"],
      "000596" => ["Genotech", "Genotech Co., Ltd."],
      "000597" => ["EagleTra", "Eagle Traffic Control Systems"],
      "000598" => ["CronosSR", "CRONOS S.r.l."],
      "000599" => ["DrsTestA", "DRS Test and Energy Management or DRS-TEM"],
      "00059A" => ["Cisco", "Cisco Systems, Inc."],
      "00059B" => ["Cisco", "Cisco Systems, Inc."],
      "00059C" => ["Kleinkne", "Kleinknecht GmbH, Ing. Buero"],
      "00059D" => ["DanielCo", "Daniel Computing Systems, Inc."],
      "00059E" => ["Zinwell", "Zinwell Corporation"],
      "00059F" => ["YottaNet", "Yotta Networks, Inc."],
      "0005A0" => ["Mobiline", "MOBILINE Kft."],
      "0005A1" => ["Zenocom",""],
      "0005A2" => ["CeloxNet", "CELOX Networks"],
      "0005A3" => ["Qei", "QEI, Inc."],
      "0005A4" => ["LucidVoi", "Lucid Voice Ltd."],
      "0005A5" => ["Kott",""],
      "0005A6" => ["ExtronEl", "Extron Electronics"],
      "0005A7" => ["Hyperchi", "Hyperchip, Inc."],
      "0005A8" => ["WyleElec", "WYLE ELECTRONICS"],
      "0005A9" => ["Princeto", "Princeton Networks, Inc."],
      "0005AA" => ["MooreInd", "Moore Industries International Inc."],
      "0005AB" => ["CyberFon", "Cyber Fone, Inc."],
      "0005AC" => ["Northern", "Northern Digital, Inc."],
      "0005AD" => ["TopspinC", "Topspin Communications, Inc."],
      "0005AE" => ["Mediapor", "Mediaport USA"],
      "0005AF" => ["Innoscan", "InnoScan Computing A/S"],
      "0005B0" => ["KoreaCom", "Korea Computer Technology Co., Ltd."],
      "0005B1" => ["AsbTechn", "ASB Technology BV"],
      "0005B2" => ["Medison", "Medison Co., Ltd."],
      "0005B3" => ["Asahi-En", "Asahi-Engineering Co., Ltd."],
      "0005B4" => ["Aceex", "Aceex Corporation"],
      "0005B5" => ["Broadcom", "Broadcom Technologies"],
      "0005B6" => ["InsysMic", "INSYS Microelectronics GmbH"],
      "0005B7" => ["ArborTec", "Arbor Technology Corp."],
      "0005B8" => ["Electron", "Electronic Design Associates, Inc."],
      "0005B9" => ["Airvana", "Airvana, Inc."],
      "0005BA" => ["AreaNetw", "Area Netwoeks, Inc."],
      "0005BB" => ["Myspace", "Myspace AB"],
      "0005BC" => ["Resorsys", "Resorsys Ltd."],
      "0005BD" => ["RoaxBv", "ROAX BV"],
      "0005BE" => ["Kongsber", "Kongsberg Seatex AS"],
      "0005BF" => ["JustezyT", "JustEzy Technology, Inc."],
      "0005C0" => ["DigitalN", "Digital Network Alacarte Co., Ltd."],
      "0005C1" => ["A-KyungM", "A-Kyung Motion, Inc."],
      "0005C2" => ["Soronti", "Soronti, Inc."],
      "0005C3" => ["PacificI", "Pacific Instruments, Inc."],
      "0005C4" => ["Telect", "Telect, Inc."],
      "0005C5" => ["FlagaHf", "Flaga HF"],
      "0005C6" => ["TrizComm", "Triz Communications"],
      "0005C7" => ["I/F-Com", "I/F-COM A/S"],
      "0005C8" => ["Verytech",""],
      "0005C9" => ["LgInnote", "LG Innotek Co., Ltd."],
      "0005CA" => ["HitronTe", "Hitron Technology, Inc."],
      "0005CB" => ["RoisTech", "ROIS Technologies, Inc."],
      "0005CC" => ["SumtelCo", "Sumtel Communications, Inc."],
      "0005CD" => ["Denon", "Denon, Ltd."],
      "0005CE" => ["ProlinkM", "Prolink Microsystems Corporation"],
      "0005CF" => ["ThunderR", "Thunder River Technologies, Inc."],
      "0005D0" => ["Solinet", "Solinet Systems"],
      "0005D1" => ["Metavect", "Metavector Technologies"],
      "0005D2" => ["DapTechn", "DAP Technologies"],
      "0005D3" => ["Eproduct", "eProduction Solutions, Inc."],
      "0005D4" => ["Futuresm", "FutureSmart Networks, Inc."],
      "0005D5" => ["Speedcom", "Speedcom Wireless"],
      "0005D6" => ["TitanWir", "Titan Wireless"],
      "0005D7" => ["VistaIma", "Vista Imaging, Inc."],
      "0005D8" => ["Arescom", "Arescom, Inc."],
      "0005D9" => ["TechnoVa", "Techno Valley, Inc."],
      "0005DA" => ["ApexAuto", "Apex Automationstechnik"],
      "0005DB" => ["PsiNente", "PSI Nentec GmbH"],
      "0005DC" => ["Cisco", "Cisco Systems, Inc."],
      "0005DD" => ["Cisco", "Cisco Systems, Inc."],
      "0005DE" => ["GiFoneKo", "Gi Fone Korea, Inc."],
      "0005DF" => ["Electron", "Electronic Innovation, Inc."],
      "0005E0" => ["Empirix", "Empirix Corp."],
      "0005E1" => ["TrellisP", "Trellis Photonics, Ltd."],
      "0005E2" => ["CreativN", "Creativ Network Technologies"],
      "0005E3" => ["Lightsan", "LightSand Communications, Inc."],
      "0005E4" => ["RedLionC", "Red Lion Controls Inc."],
      "0005E5" => ["Renishaw", "Renishaw PLC"],
      "0005E6" => ["Egenera", "Egenera, Inc."],
      "0005E7" => ["NetrakeA", "Netrake an AudioCodes Company"],
      "0005E8" => ["Turbowav", "TurboWave, Inc."],
      "0005E9" => ["UnicessN", "Unicess Network, Inc."],
      "0005EA" => ["Rednix",""],
      "0005EB" => ["BlueRidg", "Blue Ridge Networks, Inc."],
      "0005EC" => ["Mosaic", "Mosaic Systems Inc."],
      "0005ED" => ["Techniku", "Technikum Joanneum GmbH"],
      "0005EE" => ["BewatorG", "BEWATOR Group"],
      "0005EF" => ["AdoirDig", "ADOIR Digital Technology"],
      "0005F0" => ["Satec",""],
      "0005F1" => ["Vrcom", "Vrcom, Inc."],
      "0005F2" => ["PowerR", "Power R, Inc."],
      "0005F3" => ["Weboyn",""],
      "0005F4" => ["SystemBa", "System Base Co., Ltd."],
      "0005F5" => ["OyoGeosp", "OYO Geospace"],
      "0005F6" => ["YoungCha", "Young Chang Co. Ltd."],
      "0005F7" => ["AnalogDe", "Analog Devices, Inc."],
      "0005F8" => ["RealTime", "Real Time Access, Inc."],
      "0005F9" => ["Toa", "TOA Corporation"],
      "0005FA" => ["Ipoptica", "IPOptical, Inc."],
      "0005FB" => ["Sharegat", "ShareGate, Inc."],
      "0005FC" => ["SchenckP", "Schenck Pegasus Corp."],
      "0005FD" => ["Packetli", "PacketLight Networks Ltd."],
      "0005FE" => ["Traficon", "Traficon N.V."],
      "0005FF" => ["SnsSolut", "SNS Solutions, Inc."],
      "000600" => ["ToshibaT", "Toshiba Teli Corporation"],
      "000601" => ["Otanikei", "Otanikeiki Co., Ltd."],
      "000602" => ["Cirkitec", "Cirkitech Electronics Co."],
      "000603" => ["BakerHug", "Baker Hughes Inc."],
      "000604" => ["@TrackCo", "@Track Communications, Inc."],
      "000605" => ["InncomIn", "Inncom International, Inc."],
      "000606" => ["Rapidwan", "RapidWAN, Inc."],
      "000607" => ["OmniDire", "Omni Directional Control Technology Inc."],
      "000608" => ["At-SkySa", "At-Sky SAS"],
      "000609" => ["Crosspor", "Crossport Systems"],
      "00060A" => ["Blue2spa", "Blue2space"],
      "00060B" => ["EmersonN", "Emerson Network Power"],
      "00060C" => ["MelcoInd", "Melco Industries, Inc."],
      "00060D" => ["Wave7Opt", "Wave7 Optics"],
      "00060E" => ["Igys", "IGYS Systems, Inc."],
      "00060F" => ["NaradNet", "Narad Networks Inc"],
      "000610" => ["AbeonaNe", "Abeona Networks Inc"],
      "000611" => ["ZeusWire", "Zeus Wireless, Inc."],
      "000612" => ["Accusys", "Accusys, Inc."],
      "000613" => ["Kawasaki", "Kawasaki Microelectronics Incorporated"],
      "000614" => ["PrismHol", "Prism Holdings"],
      "000615" => ["KimotoEl", "Kimoto Electric Co., Ltd."],
      "000616" => ["TelNet", "Tel Net Co., Ltd."],
      "000617" => ["Redswitc", "Redswitch Inc."],
      "000618" => ["Digipowe", "DigiPower Manufacturing Inc."],
      "000619" => ["Connecti", "Connection Technology Systems"],
      "00061A" => ["Zetari", "Zetari Inc."],
      "00061B" => ["Notebook", "Notebook Development Lab.  Lenovo Japan Ltd."],
      "00061C" => ["HoshinoM", "Hoshino Metal Industries, Ltd."],
      "00061D" => ["MipTelec", "MIP Telecom, Inc."],
      "00061E" => ["Maxan", "Maxan Systems"],
      "00061F" => ["VisionCo", "Vision Components GmbH"],
      "000620" => ["SerialSy", "Serial System Ltd."],
      "000621" => ["Hinox", "Hinox, Co., Ltd."],
      "000622" => ["ChungFuC", "Chung Fu Chen Yeh Enterprise Corp."],
      "000623" => ["MgeUpsFr", "MGE UPS Systems France"],
      "000624" => ["GentnerC", "Gentner Communications Corp."],
      "000625" => ["LinksysG", "The Linksys Group, Inc."],
      "000626" => ["Mwe", "MWE GmbH"],
      "000627" => ["UniwideT", "Uniwide Technologies, Inc."],
      "000628" => ["Cisco", "Cisco Systems, Inc."],
      "000629" => ["Ibm", "IBM Corp"],
      "00062A" => ["Cisco", "Cisco Systems, Inc."],
      "00062B" => ["Intraser", "INTRASERVER TECHNOLOGY"],
      "00062C" => ["BivioNet", "Bivio Networks"],
      "00062D" => ["Touchsta", "TouchStar Technologies, L.L.C."],
      "00062E" => ["AristosL", "Aristos Logic Corp."],
      "00062F" => ["Pivotech", "Pivotech Systems Inc."],
      "000630" => ["AdtranzS", "Adtranz Sweden"],
      "000631" => ["OpticalS", "Optical Solutions, Inc."],
      "000632" => ["MescoEng", "Mesco Engineering GmbH"],
      "000633" => ["CrossMat", "Cross Match Technologies GmbH"],
      "000634" => ["GteAirfo", "GTE Airfone Inc."],
      "000635" => ["Packetai", "PacketAir Networks, Inc."],
      "000636" => ["JedaiBro", "Jedai Broadband Networks"],
      "000637" => ["Toptrend", "Toptrend-Meta Information (ShenZhen) Inc."],
      "000638" => ["SungjinC", "Sungjin C&C Co., Ltd."],
      "000639" => ["Newtec",""],
      "00063A" => ["DuraMicr", "Dura Micro, Inc."],
      "00063B" => ["Arcturus", "Arcturus Networks, Inc."],
      "00063C" => ["Intrinsy", "Intrinsyc Europe Ltd"],
      "00063D" => ["Microwav", "Microwave Data Systems Inc."],
      "00063E" => ["Opthos", "Opthos Inc."],
      "00063F" => ["EverexCo", "Everex Communications Inc."],
      "000640" => ["WhiteRoc", "White Rock Networks"],
      "000641" => ["Itcn",""],
      "000642" => ["Genetel", "Genetel Systems Inc."],
      "000643" => ["SonoComp", "SONO Computer Co., Ltd."],
      "000644" => ["Neix", "Neix,Inc"],
      "000645" => ["MeiseiEl", "Meisei Electric Co. Ltd."],
      "000646" => ["Shenzhen", "ShenZhen XunBao Network Technology Co Ltd"],
      "000647" => ["EtraliSA", "Etrali S.A."],
      "000648" => ["Seedswar", "Seedsware, Inc."],
      "000649" => ["3mDeutsc", "3M Deutschland GmbH"],
      "00064A" => ["Honeywel", "Honeywell Co., Ltd. (KOREA)"],
      "00064B" => ["Alexon", "Alexon Co., Ltd."],
      "00064C" => ["InvictaN", "Invicta Networks, Inc."],
      "00064D" => ["Sencore",""],
      "00064E" => ["BroadNet", "Broad Net Technology Inc."],
      "00064F" => ["Pro-Nets", "PRO-NETS Technology Corporation"],
      "000650" => ["TiburonN", "Tiburon Networks, Inc."],
      "000651" => ["AspenNet", "Aspen Networks Inc."],
      "000652" => ["Cisco", "Cisco Systems, Inc."],
      "000653" => ["Cisco", "Cisco Systems, Inc."],
      "000654" => ["Winpresa", "Winpresa Building Automation Technologies GmbH"],
      "000655" => ["Yipee", "Yipee, Inc."],
      "000656" => ["Tactel", "Tactel AB"],
      "000657" => ["MarketCe", "Market Central, Inc."],
      "000658" => ["HelmutFi", "Helmut Fischer GmbH Institut fur Elektronik und Messtechnik"],
      "000659" => ["EalApeld", "EAL (Apeldoorn) B.V."],
      "00065A" => ["Strix", "Strix Systems"],
      "00065B" => ["DellComp", "Dell Computer Corp."],
      "00065C" => ["Malachit", "Malachite Technologies, Inc."],
      "00065D" => ["Heidelbe", "Heidelberg Web Systems"],
      "00065E" => ["Photuris", "Photuris, Inc."],
      "00065F" => ["EciTelec", "ECI Telecom - NGTS Ltd."],
      "000660" => ["Nadex", "NADEX Co., Ltd."],
      "000661" => ["NiaHomeT", "NIA Home Technologies Corp."],
      "000662" => ["MbmTechn", "MBM Technology Ltd."],
      "000663" => ["HumanTec", "Human Technology Co., Ltd."],
      "000664" => ["Fostex", "Fostex Corporation"],
      "000665" => ["SunnyGik", "Sunny Giken, Inc."],
      "000666" => ["RovingNe", "Roving Networks"],
      "000667" => ["TrippLit", "Tripp Lite"],
      "000668" => ["ViconInd", "Vicon Industries Inc."],
      "000669" => ["Datasoun", "Datasound Laboratories Ltd"],
      "00066A" => ["Infinico", "InfiniCon Systems, Inc."],
      "00066B" => ["Sysmex", "Sysmex Corporation"],
      "00066C" => ["Robinson", "Robinson Corporation"],
      "00066D" => ["Compupri", "Compuprint S.P.A."],
      "00066E" => ["DeltaEle", "Delta Electronics, Inc."],
      "00066F" => ["KoreaDat", "Korea Data Systems"],
      "000670" => ["Upponett", "Upponetti Oy"],
      "000671" => ["Softing", "Softing AG"],
      "000672" => ["Netezza",""],
      "000673" => ["TkhSecur", "TKH Security Solutions USA"],
      "000674" => ["Spectrum", "Spectrum Control, Inc."],
      "000675" => ["Banderac", "Banderacom, Inc."],
      "000676" => ["NovraTec", "Novra Technologies Inc."],
      "000677" => ["Sick", "SICK AG"],
      "000678" => ["MarantzB", "Marantz Brand Company"],
      "000679" => ["Konami", "Konami Corporation"],
      "00067A" => ["Jmp", "JMP Systems"],
      "00067B" => ["ToplinkC", "Toplink C&C Corporation"],
      "00067C" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00067D" => ["Takasago", "Takasago Ltd."],
      "00067E" => ["Wincom", "WinCom Systems, Inc."],
      "00067F" => ["Digeo", "Digeo, Inc."],
      "000680" => ["CardAcce", "Card Access, Inc."],
      "000681" => ["GoepelEl", "Goepel Electronic GmbH"],
      "000682" => ["Convedia",""],
      "000683" => ["BravaraC", "Bravara Communications, Inc."],
      "000684" => ["Biacore", "Biacore AB"],
      "000685" => ["Netnearu", "NetNearU Corporation"],
      "000686" => ["Zardcom", "ZARDCOM Co., Ltd."],
      "000687" => ["Omnitron", "Omnitron Systems Technology, Inc."],
      "000688" => ["TelwaysC", "Telways Communication Co., Ltd."],
      "000689" => ["YlezTech", "yLez Technologies Pte Ltd"],
      "00068A" => ["Neuronne", "NeuronNet Co. Ltd. R&D Center"],
      "00068B" => ["Airrunne", "AirRunner Technologies, Inc."],
      "00068C" => ["3com", "3Com Corporation"],
      "00068D" => ["Sepaton", "SEPATON, Inc."],
      "00068E" => ["Hid", "HID Corporation"],
      "00068F" => ["Telemoni", "Telemonitor, Inc."],
      "000690" => ["EuracomC", "Euracom Communication GmbH"],
      "000691" => ["PtInovac", "PT Inovacao"],
      "000692" => ["Intruver", "Intruvert Networks, Inc."],
      "000693" => ["FlexusCo", "Flexus Computer Technology, Inc."],
      "000694" => ["Mobillia", "Mobillian Corporation"],
      "000695" => ["EnsureTe", "Ensure Technologies, Inc."],
      "000696" => ["AdventNe", "Advent Networks"],
      "000697" => ["RDCenter", "R & D Center"],
      "000698" => ["EgniteSo", "egnite Software GmbH"],
      "000699" => ["VidaDesi", "Vida Design Co."],
      "00069A" => ["ETel", "e & Tel"],
      "00069B" => ["AvtAudio", "AVT Audio Video Technologies GmbH"],
      "00069C" => ["Transmod", "Transmode Systems AB"],
      "00069D" => ["Petards", "Petards Ltd"],
      "00069E" => ["Uniqa", "UNIQA, Inc."],
      "00069F" => ["KuokoaNe", "Kuokoa Networks"],
      "0006A0" => ["MxImagin", "Mx Imaging"],
      "0006A1" => ["CelsianT", "Celsian Technologies, Inc."],
      "0006A2" => ["Microtun", "Microtune, Inc."],
      "0006A3" => ["Bitran", "Bitran Corporation"],
      "0006A4" => ["Innowell", "INNOWELL Corp."],
      "0006A5" => ["Pinon", "PINON Corp."],
      "0006A6" => ["Artistic", "Artistic Licence (UK) Ltd"],
      "0006A7" => ["Primario", "Primarion"],
      "0006A8" => ["KcTechno", "KC Technology, Inc."],
      "0006A9" => ["Universa", "Universal Instruments Corp."],
      "0006AA" => ["VtMiltop", "VT Miltope"],
      "0006AB" => ["W-Link", "W-Link Systems, Inc."],
      "0006AC" => ["Intersof", "Intersoft Co."],
      "0006AD" => ["KbElectr", "KB Electronics Ltd."],
      "0006AE" => ["Himachal", "Himachal Futuristic Communications Ltd"],
      "0006AF" => ["XaltedNe", "Xalted Networks"],
      "0006B0" => ["ComtechE", "Comtech EF Data Corp."],
      "0006B1" => ["Sonicwal", "Sonicwall"],
      "0006B2" => ["Linxtek", "Linxtek Co."],
      "0006B3" => ["Diagraph", "Diagraph Corporation"],
      "0006B4" => ["VorneInd", "Vorne Industries, Inc."],
      "0006B5" => ["SourcePh", "Source Photonics, Inc."],
      "0006B6" => ["Nir-OrIs", "Nir-Or Israel Ltd."],
      "0006B7" => ["Telem", "TELEM GmbH"],
      "0006B8" => ["Bandspee", "Bandspeed Pty Ltd"],
      "0006B9" => ["A5tek", "A5TEK Corp."],
      "0006BA" => ["Westwave", "Westwave Communications"],
      "0006BB" => ["AtiTechn", "ATI Technologies Inc."],
      "0006BC" => ["Macrolin", "Macrolink, Inc."],
      "0006BD" => ["Bntechno", "BNTECHNOLOGY Co., Ltd."],
      "0006BE" => ["BaumerOp", "Baumer Optronic GmbH"],
      "0006BF" => ["AccellaT", "Accella Technologies Co., Ltd."],
      "0006C0" => ["UnitedIn", "United Internetworks, Inc."],
      "0006C1" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0006C2" => ["Smartmat", "Smartmatic Corporation"],
      "0006C3" => ["Schindle", "Schindler Elevator Ltd."],
      "0006C4" => ["Piolink", "Piolink Inc."],
      "0006C5" => ["InnoviTe", "INNOVI Technologies Limited"],
      "0006C6" => ["Lesswire", "lesswire AG"],
      "0006C7" => ["RfnetTec", "RFNET Technologies Pte Ltd (S)"],
      "0006C8" => ["Sumitomo", "Sumitomo Metal Micro Devices, Inc."],
      "0006C9" => ["Technica", "Technical Marketing Research, Inc."],
      "0006CA" => ["American", "American Computer & Digital Components, Inc. (ACDC)"],
      "0006CB" => ["JotronEl", "Jotron Electronics A/S"],
      "0006CC" => ["JmiElect", "JMI Electronics Co., Ltd."],
      "0006CD" => ["LeafImag", "Leaf Imaging Ltd."],
      "0006CE" => ["Dateno",""],
      "0006CF" => ["ThalesAv", "Thales Avionics In-Flight Systems, LLC"],
      "0006D0" => ["ElgarEle", "Elgar Electronics Corp."],
      "0006D1" => ["TahoeNet", "Tahoe Networks, Inc."],
      "0006D2" => ["TundraSe", "Tundra Semiconductor Corp."],
      "0006D3" => ["AlphaTel", "Alpha Telecom, Inc. U.S.A."],
      "0006D4" => ["Interact", "Interactive Objects, Inc."],
      "0006D5" => ["Diamond", "Diamond Systems Corp."],
      "0006D6" => ["Cisco", "Cisco Systems, Inc."],
      "0006D7" => ["Cisco", "Cisco Systems, Inc."],
      "0006D8" => ["MapleOpt", "Maple Optical Systems"],
      "0006D9" => ["Ipm-NetS", "IPM-Net S.p.A."],
      "0006DA" => ["ItranCom", "ITRAN Communications Ltd."],
      "0006DB" => ["Ichips", "ICHIPS Co., Ltd."],
      "0006DC" => ["SyabasTe", "Syabas Technology (Amquest)"],
      "0006DD" => ["AtTLabor", "AT & T Laboratories - Cambridge Ltd"],
      "0006DE" => ["FlashTec", "Flash Technology"],
      "0006DF" => ["Aidonic", "AIDONIC Corporation"],
      "0006E0" => ["Mat", "MAT Co., Ltd."],
      "0006E1" => ["TechnoTr", "Techno Trade s.a"],
      "0006E2" => ["CeemaxTe", "Ceemax Technology Co., Ltd."],
      "0006E3" => ["Quantita", "Quantitative Imaging Corporation"],
      "0006E4" => ["CitelTec", "Citel Technologies Ltd."],
      "0006E5" => ["FujianNe", "Fujian Newland Computer Ltd. Co."],
      "0006E6" => ["Dongyang", "DongYang Telecom Co., Ltd."],
      "0006E7" => ["BitBlitz", "Bit Blitz Communications Inc."],
      "0006E8" => ["OpticalN", "Optical Network Testing, Inc."],
      "0006E9" => ["Intime", "Intime Corp."],
      "0006EA" => ["Elzet80M", "ELZET80 Mikrocomputer GmbH&Co. KG"],
      "0006EB" => ["GlobalDa", "Global Data"],
      "0006EC" => ["Harris", "Harris Corporation"],
      "0006ED" => ["InaraNet", "Inara Networks"],
      "0006EE" => ["Shenyang", "Shenyang Neu-era Information & Technology Stock Co., Ltd"],
      "0006EF" => ["Maxxan", "Maxxan Systems, Inc."],
      "0006F0" => ["Digeo", "Digeo, Inc."],
      "0006F1" => ["Optillio", "Optillion"],
      "0006F2" => ["PlatysCo", "Platys Communications"],
      "0006F3" => ["Acceligh", "AcceLight Networks"],
      "0006F4" => ["PrimeEle", "Prime Electronics & Satellitics Inc."],
      "0006F5" => ["Alps", "ALPS Co,. Ltd."],
      "0006F6" => ["Cisco", "Cisco Systems"],
      "0006F7" => ["AlpsElec", "ALPS Electric Co,. Ltd."],
      "0006F8" => ["CpuTechn", "CPU Technology, Inc."],
      "0006F9" => ["MitsuiZo", "Mitsui Zosen Systems Research Inc."],
      "0006FA" => ["IpSquare", "IP SQUARE Co, Ltd."],
      "0006FB" => ["HitachiP", "Hitachi Printing Solutions, Ltd."],
      "0006FC" => ["Fnet", "Fnet Co., Ltd."],
      "0006FD" => ["ComjetIn", "Comjet Information Systems Corp."],
      "0006FE" => ["Ambrado", "Ambrado, Inc"],
      "0006FF" => ["Sheba", "Sheba Systems Co., Ltd."],
      "000700" => ["Zettamed", "Zettamedia Korea"],
      "000701" => ["Cisco		", "RACAL-DATACOM"],
      "000702" => ["VarianMe", "Varian Medical Systems"],
      "000703" => ["CseeTran", "CSEE Transport"],
      "000704" => ["AlpsElec", "ALPS Electric Co,. Ltd."],
      "000705" => ["EndressH", "Endress & Hauser GmbH & Co"],
      "000706" => ["Sanritz", "Sanritz Corporation"],
      "000707" => ["Interali", "Interalia Inc."],
      "000708" => ["Bitrage", "Bitrage Inc."],
      "000709" => ["Westerst", "Westerstrand Urfabrik AB"],
      "00070A" => ["UnicomAu", "Unicom Automation Co., Ltd."],
      "00070B" => ["Novabase", "Novabase SGPS, SA"],
      "00070C" => ["Sva-Intr", "SVA-Intrusion.com Co. Ltd."],
      "00070D" => ["Cisco", "Cisco Systems Inc."],
      "00070E" => ["Cisco", "Cisco Systems Inc."],
      "00070F" => ["Fujant", "Fujant, Inc."],
      "000710" => ["Adax", "Adax, Inc."],
      "000711" => ["Acterna",""],
      "000712" => ["JalInfor", "JAL Information Technology"],
      "000713" => ["IpOne", "IP One, Inc."],
      "000714" => ["Brightco", "Brightcom"],
      "000715" => ["GeneralR", "General Research of Electronics, Inc."],
      "000716" => ["JSMarine", "J & S Marine Ltd."],
      "000717" => ["WielandE", "Wieland Electric GmbH"],
      "000718" => ["Icantek", "iCanTek Co., Ltd."],
      "000719" => ["Mobiis", "Mobiis Co., Ltd."],
      "00071A" => ["Finedigi", "Finedigital Inc."],
      "00071B" => ["CdvAmeri", "CDV Americas Ltd"],
      "00071C" => ["At&TFixe", "AT&T Fixed Wireless Services"],
      "00071D" => ["SatelsaS", "Satelsa Sistemas Y Aplicaciones De Telecomunicaciones, S.A."],
      "00071E" => ["Tri-MEng", "Tri-M Engineering / Nupak Dev. Corp."],
      "00071F" => ["European", "European Systems Integration"],
      "000720" => ["Trutzsch", "Trutzschler GmbH & Co. KG"],
      "000721" => ["FormacEl", "Formac Elektronik GmbH"],
      "000722" => ["Nielsen", "The Nielsen Company"],
      "000723" => ["ElconSys", "ELCON Systemtechnik GmbH"],
      "000724" => ["Telemax", "Telemax Co., Ltd."],
      "000725" => ["Bematech", "Bematech International Corp."],
      "000726" => ["Shenzhen", "Shenzhen Gongjin Electronics Co., Ltd."],
      "000727" => ["ZiHk", "Zi Corporation (HK) Ltd."],
      "000728" => ["NeoTelec", "Neo Telecom"],
      "000729" => ["KistlerI", "Kistler Instrumente AG"],
      "00072A" => ["Innovanc", "Innovance Networks"],
      "00072B" => ["JungMyun", "Jung Myung Telecom Co., Ltd."],
      "00072C" => ["Fabricom",""],
      "00072D" => ["Cnsystem", "CNSystems"],
      "00072E" => ["NorthNod", "North Node AB"],
      "00072F" => ["Intransa", "Intransa, Inc."],
      "000730" => ["Hutchiso", "Hutchison OPTEL Telecom Technology Co., Ltd."],
      "000731" => ["Ophir-Sp", "Ophir-Spiricon Inc"],
      "000732" => ["AaeonTec", "AAEON Technology Inc."],
      "000733" => ["Dancontr", "DANCONTROL Engineering"],
      "000734" => ["Onstor", "ONStor, Inc."],
      "000735" => ["FlarionT", "Flarion Technologies, Inc."],
      "000736" => ["DataVide", "Data Video Technologies Co., Ltd."],
      "000737" => ["Soriya", "Soriya Co. Ltd."],
      "000738" => ["YoungTec", "Young Technology Co., Ltd."],
      "000739" => ["ScottyGr", "Scotty Group Austria Gmbh"],
      "00073A" => ["Inventel", "Inventel Systemes"],
      "00073B" => ["Tenovis", "Tenovis GmbH & Co KG"],
      "00073C" => ["TelecomD", "Telecom Design"],
      "00073D" => ["NanjingP", "Nanjing Postel Telecommunications Co., Ltd."],
      "00073E" => ["ChinaGre", "China Great-Wall Computer Shenzhen Co., Ltd."],
      "00073F" => ["WoojyunS", "Woojyun Systec Co., Ltd."],
      "000740" => ["Buffalo", "Buffalo, Inc"],
      "000741" => ["SierraAu", "Sierra Automated Systems"],
      "000742" => ["CurrentT", "Current Technologies, LLC"],
      "000743" => ["ChelsioC", "Chelsio Communications"],
      "000744" => ["Unico", "Unico, Inc."],
      "000745" => ["RadlanCo", "Radlan Computer Communications Ltd."],
      "000746" => ["Turck", "TURCK, Inc."],
      "000747" => ["Mecalc",""],
      "000748" => ["ImagingS", "The Imaging Source Europe"],
      "000749" => ["Cenix", "CENiX Inc."],
      "00074A" => ["CarlVale", "Carl Valentin GmbH"],
      "00074B" => ["Daihen", "Daihen Corporation"],
      "00074C" => ["Beicom", "Beicom Inc."],
      "00074D" => ["ZebraTec", "Zebra Technologies Corp."],
      "00074E" => ["Ipfront", "IPFRONT Inc"],
      "00074F" => ["Cisco", "Cisco Systems, Inc."],
      "000750" => ["Cisco", "Cisco Systems, Inc."],
      "000751" => ["M-U-T", "m-u-t AG"],
      "000752" => ["RhythmWa", "Rhythm Watch Co., Ltd."],
      "000753" => ["BeijingQ", "Beijing Qxcomm Technology Co., Ltd."],
      "000754" => ["XyterraC", "Xyterra Computing, Inc."],
      "000755" => ["LafonSa", "Lafon SA"],
      "000756" => ["JuyoungT", "Juyoung Telecom"],
      "000757" => ["TopcallI", "Topcall International AG"],
      "000758" => ["Dragonwa", "Dragonwave"],
      "000759" => ["BorisMan", "Boris Manufacturing Corp."],
      "00075A" => ["AirProdu", "Air Products and Chemicals, Inc."],
      "00075B" => ["GibsonGu", "Gibson Guitars"],
      "00075C" => ["EastmanK", "Eastman Kodak Company"],
      "00075D" => ["Cellerit", "Celleritas Inc."],
      "00075E" => ["AmetekPo", "Ametek Power Instruments"],
      "00075F" => ["VcsVideo", "VCS Video Communication Systems AG"],
      "000760" => ["TomisInf", "TOMIS Information & Telecom Corp."],
      "000761" => ["Logitech", "Logitech SA"],
      "000762" => ["GroupSen", "Group Sense Limited"],
      "000763" => ["Sunniwel", "Sunniwell Cyber Tech. Co., Ltd."],
      "000764" => ["Youngwoo", "YoungWoo Telecom Co. Ltd."],
      "000765" => ["JadeQuan", "Jade Quantum Technologies, Inc."],
      "000766" => ["ChouChin", "Chou Chin Industrial Co., Ltd."],
      "000767" => ["YuxingEl", "Yuxing Electronics Company Limited"],
      "000768" => ["Danfoss", "Danfoss A/S"],
      "000769" => ["Italiana", "Italiana Macchi SpA"],
      "00076A" => ["Nexteye", "NEXTEYE Co., Ltd."],
      "00076B" => ["Stralfor", "Stralfors AB"],
      "00076C" => ["Daehanet", "Daehanet, Inc."],
      "00076D" => ["Flexligh", "Flexlight Networks"],
      "00076E" => ["Sinetica", "Sinetica Corporation Limited"],
      "00076F" => ["Synoptic", "Synoptics Limited"],
      "000770" => ["Locusnet", "Locusnetworks Corporation"],
      "000771" => ["Embedded", "Embedded System Corporation"],
      "000772" => ["AlcatelS", "Alcatel Shanghai Bell Co., Ltd."],
      "000773" => ["AscomPow", "Ascom Powerline Communications Ltd."],
      "000774" => ["Guangzho", "GuangZhou Thinker Technology Co. Ltd."],
      "000775" => ["ValenceS", "Valence Semiconductor, Inc."],
      "000776" => ["FederalA", "Federal APD"],
      "000777" => ["Motah", "Motah Ltd."],
      "000778" => ["Gerstel", "GERSTEL GmbH & Co. KG"],
      "000779" => ["SungilTe", "Sungil Telecom Co., Ltd."],
      "00077A" => ["Infoware", "Infoware System Co., Ltd."],
      "00077B" => ["Millimet", "Millimetrix Broadband Networks"],
      "00077C" => ["Westermo", "Westermo Teleindustri AB"],
      "00077D" => ["Cisco", "Cisco Systems"],
      "00077E" => ["Elrest", "Elrest GmbH"],
      "00077F" => ["JCommuni", "J Communications Co., Ltd."],
      "000780" => ["Bluegiga", "Bluegiga Technologies OY"],
      "000781" => ["Itron", "Itron Inc."],
      "000782" => ["Oracle", "Oracle Corporation"],
      "000783" => ["SyncomNe", "SynCom Network, Inc."],
      "000784" => ["Cisco", "Cisco Systems Inc."],
      "000785" => ["Cisco", "Cisco Systems Inc."],
      "000786" => ["Wireless", "Wireless Networks Inc."],
      "000787" => ["IdeaSyst", "Idea System Co., Ltd."],
      "000788" => ["Clipcomm", "Clipcomm, Inc."],
      "000789" => ["Dongwon", "DONGWON SYSTEMS"],
      "00078A" => ["MentorDa", "Mentor Data System Inc."],
      "00078B" => ["WegenerC", "Wegener Communications, Inc."],
      "00078C" => ["Elektron", "Elektronikspecialisten i Borlange AB"],
      "00078D" => ["Netengin", "NetEngines Ltd."],
      "00078E" => ["GarzFric", "Garz & Friche GmbH"],
      "00078F" => ["EmkayInn", "Emkay Innovative Products"],
      "000790" => ["Tri-MTec", "Tri-M Technologies (s) Limited"],
      "000791" => ["Internat", "International Data Communications, Inc."],
      "000792" => ["SuetronE", "Suetron Electronic GmbH"],
      "000793" => ["ShinSate", "Shin Satellite Public Company Limited"],
      "000794" => ["SimpleDe", "Simple Devices, Inc."],
      "000795" => ["Elitegro", "Elitegroup Computer System Co. (ECS)"],
      "000796" => ["Lsi", "LSI Systems, Inc."],
      "000797" => ["Netpower", "Netpower Co., Ltd."],
      "000798" => ["SeleaSrl", "Selea SRL"],
      "000799" => ["TippingPoint		", "TippingPoint Technologies, Inc."],
      "00079A" => ["Verint", "Verint Systems Inc"],
      "00079B" => ["AuroraNe", "Aurora Networks"],
      "00079C" => ["GoldenEl", "Golden Electronics Technology Co., Ltd."],
      "00079D" => ["Musashi", "Musashi Co., Ltd."],
      "00079E" => ["Ilinx", "Ilinx Co., Ltd."],
      "00079F" => ["ActionDi", "Action Digital Inc."],
      "0007A0" => ["E-Watch", "e-Watch Inc."],
      "0007A1" => ["ViasysHe", "VIASYS Healthcare GmbH"],
      "0007A2" => ["Opteon", "Opteon Corporation"],
      "0007A3" => ["OsitisSo", "Ositis Software, Inc."],
      "0007A4" => ["GnNetcom", "GN Netcom Ltd."],
      "0007A5" => ["YDK", "Y.D.K Co. Ltd."],
      "0007A6" => ["HomeAuto", "Home Automation, Inc."],
      "0007A7" => ["A-Z", "A-Z Inc."],
      "0007A8" => ["HaierGro", "Haier Group Technologies Ltd."],
      "0007A9" => ["Novasoni", "Novasonics"],
      "0007AA" => ["QuantumD", "Quantum Data Inc."],
      "0007AB" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "0007AC" => ["Eolring",""],
      "0007AD" => ["Pentacon", "Pentacon GmbH Foto-und Feinwerktechnik"],
      "0007AE" => ["Britestr", "Britestream Networks, Inc."],
      "0007AF" => ["N-Tron", "N-TRON Corporation"],
      "0007B0" => ["OfficeDe", "Office Details, Inc."],
      "0007B1" => ["EquatorT", "Equator Technologies"],
      "0007B2" => ["Transacc", "Transaccess S.A."],
      "0007B3" => ["Cisco", "Cisco Systems Inc."],
      "0007B4" => ["Cisco", "Cisco Systems Inc."],
      "0007B5" => ["AnyOneWi", "Any One Wireless Ltd."],
      "0007B6" => ["TelecomT", "Telecom Technology Ltd."],
      "0007B7" => ["SamuraiI", "Samurai Ind. Prods Eletronicos Ltda"],
      "0007B8" => ["Corvalen", "Corvalent Corporation"],
      "0007B9" => ["Ginganet", "Ginganet Corporation"],
      "0007BA" => ["Utstarco", "UTStarcom, Inc."],
      "0007BB" => ["Candera", "Candera Inc."],
      "0007BC" => ["Identix", "Identix Inc."],
      "0007BD" => ["Radionet", "Radionet Ltd."],
      "0007BE" => ["Datalogi", "DataLogic SpA"],
      "0007BF" => ["Armillai", "Armillaire Technologies, Inc."],
      "0007C0" => ["Netzerve", "NetZerver Inc."],
      "0007C1" => ["Overture", "Overture Networks, Inc."],
      "0007C2" => ["NetsysTe", "Netsys Telecom"],
      "0007C3" => ["Thomson",""],
      "0007C4" => ["Jean", "JEAN Co. Ltd."],
      "0007C5" => ["Gcom", "Gcom, Inc."],
      "0007C6" => ["VdsVossk", "VDS Vosskuhler GmbH"],
      "0007C7" => ["Synectic", "Synectics Systems Limited"],
      "0007C8" => ["Brain21", "Brain21, Inc."],
      "0007C9" => ["TechnolS", "Technol Seven Co., Ltd."],
      "0007CA" => ["CreatixP", "Creatix Polymedia Ges Fur Kommunikaitonssysteme"],
      "0007CB" => ["FreeboxS", "Freebox SA"],
      "0007CC" => ["KabaBenz", "Kaba Benzing GmbH"],
      "0007CD" => ["Nmtel", "NMTEL Co., Ltd."],
      "0007CE" => ["Cabletim", "Cabletime Limited"],
      "0007CF" => ["Anoto", "Anoto AB"],
      "0007D0" => ["AutomatE", "Automat Engenharia de Automaoa Ltda."],
      "0007D1" => ["Spectrum", "Spectrum Signal Processing Inc."],
      "0007D2" => ["LogopakS", "Logopak Systeme"],
      "0007D3" => ["StorkPri", "Stork Prints B.V."],
      "0007D4" => ["Zhejiang", "Zhejiang Yutong Network Communication Co Ltd."],
      "0007D5" => ["3eTechno", "3e Technologies Int;., Inc."],
      "0007D6" => ["Commil", "Commil Ltd."],
      "0007D7" => ["CaporisN", "Caporis Networks AG"],
      "0007D8" => ["Hitron", "Hitron Systems Inc."],
      "0007D9" => ["Spliceco", "Splicecom"],
      "0007DA" => ["NeuroTel", "Neuro Telecom Co., Ltd."],
      "0007DB" => ["KiranaNe", "Kirana Networks, Inc."],
      "0007DC" => ["Atek", "Atek Co, Ltd."],
      "0007DD" => ["CradleTe", "Cradle Technologies"],
      "0007DE" => ["Ecopilt", "eCopilt AB"],
      "0007DF" => ["Vbrick", "Vbrick Systems Inc."],
      "0007E0" => ["Palm", "Palm Inc."],
      "0007E1" => ["WisCommu", "WIS Communications Co. Ltd."],
      "0007E2" => ["Bitworks", "Bitworks, Inc."],
      "0007E3" => ["NavcomTe", "Navcom Technology, Inc."],
      "0007E4" => ["Softradi", "SoftRadio Co., Ltd."],
      "0007E5" => ["Coup", "Coup Corporation"],
      "0007E6" => ["Edgeflow", "edgeflow Canada Inc."],
      "0007E7" => ["Freewave", "FreeWave Technologies"],
      "0007E8" => ["Edgewave",""],
      "0007E9" => ["Intel", "Intel Corporation"],
      "0007EA" => ["Massana", "Massana, Inc."],
      "0007EB" => ["Cisco", "Cisco Systems Inc."],
      "0007EC" => ["Cisco", "Cisco Systems Inc."],
      "0007ED" => ["Altera", "Altera Corporation"],
      "0007EE" => ["TelcoInf", "telco Informationssysteme GmbH"],
      "0007EF" => ["Lockheed", "Lockheed Martin Tactical Systems"],
      "0007F0" => ["Logisync", "LogiSync LLC"],
      "0007F1" => ["Teraburs", "TeraBurst Networks Inc."],
      "0007F2" => ["Ioa", "IOA Corporation"],
      "0007F3" => ["Thinkeng", "Thinkengine Networks"],
      "0007F4" => ["Eletex", "Eletex Co., Ltd."],
      "0007F5" => ["Bridgeco", "Bridgeco Co AG"],
      "0007F6" => ["QqestSof", "Qqest Software Systems"],
      "0007F7" => ["Galtroni", "Galtronics"],
      "0007F8" => ["Itdevice", "ITDevices, Inc."],
      "0007F9" => ["Phonetic", "Phonetics, Inc."],
      "0007FA" => ["Itt", "ITT Co., Ltd."],
      "0007FB" => ["GigaStre", "Giga Stream UMTS Technologies GmbH"],
      "0007FC" => ["Adept", "Adept Systems Inc."],
      "0007FD" => ["Lanergy", "LANergy Ltd."],
      "0007FE" => ["Rigaku", "Rigaku Corporation"],
      "0007FF" => ["GluonNet", "Gluon Networks"],
      "000800" => ["Multitec", "MULTITECH SYSTEMS, INC."],
      "000801" => ["Highspee", "HighSpeed Surfing Inc."],
      "000802" => ["Hewlett-", "Hewlett-Packard Company"],
      "000803" => ["CosTron", "Cos Tron"],
      "000804" => ["Ica", "ICA Inc."],
      "000805" => ["Techno-H", "Techno-Holon Corporation"],
      "000806" => ["Raonet", "Raonet Systems, Inc."],
      "000807" => ["AccessDe", "Access Devices Limited"],
      "000808" => ["PptVisio", "PPT Vision, Inc."],
      "000809" => ["Systemon", "Systemonic AG"],
      "00080A" => ["Espera-W", "Espera-Werke GmbH"],
      "00080B" => ["BirkaBpa", "Birka BPA Informationssystem AB"],
      "00080C" => ["VdaElett", "VDA Elettronica spa"],
      "00080D" => ["Toshiba",""],
      "00080E" => ["Motorola", "Motorola Mobility, Inc."],
      "00080F" => ["Proximio", "Proximion Fiber Optics AB"],
      "000810" => ["KeyTechn", "Key Technology, Inc."],
      "000811" => ["Voix", "VOIX Corporation"],
      "000812" => ["Gm-2", "GM-2 Corporation"],
      "000813" => ["Diskbank", "Diskbank, Inc."],
      "000814" => ["TilTechn", "TIL Technologies"],
      "000815" => ["Cats", "CATS Co., Ltd."],
      "000816" => ["Bluetags", "Bluetags A/S"],
      "000817" => ["Emergeco", "EmergeCore Networks LLC"],
      "000818" => ["Pixelwor", "Pixelworks, Inc."],
      "000819" => ["Banksys",""],
      "00081A" => ["SanradIn", "Sanrad Intelligence Storage Communications (2000) Ltd."],
      "00081B" => ["Windigo", "Windigo Systems"],
      "00081C" => ["@PosCom", "@pos.com"],
      "00081D" => ["Ipsil", "Ipsil, Incorporated"],
      "00081E" => ["Repeatit", "Repeatit AB"],
      "00081F" => ["PouYuenT", "Pou Yuen Tech Corp. Ltd."],
      "000820" => ["Cisco", "Cisco Systems Inc."],
      "000821" => ["Cisco", "Cisco Systems Inc."],
      "000822" => ["InproCom", "InPro Comm"],
      "000823" => ["Texa", "Texa Corp."],
      "000824" => ["Copitrak", "Copitrak Inc"],
      "000825" => ["AcmePack", "Acme Packet"],
      "000826" => ["Colorado", "Colorado Med Tech"],
      "000827" => ["AdbBroad", "ADB Broadband Italia"],
      "000828" => ["KoeiEngi", "Koei Engineering Ltd."],
      "000829" => ["AvalNaga", "Aval Nagasaki Corporation"],
      "00082A" => ["Powerwal", "Powerwallz Network Security"],
      "00082B" => ["Wooksung", "Wooksung Electronics, Inc."],
      "00082C" => ["Homag", "Homag AG"],
      "00082D" => ["IndusTeq", "Indus Teqsite Private Limited"],
      "00082E" => ["Multiton", "Multitone Electronics PLC"],
      "00082F" => ["Cisco", "Cisco Systems"],
      "000830" => ["Cisco", "Cisco Systems"],
      "000831" => ["Cisco", "Cisco Systems"],
      "00084E" => ["Divergen", "DivergeNet, Inc."],
      "00084F" => ["Qualstar", "Qualstar Corporation"],
      "000850" => ["ArizonaI", "Arizona Instrument Corp."],
      "000851" => ["Canadian", "Canadian Bank Note Company, Ltd."],
      "000852" => ["Davolink", "Davolink Co. Inc."],
      "000853" => ["Schleich", "Schleicher GmbH & Co. Relaiswerke KG"],
      "000854" => ["Netronix", "Netronix, Inc."],
      "000855" => ["Nasa-God", "NASA-Goddard Space Flight Center"],
      "000856" => ["Gamatron", "Gamatronic Electronic Industries Ltd."],
      "000857" => ["PolarisN", "Polaris Networks, Inc."],
      "000858" => ["Novatech", "Novatechnology Inc."],
      "000859" => ["Shenzhen", "ShenZhen Unitone Electronics Co., Ltd."],
      "00085A" => ["Intigate", "IntiGate Inc."],
      "00085B" => ["HanbitEl", "Hanbit Electronics Co., Ltd."],
      "00085C" => ["Shanghai", "Shanghai Dare Technologies Co. Ltd."],
      "00085D" => ["Aastra",""],
      "00085E" => ["Pco", "PCO AG"],
      "00085F" => ["PicanolN", "Picanol N.V."],
      "000860" => ["Lodgenet", "LodgeNet Entertainment Corp."],
      "000861" => ["Softener", "SoftEnergy Co., Ltd."],
      "000862" => ["NecElumi", "NEC Eluminant Technologies, Inc."],
      "000863" => ["Entrisph", "Entrisphere Inc."],
      "000864" => ["FasySPA", "Fasy S.p.A."],
      "000865" => ["Jascom", "JASCOM CO., LTD"],
      "000866" => ["DsxAcces", "DSX Access Systems, Inc."],
      "000867" => ["UptimeDe", "Uptime Devices"],
      "000868" => ["Puroptix",""],
      "000869" => ["Command-", "Command-e Technology Co.,Ltd."],
      "00086A" => ["Securito", "Securiton Gmbh"],
      "00086B" => ["Mipsys",""],
      "00086C" => ["PlasmonL", "Plasmon LMS"],
      "00086D" => ["Missouri", "Missouri FreeNet"],
      "00086E" => ["Hyglo", "Hyglo AB"],
      "00086F" => ["Resource", "Resources Computer Network Ltd."],
      "000870" => ["Rasvia", "Rasvia Systems, Inc."],
      "000871" => ["Northdat", "NORTHDATA Co., Ltd."],
      "000872" => ["Sorenson", "Sorenson Communications"],
      "000873" => ["Daptechn", "DapTechnology B.V."],
      "000874" => ["DellComp", "Dell Computer Corp."],
      "000875" => ["AcorpEle", "Acorp Electronics Corp."],
      "000876" => ["Sdsystem",""],
      "000877" => ["Liebert-", "Liebert-Hiross Spa"],
      "000878" => ["Benchmar", "Benchmark Storage Innovations"],
      "000879" => ["Cem", "CEM Corporation"],
      "00087A" => ["Wipotec", "Wipotec GmbH"],
      "00087B" => ["RtxTelec", "RTX Telecom A/S"],
      "00087C" => ["Cisco", "Cisco Systems, Inc."],
      "00087D" => ["Cisco", "Cisco Systems Inc."],
      "00087E" => ["BonElect", "Bon Electro-Telecom Inc."],
      "00087F" => ["SpaunEle", "SPAUN electronic GmbH & Co. KG"],
      "000880" => ["Broadtel", "BroadTel Canada Communications inc."],
      "000881" => ["DigitalH", "DIGITAL HANDS CO.,LTD."],
      "000882" => ["Sigma", "SIGMA CORPORATION"],
      "000883" => ["Hewlett-", "Hewlett-Packard Company"],
      "000884" => ["IndexBra", "Index Braille AB"],
      "000885" => ["EmsDrTho", "EMS Dr. Thomas Wuensche"],
      "000886" => ["HansungT", "Hansung Teliann, Inc."],
      "000887" => ["Maschine", "Maschinenfabrik Reinhausen GmbH"],
      "000888" => ["OullimIn", "OULLIM Information Technology Inc,."],
      "000889" => ["Echostar", "Echostar Technologies Corp"],
      "00088A" => ["Minds@Wo", "Minds@Work"],
      "00088B" => ["TropicNe", "Tropic Networks Inc."],
      "00088C" => ["QuantaNe", "Quanta Network Systems Inc."],
      "00088D" => ["Sigma-Li", "Sigma-Links Inc."],
      "00088E" => ["NihonCom", "Nihon Computer Co., Ltd."],
      "00088F" => ["Advanced", "ADVANCED DIGITAL TECHNOLOGY"],
      "000890" => ["Avilinks", "AVILINKS SA"],
      "000891" => ["Lyan", "Lyan Inc."],
      "000892" => ["EmSoluti", "EM Solutions"],
      "000893" => ["LeInform", "LE INFORMATION COMMUNICATION INC."],
      "000894" => ["Innovisi", "InnoVISION Multimedia Ltd."],
      "000895" => ["DircTech", "DIRC Technologie GmbH & Co.KG"],
      "000896" => ["Printron", "Printronix, Inc."],
      "000897" => ["QuakeTec", "Quake Technologies"],
      "000898" => ["GigabitO", "Gigabit Optics Corporation"],
      "000899" => ["Netbind", "Netbind, Inc."],
      "00089A" => ["AlcatelM", "Alcatel Microelectronics"],
      "00089B" => ["IcpElect", "ICP Electronics Inc."],
      "00089C" => ["ElecsInd", "Elecs Industry Co., Ltd."],
      "00089D" => ["Uhd-Elek", "UHD-Elektronik"],
      "00089E" => ["BeijingE", "Beijing Enter-Net co.LTD"],
      "00089F" => ["EfmNetwo", "EFM Networks"],
      "0008A0" => ["StotzFei", "Stotz Feinmesstechnik GmbH"],
      "0008A1" => ["CnetTech", "CNet Technology Inc."],
      "0008A2" => ["AdiEngin", "ADI Engineering, Inc."],
      "0008A3" => ["Cisco", "Cisco Systems"],
      "0008A4" => ["Cisco", "Cisco Systems"],
      "0008A5" => ["Peninsul", "Peninsula Systems Inc."],
      "0008A6" => ["Multiwar", "Multiware & Image Co., Ltd."],
      "0008A7" => ["Ilogic", "iLogic Inc."],
      "0008A8" => ["Systec", "Systec Co., Ltd."],
      "0008A9" => ["Sangsang", "SangSang Technology, Inc."],
      "0008AA" => ["Karam",""],
      "0008AB" => ["Enerlinx", "EnerLinx.com, Inc."],
      "0008AC" => ["Eltromat", "Eltromat GmbH"],
      "0008AD" => ["Toyo-Lin", "Toyo-Linx Co., Ltd."],
      "0008AE" => ["Packetfr", "PacketFront International AB"],
      "0008AF" => ["Novatec", "Novatec Corporation"],
      "0008B0" => ["BktelCom", "BKtel communications GmbH"],
      "0008B1" => ["Proquent", "ProQuent Systems"],
      "0008B2" => ["Shenzhen", "SHENZHEN COMPASS TECHNOLOGY DEVELOPMENT CO.,LTD"],
      "0008B3" => ["Fastwel",""],
      "0008B4" => ["Syspol",""],
      "0008B5" => ["TaiGuenE", "TAI GUEN ENTERPRISE CO., LTD"],
      "0008B6" => ["Routefre", "RouteFree, Inc."],
      "0008B7" => ["Hit", "HIT Incorporated"],
      "0008B8" => ["EFJohnso", "E.F. Johnson"],
      "0008B9" => ["KaonMedi", "KAON MEDIA Co., Ltd."],
      "0008BA" => ["Erskine", "Erskine Systems Ltd"],
      "0008BB" => ["Netexcel", "NetExcell"],
      "0008BC" => ["Ilevo", "Ilevo AB"],
      "0008BD" => ["Tepg-Us",""],
      "0008BE" => ["XenpakMs", "XENPAK MSA Group"],
      "0008BF" => ["AptusEle", "Aptus Elektronik AB"],
      "0008C0" => ["Asa", "ASA SYSTEMS"],
      "0008C1" => ["AvistarC", "Avistar Communications Corporation"],
      "0008C2" => ["Cisco", "Cisco Systems"],
      "0008C3" => ["Contex", "Contex A/S"],
      "0008C4" => ["Hikari", "Hikari Co.,Ltd."],
      "0008C5" => ["Liontech", "Liontech Co., Ltd."],
      "0008C6" => ["PhilipsC", "Philips Consumer Communications"],
      "0008C7" => ["Hewlett-", "Hewlett-Packard Company"],
      "0008C8" => ["Sonetico", "Soneticom, Inc."],
      "0008C9" => ["Technisa", "TechniSat Digital GmbH"],
      "0008CA" => ["TwinhanT", "TwinHan Technology Co.,Ltd"],
      "0008CB" => ["ZetaBroa", "Zeta Broadband Inc."],
      "0008CC" => ["Remotec", "Remotec, Inc."],
      "0008CD" => ["With-Net", "With-Net Inc"],
      "0008CE" => ["Ipmobile", "IPMobileNet Inc."],
      "0008CF" => ["NipponKo", "Nippon Koei Power Systems Co., Ltd."],
      "0008D0" => ["MusashiE", "Musashi Engineering Co., LTD."],
      "0008D1" => ["Karel", "KAREL INC."],
      "0008D2" => ["ZoomNetw", "ZOOM Networks Inc."],
      "0008D3" => ["Hercules", "Hercules Technologies S.A."],
      "0008D4" => ["Ineoques", "IneoQuest Technologies, Inc"],
      "0008D5" => ["Vanguard", "Vanguard Networks Solutions, LLC"],
      "0008D6" => ["Hassnet", "HASSNET Inc."],
      "0008D7" => ["How", "HOW CORPORATION"],
      "0008D8" => ["DowkeyMi", "Dowkey Microwave"],
      "0008D9" => ["Mitadens", "Mitadenshi Co.,LTD"],
      "0008DA" => ["Sofaware", "SofaWare Technologies Ltd."],
      "0008DB" => ["Corrigen", "Corrigent Systems"],
      "0008DC" => ["Wiznet",""],
      "0008DD" => ["TelenaCo", "Telena Communications, Inc."],
      "0008DE" => ["3up", "3UP Systems"],
      "0008DF" => ["Alistel", "Alistel Inc."],
      "0008E0" => ["AtoTechn", "ATO Technology Ltd."],
      "0008E1" => ["Barix", "Barix AG"],
      "0008E2" => ["Cisco", "Cisco Systems"],
      "0008E3" => ["Cisco", "Cisco Systems"],
      "0008E4" => ["Envenerg", "Envenergy Inc"],
      "0008E5" => ["Idk", "IDK Corporation"],
      "0008E6" => ["Littlefe", "Littlefeet"],
      "0008E7" => ["ShiContr", "SHI ControlSystems,Ltd."],
      "0008E8" => ["ExcelMas", "Excel Master Ltd."],
      "0008E9" => ["Nextgig",""],
      "0008EA" => ["MotionCo", "Motion Control Engineering, Inc"],
      "0008EB" => ["Romwin", "ROMWin Co.,Ltd."],
      "0008EC" => ["OpticalZ", "Optical Zonu Corporation"],
      "0008ED" => ["St&TInst", "ST&T Instrument Corp."],
      "0008EE" => ["LogicPro", "Logic Product Development"],
      "0008EF" => ["DibalSA", "DIBAL,S.A."],
      "0008F0" => ["NextGene", "Next Generation Systems, Inc."],
      "0008F1" => ["Voltaire",""],
      "0008F2" => ["C&STechn", "C&S Technology"],
      "0008F3" => ["Wany",""],
      "0008F4" => ["Bluetake", "Bluetake Technology Co., Ltd."],
      "0008F5" => ["Yestechn", "YESTECHNOLOGY Co.,Ltd."],
      "0008F6" => ["Sumitomo", "Sumitomo Electric System Solutions Co.,Ltd."],
      "0008F7" => ["HitachiS", "Hitachi Ltd, Semiconductor &amp; Integrated Circuits Gr"],
      "0008F8" => ["UtcCcs", "UTC CCS"],
      "0008F9" => ["EmersonN", "Emerson Network Power"],
      "0008FA" => ["KarlEBri", "Karl E.Brinkmann GmbH"],
      "0008FB" => ["Sonosite", "SonoSite, Inc."],
      "0008FC" => ["Gigaphot", "Gigaphoton Inc."],
      "0008FD" => ["Bluekore", "BlueKorea Co., Ltd."],
      "0008FE" => ["UnikC&C", "UNIK C&C Co.,Ltd."],
      "0008FF" => ["TrilogyC", "Trilogy Communications Ltd"],
      "000900" => ["Tmt",""],
      "000901" => ["Shenzhen", "Shenzhen Shixuntong Information & Technoligy Co"],
      "000902" => ["RedlineC", "Redline Communications Inc."],
      "000903" => ["Panasas", "Panasas, Inc"],
      "000904" => ["MondialE", "MONDIAL electronic"],
      "000905" => ["ItecTech", "iTEC Technologies Ltd."],
      "000906" => ["EsteemNe", "Esteem Networks"],
      "000907" => ["Chrysali", "Chrysalis Development"],
      "000908" => ["VtechTec", "VTech Technology Corp."],
      "000909" => ["TelenorC", "Telenor Connect A/S"],
      "00090A" => ["SnedfarT", "SnedFar Technology Co., Ltd."],
      "00090B" => ["MtlInstr", "MTL  Instruments PLC"],
      "00090C" => ["Mayekawa", "Mayekawa Mfg. Co. Ltd."],
      "00090D" => ["LeaderEl", "LEADER ELECTRONICS CORP."],
      "00090E" => ["HelixTec", "Helix Technology Inc."],
      "00090F" => ["Fortinet", "Fortinet Inc."],
      "000910" => ["SimpleAc", "Simple Access Inc."],
      "000911" => ["Cisco", "Cisco Systems"],
      "000912" => ["Cisco", "Cisco Systems"],
      "000913" => ["Systemk", "SystemK Corporation"],
      "000914" => ["Computro", "COMPUTROLS INC."],
      "000915" => ["Cas", "CAS Corp."],
      "000916" => ["ListmanH", "Listman Home Technologies, Inc."],
      "000917" => ["WemTechn", "WEM Technology Inc"],
      "000918" => ["SamsungT", "SAMSUNG TECHWIN CO.,LTD"],
      "000919" => ["MdsGatew", "MDS Gateways"],
      "00091A" => ["MacatOpt", "Macat Optics & Electronics Co., Ltd."],
      "00091B" => ["DigitalG", "Digital Generation Inc."],
      "00091C" => ["Cachevis", "CacheVision, Inc"],
      "00091D" => ["ProteamC", "Proteam Computer Corporation"],
      "00091E" => ["Firstech", "Firstech Technology Corp."],
      "00091F" => ["A&Amp;D", "A&amp;D Co., Ltd."],
      "000920" => ["EpoxComp", "EpoX COMPUTER CO.,LTD."],
      "000921" => ["Planmeca", "Planmeca Oy"],
      "000922" => ["TstBiome", "TST Biometrics GmbH"],
      "000923" => ["HeamanSy", "Heaman System Co., Ltd"],
      "000924" => ["Telebau", "Telebau GmbH"],
      "000925" => ["VsnSyste", "VSN Systemen BV"],
      "000926" => ["YodaComm", "YODA COMMUNICATIONS, INC."],
      "000927" => ["Toyokeik", "TOYOKEIKI CO.,LTD."],
      "000928" => ["Telecore",""],
      "000929" => ["SanyoInd", "Sanyo Industries (UK) Limited"],
      "00092A" => ["Mytecs", "MYTECS Co.,Ltd."],
      "00092B" => ["IqstorNe", "iQstor Networks, Inc."],
      "00092C" => ["Hitpoint", "Hitpoint Inc."],
      "00092D" => ["Htc", "HTC Corporation"],
      "00092E" => ["B&TechSy", "B&Tech System Inc."],
      "00092F" => ["AkomTech", "Akom Technology Corporation"],
      "000930" => ["Aeroconc", "AeroConcierge Inc."],
      "000931" => ["FutureIn", "Future Internet, Inc."],
      "000932" => ["Omnilux",""],
      "000933" => ["Ophit", "Ophit Co.Ltd."],
      "000934" => ["Dream-Mu", "Dream-Multimedia-Tv GmbH"],
      "000935" => ["Sandvine", "Sandvine Incorporated"],
      "000936" => ["Ipetroni", "Ipetronik GmbH & Co.KG"],
      "000937" => ["Inventec", "Inventec Appliance Corp"],
      "000938" => ["AllotCom", "Allot Communications"],
      "000939" => ["Shibasok", "ShibaSoku Co.,Ltd."],
      "00093A" => ["MolexFib", "Molex Fiber Optics"],
      "00093B" => ["HyundaiN", "HYUNDAI NETWORKS INC."],
      "00093C" => ["JacquesT", "Jacques Technologies P/L"],
      "00093D" => ["Newisys", "Newisys,Inc."],
      "00093E" => ["C&ITechn", "C&I Technologies"],
      "00093F" => ["Double-W", "Double-Win Enterpirse CO., LTD"],
      "000940" => ["Agfeo", "AGFEO GmbH & Co. KG"],
      "000941" => ["AlliedTe", "Allied Telesis K.K."],
      "000942" => ["Wireless", "Wireless Technologies, Inc"],
      "000943" => ["Cisco", "Cisco Systems"],
      "000944" => ["Cisco", "Cisco Systems"],
      "000945" => ["Palmmicr", "Palmmicro Communications Inc"],
      "000946" => ["ClusterL", "Cluster Labs GmbH"],
      "000947" => ["Aztek", "Aztek, Inc."],
      "000948" => ["VistaCon", "Vista Control Systems, Corp."],
      "000949" => ["GlyphTec", "Glyph Technologies Inc."],
      "00094A" => ["HomenetC", "Homenet Communications"],
      "00094B" => ["Fillfact", "FillFactory NV"],
      "00094C" => ["Communic", "Communication Weaver Co.,Ltd."],
      "00094D" => ["Braintre", "Braintree Communications Pty Ltd"],
      "00094E" => ["BartechI", "BARTECH SYSTEMS INTERNATIONAL, INC"],
      "00094F" => ["Elmegt", "elmegt GmbH & Co. KG"],
      "000950" => ["Independ", "Independent Storage Corporation"],
      "000951" => ["ApogeeIm", "Apogee Imaging Systems"],
      "000952" => ["Auerswal", "Auerswald GmbH & Co. KG"],
      "000953" => ["LinkageS", "Linkage System Integration Co.Ltd."],
      "000954" => ["AmitSpol", "AMiT spol. s. r. o."],
      "000955" => ["YoungGen", "Young Generation International Corp."],
      "000956" => ["NetworkG", "Network Systems Group, Ltd. (NSG)"],
      "000957" => ["Supercal", "Supercaller, Inc."],
      "000958" => ["Intelnet", "INTELNET S.A."],
      "000959" => ["Sitecsof", "Sitecsoft"],
      "00095A" => ["Racewood", "RACEWOOD TECHNOLOGY"],
      "00095B" => ["Netgear", "Netgear, Inc."],
      "00095C" => ["PhilipsM", "Philips Medical Systems - Cardiac and Monitoring Systems (CM"],
      "00095D" => ["Dialogue", "Dialogue Technology Corp."],
      "00095E" => ["Masstech", "Masstech Group Inc."],
      "00095F" => ["Telebyte", "Telebyte, Inc."],
      "000960" => ["Yozan", "YOZAN Inc."],
      "000961" => ["Switchge", "Switchgear and Instrumentation Ltd"],
      "000962" => ["SonitorT", "Sonitor Technologies AS"],
      "000963" => ["Dominion", "Dominion Lasercom Inc."],
      "000964" => ["Hi-Techn", "Hi-Techniques, Inc."],
      "000965" => ["HyunjuCo", "HyunJu Computer Co., Ltd."],
      "000966" => ["ThalesNa", "Thales Navigation"],
      "000967" => ["Tachyon", "Tachyon, Inc"],
      "000968" => ["Technove", "TECHNOVENTURE, INC."],
      "000969" => ["MeretOpt", "Meret Optical Communications"],
      "00096A" => ["Cloverle", "Cloverleaf Communications Inc."],
      "00096B" => ["Ibm", "IBM Corp"],
      "00096C" => ["ImediaSe", "Imedia Semiconductor Corp."],
      "00096D" => ["Powernet", "Powernet Technologies Corp."],
      "00096E" => ["GiantEle", "GIANT ELECTRONICS LTD."],
      "00096F" => ["BeijingZ", "Beijing Zhongqing Elegant Tech. Corp.,Limited"],
      "000970" => ["Vibratio", "Vibration Research Corporation"],
      "000971" => ["TimeMana", "Time Management, Inc."],
      "000972" => ["Secureba", "Securebase,Inc"],
      "000973" => ["LentenTe", "Lenten Technology Co., Ltd."],
      "000974" => ["InnopiaT", "Innopia Technologies, Inc."],
      "000975" => ["FsonaCom", "fSONA Communications Corporation"],
      "000976" => ["Datasoft", "Datasoft ISDN Systems GmbH"],
      "000977" => ["BrunnerE", "Brunner Elektronik AG"],
      "000978" => ["AijiSyst", "AIJI System Co., Ltd."],
      "000979" => ["Advanced", "Advanced Television Systems Committee, Inc."],
      "00097A" => ["LouisDes", "Louis Design Labs."],
      "00097B" => ["Cisco", "Cisco Systems"],
      "00097C" => ["Cisco", "Cisco Systems"],
      "00097D" => ["SecwellN", "SecWell Networks Oy"],
      "00097E" => ["ImiTechn", "IMI TECHNOLOGY CO., LTD"],
      "00097F" => ["Vsecure2", "Vsecure 2000 LTD."],
      "000980" => ["PowerZen", "Power Zenith Inc."],
      "000981" => ["NewportN", "Newport Networks"],
      "000982" => ["LoeweOpt", "Loewe Opta GmbH"],
      "000983" => ["Globalto", "GlobalTop Technology, Inc."],
      "000984" => ["MycasaNe", "MyCasa Network Inc."],
      "000985" => ["AutoTele", "Auto Telecom Company"],
      "000986" => ["Metalink", "Metalink LTD."],
      "000987" => ["NishiNip", "NISHI NIPPON ELECTRIC WIRE & CABLE CO.,LTD."],
      "000988" => ["NudianEl", "Nudian Electron Co., Ltd."],
      "000989" => ["Vividlog", "VividLogic Inc."],
      "00098A" => ["Equallog", "EqualLogic Inc"],
      "00098B" => ["Entropic", "Entropic Communications, Inc."],
      "00098C" => ["OptionWi", "Option Wireless Sweden"],
      "00098D" => ["Velocity", "Velocity Semiconductor"],
      "00098E" => ["Ipcas", "ipcas GmbH"],
      "00098F" => ["Cetacean", "Cetacean Networks"],
      "000990" => ["AcksysCo", "ACKSYS Communications & systems"],
      "000991" => ["GeFanucA", "GE Fanuc Automation Manufacturing, Inc."],
      "000992" => ["Interepo", "InterEpoch Technology,INC."],
      "000993" => ["Visteon", "Visteon Corporation"],
      "000994" => ["CronyxEn", "Cronyx Engineering"],
      "000995" => ["CastleTe", "Castle Technology Ltd"],
      "000996" => ["Rdi",""],
      "000997" => ["NortelNe", "Nortel Networks"],
      "000998" => ["Capinfo", "Capinfo Company Limited"],
      "000999" => ["CpGeorge", "CP GEORGES RENAULT"],
      "00099A" => ["Elmo", "ELMO COMPANY, LIMITED"],
      "00099B" => ["WesternT", "Western Telematic Inc."],
      "00099C" => ["NavalRes", "Naval Research Laboratory"],
      "00099D" => ["Haliplex", "Haliplex Communications"],
      "00099E" => ["Testech", "Testech, Inc."],
      "00099F" => ["Videx", "VIDEX INC."],
      "0009A0" => ["Microtec", "Microtechno Corporation"],
      "0009A1" => ["Telewise", "Telewise Communications, Inc."],
      "0009A2" => ["Interfac", "Interface Co., Ltd."],
      "0009A3" => ["LeadflyT", "Leadfly Techologies Corp. Ltd."],
      "0009A4" => ["Hartec", "HARTEC Corporation"],
      "0009A5" => ["HansungE", "HANSUNG ELETRONIC INDUSTRIES DEVELOPMENT CO., LTD"],
      "0009A6" => ["IgnisOpt", "Ignis Optics, Inc."],
      "0009A7" => ["BangOluf", "Bang & Olufsen A/S"],
      "0009A8" => ["Eastmode", "Eastmode Pte Ltd"],
      "0009A9" => ["IkanosCo", "Ikanos Communications"],
      "0009AA" => ["DataComm", "Data Comm for Business, Inc."],
      "0009AB" => ["Netcontr", "Netcontrol Oy"],
      "0009AC" => ["Lanvoice",""],
      "0009AD" => ["HyundaiS", "HYUNDAI SYSCOMM, INC."],
      "0009AE" => ["OkanoEle", "OKANO ELECTRIC CO.,LTD"],
      "0009AF" => ["E-Generi", "e-generis"],
      "0009B0" => ["Onkyo", "Onkyo Corporation"],
      "0009B1" => ["Kanemats", "Kanematsu Electronics, Ltd."],
      "0009B2" => ["L&F", "L&F Inc."],
      "0009B3" => ["Mcm", "MCM Systems Ltd"],
      "0009B4" => ["KisanTel", "KISAN TELECOM CO., LTD."],
      "0009B5" => ["3jTech", "3J Tech. Co., Ltd."],
      "0009B6" => ["Cisco", "Cisco Systems"],
      "0009B7" => ["Cisco", "Cisco Systems"],
      "0009B8" => ["Entise", "Entise Systems"],
      "0009B9" => ["ActionIm", "Action Imaging Solutions"],
      "0009BA" => ["MakuInfo", "MAKU Informationstechik GmbH"],
      "0009BB" => ["Mathstar", "MathStar, Inc."],
      "0009BC" => ["DigitalS", "Digital Safety Technologies, Inc"],
      "0009BD" => ["EpygiTec", "Epygi Technologies, Ltd."],
      "0009BE" => ["Mamiya-O", "Mamiya-OP Co.,Ltd."],
      "0009BF" => ["Nintendo", "Nintendo Co.,Ltd."],
      "0009C0" => ["6wind",""],
      "0009C1" => ["Proces-D", "PROCES-DATA A/S"],
      "0009C2" => ["Onity", "Onity, Inc."],
      "0009C3" => ["Netas",""],
      "0009C4" => ["Medicore", "Medicore Co., Ltd"],
      "0009C5" => ["KingeneT", "KINGENE Technology Corporation"],
      "0009C6" => ["Visionic", "Visionics Corporation"],
      "0009C7" => ["Movistec",""],
      "0009C8" => ["Sinagawa", "SINAGAWA TSUSHIN KEISOU SERVICE"],
      "0009C9" => ["Bluewinc", "BlueWINC Co., Ltd."],
      "0009CA" => ["Imaxnetw", "iMaxNetworks(Shenzhen)Limited."],
      "0009CB" => ["Hbrain",""],
      "0009CC" => ["Moog", "Moog GmbH"],
      "0009CD" => ["HudsonSo", "HUDSON SOFT CO.,LTD."],
      "0009CE" => ["Spacebri", "SpaceBridge Semiconductor Corp."],
      "0009CF" => ["Iad", "iAd GmbH"],
      "0009D0" => ["SolacomT", "Solacom Technologies Inc."],
      "0009D1" => ["SeranoaN", "SERANOA NETWORKS INC"],
      "0009D2" => ["MaiLogic", "Mai Logic Inc."],
      "0009D3" => ["WesternD", "Western DataCom Co., Inc."],
      "0009D4" => ["Transtec", "Transtech Networks"],
      "0009D5" => ["SignalCo", "Signal Communication, Inc."],
      "0009D6" => ["KncOne", "KNC One GmbH"],
      "0009D7" => ["DcSecuri", "DC Security Products"],
      "0009D8" => ["FaltComm", "Falt Communications AB"],
      "0009D9" => ["Neoscale", "Neoscale Systems, Inc"],
      "0009DA" => ["ControlM", "Control Module Inc."],
      "0009DB" => ["Espace",""],
      "0009DC" => ["GalaxisT", "Galaxis Technology AG"],
      "0009DD" => ["MavinTec", "Mavin Technology Inc."],
      "0009DE" => ["SamjinIn", "Samjin Information & Communications Co., Ltd."],
      "0009DF" => ["VestelKo", "Vestel Komunikasyon Sanayi ve Ticaret A.S."],
      "0009E0" => ["XemicsSA", "XEMICS S.A."],
      "0009E1" => ["GemtekTe", "Gemtek Technology Co., Ltd."],
      "0009E2" => ["SinbonEl", "Sinbon Electronics Co., Ltd."],
      "0009E3" => ["AngelIgl", "Angel Iglesias S.A."],
      "0009E4" => ["KTechInf", "K Tech Infosystem Inc."],
      "0009E5" => ["Hottinge", "Hottinger Baldwin Messtechnik GmbH"],
      "0009E6" => ["CyberSwi", "Cyber Switching Inc."],
      "0009E7" => ["AdcTecho", "ADC Techonology"],
      "0009E8" => ["Cisco", "Cisco Systems"],
      "0009E9" => ["Cisco", "Cisco Systems"],
      "0009EA" => ["Yem", "YEM Inc."],
      "0009EB" => ["Humandat", "HuMANDATA LTD."],
      "0009EC" => ["Daktroni", "Daktronics, Inc."],
      "0009ED" => ["Cipherop", "CipherOptics"],
      "0009EE" => ["MeikyoEl", "MEIKYO ELECTRIC CO.,LTD"],
      "0009EF" => ["VoceraCo", "Vocera Communications"],
      "0009F0" => ["ShimizuT", "Shimizu Technology Inc."],
      "0009F1" => ["YamakiEl", "Yamaki Electric Corporation"],
      "0009F2" => ["CohuElec", "Cohu, Inc., Electronics Division"],
      "0009F3" => ["WellComm", "WELL Communication Corp."],
      "0009F4" => ["AlconLab", "Alcon Laboratories, Inc."],
      "0009F5" => ["EmersonN", "Emerson Network Power Co.,Ltd"],
      "0009F6" => ["Shenzhen", "Shenzhen Eastern Digital Tech Ltd."],
      "0009F7" => ["SedADivi", "SED, a division of Calian"],
      "0009F8" => ["UnimoTec", "UNIMO TECHNOLOGY CO., LTD."],
      "0009F9" => ["ArtJapan", "ART JAPAN CO., LTD."],
      "0009FB" => ["PhilipsP", "Philips Patient Monitoring"],
      "0009FC" => ["Ipflex", "IPFLEX Inc."],
      "0009FD" => ["Ubinetic", "Ubinetics Limited"],
      "0009FE" => ["DaisyTec", "Daisy Technologies, Inc."],
      "0009FF" => ["XNet2000", "X.net 2000 GmbH"],
      "000A00" => ["Mediatek", "Mediatek Corp."],
      "000A01" => ["Sohoware", "SOHOware, Inc."],
      "000A02" => ["Annso", "ANNSO CO., LTD."],
      "000A03" => ["EndesaSe", "ENDESA SERVICIOS, S.L."],
      "000A04" => ["3com", "3Com Ltd"],
      "000A05" => ["Widax", "Widax Corp."],
      "000A06" => ["TeledexL", "Teledex LLC"],
      "000A07" => ["Webwayon", "WebWayOne Ltd"],
      "000A08" => ["AlpineEl", "ALPINE ELECTRONICS, INC."],
      "000A09" => ["TaracomI", "TaraCom Integrated Products, Inc."],
      "000A0A" => ["Sunix", "SUNIX Co., Ltd."],
      "000A0B" => ["Sealevel", "Sealevel Systems, Inc."],
      "000A0C" => ["Scientif", "Scientific Research Corporation"],
      "000A0D" => ["FciDeuts", "FCI Deutschland GmbH"],
      "000A0E" => ["InvivoRe", "Invivo Research Inc."],
      "000A0F" => ["IlryungT", "Ilryung Telesys, Inc"],
      "000A10" => ["FastMedi", "FAST media integrations AG"],
      "000A11" => ["ExpetTec", "ExPet Technologies, Inc"],
      "000A12" => ["AzylexTe", "Azylex Technology, Inc"],
      "000A13" => ["Honeywel", "Honeywell Video Systems"],
      "000A14" => ["TecoAS", "TECO a.s."],
      "000A15" => ["SiliconD", "Silicon Data, Inc"],
      "000A16" => ["LassenRe", "Lassen Research"],
      "000A17" => ["NestarCo", "NESTAR COMMUNICATIONS, INC"],
      "000A18" => ["Vichel", "Vichel Inc."],
      "000A19" => ["ValerePo", "Valere Power, Inc."],
      "000A1A" => ["Imerge", "Imerge Ltd"],
      "000A1B" => ["StreamLa", "Stream Labs"],
      "000A1C" => ["BridgeIn", "Bridge Information Co., Ltd."],
      "000A1D" => ["OpticalC", "Optical Communications Products Inc."],
      "000A1E" => ["Red-MPro", "Red-M Products Limited"],
      "000A1F" => ["ArtWareT", "ART WARE Telecommunication Co., Ltd."],
      "000A20" => ["SvaNetwo", "SVA Networks, Inc."],
      "000A21" => ["IntegraT", "Integra Telecom Co. Ltd"],
      "000A22" => ["Amperion", "Amperion Inc"],
      "000A23" => ["ParamaNe", "Parama Networks Inc"],
      "000A24" => ["OctaveCo", "Octave Communications"],
      "000A25" => ["CeragonN", "CERAGON NETWORKS"],
      "000A26" => ["CeiaSPA", "CEIA S.p.A."],
      "000A27" => ["AppleCom", "Apple Computer, Inc."],
      "000A28" => ["Motorola",""],
      "000A29" => ["PanDacom", "Pan Dacom Networking AG"],
      "000A2A" => ["Qsi", "QSI Systems Inc."],
      "000A2B" => ["Etherstu", "Etherstuff"],
      "000A2C" => ["ActiveTc", "Active Tchnology Corporation"],
      "000A2D" => ["CabotCom", "Cabot Communications Limited"],
      "000A2E" => ["MapleNet", "MAPLE NETWORKS CO., LTD"],
      "000A2F" => ["Artnix", "Artnix Inc."],
      "000A30" => ["JohnsonC", "Johnson Controls-ASG"],
      "000A31" => ["HcvConsu", "HCV Consulting"],
      "000A32" => ["Xsido", "Xsido Corporation"],
      "000A33" => ["Emulex", "Emulex Corporation"],
      "000A34" => ["Identica", "Identicard Systems Incorporated"],
      "000A35" => ["Xilinx",""],
      "000A36" => ["SynelecT", "Synelec Telecom Multimedia"],
      "000A37" => ["ProceraN", "Procera Networks, Inc."],
      "000A38" => ["ApaniNet", "Apani Networks"],
      "000A39" => ["LopaInfo", "LoPA Information Technology"],
      "000A3A" => ["J-ThreeI", "J-THREE INTERNATIONAL Holding Co., Ltd."],
      "000A3B" => ["GctSemic", "GCT Semiconductor, Inc"],
      "000A3C" => ["Enerpoin", "Enerpoint Ltd."],
      "000A3D" => ["EloSiste", "Elo Sistemas Eletronicos S.A."],
      "000A3E" => ["EadsTele", "EADS Telecom"],
      "000A3F" => ["DataEast", "Data East Corporation"],
      "000A40" => ["CrownAud", "Crown Audio -- Harmanm International"],
      "000A41" => ["Cisco", "Cisco Systems"],
      "000A42" => ["Cisco", "Cisco Systems"],
      "000A43" => ["Chunghwa", "Chunghwa Telecom Co., Ltd."],
      "000A44" => ["AveryDen", "Avery Dennison Deutschland GmbH"],
      "000A45" => ["Audio-Te", "Audio-Technica Corp."],
      "000A46" => ["AroWeldi", "ARO WELDING TECHNOLOGIES SAS"],
      "000A47" => ["AlliedVi", "Allied Vision Technologies"],
      "000A48" => ["Albatron", "Albatron Technology"],
      "000A49" => ["F5Networ", "F5 Networks, Inc."],
      "000A4A" => ["Targa", "Targa Systems Ltd."],
      "000A4B" => ["Datapowe", "DataPower Technology, Inc."],
      "000A4C" => ["Molecula", "Molecular Devices Corporation"],
      "000A4D" => ["Noritz", "Noritz Corporation"],
      "000A4E" => ["UnitekEl", "UNITEK Electronics INC."],
      "000A4F" => ["BrainBox", "Brain Boxes Limited"],
      "000A50" => ["Remotek", "REMOTEK CORPORATION"],
      "000A51" => ["Gyrosign", "GyroSignal Technology Co., Ltd."],
      "000A52" => ["Asiarf", "AsiaRF Ltd."],
      "000A53" => ["Intronic", "Intronics, Incorporated"],
      "000A54" => ["LagunaHi", "Laguna Hills, Inc."],
      "000A55" => ["Markem", "MARKEM Corporation"],
      "000A56" => ["HitachiM", "HITACHI Maxell Ltd."],
      "000A57" => ["Hewlett-", "Hewlett-Packard Company - Standards"],
      "000A58" => ["Ingenieu", "Ingenieur-Buero Freyer & Siegel"],
      "000A59" => ["HwServer", "HW server"],
      "000A5A" => ["Greennet", "GreenNET Technologies Co.,Ltd."],
      "000A5B" => ["Power-On", "Power-One as"],
      "000A5C" => ["CarelSPA", "Carel s.p.a."],
      "000A5D" => ["PucFound", "PUC Founder (MSC) Berhad"],
      "000A5E" => ["3com", "3COM Corporation"],
      "000A5F" => ["Almedio", "almedio inc."],
      "000A60" => ["Autostar", "Autostar Technology Pte Ltd"],
      "000A61" => ["Cellinx", "Cellinx Systems Inc."],
      "000A62" => ["CrinisNe", "Crinis Networks, Inc."],
      "000A63" => ["Dhd", "DHD GmbH"],
      "000A64" => ["EracomTe", "Eracom Technologies"],
      "000A65" => ["Gentechm", "GentechMedia.co.,ltd."],
      "000A66" => ["Mitsubis", "MITSUBISHI ELECTRIC SYSTEM & SERVICE CO.,LTD."],
      "000A67" => ["Ongcorp",""],
      "000A68" => ["Solarfla", "SolarFlare Communications, Inc."],
      "000A69" => ["SunnyBel", "SUNNY bell Technology Co., Ltd."],
      "000A6A" => ["SvmMicro", "SVM Microwaves s.r.o."],
      "000A6B" => ["TadiranT", "Tadiran Telecom Business Systems LTD"],
      "000A6C" => ["Walchem", "Walchem Corporation"],
      "000A6D" => ["EksElekt", "EKS Elektronikservice GmbH"],
      "000A6E" => ["Broadcas", "Broadcast Technology Limited"],
      "000A6F" => ["ZyflexTe", "ZyFLEX Technologies Inc"],
      "000A70" => ["MplsForu", "MPLS Forum"],
      "000A71" => ["AvrioTec", "Avrio Technologies, Inc"],
      "000A72" => ["Stec", "STEC, INC."],
      "000A73" => ["Scientif", "Scientific Atlanta"],
      "000A74" => ["Manticom", "Manticom Networks Inc."],
      "000A75" => ["Caterpil", "Caterpillar, Inc"],
      "000A76" => ["BeidaJad", "Beida Jade Bird Huaguang Technology Co.,Ltd"],
      "000A77" => ["Bluewire", "Bluewire Technologies LLC"],
      "000A78" => ["Olitec",""],
      "000A79" => ["AlliedTe", "Allied Telesis K.K. corega division"],
      "000A7A" => ["Kyoritsu", "Kyoritsu Electric Co., Ltd."],
      "000A7B" => ["Corneliu", "Cornelius Consult"],
      "000A7C" => ["Tecton", "Tecton Ltd"],
      "000A7D" => ["Valo", "Valo, Inc."],
      "000A7E" => ["Advantag", "The Advantage Group"],
      "000A7F" => ["TeradonI", "Teradon Industries, Inc"],
      "000A80" => ["Telkonet", "Telkonet Inc."],
      "000A81" => ["TeimaAud", "TEIMA Audiotex S.L."],
      "000A82" => ["TatsutaS", "TATSUTA SYSTEM ELECTRONICS CO.,LTD."],
      "000A83" => ["SaltoSL", "SALTO SYSTEMS S.L."],
      "000A84" => ["RainsunE", "Rainsun Enterprise Co., Ltd."],
      "000A85" => ["PlatC2", "PLAT\'C2,Inc"],
      "000A86" => ["Lenze",""],
      "000A87" => ["Integrat", "Integrated Micromachines Inc."],
      "000A88" => ["Incypher", "InCypher S.A."],
      "000A89" => ["Creval", "Creval Systems, Inc."],
      "000A8A" => ["Cisco", "Cisco Systems"],
      "000A8B" => ["Cisco", "Cisco Systems"],
      "000A8C" => ["Guardwar", "Guardware Systems Ltd."],
      "000A8D" => ["Eurother", "EUROTHERM LIMITED"],
      "000A8E" => ["Invacom", "Invacom Ltd"],
      "000A8F" => ["AskaInte", "Aska International Inc."],
      "000A90" => ["BaysideI", "Bayside Interactive, Inc."],
      "000A91" => ["Hemocue", "HemoCue AB"],
      "000A92" => ["Presonus", "Presonus Corporation"],
      "000A93" => ["W2Networ", "W2 Networks, Inc."],
      "000A94" => ["Shanghai", "ShangHai cellink CO., LTD"],
      "000A95" => ["AppleCom", "Apple Computer, Inc."],
      "000A96" => ["MewtelTe", "MEWTEL TECHNOLOGY INC."],
      "000A97" => ["Sonicblu", "SONICblue, Inc."],
      "000A98" => ["M+FGwinn", "M+F Gwinner GmbH & Co"],
      "000A99" => ["CalampWi", "Calamp Wireless Networks Inc"],
      "000A9A" => ["AiptekIn", "Aiptek International Inc"],
      "000A9B" => ["TbGroup", "TB Group Inc"],
      "000A9C" => ["ServerTe", "Server Technology, Inc."],
      "000A9D" => ["KingYoun", "King Young Technology Co. Ltd."],
      "000A9E" => ["Broadweb", "BroadWeb Corportation"],
      "000A9F" => ["Pannaway", "Pannaway Technologies, Inc."],
      "000AA0" => ["CedarPoi", "Cedar Point Communications"],
      "000AA1" => ["VVS", "V V S Limited"],
      "000AA2" => ["Systek", "SYSTEK INC."],
      "000AA3" => ["Shimafuj", "SHIMAFUJI ELECTRIC CO.,LTD."],
      "000AA4" => ["Shanghai", "SHANGHAI SURVEILLANCE TECHNOLOGY CO,LTD"],
      "000AA5" => ["MaxlinkI", "MAXLINK INDUSTRIES LIMITED"],
      "000AA6" => ["Hochiki", "Hochiki Corporation"],
      "000AA7" => ["FeiElect", "FEI Electron Optics"],
      "000AA8" => ["EpipePty", "ePipe Pty. Ltd."],
      "000AA9" => ["BrooksAu", "Brooks Automation GmbH"],
      "000AAA" => ["AltigenC", "AltiGen Communications Inc."],
      "000AAB" => ["ToyotaTe", "Toyota Technical Development Corporation"],
      "000AAC" => ["Terratec", "TerraTec Electronic GmbH"],
      "000AAD" => ["Stargame", "Stargames Corporation"],
      "000AAE" => ["Rosemoun", "Rosemount Process Analytical"],
      "000AAF" => ["Pipal", "Pipal Systems"],
      "000AB0" => ["LoytecEl", "LOYTEC electronics GmbH"],
      "000AB1" => ["Genetec", "GENETEC Corporation"],
      "000AB2" => ["FresnelW", "Fresnel Wireless Systems"],
      "000AB3" => ["FaGira", "Fa. GIRA"],
      "000AB4" => ["EticTele", "ETIC Telecommunications"],
      "000AB5" => ["DigitalE", "Digital Electronic Network"],
      "000AB6" => ["Compunet", "COMPUNETIX, INC"],
      "000AB7" => ["Cisco", "Cisco Systems"],
      "000AB8" => ["Cisco", "Cisco Systems"],
      "000AB9" => ["AsteraTe", "Astera Technologies Corp."],
      "000ABA" => ["ArconTec", "Arcon Technology Limited"],
      "000ABB" => ["TaiwanSe", "Taiwan Secom Co,. Ltd"],
      "000ABC" => ["Seabridg", "Seabridge Ltd."],
      "000ABD" => ["Rupprech", "Rupprecht & Patashnick Co."],
      "000ABE" => ["OpnetTec", "OPNET Technologies CO., LTD."],
      "000ABF" => ["HirotaSs", "HIROTA SS"],
      "000AC0" => ["FuyohVid", "Fuyoh Video Industry CO., LTD."],
      "000AC1" => ["Futurete", "Futuretel"],
      "000AC2" => ["Fiberhom", "FiberHome Telecommunication Technologies CO.,LTD"],
      "000AC3" => ["EmTechni", "eM Technics Co., Ltd."],
      "000AC4" => ["DaewooTe", "Daewoo Teletech Co., Ltd"],
      "000AC5" => ["ColorKin", "Color Kinetics"],
      "000AC6" => ["Overture", "Overture Networks."],
      "000AC7" => ["Unicatio", "Unication Group"],
      "000AC8" => ["ZpsysPla", "ZPSYS CO.,LTD. (Planning&Management)"],
      "000AC9" => ["Zambeel", "Zambeel Inc"],
      "000ACA" => ["Yokoyama", "YOKOYAMA SHOKAI CO.,Ltd."],
      "000ACB" => ["XpakMsaG", "XPAK MSA Group"],
      "000ACC" => ["WinnowNe", "Winnow Networks, Inc."],
      "000ACD" => ["SunrichT", "Sunrich Technology Limited"],
      "000ACE" => ["Radiante", "RADIANTECH, INC."],
      "000ACF" => ["Provideo", "PROVIDEO Multimedia Co. Ltd."],
      "000AD0" => ["NiigataD", "Niigata Develoment Center,  F.I.T. Co., Ltd."],
      "000AD1" => ["Mws",""],
      "000AD2" => ["Jepico", "JEPICO Corporation"],
      "000AD3" => ["Initech", "INITECH Co., Ltd"],
      "000AD4" => ["Corebell", "CoreBell Systems Inc."],
      "000AD5" => ["Brainchi", "Brainchild Electronic Co., Ltd."],
      "000AD6" => ["Beamreac", "BeamReach Networks"],
      "000AD7" => ["OriginEl", "Origin ELECTRIC CO.,LTD."],
      "000AD8" => ["IpcservT", "IPCserv Technology Corp."],
      "000AD9" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "000ADA" => ["Vindicat", "Vindicator Technologies"],
      "000ADB" => ["Skypilot", "SkyPilot Network, Inc"],
      "000ADC" => ["Ruggedco", "RuggedCom Inc."],
      "000ADD" => ["Allworx", "Allworx Corp."],
      "000ADE" => ["HappyCom", "Happy Communication Co., Ltd."],
      "000ADF" => ["Gennum", "Gennum Corporation"],
      "000AE0" => ["FujitsuS", "Fujitsu Softek"],
      "000AE1" => ["EgTechno", "EG Technology"],
      "000AE2" => ["Binatone", "Binatone Electronics International, Ltd"],
      "000AE3" => ["YangMeiT", "YANG MEI TECHNOLOGY CO., LTD"],
      "000AE4" => ["Wistron", "Wistron Corp."],
      "000AE5" => ["Scottcar", "ScottCare Corporation"],
      "000AE6" => ["Elitegro", "Elitegroup Computer System Co. (ECS)"],
      "000AE7" => ["EliopSA", "ELIOP S.A."],
      "000AE8" => ["CathayRo", "Cathay Roxus Information Technology Co. LTD"],
      "000AE9" => ["AirvastT", "AirVast Technology Inc."],
      "000AEA" => ["AdamElek", "ADAM ELEKTRONIK LTD.STI."],
      "000AEB" => ["Shenzhen", "Shenzhen Tp-Link Technology Co; Ltd."],
      "000AEC" => ["KoatsuGa", "Koatsu Gas Kogyo Co., Ltd."],
      "000AED" => ["Harting", "HARTING Systems GmbH & Co KG"],
      "000AEE" => ["GcdHard-", "GCD Hard- & Software GmbH"],
      "000AEF" => ["OtrumAsa", "OTRUM ASA"],
      "000AF0" => ["Shin-OhE", "SHIN-OH ELECTRONICS CO., LTD. R&D"],
      "000AF1" => ["ClarityD", "Clarity Design, Inc."],
      "000AF2" => ["Neoaxiom", "NeoAxiom Corp."],
      "000AF3" => ["Cisco", "Cisco Systems"],
      "000AF4" => ["Cisco", "Cisco Systems"],
      "000AF5" => ["AirgoNet", "Airgo Networks, Inc."],
      "000AF6" => ["EmersonC", "Emerson Climate Technologies Retail Solutions, Inc."],
      "000AF7" => ["Broadcom", "Broadcom Corp."],
      "000AF8" => ["American", "American Telecare Inc."],
      "000AF9" => ["Hiconnec", "HiConnect, Inc."],
      "000AFA" => ["Traverse", "Traverse Technologies Australia"],
      "000AFB" => ["Ambri", "Ambri Limited"],
      "000AFC" => ["CoreTecC", "Core Tec Communications, LLC"],
      "000AFD" => ["VikingEl", "Viking Electronic Services"],
      "000AFE" => ["Novapal", "NovaPal Ltd"],
      "000AFF" => ["Kilchher", "Kilchherr Elektronik AG"],
      "000B00" => ["FujianSt", "FUJIAN START COMPUTER EQUIPMENT CO.,LTD"],
      "000B01" => ["DaiichiE", "DAIICHI ELECTRONICS CO., LTD."],
      "000B02" => ["Dallmeie", "Dallmeier electronic"],
      "000B03" => ["Taekwang", "Taekwang Industrial Co., Ltd"],
      "000B04" => ["Volktek", "Volktek Corporation"],
      "000B05" => ["PacificB", "Pacific Broadband Networks"],
      "000B06" => ["Motorola", "Motorola Mobility, Inc."],
      "000B07" => ["VoxpathN", "Voxpath Networks"],
      "000B08" => ["PillarDa", "Pillar Data Systems"],
      "000B09" => ["Ifoundry", "Ifoundry Systems Singapore"],
      "000B0A" => ["DbmOptic", "dBm Optics"],
      "000B0B" => ["Corrent", "Corrent Corporation"],
      "000B0C" => ["Agile", "Agile Systems Inc."],
      "000B0D" => ["Air2u", "Air2U, Inc."],
      "000B0E" => ["TrapezeN", "Trapeze Networks"],
      "000B0F" => ["BoschRex", "Bosch Rexroth"],
      "000B10" => ["11waveTe", "11wave Technonlogy Co.,Ltd"],
      "000B11" => ["HimejiAb", "HIMEJI ABC TRADING CO.,LTD."],
      "000B12" => ["NuriTele", "NURI Telecom Co., Ltd."],
      "000B13" => ["Zetron", "ZETRON INC"],
      "000B14" => ["Viewsoni", "ViewSonic Corporation"],
      "000B15" => ["Platypus", "Platypus Technology"],
      "000B16" => ["Communic", "Communication Machinery Corporation"],
      "000B17" => ["MksInstr", "MKS Instruments"],
      "000B18" => ["Private",""],
      "000B19" => ["VernierN", "Vernier Networks, Inc."],
      "000B1A" => ["Industri", "Industrial Defender, Inc."],
      "000B1B" => ["Systroni", "Systronix, Inc."],
      "000B1C" => ["SibcoBv", "SIBCO bv"],
      "000B1D" => ["Layerzer", "LayerZero Power Systems, Inc."],
      "000B1E" => ["KappaOpt", "KAPPA opto-electronics GmbH"],
      "000B1F" => ["IConComp", "I CON Computer Co."],
      "000B20" => ["Hirata", "Hirata corporation"],
      "000B21" => ["G-StarCo", "G-Star Communications Inc."],
      "000B22" => ["Environm", "Environmental Systems and Services"],
      "000B23" => ["SiemensS", "Siemens Subscriber Networks"],
      "000B24" => ["Airlogic",""],
      "000B25" => ["Aeluros",""],
      "000B26" => ["Wetek", "Wetek Corporation"],
      "000B27" => ["Scion", "Scion Corporation"],
      "000B28" => ["Quatech", "Quatech Inc."],
      "000B29" => ["LsLgIndu", "LS(LG) Industrial Systems co.,Ltd"],
      "000B2A" => ["Howtel", "HOWTEL Co., Ltd."],
      "000B2B" => ["Hostnet", "HOSTNET CORPORATION"],
      "000B2C" => ["EikiIndu", "Eiki Industrial Co. Ltd."],
      "000B2D" => ["Danfoss", "Danfoss Inc."],
      "000B2E" => ["Cal-Comp", "Cal-Comp Electronics (Thailand) Public Company Limited Taipe"],
      "000B2F" => ["Bplan", "bplan GmbH"],
      "000B30" => ["BeijingG", "Beijing Gongye Science & Technology Co.,Ltd"],
      "000B31" => ["YantaiZh", "Yantai ZhiYang Scientific and technology industry CO., LTD"],
      "000B32" => ["Vormetri", "VORMETRIC, INC."],
      "000B33" => ["VivatoTe", "Vivato Technologies"],
      "000B34" => ["Shanghai", "ShangHai Broadband Technologies CO.LTD"],
      "000B35" => ["QuadBitS", "Quad Bit System co., Ltd."],
      "000B36" => ["Producti", "Productivity Systems, Inc."],
      "000B37" => ["Manufact", "MANUFACTURE DES MONTRES ROLEX SA"],
      "000B38" => ["Knuerr", "Knuerr GmbH"],
      "000B39" => ["KeisokuG", "Keisoku Giken Co.,Ltd."],
      "000B3A" => ["Qustream", "QuStream Corporation"],
      "000B3B" => ["Devolo", "devolo AG"],
      "000B3C" => ["CygnalIn", "Cygnal Integrated Products, Inc."],
      "000B3D" => ["ContalOk", "CONTAL OK Ltd."],
      "000B3E" => ["Bittware", "BittWare, Inc"],
      "000B3F" => ["Antholog", "Anthology Solutions Inc."],
      "000B40" => ["Opnext", "OpNext Inc."],
      "000B41" => ["IngBuero", "Ing. Buero Dr. Beutlhauser"],
      "000B42" => ["Commax", "commax Co., Ltd."],
      "000B43" => ["Microsca", "Microscan Systems, Inc."],
      "000B44" => ["ConcordI", "Concord IDea Corp."],
      "000B45" => ["Cisco",""],
      "000B46" => ["Cisco",""],
      "000B47" => ["Advanced", "Advanced Energy"],
      "000B48" => ["Sofrel",""],
      "000B49" => ["Rf-LinkS", "RF-Link System Inc."],
      "000B4A" => ["Visimetr", "Visimetrics (UK) Ltd"],
      "000B4B" => ["Visiowav", "VISIOWAVE SA"],
      "000B4C" => ["ClarionM", "Clarion (M) Sdn Bhd"],
      "000B4D" => ["Emuzed",""],
      "000B4E" => ["Vertexrs", "VertexRSI, General Dynamics SatCOM Technologies, Inc."],
      "000B4F" => ["Verifone", "Verifone, INC."],
      "000B50" => ["Oxygnet",""],
      "000B51" => ["MicetekI", "Micetek International Inc."],
      "000B52" => ["JoymaxEl", "JOYMAX ELECTRONICS CO. LTD."],
      "000B53" => ["Initium", "INITIUM Co., Ltd."],
      "000B54" => ["Bitmicro", "BiTMICRO Networks, Inc."],
      "000B55" => ["Adinstru", "ADInstruments"],
      "000B56" => ["Cybernet", "Cybernetics"],
      "000B57" => ["SiliconL", "Silicon Laboratories"],
      "000B58" => ["Astronau", "Astronautics C.A  LTD"],
      "000B59" => ["Scriptpr", "ScriptPro, LLC"],
      "000B5A" => ["Hyperedg", "HyperEdge"],
      "000B5B" => ["RinconRe", "Rincon Research Corporation"],
      "000B5C" => ["Newtech", "Newtech Co.,Ltd"],
      "000B5D" => ["Fujitsu", "FUJITSU LIMITED"],
      "000B5E" => ["AudioEng", "Audio Engineering Society Inc."],
      "000B5F" => ["Cisco", "Cisco Systems"],
      "000B60" => ["Cisco", "Cisco Systems"],
      "000B61" => ["Friedric", "Friedrich LAtze GmbH &Co."],
      "000B62" => ["Ingenieu", "Ingenieurbuero fuer Elektronikdesign Ingo Mohnen"],
      "000B63" => ["Kaleides", "Kaleidescape"],
      "000B64" => ["KiebackP", "Kieback & Peter GmbH & Co KG"],
      "000B65" => ["SyACSrl", "Sy.A.C. srl"],
      "000B66" => ["Teralink", "Teralink Communications"],
      "000B67" => ["TopviewT", "Topview Technology Corporation"],
      "000B68" => ["Addvalue", "Addvalue Communications Pte Ltd"],
      "000B69" => ["FrankeFi", "Franke Finland Oy"],
      "000B6A" => ["Asiarock", "Asiarock Incorporation"],
      "000B6B" => ["WistronN", "Wistron Neweb Corp."],
      "000B6C" => ["Sychip", "Sychip Inc."],
      "000B6D" => ["Solectro", "SOLECTRON JAPAN NAKANIIDA"],
      "000B6E" => ["NeffInst", "Neff Instrument Corp."],
      "000B6F" => ["MediaStr", "Media Streaming Networks Inc"],
      "000B70" => ["LoadTech", "Load Technology, Inc."],
      "000B71" => ["Litchfie", "Litchfield Communications Inc."],
      "000B72" => ["Lawo", "Lawo AG"],
      "000B73" => ["KodeosCo", "Kodeos Communications"],
      "000B74" => ["Kingwave", "Kingwave Technology Co., Ltd."],
      "000B75" => ["Iosoft", "Iosoft Ltd."],
      "000B76" => ["Et&TTech", "ET&T Technology Co. Ltd."],
      "000B77" => ["Cogent", "Cogent Systems, Inc."],
      "000B78" => ["Taifatec", "TAIFATECH INC."],
      "000B79" => ["X-Com", "X-COM, Inc."],
      "000B7A" => ["WaveScie", "Wave Science Inc."],
      "000B7B" => ["Test-Um", "Test-Um Inc."],
      "000B7C" => ["TelexCom", "Telex Communications"],
      "000B7D" => ["SolomonE", "SOLOMON EXTREME INTERNATIONAL LTD."],
      "000B7E" => ["Saginomi", "SAGINOMIYA Seisakusho Inc."],
      "000B7F" => ["AlignEng", "Align Engineering LLC"],
      "000B80" => ["LyciumNe", "Lycium Networks"],
      "000B81" => ["Kaparel", "Kaparel Corporation"],
      "000B82" => ["Grandstr", "Grandstream Networks, Inc."],
      "000B83" => ["Datawatt", "DATAWATT B.V."],
      "000B84" => ["Bodet",""],
      "000B85" => ["Cisco", "Cisco Systems"],
      "000B86" => ["ArubaNet", "Aruba Networks"],
      "000B87" => ["American", "American Reliance Inc."],
      "000B88" => ["Vidisco", "Vidisco ltd."],
      "000B89" => ["TopGloba", "Top Global Technology, Ltd."],
      "000B8A" => ["Miteq", "MITEQ Inc."],
      "000B8B" => ["KerajetS", "KERAJET, S.A."],
      "000B8C" => ["Flextron", "Flextronics"],
      "000B8D" => ["AvvioNet", "Avvio Networks"],
      "000B8E" => ["Ascent", "Ascent Corporation"],
      "000B8F" => ["AkitaEle", "AKITA ELECTRONICS SYSTEMS CO.,LTD."],
      "000B90" => ["AdvaOpti", "Adva Optical Networking Inc."],
      "000B91" => ["AglaiaGe", "Aglaia Gesellschaft fur Bildverarbeitung und Kommunikation m"],
      "000B92" => ["AscomDan", "Ascom Danmark A/S"],
      "000B93" => ["RitterEl", "Ritter Elektronik"],
      "000B94" => ["DigitalM", "Digital Monitoring Products, Inc."],
      "000B95" => ["EbetGami", "eBet Gaming Systems Pty Ltd"],
      "000B96" => ["Innotrac", "Innotrac Diagnostics Oy"],
      "000B97" => ["Matsushi", "Matsushita Electric Industrial Co.,Ltd."],
      "000B98" => ["Nicetech", "NiceTechVision"],
      "000B99" => ["Sensable", "SensAble Technologies, Inc."],
      "000B9A" => ["Shanghai", "Shanghai Ulink Telecom Equipment Co. Ltd."],
      "000B9B" => ["SiriusSy", "Sirius System Co, Ltd."],
      "000B9C" => ["TribeamT", "TriBeam Technologies, Inc."],
      "000B9D" => ["TwinmosT", "TwinMOS Technologies Inc."],
      "000B9E" => ["YasingTe", "Yasing Technology Corp."],
      "000B9F" => ["NeueElsa", "Neue ELSA GmbH"],
      "000BA0" => ["T&LInfor", "T&L Information Inc."],
      "000BA1" => ["Syscom", "SYSCOM Ltd."],
      "000BA2" => ["Sumitomo", "Sumitomo Electric Networks, Inc"],
      "000BA3" => ["SiemensI", "Siemens AG, I&S"],
      "000BA4" => ["ShironSa", "Shiron Satellite Communications Ltd. (1996)"],
      "000BA5" => ["QuasarCi", "Quasar Cipta Mandiri, PT"],
      "000BA6" => ["Miyakawa", "Miyakawa Electric Works Ltd."],
      "000BA7" => ["MarantiN", "Maranti Networks"],
      "000BA8" => ["HanbackE", "HANBACK ELECTRONICS CO., LTD."],
      "000BA9" => ["Cloudshi", "CloudShield Technologies, Inc."],
      "000BAA" => ["Aiphone", "Aiphone co.,Ltd"],
      "000BAB" => ["Advantec", "Advantech Technology (CHINA) Co., Ltd."],
      "000BAC" => ["3com", "3Com Ltd"],
      "000BAD" => ["Pc-Pos", "PC-PoS Inc."],
      "000BAE" => ["VitalsSy", "Vitals System Inc."],
      "000BAF" => ["WoojuCom", "WOOJU COMMUNICATIONS Co,.Ltd"],
      "000BB0" => ["SysnetTe", "Sysnet Telematica srl"],
      "000BB1" => ["SuperSta", "Super Star Technology Co., Ltd."],
      "000BB2" => ["Smallbig", "SMALLBIG TECHNOLOGY"],
      "000BB3" => ["RitTechn", "RiT technologies Ltd."],
      "000BB4" => ["RdcSemic", "RDC Semiconductor Inc.,"],
      "000BB5" => ["NstorTec", "nStor Technologies, Inc."],
      "000BB6" => ["Metallig", "Metalligence Technology Corp."],
      "000BB7" => ["Micro", "Micro Systems Co.,Ltd."],
      "000BB8" => ["KihokuEl", "Kihoku Electronic Co."],
      "000BB9" => ["Imsys", "Imsys AB"],
      "000BBA" => ["Harmonic", "Harmonic Broadband Access Networks"],
      "000BBB" => ["Etin", "Etin Systems Co., Ltd"],
      "000BBC" => ["EnGarde", "En Garde Systems, Inc."],
      "000BBD" => ["Connexio", "Connexionz Limited"],
      "000BBE" => ["Cisco", "Cisco Systems"],
      "000BBF" => ["Cisco", "Cisco Systems"],
      "000BC0" => ["ChinaIwn", "China IWNComm Co., Ltd."],
      "000BC1" => ["BayMicro", "Bay Microsystems, Inc."],
      "000BC2" => ["CorinexC", "Corinex Communication Corp."],
      "000BC3" => ["Multiple", "Multiplex, Inc."],
      "000BC4" => ["Biotroni", "BIOTRONIK GmbH & Co"],
      "000BC5" => ["SmcNetwo", "SMC Networks, Inc."],
      "000BC6" => ["Isac", "ISAC, Inc."],
      "000BC7" => ["IcetSPA", "ICET S.p.A."],
      "000BC8" => ["AirflowN", "AirFlow Networks"],
      "000BC9" => ["Electrol", "Electroline Equipment"],
      "000BCA" => ["DatavanI", "DATAVAN International Corporation"],
      "000BCB" => ["FagorAut", "Fagor Automation , S. Coop"],
      "000BCC" => ["JusanSA", "JUSAN, S.A."],
      "000BCD" => ["Hewlett-", "Hewlett-Packard Company"],
      "000BCE" => ["Free2mov", "Free2move AB"],
      "000BCF" => ["AgfaNdt", "AGFA NDT INC."],
      "000BD0" => ["XimetaTe", "XiMeta Technology Americas Inc."],
      "000BD1" => ["Aeronix", "Aeronix, Inc."],
      "000BD2" => ["RemoproT", "Remopro Technology Inc."],
      "000BD3" => ["Cd3o",""],
      "000BD4" => ["BeijingW", "Beijing Wise Technology & Science Development Co.Ltd"],
      "000BD5" => ["Nvergenc", "Nvergence, Inc."],
      "000BD6" => ["PaxtonAc", "Paxton Access Ltd"],
      "000BD7" => ["DormaTim", "DORMA Time + Access GmbH"],
      "000BD8" => ["Industri", "Industrial Scientific Corp."],
      "000BD9" => ["GeneralH", "General Hydrogen"],
      "000BDA" => ["Eyecross", "EyeCross Co.,Inc."],
      "000BDB" => ["DellEsgP", "Dell ESG PCBA Test"],
      "000BDC" => ["Akcp",""],
      "000BDD" => ["TohokuRi", "TOHOKU RICOH Co., LTD."],
      "000BDE" => ["Teldix", "TELDIX GmbH"],
      "000BDF" => ["Shenzhen", "Shenzhen RouterD Networks Limited"],
      "000BE0" => ["Serconet", "SercoNet Ltd."],
      "000BE1" => ["NokiaNet", "Nokia NET Product Operations"],
      "000BE2" => ["Lumenera", "Lumenera Corporation"],
      "000BE3" => ["KeyStrea", "Key Stream Co., Ltd."],
      "000BE4" => ["Hosiden", "Hosiden Corporation"],
      "000BE5" => ["HimsKore", "HIMS Korea Co., Ltd."],
      "000BE6" => ["DatelEle", "Datel Electronics"],
      "000BE7" => ["ComfluxT", "COMFLUX TECHNOLOGY INC."],
      "000BE8" => ["Aoip",""],
      "000BE9" => ["Actel", "Actel Corporation"],
      "000BEA" => ["ZultysTe", "Zultys Technologies"],
      "000BEB" => ["Systegra", "Systegra AG"],
      "000BEC" => ["NipponEl", "NIPPON ELECTRIC INSTRUMENT, INC."],
      "000BED" => ["Elm", "ELM Inc."],
      "000BEE" => ["Jet", "inc.jet, Incorporated"],
      "000BEF" => ["Code", "Code Corporation"],
      "000BF0" => ["MotexPro", "MoTEX Products Co., Ltd."],
      "000BF1" => ["LapLaser", "LAP Laser Applikations"],
      "000BF2" => ["Chih-Kan", "Chih-Kan Technology Co., Ltd."],
      "000BF3" => ["Bae", "BAE SYSTEMS"],
      "000BF4" => ["Private",""],
      "000BF5" => ["Shanghai", "Shanghai Sibo Telecom Technology Co.,Ltd"],
      "000BF6" => ["Nitgen", "Nitgen Co., Ltd"],
      "000BF7" => ["Nidek", "NIDEK CO.,LTD"],
      "000BF8" => ["Infinera",""],
      "000BF9" => ["Gemstone", "Gemstone communications, Inc."],
      "000BFA" => ["ExemysSr", "EXEMYS SRL"],
      "000BFB" => ["D-NetInt", "D-NET International Corporation"],
      "000BFC" => ["Cisco", "Cisco Systems"],
      "000BFD" => ["Cisco", "Cisco Systems"],
      "000BFE" => ["CastelBr", "CASTEL Broadband Limited"],
      "000BFF" => ["Berkeley", "Berkeley Camera Engineering"],
      "000C00" => ["BebIndus", "BEB Industrie-Elektronik AG"],
      "000C01" => ["Abatron", "Abatron AG"],
      "000C02" => ["AbbOy", "ABB Oy"],
      "000C03" => ["HdmiLice", "HDMI Licensing, LLC"],
      "000C04" => ["Tecnova",""],
      "000C05" => ["RpaReser", "RPA Reserch Co., Ltd."],
      "000C06" => ["NixvuePt", "Nixvue Systems  Pte Ltd"],
      "000C07" => ["Iftest", "Iftest AG"],
      "000C08" => ["HumexTec", "HUMEX Technologies Corp."],
      "000C09" => ["HitachiI", "Hitachi IE Systems Co., Ltd"],
      "000C0A" => ["Guangdon", "Guangdong Province Electronic Technology Research Institute"],
      "000C0B" => ["Broadbus", "Broadbus Technologies"],
      "000C0C" => ["ApproTec", "APPRO TECHNOLOGY INC."],
      "000C0D" => ["Communic", "Communications & Power Industries / Satcom Division"],
      "000C0E" => ["Xtremesp", "XtremeSpectrum, Inc."],
      "000C0F" => ["Techno-O", "Techno-One Co., Ltd"],
      "000C10" => ["Pni", "PNI Corporation"],
      "000C11" => ["NipponDe", "NIPPON DEMPA CO.,LTD."],
      "000C12" => ["Micro-Op", "Micro-Optronic-Messtechnik GmbH"],
      "000C13" => ["Mediaq",""],
      "000C14" => ["Diagnost", "Diagnostic Instruments, Inc."],
      "000C15" => ["Cyberpow", "CyberPower Systems, Inc."],
      "000C16" => ["Concorde", "Concorde Microsystems Inc."],
      "000C17" => ["AjaVideo", "AJA Video Systems Inc"],
      "000C18" => ["ZenisuKe", "Zenisu Keisoku Inc."],
      "000C19" => ["TelioCom", "Telio Communications GmbH"],
      "000C1A" => ["QuestTec", "Quest Technical Solutions Inc."],
      "000C1B" => ["Oracom", "ORACOM Co, Ltd."],
      "000C1C" => ["Microweb", "MicroWeb Co., Ltd."],
      "000C1D" => ["MettlerF", "Mettler & Fuchs AG"],
      "000C1E" => ["GlobalCa", "Global Cache"],
      "000C1F" => ["Glimmerg", "Glimmerglass Networks"],
      "000C20" => ["FiWin", "Fi WIn, Inc."],
      "000C21" => ["FacultyO", "Faculty of Science and Technology, Keio University"],
      "000C22" => ["DoubleDE", "Double D Electronics Ltd"],
      "000C23" => ["BeijingL", "Beijing Lanchuan Tech. Co., Ltd."],
      "000C24" => ["Anator",""],
      "000C25" => ["AlliedTe", "Allied Telesis Labs, Inc."],
      "000C26" => ["WeintekL", "Weintek Labs. Inc."],
      "000C27" => ["Sammy", "Sammy Corporation"],
      "000C28" => ["Rifatron",""],
      "000C29" => ["Vmware", "VMware, Inc."],
      "000C2A" => ["OcttelCo", "OCTTEL Communication Co., Ltd."],
      "000C2B" => ["EliasTec", "ELIAS Technology, Inc."],
      "000C2C" => ["Enwiser", "Enwiser Inc."],
      "000C2D" => ["Fullwave", "FullWave Technology Co., Ltd."],
      "000C2E" => ["OpenetIn", "Openet information technology(shenzhen) Co., Ltd."],
      "000C2F" => ["Seorimte", "SeorimTechnology Co.,Ltd."],
      "000C30" => ["Cisco",""],
      "000C31" => ["Cisco",""],
      "000C32" => ["AvionicD", "Avionic Design Development GmbH"],
      "000C33" => ["Compucas", "Compucase Enterprise Co. Ltd."],
      "000C34" => ["Vixen", "Vixen Co., Ltd."],
      "000C35" => ["KavoDent", "KaVo Dental GmbH & Co. KG"],
      "000C36" => ["SharpTak", "SHARP TAKAYA ELECTRONICS INDUSTRY CO.,LTD."],
      "000C37" => ["Geomatio", "Geomation, Inc."],
      "000C38" => ["Telcobri", "TelcoBridges Inc."],
      "000C39" => ["Sentinel", "Sentinel Wireless Inc."],
      "000C3A" => ["Oxance",""],
      "000C3B" => ["OrionEle", "Orion Electric Co., Ltd."],
      "000C3C" => ["Mediacho", "MediaChorus, Inc."],
      "000C3D" => ["Glsystec", "Glsystech Co., Ltd."],
      "000C3E" => ["CrestAud", "Crest Audio"],
      "000C3F" => ["CogentDe", "Cogent Defence & Security Networks,"],
      "000C40" => ["AltechCo", "Altech Controls"],
      "000C41" => ["Cisco-Li", "Cisco-Linksys"],
      "000C42" => ["Routerbo", "Routerboard.com"],
      "000C43" => ["RalinkTe", "Ralink Technology, Corp."],
      "000C44" => ["Automate", "Automated Interfaces, Inc."],
      "000C45" => ["Animatio", "Animation Technologies Inc."],
      "000C46" => ["AlliedTe", "Allied Telesyn Inc."],
      "000C47" => ["SkTelete", "SK Teletech(R&D Planning Team)"],
      "000C48" => ["Qostek", "QoStek Corporation"],
      "000C49" => ["Dangaard", "Dangaard Telecom RTC Division A/S"],
      "000C4A" => ["CygnusMi", "Cygnus Microsystems (P) Limited"],
      "000C4B" => ["CheopsEl", "Cheops Elektronik"],
      "000C4C" => ["ArcorAg&", "Arcor AG&Co."],
      "000C4D" => ["AcraCont", "ACRA CONTROL"],
      "000C4E" => ["WinbestT", "Winbest Technology CO,LT"],
      "000C4F" => ["UdtechJa", "UDTech Japan Corporation"],
      "000C50" => ["SeagateT", "Seagate Technology"],
      "000C51" => ["Scientif", "Scientific Technologies Inc."],
      "000C52" => ["Roll", "Roll Systems Inc."],
      "000C53" => ["Private",""],
      "000C54" => ["Pedestal", "Pedestal Networks, Inc"],
      "000C55" => ["Microlin", "Microlink Communications Inc."],
      "000C56" => ["MegatelC", "Megatel Computer (1986) Corp."],
      "000C57" => ["MackieEn", "MACKIE Engineering Services Belgium BVBA"],
      "000C58" => ["M&S", "M&S Systems"],
      "000C59" => ["IndymeEl", "Indyme Electronics, Inc."],
      "000C5A" => ["IbsmmInd", "IBSmm Industrieelektronik Multimedia"],
      "000C5B" => ["HanwangT", "HANWANG TECHNOLOGY CO.,LTD"],
      "000C5C" => ["GtnBV", "GTN Systems B.V."],
      "000C5D" => ["ChicTech", "CHIC TECHNOLOGY (CHINA) CORP."],
      "000C5E" => ["CalypsoM", "Calypso Medical"],
      "000C5F" => ["Avtec", "Avtec, Inc."],
      "000C60" => ["Acm", "ACM Systems"],
      "000C61" => ["AcTechDb", "AC Tech corporation DBA Advanced Digital"],
      "000C62" => ["AbbCewe-", "ABB AB, Cewe-Control"],
      "000C63" => ["ZenithEl", "Zenith Electronics Corporation"],
      "000C64" => ["X2MsaGro", "X2 MSA Group"],
      "000C65" => ["SuninTel", "Sunin Telecom"],
      "000C66" => ["ProntoNe", "Pronto Networks Inc"],
      "000C67" => ["OyoElect", "OYO ELECTRIC CO.,LTD"],
      "000C68" => ["Sigmatel", "SigmaTel, Inc."],
      "000C69" => ["National", "National Radio Astronomy Observatory"],
      "000C6A" => ["Mbari",""],
      "000C6B" => ["KurzIndu", "Kurz Industrie-Elektronik GmbH"],
      "000C6C" => ["ElgatoLl", "Elgato Systems LLC"],
      "000C6D" => ["Edwards", "Edwards Ltd."],
      "000C6E" => ["AsustekC", "ASUSTEK COMPUTER INC."],
      "000C6F" => ["AmtekSys", "Amtek system co.,LTD."],
      "000C70" => ["Acc", "ACC GmbH"],
      "000C71" => ["Wybron", "Wybron, Inc"],
      "000C72" => ["Tempearl", "Tempearl Industrial Co., Ltd."],
      "000C73" => ["TelsonEl", "TELSON ELECTRONICS CO., LTD"],
      "000C74" => ["Rivertec", "RIVERTEC CORPORATION"],
      "000C75" => ["Oriental", "Oriental integrated electronics. LTD"],
      "000C76" => ["Micro-St", "MICRO-STAR INTERNATIONAL CO., LTD."],
      "000C77" => ["LifeRaci", "Life Racing Ltd"],
      "000C78" => ["In-TechE", "In-Tech Electronics Limited"],
      "000C79" => ["ExtelCom", "Extel Communications P/L"],
      "000C7A" => ["Datarius", "DaTARIUS Technologies GmbH"],
      "000C7B" => ["AlphaPro", "ALPHA PROJECT Co.,Ltd."],
      "000C7C" => ["Internet", "Internet Information Image Inc."],
      "000C7D" => ["TeikokuE", "TEIKOKU ELECTRIC MFG. CO., LTD"],
      "000C7E" => ["Tellium", "Tellium Incorporated"],
      "000C7F" => ["Synertro", "synertronixx GmbH"],
      "000C80" => ["Opelcomm", "Opelcomm Inc."],
      "000C81" => ["Schneide", "Schneider Electric (Australia)"],
      "000C82" => ["NetworkT", "NETWORK TECHNOLOGIES INC"],
      "000C83" => ["LogicalS", "Logical Solutions"],
      "000C84" => ["Eazix", "Eazix, Inc."],
      "000C85" => ["Cisco", "Cisco Systems"],
      "000C86" => ["Cisco", "Cisco Systems"],
      "000C87" => ["Amd",""],
      "000C88" => ["ApacheMi", "Apache Micro Peripherals, Inc."],
      "000C89" => ["AcElectr", "AC Electric Vehicles, Ltd."],
      "000C8A" => ["Bose", "Bose Corporation"],
      "000C8B" => ["ConnectT", "Connect Tech Inc"],
      "000C8C" => ["Kodicom", "KODICOM CO.,LTD."],
      "000C8D" => ["MatrixVi", "MATRIX VISION GmbH"],
      "000C8E" => ["MentorEn", "Mentor Engineering Inc"],
      "000C8F" => ["NergalSR", "Nergal s.r.l."],
      "000C90" => ["Octasic", "Octasic Inc."],
      "000C91" => ["Riverhea", "Riverhead Networks Inc."],
      "000C92" => ["Wolfvisi", "WolfVision Gmbh"],
      "000C93" => ["Xeline", "Xeline Co., Ltd."],
      "000C94" => ["UnitedEl", "United Electronic Industries, Inc. (EUI)"],
      "000C95" => ["Primenet",""],
      "000C96" => ["Oqo", "OQO, Inc."],
      "000C97" => ["NvAdbTtv", "NV ADB TTV Technologies SA"],
      "000C98" => ["LetekCom", "LETEK Communications Inc."],
      "000C99" => ["HitelLin", "HITEL LINK Co.,Ltd"],
      "000C9A" => ["HitechEl", "Hitech Electronics Corp."],
      "000C9B" => ["EeSoluti", "EE Solutions, Inc"],
      "000C9C" => ["ChonghoI", "Chongho information & communications"],
      "000C9D" => ["AirwalkC", "AirWalk Communications, Inc."],
      "000C9E" => ["Memoryli", "MemoryLink Corp."],
      "000C9F" => ["Nke", "NKE Corporation"],
      "000CA0" => ["Storcase", "StorCase Technology, Inc."],
      "000CA1" => ["Sigmacom", "SIGMACOM Co., LTD."],
      "000CA2" => ["ScopusNe", "Scopus Network Technologies Ltd"],
      "000CA3" => ["RanchoTe", "Rancho Technology, Inc."],
      "000CA4" => ["Promptte", "Prompttec Product Management GmbH"],
      "000CA5" => ["NamanNz", "Naman NZ LTd"],
      "000CA6" => ["Mintera", "Mintera Corporation"],
      "000CA7" => ["MetroSuz", "Metro (Suzhou) Technologies Co., Ltd."],
      "000CA8" => ["GarudaNe", "Garuda Networks Corporation"],
      "000CA9" => ["Ebtron", "Ebtron Inc."],
      "000CAA" => ["CubicTra", "Cubic Transportation Systems Inc"],
      "000CAB" => ["CommendI", "COMMEND International"],
      "000CAC" => ["CitizenW", "Citizen Watch Co., Ltd."],
      "000CAD" => ["BtuInter", "BTU International"],
      "000CAE" => ["AilocomO", "Ailocom Oy"],
      "000CAF" => ["TriTerm", "TRI TERM CO.,LTD."],
      "000CB0" => ["StarSemi", "Star Semiconductor Corporation"],
      "000CB1" => ["SallandE", "Salland Engineering (Europe) BV"],
      "000CB2" => ["Comstar", "Comstar Co., Ltd."],
      "000CB3" => ["Round", "ROUND Co.,Ltd."],
      "000CB4" => ["Autocell", "AutoCell Laboratories, Inc."],
      "000CB5" => ["PremierT", "Premier Technolgies, Inc"],
      "000CB6" => ["NanjingS", "NANJING SEU MOBILE & INTERNET TECHNOLOGY CO.,LTD"],
      "000CB7" => ["NanjingH", "Nanjing Huazhuo Electronics Co., Ltd."],
      "000CB8" => ["Medion", "MEDION AG"],
      "000CB9" => ["Lea",""],
      "000CBA" => ["Jamex", "Jamex, Inc."],
      "000CBB" => ["Iskraeme", "ISKRAEMECO"],
      "000CBC" => ["Iscutum",""],
      "000CBD" => ["Interfac", "Interface Masters, Inc"],
      "000CBE" => ["Innomina", "Innominate Security Technologies AG"],
      "000CBF" => ["HolySton", "Holy Stone Ent. Co., Ltd."],
      "000CC0" => ["GeneraOy", "Genera Oy"],
      "000CC1" => ["CooperIn", "Cooper Industries Inc."],
      "000CC2" => ["Controln", "ControlNet (India) Private Limited"],
      "000CC3" => ["Bewan", "BeWAN systems"],
      "000CC4" => ["Tiptel", "Tiptel AG"],
      "000CC5" => ["Nextlink", "Nextlink Co., Ltd."],
      "000CC6" => ["Ka-RoEle", "Ka-Ro electronics GmbH"],
      "000CC7" => ["Intellig", "Intelligent Computer Solutions Inc."],
      "000CC8" => ["Xytronix", "Xytronix Research & Design, Inc."],
      "000CC9" => ["IlwooDat", "ILWOO DATA & TECHNOLOGY CO.,LTD"],
      "000CCA" => ["HitachiG", "Hitachi Global Storage Technologies"],
      "000CCB" => ["DesignCo", "Design Combus Ltd"],
      "000CCC" => ["Aeroscou", "Aeroscout Ltd."],
      "000CCD" => ["Iec-Tc57", "IEC - TC57"],
      "000CCE" => ["Cisco", "Cisco Systems"],
      "000CCF" => ["Cisco", "Cisco Systems"],
      "000CD0" => ["Symetrix",""],
      "000CD1" => ["SfomTech", "SFOM Technology Corp."],
      "000CD2" => ["Schaffne", "Schaffner EMV AG"],
      "000CD3" => ["PrettlEl", "Prettl Elektronik Radeberg GmbH"],
      "000CD4" => ["Positron", "Positron Public Safety Systems inc."],
      "000CD5" => ["Passave", "Passave Inc."],
      "000CD6" => ["PartnerT", "PARTNER TECH"],
      "000CD7" => ["Nallatec", "Nallatech Ltd"],
      "000CD8" => ["MKJuchhe", "M. K. Juchheim GmbH & Co"],
      "000CD9" => ["Itcare", "Itcare Co., Ltd"],
      "000CDA" => ["Freehand", "FreeHand Systems, Inc."],
      "000CDB" => ["BrocadeC", "Brocade Communications Systems, Inc"],
      "000CDC" => ["BecsTech", "BECS Technology, Inc"],
      "000CDD" => ["AosTechn", "AOS Technologies AG"],
      "000CDE" => ["AbbStotz", "ABB STOTZ-KONTAKT GmbH"],
      "000CDF" => ["PulnixAm", "PULNiX America, Inc"],
      "000CE0" => ["TrekDiag", "Trek Diagnostics Inc."],
      "000CE1" => ["OpenGrou", "The Open Group"],
      "000CE2" => ["Rolls-Ro", "Rolls-Royce"],
      "000CE3" => ["OptionIn", "Option International N.V."],
      "000CE4" => ["Neurocom", "NeuroCom International, Inc."],
      "000CE5" => ["Motorola", "Motorola Mobility, Inc."],
      "000CE6" => ["MeruNetw", "Meru Networks Inc"],
      "000CE7" => ["Mediatek", "MediaTek Inc."],
      "000CE8" => ["Guangzho", "GuangZhou AnJuBao Co., Ltd"],
      "000CE9" => ["Bloomber", "BLOOMBERG L.P."],
      "000CEA" => ["AphonaKo", "aphona Kommunikationssysteme"],
      "000CEB" => ["CnmpNetw", "CNMP Networks, Inc."],
      "000CEC" => ["Spectrac", "Spectracom Corp."],
      "000CED" => ["RealDigi", "Real Digital Media"],
      "000CEE" => ["Jp-Embed", "jp-embedded"],
      "000CEF" => ["OpenNetw", "Open Networks Engineering Ltd"],
      "000CF0" => ["MN", "M & N GmbH"],
      "000CF1" => ["Intel", "Intel Corporation"],
      "000CF2" => ["GamesaEA", "GAMESA EA LICA"],
      "000CF3" => ["CallImag", "CALL IMAGE SA"],
      "000CF4" => ["Akatsuki", "AKATSUKI ELECTRIC MFG.CO.,LTD."],
      "000CF5" => ["Infoexpr", "InfoExpress"],
      "000CF6" => ["SitecomE", "Sitecom Europe BV"],
      "000CF7" => ["NortelNe", "Nortel Networks"],
      "000CF8" => ["NortelNe", "Nortel Networks"],
      "000CF9" => ["IttFlygt", "ITT Flygt AB"],
      "000CFA" => ["Digital", "Digital Systems Corp"],
      "000CFB" => ["KoreaNet", "Korea Network Systems"],
      "000CFC" => ["S2ioTech", "S2io Technologies Corp"],
      "000CFD" => ["HyundaiI", "Hyundai ImageQuest Co.,Ltd."],
      "000CFE" => ["GrandEle", "Grand Electronic Co., Ltd"],
      "000CFF" => ["Mro-Tek", "MRO-TEK LIMITED"],
      "000D00" => ["SeawayNe", "Seaway Networks Inc."],
      "000D01" => ["P&EMicro", "P&E Microcomputer Systems, Inc."],
      "000D02" => ["NecAcces", "NEC AccessTechnica, Ltd."],
      "000D03" => ["Matrics", "Matrics, Inc."],
      "000D04" => ["FoxboroE", "Foxboro Eckardt Development GmbH"],
      "000D05" => ["Cybernet", "cybernet manufacturing inc."],
      "000D06" => ["Compulog", "Compulogic Limited"],
      "000D07" => ["CalrecAu", "Calrec Audio Ltd"],
      "000D08" => ["Abovecab", "AboveCable, Inc."],
      "000D09" => ["YuehuaZh", "Yuehua(Zhuhai) Electronic CO. LTD"],
      "000D0A" => ["Projecti", "Projectiondesign as"],
      "000D0B" => ["Buffalo", "Buffalo Inc."],
      "000D0C" => ["MdiSecur", "MDI Security Systems"],
      "000D0D" => ["Itsuppor", "ITSupported, LLC"],
      "000D0E" => ["Inqnet", "Inqnet Systems, Inc."],
      "000D0F" => ["Finlux", "Finlux Ltd"],
      "000D10" => ["Embedtro", "Embedtronics Oy"],
      "000D11" => ["Dentsply", "DENTSPLY - Gendex"],
      "000D12" => ["Axell", "AXELL Corporation"],
      "000D13" => ["WilhelmR", "Wilhelm Rutenbeck GmbH&Co."],
      "000D14" => ["VtechInn", "Vtech Innovation LP dba Advanced American Telephones"],
      "000D15" => ["VoipacSR", "Voipac s.r.o."],
      "000D16" => ["UhsPty", "UHS Systems Pty Ltd"],
      "000D17" => ["TurboNet", "Turbo Networks Co.Ltd"],
      "000D18" => ["Mega-Tre", "Mega-Trend Electronics CO., LTD."],
      "000D19" => ["RobeShow", "ROBE Show lighting"],
      "000D1A" => ["MustekSy", "Mustek System Inc."],
      "000D1B" => ["KyotoEle", "Kyoto Electronics Manufacturing Co., Ltd."],
      "000D1C" => ["AmesysDe", "Amesys Defense"],
      "000D1D" => ["High-Tek", "HIGH-TEK HARNESS ENT. CO., LTD."],
      "000D1E" => ["ControlT", "Control Techniques"],
      "000D1F" => ["AvDigita", "AV Digital"],
      "000D20" => ["Asahikas", "ASAHIKASEI TECHNOSYSTEM CO.,LTD."],
      "000D21" => ["Wiscore", "WISCORE Inc."],
      "000D22" => ["Unitroni", "Unitronics LTD"],
      "000D23" => ["SmartSol", "Smart Solution, Inc"],
      "000D24" => ["SentecE&", "SENTEC E&E CO., LTD."],
      "000D25" => ["Sanden", "SANDEN CORPORATION"],
      "000D26" => ["Primagra", "Primagraphics Limited"],
      "000D27" => ["Microple", "MICROPLEX Printware AG"],
      "000D28" => ["Cisco",""],
      "000D29" => ["Cisco",""],
      "000D2A" => ["Scanmati", "Scanmatic AS"],
      "000D2B" => ["RacalIns", "Racal Instruments"],
      "000D2C" => ["Patapsco", "Patapsco Designs Ltd"],
      "000D2D" => ["NctDeuts", "NCT Deutschland GmbH"],
      "000D2E" => ["Matsushi", "Matsushita Avionics Systems Corporation"],
      "000D2F" => ["AinCommT", "AIN Comm.Tech.Co., LTD"],
      "000D30" => ["IcefyreS", "IceFyre Semiconductor"],
      "000D31" => ["Compelle", "Compellent Technologies, Inc."],
      "000D32" => ["Dispense", "DispenseSource, Inc."],
      "000D33" => ["Prediwav", "Prediwave Corp."],
      "000D34" => ["ShellInt", "Shell International Exploration and Production, Inc."],
      "000D35" => ["PacInter", "PAC International Ltd"],
      "000D36" => ["WuHanRou", "Wu Han Routon Electronic Co., Ltd"],
      "000D37" => ["Wiplug",""],
      "000D38" => ["Nissin", "NISSIN INC."],
      "000D39" => ["NetworkE", "Network Electronics"],
      "000D3A" => ["Microsof", "Microsoft Corp."],
      "000D3B" => ["Microele", "Microelectronics Technology Inc."],
      "000D3C" => ["ITechDyn", "i.Tech Dynamic Ltd"],
      "000D3D" => ["Hammerhe", "Hammerhead Systems, Inc."],
      "000D3E" => ["ApluxCom", "APLUX Communications Ltd."],
      "000D3F" => ["VtiInstr", "VTI Instruments Corporation"],
      "000D40" => ["VerintLo", "Verint Loronix Video Solutions"],
      "000D41" => ["SiemensI", "Siemens AG ICM MP UC RD IT KLF1"],
      "000D42" => ["NewbestD", "Newbest Development Limited"],
      "000D43" => ["DrsTacti", "DRS Tactical Systems Inc."],
      "000D44" => ["AudioBu-", "Audio BU - Logitech"],
      "000D45" => ["TottoriS", "Tottori SANYO Electric Co., Ltd."],
      "000D46" => ["ParkerSs", "Parker SSD Drives"],
      "000D47" => ["Collex",""],
      "000D48" => ["AewinTec", "AEWIN Technologies Co., Ltd."],
      "000D49" => ["TritonOf", "Triton Systems of Delaware, Inc."],
      "000D4A" => ["SteagEta", "Steag ETA-Optik"],
      "000D4B" => ["RokuLlc", "Roku, LLC"],
      "000D4C" => ["OutlineE", "Outline Electronics Ltd."],
      "000D4D" => ["Ninelane", "Ninelanes"],
      "000D4E" => ["Ndr", "NDR Co.,LTD."],
      "000D4F" => ["Kenwood", "Kenwood Corporation"],
      "000D50" => ["GalazarN", "Galazar Networks"],
      "000D51" => ["Divr", "DIVR Systems, Inc."],
      "000D52" => ["ComartSy", "Comart system"],
      "000D53" => ["Beijing5", "Beijing 5w Communication Corp."],
      "000D54" => ["3com", "3Com Ltd"],
      "000D55" => ["SanycomT", "SANYCOM Technology Co.,Ltd"],
      "000D56" => ["DellPcba", "Dell PCBA Test"],
      "000D57" => ["FujitsuI", "Fujitsu I-Network Systems Limited."],
      "000D58" => ["Private",""],
      "000D59" => ["Amity", "Amity Systems, Inc."],
      "000D5A" => ["Tiesse", "Tiesse SpA"],
      "000D5B" => ["SmartEmp", "Smart Empire Investments Limited"],
      "000D5C" => ["RobertBo", "Robert Bosch GmbH, VT-ATMO"],
      "000D5D" => ["RaritanC", "Raritan Computer, Inc"],
      "000D5E" => ["NecPerso", "NEC Personal Products"],
      "000D5F" => ["Minds", "Minds Inc"],
      "000D60" => ["Ibm", "IBM Corp"],
      "000D61" => ["Giga-Byt", "Giga-Byte Technology Co., Ltd."],
      "000D62" => ["Funkwerk", "Funkwerk Dabendorf GmbH"],
      "000D63" => ["DentInst", "DENT Instruments, Inc."],
      "000D64" => ["ComagHan", "COMAG Handels AG"],
      "000D65" => ["Cisco", "Cisco Systems"],
      "000D66" => ["Cisco", "Cisco Systems"],
      "000D67" => ["BelairNe", "BelAir Networks Inc."],
      "000D68" => ["Vinci", "Vinci Systems, Inc."],
      "000D69" => ["Tmt&D", "TMT&D Corporation"],
      "000D6A" => ["RedwoodT", "Redwood Technologies LTD"],
      "000D6B" => ["Mita-Tek", "Mita-Teknik A/S"],
      "000D6C" => ["M-Audio",""],
      "000D6D" => ["K-TechDe", "K-Tech Devices Corp."],
      "000D6E" => ["K-Patent", "K-Patents Oy"],
      "000D6F" => ["Ember", "Ember Corporation"],
      "000D70" => ["Datamax", "Datamax Corporation"],
      "000D71" => ["Boca", "boca systems"],
      "000D72" => ["2wire", "2Wire, Inc"],
      "000D73" => ["Technica", "Technical Support, Inc."],
      "000D74" => ["SandNetw", "Sand Network Systems, Inc."],
      "000D75" => ["KobianPt", "Kobian Pte Ltd - Taiwan Branch"],
      "000D76" => ["HokutoDe", "Hokuto Denshi Co,. Ltd."],
      "000D77" => ["Falconst", "FalconStor Software"],
      "000D78" => ["Engineer", "Engineering & Security"],
      "000D79" => ["DynamicS", "Dynamic Solutions Co,.Ltd."],
      "000D7A" => ["DigattoA", "DiGATTO Asia Pacific Pte Ltd"],
      "000D7B" => ["Consensy", "Consensys Computers Inc."],
      "000D7C" => ["Codian", "Codian Ltd"],
      "000D7D" => ["Afco", "Afco Systems"],
      "000D7E" => ["Axiowave", "Axiowave Networks, Inc."],
      "000D7F" => ["MidasCom", "MIDAS  COMMUNICATION TECHNOLOGIES PTE LTD ( Foreign Branch)"],
      "000D80" => ["OnlineDe", "Online Development Inc"],
      "000D81" => ["Pepperl+", "Pepperl+Fuchs GmbH"],
      "000D82" => ["PhsSrl", "PHS srl"],
      "000D83" => ["Sanmina-", "Sanmina-SCI Hungary  Ltd."],
      "000D84" => ["Makus", "Makus Inc."],
      "000D85" => ["Tapwave", "Tapwave, Inc."],
      "000D86" => ["Huber+Su", "Huber + Suhner AG"],
      "000D87" => ["Elitegro", "Elitegroup Computer System Co. (ECS)"],
      "000D88" => ["D-Link", "D-Link Corporation"],
      "000D89" => ["BilsTech", "Bils Technology Inc"],
      "000D8A" => ["WinnersE", "Winners Electronics Co., Ltd."],
      "000D8B" => ["T&D", "T&D Corporation"],
      "000D8C" => ["Shanghai", "Shanghai Wedone Digital Ltd. CO."],
      "000D8D" => ["ProlinxC", "ProLinx Communication Gateways, Inc."],
      "000D8E" => ["KodenEle", "Koden Electronics Co., Ltd."],
      "000D8F" => ["KingTsus", "King Tsushin Kogyo Co., LTD."],
      "000D90" => ["FactumEl", "Factum Electronics AB"],
      "000D91" => ["EclipseH", "Eclipse (HQ Espana) S.L."],
      "000D92" => ["ArimaCom", "Arima Communication Corporation"],
      "000D93" => ["AppleCom", "Apple Computer"],
      "000D94" => ["AfarComm", "AFAR Communications,Inc"],
      "000D95" => ["Opti-Cel", "Opti-cell, Inc."],
      "000D96" => ["VteraTec", "Vtera Technology Inc."],
      "000D97" => ["TroposNe", "Tropos Networks, Inc."],
      "000D98" => ["SWACSchm", "S.W.A.C. Schmitt-Walter Automation Consult GmbH"],
      "000D99" => ["OrbitalS", "Orbital Sciences Corp.; Launch Systems Group"],
      "000D9A" => ["Infotec", "INFOTEC LTD"],
      "000D9B" => ["HeraeusE", "Heraeus Electro-Nite International N.V."],
      "000D9C" => ["Elan", "Elan GmbH & Co KG"],
      "000D9D" => ["Hewlett-", "Hewlett-Packard Company"],
      "000D9E" => ["TokudenO", "TOKUDEN OHIZUMI SEISAKUSYO Co.,Ltd."],
      "000D9F" => ["RfMicroD", "RF Micro Devices"],
      "000DA0" => ["NedapNV", "NEDAP N.V."],
      "000DA1" => ["MiraeIts", "MIRAE ITS Co.,LTD."],
      "000DA2" => ["InfrantT", "Infrant Technologies, Inc."],
      "000DA3" => ["Emerging", "Emerging Technologies Limited"],
      "000DA4" => ["DoschAma", "DOSCH & AMAND SYSTEMS AG"],
      "000DA5" => ["Fabric7", "Fabric7 Systems, Inc"],
      "000DA6" => ["Universa", "Universal Switching Corporation"],
      "000DA7" => ["Private",""],
      "000DA8" => ["Teletron", "Teletronics Technology Corporation"],
      "000DA9" => ["TEAMSL", "T.E.A.M. S.L."],
      "000DAA" => ["SATehnol", "S.A.Tehnology co.,Ltd."],
      "000DAB" => ["ParkerHa", "Parker Hannifin GmbH Electromechanical Division Europe"],
      "000DAC" => ["JapanCbm", "Japan CBM Corporation"],
      "000DAD" => ["Dataprob", "Dataprobe Inc"],
      "000DAE" => ["SamsungH", "SAMSUNG HEAVY INDUSTRIES CO., LTD."],
      "000DAF" => ["PlexusUk", "Plexus Corp (UK) Ltd"],
      "000DB0" => ["Olym-Tec", "Olym-tech Co.,Ltd."],
      "000DB1" => ["JapanNet", "Japan Network Service Co., Ltd."],
      "000DB2" => ["Ammasso", "Ammasso, Inc."],
      "000DB3" => ["SdoCommu", "SDO Communication Corperation"],
      "000DB4" => ["Netasq",""],
      "000DB5" => ["Globalsa", "GLOBALSAT TECHNOLOGY CORPORATION"],
      "000DB6" => ["Broadcom", "Broadcom Corporation"],
      "000DB7" => ["SankoEle", "SANKO ELECTRIC CO,.LTD"],
      "000DB8" => ["Schiller", "SCHILLER AG"],
      "000DB9" => ["PcEngine", "PC Engines GmbH"],
      "000DBA" => ["OceDocum", "Oce Document Technologies GmbH"],
      "000DBB" => ["NipponDe", "Nippon Dentsu Co.,Ltd."],
      "000DBC" => ["Cisco", "Cisco Systems"],
      "000DBD" => ["Cisco", "Cisco Systems"],
      "000DBE" => ["BelFuseE", "Bel Fuse Europe Ltd.,UK"],
      "000DBF" => ["TektoneS", "TekTone Sound & Signal Mfg., Inc."],
      "000DC0" => ["SpagatAs", "Spagat AS"],
      "000DC1" => ["Safeweb", "SafeWeb Inc"],
      "000DC2" => ["Private",""],
      "000DC3" => ["FirstCom", "First Communication, Inc."],
      "000DC4" => ["Emcore", "Emcore Corporation"],
      "000DC5" => ["Echostar", "EchoStar Global B.V."],
      "000DC6" => ["Digirose", "DigiRose Technology Co., Ltd."],
      "000DC7" => ["CosmicEn", "COSMIC ENGINEERING INC."],
      "000DC8" => ["Airmagne", "AirMagnet, Inc"],
      "000DC9" => ["ThalesEl", "THALES Elektronik Systeme GmbH"],
      "000DCA" => ["TaitElec", "Tait Electronics"],
      "000DCB" => ["Petcomko", "Petcomkorea Co., Ltd."],
      "000DCC" => ["Neosmart", "NEOSMART Corp."],
      "000DCD" => ["GroupeTx", "GROUPE TXCOM"],
      "000DCE" => ["DynavacT", "Dynavac Technology Pte Ltd"],
      "000DCF" => ["Cidra", "Cidra Corp."],
      "000DD0" => ["Tetratec", "TetraTec Instruments GmbH"],
      "000DD1" => ["Stryker", "Stryker Corporation"],
      "000DD2" => ["SimradOp", "Simrad Optronics ASA"],
      "000DD3" => ["SamwooTe", "SAMWOO Telecommunication Co.,Ltd."],
      "000DD4" => ["Symantec", "Symantec Corporation"],
      "000DD5" => ["ORiteTec", "O\'RITE TECHNOLOGY CO.,LTD"],
      "000DD6" => ["Iti", "ITI    LTD"],
      "000DD7" => ["Bright",""],
      "000DD8" => ["Bbn",""],
      "000DD9" => ["AntonPaa", "Anton Paar GmbH"],
      "000DDA" => ["AlliedTe", "ALLIED TELESIS K.K."],
      "000DDB" => ["AirwaveT", "AIRWAVE TECHNOLOGIES INC."],
      "000DDC" => ["Vac",""],
      "000DDD" => ["ProfA Lo", "PROFA LO TELRA ELEKTRONA K SANAYA  VE TA CARET A.Az."],
      "000DDE" => ["Joyteck", "Joyteck Co., Ltd."],
      "000DDF" => ["JapanIma", "Japan Image & Network Inc."],
      "000DE0" => ["Icpdas", "ICPDAS Co.,LTD"],
      "000DE1" => ["ControlP", "Control Products, Inc."],
      "000DE2" => ["CmzSiste", "CMZ Sistemi Elettronici"],
      "000DE3" => ["AtSweden", "AT Sweden AB"],
      "000DE4" => ["Diginics", "DIGINICS, Inc."],
      "000DE5" => ["SamsungT", "Samsung Thales"],
      "000DE6" => ["YoungboE", "YOUNGBO ENGINEERING CO.,LTD"],
      "000DE7" => ["Snap-OnO", "Snap-on OEM Group"],
      "000DE8" => ["NasacoEl", "Nasaco Electronics Pte. Ltd"],
      "000DE9" => ["Napatech", "Napatech Aps"],
      "000DEA" => ["KingtelT", "Kingtel Telecommunication Corp."],
      "000DEB" => ["Compxs", "CompXs Limited"],
      "000DEC" => ["Cisco", "Cisco Systems"],
      "000DED" => ["Cisco", "Cisco Systems"],
      "000DEE" => ["AndrewRf", "Andrew RF Power Amplifier Group"],
      "000DEF" => ["SocCoopB", "Soc. Coop. Bilanciai"],
      "000DF0" => ["QcomTech", "QCOM TECHNOLOGY INC."],
      "000DF1" => ["Ionix", "IONIX INC."],
      "000DF2" => ["Private",""],
      "000DF3" => ["AsmaxSol", "Asmax Solutions"],
      "000DF4" => ["Watertek", "Watertek Co."],
      "000DF5" => ["Teletron", "Teletronics International Inc."],
      "000DF6" => ["Technolo", "Technology Thesaurus Corp."],
      "000DF7" => ["SpaceDyn", "Space Dynamics Lab"],
      "000DF8" => ["OrgaKart", "ORGA Kartensysteme GmbH"],
      "000DF9" => ["Nds", "NDS Limited"],
      "000DFA" => ["MicroCon", "Micro Control Systems Ltd."],
      "000DFB" => ["Komax", "Komax AG"],
      "000DFC" => ["Itfor", "ITFOR Inc."],
      "000DFD" => ["HugesHi-", "Huges Hi-Tech Inc.,"],
      "000DFE" => ["Hauppaug", "Hauppauge Computer Works, Inc."],
      "000DFF" => ["Chenming", "CHENMING MOLD INDUSTRY CORP."],
      "000E00" => ["Atrie",""],
      "000E01" => ["AsipTech", "ASIP Technologies Inc."],
      "000E02" => ["Advantec", "Advantech AMT Inc."],
      "000E03" => ["Emulex",""],
      "000E04" => ["Cma/Micr", "CMA/Microdialysis AB"],
      "000E05" => ["Wireless", "WIRELESS MATRIX CORP."],
      "000E06" => ["TeamSimo", "Team Simoco Ltd"],
      "000E07" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "000E08" => ["CiscoLin", "Cisco Linksys LLC"],
      "000E09" => ["Shenzhen", "Shenzhen Coship Software Co.,LTD."],
      "000E0A" => ["SakumaDe", "SAKUMA DESIGN OFFICE"],
      "000E0B" => ["NetacTec", "Netac Technology Co., Ltd."],
      "000E0C" => ["Intel", "Intel Corporation"],
      "000E0D" => ["HeschSch", "HESCH Schroder GmbH"],
      "000E0E" => ["EsaElett", "ESA elettronica S.P.A."],
      "000E0F" => ["Ermme",""],
      "000E10" => ["C-Guys", "C-guys, Inc."],
      "000E11" => ["BdtBuro-", "BDT Buro- und Datentechnik GmbH & Co. KG"],
      "000E12" => ["Adaptive", "Adaptive Micro Systems Inc."],
      "000E13" => ["Accu-Sor", "Accu-Sort Systems inc."],
      "000E14" => ["Visionar", "Visionary Solutions, Inc."],
      "000E15" => ["Tadlys", "Tadlys LTD"],
      "000E16" => ["Southwin", "SouthWing S.L."],
      "000E17" => ["Private",""],
      "000E18" => ["MyaTechn", "MyA Technology"],
      "000E19" => ["Logicacm", "LogicaCMG Pty Ltd"],
      "000E1A" => ["JpsCommu", "JPS Communications"],
      "000E1B" => ["Iav", "IAV GmbH"],
      "000E1C" => ["Hach", "Hach Company"],
      "000E1D" => ["ArionTec", "ARION Technology Inc."],
      "000E1E" => ["Qlogic", "QLogic Corporation"],
      "000E1F" => ["TclNetwo", "TCL Networks Equipment Co., Ltd."],
      "000E20" => ["AccessAm", "ACCESS Systems Americas, Inc."],
      "000E21" => ["MtuFried", "MTU Friedrichshafen GmbH"],
      "000E22" => ["Private",""],
      "000E23" => ["Incipien", "Incipient, Inc."],
      "000E24" => ["HuwellTe", "Huwell Technology Inc."],
      "000E25" => ["HannaeTe", "Hannae Technology Co., Ltd"],
      "000E26" => ["GincomTe", "Gincom Technology Corp."],
      "000E27" => ["CrereNet", "Crere Networks, Inc."],
      "000E28" => ["DynamicR", "Dynamic Ratings P/L"],
      "000E29" => ["ShesterC", "Shester Communications Inc"],
      "000E2A" => ["Private",""],
      "000E2B" => ["SafariTe", "Safari Technologies"],
      "000E2C" => ["Netcodec", "Netcodec co."],
      "000E2D" => ["HyundaiD", "Hyundai Digital Technology Co.,Ltd."],
      "000E2E" => ["EdimaxTe", "Edimax Technology Co., Ltd."],
      "000E2F" => ["Disetron", "Disetronic Medical Systems AG"],
      "000E30" => ["AerasNet", "AERAS Networks, Inc."],
      "000E31" => ["OlympusS", "Olympus Soft Imaging Solutions GmbH"],
      "000E32" => ["KontronM", "Kontron Medical"],
      "000E33" => ["ShukoEle", "Shuko Electronics Co.,Ltd"],
      "000E34" => ["NexgenCi", "NexGen City, LP"],
      "000E35" => ["Intel", "Intel Corp"],
      "000E36" => ["Heinesys", "HEINESYS, Inc."],
      "000E37" => ["HarmsWen", "Harms & Wende GmbH & Co.KG"],
      "000E38" => ["Cisco", "Cisco Systems"],
      "000E39" => ["Cisco", "Cisco Systems"],
      "000E3A" => ["CirrusLo", "Cirrus Logic"],
      "000E3B" => ["HawkingT", "Hawking Technologies, Inc."],
      "000E3C" => ["Transact", "Transact Technologies Inc"],
      "000E3D" => ["TelevicN", "Televic N.V."],
      "000E3E" => ["SunOptro", "Sun Optronics Inc"],
      "000E3F" => ["Soronti", "Soronti, Inc."],
      "000E40" => ["NortelNe", "Nortel Networks"],
      "000E41" => ["NihonMec", "NIHON MECHATRONICS CO.,LTD."],
      "000E42" => ["MoticInc", "Motic Incoporation Ltd."],
      "000E43" => ["G-TekEle", "G-Tek Electronics Sdn. Bhd."],
      "000E44" => ["Digital5", "Digital 5, Inc."],
      "000E45" => ["BeijingN", "Beijing Newtry Electronic Technology Ltd"],
      "000E46" => ["NiigataS", "Niigata Seimitsu Co.,Ltd."],
      "000E47" => ["NciSyste", "NCI System Co.,Ltd."],
      "000E48" => ["LipmanTr", "Lipman TransAction Solutions"],
      "000E49" => ["ForswayS", "Forsway Scandinavia AB"],
      "000E4A" => ["Changchu", "Changchun Huayu WEBPAD Co.,LTD"],
      "000E4B" => ["AtriumCA", "atrium c and i"],
      "000E4C" => ["Bermai", "Bermai Inc."],
      "000E4D" => ["Numesa", "Numesa Inc."],
      "000E4E" => ["Waveplus", "Waveplus Technology Co., Ltd."],
      "000E4F" => ["Trajet", "Trajet GmbH"],
      "000E50" => ["ThomsonT", "Thomson Telecom Belgium"],
      "000E51" => ["TecnaEle", "tecna elettronica srl"],
      "000E52" => ["Optium", "Optium Corporation"],
      "000E53" => ["AvTech", "AV TECH CORPORATION"],
      "000E54" => ["Alphacel", "AlphaCell Wireless Ltd."],
      "000E55" => ["Auvitran",""],
      "000E56" => ["4g", "4G Systems GmbH & Co. KG"],
      "000E57" => ["IworldNe", "Iworld Networking, Inc."],
      "000E58" => ["Sonos", "Sonos, Inc."],
      "000E59" => ["SagemSa", "SAGEM SA"],
      "000E5A" => ["Telefiel", "TELEFIELD inc."],
      "000E5B" => ["Parkervi", "ParkerVision - Direct2Data"],
      "000E5C" => ["Motorola", "Motorola Mobility, Inc."],
      "000E5D" => ["TriplePl", "Triple Play Technologies A/S"],
      "000E5E" => ["Raisecom", "Raisecom Technology"],
      "000E5F" => ["Activ-Ne", "activ-net GmbH & Co. KG"],
      "000E60" => ["360sunDi", "360SUN Digital Broadband Corporation"],
      "000E61" => ["Microtro", "MICROTROL LIMITED"],
      "000E62" => ["NortelNe", "Nortel Networks"],
      "000E63" => ["LemkeDia", "Lemke Diagnostics GmbH"],
      "000E64" => ["Elphel", "Elphel, Inc"],
      "000E65" => ["Transcor", "TransCore"],
      "000E66" => ["HitachiA", "Hitachi Advanced Digital, Inc."],
      "000E67" => ["EltisMic", "Eltis Microelectronics Ltd."],
      "000E68" => ["E-TopNet", "E-TOP Network Technology Inc."],
      "000E69" => ["ChinaEle", "China Electric Power Research Institute"],
      "000E6A" => ["3com", "3Com Ltd"],
      "000E6B" => ["JanitzaE", "Janitza electronics GmbH"],
      "000E6C" => ["DeviceDr", "Device Drivers Limited"],
      "000E6D" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "000E6E" => ["Micrelec", "MICRELEC  ELECTRONICS S.A"],
      "000E6F" => ["IrisBerh", "IRIS Corporation Berhad"],
      "000E70" => ["In2Netwo", "in2 Networks"],
      "000E71" => ["GemstarT", "Gemstar Technology Development Ltd."],
      "000E72" => ["CtsElect", "CTS electronics"],
      "000E73" => ["Tpack", "Tpack A/S"],
      "000E74" => ["SolarTel", "Solar Telecom. Tech"],
      "000E75" => ["NewYorkA", "New York Air Brake Corp."],
      "000E76" => ["GemsocIn", "GEMSOC INNOVISION INC."],
      "000E77" => ["Decru", "Decru, Inc."],
      "000E78" => ["Amtelco",""],
      "000E79" => ["AmpleCom", "Ample Communications Inc."],
      "000E7A" => ["GemwonCo", "GemWon Communications Co., Ltd."],
      "000E7B" => ["Toshiba",""],
      "000E7C" => ["TelevesS", "Televes S.A."],
      "000E7D" => ["Electron", "Electronics Line 3000 Ltd."],
      "000E7E" => ["IonsignO", "ionSign Oy"],
      "000E7F" => ["Hewlett-", "Hewlett-Packard Company"],
      "000E80" => ["ThomsonT", "Thomson Technology Inc"],
      "000E81" => ["Devicesc", "Devicescape Software, Inc."],
      "000E82" => ["Commtech", "Commtech Wireless"],
      "000E83" => ["Cisco", "Cisco Systems"],
      "000E84" => ["Cisco", "Cisco Systems"],
      "000E85" => ["Catalyst", "Catalyst Enterprises, Inc."],
      "000E86" => ["AlcatelN", "Alcatel North America"],
      "000E87" => ["AdpGause", "adp Gauselmann GmbH"],
      "000E88" => ["Videotro", "VIDEOTRON CORP."],
      "000E89" => ["Clematic",""],
      "000E8A" => ["AvaraTec", "Avara Technologies Pty. Ltd."],
      "000E8B" => ["AstarteT", "Astarte Technology Co, Ltd."],
      "000E8C" => ["SiemensA", "Siemens AG A&D ET"],
      "000E8D" => ["InProgre", "Systems in Progress Holding GmbH"],
      "000E8E" => ["Sparklan", "SparkLAN Communications, Inc."],
      "000E8F" => ["Sercomm", "Sercomm Corp."],
      "000E90" => ["Ponico", "PONICO CORP."],
      "000E91" => ["NavicoAu", "Navico Auckland Ltd"],
      "000E92" => ["Millinet", "Millinet Co., Ltd."],
      "000E93" => ["Milenio3", "Milenio 3 Sistemas Electronicos, Lda."],
      "000E94" => ["MaasInte", "Maas International BV"],
      "000E95" => ["FujiyaDe", "Fujiya Denki Seisakusho Co.,Ltd."],
      "000E96" => ["CubicDef", "Cubic Defense Applications, Inc."],
      "000E97" => ["Ultracke", "Ultracker Technology CO., Inc"],
      "000E98" => ["HmeClear", "HME Clear-Com LTD."],
      "000E99" => ["Spectrum", "Spectrum Digital, Inc"],
      "000E9A" => ["BoeTechn", "BOE TECHNOLOGY GROUP CO.,LTD"],
      "000E9B" => ["AmbitMic", "Ambit Microsystems Corporation"],
      "000E9C" => ["Pemstar",""],
      "000E9D" => ["TiscaliU", "Tiscali UK Ltd"],
      "000E9E" => ["Topfield", "Topfield Co., Ltd"],
      "000E9F" => ["TemicSds", "TEMIC SDS GmbH"],
      "000EA0" => ["Netklass", "NetKlass Technology Inc."],
      "000EA1" => ["FormosaT", "Formosa Teletek Corporation"],
      "000EA2" => ["Mcafee", "McAfee, Inc"],
      "000EA3" => ["Cncr-ItH", "CNCR-IT CO.,LTD,HangZhou P.R.CHINA"],
      "000EA4" => ["Certance", "Certance Inc."],
      "000EA5" => ["Blip", "BLIP Systems"],
      "000EA6" => ["AsustekC", "ASUSTEK COMPUTER INC."],
      "000EA7" => ["EndaceTe", "Endace Technology"],
      "000EA8" => ["UnitedTe", "United Technologists Europe Limited"],
      "000EA9" => ["Shanghai", "Shanghai Xun Shi Communications Equipment Ltd. Co."],
      "000EAA" => ["Scalent", "Scalent Systems, Inc."],
      "000EAB" => ["Cray", "Cray Inc"],
      "000EAC" => ["MintronE", "MINTRON ENTERPRISE CO., LTD."],
      "000EAD" => ["Metanoia", "Metanoia Technologies, Inc."],
      "000EAE" => ["GawellTe", "GAWELL TECHNOLOGIES CORP."],
      "000EAF" => ["Castel",""],
      "000EB0" => ["Solution", "Solutions Radio BV"],
      "000EB1" => ["Newcotec", "Newcotech,Ltd"],
      "000EB2" => ["Micro-Re", "Micro-Research Finland Oy"],
      "000EB3" => ["Hewlett-", "Hewlett-Packard"],
      "000EB4" => ["Guangzho", "GUANGZHOU GAOKE COMMUNICATIONS TECHNOLOGY CO.LTD."],
      "000EB5" => ["EcastleE", "Ecastle Electronics Co., Ltd."],
      "000EB6" => ["Riverbed", "Riverbed Technology, Inc."],
      "000EB7" => ["Knovativ", "Knovative, Inc."],
      "000EB8" => ["Iiga", "Iiga co.,Ltd"],
      "000EB9" => ["Hashimot", "HASHIMOTO Electronics Industry Co.,Ltd."],
      "000EBA" => ["HanmiSem", "HANMI SEMICONDUCTOR CO., LTD."],
      "000EBB" => ["EverbeeN", "Everbee Networks"],
      "000EBC" => ["ParagonF", "Paragon Fidelity GmbH"],
      "000EBD" => ["BurdickA", "Burdick, a Quinton Compny"],
      "000EBE" => ["B&BElect", "B&B Electronics Manufacturing Co."],
      "000EBF" => ["Remsdaq", "Remsdaq Limited"],
      "000EC0" => ["NortelNe", "Nortel Networks"],
      "000EC1" => ["MynahTec", "MYNAH Technologies"],
      "000EC2" => ["Lowrance", "Lowrance Electronics, Inc."],
      "000EC3" => ["LogicCon", "Logic Controls, Inc."],
      "000EC4" => ["IskraTra", "Iskra Transmission d.d."],
      "000EC5" => ["DigitalM", "Digital Multitools Inc"],
      "000EC6" => ["AsixElec", "ASIX ELECTRONICS CORP."],
      "000EC7" => ["Motorola", "Motorola Korea"],
      "000EC8" => ["Zoran", "Zoran Corporation"],
      "000EC9" => ["YokoTech", "YOKO Technology Corp."],
      "000ECA" => ["Wtss", "WTSS Inc"],
      "000ECB" => ["VinesysT", "VineSys Technology"],
      "000ECC" => ["TableauL", "Tableau, LLC"],
      "000ECD" => ["Skov", "SKOV A/S"],
      "000ECE" => ["SITTISPA", "S.I.T.T.I. S.p.A."],
      "000ECF" => ["Profibus", "PROFIBUS Nutzerorganisation e.V."],
      "000ED0" => ["Privaris", "Privaris, Inc."],
      "000ED1" => ["OsakaMic", "Osaka Micro Computer."],
      "000ED2" => ["Filtroni", "Filtronic plc"],
      "000ED3" => ["Epicente", "Epicenter, Inc."],
      "000ED4" => ["CresittI", "CRESITT INDUSTRIE"],
      "000ED5" => ["Copan", "COPAN Systems Inc."],
      "000ED6" => ["Cisco", "Cisco Systems"],
      "000ED7" => ["Cisco", "Cisco Systems"],
      "000ED8" => ["Aktino", "Aktino, Inc."],
      "000ED9" => ["Aksys", "Aksys, Ltd."],
      "000EDA" => ["C-TechUn", "C-TECH UNITED CORP."],
      "000EDB" => ["Xincom", "XiNCOM Corp."],
      "000EDC" => ["Tellion", "Tellion INC."],
      "000EDD" => ["Shure", "SHURE INCORPORATED"],
      "000EDE" => ["Remec", "REMEC, Inc."],
      "000EDF" => ["PlxTechn", "PLX Technology"],
      "000EE0" => ["Mcharge",""],
      "000EE1" => ["Extremes", "ExtremeSpeed Inc."],
      "000EE2" => ["CustomEn", "Custom Engineering S.p.A."],
      "000EE3" => ["ChiyuTec", "Chiyu Technology Co.,Ltd"],
      "000EE4" => ["BoeTechn", "BOE TECHNOLOGY GROUP CO.,LTD"],
      "000EE5" => ["Bitwalle", "bitWallet, Inc."],
      "000EE6" => ["Adimos", "Adimos Systems LTD"],
      "000EE7" => ["AacElect", "AAC ELECTRONICS CORP."],
      "000EE8" => ["Zioncom",""],
      "000EE9" => ["WaytechD", "WayTech Development, Inc."],
      "000EEA" => ["ShadongL", "Shadong Luneng Jicheng Electronics,Co.,Ltd"],
      "000EEB" => ["Sandmart", "Sandmartin(zhong shan)Electronics Co.,Ltd"],
      "000EEC" => ["Orban",""],
      "000EED" => ["NokiaDan", "Nokia Danmark A/S"],
      "000EEE" => ["MucoIndu", "Muco Industrie BV"],
      "000EEF" => ["Private",""],
      "000EF0" => ["Festo", "Festo AG & Co. KG"],
      "000EF1" => ["Ezquest", "EZQUEST INC."],
      "000EF2" => ["Infinico", "Infinico Corporation"],
      "000EF3" => ["Smarthom", "Smarthome"],
      "000EF4" => ["KasdaDig", "Kasda Digital Technology Co.,Ltd"],
      "000EF5" => ["IpacTech", "iPAC Technology Co., Ltd."],
      "000EF6" => ["E-TenInf", "E-TEN Information Systems Co., Ltd."],
      "000EF7" => ["VulcanPo", "Vulcan Portals Inc"],
      "000EF8" => ["SbcAsi", "SBC ASI"],
      "000EF9" => ["ReaElekt", "REA Elektronik GmbH"],
      "000EFA" => ["OptowayT", "Optoway Technology Incorporation"],
      "000EFB" => ["MaceyEnt", "Macey Enterprises"],
      "000EFC" => ["JtagTech", "JTAG Technologies B.V."],
      "000EFD" => ["Fujinon", "FUJINON CORPORATION"],
      "000EFE" => ["EndrunTe", "EndRun Technologies LLC"],
      "000EFF" => ["Megasolu", "Megasolution,Inc."],
      "000F00" => ["Legra", "Legra Systems, Inc."],
      "000F01" => ["Digitalk", "DIGITALKS INC"],
      "000F02" => ["Digicube", "Digicube Technology Co., Ltd"],
      "000F03" => ["Com&C", "COM&C CO., LTD"],
      "000F04" => ["Cim-Usa", "cim-usa inc"],
      "000F05" => ["3bSystem", "3B SYSTEM INC."],
      "000F06" => ["NortelNe", "Nortel Networks"],
      "000F07" => ["Mangrove", "Mangrove Systems, Inc."],
      "000F08" => ["IndagonO", "Indagon Oy"],
      "000F09" => ["Private",""],
      "000F0A" => ["ClearEdg", "Clear Edge Networks"],
      "000F0B" => ["KentimaT", "Kentima Technologies AB"],
      "000F0C" => ["Synchron", "SYNCHRONIC ENGINEERING"],
      "000F0D" => ["HuntElec", "Hunt Electronic Co., Ltd."],
      "000F0E" => ["Wavespli", "WaveSplitter Technologies, Inc."],
      "000F0F" => ["RealIdTe", "Real ID Technology Co., Ltd."],
      "000F10" => ["Rdm", "RDM Corporation"],
      "000F11" => ["Prodrive", "Prodrive B.V."],
      "000F12" => ["Panasoni", "Panasonic Europe Ltd."],
      "000F13" => ["Nisca", "Nisca corporation"],
      "000F14" => ["Mindray", "Mindray Co., Ltd."],
      "000F15" => ["Kjaerulf", "Kjaerulff1 A/S"],
      "000F16" => ["JayHowTe", "JAY HOW TECHNOLOGY CO.,"],
      "000F17" => ["InstaEle", "Insta Elektro GmbH"],
      "000F18" => ["Industri", "Industrial Control Systems"],
      "000F19" => ["BostonSc", "Boston Scientific"],
      "000F1A" => ["GamingSu", "Gaming Support B.V."],
      "000F1B" => ["Ego", "Ego Systems Inc."],
      "000F1C" => ["Digitall", "DigitAll World Co., Ltd"],
      "000F1D" => ["CosmoTec", "Cosmo Techs Co., Ltd."],
      "000F1E" => ["ChengduK", "Chengdu KT Electric Co.of High & New Technology"],
      "000F1F" => ["WwPcbaTe", "WW PCBA Test"],
      "000F20" => ["Hewlett-", "Hewlett-Packard Company"],
      "000F21" => ["Scientif", "Scientific Atlanta, Inc"],
      "000F22" => ["Helius", "Helius, Inc."],
      "000F23" => ["Cisco", "Cisco Systems"],
      "000F24" => ["Cisco", "Cisco Systems"],
      "000F25" => ["Aimvalle", "AimValley B.V."],
      "000F26" => ["Worldacc", "WorldAccxx  LLC"],
      "000F27" => ["TealElec", "TEAL Electronics, Inc."],
      "000F28" => ["Itronix", "Itronix Corporation"],
      "000F29" => ["Augmenti", "Augmentix Corporation"],
      "000F2A" => ["Cablewar", "Cableware Electronics"],
      "000F2B" => ["Greenbel", "GREENBELL SYSTEMS"],
      "000F2C" => ["Uplogix", "Uplogix, Inc."],
      "000F2D" => ["Chung-Hs", "CHUNG-HSIN ELECTRIC & MACHINERY MFG.CORP."],
      "000F2E" => ["Megapowe", "Megapower International Corp."],
      "000F2F" => ["W-LinxTe", "W-LINX TECHNOLOGY CO., LTD."],
      "000F30" => ["RazaMicr", "Raza Microelectronics Inc"],
      "000F31" => ["AlliedVi", "Allied Vision Technologies Canada Inc"],
      "000F32" => ["LutongEl", "LuTong Electronic Technology Co.,Ltd"],
      "000F33" => ["Duali", "DUALi Inc."],
      "000F34" => ["Cisco", "Cisco Systems"],
      "000F35" => ["Cisco", "Cisco Systems"],
      "000F36" => ["Accurate", "Accurate Techhnologies, Inc."],
      "000F37" => ["Xambala", "Xambala Incorporated"],
      "000F38" => ["Netstar",""],
      "000F39" => ["IrisSens", "IRIS SENSORS"],
      "000F3A" => ["Hisharp",""],
      "000F3B" => ["FujiSyst", "Fuji System Machines Co., Ltd."],
      "000F3C" => ["Endeleo", "Endeleo Limited"],
      "000F3D" => ["D-Link", "D-Link Corporation"],
      "000F3E" => ["Cardione", "CardioNet, Inc"],
      "000F3F" => ["BigBearN", "Big Bear Networks"],
      "000F40" => ["OpticalI", "Optical Internetworking Forum"],
      "000F41" => ["Zipher", "Zipher Ltd"],
      "000F42" => ["Xalyo", "Xalyo Systems"],
      "000F43" => ["Wasabi", "Wasabi Systems Inc."],
      "000F44" => ["Tivella", "Tivella Inc."],
      "000F45" => ["Stretch", "Stretch, Inc."],
      "000F46" => ["Sinar", "SINAR AG"],
      "000F47" => ["Robox", "ROBOX SPA"],
      "000F48" => ["Polypix", "Polypix Inc."],
      "000F49" => ["Northove", "Northover Solutions Limited"],
      "000F4A" => ["Kyushu-K", "Kyushu-kyohan co.,ltd"],
      "000F4B" => ["Oracle", "Oracle Corporation"],
      "000F4C" => ["Elextech", "Elextech INC"],
      "000F4D" => ["Talkswit", "TalkSwitch"],
      "000F4E" => ["Cellink",""],
      "000F4F" => ["CadmusTe", "Cadmus Technology Ltd"],
      "000F50" => ["Streamsc", "StreamScale Limited"],
      "000F51" => ["Azul", "Azul Systems, Inc."],
      "000F52" => ["YorkRefr", "YORK Refrigeration, Marine & Controls"],
      "000F53" => ["Solarfla", "Solarflare Communications Inc"],
      "000F54" => ["Entrelog", "Entrelogic Corporation"],
      "000F55" => ["Datawire", "Datawire Communication Networks Inc."],
      "000F56" => ["Continuu", "Continuum Photonics Inc"],
      "000F57" => ["Cablelog", "CABLELOGIC Co., Ltd."],
      "000F58" => ["AdderTec", "Adder Technology Limited"],
      "000F59" => ["PhonakCo", "Phonak Communications AG"],
      "000F5A" => ["PeribitN", "Peribit Networks"],
      "000F5B" => ["DeltaInf", "Delta Information Systems, Inc."],
      "000F5C" => ["DayOneDi", "Day One Digital Media Limited"],
      "000F5D" => ["Packetfr", "PacketFront International AB"],
      "000F5E" => ["Veo",""],
      "000F5F" => ["NicetyTe", "Nicety Technologies Inc. (NTS)"],
      "000F60" => ["Lifetron", "Lifetron Co.,Ltd"],
      "000F61" => ["Hewlett-", "Hewlett-Packard Company"],
      "000F62" => ["AlcatelB", "Alcatel Bell Space N.V."],
      "000F63" => ["ObzervTe", "Obzerv Technologies"],
      "000F64" => ["D&RElect", "D&R Electronica Weesp BV"],
      "000F65" => ["Icube", "icube Corp."],
      "000F66" => ["Cisco-Li", "Cisco-Linksys"],
      "000F67" => ["WestInst", "West Instruments"],
      "000F68" => ["VavicNet", "Vavic Network Technology, Inc."],
      "000F69" => ["SewEurod", "SEW Eurodrive GmbH & Co. KG"],
      "000F6A" => ["NortelNe", "Nortel Networks"],
      "000F6B" => ["Gateware", "GateWare Communications GmbH"],
      "000F6C" => ["Addi-Dat", "ADDI-DATA GmbH"],
      "000F6D" => ["MidasEng", "Midas Engineering"],
      "000F6E" => ["Bbox",""],
      "000F6F" => ["FtaCommu", "FTA Communication Technologies"],
      "000F70" => ["WintecIn", "Wintec Industries, inc."],
      "000F71" => ["SanmeiEl", "Sanmei Electronics Co.,Ltd"],
      "000F72" => ["Sandburs", "Sandburst"],
      "000F73" => ["RsAutoma", "RS Automation Co., Ltd"],
      "000F74" => ["QamcomTe", "Qamcom Technology AB"],
      "000F75" => ["FirstSil", "First Silicon Solutions"],
      "000F76" => ["DigitalK", "Digital Keystone, Inc."],
      "000F77" => ["Dentum", "DENTUM CO.,LTD"],
      "000F78" => ["Datacap", "Datacap Systems Inc"],
      "000F79" => ["Bluetoot", "Bluetooth Interest Group Inc."],
      "000F7A" => ["BeijingN", "BeiJing NuQX Technology CO.,LTD"],
      "000F7B" => ["ArceSist", "Arce Sistemas, S.A."],
      "000F7C" => ["Acti", "ACTi Corporation"],
      "000F7D" => ["Xirrus",""],
      "000F7E" => ["AblerexE", "Ablerex Electronics Co., LTD"],
      "000F7F" => ["Ubstorag", "UBSTORAGE Co.,Ltd."],
      "000F80" => ["TrinityS", "Trinity Security Systems,Inc."],
      "000F81" => ["SecureIn", "Secure Info Imaging"],
      "000F82" => ["MortaraI", "Mortara Instrument, Inc."],
      "000F83" => ["Brainium", "Brainium Technologies Inc."],
      "000F84" => ["AstuteNe", "Astute Networks, Inc."],
      "000F85" => ["Addo-Jap", "ADDO-Japan Corporation"],
      "000F86" => ["Research", "Research In Motion Limited"],
      "000F87" => ["MaxcessI", "Maxcess International"],
      "000F88" => ["Ametek", "AMETEK, Inc."],
      "000F89" => ["Winnerte", "Winnertec System Co., Ltd."],
      "000F8A" => ["Wideview",""],
      "000F8B" => ["OrionMul", "Orion MultiSystems Inc"],
      "000F8C" => ["Gigawave", "Gigawavetech Pte Ltd"],
      "000F8D" => ["FastTv-S", "FAST TV-Server AG"],
      "000F8E" => ["Dongyang", "DONGYANG TELECOM CO.,LTD."],
      "000F8F" => ["Cisco", "Cisco Systems"],
      "000F90" => ["Cisco", "Cisco Systems"],
      "000F91" => ["Aerotele", "Aerotelecom Co.,Ltd."],
      "000F92" => ["Microhar", "Microhard Systems Inc."],
      "000F93" => ["Landis+G", "Landis+Gyr Ltd."],
      "000F94" => ["Genexis",""],
      "000F95" => ["ElecomLa", "ELECOM Co.,LTD Laneed Division"],
      "000F96" => ["Telco", "Telco Systems, Inc."],
      "000F97" => ["Avanex", "Avanex Corporation"],
      "000F98" => ["Avamax", "Avamax Co. Ltd."],
      "000F99" => ["ApacOpto", "APAC opto Electronics Inc."],
      "000F9A" => ["Synchron", "Synchrony, Inc."],
      "000F9B" => ["RossVide", "Ross Video Limited"],
      "000F9C" => ["Panduit", "Panduit Corp"],
      "000F9D" => ["Displayl", "DisplayLink (UK) Ltd"],
      "000F9E" => ["Murrelek", "Murrelektronik GmbH"],
      "000F9F" => ["Motorola", "Motorola Mobility, Inc."],
      "000FA0" => ["CanonKor", "CANON KOREA BUSINESS SOLUTIONS INC."],
      "000FA1" => ["Gigabit", "Gigabit Systems Inc."],
      "000FA2" => ["DigitalP", "Digital Path Networks"],
      "000FA3" => ["AlphaNet", "Alpha Networks Inc."],
      "000FA4" => ["Sprecher", "Sprecher Automation GmbH"],
      "000FA5" => ["BwaTechn", "BWA Technology GmbH"],
      "000FA6" => ["S2Securi", "S2 Security Corporation"],
      "000FA7" => ["RaptorNe", "Raptor Networks Technology"],
      "000FA8" => ["Photomet", "Photometrics, Inc."],
      "000FA9" => ["PcFabrik", "PC Fabrik"],
      "000FAA" => ["NexusTec", "Nexus Technologies"],
      "000FAB" => ["KyushuEl", "Kyushu Electronics Systems Inc."],
      "000FAC" => ["Ieee8021", "IEEE 802.11"],
      "000FAD" => ["FmnCommu", "FMN communications GmbH"],
      "000FAE" => ["E2oCommu", "E2O Communications"],
      "000FAF" => ["Dialog", "Dialog Inc."],
      "000FB0" => ["CompalEl", "Compal Electronics,INC."],
      "000FB1" => ["Cognio", "Cognio Inc."],
      "000FB2" => ["Broadban", "Broadband Pacenet (India) Pvt. Ltd."],
      "000FB3" => ["Actionte", "Actiontec Electronics, Inc"],
      "000FB4" => ["Timespac", "Timespace Technology"],
      "000FB5" => ["Netgear", "NETGEAR Inc"],
      "000FB6" => ["Europlex", "Europlex Technologies"],
      "000FB7" => ["CaviumNe", "Cavium Networks"],
      "000FB8" => ["Callurl", "CallURL Inc."],
      "000FB9" => ["Adaptive", "Adaptive Instruments"],
      "000FBA" => ["Tevebox", "Tevebox AB"],
      "000FBB" => ["NokiaSie", "Nokia Siemens Networks GmbH & Co. KG"],
      "000FBC" => ["OnkeyTec", "Onkey Technologies, Inc."],
      "000FBD" => ["MrvCommu", "MRV Communications (Networks) LTD"],
      "000FBE" => ["E-W/You", "e-w/you Inc."],
      "000FBF" => ["DgtSpZOO", "DGT Sp. z o.o."],
      "000FC0" => ["Delcomp",""],
      "000FC1" => ["Wave", "WAVE Corporation"],
      "000FC2" => ["Uniwell", "Uniwell Corporation"],
      "000FC3" => ["Palmpalm", "PalmPalm Technology, Inc."],
      "000FC4" => ["Nst", "NST co.,LTD."],
      "000FC5" => ["Keymed", "KeyMed Ltd"],
      "000FC6" => ["EurocomI", "Eurocom Industries A/S"],
      "000FC7" => ["DionicaR", "Dionica R&D Ltd."],
      "000FC8" => ["ChantryN", "Chantry Networks"],
      "000FC9" => ["Allnet", "Allnet GmbH"],
      "000FCA" => ["A-JinTec", "A-JIN TECHLINE CO, LTD"],
      "000FCB" => ["3com", "3Com Ltd"],
      "000FCC" => ["Netopia", "Netopia, Inc."],
      "000FCD" => ["NortelNe", "Nortel Networks"],
      "000FCE" => ["KikusuiE", "Kikusui Electronics Corp."],
      "000FCF" => ["Datawind", "Datawind Research"],
      "000FD0" => ["Astri",""],
      "000FD1" => ["AppliedW", "Applied Wireless Identifications Group, Inc."],
      "000FD2" => ["EwaTechn", "EWA Technologies, Inc."],
      "000FD3" => ["Digium",""],
      "000FD4" => ["Soundcra", "Soundcraft"],
      "000FD5" => ["Schwecha", "Schwechat - RISE"],
      "000FD6" => ["Sarotech", "Sarotech Co., Ltd"],
      "000FD7" => ["HarmanMu", "Harman Music Group"],
      "000FD8" => ["Force", "Force, Inc."],
      "000FD9" => ["FlexdslT", "FlexDSL Telecommunications AG"],
      "000FDA" => ["Yazaki", "YAZAKI CORPORATION"],
      "000FDB" => ["WestellT", "Westell Technologies"],
      "000FDC" => ["UedaJapa", "Ueda Japan  Radio Co., Ltd."],
      "000FDD" => ["Sordin", "SORDIN AB"],
      "000FDE" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "000FDF" => ["SolomonT", "SOLOMON Technology Corp."],
      "000FE0" => ["Ncomputi", "NComputing Co.,Ltd."],
      "000FE1" => ["IdDigita", "ID DIGITAL CORPORATION"],
      "000FE2" => ["Hangzhou", "Hangzhou H3C Technologies Co., Ltd."],
      "000FE3" => ["DammCell", "Damm Cellular Systems A/S"],
      "000FE4" => ["Pantech", "Pantech Co.,Ltd"],
      "000FE5" => ["MercuryS", "MERCURY SECURITY CORPORATION"],
      "000FE6" => ["Mbtech", "MBTech Systems, Inc."],
      "000FE7" => ["LutronEl", "Lutron Electronics Co., Inc."],
      "000FE8" => ["Lobos", "Lobos, Inc."],
      "000FE9" => ["GwTechno", "GW TECHNOLOGIES CO.,LTD."],
      "000FEA" => ["Giga-Byt", "Giga-Byte Technology Co.,LTD."],
      "000FEB" => ["CylonCon", "Cylon Controls"],
      "000FEC" => ["Arkus", "Arkus Inc."],
      "000FED" => ["AnamElec", "Anam Electronics Co., Ltd"],
      "000FEE" => ["Xtec", "XTec, Incorporated"],
      "000FEF" => ["ThalesE-", "Thales e-Transactions GmbH"],
      "000FF0" => ["Sunray", "Sunray Co. Ltd."],
      "000FF1" => ["Nex-GPte", "nex-G Systems Pte.Ltd"],
      "000FF2" => ["LoudTech", "Loud Technologies Inc."],
      "000FF3" => ["JungMyou", "Jung Myoung Communications&Technology"],
      "000FF4" => ["Gunterma", "Guntermann & Drunck GmbH"],
      "000FF5" => ["Gn&S", "GN&S company"],
      "000FF6" => ["DarfonEl", "Darfon Electronics Corp."],
      "000FF7" => ["Cisco", "Cisco Systems"],
      "000FF8" => ["Cisco", "Cisco  Systems"],
      "000FF9" => ["Valcrete", "Valcretec, Inc."],
      "000FFA" => ["Optinel", "Optinel Systems, Inc."],
      "000FFB" => ["NipponDe", "Nippon Denso Industry Co., Ltd."],
      "000FFC" => ["MeritLi-", "Merit Li-Lin Ent."],
      "000FFD" => ["Glorytek", "Glorytek Network Inc."],
      "000FFE" => ["G-ProCom", "G-PRO COMPUTER"],
      "000FFF" => ["Control4",""],
      "001000" => ["CableTel", "CABLE TELEVISION LABORATORIES, INC."],
      "001001" => ["Citel",""],
      "001002" => ["Actia",""],
      "001003" => ["Imatron", "IMATRON, INC."],
      "001004" => ["Brantley", "THE BRANTLEY COILE COMPANY,INC"],
      "001005" => ["UecComme", "UEC COMMERCIAL"],
      "001006" => ["ThalesCo", "Thales Contact Solutions Ltd."],
      "001007" => ["Cisco", "CISCO SYSTEMS, INC."],
      "001008" => ["Vienna", "VIENNA SYSTEMS CORPORATION"],
      "001009" => ["HoroQuar", "HORO QUARTZ"],
      "00100A" => ["Williams", "WILLIAMS COMMUNICATIONS GROUP"],
      "00100B" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00100C" => ["Ito", "ITO CO., LTD."],
      "00100D" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00100E" => ["MicroLin", "MICRO LINEAR COPORATION"],
      "00100F" => ["Industri", "INDUSTRIAL CPU SYSTEMS"],
      "001010" => ["Initio", "INITIO CORPORATION"],
      "001011" => ["Cisco", "CISCO SYSTEMS, INC."],
      "001012" => ["Processo", "PROCESSOR SYSTEMS (I) PVT LTD"],
      "001013" => ["KontronA", "Kontron America, Inc."],
      "001014" => ["Cisco", "CISCO SYSTEMS, INC."],
      "001015" => ["Oomon", "OOmon Inc."],
      "001016" => ["TSqware", "T.SQWARE"],
      "001017" => ["BoschAcc", "Bosch Access Systems GmbH"],
      "001018" => ["Broadcom", "BROADCOM CORPORATION"],
      "001019" => ["SironaDe", "SIRONA DENTAL SYSTEMS GmbH & Co. KG"],
      "00101A" => ["Picturet", "PictureTel Corp."],
      "00101B" => ["CornetTe", "CORNET TECHNOLOGY, INC."],
      "00101C" => ["OhmTechn", "OHM TECHNOLOGIES INTL, LLC"],
      "00101D" => ["WinbondE", "WINBOND ELECTRONICS CORP."],
      "00101E" => ["Matsushi", "MATSUSHITA ELECTRONIC INSTRUMENTS CORP."],
      "00101F" => ["Cisco", "CISCO SYSTEMS, INC."],
      "001020" => ["HandHeld", "Hand Held Products Inc"],
      "001021" => ["EncantoN", "ENCANTO NETWORKS, INC."],
      "001022" => ["SatcomMe", "SatCom Media Corporation"],
      "001023" => ["NetworkE", "Network Equipment Technologies"],
      "001024" => ["NagoyaEl", "NAGOYA ELECTRIC WORKS CO., LTD"],
      "001025" => ["Grayhill", "Grayhill, Inc"],
      "001026" => ["Accelera", "ACCELERATED NETWORKS, INC."],
      "001027" => ["L-3Commu", "L-3 COMMUNICATIONS EAST"],
      "001028" => ["Computer", "COMPUTER TECHNICA, INC."],
      "001029" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00102A" => ["ZfMicros", "ZF MICROSYSTEMS, INC."],
      "00102B" => ["UmaxData", "UMAX DATA SYSTEMS, INC."],
      "00102C" => ["LasatNet", "Lasat Networks A/S"],
      "00102D" => ["HitachiS", "HITACHI SOFTWARE ENGINEERING"],
      "00102E" => ["NetworkT", "NETWORK SYSTEMS & TECHNOLOGIES PVT. LTD."],
      "00102F" => ["Cisco", "CISCO SYSTEMS, INC."],
      "001030" => ["Eion", "EION Inc."],
      "001031" => ["Objectiv", "OBJECTIVE COMMUNICATIONS, INC."],
      "001032" => ["AltaTech", "ALTA TECHNOLOGY"],
      "001033" => ["Accessla", "ACCESSLAN COMMUNICATIONS, INC."],
      "001034" => ["GnpCompu", "GNP Computers"],
      "001035" => ["Elitegro", "ELITEGROUP COMPUTER SYSTEMS CO., LTD"],
      "001036" => ["Inter-Te", "INTER-TEL INTEGRATED SYSTEMS"],
      "001037" => ["CyqVeTec", "CYQ\'ve Technology Co., Ltd."],
      "001038" => ["MicroRes", "MICRO RESEARCH INSTITUTE, INC."],
      "001039" => ["Vectron", "Vectron Systems AG"],
      "00103A" => ["DiamondN", "DIAMOND NETWORK TECH"],
      "00103B" => ["HippiNet", "HIPPI NETWORKING FORUM"],
      "00103C" => ["IcEnsemb", "IC ENSEMBLE, INC."],
      "00103D" => ["Phasecom", "PHASECOM, LTD."],
      "00103E" => ["Netschoo", "NETSCHOOLS CORPORATION"],
      "00103F" => ["Tollgrad", "TOLLGRADE COMMUNICATIONS, INC."],
      "001040" => ["Intermec", "INTERMEC CORPORATION"],
      "001041" => ["BristolB", "BRISTOL BABCOCK, INC."],
      "001042" => ["Alacrite", "Alacritech, Inc."],
      "001043" => ["A2", "A2 CORPORATION"],
      "001044" => ["Innolabs", "InnoLabs Corporation"],
      "001045" => ["NortelNe", "Nortel Networks"],
      "001046" => ["AlcornMc", "ALCORN MCBRIDE INC."],
      "001047" => ["EchoElet", "ECHO ELETRIC CO. LTD."],
      "001048" => ["HtrcAuto", "HTRC AUTOMATION, INC."],
      "001049" => ["Shoretel", "ShoreTel, Inc"],
      "00104A" => ["Parvus", "The Parvus Corporation"],
      "00104B" => ["3com", "3COM CORPORATION"],
      "00104C" => ["Lecroy", "LeCroy Corporation"],
      "00104D" => ["SurtecIn", "SURTEC INDUSTRIES, INC."],
      "00104E" => ["Ceologic",""],
      "00104F" => ["Oracle", "Oracle Corporation"],
      "001050" => ["Rion", "RION CO., LTD."],
      "001051" => ["Cmicro", "CMICRO CORPORATION"],
      "001052" => ["Mettler-", "METTLER-TOLEDO (ALBSTADT) GMBH"],
      "001053" => ["Computer", "COMPUTER TECHNOLOGY CORP."],
      "001054" => ["Cisco", "CISCO SYSTEMS, INC."],
      "001055" => ["FujitsuM", "FUJITSU MICROELECTRONICS, INC."],
      "001056" => ["Sodick", "SODICK CO., LTD."],
      "001057" => ["RebelCom", "Rebel.com, Inc."],
      "001058" => ["Arrowpoi", "ArrowPoint Communications"],
      "001059" => ["DiabloRe", "DIABLO RESEARCH CO. LLC"],
      "00105A" => ["3com", "3COM CORPORATION"],
      "00105B" => ["NetInsig", "NET INSIGHT AB"],
      "00105C" => ["QuantumD", "QUANTUM DESIGNS (H.K.) LTD."],
      "00105D" => ["DraegerM", "Draeger Medical"],
      "00105E" => ["Hekimian", "HEKIMIAN LABORATORIES, INC."],
      "00105F" => ["ZodiacDa", "ZODIAC DATA SYSTEMS"],
      "001060" => ["Billiont", "BILLIONTON SYSTEMS, INC."],
      "001061" => ["Hostlink", "HOSTLINK CORP."],
      "001062" => ["NxServer", "NX SERVER, ILNC."],
      "001063" => ["Starguid", "STARGUIDE DIGITAL NETWORKS"],
      "001064" => ["DnpgLlc", "DNPG, LLC"],
      "001065" => ["Radyne", "RADYNE CORPORATION"],
      "001066" => ["Advanced", "ADVANCED CONTROL SYSTEMS, INC."],
      "001067" => ["Ericsson",""],
      "001068" => ["ComosTel", "COMOS TELECOM"],
      "001069" => ["HeliossC", "HELIOSS COMMUNICATIONS, INC."],
      "00106A" => ["DigitalM", "DIGITAL MICROWAVE CORPORATION"],
      "00106B" => ["SonusNet", "SONUS NETWORKS, INC."],
      "00106C" => ["Infratec", "Infratec AG"],
      "00106D" => ["Axxceler", "Axxcelera Broadband Wireless"],
      "00106E" => ["TadiranC", "TADIRAN COM. LTD."],
      "00106F" => ["TrentonT", "TRENTON TECHNOLOGY INC."],
      "001070" => ["CaradonT", "CARADON TREND LTD."],
      "001071" => ["Advanet", "ADVANET INC."],
      "001072" => ["GvnTechn", "GVN TECHNOLOGIES, INC."],
      "001073" => ["Technobo", "Technobox, Inc."],
      "001074" => ["AtenInte", "ATEN INTERNATIONAL CO., LTD."],
      "001075" => ["Maxtor", "Maxtor Corporation"],
      "001076" => ["Eurem", "EUREM GmbH"],
      "001077" => ["SafDrive", "SAF DRIVE SYSTEMS, LTD."],
      "001078" => ["NueraCom", "NUERA COMMUNICATIONS, INC."],
      "001079" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00107A" => ["Ambicom", "AmbiCom, Inc."],
      "00107B" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00107C" => ["P-Com", "P-COM, INC."],
      "00107D" => ["AuroraCo", "AURORA COMMUNICATIONS, LTD."],
      "00107E" => ["Bachmann", "BACHMANN ELECTRONIC GmbH"],
      "00107F" => ["Crestron", "CRESTRON ELECTRONICS, INC."],
      "001080" => ["Metawave", "METAWAVE COMMUNICATIONS"],
      "001081" => ["Dps", "DPS, INC."],
      "001082" => ["JnaTelec", "JNA TELECOMMUNICATIONS LIMITED"],
      "001083" => ["Hewlett-", "HEWLETT-PACKARD COMPANY"],
      "001084" => ["K-BotCom", "K-BOT COMMUNICATIONS"],
      "001085" => ["PolarisC", "POLARIS COMMUNICATIONS, INC."],
      "001086" => ["AttoTech", "ATTO Technology, Inc."],
      "001087" => ["Xstreami", "Xstreamis PLC"],
      "001088" => ["American", "AMERICAN NETWORKS INC."],
      "001089" => ["Websonic",""],
      "00108A" => ["Teralogi", "TeraLogic, Inc."],
      "00108B" => ["Laserani", "LASERANIMATION SOLLINGER GmbH"],
      "00108C" => ["FujitsuT", "FUJITSU TELECOMMUNICATIONS EUROPE, LTD."],
      "00108D" => ["JohnsonC", "Johnson Controls, Inc."],
      "00108E" => ["HughSymo", "HUGH SYMONS CONCEPT Technologies Ltd."],
      "00108F" => ["Raptor", "RAPTOR SYSTEMS"],
      "001090" => ["Cimetric", "CIMETRICS, INC."],
      "001091" => ["NoWiresN", "NO WIRES NEEDED BV"],
      "001092" => ["Netcore", "NETCORE INC."],
      "001093" => ["CmsCompu", "CMS COMPUTERS, LTD."],
      "001094" => ["Performa", "Performance Analysis Broadband, Spirent plc"],
      "001095" => ["Thomson", "Thomson Inc."],
      "001096" => ["Tracewel", "TRACEWELL SYSTEMS, INC."],
      "001097" => ["WinnetMe", "WinNet Metropolitan Communications Systems, Inc."],
      "001098" => ["StarnetT", "STARNET TECHNOLOGIES, INC."],
      "001099" => ["Innomedi", "InnoMedia, Inc."],
      "00109A" => ["Netline",""],
      "00109B" => ["Emulex", "Emulex Corporation"],
      "00109C" => ["M-System", "M-SYSTEM CO., LTD."],
      "00109D" => ["Clarinet", "CLARINET SYSTEMS, INC."],
      "00109E" => ["Aware", "AWARE, INC."],
      "00109F" => ["Pavo", "PAVO, INC."],
      "0010A0" => ["InnovexT", "INNOVEX TECHNOLOGIES, INC."],
      "0010A1" => ["KendinSe", "KENDIN SEMICONDUCTOR, INC."],
      "0010A2" => ["Tns",""],
      "0010A3" => ["Omnitron", "OMNITRONIX, INC."],
      "0010A4" => ["Xircom",""],
      "0010A5" => ["OxfordIn", "OXFORD INSTRUMENTS"],
      "0010A6" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0010A7" => ["UnexTech", "UNEX TECHNOLOGY CORPORATION"],
      "0010A8" => ["Reliance", "RELIANCE COMPUTER CORP."],
      "0010A9" => ["AdhocTec", "ADHOC TECHNOLOGIES"],
      "0010AA" => ["Media4", "MEDIA4, INC."],
      "0010AB" => ["KoitoEle", "KOITO ELECTRIC INDUSTRIES, LTD."],
      "0010AC" => ["ImciTech", "IMCI TECHNOLOGIES"],
      "0010AD" => ["Softroni", "SOFTRONICS USB, INC."],
      "0010AE" => ["ShinkoEl", "SHINKO ELECTRIC INDUSTRIES CO."],
      "0010AF" => ["Tac", "TAC SYSTEMS, INC."],
      "0010B0" => ["Meridian", "MERIDIAN TECHNOLOGY CORP."],
      "0010B1" => ["For-A", "FOR-A CO., LTD."],
      "0010B2" => ["Coactive", "COACTIVE AESTHETICS"],
      "0010B3" => ["NokiaMul", "NOKIA MULTIMEDIA TERMINALS"],
      "0010B4" => ["Atmosphe", "ATMOSPHERE NETWORKS"],
      "0010B5" => ["AcctonTe", "ACCTON TECHNOLOGY CORPORATION"],
      "0010B6" => ["EntrataC", "ENTRATA COMMUNICATIONS CORP."],
      "0010B7" => ["CoyoteTe", "COYOTE TECHNOLOGIES, LLC"],
      "0010B8" => ["Ishigaki", "ISHIGAKI COMPUTER SYSTEM CO."],
      "0010B9" => ["Maxtor", "MAXTOR CORP."],
      "0010BA" => ["Martinho", "MARTINHO-DAVIS SYSTEMS, INC."],
      "0010BB" => ["DataInfo", "DATA & INFORMATION TECHNOLOGY"],
      "0010BC" => ["AastraTe", "Aastra Telecom"],
      "0010BD" => ["Telecomm", "THE TELECOMMUNICATION TECHNOLOGY COMMITTEE (TTC)"],
      "0010BE" => ["MarchNet", "MARCH NETWORKS CORPORATION"],
      "0010BF" => ["Interair", "InterAir Wireless"],
      "0010C0" => ["Arma", "ARMA, Inc."],
      "0010C1" => ["OiElectr", "OI ELECTRIC CO., LTD."],
      "0010C2" => ["Willnet", "WILLNET, INC."],
      "0010C3" => ["Csi-Cont", "CSI-CONTROL SYSTEMS"],
      "0010C4" => ["MediaLin", "MEDIA LINKS CO., LTD."],
      "0010C5" => ["Protocol", "PROTOCOL TECHNOLOGIES, INC."],
      "0010C6" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "0010C7" => ["DataTran", "DATA TRANSMISSION NETWORK"],
      "0010C8" => ["Communic", "COMMUNICATIONS ELECTRONICS SECURITY GROUP"],
      "0010C9" => ["Mitsubis", "MITSUBISHI ELECTRONICS LOGISTIC SUPPORT CO."],
      "0010CA" => ["Telco", "Telco Systems, Inc."],
      "0010CB" => ["FacitKK", "FACIT K.K."],
      "0010CC" => ["ClpCompu", "CLP COMPUTER LOGISTIK PLANUNG GmbH"],
      "0010CD" => ["Interfac", "INTERFACE CONCEPT"],
      "0010CE" => ["Volamp", "VOLAMP, LTD."],
      "0010CF" => ["Fiberlan", "FIBERLANE COMMUNICATIONS"],
      "0010D0" => ["Witcom", "WITCOM, LTD."],
      "0010D1" => ["TopLayer", "Top Layer Networks, Inc."],
      "0010D2" => ["NittoTsu", "NITTO TSUSHINKI CO., LTD"],
      "0010D3" => ["GripsEle", "GRIPS ELECTRONIC GMBH"],
      "0010D4" => ["StorageC", "STORAGE COMPUTER CORPORATION"],
      "0010D5" => ["ImasdeCa", "IMASDE CANARIAS, S.A."],
      "0010D6" => ["Itt-A/Cd", "ITT - A/CD"],
      "0010D7" => ["ArgosyRe", "ARGOSY RESEARCH INC."],
      "0010D8" => ["Calista",""],
      "0010D9" => ["IbmJapan", "IBM JAPAN, FUJISAWA MT+D"],
      "0010DA" => ["MotionEn", "MOTION ENGINEERING, INC."],
      "0010DB" => ["Netscreen		", "Now part of Juniper Networks"],
      "0010DC" => ["Micro-St", "MICRO-STAR INTERNATIONAL CO., LTD."],
      "0010DD" => ["EnableSe", "ENABLE SEMICONDUCTOR, INC."],
      "0010DE" => ["Internat", "INTERNATIONAL DATACASTING CORPORATION"],
      "0010DF" => ["RiseComp", "RISE COMPUTER INC."],
      "0010E0" => ["Oracle", "Oracle Corporation"],
      "0010E1" => ["SITech", "S.I. TECH, INC."],
      "0010E2" => ["Arraycom", "ArrayComm, Inc."],
      "0010E3" => ["Hewlett-", "Hewlett-Packard Company"],
      "0010E4" => ["Nsi", "NSI CORPORATION"],
      "0010E5" => ["Solectro", "SOLECTRON TEXAS"],
      "0010E6" => ["AppliedI", "APPLIED INTELLIGENT SYSTEMS, INC."],
      "0010E7" => ["Breezeco", "BreezeCom"],
      "0010E8" => ["Telocity", "TELOCITY, INCORPORATED"],
      "0010E9" => ["Raidtec", "RAIDTEC LTD."],
      "0010EA" => ["AdeptTec", "ADEPT TECHNOLOGY"],
      "0010EB" => ["Selsius", "SELSIUS SYSTEMS, INC."],
      "0010EC" => ["RpcgLlc", "RPCG, LLC"],
      "0010ED" => ["Sundance", "SUNDANCE TECHNOLOGY, INC."],
      "0010EE" => ["CtiProdu", "CTI PRODUCTS, INC."],
      "0010EF" => ["Dbtel", "DBTEL INCORPORATED"],
      "0010F1" => ["I-O", "I-O CORPORATION"],
      "0010F2" => ["Antec",""],
      "0010F3" => ["NexcomIn", "Nexcom International Co., Ltd."],
      "0010F4" => ["Vertical", "Vertical Communications"],
      "0010F5" => ["Amherst", "AMHERST SYSTEMS, INC."],
      "0010F6" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0010F7" => ["IriichiT", "IRIICHI TECHNOLOGIES Inc."],
      "0010F8" => ["NiikkeTe", "Niikke Techno System Co. Ltd"],
      "0010F9" => ["Unique", "UNIQUE SYSTEMS, INC."],
      "0010FA" => ["Apple", "Apple, Inc"],
      "0010FB" => ["ZidaTech", "ZIDA TECHNOLOGIES LIMITED"],
      "0010FC" => ["Broadban", "BROADBAND NETWORKS, INC."],
      "0010FD" => ["Cocom", "COCOM A/S"],
      "0010FE" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "0010FF" => ["Cisco", "CISCO SYSTEMS, INC."],
      "001100" => ["Schneide", "Schneider Electric"],
      "001101" => ["CetTechn", "CET Technologies Pte Ltd"],
      "001102" => ["AuroraMu", "Aurora Multimedia Corp."],
      "001103" => ["Kawamura", "kawamura electric inc."],
      "001104" => ["Telexy",""],
      "001105" => ["SunplusT", "Sunplus Technology Co., Ltd."],
      "001106" => ["SiemensN", "Siemens NV (Belgium)"],
      "001107" => ["RgbNetwo", "RGB Networks Inc."],
      "001108" => ["OrbitalD", "Orbital Data Corporation"],
      "001109" => ["Micro-St", "Micro-Star International"],
      "00110A" => ["Hewlett-", "Hewlett-Packard Company"],
      "00110B" => ["Franklin", "Franklin Technology Systems"],
      "00110C" => ["AtmarkTe", "Atmark Techno, Inc."],
      "00110D" => ["Sanblaze", "SANBlaze Technology, Inc."],
      "00110E" => ["Tsurusak", "Tsurusaki Sealand Transportation Co. Ltd."],
      "00110F" => ["Netplat", "netplat,Inc."],
      "001110" => ["MaxannaT", "Maxanna Technology Co., Ltd."],
      "001111" => ["Intel", "Intel Corporation"],
      "001112" => ["Honeywel", "Honeywell CMSS"],
      "001113" => ["Fraunhof", "Fraunhofer FOKUS"],
      "001114" => ["Everfocu", "EverFocus Electronics Corp."],
      "001115" => ["EpinTech", "EPIN Technologies, Inc."],
      "001116" => ["CoteauVe", "COTEAU VERT CO., LTD."],
      "001117" => ["Cesnet",""],
      "001118" => ["BlxIcDes", "BLX IC Design Corp., Ltd."],
      "001119" => ["Solteras", "Solteras, Inc."],
      "00111A" => ["Motorola", "Motorola Mobility, Inc."],
      "00111B" => ["TargaDiv", "Targa Systems Div L-3 Communications Canada"],
      "00111C" => ["PleoraTe", "Pleora Technologies Inc."],
      "00111D" => ["Hectrix", "Hectrix Limited"],
      "00111E" => ["EpsgEthe", "EPSG (Ethernet Powerlink Standardization Group)"],
      "00111F" => ["DoremiLa", "Doremi Labs, Inc."],
      "001120" => ["Cisco", "Cisco Systems"],
      "001121" => ["Cisco", "Cisco Systems"],
      "001122" => ["Cimsys", "CIMSYS Inc"],
      "001123" => ["Appointe", "Appointech, Inc."],
      "001124" => ["AppleCom", "Apple Computer"],
      "001125" => ["Ibm", "IBM Corp"],
      "001126" => ["Venstar", "Venstar Inc."],
      "001127" => ["Tasi", "TASI, Inc"],
      "001128" => ["Streamit",""],
      "001129" => ["Paradise", "Paradise Datacom Ltd."],
      "00112A" => ["NikoNv", "Niko NV"],
      "00112B" => ["Netmodul", "NetModule AG"],
      "00112C" => ["Izt", "IZT GmbH"],
      "00112D" => ["Ipulse", "iPulse Systems"],
      "00112E" => ["Ceicom",""],
      "00112F" => ["AsustekC", "ASUSTek Computer Inc."],
      "001130" => ["AlliedTe", "Allied Telesis (Hong Kong) Ltd."],
      "001131" => ["Unatech", "UNATECH. CO.,LTD"],
      "001132" => ["Synology", "Synology Incorporated"],
      "001133" => ["SiemensA", "Siemens Austria SIMEA"],
      "001134" => ["Mediacel", "MediaCell, Inc."],
      "001135" => ["Grandeye", "Grandeye Ltd"],
      "001136" => ["Goodrich", "Goodrich Sensor Systems"],
      "001137" => ["AichiEle", "AICHI ELECTRIC CO., LTD."],
      "001138" => ["Taishin", "TAISHIN CO., LTD."],
      "001139" => ["StoeberA", "STOEBER ANTRIEBSTECHNIK GmbH + Co. KG."],
      "00113A" => ["Shinbora", "SHINBORAM"],
      "00113B" => ["Micronet", "Micronet Communications Inc."],
      "00113C" => ["Micronas", "Micronas GmbH"],
      "00113D" => ["KnSoltec", "KN SOLTEC CO.,LTD."],
      "00113E" => ["Jl", "JL Corporation"],
      "00113F" => ["AlcatelD", "Alcatel DI"],
      "001140" => ["Nanometr", "Nanometrics Inc."],
      "001141" => ["Goodman", "GoodMan Corporation"],
      "001142" => ["E-Smartc", "e-SMARTCOM  INC."],
      "001143" => ["Dell", "DELL INC."],
      "001144" => ["Assuranc", "Assurance Technology Corp"],
      "001145" => ["Valuepoi", "ValuePoint Networks"],
      "001146" => ["Telecard", "Telecard-Pribor Ltd"],
      "001147" => ["Secom-In", "Secom-Industry co.LTD."],
      "001148" => ["ProlonCo", "Prolon Control Systems"],
      "001149" => ["Proliphi", "Proliphix Inc."],
      "00114A" => ["KayabaIn", "KAYABA INDUSTRY Co,.Ltd."],
      "00114B" => ["Francoty", "Francotyp-Postalia GmbH"],
      "00114C" => ["Caffeina", "caffeina applied research ltd."],
      "00114D" => ["AtsumiEl", "Atsumi Electric Co.,LTD."],
      "00114E" => ["690885On", "690885 Ontario Inc."],
      "00114F" => ["UsDigita", "US Digital Television, Inc"],
      "001150" => ["Belkin", "Belkin Corporation"],
      "001151" => ["Mykotron", "Mykotronx"],
      "001152" => ["Eidsvoll", "Eidsvoll Electronics AS"],
      "001153" => ["TridentT", "Trident Tek, Inc."],
      "001154" => ["WebproTe", "Webpro Technologies Inc."],
      "001155" => ["Sevis", "Sevis Systems"],
      "001156" => ["PharosNz", "Pharos Systems NZ"],
      "001157" => ["OfNetwor", "OF Networks Co., Ltd."],
      "001158" => ["NortelNe", "Nortel Networks"],
      "001159" => ["MatisseN", "MATISSE NETWORKS INC"],
      "00115A" => ["IvoclarV", "Ivoclar Vivadent AG"],
      "00115B" => ["Elitegro", "Elitegroup Computer System Co. (ECS)"],
      "00115C" => ["Cisco",""],
      "00115D" => ["Cisco",""],
      "00115E" => ["Prominen", "ProMinent Dosiertechnik GmbH"],
      "00115F" => ["ItxSecur", "ITX Security Co., Ltd."],
      "001160" => ["Artdio", "ARTDIO Company Co., LTD"],
      "001161" => ["Netstrea", "NetStreams, LLC"],
      "001162" => ["StarMicr", "STAR MICRONICS CO.,LTD."],
      "001163" => ["SystemDe", "SYSTEM SPA DEPT. ELECTRONICS"],
      "001164" => ["AcardTec", "ACARD Technology Corp."],
      "001165" => ["ZnyxNetw", "Znyx Networks"],
      "001166" => ["TaelimEl", "Taelim Electronics Co., Ltd."],
      "001167" => ["Integrat", "Integrated System Solution Corp."],
      "001168" => ["Homelogi", "HomeLogic LLC"],
      "001169" => ["EmsSatco", "EMS Satcom"],
      "00116A" => ["Domo", "Domo Ltd"],
      "00116B" => ["DigitalD", "Digital Data Communications Asia Co.,Ltd"],
      "00116C" => ["NanwangM", "Nanwang Multimedia Inc.,Ltd"],
      "00116D" => ["American", "American Time and Signal"],
      "00116E" => ["Peplink", "PePLink Ltd."],
      "00116F" => ["Netforyo", "Netforyou Co., LTD."],
      "001170" => ["GscSrl", "GSC SRL"],
      "001171" => ["DexterCo", "DEXTER Communications, Inc."],
      "001172" => ["Cotron", "COTRON CORPORATION"],
      "001173" => ["SmartSto", "SMART Storage Systems"],
      "001174" => ["WibhuTec", "Wibhu Technologies, Inc."],
      "001175" => ["Pathscal", "PathScale, Inc."],
      "001176" => ["Intellam", "Intellambda Systems, Inc."],
      "001177" => ["CoaxialN", "Coaxial Networks, Inc."],
      "001178" => ["ChironTe", "Chiron Technology Ltd"],
      "001179" => ["Singular", "Singular Technology Co. Ltd."],
      "00117A" => ["SingimIn", "Singim International Corp."],
      "00117B" => ["BuchiLab", "Buchi Labortechnik AG"],
      "00117C" => ["E-ZyNet", "e-zy.net"],
      "00117D" => ["ZmdAmeri", "ZMD America, Inc."],
      "00117E" => ["ProgenyA", "Progeny, A division of Midmark Corp"],
      "00117F" => ["NeotuneI", "Neotune Information Technology Corporation,.LTD"],
      "001180" => ["Motorola", "Motorola Mobility, Inc."],
      "001181" => ["Interene", "InterEnergy Co.Ltd,"],
      "001182" => ["ImiNorgr", "IMI Norgren Ltd"],
      "001183" => ["Datalogi", "Datalogic Mobile, Inc."],
      "001184" => ["HumoLabo", "Humo Laboratory,Ltd."],
      "001185" => ["Hewlett-", "Hewlett-Packard Company"],
      "001186" => ["Prime", "Prime Systems, Inc."],
      "001187" => ["Category", "Category Solutions, Inc"],
      "001188" => ["Enterasy", "Enterasys"],
      "001189" => ["Aerotech", "Aerotech Inc"],
      "00118A" => ["Viewtran", "Viewtran Technology Limited"],
      "00118B" => ["Alcatel-", "Alcatel-Lucent, Enterprise Business Group"],
      "00118C" => ["Missouri", "Missouri Department of Transportation"],
      "00118D" => ["Hanchang", "Hanchang System Corp."],
      "00118E" => ["Halytech", "Halytech Mace"],
      "00118F" => ["EutechIn", "EUTECH INSTRUMENTS PTE. LTD."],
      "001190" => ["DigitalD", "Digital Design Corporation"],
      "001191" => ["Cts-Clim", "CTS-Clima Temperatur Systeme GmbH"],
      "001192" => ["Cisco", "Cisco Systems"],
      "001193" => ["Cisco", "Cisco Systems"],
      "001194" => ["ChiMeiCo", "Chi Mei Communication Systems, Inc."],
      "001195" => ["D-Link", "D-Link Corporation"],
      "001196" => ["Actualit", "Actuality Systems, Inc."],
      "001197" => ["Monitori", "Monitoring Technologies Limited"],
      "001198" => ["PrismMed", "Prism Media Products Limited"],
      "001199" => ["2wcom", "2wcom GmbH"],
      "00119A" => ["AlkeriaS", "Alkeria srl"],
      "00119B" => ["Telesyne", "Telesynergy Research Inc."],
      "00119C" => ["Ep&TEner", "EP&T Energy"],
      "00119D" => ["DiginfoT", "Diginfo Technology Corporation"],
      "00119E" => ["Solectro", "Solectron Brazil"],
      "00119F" => ["NokiaDan", "Nokia Danmark A/S"],
      "0011A0" => ["VtechEng", "Vtech Engineering Canada Ltd"],
      "0011A1" => ["VisionNe", "VISION NETWARE CO.,LTD"],
      "0011A2" => ["Manufact", "Manufacturing Technology Inc"],
      "0011A3" => ["Lanready", "LanReady Technologies Inc."],
      "0011A4" => ["JstreamT", "JStream Technologies Inc."],
      "0011A5" => ["FortunaE", "Fortuna Electronic Corp."],
      "0011A6" => ["SypixxNe", "Sypixx Networks"],
      "0011A7" => ["InfilcoD", "Infilco Degremont Inc."],
      "0011A8" => ["QuestTec", "Quest Technologies"],
      "0011A9" => ["Moimston", "MOIMSTONE Co., LTD"],
      "0011AA" => ["Uniclass", "Uniclass Technology, Co., LTD"],
      "0011AB" => ["Trustabl", "TRUSTABLE TECHNOLOGY CO.,LTD."],
      "0011AC" => ["SimtecEl", "Simtec Electronics"],
      "0011AD" => ["Shanghai", "Shanghai Ruijie Technology"],
      "0011AE" => ["Motorola", "Motorola Mobility, Inc."],
      "0011AF" => ["Medialin", "Medialink-i,Inc"],
      "0011B0" => ["Fortelin", "Fortelink Inc."],
      "0011B1" => ["Blueexpe", "BlueExpert Technology Corp."],
      "0011B2" => ["2001Tech", "2001 Technology Inc."],
      "0011B3" => ["Yoshimiy", "YOSHIMIYA CO.,LTD."],
      "0011B4" => ["Westermo", "Westermo Teleindustri AB"],
      "0011B5" => ["Shenzhen", "Shenzhen Powercom Co.,Ltd"],
      "0011B6" => ["OpenInte", "Open Systems International"],
      "0011B7" => ["OctalixB", "Octalix B.V."],
      "0011B8" => ["Liebherr", "Liebherr - Elektronik GmbH"],
      "0011B9" => ["InnerRan", "Inner Range Pty. Ltd."],
      "0011BA" => ["ElexolPt", "Elexol Pty Ltd"],
      "0011BB" => ["Cisco", "Cisco Systems"],
      "0011BC" => ["Cisco", "Cisco Systems"],
      "0011BD" => ["Bombardi", "Bombardier Transportation"],
      "0011BE" => ["AgpTelec", "AGP Telecom Co. Ltd"],
      "0011BF" => ["AesysSPA", "AESYS S.p.A."],
      "0011C0" => ["AdayTech", "Aday Technology Inc"],
      "0011C1" => ["4pMobile", "4P MOBILE DATA PROCESSING"],
      "0011C2" => ["UnitedFi", "United Fiber Optic Communication"],
      "0011C3" => ["Transcei", "Transceiving System Technology Corporation"],
      "0011C4" => ["Terminal", "Terminales de Telecomunicacion Terrestre, S.L."],
      "0011C5" => ["TenTechn", "TEN Technology"],
      "0011C6" => ["SeagateT", "Seagate Technology LLC"],
      "0011C7" => ["Raymarin", "Raymarine UK Ltd"],
      "0011C8" => ["Powercom", "Powercom Co., Ltd."],
      "0011C9" => ["Mtt", "MTT Corporation"],
      "0011CA" => ["LongRang", "Long Range Systems, Inc."],
      "0011CB" => ["Jacobson", "Jacobsons AB"],
      "0011CC" => ["Guangzho", "Guangzhou Jinpeng Group Co.,Ltd."],
      "0011CD" => ["AxsunTec", "Axsun Technologies"],
      "0011CE" => ["Ubisense", "Ubisense Limited"],
      "0011CF" => ["ThraneTh", "Thrane & Thrane A/S"],
      "0011D0" => ["Tandberg", "Tandberg Data ASA"],
      "0011D1" => ["SoftImag", "Soft Imaging System GmbH"],
      "0011D2" => ["Percepti", "Perception Digital Ltd"],
      "0011D3" => ["Nextgent", "NextGenTel Holding ASA"],
      "0011D4" => ["Netenric", "NetEnrich, Inc"],
      "0011D5" => ["Hangzhou", "Hangzhou Sunyard System Engineering Co.,Ltd."],
      "0011D6" => ["Handera", "HandEra, Inc."],
      "0011D7" => ["Ewerks", "eWerks Inc"],
      "0011D8" => ["AsustekC", "ASUSTek Computer Inc."],
      "0011D9" => ["Tivo",""],
      "0011DA" => ["VivaasTe", "Vivaas Technology Inc."],
      "0011DB" => ["Land-Cel", "Land-Cellular Corporation"],
      "0011DC" => ["GlunzJen", "Glunz & Jensen"],
      "0011DD" => ["FromusTe", "FROMUS TEC. Co., Ltd."],
      "0011DE" => ["Eurilogi", "EURILOGIC"],
      "0011DF" => ["CurrentE", "Current Energy"],
      "0011E0" => ["U-MediaC", "U-MEDIA Communications, Inc."],
      "0011E1" => ["ArcelikA", "Arcelik A.S"],
      "0011E2" => ["HuaJungC", "Hua Jung Components Co., Ltd."],
      "0011E3" => ["Thomson", "Thomson, Inc."],
      "0011E4" => ["DanelecE", "Danelec Electronics A/S"],
      "0011E5" => ["Kcodes", "KCodes Corporation"],
      "0011E6" => ["Scientif", "Scientific Atlanta"],
      "0011E7" => ["Worldsat", "WORLDSAT - Texas de France"],
      "0011E8" => ["TixiCom", "Tixi.Com"],
      "0011E9" => ["Starnex", "STARNEX CO., LTD."],
      "0011EA" => ["Iwics", "IWICS Inc."],
      "0011EB" => ["Innovati", "Innovative Integration"],
      "0011EC" => ["Avix", "AVIX INC."],
      "0011ED" => ["802Globa", "802 Global"],
      "0011EE" => ["Estari", "Estari, Inc."],
      "0011EF" => ["ConitecD", "Conitec Datensysteme GmbH"],
      "0011F0" => ["Wideful", "Wideful Limited"],
      "0011F1" => ["Qinetiq", "QinetiQ Ltd"],
      "0011F2" => ["Institut", "Institute of Network Technologies"],
      "0011F3" => ["Neomedia", "NeoMedia Europe AG"],
      "0011F4" => ["Woori-Ne", "woori-net"],
      "0011F5" => ["AskeyCom", "ASKEY COMPUTER CORP."],
      "0011F6" => ["AsiaPaci", "Asia Pacific Microsystems , Inc."],
      "0011F7" => ["Shenzhen", "Shenzhen Forward Industry Co., Ltd"],
      "0011F8" => ["Airaya", "AIRAYA Corp"],
      "0011F9" => ["NortelNe", "Nortel Networks"],
      "0011FA" => ["Rane", "Rane Corporation"],
      "0011FB" => ["Heidelbe", "Heidelberg Engineering GmbH"],
      "0011FC" => ["HartingE", "HARTING Electric Gmbh & Co.KG"],
      "0011FD" => ["Korg", "KORG INC."],
      "0011FE" => ["KeiyoSys", "Keiyo System Research, Inc."],
      "0011FF" => ["DigitroT", "Digitro Tecnologia Ltda"],
      "001200" => ["Cisco",""],
      "001201" => ["Cisco",""],
      "001202" => ["DecraneA", "Decrane Aerospace - Audio International Inc."],
      "001203" => ["ActivNet", "Activ Networks"],
      "001204" => ["U10Netwo", "u10 Networks, Inc."],
      "001205" => ["Terrasat", "Terrasat Communications, Inc."],
      "001206" => ["IquestNz", "iQuest (NZ) Ltd"],
      "001207" => ["HeadStro", "Head Strong International Limited"],
      "001208" => ["GantnerI", "Gantner Instruments GmbH"],
      "001209" => ["Fastrax", "Fastrax Ltd"],
      "00120A" => ["EmersonE", "Emerson Electric GmbH & Co. OHG"],
      "00120B" => ["Chinasys", "Chinasys Technologies Limited"],
      "00120C" => ["Ce-Infos", "CE-Infosys Pte Ltd"],
      "00120D" => ["Advanced", "Advanced Telecommunication Technologies, Inc."],
      "00120E" => ["Abocom",""],
      "00120F" => ["Ieee8023", "IEEE 802.3"],
      "001210" => ["Wideray", "WideRay Corp"],
      "001211" => ["Protechn", "Protechna Herbst GmbH & Co. KG"],
      "001212" => ["Plus", "PLUS  Corporation"],
      "001213" => ["Metrohm", "Metrohm AG"],
      "001214" => ["KoenigBa", "Koenig & Bauer AG"],
      "001215" => ["IstorNet", "iStor Networks, Inc."],
      "001216" => ["IcpInter", "ICP Internet Communication Payment AG"],
      "001217" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "001218" => ["Aruze", "ARUZE Corporation"],
      "001219" => ["AheadCom", "Ahead Communication Systems Inc"],
      "00121A" => ["TechnoSo", "Techno Soft Systemnics Inc."],
      "00121B" => ["SoundDev", "Sound Devices, LLC"],
      "00121C" => ["ParrotSA", "PARROT S.A."],
      "00121D" => ["Netfabri", "Netfabric Corporation"],
      "00121E" => ["JuniperN", "Juniper Networks, Inc."],
      "00121F" => ["HardingI", "Harding Intruments"],
      "001220" => ["Cadco", "Cadco Systems"],
      "001221" => ["BBraunMe", "B.Braun Melsungen AG"],
      "001222" => ["SkardinU", "Skardin (UK) Ltd"],
      "001223" => ["Pixim",""],
      "001224" => ["Nexql", "NexQL Corporation"],
      "001225" => ["Motorola", "Motorola Mobility, Inc."],
      "001226" => ["JapanDir", "Japan Direx Corporation"],
      "001227" => ["Franklin", "Franklin Electric Co., Inc."],
      "001228" => ["Data", "Data Ltd."],
      "001229" => ["Broadeas", "BroadEasy Technologies Co.,Ltd"],
      "00122A" => ["VtechTel", "VTech Telecommunications Ltd."],
      "00122B" => ["Virbiage", "Virbiage Pty Ltd"],
      "00122C" => ["SoenenCo", "Soenen Controls N.V."],
      "00122D" => ["Sinett", "SiNett Corporation"],
      "00122E" => ["SignalTe", "Signal Technology - AISD"],
      "00122F" => ["SaneiEle", "Sanei Electric Inc."],
      "001230" => ["PicasoIn", "Picaso Infocommunication CO., LTD."],
      "001231" => ["MotionCo", "Motion Control Systems, Inc."],
      "001232" => ["LewizCom", "LeWiz Communications Inc."],
      "001233" => ["JrcTokki", "JRC TOKKI Co.,Ltd."],
      "001234" => ["CamilleB", "Camille Bauer"],
      "001235" => ["Andrew", "Andrew Corporation"],
      "001236" => ["Consentr", "ConSentry Networks"],
      "001237" => ["TexasIns", "Texas Instruments"],
      "001238" => ["SetaboxT", "SetaBox Technology Co., Ltd."],
      "001239" => ["SNet", "S Net Systems Inc."],
      "00123A" => ["Posystec", "Posystech Inc., Co."],
      "00123B" => ["KeroAps", "KeRo Systems ApS"],
      "00123C" => ["SecondRu", "Second Rule LLC"],
      "00123D" => ["Ges",""],
      "00123E" => ["EruneTec", "ERUNE technology Co., Ltd."],
      "00123F" => ["Dell", "Dell Inc"],
      "001240" => ["AmoiElec", "AMOI ELECTRONICS CO.,LTD"],
      "001241" => ["A2iMarke", "a2i marketing center"],
      "001242" => ["Millenni", "Millennial Net"],
      "001243" => ["Cisco",""],
      "001244" => ["Cisco",""],
      "001245" => ["Zellwege", "Zellweger Analytics, Inc."],
      "001246" => ["TOMTechn", "T.O.M TECHNOLOGY INC.."],
      "001247" => ["SamsungE", "Samsung Electronics Co., Ltd."],
      "001248" => ["EmcKashy", "EMC Corporation (Kashya)"],
      "001249" => ["DeltaEle", "Delta Elettronica S.p.A."],
      "00124A" => ["Dedicate", "Dedicated Devices, Inc."],
      "00124B" => ["TexasIns", "Texas Instruments"],
      "00124C" => ["Bbwm", "BBWM Corporation"],
      "00124D" => ["InduconB", "Inducon BV"],
      "00124E" => ["XacAutom", "XAC AUTOMATION CORP."],
      "00124F" => ["TycoTher", "Tyco Thermal Controls LLC."],
      "001250" => ["TokyoAir", "Tokyo Aircaft Instrument Co., Ltd."],
      "001251" => ["Silink",""],
      "001252" => ["Citronix", "Citronix, LLC"],
      "001253" => ["Audiodev", "AudioDev AB"],
      "001254" => ["SpectraT", "Spectra Technologies Holdings Company Ltd"],
      "001255" => ["Neteffec", "NetEffect Incorporated"],
      "001256" => ["LgInform", "LG INFORMATION & COMM."],
      "001257" => ["Leapcomm", "LeapComm Communication Technologies Inc."],
      "001258" => ["ActivisP", "Activis Polska"],
      "001259" => ["ThermoEl", "THERMO ELECTRON KARLSRUHE"],
      "00125A" => ["Microsof", "Microsoft Corporation"],
      "00125B" => ["KaimeiEl", "KAIMEI ELECTRONI"],
      "00125C" => ["GreenHil", "Green Hills Software, Inc."],
      "00125D" => ["Cybernet", "CyberNet Inc."],
      "00125E" => ["Caen",""],
      "00125F" => ["Awind", "AWIND Inc."],
      "001260" => ["StantonM", "Stanton Magnetics,inc."],
      "001261" => ["Adaptix", "Adaptix, Inc"],
      "001262" => ["NokiaDan", "Nokia Danmark A/S"],
      "001263" => ["DataVoic", "Data Voice Technologies GmbH"],
      "001264" => ["DaumElec", "daum electronic gmbh"],
      "001265" => ["Enerdyne", "Enerdyne Technologies, Inc."],
      "001266" => ["Swisscom", "Swisscom Hospitality Services SA"],
      "001267" => ["Matsushi", "Matsushita Electronic Components Co., Ltd."],
      "001268" => ["IpsDOO", "IPS d.o.o."],
      "001269" => ["ValueEle", "Value Electronics"],
      "00126A" => ["Optoelec", "OPTOELECTRONICS Co., Ltd."],
      "00126B" => ["Ascalade", "Ascalade Communications Limited"],
      "00126C" => ["Visonic", "Visonic Ltd."],
      "00126D" => ["Universi", "University of California, Berkeley"],
      "00126E" => ["SeidelEl", "Seidel Elektronik GmbH Nfg.KG"],
      "00126F" => ["RaysonTe", "Rayson Technology Co., Ltd."],
      "001270" => ["NgesDenr", "NGES Denro Systems"],
      "001271" => ["Measurem", "Measurement Computing Corp"],
      "001272" => ["ReduxCom", "Redux Communications Ltd."],
      "001273" => ["Stoke", "Stoke Inc"],
      "001274" => ["NitLab", "NIT lab"],
      "001275" => ["Sentilla", "Sentilla Corporation"],
      "001276" => ["CgPowerI", "CG Power Systems Ireland Limited"],
      "001277" => ["KorenixT", "Korenix Technologies Co., Ltd."],
      "001278" => ["Internat", "International Bar Code"],
      "001279" => ["Hewlett-", "Hewlett-Packard Company"],
      "00127A" => ["SanyuInd", "Sanyu Industry Co.,Ltd."],
      "00127B" => ["ViaNetwo", "VIA Networking Technologies, Inc."],
      "00127C" => ["Swegon", "SWEGON AB"],
      "00127D" => ["Mobilear", "MobileAria"],
      "00127E" => ["DigitalL", "Digital Lifestyles Group, Inc."],
      "00127F" => ["Cisco",""],
      "001280" => ["Cisco",""],
      "001281" => ["MarchNet", "March Networks S.p.A."],
      "001282" => ["Qovia",""],
      "001283" => ["NortelNe", "Nortel Networks"],
      "001284" => ["Lab33Srl", "Lab33 Srl"],
      "001285" => ["Gizmondo", "Gizmondo Europe Ltd"],
      "001286" => ["Endevco", "ENDEVCO CORP"],
      "001287" => ["DigitalE", "Digital Everywhere Unterhaltungselektronik GmbH"],
      "001288" => ["2wire", "2Wire, Inc"],
      "001289" => ["AdvanceS", "Advance Sterilization Products"],
      "00128A" => ["Motorola", "Motorola Mobility, Inc."],
      "00128B" => ["SensoryN", "Sensory Networks Inc"],
      "00128C" => ["Woodward", "Woodward Governor"],
      "00128D" => ["StbDaten", "STB Datenservice GmbH"],
      "00128E" => ["Q-FreeAs", "Q-Free ASA"],
      "00128F" => ["Montilio",""],
      "001290" => ["KyowaEle", "KYOWA Electric & Machinery Corp."],
      "001291" => ["KwsCompu", "KWS Computersysteme GmbH"],
      "001292" => ["GriffinT", "Griffin Technology"],
      "001293" => ["GeEnergy", "GE Energy"],
      "001294" => ["Sumitomo", "SUMITOMO ELECTRIC DEVICE INNOVATIONS, INC"],
      "001295" => ["Aiware", "Aiware Inc."],
      "001296" => ["Addlogix",""],
      "001297" => ["O2micro", "O2Micro, Inc."],
      "001298" => ["MicoElec", "MICO ELECTRIC(SHENZHEN) LIMITED"],
      "001299" => ["KtechTel", "Ktech Telecommunications Inc"],
      "00129A" => ["IrtElect", "IRT Electronics Pty Ltd"],
      "00129B" => ["E2sElect", "E2S Electronic Engineering Solutions, S.L."],
      "00129C" => ["Yulinet",""],
      "00129D" => ["FirstInt", "First International Computer do Brasil"],
      "00129E" => ["SurfComm", "Surf Communications Inc."],
      "00129F" => ["Rae", "RAE Systems"],
      "0012A0" => ["Neomerid", "NeoMeridian Sdn Bhd"],
      "0012A1" => ["Bluepack", "BluePacket Communications Co., Ltd."],
      "0012A2" => ["Vita",""],
      "0012A3" => ["TrustInt", "Trust International B.V."],
      "0012A4" => ["Thingmag", "ThingMagic, LLC"],
      "0012A5" => ["Stargen", "Stargen, Inc."],
      "0012A6" => ["DolbyAus", "Dolby Australia"],
      "0012A7" => ["IsrTechn", "ISR TECHNOLOGIES Inc"],
      "0012A8" => ["Intec", "intec GmbH"],
      "0012A9" => ["3com", "3Com Ltd"],
      "0012AA" => ["Iee", "IEE, Inc."],
      "0012AB" => ["Wilife", "WiLife, Inc."],
      "0012AC" => ["Ontimete", "ONTIMETEK INC."],
      "0012AD" => ["Ids", "IDS GmbH"],
      "0012AE" => ["HlsHard-", "HLS HARD-LINE Solutions Inc."],
      "0012AF" => ["ElproTec", "ELPRO Technologies"],
      "0012B0" => ["EforeOyj", "Efore Oyj   (Plc)"],
      "0012B1" => ["DaiNippo", "Dai Nippon Printing Co., Ltd"],
      "0012B2" => ["Avolites", "AVOLITES LTD."],
      "0012B3" => ["AdvanceW", "Advance Wireless Technology Corp."],
      "0012B4" => ["WorkMicr", "Work Microwave GmbH"],
      "0012B5" => ["Vialta", "Vialta, Inc."],
      "0012B6" => ["SantaBar", "Santa Barbara Infrared, Inc."],
      "0012B7" => ["PtwFreib", "PTW Freiburg"],
      "0012B8" => ["G2Micros", "G2 Microsystems"],
      "0012B9" => ["FusionDi", "Fusion Digital Technology"],
      "0012BA" => ["Fsi", "FSI Systems, Inc."],
      "0012BB" => ["Telecomm", "Telecommunications Industry Association TR-41 Committee"],
      "0012BC" => ["EcholabL", "Echolab LLC"],
      "0012BD" => ["AvantecM", "Avantec Manufacturing Limited"],
      "0012BE" => ["Astek", "Astek Corporation"],
      "0012BF" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "0012C0" => ["Hotlava", "HotLava Systems, Inc."],
      "0012C1" => ["CheckPoi", "Check Point Software Technologies"],
      "0012C2" => ["ApexElec", "Apex Electronics Factory"],
      "0012C3" => ["WitSA", "WIT S.A."],
      "0012C4" => ["Viseon", "Viseon, Inc."],
      "0012C5" => ["V-ShowTe", "V-Show  Technology (China) Co.,Ltd"],
      "0012C6" => ["TgcAmeri", "TGC America, Inc"],
      "0012C7" => ["SecurayT", "SECURAY Technologies Ltd.Co."],
      "0012C8" => ["PerfectT", "Perfect tech"],
      "0012C9" => ["Motorola", "Motorola Mobility, Inc."],
      "0012CA" => ["Mechatro", "Mechatronic Brick Aps"],
      "0012CB" => ["Css", "CSS Inc."],
      "0012CC" => ["Bitatek", "Bitatek CO., LTD"],
      "0012CD" => ["Asem", "ASEM SpA"],
      "0012CE" => ["Advanced", "Advanced Cybernetics Group"],
      "0012CF" => ["AcctonTe", "Accton Technology Corporation"],
      "0012D0" => ["Gossen-M", "Gossen-Metrawatt-GmbH"],
      "0012D1" => ["TexasIns", "Texas Instruments Inc"],
      "0012D2" => ["TexasIns", "Texas Instruments"],
      "0012D3" => ["Zetta", "Zetta Systems, Inc."],
      "0012D4" => ["Princeto", "Princeton Technology, Ltd"],
      "0012D5" => ["MotionRe", "Motion Reality Inc."],
      "0012D6" => ["JiangsuY", "Jiangsu Yitong High-Tech Co.,Ltd"],
      "0012D7" => ["InventoN", "Invento Networks, Inc."],
      "0012D8" => ["Internat", "International Games System Co., Ltd."],
      "0012D9" => ["Cisco", "Cisco Systems"],
      "0012DA" => ["Cisco", "Cisco Systems"],
      "0012DB" => ["ZiehlInd", "ZIEHL industrie-elektronik GmbH + Co KG"],
      "0012DC" => ["SuncorpI", "SunCorp Industrial Limited"],
      "0012DD" => ["ShengquI", "Shengqu Information Technology (Shanghai) Co., Ltd."],
      "0012DE" => ["RadioCom", "Radio Components Sweden AB"],
      "0012DF" => ["Novomati", "Novomatic AG"],
      "0012E0" => ["Codan", "Codan Limited"],
      "0012E1" => ["AlliantN", "Alliant Networks, Inc"],
      "0012E2" => ["AlaxalaN", "ALAXALA Networks Corporation"],
      "0012E3" => ["Agat-Rt", "Agat-RT, Ltd."],
      "0012E4" => ["ZiehlInd", "ZIEHL industrie-electronik GmbH + Co KG"],
      "0012E5" => ["TimeAmer", "Time America, Inc."],
      "0012E6" => ["SpectecC", "SPECTEC COMPUTER CO., LTD."],
      "0012E7" => ["Projecte", "Projectek Networking Electronics Corp."],
      "0012E8" => ["Fraunhof", "Fraunhofer IMS"],
      "0012E9" => ["Abbey", "Abbey Systems Ltd"],
      "0012EA" => ["Trane",""],
      "0012EB" => ["R2diLlc", "R2DI, LLC"],
      "0012EC" => ["Movacolo", "Movacolor b.v."],
      "0012ED" => ["AvgAdvan", "AVG Advanced Technologies"],
      "0012EE" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "0012EF" => ["Oneacces", "OneAccess SA"],
      "0012F0" => ["IntelCor", "Intel Corporate"],
      "0012F1" => ["Ifotec",""],
      "0012F2" => ["BrocadeC", "Brocade Communications Systems, Inc"],
      "0012F3" => ["Connectb", "connectBlue AB"],
      "0012F4" => ["BelcoInt", "Belco International Co.,Ltd."],
      "0012F5" => ["ImardaNe", "Imarda New Zealand Limited"],
      "0012F6" => ["Mdk", "MDK CO.,LTD."],
      "0012F7" => ["XiamenXi", "Xiamen Xinglian Electronics Co., Ltd."],
      "0012F8" => ["WniResou", "WNI Resources, LLC"],
      "0012F9" => ["UryuSeis", "URYU SEISAKU, LTD."],
      "0012FA" => ["Thx", "THX LTD"],
      "0012FB" => ["SamsungE", "Samsung Electronics"],
      "0012FC" => ["PlanetSy", "PLANET System Co.,LTD"],
      "0012FD" => ["OptimusI", "OPTIMUS IC S.A."],
      "0012FE" => ["LenovoMo", "Lenovo Mobile Communication Technology Ltd."],
      "0012FF" => ["LelyIndu", "Lely Industries N.V."],
      "001300" => ["It-Facto", "IT-FACTORY, INC."],
      "001301" => ["Irongate", "IronGate S.L."],
      "001302" => ["IntelCor", "Intel Corporate"],
      "001303" => ["Gateconn", "GateConnect Technologies GmbH"],
      "001304" => ["Flaircom", "Flaircomm Technologies Co. LTD"],
      "001305" => ["Epicom", "Epicom, Inc."],
      "001306" => ["AlwaysOn", "Always On Wireless"],
      "001307" => ["Paravirt", "Paravirtual Corporation"],
      "001308" => ["NuveraFu", "Nuvera Fuel Cells"],
      "001309" => ["OceanBro", "Ocean Broadband Networks"],
      "00130A" => ["Nortel",""],
      "00130B" => ["MextalBV", "Mextal B.V."],
      "00130C" => ["HfSystem", "HF System Corporation"],
      "00130D" => ["GalileoA", "GALILEO AVIONICA"],
      "00130E" => ["Focusrit", "Focusrite Audio Engineering Limited"],
      "00130F" => ["EgemenBi", "EGEMEN Bilgisayar Muh San ve Tic LTD STI"],
      "001310" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "001311" => ["ArrisInt", "ARRIS International"],
      "001312" => ["AmediaNe", "Amedia Networks Inc."],
      "001313" => ["Guangzho", "GuangZhou Post & Telecom Equipment ltd"],
      "001314" => ["Asiamajo", "Asiamajor Inc."],
      "001315" => ["SonyComp", "SONY Computer Entertainment inc,"],
      "001316" => ["L-S-BBro", "L-S-B Broadcast Technologies GmbH"],
      "001317" => ["GnNetcom", "GN Netcom as"],
      "001318" => ["Dgstatio", "DGSTATION Co., Ltd."],
      "001319" => ["Cisco", "Cisco Systems"],
      "00131A" => ["Cisco", "Cisco Systems"],
      "00131B" => ["BecellIn", "BeCell Innovations Corp."],
      "00131C" => ["Litetouc", "LiteTouch, Inc."],
      "00131D" => ["Scanvaeg", "Scanvaegt International A/S"],
      "00131E" => ["PeikerAc", "Peiker acustic GmbH & Co. KG"],
      "00131F" => ["Nxtphase", "NxtPhase T&D, Corp."],
      "001320" => ["IntelCor", "Intel Corporate"],
      "001321" => ["Hewlett-", "Hewlett-Packard Company"],
      "001322" => ["DaqElect", "DAQ Electronics, Inc."],
      "001323" => ["Cap", "Cap Co., Ltd."],
      "001324" => ["Schneide", "Schneider Electric Ultra Terminal"],
      "001325" => ["Cortina", "Cortina Systems Inc"],
      "001326" => ["Ecm", "ECM Systems Ltd"],
      "001327" => ["DataAcqu", "Data Acquisitions limited"],
      "001328" => ["WestechK", "Westech Korea Inc.,"],
      "001329" => ["Vsst", "VSST Co., LTD"],
      "00132A" => ["Sitronic", "Sitronics Telecom Solutions"],
      "00132B" => ["PhoenixD", "Phoenix Digital"],
      "00132C" => ["MazBrand", "MAZ Brandenburg GmbH"],
      "00132D" => ["IwiseCom", "iWise Communications"],
      "00132E" => ["ItianCop", "ITian Coporation"],
      "00132F" => ["Interact", "Interactek"],
      "001330" => ["EuroProt", "EURO PROTECTION SURVEILLANCE"],
      "001331" => ["Cellpoin", "CellPoint Connect"],
      "001332" => ["BeijingT", "Beijing Topsec Network Security Technology Co., Ltd."],
      "001333" => ["Baudtec", "BaudTec Corporation"],
      "001334" => ["Arkados", "Arkados, Inc."],
      "001335" => ["VsIndust", "VS Industry Berhad"],
      "001336" => ["Tianjin7", "Tianjin 712 Communication Broadcasting co., ltd."],
      "001337" => ["OrientPo", "Orient Power Home Network Ltd."],
      "001338" => ["Freseniu", "FRESENIUS-VIAL"],
      "001339" => ["El-Me", "EL-ME AG"],
      "00133A" => ["Vadatech", "VadaTech Inc."],
      "00133B" => ["SpeedDra", "Speed Dragon Multimedia Limited"],
      "00133C" => ["Quintron", "QUINTRON SYSTEMS INC."],
      "00133D" => ["MicroMem", "Micro Memory Curtiss Wright Co"],
      "00133E" => ["Metaswit", "MetaSwitch"],
      "00133F" => ["Eppendor", "Eppendorf Instrumente GmbH"],
      "001340" => ["AdElSRL", "AD.EL s.r.l."],
      "001341" => ["Shandong", "Shandong New Beiyang Information Technology Co.,Ltd"],
      "001342" => ["VisionRe", "Vision Research, Inc."],
      "001343" => ["Matsushi", "Matsushita Electronic Components (Europe) GmbH"],
      "001344" => ["FargoEle", "Fargo Electronics Inc."],
      "001345" => ["Eaton", "Eaton Corporation"],
      "001346" => ["D-Link", "D-Link Corporation"],
      "001347" => ["Bluetree", "BlueTree Wireless Data Inc."],
      "001348" => ["ArtilaEl", "Artila Electronics Co., Ltd."],
      "001349" => ["ZyxelCom", "ZyXEL Communications Corporation"],
      "00134A" => ["Engim", "Engim, Inc."],
      "00134B" => ["Togolden", "ToGoldenNet Technology Inc."],
      "00134C" => ["YdtTechn", "YDT Technology International"],
      "00134D" => ["IneproBv", "Inepro BV"],
      "00134E" => ["Valox", "Valox Systems, Inc."],
      "00134F" => ["TranzeoW", "Tranzeo Wireless Technologies Inc."],
      "001350" => ["SilverSp", "Silver Spring Networks, Inc"],
      "001351" => ["NilesAud", "Niles Audio Corporation"],
      "001352" => ["Naztec", "Naztec, Inc."],
      "001353" => ["HydacFil", "HYDAC Filtertechnik GMBH"],
      "001354" => ["ZcomaxTe", "Zcomax Technologies, Inc."],
      "001355" => ["TomenCyb", "TOMEN Cyber-business Solutions, Inc."],
      "001356" => ["FlirRadi", "FLIR Radiation GmbH"],
      "001357" => ["SoyalTec", "Soyal Technology Co., Ltd."],
      "001358" => ["Realm", "Realm Systems, Inc."],
      "001359" => ["Protelev", "ProTelevision Technologies A/S"],
      "00135A" => ["ProjectT", "Project T&E Limited"],
      "00135B" => ["Panellin", "PanelLink Cinema, LLC"],
      "00135C" => ["Onsite", "OnSite Systems, Inc."],
      "00135D" => ["NttpcCom", "NTTPC Communications, Inc."],
      "00135E" => ["Eab/Rwi/", "EAB/RWI/K"],
      "00135F" => ["Cisco", "Cisco Systems"],
      "001360" => ["Cisco", "Cisco Systems"],
      "001361" => ["Biospace", "Biospace Co., Ltd."],
      "001362" => ["Shinheun", "ShinHeung Precision Co., Ltd."],
      "001363" => ["Verascap", "Verascape, Inc."],
      "001364" => ["Paradigm", "Paradigm Technology Inc.."],
      "001365" => ["Nortel",""],
      "001366" => ["Neturity", "Neturity Technologies Inc."],
      "001367" => ["Narayon", "Narayon. Co., Ltd."],
      "001368" => ["MaerskDa", "Maersk Data Defence"],
      "001369" => ["HondaEle", "Honda Electron Co., LED."],
      "00136A" => ["HachLang", "Hach Lange SA"],
      "00136B" => ["E-Tec",""],
      "00136C" => ["Tomtom",""],
      "00136D" => ["Tentacul", "Tentaculus AB"],
      "00136E" => ["Techmetr", "Techmetro Corp."],
      "00136F" => ["Packetmo", "PacketMotion, Inc."],
      "001370" => ["NokiaDan", "Nokia Danmark A/S"],
      "001371" => ["Motorola", "Motorola Mobility, Inc."],
      "001372" => ["Dell", "Dell Inc."],
      "001373" => ["BlwaveEl", "BLwave Electronics Co., Ltd"],
      "001374" => ["AtherosC", "Atheros Communications, Inc."],
      "001375" => ["American", "American Security Products Co."],
      "001376" => ["TaborEle", "Tabor Electronics Ltd."],
      "001377" => ["SamsungE", "Samsung Electronics CO., LTD"],
      "001378" => ["QsanTech", "QSAN Technology, Inc."],
      "001379" => ["PonderIn", "PONDER INFORMATION INDUSTRIES LTD."],
      "00137A" => ["NetvoxTe", "Netvox Technology Co., Ltd."],
      "00137B" => ["Movon", "Movon Corporation"],
      "00137C" => ["Kaicom", "Kaicom co., Ltd."],
      "00137D" => ["Dynalab", "Dynalab, Inc."],
      "00137E" => ["CoredgeN", "CorEdge Networks, Inc."],
      "00137F" => ["Cisco", "Cisco Systems"],
      "001380" => ["Cisco", "Cisco Systems"],
      "001381" => ["Chips", "CHIPS & Systems, Inc."],
      "001382" => ["CetaceaN", "Cetacea Networks Corporation"],
      "001383" => ["Applicat", "Application Technologies and Engineering Research Laboratory"],
      "001384" => ["Advanced", "Advanced Motion Controls"],
      "001385" => ["Add-OnTe", "Add-On Technology Co., LTD."],
      "001386" => ["Abb/Tota", "ABB Inc./Totalflow"],
      "001387" => ["27mTechn", "27M Technologies AB"],
      "001388" => ["WimediaA", "WiMedia Alliance"],
      "001389" => ["RedesDeT", "Redes de Telefonia Movil S.A."],
      "00138A" => ["QingdaoG", "QINGDAO GOERTEK ELECTRONICS CO.,LTD."],
      "00138B" => ["PhantomT", "Phantom Technologies LLC"],
      "00138C" => ["Kumyoung", "Kumyoung.Co.Ltd"],
      "00138D" => ["Kinghold",""],
      "00138E" => ["FoabElek", "FOAB Elektronik AB"],
      "00138F" => ["Asiarock", "Asiarock Incorporation"],
      "001390" => ["TermtekC", "Termtek Computer Co., Ltd"],
      "001391" => ["Ouen", "OUEN CO.,LTD."],
      "001392" => ["RuckusWi", "Ruckus Wireless"],
      "001393" => ["Panta", "Panta Systems, Inc."],
      "001394" => ["Infohand", "Infohand Co.,Ltd"],
      "001395" => ["Congatec", "congatec AG"],
      "001396" => ["AcbelPol", "Acbel Polytech Inc."],
      "001397" => ["Xsigo", "Xsigo Systems, Inc."],
      "001398" => ["Traffics", "TrafficSim Co.,Ltd"],
      "001399" => ["Stac", "STAC Corporation."],
      "00139A" => ["K-Ubique", "K-ubique ID Corp."],
      "00139B" => ["Ioimage", "ioIMAGE Ltd."],
      "00139C" => ["ExaveraT", "Exavera Technologies, Inc."],
      "00139D" => ["MarvellH", "Marvell Hispana S.L."],
      "00139E" => ["CiaraTec", "Ciara Technologies Inc."],
      "00139F" => ["Electron", "Electronics Design Services, Co., Ltd."],
      "0013A0" => ["Algosyst", "ALGOSYSTEM Co., Ltd."],
      "0013A1" => ["CrowElec", "Crow Electronic Engeneering"],
      "0013A2" => ["Maxstrea", "MaxStream, Inc"],
      "0013A3" => ["SiemensC", "Siemens Com CPE Devices"],
      "0013A4" => ["KeyeyeCo", "KeyEye Communications"],
      "0013A5" => ["GeneralS", "General Solutions, LTD."],
      "0013A6" => ["Extricom", "Extricom Ltd"],
      "0013A7" => ["Battelle", "BATTELLE MEMORIAL INSTITUTE"],
      "0013A8" => ["TanisysT", "Tanisys Technology"],
      "0013A9" => ["Sony", "Sony Corporation"],
      "0013AA" => ["AlsTec", "ALS  & TEC Ltd."],
      "0013AB" => ["Telemoti", "Telemotive AG"],
      "0013AC" => ["Sunmyung", "Sunmyung Electronics Co., LTD"],
      "0013AD" => ["Sendo", "Sendo Ltd"],
      "0013AE" => ["Radiance", "Radiance Technologies, Inc."],
      "0013AF" => ["NumaTech", "NUMA Technology,Inc."],
      "0013B0" => ["Jablotro", "Jablotron"],
      "0013B1" => ["Intellig", "Intelligent Control Systems (Asia) Pte Ltd"],
      "0013B2" => ["Carallon", "Carallon Limited"],
      "0013B3" => ["EcomComm", "Ecom Communications Technology Co., Ltd."],
      "0013B4" => ["AppearTv", "Appear TV"],
      "0013B5" => ["Wavesat",""],
      "0013B6" => ["SlingMed", "Sling Media, Inc."],
      "0013B7" => ["Scantech", "Scantech ID"],
      "0013B8" => ["RycoElec", "RyCo Electronic Systems Limited"],
      "0013B9" => ["Bm", "BM SPA"],
      "0013BA" => ["Readylin", "ReadyLinks Inc"],
      "0013BB" => ["Smartvue", "Smartvue Corporation"],
      "0013BC" => ["Artimi", "Artimi Ltd"],
      "0013BD" => ["HymatomS", "HYMATOM SA"],
      "0013BE" => ["VirtualC", "Virtual Conexions"],
      "0013BF" => ["MediaSys", "Media System Planning Corp."],
      "0013C0" => ["TrixTecn", "Trix Tecnologia Ltda."],
      "0013C1" => ["AsokaUsa", "Asoka USA Corporation"],
      "0013C2" => ["Wacom", "WACOM Co.,Ltd"],
      "0013C3" => ["Cisco", "Cisco Systems"],
      "0013C4" => ["Cisco", "Cisco Systems"],
      "0013C5" => ["Lightron", "LIGHTRON FIBER-OPTIC DEVICES INC."],
      "0013C6" => ["Opengear", "OpenGear, Inc"],
      "0013C7" => ["Ionos", "IONOS Co.,Ltd."],
      "0013C8" => ["AdbBroad", "ADB Broadband Italia"],
      "0013C9" => ["BeyondAc", "Beyond Achieve Enterprises Ltd."],
      "0013CA" => ["PicoDigi", "Pico Digital"],
      "0013CB" => ["ZenitelN", "Zenitel Norway AS"],
      "0013CC" => ["TallMapl", "Tall Maple Systems"],
      "0013CD" => ["Mti", "MTI co. LTD"],
      "0013CE" => ["IntelCor", "Intel Corporate"],
      "0013CF" => ["4accessC", "4Access Communications"],
      "0013D0" => ["T+Medica", "t+ Medical Ltd"],
      "0013D1" => ["KirkTele", "KIRK telecom A/S"],
      "0013D2" => ["PageIber", "PAGE IBERICA, S.A."],
      "0013D3" => ["Micro-St", "MICRO-STAR INTERNATIONAL CO., LTD."],
      "0013D4" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "0013D5" => ["Ruggedco", "RuggedCom"],
      "0013D6" => ["TiiNetwo", "TII NETWORK TECHNOLOGIES, INC."],
      "0013D7" => ["SpidcomT", "SPIDCOM Technologies SA"],
      "0013D8" => ["Princeto", "Princeton Instruments"],
      "0013D9" => ["MatrixPr", "Matrix Product Development, Inc."],
      "0013DA" => ["Diskware", "Diskware Co., Ltd"],
      "0013DB" => ["ShoeiEle", "SHOEI Electric Co.,Ltd"],
      "0013DC" => ["Ibtek", "IBTEK INC."],
      "0013DD" => ["AbbottDi", "Abbott Diagnostics"],
      "0013DE" => ["Adapt4Ll", "Adapt4, LLC"],
      "0013DF" => ["Ryvor", "Ryvor Corp."],
      "0013E0" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "0013E1" => ["Iprobe", "Iprobe AB"],
      "0013E2" => ["Geovisio", "GeoVision Inc."],
      "0013E3" => ["CoviTech", "CoVi Technologies, Inc."],
      "0013E4" => ["Yangjae", "YANGJAE SYSTEMS CORP."],
      "0013E5" => ["Tenosys", "TENOSYS, INC."],
      "0013E6" => ["Technolu", "Technolution"],
      "0013E7" => ["Halcro",""],
      "0013E8" => ["IntelCor", "Intel Corporate"],
      "0013E9" => ["Veriwave", "VeriWave, Inc."],
      "0013EA" => ["Kamstrup", "Kamstrup A/S"],
      "0013EB" => ["Sysmaste", "Sysmaster Corporation"],
      "0013EC" => ["SunbaySo", "Sunbay Software AG"],
      "0013ED" => ["Psia",""],
      "0013EE" => ["JbxDesig", "JBX Designs Inc."],
      "0013EF" => ["KingjonD", "Kingjon Digital Technology Co.,Ltd"],
      "0013F0" => ["Wavefron", "Wavefront Semiconductor"],
      "0013F1" => ["AmodTech", "AMOD Technology Co., Ltd."],
      "0013F2" => ["Klas", "Klas Ltd"],
      "0013F3" => ["Giga-Byt", "Giga-byte Communications Inc."],
      "0013F4" => ["PsitekPt", "Psitek (Pty) Ltd"],
      "0013F5" => ["Akimbi", "Akimbi Systems"],
      "0013F6" => ["Cintech",""],
      "0013F7" => ["SmcNetwo", "SMC Networks, Inc."],
      "0013F8" => ["DexSecur", "Dex Security Solutions"],
      "0013F9" => ["Cavera", "Cavera Systems"],
      "0013FA" => ["Lifesize", "LifeSize Communications, Inc"],
      "0013FB" => ["RkcInstr", "RKC INSTRUMENT INC."],
      "0013FC" => ["Sicortex", "SiCortex, Inc"],
      "0013FD" => ["NokiaDan", "Nokia Danmark A/S"],
      "0013FE" => ["Grandtec", "GRANDTEC ELECTRONIC CORP."],
      "0013FF" => ["Dage-Mti", "Dage-MTI of MC, Inc."],
      "001400" => ["MinervaK", "MINERVA KOREA CO., LTD"],
      "001401" => ["Rivertre", "Rivertree Networks Corp."],
      "001402" => ["Kk-Elect", "kk-electronic a/s"],
      "001403" => ["RenasisL", "Renasis, LLC"],
      "001404" => ["Motorola", "Motorola Mobility, Inc."],
      "001405" => ["Openib", "OpenIB, Inc."],
      "001406" => ["GoNetwor", "Go Networks"],
      "001407" => ["SperianP", "Sperian Protection Instrumentation"],
      "001408" => ["Eka", "Eka Systems Inc."],
      "001409" => ["MagnetiM", "MAGNETI MARELLI   S.E. S.p.A."],
      "00140A" => ["Wepio", "WEPIO Co., Ltd."],
      "00140B" => ["FirstInt", "FIRST INTERNATIONAL COMPUTER, INC."],
      "00140C" => ["GkbCctv", "GKB CCTV CO., LTD."],
      "00140D" => ["Nortel",""],
      "00140E" => ["Nortel",""],
      "00140F" => ["FederalS", "Federal State Unitary Enterprise Leningrad R&D Institute of"],
      "001410" => ["SuzhouKe", "Suzhou Keda Technology CO.,Ltd"],
      "001411" => ["Deutschm", "Deutschmann Automation GmbH & Co. KG"],
      "001412" => ["S-TecEle", "S-TEC electronics AG"],
      "001413" => ["TrebingH", "Trebing & Himstedt Prozessautomation GmbH & Co. KG"],
      "001414" => ["Jumpnode", "Jumpnode Systems LLC."],
      "001415" => ["IntecAut", "Intec Automation Inc."],
      "001416" => ["ScoscheI", "Scosche Industries, Inc."],
      "001417" => ["RseInfor", "RSE Informations Technologie GmbH"],
      "001418" => ["C4line",""],
      "001419" => ["Sidsa",""],
      "00141A" => ["Deicy", "DEICY CORPORATION"],
      "00141B" => ["Cisco", "Cisco Systems"],
      "00141C" => ["Cisco", "Cisco Systems"],
      "00141D" => ["LustAntr", "Lust Antriebstechnik GmbH"],
      "00141E" => ["PASemi", "P.A. Semi, Inc."],
      "00141F" => ["Sunkwang", "SunKwang Electronics Co., Ltd"],
      "001420" => ["G-LinksN", "G-Links networking company"],
      "001421" => ["TotalWir", "Total Wireless Technologies Pte. Ltd."],
      "001422" => ["Dell", "Dell Inc."],
      "001423" => ["J-SNeuro", "J-S Co. NEUROCOM"],
      "001424" => ["MerryEle", "Merry Electrics CO., LTD."],
      "001425" => ["Galactic", "Galactic Computing Corp."],
      "001426" => ["NlTechno", "NL Technology"],
      "001427" => ["Jazzmuta", "JazzMutant"],
      "001428" => ["Vocollec", "Vocollect, Inc"],
      "001429" => ["VCenterT", "V Center Technologies Co., Ltd."],
      "00142A" => ["Elitegro", "Elitegroup Computer System Co., Ltd"],
      "00142B" => ["EdataCom", "Edata Communication Inc."],
      "00142C" => ["KonceptI", "Koncept International, Inc."],
      "00142D" => ["Toradex", "Toradex AG"],
      "00142E" => ["77Elektr", "77 Elektronika Kft."],
      "00142F" => ["Wildpack", "WildPackets"],
      "001430" => ["Vipower", "ViPowER, Inc"],
      "001431" => ["PdlElect", "PDL Electronics Ltd"],
      "001432" => ["Tarallax", "Tarallax Wireless, Inc."],
      "001433" => ["EmpowerT", "Empower Technologies(Canada) Inc."],
      "001434" => ["Keri", "Keri Systems, Inc"],
      "001435" => ["Citycom", "CityCom Corp."],
      "001436" => ["QwertyEl", "Qwerty Elektronik AB"],
      "001437" => ["Gstelete", "GSTeletech Co.,Ltd."],
      "001438" => ["Hewlett-", "Hewlett-Packard Company"],
      "001439" => ["BlonderT", "Blonder Tongue Laboratories, Inc."],
      "00143A" => ["RaytalkI", "RAYTALK INTERNATIONAL SRL"],
      "00143B" => ["Sensovat", "Sensovation AG"],
      "00143C" => ["Rheinmet", "Rheinmetall Canada Inc."],
      "00143D" => ["Aevoe", "Aevoe Inc."],
      "00143E" => ["AirlinkC", "AirLink Communications, Inc."],
      "00143F" => ["HotwayTe", "Hotway Technology Corporation"],
      "001440" => ["Atomic", "ATOMIC Corporation"],
      "001441" => ["Innovati", "Innovation Sound Technology Co., LTD."],
      "001442" => ["Atto", "ATTO CORPORATION"],
      "001443" => ["Consultr", "Consultronics Europe Ltd"],
      "001444" => ["Grundfos", "Grundfos Electronics"],
      "001445" => ["Telefon-", "Telefon-Gradnja d.o.o."],
      "001446" => ["Supervis", "SuperVision Solutions LLC"],
      "001447" => ["Boaz", "BOAZ Inc."],
      "001448" => ["Inventec", "Inventec Multimedia & Telecom Corporation"],
      "001449" => ["SichuanC", "Sichuan Changhong Electric Ltd."],
      "00144A" => ["TaiwanTh", "Taiwan Thick-Film Ind. Corp."],
      "00144B" => ["Hifn", "Hifn, Inc."],
      "00144C" => ["GeneralM", "General Meters Corp."],
      "00144D" => ["Intellig", "Intelligent Systems"],
      "00144E" => ["Srisa",""],
      "00144F" => ["Oracle", "Oracle Corporation"],
      "001450" => ["Heim", "Heim Systems GmbH"],
      "001451" => ["AppleCom", "Apple Computer Inc."],
      "001452" => ["Calculex", "CALCULEX,INC."],
      "001453" => ["Advantec", "ADVANTECH TECHNOLOGIES CO.,LTD"],
      "001454" => ["Symwave",""],
      "001455" => ["CoderEle", "Coder Electronics Corporation"],
      "001456" => ["EdgeProd", "Edge Products"],
      "001457" => ["T-VipsAs", "T-VIPS AS"],
      "001458" => ["HsAutoma", "HS Automatic ApS"],
      "001459" => ["Moram", "Moram Co., Ltd."],
      "00145A" => ["Neratec", "Neratec AG"],
      "00145B" => ["Seekerne", "SeekerNet Inc."],
      "00145C" => ["Intronic", "Intronics B.V."],
      "00145D" => ["WjCommun", "WJ Communications, Inc."],
      "00145E" => ["Ibm", "IBM Corp"],
      "00145F" => ["Aditec", "ADITEC CO. LTD"],
      "001460" => ["KyoceraW", "Kyocera Wireless Corp."],
      "001461" => ["Corona", "CORONA CORPORATION"],
      "001462" => ["Digiwell", "Digiwell Technology, inc"],
      "001463" => ["IdcsNV", "IDCS N.V."],
      "001464" => ["Cryptoso", "Cryptosoft"],
      "001465" => ["NovoNord", "Novo Nordisk A/S"],
      "001466" => ["Kleinhen", "Kleinhenz Elektronik GmbH"],
      "001467" => ["Arrowspa", "ArrowSpan Inc."],
      "001468" => ["CelplanI", "CelPlan International, Inc."],
      "001469" => ["Cisco", "Cisco Systems"],
      "00146A" => ["Cisco", "Cisco Systems"],
      "00146B" => ["Anagran", "Anagran, Inc."],
      "00146C" => ["Netgear", "Netgear Inc."],
      "00146D" => ["RfTechno", "RF Technologies"],
      "00146E" => ["HStoll", "H. Stoll GmbH & Co. KG"],
      "00146F" => ["Kohler", "Kohler Co"],
      "001470" => ["ProkomSo", "Prokom Software SA"],
      "001471" => ["EasternA", "Eastern Asia Technology Limited"],
      "001472" => ["ChinaBro", "China Broadband Wireless IP Standard Group"],
      "001473" => ["Bookham", "Bookham Inc"],
      "001474" => ["K40Elect", "K40 Electronics"],
      "001475" => ["WilineNe", "Wiline Networks, Inc."],
      "001476" => ["Multicom", "MultiCom Industries Limited"],
      "001477" => ["Nertec", "Nertec  Inc."],
      "001478" => ["Shenzhen", "ShenZhen TP-LINK Technologies Co., Ltd."],
      "001479" => ["NecMagnu", "NEC Magnus Communications,Ltd."],
      "00147A" => ["Eubus", "Eubus GmbH"],
      "00147B" => ["Iteris", "Iteris, Inc."],
      "00147C" => ["3com", "3Com Ltd"],
      "00147D" => ["AeonDigi", "Aeon Digital International"],
      "00147E" => ["Innerwir", "InnerWireless"],
      "00147F" => ["ThomsonT", "Thomson Telecom Belgium"],
      "001480" => ["Hitachi-", "Hitachi-LG Data Storage Korea, Inc"],
      "001481" => ["Multilin", "Multilink Inc"],
      "001482" => ["Gobacktv", "GoBackTV, Inc"],
      "001483" => ["Exs", "eXS Inc."],
      "001484" => ["CermateT", "Cermate Technologies Inc."],
      "001485" => ["Giga-Byt", "Giga-Byte"],
      "001486" => ["EchoDigi", "Echo Digital Audio Corporation"],
      "001487" => ["American", "American Technology Integrators"],
      "001488" => ["Akorri",""],
      "001489" => ["B1540210", "B15402100 - JANDEI, S.L."],
      "00148A" => ["ElinEbgT", "Elin Ebg Traction Gmbh"],
      "00148B" => ["GloboEle", "Globo Electronic GmbH & Co. KG"],
      "00148C" => ["Fortress", "Fortress Technologies"],
      "00148D" => ["CubicDef", "Cubic Defense Simulation Systems"],
      "00148E" => ["TelePowe", "Tele Power Inc."],
      "00148F" => ["Protroni", "Protronic (Far East) Ltd."],
      "001490" => ["Asp", "ASP Corporation"],
      "001491" => ["DanielsE", "Daniels Electronics Ltd."],
      "001492" => ["LiteonMo", "Liteon, Mobile Media Solution SBU"],
      "001493" => ["Systimax", "Systimax Solutions"],
      "001494" => ["Esu", "ESU AG"],
      "001495" => ["2wire", "2Wire, Inc."],
      "001496" => ["Phonic", "Phonic Corp."],
      "001497" => ["ZhiyuanE", "ZHIYUAN Eletronics co.,ltd."],
      "001498" => ["VikingDe", "Viking Design Technology"],
      "001499" => ["Helicomm", "Helicomm Inc"],
      "00149A" => ["Motorola", "Motorola Mobility, Inc."],
      "00149B" => ["NokotaCo", "Nokota Communications, LLC"],
      "00149C" => ["Hf", "HF Company"],
      "00149D" => ["SoundId", "Sound ID Inc."],
      "00149E" => ["Ubone", "UbONE Co., Ltd"],
      "00149F" => ["SystemAn", "System and Chips, Inc."],
      "0014A0" => ["Accsense", "Accsense, Inc."],
      "0014A1" => ["Synchron", "Synchronous Communication Corp"],
      "0014A2" => ["CoreMicr", "Core Micro Systems Inc."],
      "0014A3" => ["VitelecB", "Vitelec BV"],
      "0014A4" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "0014A5" => ["GemtekTe", "Gemtek Technology Co., Ltd."],
      "0014A6" => ["Teraneti", "Teranetics, Inc."],
      "0014A7" => ["NokiaDan", "Nokia Danmark A/S"],
      "0014A8" => ["Cisco", "Cisco Systems"],
      "0014A9" => ["Cisco", "Cisco Systems"],
      "0014AA" => ["AshlyAud", "Ashly Audio, Inc."],
      "0014AB" => ["SenhaiEl", "Senhai Electronic Technology Co., Ltd."],
      "0014AC" => ["Bountifu", "Bountiful WiFi"],
      "0014AD" => ["GassnerW", "Gassner Wiege- u. MeAYtechnik GmbH"],
      "0014AE" => ["Wizlogic", "Wizlogics Co., Ltd."],
      "0014AF" => ["Datasym", "Datasym Inc."],
      "0014B0" => ["NaeilCom", "Naeil Community"],
      "0014B1" => ["Avitec", "Avitec AB"],
      "0014B2" => ["Mcubelog", "mCubelogics Corporation"],
      "0014B3" => ["Corestar", "CoreStar International Corp"],
      "0014B4" => ["GeneralD", "General Dynamics United Kingdom Ltd"],
      "0014B5" => ["Physiome", "PHYSIOMETRIX,INC"],
      "0014B6" => ["EnswerTe", "Enswer Technology Inc."],
      "0014B7" => ["ArInfote", "AR Infotek Inc."],
      "0014B8" => ["Hill-Rom",""],
      "0014B9" => ["MstarSem", "MSTAR SEMICONDUCTOR"],
      "0014BA" => ["CarversS", "Carvers SA de CV"],
      "0014BB" => ["OpenInte", "Open Interface North America"],
      "0014BC" => ["Synectic", "SYNECTIC TELECOM EXPORTS PVT. LTD."],
      "0014BD" => ["Incnetwo", "incNETWORKS, Inc"],
      "0014BE" => ["WinkComm", "Wink communication technology CO.LTD"],
      "0014BF" => ["Cisco-Li", "Cisco-Linksys LLC"],
      "0014C0" => ["Symstrea", "Symstream Technology Group Ltd"],
      "0014C1" => ["USRoboti", "U.S. Robotics Corporation"],
      "0014C2" => ["Hewlett-", "Hewlett-Packard Company"],
      "0014C3" => ["SeagateT", "Seagate Technology LLC"],
      "0014C4" => ["Vitelcom", "Vitelcom Mobile Technology"],
      "0014C5" => ["AliveTec", "Alive Technologies Pty Ltd"],
      "0014C6" => ["Quixant", "Quixant Ltd"],
      "0014C7" => ["Nortel",""],
      "0014C8" => ["Contempo", "Contemporary Research Corp"],
      "0014C9" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "0014CA" => ["KeyRadio", "Key Radio Systems Limited"],
      "0014CB" => ["Lifesync", "LifeSync Corporation"],
      "0014CC" => ["Zetec", "Zetec, Inc."],
      "0014CD" => ["Digitalz", "DigitalZone Co., Ltd."],
      "0014CE" => ["Nf", "NF CORPORATION"],
      "0014CF" => ["InvisioC", "INVISIO Communications"],
      "0014D0" => ["Bti", "BTI Systems Inc."],
      "0014D1" => ["Trendnet",""],
      "0014D2" => ["KyudenTe", "Kyuden Technosystems Corporation"],
      "0014D3" => ["Sepsa",""],
      "0014D4" => ["KTechnol", "K Technology Corporation"],
      "0014D5" => ["DatangTe", "Datang Telecom Technology CO. , LCD,Optical Communication Br"],
      "0014D6" => ["Jeongmin", "Jeongmin Electronics Co.,Ltd."],
      "0014D7" => ["Datastor", "Datastore Technology Corp"],
      "0014D8" => ["Bio-Logi", "bio-logic SA"],
      "0014D9" => ["IpFabric", "IP Fabrics, Inc."],
      "0014DA" => ["Huntleig", "Huntleigh Healthcare"],
      "0014DB" => ["ElmaTren", "Elma Trenew Electronic GmbH"],
      "0014DC" => ["Communic", "Communication System Design & Manufacturing (CSDM)"],
      "0014DD" => ["Covergen", "Covergence Inc."],
      "0014DE" => ["SageInst", "Sage Instruments Inc."],
      "0014DF" => ["Hi-PTech", "HI-P Tech Corporation"],
      "0014E0" => ["LetS", "LET\'S Corporation"],
      "0014E1" => ["DataDisp", "Data Display AG"],
      "0014E2" => ["Datacom", "datacom systems inc."],
      "0014E3" => ["Mm-Lab", "mm-lab GmbH"],
      "0014E4" => ["Integral", "Integral Technologies"],
      "0014E5" => ["Alticast",""],
      "0014E6" => ["AimInfra", "AIM Infrarotmodule GmbH"],
      "0014E7" => ["Stolinx", "Stolinx,. Inc"],
      "0014E8" => ["Motorola", "Motorola Mobility, Inc."],
      "0014E9" => ["NortechI", "Nortech International"],
      "0014EA" => ["SDigmSaf", "S Digm Inc. (Safe Paradigm Inc.)"],
      "0014EB" => ["Awarepoi", "AwarePoint Corporation"],
      "0014EC" => ["AcroTele", "Acro Telecom"],
      "0014ED" => ["Airak", "Airak, Inc."],
      "0014EE" => ["WesternD", "Western Digital Technologies, Inc."],
      "0014EF" => ["TzeroTec", "TZero Technologies, Inc."],
      "0014F0" => ["Business", "Business Security OL AB"],
      "0014F1" => ["Cisco", "Cisco Systems"],
      "0014F2" => ["Cisco", "Cisco Systems"],
      "0014F3" => ["Vixs", "ViXS Systems Inc"],
      "0014F4" => ["DektecDi", "DekTec Digital Video B.V."],
      "0014F5" => ["OsiSecur", "OSI Security Devices"],
      "0014F6" => ["JuniperN", "Juniper Networks, Inc."],
      "0014F7" => ["Crevis",""],
      "0014F8" => ["Scientif", "Scientific Atlanta"],
      "0014F9" => ["VantageC", "Vantage Controls"],
      "0014FA" => ["AsgaSA", "AsGa S.A."],
      "0014FB" => ["Technica", "Technical Solutions Inc."],
      "0014FC" => ["Extandon", "Extandon, Inc."],
      "0014FD" => ["ThecusTe", "Thecus Technology Corp."],
      "0014FE" => ["ArtechEl", "Artech Electronics"],
      "0014FF" => ["PreciseA", "Precise Automation, Inc."],
      "001500" => ["IntelCor", "Intel Corporate"],
      "001501" => ["Lexbox",""],
      "001502" => ["BetaTech", "BETA tech"],
      "001503" => ["Proficom", "PROFIcomms s.r.o."],
      "001504" => ["GamePlus", "GAME PLUS CO., LTD."],
      "001505" => ["Actionte", "Actiontec Electronics, Inc"],
      "001506" => ["NeoPhoto", "Neo Photonics"],
      "001507" => ["Renaissa", "Renaissance Learning Inc"],
      "001508" => ["GlobalTa", "Global Target Enterprise Inc"],
      "001509" => ["PlusTech", "Plus Technology Co., Ltd"],
      "00150A" => ["Sonoa", "Sonoa Systems, Inc"],
      "00150B" => ["SageInfo", "SAGE INFOTECH LTD."],
      "00150C" => ["Avm", "AVM GmbH"],
      "00150D" => ["HoanaMed", "Hoana Medical, Inc."],
      "00150E" => ["Openbrai", "OPENBRAIN TECHNOLOGIES CO., LTD."],
      "00150F" => ["Mingjong",""],
      "001510" => ["Techsphe", "Techsphere Co., Ltd"],
      "001511" => ["DataCent", "Data Center Systems"],
      "001512" => ["ZurichUn", "Zurich University of Applied Sciences"],
      "001513" => ["EfsSas", "EFS sas"],
      "001514" => ["HuZhouNa", "Hu Zhou NAVA Networks&Electronics Ltd."],
      "001515" => ["Leipold+", "Leipold+Co.GmbH"],
      "001516" => ["Uriel", "URIEL SYSTEMS INC."],
      "001517" => ["IntelCor", "Intel Corporate"],
      "001518" => ["Shenzhen", "Shenzhen 10MOONS Technology Development CO.,Ltd"],
      "001519" => ["Storeage", "StoreAge Networking Technologies"],
      "00151A" => ["HunterEn", "Hunter Engineering Company"],
      "00151B" => ["Isilon", "Isilon Systems Inc."],
      "00151C" => ["Leneco",""],
      "00151D" => ["M2i", "M2I CORPORATION"],
      "00151E" => ["Ethernet", "Ethernet Powerlink Standardization Group (EPSG)"],
      "00151F" => ["Multivis", "Multivision Intelligent Surveillance (Hong Kong) Ltd"],
      "001520" => ["Radiocra", "Radiocrafts AS"],
      "001521" => ["Horoquar", "Horoquartz"],
      "001522" => ["DeaSecur", "Dea Security"],
      "001523" => ["MeteorCo", "Meteor Communications Corporation"],
      "001524" => ["Numatics", "Numatics, Inc."],
      "001525" => ["Chamberl", "Chamberlain Access Solutions"],
      "001526" => ["RemoteTe", "Remote Technologies Inc"],
      "001527" => ["BalboaIn", "Balboa Instruments"],
      "001528" => ["BeaconMe", "Beacon Medical Products LLC d.b.a. BeaconMedaes"],
      "001529" => ["N3", "N3 Corporation"],
      "00152A" => ["Nokia", "Nokia GmbH"],
      "00152B" => ["Cisco", "Cisco Systems"],
      "00152C" => ["Cisco", "Cisco Systems"],
      "00152D" => ["TenxNetw", "TenX Networks, LLC"],
      "00152E" => ["Packetho", "PacketHop, Inc."],
      "00152F" => ["Motorola", "Motorola Mobility, Inc."],
      "001530" => ["Bus-Tech", "Bus-Tech, Inc."],
      "001531" => ["Kocom",""],
      "001532" => ["Consumer", "Consumer Technologies Group, LLC"],
      "001533" => ["Nadam", "NADAM.CO.,LTD"],
      "001534" => ["ABeltrA ", "A BELTRA NICA, Companhia de ComunicaA Aues, Lda"],
      "001535" => ["Ote", "OTE Spa"],
      "001536" => ["Powertec", "Powertech co.,Ltd"],
      "001537" => ["VentusNe", "Ventus Networks"],
      "001538" => ["Rfid", "RFID, Inc."],
      "001539" => ["Technodr", "Technodrive SRL"],
      "00153A" => ["Shenzhen", "Shenzhen Syscan Technology Co.,Ltd."],
      "00153B" => ["EmhMeter", "EMH metering GmbH & Co. KG"],
      "00153C" => ["Kprotech", "Kprotech Co., Ltd."],
      "00153D" => ["ElimProd", "ELIM PRODUCT CO."],
      "00153E" => ["Q-MaticS", "Q-Matic Sweden AB"],
      "00153F" => ["AlcatelA", "Alcatel Alenia Space Italia"],
      "001540" => ["Nortel",""],
      "001541" => ["Stratali", "StrataLight Communications, Inc."],
      "001542" => ["Microhar", "MICROHARD S.R.L."],
      "001543" => ["Aberdeen", "Aberdeen Test Center"],
      "001544" => ["ComSAT", "coM.s.a.t. AG"],
      "001545" => ["Seecode", "SEECODE Co., Ltd."],
      "001546" => ["ItgWorld", "ITG Worldwide Sdn Bhd"],
      "001547" => ["AizenSol", "AiZen Solutions Inc."],
      "001548" => ["CubeTech", "CUBE TECHNOLOGIES"],
      "001549" => ["DixtalBi", "Dixtal Biomedica Ind. Com. Ltda"],
      "00154A" => ["WanshihE", "WANSHIH ELECTRONIC CO., LTD"],
      "00154B" => ["WondePro", "Wonde Proud Technology Co., Ltd"],
      "00154C" => ["Saunders", "Saunders Electronics"],
      "00154D" => ["Netronom", "Netronome Systems, Inc."],
      "00154E" => ["Iec",""],
      "00154F" => ["OneRfTec", "one RF Technology"],
      "001550" => ["NitsTech", "Nits Technology Inc"],
      "001551" => ["Radiopul", "RadioPulse Inc."],
      "001552" => ["Wi-Gear", "Wi-Gear Inc."],
      "001553" => ["Cytyc", "Cytyc Corporation"],
      "001554" => ["AtalumWi", "Atalum Wireless S.A."],
      "001555" => ["Dfm", "DFM GmbH"],
      "001556" => ["SagemCom", "SAGEM COMMUNICATION"],
      "001557" => ["Olivetti",""],
      "001558" => ["Foxconn",""],
      "001559" => ["Securapl", "Securaplane Technologies, Inc."],
      "00155A" => ["Dainippo", "DAINIPPON PHARMACEUTICAL CO., LTD."],
      "00155B" => ["Sampo", "Sampo Corporation"],
      "00155C" => ["DresserW", "Dresser Wayne"],
      "00155D" => ["Microsof", "Microsoft Corporation"],
      "00155E" => ["MorganSt", "Morgan Stanley"],
      "00155F" => ["Greenpea", "GreenPeak Technologies"],
      "001560" => ["Hewlett-", "Hewlett-Packard Company"],
      "001561" => ["Jjplus", "JJPlus Corporation"],
      "001562" => ["Cisco", "Cisco Systems"],
      "001563" => ["Cisco", "Cisco Systems"],
      "001564" => ["Behringe", "BEHRINGER Spezielle Studiotechnik GmbH"],
      "001565" => ["XiamenYe", "XIAMEN YEALINK NETWORK TECHNOLOGY CO.,LTD"],
      "001566" => ["A-FirstT", "A-First Technology Co., Ltd."],
      "001567" => ["Radwin", "RADWIN Inc."],
      "001568" => ["Dilithiu", "Dilithium Networks"],
      "001569" => ["PecoIi", "PECO II, Inc."],
      "00156A" => ["Dg2lTech", "DG2L Technologies Pvt. Ltd."],
      "00156B" => ["Perfisan", "Perfisans Networks Corp."],
      "00156C" => ["SaneSyst", "SANE SYSTEM CO., LTD"],
      "00156D" => ["Ubiquiti", "Ubiquiti Networks Inc."],
      "00156E" => ["AWCommun", "A. W. Communication Systems Ltd"],
      "00156F" => ["XiranetC", "Xiranet Communications GmbH"],
      "001570" => ["SymbolTe", "Symbol TechnologiesWholly owned Subsidiary of Motorola"],
      "001571" => ["Nolan", "Nolan Systems"],
      "001572" => ["Red-Lemo", "Red-Lemon"],
      "001573" => ["NewsoftT", "NewSoft  Technology Corporation"],
      "001574" => ["HorizonS", "Horizon Semiconductors Ltd."],
      "001575" => ["NevisNet", "Nevis Networks Inc."],
      "001576" => ["ScilAnim", "scil animal care company GmbH"],
      "001577" => ["AlliedTe", "Allied Telesis"],
      "001578" => ["Audio/Vi", "Audio / Video Innovations"],
      "001579" => ["Lunatone", "Lunatone Industrielle Elektronik GmbH"],
      "00157A" => ["TelefinS", "Telefin S.p.A."],
      "00157B" => ["LeuzeEle", "Leuze electronic GmbH + Co. KG"],
      "00157C" => ["DaveNetw", "Dave Networks, Inc."],
      "00157D" => ["Posdata", "POSDATA CO., LTD."],
      "00157E" => ["Weidm Ll", "Weidm ller Interface GmbH & Co. KG"],
      "00157F" => ["ChuangIn", "ChuanG International Holding CO.,LTD."],
      "001580" => ["U-Way", "U-WAY CORPORATION"],
      "001581" => ["Makus", "MAKUS Inc."],
      "001582" => ["Tvonics", "TVonics Ltd"],
      "001583" => ["Ivt", "IVT corporation"],
      "001584" => ["SchenckP", "Schenck Process GmbH"],
      "001585" => ["Aonvisio", "Aonvision Technolopy Corp."],
      "001586" => ["XiamenOv", "Xiamen Overseas Chinese Electronic Co., Ltd."],
      "001587" => ["Takenaka", "Takenaka Seisakusho Co.,Ltd"],
      "001588" => ["BaldaSol", "Balda Solution Malaysia Sdn Bhd"],
      "001589" => ["D-MaxTec", "D-MAX Technology Co.,Ltd"],
      "00158A" => ["SurecomT", "SURECOM Technology Corp."],
      "00158B" => ["ParkAir", "Park Air Systems Ltd"],
      "00158C" => ["LiabAps", "Liab ApS"],
      "00158D" => ["Jennic", "Jennic Ltd"],
      "00158E" => ["Plustek", "Plustek.INC"],
      "00158F" => ["NttAdvan", "NTT Advanced Technology Corporation"],
      "001590" => ["Hectroni", "Hectronic GmbH"],
      "001591" => ["Rlw", "RLW Inc."],
      "001592" => ["FacomUkM", "Facom UK Ltd (Melksham)"],
      "001593" => ["U4eaTech", "U4EA Technologies Inc."],
      "001594" => ["Bixolon", "BIXOLON CO.,LTD"],
      "001595" => ["QuesterT", "Quester Tangent Corporation"],
      "001596" => ["ArrisInt", "ARRIS International"],
      "001597" => ["AetaAudi", "AETA AUDIO SYSTEMS"],
      "001598" => ["Kolektor", "Kolektor group"],
      "001599" => ["SamsungE", "Samsung Electronics Co., LTD"],
      "00159A" => ["Motorola", "Motorola Mobility, Inc."],
      "00159B" => ["Nortel",""],
      "00159C" => ["B-KyungS", "B-KYUNG SYSTEM Co.,Ltd."],
      "00159D" => ["MinicomA", "Minicom Advanced Systems ltd"],
      "00159E" => ["MadCatzI", "Mad Catz Interactive Inc"],
      "00159F" => ["Terascal", "Terascala, Inc."],
      "0015A0" => ["NokiaDan", "Nokia Danmark A/S"],
      "0015A1" => ["Eca-Sint", "ECA-SINTERS"],
      "0015A2" => ["ArrisInt", "ARRIS International"],
      "0015A3" => ["ArrisInt", "ARRIS International"],
      "0015A4" => ["ArrisInt", "ARRIS International"],
      "0015A5" => ["Dci", "DCI Co., Ltd."],
      "0015A6" => ["DigitalE", "Digital Electronics Products Ltd."],
      "0015A7" => ["Robatech", "Robatech AG"],
      "0015A8" => ["Motorola", "Motorola Mobility, Inc."],
      "0015A9" => ["KwangWoo", "KWANG WOO I&C CO.,LTD"],
      "0015AA" => ["Rextechn", "Rextechnik International Co.,"],
      "0015AB" => ["ProSound", "PRO CO SOUND INC"],
      "0015AC" => ["Capelon", "Capelon AB"],
      "0015AD" => ["Accedian", "Accedian Networks"],
      "0015AE" => ["KyungIl", "kyung il"],
      "0015AF" => ["Azurewav", "AzureWave Technologies, Inc."],
      "0015B0" => ["Autotele", "AUTOTELENET CO.,LTD"],
      "0015B1" => ["Ambient", "Ambient Corporation"],
      "0015B2" => ["Advanced", "Advanced Industrial Computer, Inc."],
      "0015B3" => ["Caretech", "Caretech AB"],
      "0015B4" => ["PolymapW", "Polymap  Wireless LLC"],
      "0015B5" => ["CiNetwor", "CI Network Corp."],
      "0015B6" => ["Shinmayw", "ShinMaywa Industries, Ltd."],
      "0015B7" => ["Toshiba",""],
      "0015B8" => ["Tahoe",""],
      "0015B9" => ["SamsungE", "Samsung Electronics Co., Ltd."],
      "0015BA" => ["Iba", "iba AG"],
      "0015BB" => ["SmaSolar", "SMA Solar Technology AG"],
      "0015BC" => ["Develco",""],
      "0015BD" => ["Group4Te", "Group 4 Technology Ltd"],
      "0015BE" => ["Iqua", "Iqua Ltd."],
      "0015BF" => ["Technico", "technicob"],
      "0015C0" => ["DigitalT", "DIGITAL TELEMEDIA CO.,LTD."],
      "0015C1" => ["SonyComp", "SONY Computer Entertainment inc,"],
      "0015C2" => ["3mGerman", "3M Germany"],
      "0015C3" => ["RufTelem", "Ruf Telematik AG"],
      "0015C4" => ["Flovel", "FLOVEL CO., LTD."],
      "0015C5" => ["Dell", "Dell Inc"],
      "0015C6" => ["Cisco", "Cisco Systems"],
      "0015C7" => ["Cisco", "Cisco Systems"],
      "0015C8" => ["Flexipan", "FlexiPanel Ltd"],
      "0015C9" => ["Gumstix", "Gumstix, Inc"],
      "0015CA" => ["Terareco", "TeraRecon, Inc."],
      "0015CB" => ["SurfComm", "Surf Communication Solutions Ltd."],
      "0015CC" => ["TepcoUqu", "TEPCO UQUEST, LTD."],
      "0015CD" => ["Exartech", "Exartech International Corp."],
      "0015CE" => ["ArrisInt", "ARRIS International"],
      "0015CF" => ["ArrisInt", "ARRIS International"],
      "0015D0" => ["ArrisInt", "ARRIS International"],
      "0015D1" => ["ArrisGro", "ARRIS Group, Inc."],
      "0015D2" => ["Xantech", "Xantech Corporation"],
      "0015D3" => ["Pantech&", "Pantech&Curitel Communications, Inc."],
      "0015D4" => ["Emitor", "Emitor AB"],
      "0015D5" => ["Nicevt",""],
      "0015D6" => ["OslinkSp", "OSLiNK Sp. z o.o."],
      "0015D7" => ["Reti", "Reti Corporation"],
      "0015D8" => ["Interlin", "Interlink Electronics"],
      "0015D9" => ["PkcElect", "PKC Electronics Oy"],
      "0015DA" => ["IritelAD", "IRITEL A.D."],
      "0015DB" => ["Canesta", "Canesta Inc."],
      "0015DC" => ["Kt&C", "KT&C Co., Ltd."],
      "0015DD" => ["IpContro", "IP Control Systems Ltd."],
      "0015DE" => ["NokiaDan", "Nokia Danmark A/S"],
      "0015DF" => ["ClivetSP", "Clivet S.p.A."],
      "0015E0" => ["St-Erics", "ST-Ericsson"],
      "0015E1" => ["Picochip", "Picochip Ltd"],
      "0015E2" => ["DrIngHer", "Dr.Ing. Herbert Knauer GmbH"],
      "0015E3" => ["DreamTec", "Dream Technologies Corporation"],
      "0015E4" => ["ZimmerEl", "Zimmer Elektromedizin"],
      "0015E5" => ["Cheertek", "Cheertek Inc."],
      "0015E6" => ["MobileTe", "MOBILE TECHNIKA Inc."],
      "0015E7" => ["QuantecP", "Quantec ProAudio"],
      "0015E8" => ["Nortel",""],
      "0015E9" => ["D-Link", "D-Link Corporation"],
      "0015EA" => ["Tellumat", "Tellumat (Pty) Ltd"],
      "0015EB" => ["Zte", "ZTE CORPORATION"],
      "0015EC" => ["BocaDevi", "Boca Devices LLC"],
      "0015ED" => ["FulcrumM", "Fulcrum Microsystems, Inc."],
      "0015EE" => ["OmnexCon", "Omnex Control Systems"],
      "0015EF" => ["NecTokin", "NEC TOKIN Corporation"],
      "0015F0" => ["EgoBv", "EGO BV"],
      "0015F1" => ["KylinkCo", "KYLINK Communications Corp."],
      "0015F2" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "0015F3" => ["Peltor", "PELTOR AB"],
      "0015F4" => ["Eventide",""],
      "0015F5" => ["Sustaina", "Sustainable Energy Systems"],
      "0015F6" => ["ScienceA", "SCIENCE AND ENGINEERING SERVICES, INC."],
      "0015F7" => ["Wintecro", "Wintecronics Ltd."],
      "0015F8" => ["Kingtron", "Kingtronics Industrial Co. Ltd."],
      "0015F9" => ["Cisco", "Cisco Systems"],
      "0015FA" => ["Cisco", "Cisco Systems"],
      "0015FB" => ["SetexSch", "setex schermuly textile computer gmbh"],
      "0015FC" => ["Littelfu", "Littelfuse Startco"],
      "0015FD" => ["Complete", "Complete Media Systems"],
      "0015FE" => ["Schillin", "SCHILLING ROBOTICS LLC"],
      "0015FF" => ["NovatelW", "Novatel Wireless, Inc."],
      "001600" => ["Cellebri", "CelleBrite Mobile Synchronization"],
      "001601" => ["Buffalo", "Buffalo Inc."],
      "001602" => ["CeyonTec", "CEYON TECHNOLOGY CO.,LTD."],
      "001603" => ["Coolksky", "COOLKSKY Co., LTD"],
      "001604" => ["Sigpro",""],
      "001605" => ["Yorkvill", "YORKVILLE SOUND INC."],
      "001606" => ["IdealInd", "Ideal Industries"],
      "001607" => ["CurvesIn", "Curves International Inc."],
      "001608" => ["SequansC", "Sequans Communications"],
      "001609" => ["UnitechE", "Unitech electronics co., ltd."],
      "00160A" => ["SweexEur", "SWEEX Europe BV"],
      "00160B" => ["TvworksL", "TVWorks LLC"],
      "00160C" => ["LplDevel", "LPL  DEVELOPMENT S.A. DE C.V"],
      "00160D" => ["BeHere", "Be Here Corporation"],
      "00160E" => ["OpticaTe", "Optica Technologies Inc."],
      "00160F" => ["BadgerMe", "BADGER METER INC"],
      "001610" => ["CarinaTe", "Carina Technology"],
      "001611" => ["AlteconS", "Altecon Srl"],
      "001612" => ["OtsukaEl", "Otsuka Electronics Co., Ltd."],
      "001613" => ["Librestr", "LibreStream Technologies Inc."],
      "001614" => ["Picoseco", "Picosecond Pulse Labs"],
      "001615" => ["Nittan", "Nittan Company, Limited"],
      "001616" => ["BrowanCo", "BROWAN COMMUNICATION INC."],
      "001617" => ["Msi",""],
      "001618" => ["Hivion", "HIVION Co., Ltd."],
      "001619" => ["LaFactor", "La Factoria de Comunicaciones Aplicadas,S.L."],
      "00161A" => ["Dametric", "Dametric AB"],
      "00161B" => ["Micronet", "Micronet Corporation"],
      "00161C" => ["E:Cue",""],
      "00161D" => ["Innovati", "Innovative Wireless Technologies, Inc."],
      "00161E" => ["Woojinne", "Woojinnet"],
      "00161F" => ["Sunwavet", "SUNWAVETEC Co., Ltd."],
      "001620" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "001621" => ["Colorado", "Colorado Vnet"],
      "001622" => ["Bbh", "BBH SYSTEMS GMBH"],
      "001623" => ["Interval", "Interval Media"],
      "001624" => ["Teneros", "Teneros, Inc."],
      "001625" => ["Impinj", "Impinj, Inc."],
      "001626" => ["Motorola", "Motorola Mobility, Inc."],
      "001627" => ["Embedded", "embedded-logic DESIGN AND MORE GmbH"],
      "001628" => ["UltraEle", "Ultra Electronics Manufacturing and Card Systems"],
      "001629" => ["Nivus", "Nivus GmbH"],
      "00162A" => ["AntikCom", "Antik computers & communications s.r.o."],
      "00162B" => ["TogamiEl", "Togami Electric Mfg.co.,Ltd."],
      "00162C" => ["Xanboo",""],
      "00162D" => ["Stnet", "STNet Co., Ltd."],
      "00162E" => ["SpaceShu", "Space Shuttle Hi-Tech Co., Ltd."],
      "00162F" => ["Geutebru", "Geutebruck GmbH"],
      "001630" => ["VativTec", "Vativ Technologies"],
      "001631" => ["Xteam",""],
      "001632" => ["SamsungE", "SAMSUNG ELECTRONICS CO., LTD."],
      "001633" => ["OxfordDi", "Oxford Diagnostics Ltd."],
      "001634" => ["Mathtech", "Mathtech, Inc."],
      "001635" => ["Hewlett-", "Hewlett-Packard Company"],
      "001636" => ["QuantaCo", "Quanta Computer Inc."],
      "001637" => ["CitelSrl", "Citel Srl"],
      "001638" => ["Tecom", "TECOM Co., Ltd."],
      "001639" => ["Ubiquam", "UBIQUAM Co.,Ltd"],
      "00163A" => ["YvesTech", "YVES TECHNOLOGY CO., LTD."],
      "00163B" => ["Vertexrs", "VertexRSI/General Dynamics"],
      "00163C" => ["ReboxBV", "Rebox B.V."],
      "00163D" => ["Tsinghua", "Tsinghua Tongfang Legend Silicon Tech. Co., Ltd."],
      "00163E" => ["Xensourc", "Xensource, Inc."],
      "00163F" => ["Crete", "CReTE SYSTEMS Inc."],
      "001640" => ["Asmobile", "Asmobile Communication Inc."],
      "001641" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "001642" => ["Pangolin",""],
      "001643" => ["Sunhillo", "Sunhillo Corporation"],
      "001644" => ["Lite-OnT", "LITE-ON Technology Corp."],
      "001645" => ["PowerDis", "Power Distribution, Inc."],
      "001646" => ["Cisco", "Cisco Systems"],
      "001647" => ["Cisco", "Cisco Systems"],
      "001648" => ["Ssd", "SSD Company Limited"],
      "001649" => ["Setone", "SetOne GmbH"],
      "00164A" => ["Vibratio", "Vibration Technology Limited"],
      "00164B" => ["QuorionD", "Quorion Data Systems GmbH"],
      "00164C" => ["PlanetIn", "PLANET INT Co., Ltd"],
      "00164D" => ["AlcatelN", "Alcatel North America IP Division"],
      "00164E" => ["NokiaDan", "Nokia Danmark A/S"],
      "00164F" => ["WorldEth", "World Ethnic Broadcastin Inc."],
      "001650" => ["HerleyGe", "Herley General Microwave Israel."],
      "001651" => ["Exeo", "Exeo Systems"],
      "001652" => ["HoatechT", "Hoatech Technologies, Inc."],
      "001653" => ["LegoSyst", "LEGO System A/S IE Electronics Division"],
      "001654" => ["Flex-PIn", "Flex-P Industries Sdn. Bhd."],
      "001655" => ["FuhoTech", "FUHO TECHNOLOGY Co., LTD"],
      "001656" => ["Nintendo", "Nintendo Co., Ltd."],
      "001657" => ["Aegate", "Aegate Ltd"],
      "001658" => ["Fusionte", "Fusiontech Technologies Inc."],
      "001659" => ["ZMPRadwa", "Z.M.P. RADWAG"],
      "00165A" => ["HarmanSp", "Harman Specialty Group"],
      "00165B" => ["GripAudi", "Grip Audio"],
      "00165C" => ["Trackflo", "Trackflow Ltd"],
      "00165D" => ["Airdefen", "AirDefense, Inc."],
      "00165E" => ["Precisio", "Precision I/O"],
      "00165F" => ["Fairmoun", "Fairmount Automation"],
      "001660" => ["Nortel",""],
      "001661" => ["Novatium", "Novatium Solutions (P) Ltd"],
      "001662" => ["LiyuhTec", "Liyuh Technology Ltd."],
      "001663" => ["KbtMobil", "KBT Mobile"],
      "001664" => ["Prod-El", "Prod-El SpA"],
      "001665" => ["CellonFr", "Cellon France"],
      "001666" => ["Quantier", "Quantier Communication Inc."],
      "001667" => ["A-TecSub", "A-TEC Subsystem INC."],
      "001668" => ["EishinEl", "Eishin Electronics"],
      "001669" => ["MrvCommu", "MRV Communication (Networks) LTD"],
      "00166A" => ["Tps",""],
      "00166B" => ["SamsungE", "Samsung Electronics"],
      "00166C" => ["SamsungE", "Samsung Electonics Digital Video System Division"],
      "00166D" => ["YulongCo", "Yulong Computer Telecommunication Scientific(shenzhen)Co.,Lt"],
      "00166E" => ["Arbitron", "Arbitron Inc."],
      "00166F" => ["Intel", "Intel Corporation"],
      "001670" => ["Sknet", "SKNET Corporation"],
      "001671" => ["SymphoxI", "Symphox Information Co."],
      "001672" => ["ZenwayEn", "Zenway enterprise ltd"],
      "001673" => ["Bury", "Bury GmbH & Co. KG"],
      "001674" => ["EurocbPh", "EuroCB (Phils.), Inc."],
      "001675" => ["Motorola", "Motorola Mobility, Inc."],
      "001676" => ["Intel", "Intel Corporation"],
      "001677" => ["Bihl+Wie", "Bihl+Wiedemann GmbH"],
      "001678" => ["Shenzhen", "SHENZHEN BAOAN GAOKE ELECTRONICS CO., LTD"],
      "001679" => ["EonCommu", "eOn Communications"],
      "00167A" => ["Skyworth", "Skyworth Overseas Dvelopment Ltd."],
      "00167B" => ["Haver&Bo", "Haver&Boecker"],
      "00167C" => ["IrexTech", "iRex Technologies BV"],
      "00167D" => ["Sky-Line", "Sky-Line Information Co., Ltd."],
      "00167E" => ["Diboss", "DIBOSS.CO.,LTD"],
      "00167F" => ["Bluebird", "Bluebird Soft Inc."],
      "001680" => ["BallyGam", "Bally Gaming + Systems"],
      "001681" => ["VectorIn", "Vector Informatik GmbH"],
      "001682" => ["ProDex", "Pro Dex, Inc"],
      "001683" => ["WebioInt", "WEBIO International Co.,.Ltd."],
      "001684" => ["Donjin", "Donjin Co.,Ltd."],
      "001685" => ["ElisaOyj", "Elisa Oyj"],
      "001686" => ["KarlStor", "Karl Storz Imaging"],
      "001687" => ["ChubbCsc", "Chubb CSC-Vendor AP"],
      "001688" => ["Serveren", "ServerEngines LLC"],
      "001689" => ["PilkorEl", "Pilkor Electronics Co., Ltd"],
      "00168A" => ["Id-Confi", "id-Confirm Inc"],
      "00168B" => ["Paralan", "Paralan Corporation"],
      "00168C" => ["DslPartn", "DSL Partner AS"],
      "00168D" => ["Korwin", "KORWIN CO., Ltd."],
      "00168E" => ["Vimicro", "Vimicro corporation"],
      "00168F" => ["GnNetcom", "GN Netcom as"],
      "001690" => ["J-TekInc", "J-TEK INCORPORATION"],
      "001691" => ["Moser-Ba", "Moser-Baer AG"],
      "001692" => ["Scientif", "Scientific-Atlanta, Inc."],
      "001693" => ["Powerlin", "PowerLink Technology Inc."],
      "001694" => ["Sennheis", "Sennheiser Communications A/S"],
      "001695" => ["AvcTechn", "AVC Technology Limited"],
      "001696" => ["QdiTechn", "QDI Technology (H.K.) Limited"],
      "001697" => ["Nec", "NEC Corporation"],
      "001698" => ["T&AMobil", "T&A Mobile Phones"],
      "001699" => ["TonicDvb", "Tonic DVB Marketing Ltd"],
      "00169A" => ["Quadrics", "Quadrics Ltd"],
      "00169B" => ["AlstomTr", "Alstom Transport"],
      "00169C" => ["Cisco", "Cisco Systems"],
      "00169D" => ["Cisco", "Cisco Systems"],
      "00169E" => ["TvOne", "TV One Ltd"],
      "00169F" => ["VimtronE", "Vimtron Electronics Co., Ltd."],
      "0016A0" => ["Auto-Mas", "Auto-Maskin"],
      "0016A1" => ["3leafNet", "3Leaf Networks"],
      "0016A2" => ["Centrali", "CentraLite Systems, Inc."],
      "0016A3" => ["Ingeteam", "Ingeteam Transmission&Distribution, S.A."],
      "0016A4" => ["Ezurio", "Ezurio Ltd"],
      "0016A5" => ["Tandberg", "Tandberg Storage ASA"],
      "0016A6" => ["DovadoFz", "Dovado FZ-LLC"],
      "0016A7" => ["AwetaG&P", "AWETA G&P"],
      "0016A8" => ["Cwt", "CWT CO., LTD."],
      "0016A9" => ["2ei",""],
      "0016AA" => ["KeiCommu", "Kei Communication Technology Inc."],
      "0016AB" => ["Pbi-Dans", "PBI-Dansensor A/S"],
      "0016AC" => ["TohoTech", "Toho Technology Corp."],
      "0016AD" => ["Bt-Links", "BT-Links Company Limited"],
      "0016AE" => ["Inventel",""],
      "0016AF" => ["Shenzhen", "Shenzhen Union Networks Equipment Co.,Ltd."],
      "0016B0" => ["Vk", "VK Corporation"],
      "0016B1" => ["Kbs",""],
      "0016B2" => ["Drivecam", "DriveCam Inc"],
      "0016B3" => ["Photonic", "Photonicbridges (China) Co., Ltd."],
      "0016B4" => ["Private",""],
      "0016B5" => ["Motorola", "Motorola Mobility, Inc."],
      "0016B6" => ["Cisco-Li", "Cisco-Linksys"],
      "0016B7" => ["SeoulCom", "Seoul Commtech"],
      "0016B8" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "0016B9" => ["Procurve", "ProCurve Networking"],
      "0016BA" => ["Weathern", "WEATHERNEWS INC."],
      "0016BB" => ["Law-Chai", "Law-Chain Computer Technology Co Ltd"],
      "0016BC" => ["NokiaDan", "Nokia Danmark A/S"],
      "0016BD" => ["AtiIndus", "ATI Industrial Automation"],
      "0016BE" => ["Infranet", "INFRANET, Inc."],
      "0016BF" => ["PalodexG", "PaloDEx Group Oy"],
      "0016C0" => ["Semtech", "Semtech Corporation"],
      "0016C1" => ["Eleksen", "Eleksen Ltd"],
      "0016C2" => ["Avtec", "Avtec Systems Inc"],
      "0016C3" => ["Ba", "BA Systems Inc"],
      "0016C4" => ["SirfTech", "SiRF Technology, Inc."],
      "0016C5" => ["Shenzhen", "Shenzhen Xing Feng Industry Co.,Ltd"],
      "0016C6" => ["NorthAtl", "North Atlantic Industries"],
      "0016C7" => ["Cisco", "Cisco Systems"],
      "0016C8" => ["Cisco", "Cisco Systems"],
      "0016C9" => ["NatSeatt", "NAT Seattle, Inc."],
      "0016CA" => ["Nortel",""],
      "0016CB" => ["AppleCom", "Apple Computer"],
      "0016CC" => ["XcuteMob", "Xcute Mobile Corp."],
      "0016CD" => ["HijiHigh", "HIJI HIGH-TECH CO., LTD."],
      "0016CE" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "0016CF" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "0016D0" => ["AtechEle", "ATech elektronika d.o.o."],
      "0016D1" => ["ZatAS", "ZAT a.s."],
      "0016D2" => ["Caspian",""],
      "0016D3" => ["Wistron", "Wistron Corporation"],
      "0016D4" => ["CompalCo", "Compal Communications, Inc."],
      "0016D5" => ["Synccom", "Synccom Co., Ltd"],
      "0016D6" => ["TdaTechP", "TDA Tech Pty Ltd"],
      "0016D7" => ["Sunways", "Sunways AG"],
      "0016D8" => ["Senea", "Senea AB"],
      "0016D9" => ["NingboBi", "NINGBO BIRD CO.,LTD."],
      "0016DA" => ["Futronic", "Futronic Technology Co. Ltd."],
      "0016DB" => ["SamsungE", "Samsung Electronics Co., Ltd."],
      "0016DC" => ["Archos",""],
      "0016DD" => ["Gigabeam", "Gigabeam Corporation"],
      "0016DE" => ["Fast", "FAST Inc"],
      "0016DF" => ["Lundinov", "Lundinova AB"],
      "0016E0" => ["3com", "3Com Ltd"],
      "0016E1" => ["Silicons", "SiliconStor, Inc."],
      "0016E2" => ["American", "American Fibertek, Inc."],
      "0016E3" => ["AskeyCom", "ASKEY COMPUTER CORP."],
      "0016E4" => ["Vanguard", "VANGUARD SECURITY ENGINEERING CORP."],
      "0016E5" => ["FordleyD", "FORDLEY DEVELOPMENT LIMITED"],
      "0016E6" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "0016E7" => ["DynamixP", "Dynamix Promotions Limited"],
      "0016E8" => ["SigmaDes", "Sigma Designs, Inc."],
      "0016E9" => ["TibaMedi", "Tiba Medical Inc"],
      "0016EA" => ["Intel", "Intel Corporation"],
      "0016EB" => ["Intel", "Intel Corporation"],
      "0016EC" => ["Elitegro", "Elitegroup Computer Systems Co., Ltd."],
      "0016ED" => ["DigitalS", "Digital Safety Technologies, Inc"],
      "0016EE" => ["Royaldig", "RoyalDigital Inc."],
      "0016EF" => ["KokoFitn", "Koko Fitness, Inc."],
      "0016F0" => ["Dell",""],
      "0016F1" => ["Omnisens", "OmniSense, LLC"],
      "0016F2" => ["DmobileS", "Dmobile System Co., Ltd."],
      "0016F3" => ["CastInfo", "CAST Information Co., Ltd"],
      "0016F4" => ["Eidicom", "Eidicom Co., Ltd."],
      "0016F5" => ["DalianGo", "Dalian Golden Hualu Digital Technology Co.,Ltd"],
      "0016F6" => ["VideoPro", "Video Products Group"],
      "0016F7" => ["L-3Commu", "L-3 Communications, Electrodynamics, Inc."],
      "0016F8" => ["Aviqtech", "AVIQTECH TECHNOLOGY CO., LTD."],
      "0016F9" => ["CetrtaPo", "CETRTA POT, d.o.o., Kranj"],
      "0016FA" => ["EciTelec", "ECI Telecom Ltd."],
      "0016FB" => ["Shenzhen", "SHENZHEN MTC CO.,LTD."],
      "0016FC" => ["Tohken", "TOHKEN CO.,LTD."],
      "0016FD" => ["JatyElec", "Jaty Electronics"],
      "0016FE" => ["AlpsElec", "Alps Electric Co., Ltd"],
      "0016FF" => ["WaminOpt", "Wamin Optocomm Mfg Corp"],
      "001700" => ["Motorola", "Motorola Mobility, Inc."],
      "001701" => ["Kde", "KDE, Inc."],
      "001702" => ["OsungMid", "Osung Midicom Co., Ltd"],
      "001703" => ["MosdanIn", "MOSDAN Internation Co.,Ltd"],
      "001704" => ["ShincoEl", "Shinco Electronics Group Co.,Ltd"],
      "001705" => ["MethodeE", "Methode Electronics"],
      "001706" => ["Techfait", "Techfaith Wireless Communication Technology Limited."],
      "001707" => ["Ingrid", "InGrid, Inc"],
      "001708" => ["Hewlett-", "Hewlett-Packard Company"],
      "001709" => ["ExaltCom", "Exalt Communications"],
      "00170A" => ["InewDigi", "INEW DIGITAL COMPANY"],
      "00170B" => ["Contela", "Contela, Inc."],
      "00170C" => ["TwigCom", "Twig Com Ltd."],
      "00170D" => ["DustNetw", "Dust Networks Inc."],
      "00170E" => ["Cisco", "Cisco Systems"],
      "00170F" => ["Cisco", "Cisco Systems"],
      "001710" => ["Casa", "Casa Systems Inc."],
      "001711" => ["GeHealth", "GE Healthcare Bio-Sciences AB"],
      "001712" => ["IscoInte", "ISCO International"],
      "001713" => ["TigerNet", "Tiger NetCom"],
      "001714" => ["BrContro", "BR Controls Nederland bv"],
      "001715" => ["Qstik",""],
      "001716" => ["QnoTechn", "Qno Technology Inc."],
      "001717" => ["LeicaGeo", "Leica Geosystems AG"],
      "001718" => ["VanscoEl", "Vansco Electronics Oy"],
      "001719" => ["Audiocod", "AudioCodes USA, Inc"],
      "00171A" => ["Winegard", "Winegard Company"],
      "00171B" => ["Innovati", "Innovation Lab Corp."],
      "00171C" => ["NtMicros", "NT MicroSystems, Inc."],
      "00171D" => ["Digit",""],
      "00171E" => ["TheoBenn", "Theo Benning GmbH & Co. KG"],
      "00171F" => ["Imv", "IMV Corporation"],
      "001720" => ["ImageSen", "Image Sensing Systems, Inc."],
      "001721" => ["FitreSPA", "FITRE S.p.A."],
      "001722" => ["Hanazede", "Hanazeder Electronic GmbH"],
      "001723" => ["SummitDa", "Summit Data Communications"],
      "001724" => ["StuderPr", "Studer Professional Audio GmbH"],
      "001725" => ["LiquidCo", "Liquid Computing"],
      "001726" => ["M2cElect", "m2c Electronic Technology Ltd."],
      "001727" => ["ThermoRa", "Thermo Ramsey Italia s.r.l."],
      "001728" => ["SelexCom", "Selex Communications"],
      "001729" => ["Ubicod", "Ubicod Co.LTD"],
      "00172A" => ["ProwareT", "Proware Technology Corp."],
      "00172B" => ["GlobalTe", "Global Technologies Inc."],
      "00172C" => ["TaejinIn", "TAEJIN INFOTECH"],
      "00172D" => ["AxcenPho", "Axcen Photonics Corporation"],
      "00172E" => ["Fxc", "FXC Inc."],
      "00172F" => ["Neulion", "NeuLion Incorporated"],
      "001730" => ["Automati", "Automation Electronics"],
      "001731" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "001732" => ["Science-", "Science-Technical Center RISSA"],
      "001733" => ["Sfr",""],
      "001734" => ["AdcTelec", "ADC Telecommunications"],
      "001735" => ["Private",""],
      "001736" => ["Iitron", "iiTron Inc."],
      "001737" => ["Industri", "Industrie Dial Face S.p.A."],
      "001738" => ["Internat", "International Business Machines"],
      "001739" => ["BrightHe", "Bright Headphone Electronics Company"],
      "00173A" => ["Reach", "Reach Systems Inc."],
      "00173B" => ["Cisco", "Cisco Systems, Inc."],
      "00173C" => ["ExtremeE", "Extreme Engineering Solutions"],
      "00173D" => ["Neology",""],
      "00173E" => ["Leucotro", "LeucotronEquipamentos Ltda."],
      "00173F" => ["Belkin", "Belkin Corporation"],
      "001740" => ["BluberiG", "Bluberi Gaming Technologies Inc"],
      "001741" => ["Defidev",""],
      "001742" => ["Fujitsu", "FUJITSU LIMITED"],
      "001743" => ["DeckSrl", "Deck Srl"],
      "001744" => ["Araneo", "Araneo Ltd."],
      "001745" => ["Innotz", "INNOTZ CO., Ltd"],
      "001746" => ["Freedom9", "Freedom9 Inc."],
      "001747" => ["Trimble",""],
      "001748" => ["Neokoros", "Neokoros Brasil Ltda"],
      "001749" => ["HyundaeY", "HYUNDAE YONG-O-SA CO.,LTD"],
      "00174A" => ["Socomec",""],
      "00174B" => ["NokiaDan", "Nokia Danmark A/S"],
      "00174C" => ["Millipor", "Millipore"],
      "00174D" => ["DynamicN", "DYNAMIC NETWORK FACTORY, INC."],
      "00174E" => ["Parama-T", "Parama-tech Co.,Ltd."],
      "00174F" => ["Icatch", "iCatch Inc."],
      "001750" => ["GsiGroup", "GSI Group, MicroE Systems"],
      "001751" => ["Online", "Online Corporation"],
      "001752" => ["Dags", "DAGS, Inc"],
      "001753" => ["NforeTec", "nFore Technology Inc."],
      "001754" => ["ArkinoHi", "Arkino HiTOP Corporation Limited"],
      "001755" => ["GeSecuri", "GE Security"],
      "001756" => ["VinciLab", "Vinci Labs Oy"],
      "001757" => ["RixTechn", "RIX TECHNOLOGY LIMITED"],
      "001758" => ["Thruvisi", "ThruVision Ltd"],
      "001759" => ["Cisco", "Cisco Systems"],
      "00175A" => ["Cisco", "Cisco Systems"],
      "00175B" => ["AcsSolut", "ACS Solutions Switzerland Ltd."],
      "00175C" => ["Sharp", "SHARP CORPORATION"],
      "00175D" => ["DongseoS", "Dongseo system."],
      "00175E" => ["Zed-3",""],
      "00175F" => ["Xenolink", "XENOLINK Communications Co., Ltd."],
      "001760" => ["NaitoDen", "Naito Densei Machida MFG.CO.,LTD"],
      "001761" => ["Zksoftwa", "ZKSoftware Inc."],
      "001762" => ["SolarTec", "Solar Technology, Inc."],
      "001763" => ["Essentia", "Essentia S.p.A."],
      "001764" => ["Atmedia", "ATMedia GmbH"],
      "001765" => ["Nortel",""],
      "001766" => ["AccenseT", "Accense Technology, Inc."],
      "001767" => ["Earforce", "Earforce AS"],
      "001768" => ["Zinwave", "Zinwave Ltd"],
      "001769" => ["Cymphoni", "Cymphonix Corp"],
      "00176A" => ["AvagoTec", "Avago Technologies"],
      "00176B" => ["Kiyon", "Kiyon, Inc."],
      "00176C" => ["Pivot3", "Pivot3, Inc."],
      "00176D" => ["Core", "CORE CORPORATION"],
      "00176E" => ["DucatiSi", "DUCATI SISTEMI"],
      "00176F" => ["PaxCompu", "PAX Computer Technology(Shenzhen) Ltd."],
      "001770" => ["ArtiIndu", "Arti Industrial Electronics Ltd."],
      "001771" => ["ApdCommu", "APD Communications Ltd"],
      "001772" => ["AstroStr", "ASTRO Strobel Kommunikationssysteme GmbH"],
      "001773" => ["Laketune", "Laketune Technologies Co. Ltd"],
      "001774" => ["Elesta", "Elesta GmbH"],
      "001775" => ["TteGerma", "TTE Germany GmbH"],
      "001776" => ["MesoScal", "Meso Scale Diagnostics, LLC"],
      "001777" => ["Obsidian", "Obsidian Research Corporation"],
      "001778" => ["CentralM", "Central Music Co."],
      "001779" => ["Quicktel",""],
      "00177A" => ["AssaAblo", "ASSA ABLOY AB"],
      "00177B" => ["AzaleaNe", "Azalea Networks inc"],
      "00177C" => ["Smartlin", "Smartlink Network Systems Limited"],
      "00177D" => ["IdtInter", "IDT International Limited"],
      "00177E" => ["MeshcomT", "Meshcom Technologies Inc."],
      "00177F" => ["Worldsma", "Worldsmart Retech"],
      "001780" => ["AppliedB", "Applied Biosystems B.V."],
      "001781" => ["Greyston", "Greystone Data System, Inc."],
      "001782" => ["Lobenn", "LoBenn Inc."],
      "001783" => ["TexasIns", "Texas Instruments"],
      "001784" => ["Motorola", "Motorola Mobility, Inc."],
      "001785" => ["SparrEle", "Sparr Electronics Ltd"],
      "001786" => ["Wisembed",""],
      "001787" => ["BrotherB", "Brother, Brother & Sons ApS"],
      "001788" => ["PhilipsL", "Philips Lighting BV"],
      "001789" => ["Zenitron", "Zenitron Corporation"],
      "00178A" => ["DartsTec", "DARTS TECHNOLOGIES CORP."],
      "00178B" => ["Teledyne", "Teledyne Technologies Incorporated"],
      "00178C" => ["Independ", "Independent Witness, Inc"],
      "00178D" => ["Checkpoi", "Checkpoint Systems, Inc."],
      "00178E" => ["GunneboC", "Gunnebo Cash Automation AB"],
      "00178F" => ["NingboYi", "NINGBO YIDONG ELECTRONIC CO.,LTD."],
      "001790" => ["HyundaiD", "HYUNDAI DIGITECH Co, Ltd."],
      "001791" => ["Lintech", "LinTech GmbH"],
      "001792" => ["FalcomWi", "Falcom Wireless Comunications Gmbh"],
      "001793" => ["Tigi", "Tigi Corporation"],
      "001794" => ["Cisco", "Cisco Systems"],
      "001795" => ["Cisco", "Cisco Systems"],
      "001796" => ["Rittmeye", "Rittmeyer AG"],
      "001797" => ["TelsyEle", "Telsy Elettronica S.p.A."],
      "001798" => ["AzonicTe", "Azonic Technology Co., LTD"],
      "001799" => ["Smartire", "SmarTire Systems Inc."],
      "00179A" => ["D-Link", "D-Link Corporation"],
      "00179B" => ["ChantSin", "Chant Sincere CO., LTD."],
      "00179C" => ["DepragSc", "DEPRAG SCHULZ GMBH u. CO."],
      "00179D" => ["Kelman", "Kelman Limited"],
      "00179E" => ["Sirit", "Sirit Inc"],
      "00179F" => ["Apricorn",""],
      "0017A0" => ["Robotech", "RoboTech srl"],
      "0017A1" => ["3soft", "3soft inc."],
      "0017A2" => ["Camrivox", "Camrivox Ltd."],
      "0017A3" => ["MixSRL", "MIX s.r.l."],
      "0017A4" => ["Hewlett-", "Hewlett-Packard Company"],
      "0017A5" => ["RalinkTe", "Ralink Technology Corp"],
      "0017A6" => ["YosinEle", "YOSIN ELECTRONICS CO., LTD."],
      "0017A7" => ["MobileCo", "Mobile Computing Promotion Consortium"],
      "0017A8" => ["Edm", "EDM Corporation"],
      "0017A9" => ["Sentivis", "Sentivision"],
      "0017AA" => ["Elab-Exp", "elab-experience inc."],
      "0017AB" => ["Nintendo", "Nintendo Co., Ltd."],
      "0017AC" => ["ONeilPro", "O\'Neil Product Development Inc."],
      "0017AD" => ["Acenet", "AceNet Corporation"],
      "0017AE" => ["Gai-Tron", "GAI-Tronics"],
      "0017AF" => ["Enermet",""],
      "0017B0" => ["NokiaDan", "Nokia Danmark A/S"],
      "0017B1" => ["AcistMed", "ACIST Medical Systems, Inc."],
      "0017B2" => ["SkTelesy", "SK Telesys"],
      "0017B3" => ["AftekInf", "Aftek Infosys Limited"],
      "0017B4" => ["RemoteSe", "Remote Security Systems, LLC"],
      "0017B5" => ["Peerless", "Peerless Systems Corporation"],
      "0017B6" => ["Aquantia",""],
      "0017B7" => ["TonzeTec", "Tonze Technology Co."],
      "0017B8" => ["Novatron", "NOVATRON CO., LTD."],
      "0017B9" => ["GambroLu", "Gambro Lundia AB"],
      "0017BA" => ["Sedo", "SEDO CO., LTD."],
      "0017BB" => ["SyrinxIn", "Syrinx Industrial Electronics"],
      "0017BC" => ["Touchtun", "Touchtunes Music Corporation"],
      "0017BD" => ["Tibetsys", "Tibetsystem"],
      "0017BE" => ["TratecTe", "Tratec Telecom B.V."],
      "0017BF" => ["Coherent", "Coherent Research Limited"],
      "0017C0" => ["Puretech", "PureTech Systems, Inc."],
      "0017C1" => ["CmPrecis", "CM Precision Technology LTD."],
      "0017C2" => ["AdbBroad", "ADB Broadband Italia"],
      "0017C3" => ["KtfTechn", "KTF Technologies Inc."],
      "0017C4" => ["QuantaMi", "Quanta Microsystems, INC."],
      "0017C5" => ["Sonicwal", "SonicWALL"],
      "0017C6" => ["CrossMat", "Cross Match Technologies Inc"],
      "0017C7" => ["MaraCons", "MARA Systems Consulting AB"],
      "0017C8" => ["KyoceraM", "Kyocera Mita Corporation"],
      "0017C9" => ["SamsungE", "Samsung Electronics Co., Ltd."],
      "0017CA" => ["Qisda", "Qisda Corporation"],
      "0017CB" => ["JuniperN", "Juniper Networks"],
      "0017CC" => ["Alcatel-", "Alcatel-Lucent"],
      "0017CD" => ["CecWirel", "CEC Wireless R&D Ltd."],
      "0017CE" => ["ScreenSe", "Screen Service Spa"],
      "0017CF" => ["Imca-Gmb", "iMCA-GmbH"],
      "0017D0" => ["OpticomC", "Opticom Communications, LLC"],
      "0017D1" => ["Nortel",""],
      "0017D2" => ["Thinlinx", "THINLINX PTY LTD"],
      "0017D3" => ["Etymotic", "Etymotic Research, Inc."],
      "0017D4" => ["MonsoonM", "Monsoon Multimedia, Inc"],
      "0017D5" => ["SamsungE", "Samsung Electronics Co., Ltd."],
      "0017D6" => ["Bluechip", "Bluechips Microhouse Co.,Ltd."],
      "0017D7" => ["IonGeoph", "ION Geophysical Corporation Inc."],
      "0017D8" => ["MagnumSe", "Magnum Semiconductor, Inc."],
      "0017D9" => ["Aai", "AAI Corporation"],
      "0017DA" => ["SpansLog", "Spans Logic"],
      "0017DB" => ["CankoTec", "CANKO TECHNOLOGIES INC."],
      "0017DC" => ["Daemyung", "DAEMYUNG ZERO1"],
      "0017DD" => ["ClipsalA", "Clipsal Australia"],
      "0017DE" => ["Advantag", "Advantage Six Ltd"],
      "0017DF" => ["Cisco", "Cisco Systems"],
      "0017E0" => ["Cisco", "Cisco Systems"],
      "0017E1" => ["DacosTec", "DACOS Technologies Co., Ltd."],
      "0017E2" => ["Motorola", "Motorola Mobility, Inc."],
      "0017E3" => ["TexasIns", "Texas Instruments"],
      "0017E4" => ["TexasIns", "Texas Instruments"],
      "0017E5" => ["TexasIns", "Texas Instruments"],
      "0017E6" => ["TexasIns", "Texas Instruments"],
      "0017E7" => ["TexasIns", "Texas Instruments"],
      "0017E8" => ["TexasIns", "Texas Instruments"],
      "0017E9" => ["TexasIns", "Texas Instruments"],
      "0017EA" => ["TexasIns", "Texas Instruments"],
      "0017EB" => ["TexasIns", "Texas Instruments"],
      "0017EC" => ["TexasIns", "Texas Instruments"],
      "0017ED" => ["Woojooit", "WooJooIT Ltd."],
      "0017EE" => ["Motorola", "Motorola Mobility, Inc."],
      "0017EF" => ["Ibm", "IBM Corp"],
      "0017F0" => ["SzcomBro", "SZCOM Broadband Network Technology Co.,Ltd"],
      "0017F1" => ["RenuElec", "Renu Electronics Pvt Ltd"],
      "0017F2" => ["AppleCom", "Apple Computer"],
      "0017F3" => ["HarrisCo", "Harris Corparation"],
      "0017F4" => ["ZeronAll", "ZERON ALLIANCE"],
      "0017F5" => ["LigNeopt", "LIG NEOPTEK"],
      "0017F6" => ["PyramidM", "Pyramid Meriden Inc."],
      "0017F7" => ["CemSolut", "CEM Solutions Pvt Ltd"],
      "0017F8" => ["MotechIn", "Motech Industries Inc."],
      "0017F9" => ["ForcomSp", "Forcom Sp. z o.o."],
      "0017FA" => ["Microsof", "Microsoft Corporation"],
      "0017FB" => ["Fa",""],
      "0017FC" => ["Suprema", "Suprema Inc."],
      "0017FD" => ["AmuletHo", "Amulet Hotkey"],
      "0017FE" => ["TalosSys", "TALOS SYSTEM INC."],
      "0017FF" => ["Playline", "PLAYLINE Co.,Ltd."],
      "001800" => ["Unigrand", "UNIGRAND LTD"],
      "001801" => ["Actionte", "Actiontec Electronics, Inc"],
      "001802" => ["AlphaNet", "Alpha Networks Inc."],
      "001803" => ["ArcsoftS", "ArcSoft Shanghai Co. LTD"],
      "001804" => ["E-TekDig", "E-TEK DIGITAL TECHNOLOGY LIMITED"],
      "001805" => ["BeijingI", "Beijing InHand Networking Technology Co.,Ltd."],
      "001806" => ["HokkeiIn", "Hokkei Industries Co., Ltd."],
      "001807" => ["Fanstel", "Fanstel Corp."],
      "001808" => ["Sightlog", "SightLogix, Inc."],
      "001809" => ["Cresyn",""],
      "00180A" => ["Meraki", "Meraki, Inc."],
      "00180B" => ["Brillian", "Brilliant Telecommunications"],
      "00180C" => ["Optelian", "Optelian Access Networks"],
      "00180D" => ["Terabyte", "Terabytes Server Storage Tech Corp"],
      "00180E" => ["Avega", "Avega Systems"],
      "00180F" => ["NokiaDan", "Nokia Danmark A/S"],
      "001810" => ["IptradeS", "IPTrade S.A."],
      "001811" => ["NeurosTe", "Neuros Technology International, LLC."],
      "001812" => ["BeijingX", "Beijing Xinwei Telecom Technology Co., Ltd."],
      "001813" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "001814" => ["Mitutoyo", "Mitutoyo Corporation"],
      "001815" => ["GzTechno", "GZ Technologies, Inc."],
      "001816" => ["Ubixon", "Ubixon Co., Ltd."],
      "001817" => ["DEShawRe", "D. E. Shaw Research, LLC"],
      "001818" => ["Cisco", "Cisco Systems"],
      "001819" => ["Cisco", "Cisco Systems"],
      "00181A" => ["Avermedi", "AVerMedia Information Inc."],
      "00181B" => ["TaijinMe", "TaiJin Metal Co., Ltd."],
      "00181C" => ["Exterity", "Exterity Limited"],
      "00181D" => ["AsiaElec", "ASIA ELECTRONICS CO.,LTD"],
      "00181E" => ["GdxTechn", "GDX Technologies Ltd."],
      "00181F" => ["Palmmicr", "Palmmicro Communications"],
      "001820" => ["W5networ", "w5networks"],
      "001821" => ["Sindoric", "SINDORICOH"],
      "001822" => ["CecTelec", "CEC TELECOM CO.,LTD."],
      "001823" => ["DeltaEle", "Delta Electronics, Inc."],
      "001824" => ["KimaldiE", "Kimaldi Electronics, S.L."],
      "001825" => ["Private",""],
      "001826" => ["CaleAcce", "Cale Access AB"],
      "001827" => ["NecUnifi", "NEC UNIFIED SOLUTIONS NEDERLAND B.V."],
      "001828" => ["E2vTechn", "e2v technologies (UK) ltd."],
      "001829" => ["Gatsomet", "Gatsometer"],
      "00182A" => ["TaiwanVi", "Taiwan Video & Monitor"],
      "00182B" => ["Softier",""],
      "00182C" => ["AscendNe", "Ascend Networks, Inc."],
      "00182D" => ["ArtecGro", "Artec Group OAoe"],
      "00182E" => ["Xstreamh", "XStreamHD, LLC"],
      "00182F" => ["TexasIns", "Texas Instruments"],
      "001830" => ["TexasIns", "Texas Instruments"],
      "001831" => ["TexasIns", "Texas Instruments"],
      "001832" => ["TexasIns", "Texas Instruments"],
      "001833" => ["TexasIns", "Texas Instruments"],
      "001834" => ["TexasIns", "Texas Instruments"],
      "001835" => ["Thoratec", "Thoratec / ITC"],
      "001836" => ["Reliance", "Reliance Electric Limited"],
      "001837" => ["Universa", "Universal ABIT Co., Ltd."],
      "001838" => ["Panacces", "PanAccess Communications,Inc."],
      "001839" => ["Cisco-Li", "Cisco-Linksys LLC"],
      "00183A" => ["WestellT", "Westell Technologies"],
      "00183B" => ["Cenits", "CENITS Co., Ltd."],
      "00183C" => ["EncoreSo", "Encore Software Limited"],
      "00183D" => ["VertexLi", "Vertex Link Corporation"],
      "00183E" => ["Digilent", "Digilent, Inc"],
      "00183F" => ["2wire", "2Wire, Inc"],
      "001840" => ["3Phoenix", "3 Phoenix, Inc."],
      "001841" => ["HighTech", "High Tech Computer Corp"],
      "001842" => ["NokiaDan", "Nokia Danmark A/S"],
      "001843" => ["Dawevisi", "Dawevision Ltd"],
      "001844" => ["HeadsUpT", "Heads Up Technologies, Inc."],
      "001845" => ["NplPulsa", "NPL Pulsar Ltd."],
      "001846" => ["CryptoSA", "Crypto S.A."],
      "001847" => ["AcenetTe", "AceNet Technology Inc."],
      "001848" => ["VecimaNe", "Vecima Networks Inc."],
      "001849" => ["PigeonPo", "Pigeon Point Systems"],
      "00184A" => ["Catcher", "Catcher, Inc."],
      "00184B" => ["LasVegas", "Las Vegas Gaming, Inc."],
      "00184C" => ["BogenCom", "Bogen Communications"],
      "00184D" => ["Netgear", "Netgear Inc."],
      "00184E" => ["LianheTe", "Lianhe Technologies, Inc."],
      "00184F" => ["8WaysTec", "8 Ways Technology Corp."],
      "001850" => ["SecfoneK", "Secfone Kft"],
      "001851" => ["Swsoft",""],
      "001852" => ["Storlink", "StorLink Semiconductors, Inc."],
      "001853" => ["AteraNet", "Atera Networks LTD."],
      "001854" => ["Argard", "Argard Co., Ltd"],
      "001855" => ["Aeromari", "Aeromaritime Systembau GmbH"],
      "001856" => ["Eyefi", "EyeFi, Inc"],
      "001857" => ["Unilever", "Unilever R&D"],
      "001858" => ["Tagmaste", "TagMaster AB"],
      "001859" => ["Strawber", "Strawberry Linux Co.,Ltd."],
      "00185A" => ["Ucontrol", "uControl, Inc."],
      "00185B" => ["NetworkC", "Network Chemistry, Inc"],
      "00185C" => ["EdsLabPt", "EDS Lab Pte Ltd"],
      "00185D" => ["TaiguenT", "TAIGUEN TECHNOLOGY (SHEN-ZHEN) CO., LTD."],
      "00185E" => ["Nexterm", "Nexterm Inc."],
      "00185F" => ["Tac", "TAC Inc."],
      "001860" => ["SimTechn", "SIM Technology Group Shanghai Simcom Ltd.,"],
      "001861" => ["Ooma", "Ooma, Inc."],
      "001862" => ["SeagateT", "Seagate Technology"],
      "001863" => ["Veritech", "Veritech Electronics Limited"],
      "001864" => ["Cybectec", "Cybectec Inc."],
      "001865" => ["SiemensH", "Siemens Healthcare Diagnostics Manufacturing Ltd"],
      "001866" => ["LeutronV", "Leutron Vision"],
      "001867" => ["Evolutio", "Evolution Robotics Retail"],
      "001868" => ["Scientif", "Scientific Atlanta, A Cisco Company"],
      "001869" => ["Kingjim",""],
      "00186A" => ["GlobalLi", "Global Link Digital Technology Co,.LTD"],
      "00186B" => ["SambuCom", "Sambu Communics CO., LTD."],
      "00186C" => ["Neonode", "Neonode AB"],
      "00186D" => ["Zhenjian", "Zhenjiang Sapphire Electronic Industry CO."],
      "00186E" => ["3com", "3Com Ltd"],
      "00186F" => ["SethaInd", "Setha Industria Eletronica LTDA"],
      "001870" => ["E28Shang", "E28 Shanghai Limited"],
      "001871" => ["Hewlett-", "Hewlett-Packard Company"],
      "001872" => ["Expertis", "Expertise Engineering"],
      "001873" => ["Cisco", "Cisco Systems"],
      "001874" => ["Cisco", "Cisco Systems"],
      "001875" => ["AnaciseT", "AnaCise Testnology Pte Ltd"],
      "001876" => ["Wowwee", "WowWee Ltd."],
      "001877" => ["Amplex", "Amplex A/S"],
      "001878" => ["Mackware", "Mackware GmbH"],
      "001879" => ["Dsys",""],
      "00187A" => ["Wiremold",""],
      "00187B" => ["4nsys", "4NSYS Co. Ltd."],
      "00187C" => ["Intercro", "INTERCROSS, LLC"],
      "00187D" => ["Armorlin", "Armorlink shanghai Co. Ltd"],
      "00187E" => ["RgbSpect", "RGB Spectrum"],
      "00187F" => ["Zodianet",""],
      "001880" => ["MaximInt", "Maxim Integrated Products"],
      "001881" => ["BuyangEl", "Buyang Electronics Industrial Co., Ltd"],
      "001882" => ["HuaweiTe", "Huawei Technologies Co., Ltd."],
      "001883" => ["Formosa2", "FORMOSA21 INC."],
      "001884" => ["FonTechn", "Fon Technology S.L."],
      "001885" => ["Avigilon", "Avigilon Corporation"],
      "001886" => ["El-Tech", "EL-TECH, INC."],
      "001887" => ["Metasyst", "Metasystem SpA"],
      "001888" => ["GotiveAS", "GOTIVE a.s."],
      "001889" => ["WinnetSo", "WinNet Solutions Limited"],
      "00188A" => ["Infinova", "Infinova LLC"],
      "00188B" => ["Dell",""],
      "00188C" => ["MobileAc", "Mobile Action Technology Inc."],
      "00188D" => ["NokiaDan", "Nokia Danmark A/S"],
      "00188E" => ["Ekahau", "Ekahau, Inc."],
      "00188F" => ["Montgome", "Montgomery Technology, Inc."],
      "001890" => ["Radiocom", "RadioCOM, s.r.o."],
      "001891" => ["Zhongsha", "Zhongshan General K-mate Electronics Co., Ltd"],
      "001892" => ["Ads-Tec", "ads-tec GmbH"],
      "001893" => ["Shenzhen", "SHENZHEN PHOTON BROADBAND TECHNOLOGY CO.,LTD"],
      "001894" => ["Zimocom",""],
      "001895" => ["HansunTe", "Hansun Technologies Inc."],
      "001896" => ["GreatWel", "Great Well Electronic LTD"],
      "001897" => ["Jess-Lin", "JESS-LINK PRODUCTS Co., LTD"],
      "001898" => ["Kingstat", "KINGSTATE ELECTRONICS CORPORATION"],
      "001899" => ["Shenzhen", "ShenZhen jieshun Science&Technology Industry CO,LTD."],
      "00189A" => ["HanaMicr", "HANA Micron Inc."],
      "00189B" => ["Thomson", "Thomson Inc."],
      "00189C" => ["Weldex", "Weldex Corporation"],
      "00189D" => ["Navcast", "Navcast Inc."],
      "00189E" => ["Omnikey", "OMNIKEY GmbH."],
      "00189F" => ["Lenntek", "Lenntek Corporation"],
      "0018A0" => ["CiermaAs", "Cierma Ascenseurs"],
      "0018A1" => ["TiqitCom", "Tiqit Computers, Inc."],
      "0018A2" => ["XipTechn", "XIP Technology AB"],
      "0018A3" => ["ZippyTec", "ZIPPY TECHNOLOGY CORP."],
      "0018A4" => ["Motorola", "Motorola Mobility, Inc."],
      "0018A5" => ["AdigitTe", "ADigit Technologies Corp."],
      "0018A6" => ["Persiste", "Persistent Systems, LLC"],
      "0018A7" => ["YoggieSe", "Yoggie Security Systems LTD."],
      "0018A8" => ["AnnealTe", "AnNeal Technology Inc."],
      "0018A9" => ["Ethernet", "Ethernet Direct Corporation"],
      "0018AA" => ["ProtecFi", "Protec Fire Detection plc"],
      "0018AB" => ["BeijingL", "BEIJING LHWT MICROELECTRONICS INC."],
      "0018AC" => ["Shanghai", "Shanghai Jiao Da HISYS Technology Co. Ltd."],
      "0018AD" => ["NidecSan", "NIDEC SANKYO CORPORATION"],
      "0018AE" => ["Tvt", "TVT CO.,LTD"],
      "0018AF" => ["SamsungE", "Samsung Electronics Co., Ltd."],
      "0018B0" => ["Nortel",""],
      "0018B1" => ["Ibm", "IBM Corp"],
      "0018B2" => ["AdeunisR", "ADEUNIS RF"],
      "0018B3" => ["TecWizho", "TEC WizHome Co., Ltd."],
      "0018B4" => ["DawonMed", "Dawon Media Inc."],
      "0018B5" => ["MagnaCar", "Magna Carta"],
      "0018B6" => ["S3c", "S3C, Inc."],
      "0018B7" => ["D3LedLlc", "D3 LED, LLC"],
      "0018B8" => ["NewVoice", "New Voice International AG"],
      "0018B9" => ["Cisco", "Cisco Systems"],
      "0018BA" => ["Cisco", "Cisco Systems"],
      "0018BB" => ["EliwellC", "Eliwell Controls srl"],
      "0018BC" => ["ZaoNvpBo", "ZAO NVP Bolid"],
      "0018BD" => ["Shenzhen", "SHENZHEN DVBWORLD TECHNOLOGY CO., LTD."],
      "0018BE" => ["Ansa", "ANSA Corporation"],
      "0018BF" => ["EssenceT", "Essence Technology Solution, Inc."],
      "0018C0" => ["Motorola", "Motorola Mobility, Inc."],
      "0018C1" => ["AlmitecI", "Almitec Informatica e Comercio Ltda."],
      "0018C2" => ["Firetide", "Firetide, Inc"],
      "0018C3" => ["Cs", "CS Corporation"],
      "0018C4" => ["RabaTech", "Raba Technologies LLC"],
      "0018C5" => ["NokiaDan", "Nokia Danmark A/S"],
      "0018C6" => ["OpwFuelM", "OPW Fuel Management Systems"],
      "0018C7" => ["RealTime", "Real Time Automation"],
      "0018C8" => ["Isonas", "ISONAS Inc."],
      "0018C9" => ["EopsTech", "EOps Technology Limited"],
      "0018CA" => ["Viprinet", "Viprinet GmbH"],
      "0018CB" => ["Tecobest", "Tecobest Technology Limited"],
      "0018CC" => ["AxiohmSa", "AXIOHM SAS"],
      "0018CD" => ["EraeElec", "Erae Electronics Industry Co., Ltd"],
      "0018CE" => ["Dreamtec", "Dreamtech Co., Ltd"],
      "0018CF" => ["BaldorEl", "Baldor Electric Company"],
      "0018D0" => ["AtroadAT", "AtRoad,  A Trimble Company"],
      "0018D1" => ["SiemensH", "Siemens Home & Office Comm. Devices"],
      "0018D2" => ["High-Gai", "High-Gain Antennas LLC"],
      "0018D3" => ["Teamcast",""],
      "0018D4" => ["UnifiedD", "Unified Display Interface SIG"],
      "0018D5" => ["Reigncom",""],
      "0018D6" => ["Swirlnet", "Swirlnet A/S"],
      "0018D7" => ["JavadNav", "Javad Navigation Systems Inc."],
      "0018D8" => ["ArchMete", "ARCH METER Corporation"],
      "0018D9" => ["Santosha", "Santosha Internatonal, Inc"],
      "0018DA" => ["AmberWir", "AMBER wireless GmbH"],
      "0018DB" => ["EplTechn", "EPL Technology Ltd"],
      "0018DC" => ["Prostar", "Prostar Co., Ltd."],
      "0018DD" => ["Silicond", "Silicondust Engineering Ltd"],
      "0018DE" => ["Intel", "Intel Corporation"],
      "0018DF" => ["Morey", "The Morey Corporation"],
      "0018E0" => ["Anaveo",""],
      "0018E1" => ["VerkerkS", "Verkerk Service Systemen"],
      "0018E2" => ["TopdataS", "Topdata Sistemas de Automacao Ltda"],
      "0018E3" => ["Visualga", "Visualgate Systems, Inc."],
      "0018E4" => ["Yiguang",""],
      "0018E5" => ["Adhoco", "Adhoco AG"],
      "0018E6" => ["Computer", "Computer Hardware Design SIA"],
      "0018E7" => ["CameoCom", "Cameo Communications, INC."],
      "0018E8" => ["Hacetron", "Hacetron Corporation"],
      "0018E9" => ["Numata", "Numata Corporation"],
      "0018EA" => ["Alltec", "Alltec GmbH"],
      "0018EB" => ["BrovisWi", "BroVis Wireless Networks"],
      "0018EC" => ["WeldingT", "Welding Technology Corporation"],
      "0018ED" => ["Accutech", "Accutech Ultrasystems Co., Ltd."],
      "0018EE" => ["Videolog", "Videology Imaging Solutions, Inc."],
      "0018EF" => ["EscapeCo", "Escape Communications, Inc."],
      "0018F0" => ["Joytoto", "JOYTOTO Co., Ltd."],
      "0018F1" => ["Chunichi", "Chunichi Denshi Co.,LTD."],
      "0018F2" => ["BeijingT", "Beijing Tianyu Communication Equipment Co., Ltd"],
      "0018F3" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "0018F4" => ["EoTechni", "EO TECHNICS Co., Ltd."],
      "0018F5" => ["Shenzhen", "Shenzhen Streaming Video Technology Company Limited"],
      "0018F6" => ["ThomsonT", "Thomson Telecom Belgium"],
      "0018F7" => ["Kameleon", "Kameleon Technologies"],
      "0018F8" => ["Cisco-Li", "Cisco-Linksys LLC"],
      "0018F9" => ["Vvond", "VVOND, Inc."],
      "0018FA" => ["YushinPr", "Yushin Precision Equipment Co.,Ltd."],
      "0018FB" => ["ComproTe", "Compro Technology"],
      "0018FC" => ["AltecEle", "Altec Electronic AG"],
      "0018FD" => ["OptimalT", "Optimal Technologies International Inc."],
      "0018FE" => ["Hewlett-", "Hewlett-Packard Company"],
      "0018FF" => ["Powerqua", "PowerQuattro Co."],
      "001900" => ["Intelliv", "Intelliverese - DBA Voicecom"],
      "001901" => ["F1media",""],
      "001902" => ["Cambridg", "Cambridge Consultants Ltd"],
      "001903" => ["BigfootN", "Bigfoot Networks Inc"],
      "001904" => ["WbElectr", "WB Electronics Sp. z o.o."],
      "001905" => ["SchrackS", "SCHRACK Seconet AG"],
      "001906" => ["Cisco", "Cisco Systems"],
      "001907" => ["Cisco", "Cisco Systems"],
      "001908" => ["Duaxes", "Duaxes Corporation"],
      "001909" => ["Devi", "Devi A/S"],
      "00190A" => ["Hasware", "HASWARE INC."],
      "00190B" => ["Southern", "Southern Vision Systems, Inc."],
      "00190C" => ["EncoreEl", "Encore Electronics, Inc."],
      "00190D" => ["Ieee1394", "IEEE 1394c"],
      "00190E" => ["AtechTec", "Atech Technology Co., Ltd."],
      "00190F" => ["Advansus", "Advansus Corp."],
      "001910" => ["KnickEle", "Knick Elektronische Messgeraete GmbH & Co. KG"],
      "001911" => ["JustInMo", "Just In Mobile Information Technologies (Shanghai) Co., Ltd."],
      "001912" => ["Welcat", "Welcat Inc"],
      "001913" => ["Chuang-Y", "Chuang-Yi Network Equipment Co.Ltd."],
      "001914" => ["Winix", "Winix Co., Ltd"],
      "001915" => ["Tecom", "TECOM Co., Ltd."],
      "001916" => ["Paytec", "PayTec AG"],
      "001917" => ["Posiflex", "Posiflex Inc."],
      "001918" => ["Interact", "Interactive Wear AG"],
      "001919" => ["Astel", "ASTEL Inc."],
      "00191A" => ["Irlink",""],
      "00191B" => ["SputnikE", "Sputnik Engineering AG"],
      "00191C" => ["Sensicas", "Sensicast Systems"],
      "00191D" => ["Nintendo", "Nintendo Co.,Ltd."],
      "00191E" => ["Beyondwi", "Beyondwiz Co., Ltd."],
      "00191F" => ["Microlin", "Microlink communications Inc."],
      "001920" => ["KumeElec", "KUME electric Co.,Ltd."],
      "001921" => ["Elitegro", "Elitegroup Computer System Co."],
      "001922" => ["CmComand", "CM Comandos Lineares"],
      "001923" => ["PhonexKo", "Phonex Korea Co., LTD."],
      "001924" => ["LbnlEngi", "LBNL  Engineering"],
      "001925" => ["Intelici", "Intelicis Corporation"],
      "001926" => ["Bitsgen", "BitsGen Co., Ltd."],
      "001927" => ["Imcosys", "ImCoSys Ltd"],
      "001928" => ["SiemensT", "Siemens AG, Transportation Systems"],
      "001929" => ["2m2bMont", "2M2B Montadora de Maquinas Bahia Brasil LTDA"],
      "00192A" => ["AntiopeA", "Antiope Associates"],
      "00192B" => ["AclaraRf", "Aclara RF Systems Inc."],
      "00192C" => ["Motorola", "Motorola Mobility, Inc."],
      "00192D" => ["Nokia", "Nokia Corporation"],
      "00192E" => ["Spectral", "Spectral Instruments, Inc."],
      "00192F" => ["Cisco", "Cisco Systems"],
      "001930" => ["Cisco", "Cisco Systems"],
      "001931" => ["Balluff", "Balluff GmbH"],
      "001932" => ["GudeAnal", "Gude Analog- und Digialsysteme GmbH"],
      "001933" => ["Strix", "Strix Systems, Inc."],
      "001934" => ["TrendonT", "TRENDON TOUCH TECHNOLOGY CORP."],
      "001935" => ["DuerrDen", "Duerr Dental GmbH & Co. KG"],
      "001936" => ["Sterlite", "STERLITE OPTICAL TECHNOLOGIES LIMITED"],
      "001937" => ["Commerce", "CommerceGuard AB"],
      "001938" => ["UmbCommu", "UMB Communications Co., Ltd."],
      "001939" => ["Gigamips",""],
      "00193A" => ["Oesoluti", "OESOLUTIONS"],
      "00193B" => ["WiliboxD", "Wilibox Deliberant Group LLC"],
      "00193C" => ["Highpoin", "HighPoint Technologies Incorporated"],
      "00193D" => ["GmcGuard", "GMC Guardian Mobility Corp."],
      "00193E" => ["AdbBroad", "ADB Broadband Italia"],
      "00193F" => ["RdiTechn", "RDI technology(Shenzhen) Co.,LTD"],
      "001940" => ["Rackable", "Rackable Systems"],
      "001941" => ["PitneyBo", "Pitney Bowes, Inc"],
      "001942" => ["OnSoftwa", "ON SOFTWARE INTERNATIONAL LIMITED"],
      "001943" => ["Belden",""],
      "001944" => ["FossilPa", "Fossil Partners, L.P."],
      "001945" => ["Ten-Tec", "Ten-Tec Inc."],
      "001946" => ["CianetIn", "Cianet Industria e Comercio S/A"],
      "001947" => ["Scientif", "Scientific Atlanta, A Cisco Company"],
      "001948" => ["Airespid", "AireSpider Networks"],
      "001949" => ["TentelCo", "TENTEL  COMTECH CO., LTD."],
      "00194A" => ["Testo", "TESTO AG"],
      "00194B" => ["SagemCom", "SAGEM COMMUNICATION"],
      "00194C" => ["FujianSt", "Fujian Stelcom information & Technology CO.,Ltd"],
      "00194D" => ["AvagoTec", "Avago Technologies Sdn Bhd"],
      "00194E" => ["UltraEle", "Ultra Electronics - TCS (Tactical Communication Systems)"],
      "00194F" => ["NokiaDan", "Nokia Danmark A/S"],
      "001950" => ["HarmanMu", "Harman Multimedia"],
      "001951" => ["NetconsS", "NETCONS, s.r.o."],
      "001952" => ["Acogito", "ACOGITO Co., Ltd"],
      "001953" => ["Chainlea", "Chainleader Communications Corp."],
      "001954" => ["Leaf", "Leaf Corporation."],
      "001955" => ["Cisco", "Cisco Systems"],
      "001956" => ["Cisco", "Cisco Systems"],
      "001957" => ["SaafnetC", "Saafnet Canada Inc."],
      "001958" => ["Bluetoot", "Bluetooth SIG, Inc."],
      "001959" => ["Staccato", "Staccato Communications Inc."],
      "00195A" => ["JenaerAn", "Jenaer Antriebstechnik GmbH"],
      "00195B" => ["D-Link", "D-Link Corporation"],
      "00195C" => ["Innotech", "Innotech Corporation"],
      "00195D" => ["Shenzhen", "ShenZhen XinHuaTong Opto Electronics Co.,Ltd"],
      "00195E" => ["Motorola", "Motorola Mobility, Inc."],
      "00195F" => ["Valemoun", "Valemount Networks Corporation"],
      "001960" => ["Docomo", "DoCoMo Systems, Inc."],
      "001961" => ["Blaupunk", "Blaupunkt  Embedded Systems GmbH"],
      "001962" => ["Commerci", "Commerciant, LP"],
      "001963" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "001964" => ["Doorking", "Doorking Inc."],
      "001965" => ["YuhuaTel", "YuHua TelTech (ShangHai) Co., Ltd."],
      "001966" => ["Asiarock", "Asiarock Technology Limited"],
      "001967" => ["TeldatSp", "TELDAT Sp.J."],
      "001968" => ["DigitalV", "Digital Video Networks(Shanghai) CO. LTD."],
      "001969" => ["Nortel",""],
      "00196A" => ["Mikrom", "MikroM GmbH"],
      "00196B" => ["Danpex", "Danpex Corporation"],
      "00196C" => ["Etrovisi", "ETROVISION TECHNOLOGY"],
      "00196D" => ["RaybitKo", "Raybit Systems Korea, Inc"],
      "00196E" => ["MetacomP", "Metacom (Pty) Ltd."],
      "00196F" => ["Sensopar", "SensoPart GmbH"],
      "001970" => ["Z-Com", "Z-Com, Inc."],
      "001971" => ["Guangzho", "Guangzhou Unicomp Technology Co.,Ltd"],
      "001972" => ["PlexusXi", "Plexus (Xiamen) Co.,ltd"],
      "001973" => ["Zeugma", "Zeugma Systems"],
      "001974" => ["Abocom", "AboCom Systems, Inc."],
      "001975" => ["BeijingH", "Beijing Huisen networks technology Inc"],
      "001976" => ["XipherTe", "Xipher Technologies, LLC"],
      "001977" => ["Aerohive", "Aerohive Networks, Inc."],
      "001978" => ["Datum", "Datum Systems, Inc."],
      "001979" => ["NokiaDan", "Nokia Danmark A/S"],
      "00197A" => ["Mazet", "MAZeT GmbH"],
      "00197B" => ["Picotest", "Picotest Corp."],
      "00197C" => ["RiedelCo", "Riedel Communications GmbH"],
      "00197D" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd"],
      "00197E" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd"],
      "00197F" => ["Plantron", "PLANTRONICS, INC."],
      "001980" => ["Gridpoin", "Gridpoint Systems"],
      "001981" => ["Vivox", "Vivox Inc"],
      "001982" => ["Smardtv",""],
      "001983" => ["CctR&D", "CCT R&D Limited"],
      "001984" => ["Estic", "ESTIC Corporation"],
      "001985" => ["ItWatchd", "IT Watchdogs, Inc"],
      "001986" => ["ChengHon", "Cheng Hongjian"],
      "001987" => ["Panasoni", "Panasonic Mobile Communications Co., Ltd."],
      "001988" => ["Wi2wi", "Wi2Wi, Inc"],
      "001989" => ["Sonitrol", "Sonitrol Corporation"],
      "00198A" => ["Northrop", "Northrop Grumman Systems Corp."],
      "00198B" => ["NoveraOp", "Novera Optics Korea, Inc."],
      "00198C" => ["Ixsea",""],
      "00198D" => ["OceanOpt", "Ocean Optics, Inc."],
      "00198E" => ["Oticon", "Oticon A/S"],
      "00198F" => ["AlcatelB", "Alcatel Bell N.V."],
      "001990" => ["ElmData", "ELM DATA Co., Ltd."],
      "001991" => ["Avinfo",""],
      "001992" => ["Adtran", "ADTRAN INC."],
      "001993" => ["Changshu", "Changshu Switchgear MFG. Co.,Ltd. (Former Changshu Switchgea"],
      "001994" => ["JorjinTe", "Jorjin Technologies Inc."],
      "001995" => ["JurongHi", "Jurong Hi-Tech (Suzhou)Co.ltd"],
      "001996" => ["Turboche", "TurboChef Technologies Inc."],
      "001997" => ["SoftDevi", "Soft Device Sdn Bhd"],
      "001998" => ["Sato", "SATO CORPORATION"],
      "001999" => ["FujitsuT", "Fujitsu Technology Solutions"],
      "00199A" => ["Edo-Evi",""],
      "00199B" => ["Diversif", "Diversified Technical Systems, Inc."],
      "00199C" => ["Ctring",""],
      "00199D" => ["Vizio", "VIZIO, Inc."],
      "00199E" => ["Showaden", "SHOWADENSHI ELECTRONICS,INC."],
      "00199F" => ["Dkt", "DKT A/S"],
      "0019A0" => ["NihonDat", "NIHON DATA SYSTENS, INC."],
      "0019A1" => ["LgInform", "LG INFORMATION & COMM."],
      "0019A2" => ["OrdynTec", "ORDYN TECHNOLOGIES"],
      "0019A3" => ["AsteelEl", "asteel electronique atlantique"],
      "0019A4" => ["AustarTe", "Austar Technology (hang zhou) Co.,Ltd"],
      "0019A5" => ["Radarfin", "RadarFind Corporation"],
      "0019A6" => ["Motorola", "Motorola Mobility, Inc."],
      "0019A7" => ["Itu-T",""],
      "0019A8" => ["WiquestC", "WiQuest Communications"],
      "0019A9" => ["Cisco", "Cisco Systems"],
      "0019AA" => ["Cisco", "Cisco Systems"],
      "0019AB" => ["Raycom", "Raycom CO ., LTD"],
      "0019AC" => ["Gsp", "GSP SYSTEMS Inc."],
      "0019AD" => ["BobstSa", "BOBST SA"],
      "0019AE" => ["HoplingT", "Hopling Technologies b.v."],
      "0019AF" => ["RigolTec", "Rigol Technologies, Inc."],
      "0019B0" => ["HanyangS", "HanYang System"],
      "0019B1" => ["Arrow7", "Arrow7 Corporation"],
      "0019B2" => ["Xynetsof", "XYnetsoft Co.,Ltd"],
      "0019B3" => ["Stanford", "Stanford Research Systems"],
      "0019B4" => ["Videocas", "VideoCast Ltd."],
      "0019B5" => ["FamarFue", "Famar Fueguina S.A."],
      "0019B6" => ["EuroEmme", "Euro Emme s.r.l."],
      "0019B7" => ["NokiaDan", "Nokia Danmark A/S"],
      "0019B8" => ["Boundary", "Boundary Devices"],
      "0019B9" => ["Dell", "Dell Inc."],
      "0019BA" => ["ParadoxS", "Paradox Security Systems Ltd"],
      "0019BB" => ["Hewlett-", "Hewlett-Packard Company"],
      "0019BC" => ["ElectroC", "ELECTRO CHANCE SRL"],
      "0019BD" => ["NewMedia", "New Media Life"],
      "0019BE" => ["AltaiTec", "Altai Technologies Limited"],
      "0019BF" => ["CitiwayT", "Citiway technology Co.,ltd"],
      "0019C0" => ["Motorola", "Motorola Mobility, Inc."],
      "0019C1" => ["AlpsElec", "Alps Electric Co., Ltd"],
      "0019C2" => ["Equustek", "Equustek Solutions, Inc."],
      "0019C3" => ["Qualitro", "Qualitrol"],
      "0019C4" => ["Infocryp", "Infocrypt Inc."],
      "0019C5" => ["SonyComp", "SONY Computer Entertainment inc,"],
      "0019C6" => ["Zte", "ZTE Corporation"],
      "0019C7" => ["Cambridg", "Cambridge Industries(Group) Co.,Ltd."],
      "0019C8" => ["Anydata", "AnyDATA Corporation"],
      "0019C9" => ["S&CElect", "S&C ELECTRIC COMPANY"],
      "0019CA" => ["Broadata", "Broadata Communications, Inc"],
      "0019CB" => ["ZyxelCom", "ZyXEL Communications Corporation"],
      "0019CC" => ["RcgHk", "RCG (HK) Ltd"],
      "0019CD" => ["ChengduE", "Chengdu ethercom information technology Ltd."],
      "0019CE" => ["Progress", "Progressive Gaming International"],
      "0019CF" => ["SalicruS", "SALICRU, S.A."],
      "0019D0" => ["Cathexis",""],
      "0019D1" => ["Intel", "Intel Corporation"],
      "0019D2" => ["Intel", "Intel Corporation"],
      "0019D3" => ["TrakMicr", "TRAK Microwave"],
      "0019D4" => ["IcxTechn", "ICX Technologies"],
      "0019D5" => ["IpInnova", "IP Innovations, Inc."],
      "0019D6" => ["LsCable", "LS Cable Ltd."],
      "0019D7" => ["Fortunet", "FORTUNETEK CO., LTD"],
      "0019D8" => ["Maxfor",""],
      "0019D9" => ["Zeutsche", "Zeutschel GmbH"],
      "0019DA" => ["Welltran", "Welltrans O&E Technology Co. , Ltd."],
      "0019DB" => ["Micro-St", "MICRO-STAR INTERNATIONAL CO., LTD."],
      "0019DC" => ["EnensysT", "ENENSYS Technologies"],
      "0019DD" => ["Fei-Zyfe", "FEI-Zyfer, Inc."],
      "0019DE" => ["Mobitek",""],
      "0019DF" => ["Thomson", "Thomson Inc."],
      "0019E0" => ["Tp-LinkT", "TP-LINK Technologies Co., Ltd."],
      "0019E1" => ["Nortel",""],
      "0019E2" => ["JuniperN", "Juniper Networks"],
      "0019E3" => ["AppleCom", "Apple Computer Inc."],
      "0019E4" => ["2wire", "2Wire, Inc"],
      "0019E5" => ["LynxStud", "Lynx Studio Technology, Inc."],
      "0019E6" => ["ToyoMedi", "TOYO MEDIC CO.,LTD."],
      "0019E7" => ["Cisco", "Cisco Systems"],
      "0019E8" => ["Cisco", "Cisco Systems"],
      "0019E9" => ["S-Inform", "S-Information Technolgy, Co., Ltd."],
      "0019EA" => ["Teramage", "TeraMage Technologies Co., Ltd."],
      "0019EB" => ["Pyronix", "Pyronix Ltd"],
      "0019EC" => ["Sagamore", "Sagamore Systems, Inc."],
      "0019ED" => ["Axesstel", "Axesstel Inc."],
      "0019EE" => ["CarloGav", "CARLO GAVAZZI CONTROLS SPA-Controls Division"],
      "0019EF" => ["Shenzhen", "SHENZHEN LINNKING ELECTRONICS CO.,LTD"],
      "0019F0" => ["Unionman", "UNIONMAN TECHNOLOGY CO.,LTD"],
      "0019F1" => ["StarComm", "Star Communication Network Technology Co.,Ltd"],
      "0019F2" => ["Teradyne", "Teradyne K.K."],
      "0019F3" => ["Cetis", "Cetis, Inc"],
      "0019F4" => ["Converge", "Convergens Oy Ltd"],
      "0019F5" => ["Imaginat", "Imagination Technologies Ltd"],
      "0019F6" => ["AcconetP", "Acconet (PTE) Ltd"],
      "0019F7" => ["OnsetCom", "Onset Computer Corporation"],
      "0019F8" => ["Embedded", "Embedded Systems Design, Inc."],
      "0019F9" => ["Tdk-Lamb", "TDK-Lambda"],
      "0019FA" => ["CableVis", "Cable Vision Electronics CO., LTD."],
      "0019FB" => ["Bskyb", "BSkyB Ltd"],
      "0019FC" => ["PtUfoaks", "PT. Ufoakses Sukses Luarbiasa"],
      "0019FD" => ["Nintendo", "Nintendo Co., Ltd."],
      "0019FE" => ["Shenzhen", "SHENZHEN SEECOMM TECHNOLOGY CO.,LTD."],
      "0019FF" => ["Finnzyme", "Finnzymes"],
      "001A00" => ["Matrix", "MATRIX INC."],
      "001A01" => ["SmithsMe", "Smiths Medical"],
      "001A02" => ["SecureCa", "SECURE CARE PRODUCTS, INC"],
      "001A03" => ["AngelEle", "Angel Electronics Co., Ltd."],
      "001A04" => ["InterayS", "Interay Solutions BV"],
      "001A05" => ["Optibase", "OPTIBASE LTD"],
      "001A06" => ["Opvista", "OpVista, Inc."],
      "001A07" => ["ArecontV", "Arecont Vision"],
      "001A08" => ["DalmanTe", "Dalman Technical Services"],
      "001A09" => ["Wayfarer", "Wayfarer Transit Systems Ltd"],
      "001A0A" => ["Adaptive", "Adaptive Micro-Ware Inc."],
      "001A0B" => ["BonaTech", "BONA TECHNOLOGY INC."],
      "001A0C" => ["Swe-Dish", "Swe-Dish Satellite Systems AB"],
      "001A0D" => ["Handheld", "HandHeld entertainment, Inc."],
      "001A0E" => ["ChengUei", "Cheng Uei Precision Industry Co.,Ltd"],
      "001A0F" => ["Sistemas", "Sistemas Avanzados de Control, S.A."],
      "001A10" => ["LucentTr", "LUCENT TRANS ELECTRONICS CO.,LTD"],
      "001A11" => ["Google", "Google Inc."],
      "001A12" => ["Essilor",""],
      "001A13" => ["WanlidaG", "Wanlida Group Co., LTD"],
      "001A14" => ["XinHuaCo", "Xin Hua Control Engineering Co.,Ltd."],
      "001A15" => ["GemaltoE", "gemalto e-Payment"],
      "001A16" => ["NokiaDan", "Nokia Danmark A/S"],
      "001A17" => ["TeakTech", "Teak Technologies, Inc."],
      "001A18" => ["Advanced", "Advanced Simulation Technology inc."],
      "001A19" => ["Computer", "Computer Engineering Limited"],
      "001A1A" => ["GentexCo", "Gentex Corporation/Electro-Acoustic Products"],
      "001A1B" => ["Motorola", "Motorola Mobility, Inc."],
      "001A1C" => ["Gt&TEngi", "GT&T Engineering Pte Ltd"],
      "001A1D" => ["PchomeOn", "PChome Online Inc."],
      "001A1E" => ["ArubaNet", "Aruba Networks"],
      "001A1F" => ["CoastalE", "Coastal Environmental Systems"],
      "001A20" => ["Cmotech", "CMOTECH Co. Ltd."],
      "001A21" => ["IndacBV", "Indac B.V."],
      "001A22" => ["Eq-3Entw", "eQ-3 Entwicklung GmbH"],
      "001A23" => ["IceQube", "Ice Qube, Inc"],
      "001A24" => ["GalaxyTe", "Galaxy Telecom Technologies Ltd"],
      "001A25" => ["DeltaDor", "DELTA DORE"],
      "001A26" => ["Deltanod", "Deltanode Solutions AB"],
      "001A27" => ["Ubistar",""],
      "001A28" => ["AswtTaiw", "ASWT Co., LTD. Taiwan Branch H.K."],
      "001A29" => ["Techsoni", "Techsonic Industries d/b/a Humminbird"],
      "001A2A" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "001A2B" => ["AyecomTe", "Ayecom Technology Co., Ltd."],
      "001A2C" => ["Satec", "SATEC Co.,LTD"],
      "001A2D" => ["NavvoGro", "The Navvo Group"],
      "001A2E" => ["ZiovaCop", "Ziova Coporation"],
      "001A2F" => ["Cisco", "Cisco Systems"],
      "001A30" => ["Cisco", "Cisco Systems"],
      "001A31" => ["ScanCoin", "SCAN COIN Industries AB"],
      "001A32" => ["ActivaMu", "ACTIVA MULTIMEDIA"],
      "001A33" => ["AsiCommu", "ASI Communications, Inc."],
      "001A34" => ["KonkaGro", "Konka Group Co., Ltd."],
      "001A35" => ["Bartec", "BARTEC GmbH"],
      "001A36" => ["Aipermon", "Aipermon GmbH & Co. KG"],
      "001A37" => ["Lear", "Lear Corporation"],
      "001A38" => ["Sanmina-", "Sanmina-SCI"],
      "001A39" => ["MertenGm", "Merten GmbH&CoKG"],
      "001A3A" => ["Dongahel", "Dongahelecomm"],
      "001A3B" => ["DoahElec", "Doah Elecom Inc."],
      "001A3C" => ["Technowa", "Technowave Ltd."],
      "001A3D" => ["AjinVisi", "Ajin Vision Co.,Ltd"],
      "001A3E" => ["FasterTe", "Faster Technology LLC"],
      "001A3F" => ["Intelbra", "intelbras"],
      "001A40" => ["A-FourTe", "A-FOUR TECH CO., LTD."],
      "001A41" => ["Inocova", "INOCOVA Co.,Ltd"],
      "001A42" => ["Techcity", "Techcity Technology co., Ltd."],
      "001A43" => ["LogicalL", "Logical Link Communications"],
      "001A44" => ["Jwtradin", "JWTrading Co., Ltd"],
      "001A45" => ["GnNetcom", "GN Netcom as"],
      "001A46" => ["DigitalM", "Digital Multimedia Technology Co., Ltd"],
      "001A47" => ["Agami", "Agami Systems, Inc."],
      "001A48" => ["Takacom", "Takacom Corporation"],
      "001A49" => ["MicroVis", "Micro Vision Co.,LTD"],
      "001A4A" => ["Qumranet", "Qumranet Inc."],
      "001A4B" => ["Hewlett-", "Hewlett-Packard Company"],
      "001A4C" => ["Crossbow", "Crossbow Technology, Inc"],
      "001A4D" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "001A4E" => ["Nti/Linm", "NTI AG / LinMot"],
      "001A4F" => ["Avm", "AVM GmbH"],
      "001A50" => ["PheenetT", "PheeNet Technology Corp."],
      "001A51" => ["AlfredMa", "Alfred Mann Foundation"],
      "001A52" => ["Meshlinx", "Meshlinx Wireless Inc."],
      "001A53" => ["Zylaya",""],
      "001A54" => ["HipShing", "Hip Shing Electronics Ltd."],
      "001A55" => ["Aca-Digi", "ACA-Digital Corporation"],
      "001A56" => ["Viewtel", "ViewTel Co,. Ltd."],
      "001A57" => ["MatrixDe", "Matrix Design Group, LLC"],
      "001A58" => ["CcvDeuts", "CCV Deutschland GmbH - Celectronic eHealth Div."],
      "001A59" => ["Ircona",""],
      "001A5A" => ["KoreaEle", "Korea Electric Power Data Network  (KDN) Co., Ltd"],
      "001A5B" => ["NetcareS", "NetCare Service Co., Ltd."],
      "001A5C" => ["EuchnerG", "Euchner GmbH+Co. KG"],
      "001A5D" => ["Mobinnov", "Mobinnova Corp."],
      "001A5E" => ["ThincomT", "Thincom Technology Co.,Ltd"],
      "001A5F" => ["Kitworks", "KitWorks.fi Ltd."],
      "001A60" => ["WaveElec", "Wave Electronics Co.,Ltd."],
      "001A61" => ["Pacstar", "PacStar Corp."],
      "001A62" => ["DataRobo", "Data Robotics, Incorporated"],
      "001A63" => ["ElsterSo", "Elster Solutions, LLC,"],
      "001A64" => ["Ibm", "IBM Corp"],
      "001A65" => ["Seluxit",""],
      "001A66" => ["Motorola", "Motorola Mobility, Inc."],
      "001A67" => ["Infinite", "Infinite QL Sdn Bhd"],
      "001A68" => ["WeltecEn", "Weltec Enterprise Co., Ltd."],
      "001A69" => ["WuhanYan", "Wuhan Yangtze Optical Technology CO.,Ltd."],
      "001A6A" => ["Tranzas", "Tranzas, Inc."],
      "001A6B" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "001A6C" => ["Cisco", "Cisco Systems"],
      "001A6D" => ["Cisco", "Cisco Systems"],
      "001A6E" => ["ImproTec", "Impro Technologies"],
      "001A6F" => ["MiTelSRL", "MI.TEL s.r.l."],
      "001A70" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "001A71" => ["Diostech", "Diostech Co., Ltd."],
      "001A72" => ["MosartSe", "Mosart Semiconductor Corp."],
      "001A73" => ["GemtekTe", "Gemtek Technology Co., Ltd."],
      "001A74" => ["ProcareI", "Procare International Co"],
      "001A75" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "001A76" => ["SdtInfor", "SDT information Technology Co.,LTD."],
      "001A77" => ["Motorola", "Motorola Mobility, Inc."],
      "001A78" => ["Ubtos",""],
      "001A79" => ["Telecomu", "TELECOMUNICATION TECHNOLOGIES LTD."],
      "001A7A" => ["LismoreI", "Lismore Instruments Limited"],
      "001A7B" => ["Teleco", "Teleco, Inc."],
      "001A7C" => ["Hirschma", "Hirschmann Multimedia B.V."],
      "001A7D" => ["Cyber-Bl", "cyber-blue(HK)Ltd"],
      "001A7E" => ["LnSritha", "LN Srithai Comm Ltd."],
      "001A7F" => ["GciScien", "GCI Science&Technology Co.,Ltd."],
      "001A80" => ["Sony", "Sony Corporation"],
      "001A81" => ["Zelax",""],
      "001A82" => ["ProbaBui", "PROBA Building Automation Co.,LTD"],
      "001A83" => ["PegasusT", "Pegasus Technologies Inc."],
      "001A84" => ["VOneMult", "V One Multimedia Pte Ltd"],
      "001A85" => ["NvMichel", "NV Michel Van de Wiele"],
      "001A86" => ["Advanced", "AdvancedIO Systems Inc"],
      "001A87" => ["CanholdI", "Canhold International Limited"],
      "001A88" => ["Venergy", "Venergy,Co,Ltd"],
      "001A89" => ["NokiaDan", "Nokia Danmark A/S"],
      "001A8A" => ["SamsungE", "Samsung Electronics Co., Ltd."],
      "001A8B" => ["ChunilEl", "CHUNIL ELECTRIC IND., CO."],
      "001A8C" => ["Astaro", "Astaro AG"],
      "001A8D" => ["AvecsBer", "AVECS Bergen GmbH"],
      "001A8E" => ["3wayNetw", "3Way Networks Ltd"],
      "001A8F" => ["Nortel",""],
      "001A90" => ["TropicoS", "Tropico Sistemas e Telecomunicacoes da Amazonia LTDA."],
      "001A91" => ["Fusiondy", "FusionDynamic Ltd."],
      "001A92" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "001A93" => ["ErcoLeuc", "ERCO Leuchten GmbH"],
      "001A94" => ["Votronic", "Votronic GmbH"],
      "001A95" => ["HisenseM", "Hisense Mobile Communications Technoligy Co.,Ltd."],
      "001A96" => ["EclerSA", "ECLER S.A."],
      "001A97" => ["Fitivisi", "fitivision technology Inc."],
      "001A98" => ["AsotelCo", "Asotel Communication Limited Taiwan Branch"],
      "001A99" => ["SmartyHz", "Smarty (HZ) Information Electronics Co., Ltd"],
      "001A9A" => ["Skyworth", "Skyworth Digital technology(shenzhen)co.ltd."],
      "001A9B" => ["AdecPart", "ADEC & Parter AG"],
      "001A9C" => ["Righthan", "RightHand Technologies, Inc."],
      "001A9D" => ["SkipperW", "Skipper Wireless, Inc."],
      "001A9E" => ["IconDigi", "ICON Digital International Limited"],
      "001A9F" => ["A-LinkEu", "A-Link Europe Ltd"],
      "001AA0" => ["Dell", "Dell Inc"],
      "001AA1" => ["Cisco", "Cisco Systems"],
      "001AA2" => ["Cisco", "Cisco Systems"],
      "001AA3" => ["Delorme",""],
      "001AA4" => ["FutureUn", "Future University-Hakodate"],
      "001AA5" => ["BrnPhoen", "BRN Phoenix"],
      "001AA6" => ["Telefunk", "Telefunken Radio Communication Systems GmbH &CO.KG"],
      "001AA7" => ["TorianWi", "Torian Wireless"],
      "001AA8" => ["MamiyaDi", "Mamiya Digital Imaging Co., Ltd."],
      "001AA9" => ["FujianSt", "FUJIAN STAR-NET COMMUNICATION CO.,LTD"],
      "001AAA" => ["Analogic", "Analogic Corp."],
      "001AAB" => ["EwingsSR", "eWings s.r.l."],
      "001AAC" => ["Corelatu", "Corelatus AB"],
      "001AAD" => ["Motorola", "Motorola Mobility, Inc."],
      "001AAE" => ["SavantLl", "Savant Systems LLC"],
      "001AAF" => ["BlusensT", "BLUSENS TECHNOLOGY"],
      "001AB0" => ["SignalNe", "Signal Networks Pvt. Ltd.,"],
      "001AB1" => ["AsiaPaci", "Asia Pacific Satellite Industries Co., Ltd."],
      "001AB2" => ["CyberSol", "Cyber Solutions Inc."],
      "001AB3" => ["Visionit", "VISIONITE INC."],
      "001AB4" => ["Ffei", "FFEI Ltd."],
      "001AB5" => ["HomeNetw", "Home Network System"],
      "001AB6" => ["TexasIns", "Texas Instruments"],
      "001AB7" => ["EthosNet", "Ethos Networks LTD."],
      "001AB8" => ["Anseri", "Anseri Corporation"],
      "001AB9" => ["Pmc",""],
      "001ABA" => ["CatonOve", "Caton Overseas Limited"],
      "001ABB" => ["FontalTe", "Fontal Technology Incorporation"],
      "001ABC" => ["U4eaTech", "U4EA Technologies Ltd"],
      "001ABD" => ["Impatica", "Impatica Inc."],
      "001ABE" => ["Computer", "COMPUTER HI-TECH INC."],
      "001ABF" => ["TrumpfLa", "TRUMPF Laser Marking Systems AG"],
      "001AC0" => ["JoybienT", "JOYBIEN TECHNOLOGIES CO., LTD."],
      "001AC1" => ["3com", "3Com Ltd"],
      "001AC2" => ["Yec", "YEC Co.,Ltd."],
      "001AC3" => ["Scientif", "Scientific-Atlanta, Inc"],
      "001AC4" => ["2wire", "2Wire, Inc"],
      "001AC5" => ["Breaking", "BreakingPoint Systems, Inc."],
      "001AC6" => ["MicroCon", "Micro Control Designs"],
      "001AC7" => ["Unipoint",""],
      "001AC8" => ["IslInstr", "ISL (Instrumentation Scientifique de Laboratoire)"],
      "001AC9" => ["Suzuken", "SUZUKEN CO.,LTD"],
      "001ACA" => ["Tilera", "Tilera Corporation"],
      "001ACB" => ["AutocomP", "Autocom Products Ltd"],
      "001ACC" => ["Celestia", "Celestial Semiconductor, Ltd"],
      "001ACD" => ["TidelEng", "Tidel Engineering LP"],
      "001ACE" => ["Yupiteru", "YUPITERU CORPORATION"],
      "001ACF" => ["CTElettr", "C.T. ELETTRONICA"],
      "001AD0" => ["AlbisTec", "Albis Technologies AG"],
      "001AD1" => ["Fargo", "FARGO CO., LTD."],
      "001AD2" => ["Eletroni", "Eletronica Nitron Ltda"],
      "001AD3" => ["Vamp", "Vamp Ltd."],
      "001AD4" => ["IpoxTech", "iPOX Technology Co., Ltd."],
      "001AD5" => ["KmcChain", "KMC CHAIN INDUSTRIAL CO., LTD."],
      "001AD6" => ["JiagnsuA", "JIAGNSU AETNA ELECTRIC CO.,LTD"],
      "001AD7" => ["Christie", "Christie Digital Systems, Inc."],
      "001AD8" => ["Alsterae", "AlsterAero GmbH"],
      "001AD9" => ["Internat", "International Broadband Electric Communications, Inc."],
      "001ADA" => ["Biz-2-Me", "Biz-2-Me Inc."],
      "001ADB" => ["Motorola", "Motorola Mobility, Inc."],
      "001ADC" => ["NokiaDan", "Nokia Danmark A/S"],
      "001ADD" => ["Pepwave", "PePWave Ltd"],
      "001ADE" => ["Motorola", "Motorola Mobility, Inc."],
      "001ADF" => ["Interact", "Interactivetv Pty Limited"],
      "001AE0" => ["Mytholog", "Mythology Tech Express Inc."],
      "001AE1" => ["EdgeAcce", "EDGE ACCESS INC"],
      "001AE2" => ["Cisco", "Cisco Systems"],
      "001AE3" => ["Cisco", "Cisco Systems"],
      "001AE4" => ["MedicisT", "Medicis Technologies Corporation"],
      "001AE5" => ["MvoxTech", "Mvox Technologies Inc."],
      "001AE6" => ["AtlantaA", "Atlanta Advanced Communications Holdings Limited"],
      "001AE7" => ["AztekNet", "Aztek Networks, Inc."],
      "001AE8" => ["SiemensE", "Siemens Enterprise Communications GmbH & Co. KG"],
      "001AE9" => ["Nintendo", "Nintendo Co., Ltd."],
      "001AEA" => ["RadioTer", "Radio Terminal Systems Pty Ltd"],
      "001AEB" => ["AlliedTe", "Allied Telesis K.K."],
      "001AEC" => ["KeumbeeE", "Keumbee Electronics Co.,Ltd."],
      "001AED" => ["Incotec", "INCOTEC GmbH"],
      "001AEE" => ["Shenztec", "Shenztech Ltd"],
      "001AEF" => ["Loopcomm", "Loopcomm Technology, Inc."],
      "001AF0" => ["Alcatel-", "Alcatel - IPD"],
      "001AF1" => ["Embedded", "Embedded Artists AB"],
      "001AF2" => ["Dynavisi", "Dynavisions Schweiz AG"],
      "001AF3" => ["Samyoung", "Samyoung Electronics"],
      "001AF4" => ["Handream", "Handreamnet"],
      "001AF5" => ["Pentaone", "PENTAONE. CO., LTD."],
      "001AF6" => ["Woven", "Woven Systems, Inc."],
      "001AF7" => ["Datascha", "dataschalt e+a GmbH"],
      "001AF8" => ["CopleyCo", "Copley Controls Corporation"],
      "001AF9" => ["Aeroviro", "AeroVIronment (AV Inc)"],
      "001AFA" => ["WelchAll", "Welch Allyn, Inc."],
      "001AFB" => ["Joby", "Joby Inc."],
      "001AFC" => ["Moduslin", "ModusLink Corporation"],
      "001AFD" => ["Evolis",""],
      "001AFE" => ["Sofacrea", "SOFACREAL"],
      "001AFF" => ["Wizyoung", "Wizyoung Tech."],
      "001B00" => ["NeopostT", "Neopost Technologies"],
      "001B01" => ["AppliedR", "Applied Radio Technologies"],
      "001B02" => ["Ed", "ED Co.Ltd"],
      "001B03" => ["ActionTe", "Action Technology (SZ) Co., Ltd"],
      "001B04" => ["Affinity", "Affinity International S.p.a"],
      "001B05" => ["Ymc", "YMC AG"],
      "001B06" => ["Ateliers", "Ateliers R. LAUMONIER"],
      "001B07" => ["Mendocin", "Mendocino Software"],
      "001B08" => ["DanfossD", "Danfoss Drives A/S"],
      "001B09" => ["MatrixTe", "Matrix Telecom Pvt. Ltd."],
      "001B0A" => ["Intellig", "Intelligent Distributed Controls Ltd"],
      "001B0B" => ["Phidgets", "Phidgets Inc."],
      "001B0C" => ["Cisco", "Cisco Systems"],
      "001B0D" => ["Cisco", "Cisco Systems"],
      "001B0E" => ["InotecOr", "InoTec GmbH Organisationssysteme"],
      "001B0F" => ["Petratec",""],
      "001B10" => ["Shenzhen", "ShenZhen Kang Hui Technology Co.,ltd"],
      "001B11" => ["D-Link", "D-Link Corporation"],
      "001B12" => ["Apprion",""],
      "001B13" => ["IcronTec", "Icron Technologies Corporation"],
      "001B14" => ["CarexLig", "Carex Lighting Equipment Factory"],
      "001B15" => ["Voxtel", "Voxtel, Inc."],
      "001B16" => ["Celtro", "Celtro Ltd."],
      "001B17" => ["PaloAlto", "Palo Alto Networks"],
      "001B18" => ["TsukenEl", "Tsuken Electric Ind. Co.,Ltd"],
      "001B19" => ["IeeeI&MS", "IEEE I&M Society TC9"],
      "001B1A" => ["E-TreesJ", "e-trees Japan, Inc."],
      "001B1B" => ["Siemens", "Siemens AG,"],
      "001B1C" => ["Coherent",""],
      "001B1D" => ["PhoenixI", "Phoenix International Co., Ltd"],
      "001B1E" => ["HartComm", "HART Communication Foundation"],
      "001B1F" => ["Delta-Da", "DELTA - Danish Electronics, Light & Acoustics"],
      "001B20" => ["TpineTec", "TPine Technology"],
      "001B21" => ["IntelCor", "Intel Corporate"],
      "001B22" => ["PalitMic", "Palit Microsystems ( H.K.) Ltd."],
      "001B23" => ["Simpleco", "SimpleComTools"],
      "001B24" => ["QuantaCo", "Quanta Computer Inc."],
      "001B25" => ["Nortel",""],
      "001B26" => ["Ron-Tele", "RON-Telecom ZAO"],
      "001B27" => ["MerlinCs", "Merlin CSI"],
      "001B28" => ["PolygonJ", "POLYGON, JSC"],
      "001B29" => ["Avantis", "Avantis.Co.,Ltd"],
      "001B2A" => ["Cisco", "Cisco Systems"],
      "001B2B" => ["Cisco", "Cisco Systems"],
      "001B2C" => ["AtronEle", "ATRON electronic GmbH"],
      "001B2D" => ["Med-Eng", "Med-Eng Systems Inc."],
      "001B2E" => ["SinkyoEl", "Sinkyo Electron Inc"],
      "001B2F" => ["Netgear", "NETGEAR Inc."],
      "001B30" => ["Solitech", "Solitech Inc."],
      "001B31" => ["NeuralIm", "Neural Image. Co. Ltd."],
      "001B32" => ["Qlogic", "QLogic Corporation"],
      "001B33" => ["NokiaDan", "Nokia Danmark A/S"],
      "001B34" => ["FocusSys", "Focus System Inc."],
      "001B35" => ["Chongqin", "ChongQing JINOU Science & Technology Development CO.,Ltd"],
      "001B36" => ["TsubataE", "Tsubata Engineering Co.,Ltd. (Head Office)"],
      "001B37" => ["Computec", "Computec Oy"],
      "001B38" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD."],
      "001B39" => ["Proxicas", "Proxicast"],
      "001B3A" => ["Sims", "SIMS Corp."],
      "001B3B" => ["Yi-Qing", "Yi-Qing CO., LTD"],
      "001B3C" => ["Software", "Software Technologies Group,Inc."],
      "001B3D" => ["Eurotel", "EuroTel Spa"],
      "001B3E" => ["Curtis", "Curtis, Inc."],
      "001B3F" => ["Procurve", "ProCurve Networking by HP"],
      "001B40" => ["NetworkA", "Network Automation mxc AB"],
      "001B41" => ["GeneralI", "General Infinity Co.,Ltd."],
      "001B42" => ["WiseBlue", "Wise & Blue"],
      "001B43" => ["BeijingD", "Beijing DG Telecommunications equipment Co.,Ltd"],
      "001B44" => ["Sandisk", "SanDisk Corporation"],
      "001B45" => ["AbbAsDiv", "ABB AS, Division Automation Products"],
      "001B46" => ["BlueoneT", "Blueone Technology Co.,Ltd"],
      "001B47" => ["Futarque", "Futarque A/S"],
      "001B48" => ["Shenzhen", "Shenzhen Lantech Electronics Co., Ltd."],
      "001B49" => ["RobertsR", "Roberts Radio limited"],
      "001B4A" => ["W&WCommu", "W&W Communications, Inc."],
      "001B4B" => ["Sanion", "SANION Co., Ltd."],
      "001B4C" => ["Signtech",""],
      "001B4D" => ["ArecaTec", "Areca Technology Corporation"],
      "001B4E" => ["NavmanNe", "Navman New Zealand"],
      "001B4F" => ["Avaya", "Avaya Inc."],
      "001B50" => ["NizhnyNo", "Nizhny Novgorod Factory named after M.Frunze, FSUE (NZiF)"],
      "001B51" => ["VectorTe", "Vector Technology Corp."],
      "001B52" => ["Motorola", "Motorola Mobility, Inc."],
      "001B53" => ["Cisco", "Cisco Systems"],
      "001B54" => ["Cisco", "Cisco Systems"],
      "001B55" => ["HurcoAut", "Hurco Automation Ltd."],
      "001B56" => ["TehutiNe", "Tehuti Networks Ltd."],
      "001B57" => ["Semindia", "SEMINDIA SYSTEMS PRIVATE LIMITED"],
      "001B58" => ["AceCadEn", "ACE CAD Enterprise Co., Ltd."],
      "001B59" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "001B5A" => ["ApolloIm", "Apollo Imaging Technologies, Inc."],
      "001B5B" => ["2wire", "2Wire, Inc."],
      "001B5C" => ["Azuretec", "Azuretec Co., Ltd."],
      "001B5D" => ["Vololink", "Vololink Pty Ltd"],
      "001B5E" => ["Bpl", "BPL Limited"],
      "001B5F" => ["AlienTec", "Alien Technology"],
      "001B60" => ["Navigon", "NAVIGON AG"],
      "001B61" => ["DigitalA", "Digital Acoustics, LLC"],
      "001B62" => ["JhtOptoe", "JHT Optoelectronics Co.,Ltd."],
      "001B63" => ["AppleCom", "Apple Computer Inc."],
      "001B64" => ["Isaaclan", "IsaacLandKorea Co., Ltd,"],
      "001B65" => ["ChinaGri", "China Gridcom Co., Ltd"],
      "001B66" => ["Sennheis", "Sennheiser electronic GmbH & Co. KG"],
      "001B67" => ["Ubiquisy", "Ubiquisys Ltd"],
      "001B68" => ["Modnnet", "Modnnet Co., Ltd"],
      "001B69" => ["Equaline", "Equaline Corporation"],
      "001B6A" => ["Powerwav", "Powerwave Technologies Sweden AB"],
      "001B6B" => ["SwyxSolu", "Swyx Solutions AG"],
      "001B6C" => ["LookxDig", "LookX Digital Media BV"],
      "001B6D" => ["Midtroni", "Midtronics, Inc."],
      "001B6E" => ["Anue", "Anue Systems, Inc."],
      "001B6F" => ["Teletrak", "Teletrak Ltd"],
      "001B70" => ["IriUbite", "IRI Ubiteq, INC."],
      "001B71" => ["Telular", "Telular Corp."],
      "001B72" => ["SicepSPA", "Sicep s.p.a."],
      "001B73" => ["DtlBroad", "DTL Broadcast Ltd"],
      "001B74" => ["Miralink", "MiraLink Corporation"],
      "001B75" => ["Hypermed", "Hypermedia Systems"],
      "001B76" => ["Ripcode", "Ripcode, Inc."],
      "001B77" => ["IntelCor", "Intel Corporate"],
      "001B78" => ["Hewlett-", "Hewlett-Packard Company"],
      "001B79" => ["Faiveley", "FAIVELEY TRANSPORT"],
      "001B7A" => ["Nintendo", "Nintendo Co., Ltd."],
      "001B7B" => ["Tintomet", "The Tintometer Ltd"],
      "001B7C" => ["ARCambri", "A & R Cambridge"],
      "001B7D" => ["CxrAnder", "CXR Anderson Jacobson"],
      "001B7E" => ["Beckmann", "Beckmann GmbH"],
      "001B7F" => ["TmnTechn", "TMN Technologies Telecomunicacoes Ltda"],
      "001B80" => ["Lord", "LORD Corporation"],
      "001B81" => ["DataqIns", "DATAQ Instruments, Inc."],
      "001B82" => ["TaiwanSe", "Taiwan Semiconductor Co., Ltd."],
      "001B83" => ["Finsoft", "Finsoft Ltd"],
      "001B84" => ["ScanEngi", "Scan Engineering Telecom"],
      "001B85" => ["ManDiese", "MAN Diesel SE"],
      "001B86" => ["BoschAcc", "Bosch Access Systems GmbH"],
      "001B87" => ["Deepsoun", "Deepsound Tech. Co., Ltd"],
      "001B88" => ["DivinetA", "Divinet Access Technologies Ltd"],
      "001B89" => ["EmzaVisu", "EMZA Visual Sense Ltd."],
      "001B8A" => ["2mElectr", "2M Electronic A/S"],
      "001B8B" => ["NecAcces", "NEC AccessTechnica, Ltd."],
      "001B8C" => ["JmicronT", "JMicron Technology Corp."],
      "001B8D" => ["Electron", "Electronic Computer Systems, Inc."],
      "001B8E" => ["HuluSwed", "Hulu Sweden AB"],
      "001B8F" => ["Cisco", "Cisco Systems"],
      "001B90" => ["Cisco", "Cisco Systems"],
      "001B91" => ["Efkon", "EFKON AG"],
      "001B92" => ["L-Acoust", "l-acoustics"],
      "001B93" => ["JcDecaux", "JC Decaux SA DNT"],
      "001B94" => ["TEMASPA", "T.E.M.A. S.p.A."],
      "001B95" => ["VideoSrl", "VIDEO SYSTEMS SRL"],
      "001B96" => ["GeneralS", "General Sensing"],
      "001B97" => ["ViolinTe", "Violin Technologies"],
      "001B98" => ["SamsungE", "Samsung Electronics Co., Ltd."],
      "001B99" => ["KsSystem", "KS System GmbH"],
      "001B9A" => ["ApolloFi", "Apollo Fire Detectors Ltd"],
      "001B9B" => ["Hose-Mcc", "Hose-McCann Communications"],
      "001B9C" => ["SatelSpZ", "SATEL sp. z o.o."],
      "001B9D" => ["NovusSec", "Novus Security Sp. z o.o."],
      "001B9E" => ["AskeyCom", "ASKEY  COMPUTER  CORP"],
      "001B9F" => ["Calyptec", "Calyptech Pty Ltd"],
      "001BA0" => ["Awox",""],
      "001BA1" => ["A.Mic", "A.mic AB"],
      "001BA2" => ["IdsImagi", "IDS Imaging Development Systems GmbH"],
      "001BA3" => ["FlexitGr", "Flexit Group GmbH"],
      "001BA4" => ["SAEAfiki", "S.A.E Afikim"],
      "001BA5" => ["Myungmin", "MyungMin Systems, Inc."],
      "001BA6" => ["Intotech", "intotech inc."],
      "001BA7" => ["LoricaSo", "Lorica Solutions"],
      "001BA8" => ["Ubi&Mobi", "UBI&MOBI,.Inc"],
      "001BA9" => ["BrotherI", "BROTHER INDUSTRIES, LTD."],
      "001BAA" => ["XenicsNv", "XenICs nv"],
      "001BAB" => ["Telchemy", "Telchemy, Incorporated"],
      "001BAC" => ["CurtissW", "Curtiss Wright Controls Embedded Computing"],
      "001BAD" => ["Icontrol", "iControl Incorporated"],
      "001BAE" => ["MicroCon", "Micro Control Systems, Inc"],
      "001BAF" => ["NokiaDan", "Nokia Danmark A/S"],
      "001BB0" => ["BharatEl", "BHARAT ELECTRONICS"],
      "001BB1" => ["WistronN", "Wistron Neweb Corp."],
      "001BB2" => ["Intellec", "Intellect International NV"],
      "001BB3" => ["Condalo", "Condalo GmbH"],
      "001BB4" => ["Airvod", "Airvod Limited"],
      "001BB5" => ["ZfElectr", "ZF Electronics GmbH"],
      "001BB6" => ["BirdElec", "Bird Electronic Corp."],
      "001BB7" => ["AltaHeig", "Alta Heights Technology Corp."],
      "001BB8" => ["BluewayE", "BLUEWAY ELECTRONIC CO;LTD"],
      "001BB9" => ["Elitegro", "Elitegroup Computer System Co."],
      "001BBA" => ["Nortel",""],
      "001BBB" => ["Rftech", "RFTech Co.,Ltd"],
      "001BBC" => ["SilverPe", "Silver Peak Systems, Inc."],
      "001BBD" => ["FmcKongs", "FMC Kongsberg Subsea AS"],
      "001BBE" => ["IcopDigi", "ICOP Digital"],
      "001BBF" => ["SagemCom", "SAGEM COMMUNICATION"],
      "001BC0" => ["JuniperN", "Juniper Networks"],
      "001BC1" => ["HoluxTec", "HOLUX Technology, Inc."],
      "001BC2" => ["Integrat", "Integrated Control Technology Limitied"],
      "001BC3" => ["Mobisolu", "Mobisolution Co.,Ltd"],
      "001BC4" => ["Ultratec", "Ultratec, Inc."],
      "001BC5" => ["IeeeRegi", "IEEE Registration Authority"],
      "001BC6" => ["StratoRe", "Strato Rechenzentrum AG"],
      "001BC7" => ["Starvedi", "StarVedia Technology Inc."],
      "001BC8" => ["Miura", "MIURA CO.,LTD"],
      "001BC9" => ["FsnDispl", "FSN DISPLAY INC"],
      "001BCA" => ["BeijingR", "Beijing Run Technology LTD. Company"],
      "001BCB" => ["PempekPt", "PEMPEK SYSTEMS PTY LTD"],
      "001BCC" => ["KingtekC", "KINGTEK CCTV ALLIANCE CO., LTD."],
      "001BCD" => ["Daviscom", "DAVISCOMMS (S) PTE LTD"],
      "001BCE" => ["Measurem", "Measurement Devices Ltd"],
      "001BCF" => ["Dataupia", "Dataupia Corporation"],
      "001BD0" => ["IdentecS", "IDENTEC SOLUTIONS"],
      "001BD1" => ["Sogestma", "SOGESTMATIC"],
      "001BD2" => ["Ultra-XA", "ULTRA-X ASIA PACIFIC Inc."],
      "001BD3" => ["Matsushi", "Matsushita Electric Panasonic AVC"],
      "001BD4" => ["Cisco", "Cisco Systems"],
      "001BD5" => ["Cisco", "Cisco Systems"],
      "001BD6" => ["KelvinHu", "Kelvin Hughes Ltd"],
      "001BD7" => ["Scientif", "Scientific Atlanta, A Cisco Company"],
      "001BD8" => ["Dvtel", "DVTel LTD"],
      "001BD9" => ["Edgewate", "Edgewater Computer Systems"],
      "001BDA" => ["Utstarco", "UTStarcom Inc"],
      "001BDB" => ["ValeoVec", "Valeo VECS"],
      "001BDC" => ["Vencer", "Vencer Co., Ltd."],
      "001BDD" => ["Motorola", "Motorola Mobility, Inc."],
      "001BDE" => ["Renkus-H", "Renkus-Heinz, Inc."],
      "001BDF" => ["IskraMis", "Iskra MIS"],
      "001BE0" => ["TelenotE", "TELENOT ELECTRONIC GmbH"],
      "001BE1" => ["Vialogy",""],
      "001BE2" => ["Ahnlab", "AhnLab,Inc."],
      "001BE3" => ["HealthHe", "Health Hero Network, Inc."],
      "001BE4" => ["TownetSr", "TOWNET SRL"],
      "001BE5" => ["802autom", "802automation Limited"],
      "001BE6" => ["Vr", "VR AG"],
      "001BE7" => ["PostekEl", "Postek Electronics Co., Ltd."],
      "001BE8" => ["Ultratro", "Ultratronik GmbH"],
      "001BE9" => ["Broadcom", "Broadcom Corporation"],
      "001BEA" => ["Nintendo", "Nintendo Co., Ltd."],
      "001BEB" => ["DmpElect", "DMP Electronics INC."],
      "001BEC" => ["NetioTec", "Netio Technologies Co., Ltd"],
      "001BED" => ["BrocadeC", "Brocade Communications Systems, Inc"],
      "001BEE" => ["NokiaDan", "Nokia Danmark A/S"],
      "001BEF" => ["Blossoms", "Blossoms Digital Technology Co.,Ltd."],
      "001BF0" => ["ValuePla", "Value Platforms Limited"],
      "001BF1" => ["NanjingS", "Nanjing SilverNet Software Co., Ltd."],
      "001BF2" => ["KworldCo", "KWORLD COMPUTER CO., LTD"],
      "001BF3" => ["Transrad", "TRANSRADIO SenderSysteme Berlin AG"],
      "001BF4" => ["KenwinIn", "KENWIN INDUSTRIAL(HK) LTD."],
      "001BF5" => ["TellinkS", "Tellink Sistemas de Telecomunicacion S.L."],
      "001BF6" => ["ConwiseT", "CONWISE Technology Corporation Ltd."],
      "001BF7" => ["LundIpPr", "Lund IP Products AB"],
      "001BF8" => ["Digitrax", "Digitrax Inc."],
      "001BF9" => ["Intellit", "Intellitect Water Ltd"],
      "001BFA" => ["GINMbh", "G.i.N. mbH"],
      "001BFB" => ["AlpsElec", "Alps Electric Co., Ltd"],
      "001BFC" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "001BFD" => ["Dignsys", "Dignsys Inc."],
      "001BFE" => ["Zavio", "Zavio Inc."],
      "001BFF" => ["Millenni", "Millennia Media inc."],
      "001C00" => ["EntryPoi", "Entry Point, LLC"],
      "001C01" => ["AbbOyDri", "ABB Oy Drives"],
      "001C02" => ["PanoLogi", "Pano Logic"],
      "001C03" => ["BettyTvT", "Betty TV Technology AG"],
      "001C04" => ["Airgain", "Airgain, Inc."],
      "001C05" => ["NoninMed", "Nonin Medical Inc."],
      "001C06" => ["SiemensN", "Siemens Numerical Control Ltd., Nanjing"],
      "001C07" => ["Cwlinux", "Cwlinux Limited"],
      "001C08" => ["Echo360", "Echo360, Inc."],
      "001C09" => ["SaeElect", "SAE Electronic Co.,Ltd."],
      "001C0A" => ["Shenzhen", "Shenzhen AEE Technology Co.,Ltd."],
      "001C0B" => ["Smartant", "SmartAnt Telecom"],
      "001C0C" => ["Tanita", "TANITA Corporation"],
      "001C0D" => ["G-Techno", "G-Technology, Inc."],
      "001C0E" => ["Cisco", "Cisco Systems"],
      "001C0F" => ["Cisco", "Cisco Systems"],
      "001C10" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "001C11" => ["Motorola", "Motorola Mobility, Inc."],
      "001C12" => ["Motorola", "Motorola Mobility, Inc."],
      "001C13" => ["OptsysTe", "OPTSYS TECHNOLOGY CO., LTD."],
      "001C14" => ["Vmware", "VMware, Inc"],
      "001C15" => ["Txp", "TXP Corporation"],
      "001C16" => ["Thyssenk", "ThyssenKrupp Elevator"],
      "001C17" => ["Nortel",""],
      "001C18" => ["SicertSR", "Sicert S.r.L."],
      "001C19" => ["SecunetS", "secunet Security Networks AG"],
      "001C1A" => ["ThomasIn", "Thomas Instrumentation, Inc"],
      "001C1B" => ["Hypersto", "Hyperstone GmbH"],
      "001C1C" => ["CenterCo", "Center Communication Systems GmbH"],
      "001C1D" => ["Chenzhou", "CHENZHOU GOSPELL DIGITAL TECHNOLOGY CO.,LTD"],
      "001C1E" => ["Emtrion", "emtrion GmbH"],
      "001C1F" => ["QuestRet", "Quest Retail Technology Pty Ltd"],
      "001C20" => ["ClbBenel", "CLB Benelux"],
      "001C21" => ["Nucsafe", "Nucsafe Inc."],
      "001C22" => ["AerisEle", "Aeris Elettronica s.r.l."],
      "001C23" => ["Dell", "Dell Inc"],
      "001C24" => ["FormosaW", "Formosa Wireless Systems Corp."],
      "001C25" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "001C26" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "001C27" => ["SunellEl", "Sunell Electronics Co."],
      "001C28" => ["Sphairon", "Sphairon Technologies GmbH"],
      "001C29" => ["CoreDigi", "CORE DIGITAL ELECTRONICS CO., LTD"],
      "001C2A" => ["Envisaco", "Envisacor Technologies Inc."],
      "001C2B" => ["AlertmeC", "Alertme.com Limited"],
      "001C2C" => ["Synapse",""],
      "001C2D" => ["Flexradi", "FlexRadio Systems"],
      "001C2E" => ["Procurve", "ProCurve Networking by HP"],
      "001C2F" => ["Pfister", "Pfister GmbH"],
      "001C30" => ["ModeLigh", "Mode Lighting (UK ) Ltd."],
      "001C31" => ["MobileXp", "Mobile XP Technology Co., LTD"],
      "001C32" => ["Telian", "Telian Corporation"],
      "001C33" => ["Sutron",""],
      "001C34" => ["HueyChia", "HUEY CHIAO INTERNATIONAL CO., LTD."],
      "001C35" => ["NokiaDan", "Nokia Danmark A/S"],
      "001C36" => ["InewitNv", "iNEWiT NV"],
      "001C37" => ["Callpod", "Callpod, Inc."],
      "001C38" => ["Bio-RadL", "Bio-Rad Laboratories, Inc."],
      "001C39" => ["SNetsyst", "S Netsystems Inc."],
      "001C3A" => ["ElementL", "Element Labs, Inc."],
      "001C3B" => ["AmroadTe", "AmRoad Technology Inc."],
      "001C3C" => ["SeonDesi", "Seon Design Inc."],
      "001C3D" => ["Wavestor", "WaveStorm"],
      "001C3E" => ["Eckey", "ECKey Limited"],
      "001C3F" => ["Internat", "International Police Technologies, Inc."],
      "001C40" => ["Vdg-Secu", "VDG-Security bv"],
      "001C41" => ["ScemtecT", "scemtec Transponder Technology GmbH"],
      "001C42" => ["Parallel", "Parallels, Inc."],
      "001C43" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "001C44" => ["BoschSec", "Bosch Security Systems BV"],
      "001C45" => ["ChenbroM", "Chenbro Micom Co., Ltd."],
      "001C46" => ["Qtum",""],
      "001C47" => ["Hangzhou", "Hangzhou Hollysys Automation Co., Ltd"],
      "001C48" => ["Widefi", "WiDeFi, Inc."],
      "001C49" => ["ZoltanTe", "Zoltan Technology Inc."],
      "001C4A" => ["Avm", "AVM GmbH"],
      "001C4B" => ["Gener8", "Gener8, Inc."],
      "001C4C" => ["Petrotes", "Petrotest Instruments"],
      "001C4D" => ["Zeetoo", "Zeetoo, Inc."],
      "001C4E" => ["TasaInte", "TASA International Limited"],
      "001C4F" => ["Macab", "MACAB AB"],
      "001C50" => ["TclTechn", "TCL Technoly Electronics(Huizhou)Co.,Ltd"],
      "001C51" => ["CelenoCo", "Celeno Communications"],
      "001C52" => ["Visionee", "VISIONEE SRL"],
      "001C53" => ["SynergyL", "Synergy Lighting Controls"],
      "001C54" => ["Hillston", "Hillstone Networks Inc"],
      "001C55" => ["Shenzhen", "Shenzhen Kaifa Technology Co."],
      "001C56" => ["Pado", "Pado Systems, Inc."],
      "001C57" => ["Cisco", "Cisco Systems"],
      "001C58" => ["Cisco", "Cisco Systems"],
      "001C59" => ["DevonIt", "DEVON IT"],
      "001C5A" => ["Advanced", "Advanced Relay Corporation"],
      "001C5B" => ["ChubbEle", "Chubb Electronic Security Systems Ltd"],
      "001C5C" => ["Integrat", "Integrated Medical Systems, Inc."],
      "001C5D" => ["LeicaMic", "Leica Microsystems"],
      "001C5E" => ["AstonFra", "ASTON France"],
      "001C5F" => ["WinlandE", "Winland Electronics, Inc."],
      "001C60" => ["CspFront", "CSP Frontier Technologies,Inc."],
      "001C61" => ["GalaxyTe", "Galaxy Technology (HK) Ltd."],
      "001C62" => ["LgElectr", "LG Electronics Inc"],
      "001C63" => ["Truen",""],
      "001C64" => ["Cellnet+", "Cellnet+Hunt"],
      "001C65" => ["Joescan", "JoeScan, Inc."],
      "001C66" => ["Ucamp", "UCAMP CO.,LTD"],
      "001C67" => ["PumpkinN", "Pumpkin Networks, Inc."],
      "001C68" => ["AnhuiSun", "Anhui Sun Create Electronics Co., Ltd"],
      "001C69" => ["PacketVi", "Packet Vision Ltd"],
      "001C6A" => ["WeissEng", "Weiss Engineering Ltd."],
      "001C6B" => ["Covax", "COVAX  Co. Ltd"],
      "001C6C" => ["JabilCir", "Jabil Circuit (Guangzhou) Limited"],
      "001C6D" => ["Kyohrits", "KYOHRITSU ELECTRONIC INDUSTRY CO., LTD."],
      "001C6E" => ["NewburyN", "Newbury Networks, Inc."],
      "001C6F" => ["Emfit", "Emfit Ltd"],
      "001C70" => ["Novacomm", "NOVACOMM LTDA"],
      "001C71" => ["Emergent", "Emergent Electronics"],
      "001C72" => ["MayerCie", "Mayer & Cie GmbH & Co KG"],
      "001C73" => ["AristaNe", "Arista Networks, Inc."],
      "001C74" => ["SyswanTe", "Syswan Technologies Inc."],
      "001C75" => ["Rf", "RF Systems GmbH"],
      "001C76" => ["Wandswor", "The Wandsworth Group Ltd"],
      "001C77" => ["Prodys",""],
      "001C78" => ["WyplaySa", "WYPLAY SAS"],
      "001C79" => ["Cohesive", "Cohesive Financial Technologies LLC"],
      "001C7A" => ["Perfecto", "Perfectone Netware Company Ltd"],
      "001C7B" => ["Castlene", "Castlenet Technology Inc."],
      "001C7C" => ["Perq", "PERQ SYSTEMS CORPORATION"],
      "001C7D" => ["Excelpoi", "Excelpoint Manufacturing Pte Ltd"],
      "001C7E" => ["Toshiba",""],
      "001C7F" => ["CheckPoi", "Check Point Software Technologies"],
      "001C80" => ["NewBusin", "New Business Division/Rhea-Information CO., LTD."],
      "001C81" => ["NextgenV", "NextGen Venturi LTD"],
      "001C82" => ["GenewTec", "Genew Technologies"],
      "001C83" => ["NewLevel", "New Level Telecom Co., Ltd."],
      "001C84" => ["StlSolut", "STL Solution Co.,Ltd."],
      "001C85" => ["Eunicorn",""],
      "001C86" => ["Cranite", "Cranite Systems, Inc."],
      "001C87" => ["Uriver", "Uriver Inc."],
      "001C88" => ["Transyst", "TRANSYSTEM INC."],
      "001C89" => ["ForceCom", "Force Communications, Inc."],
      "001C8A" => ["Cirrasca", "Cirrascale Corporation"],
      "001C8B" => ["MjInnova", "MJ Innovations Ltd."],
      "001C8C" => ["DialTech", "DIAL TECHNOLOGY LTD."],
      "001C8D" => ["MesaImag", "Mesa Imaging"],
      "001C8E" => ["Alcatel-", "Alcatel-Lucent IPD"],
      "001C8F" => ["Advanced", "Advanced Electronic Design, Inc."],
      "001C90" => ["Empacket", "Empacket Corporation"],
      "001C91" => ["Gefen", "Gefen Inc."],
      "001C92" => ["Tervela",""],
      "001C93" => ["Exadigm", "ExaDigm Inc"],
      "001C94" => ["Li-CorBi", "LI-COR Biosciences"],
      "001C95" => ["Opticomm", "Opticomm Corporation"],
      "001C96" => ["Linkwise", "Linkwise Technology Pte Ltd"],
      "001C97" => ["EnzytekT", "Enzytek Technology Inc.,"],
      "001C98" => ["LuckyTec", "LUCKY TECHNOLOGY (HK) COMPANY LIMITED"],
      "001C99" => ["ShunraSo", "Shunra Software Ltd."],
      "001C9A" => ["NokiaDan", "Nokia Danmark A/S"],
      "001C9B" => ["FeigElec", "FEIG ELECTRONIC GmbH"],
      "001C9C" => ["Nortel",""],
      "001C9D" => ["Liecthi", "Liecthi AG"],
      "001C9E" => ["Dualtech", "Dualtech IT AB"],
      "001C9F" => ["Razorstr", "Razorstream, LLC"],
      "001CA0" => ["Producti", "Production Resource Group, LLC"],
      "001CA1" => ["AkamaiTe", "AKAMAI TECHNOLOGIES, INC."],
      "001CA2" => ["AdbBroad", "ADB Broadband Italia"],
      "001CA3" => ["Terra",""],
      "001CA4" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "001CA5" => ["Zygo", "Zygo Corporation"],
      "001CA6" => ["Win4net",""],
      "001CA7" => ["Internat", "International Quartz Limited"],
      "001CA8" => ["AirtiesW", "AirTies Wireless Networks"],
      "001CA9" => ["Audiomat", "Audiomatica Srl"],
      "001CAA" => ["BellonPt", "Bellon Pty Ltd"],
      "001CAB" => ["MeyerSou", "Meyer Sound Laboratories, Inc."],
      "001CAC" => ["QniqTech", "Qniq Technology Corp."],
      "001CAD" => ["WuhanTel", "Wuhan Telecommunication Devices Co.,Ltd"],
      "001CAE" => ["Wichorus", "WiChorus, Inc."],
      "001CAF" => ["PlatoNet", "Plato Networks Inc."],
      "001CB0" => ["Cisco", "Cisco Systems"],
      "001CB1" => ["Cisco", "Cisco Systems"],
      "001CB2" => ["Bpt", "BPT SPA"],
      "001CB3" => ["Apple", "APPLE, INC"],
      "001CB4" => ["IridiumS", "Iridium Satellite LLC"],
      "001CB5" => ["NeihuaNe", "Neihua Network Technology Co.,LTD.(NHN)"],
      "001CB6" => ["DuzonCnt", "Duzon CNT Co., Ltd."],
      "001CB7" => ["UscDigia", "USC DigiArk Corporation"],
      "001CB8" => ["Cbc", "CBC Co., Ltd"],
      "001CB9" => ["KwangSun", "KWANG SUNG ELECTRONICS CO., LTD."],
      "001CBA" => ["Verscien", "VerScient, Inc."],
      "001CBB" => ["Musician", "MusicianLink"],
      "001CBC" => ["Castgrab", "CastGrabber, LLC"],
      "001CBD" => ["EzzeMobi", "Ezze Mobile Tech., Inc."],
      "001CBE" => ["Nintendo", "Nintendo Co., Ltd."],
      "001CBF" => ["IntelCor", "Intel Corporate"],
      "001CC0" => ["IntelCor", "Intel Corporate"],
      "001CC1" => ["Motorola", "Motorola Mobility, Inc."],
      "001CC2" => ["PartIiRe", "Part II Research, Inc."],
      "001CC3" => ["Pace", "Pace plc"],
      "001CC4" => ["Hewlett-", "Hewlett-Packard Company"],
      "001CC5" => ["3com", "3COM LTD"],
      "001CC6" => ["Prostor", "ProStor Systems"],
      "001CC7" => ["Rembrand", "Rembrandt Technologies, LLC d/b/a REMSTREAM"],
      "001CC8" => ["Industro", "INDUSTRONIC Industrie-Electronic GmbH & Co. KG"],
      "001CC9" => ["KaiseEle", "Kaise Electronic Technology Co., Ltd."],
      "001CCA" => ["Shanghai", "Shanghai Gaozhi Science & Technology Development Co."],
      "001CCB" => ["ForthPub", "Forth Corporation Public Company Limited"],
      "001CCC" => ["Research", "Research In Motion Limited"],
      "001CCD" => ["Alektron", "Alektrona Corporation"],
      "001CCE" => ["ByTechde", "By Techdesign"],
      "001CCF" => ["Limetek",""],
      "001CD0" => ["Circleon", "Circleone Co.,Ltd."],
      "001CD1" => ["WavesAud", "Waves Audio LTD"],
      "001CD2" => ["KingCham", "King Champion (Hong Kong) Limited"],
      "001CD3" => ["ZpEngine", "ZP Engineering SEL"],
      "001CD4" => ["NokiaDan", "Nokia Danmark A/S"],
      "001CD5" => ["Zeevee", "ZeeVee, Inc."],
      "001CD6" => ["NokiaDan", "Nokia Danmark A/S"],
      "001CD7" => ["Harman/B", "Harman/Becker Automotive Systems GmbH"],
      "001CD8" => ["BlueantW", "BlueAnt Wireless"],
      "001CD9" => ["Globalto", "GlobalTop Technology Inc."],
      "001CDA" => ["ExeginTe", "Exegin Technologies Limited"],
      "001CDB" => ["Carpoint", "CARPOINT CO.,LTD"],
      "001CDC" => ["CustomCo", "Custom Computer Services, Inc."],
      "001CDD" => ["CowbellE", "COWBELL ENGINEERING CO., LTD."],
      "001CDE" => ["Interact", "Interactive Multimedia eXchange Inc."],
      "001CDF" => ["BelkinIn", "Belkin International Inc."],
      "001CE0" => ["DasanTps", "DASAN TPS"],
      "001CE1" => ["IndraSis", "INDRA SISTEMAS, S.A."],
      "001CE2" => ["AtteroTe", "Attero Tech, LLC."],
      "001CE3" => ["Optimedi", "Optimedical Systems"],
      "001CE4" => ["ElesyJsc", "EleSy JSC"],
      "001CE5" => ["MbsElect", "MBS Electronic Systems GmbH"],
      "001CE6" => ["Innes",""],
      "001CE7" => ["RoconRes", "Rocon PLC Research Centre"],
      "001CE8" => ["Cummins", "Cummins Inc"],
      "001CE9" => ["GalaxyTe", "Galaxy Technology Limited"],
      "001CEA" => ["Scientif", "Scientific-Atlanta, Inc"],
      "001CEB" => ["Nortel",""],
      "001CEC" => ["Mobileso", "Mobilesoft (Aust.) Pty Ltd"],
      "001CED" => ["Environn", "ENVIRONNEMENT SA"],
      "001CEE" => ["Sharp", "SHARP Corporation"],
      "001CEF" => ["PrimaxEl", "Primax Electronics LTD"],
      "001CF0" => ["D-Link", "D-Link Corporation"],
      "001CF1" => ["SupoxTec", "SUPoX Technology Co. , LTD."],
      "001CF2" => ["TenlonTe", "Tenlon Technology Co.,Ltd."],
      "001CF3" => ["EvsBroad", "EVS BROADCAST EQUIPMENT"],
      "001CF4" => ["MediaTec", "Media Technology Systems Inc"],
      "001CF5" => ["Wiseblue", "Wiseblue Technology Limited"],
      "001CF6" => ["Cisco", "Cisco Systems"],
      "001CF7" => ["Audiosci", "AudioScience"],
      "001CF8" => ["ParadeTe", "Parade Technologies, Ltd."],
      "001CF9" => ["Cisco", "Cisco Systems"],
      "001CFA" => ["AlarmCom", "Alarm.com"],
      "001CFB" => ["Motorola", "Motorola Mobility, Inc."],
      "001CFC" => ["SuminetC", "Suminet Communication Technologies (Shanghai) Co., Ltd."],
      "001CFD" => ["Universa", "Universal Electronics"],
      "001CFE" => ["Quartics", "Quartics Inc"],
      "001CFF" => ["NaperaNe", "Napera Networks Inc"],
      "001D00" => ["BrivoLlc", "Brivo Systems, LLC"],
      "001D01" => ["NeptuneD", "Neptune Digital"],
      "001D02" => ["Cybertec", "Cybertech Telecom Development"],
      "001D03" => ["DesignSo", "Design Solutions Inc."],
      "001D04" => ["ZipitWir", "Zipit Wireless, Inc."],
      "001D05" => ["Ilight",""],
      "001D06" => ["HmElectr", "HM Electronics, Inc."],
      "001D07" => ["Shenzhen", "Shenzhen Sang Fei Consumer Communications Co.,Ltd"],
      "001D08" => ["JiangsuY", "JIANGSU YINHE ELECTRONICS CO., LTD"],
      "001D09" => ["Dell", "Dell Inc"],
      "001D0A" => ["DavisIns", "Davis Instruments, Inc."],
      "001D0B" => ["PowerSta", "Power Standards Lab"],
      "001D0C" => ["Mobileco", "MobileCompia"],
      "001D0D" => ["SonyComp", "Sony Computer Entertainment inc."],
      "001D0E" => ["AgaphaTe", "Agapha Technology co., Ltd."],
      "001D0F" => ["Tp-LinkT", "TP-LINK Technologies Co., Ltd."],
      "001D10" => ["Lighthau", "LightHaus Logic, Inc."],
      "001D11" => ["Analogue", "Analogue & Micro Ltd"],
      "001D12" => ["Rohm", "ROHM CO., LTD."],
      "001D13" => ["Nextgtv",""],
      "001D14" => ["Speradto", "SPERADTONE INFORMATION TECHNOLOGY LIMITED"],
      "001D15" => ["Shenzhen", "Shenzhen Dolphin Electronic Co., Ltd"],
      "001D16" => ["Efixo",""],
      "001D17" => ["DigitalS", "Digital Sky Corporation"],
      "001D18" => ["PowerInn", "Power Innovation GmbH"],
      "001D19" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "001D1A" => ["Ovislink", "OvisLink S.A."],
      "001D1B" => ["SangeanE", "Sangean Electronics Inc."],
      "001D1C" => ["GennetSA", "Gennet s.a."],
      "001D1D" => ["Inter-M", "Inter-M Corporation"],
      "001D1E" => ["KyushuTe", "KYUSHU TEN CO.,LTD"],
      "001D1F" => ["SiauliuT", "Siauliu Tauro Televizoriai, JSC"],
      "001D20" => ["Comtrend", "COMTREND CO."],
      "001D21" => ["AlcadSl", "Alcad SL"],
      "001D22" => ["FossAnal", "Foss Analytical A/S"],
      "001D23" => ["Sensus", "SENSUS"],
      "001D24" => ["AclaraPo", "Aclara Power-Line Systems Inc."],
      "001D25" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "001D26" => ["Rockridg", "Rockridgesound Technology Co."],
      "001D27" => ["Nac-Inte", "NAC-INTERCOM"],
      "001D28" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "001D29" => ["Doro", "Doro AB"],
      "001D2A" => ["TidewayE", "Tideway Electronic LTD"],
      "001D2B" => ["WuhanPon", "Wuhan Pont Technology CO. , LTD"],
      "001D2C" => ["Wavetren", "Wavetrend Technologies (Pty) Limited"],
      "001D2D" => ["Pylone", "Pylone, Inc."],
      "001D2E" => ["RuckusWi", "Ruckus Wireless"],
      "001D2F" => ["Quantumv", "QuantumVision Corporation"],
      "001D30" => ["YxWirele", "YX Wireless S.A."],
      "001D31" => ["HighproI", "HIGHPRO INTERNATIONAL R&D CO,.LTD."],
      "001D32" => ["LongkayC", "Longkay Communication & Technology (Shanghai) Co. Ltd"],
      "001D33" => ["Maverick", "Maverick Systems Inc."],
      "001D34" => ["SyrisTec", "SYRIS Technology Corp"],
      "001D35" => ["Viconics", "Viconics Electronics Inc."],
      "001D36" => ["Electron", "ELECTRONICS CORPORATION OF INDIA LIMITED"],
      "001D37" => ["Thales-P", "Thales-Panda Transportation System"],
      "001D38" => ["SeagateT", "Seagate Technology"],
      "001D39" => ["Moohadig", "MOOHADIGITAL CO., LTD"],
      "001D3A" => ["MhAcoust", "mh acoustics LLC"],
      "001D3B" => ["NokiaDan", "Nokia Danmark A/S"],
      "001D3C" => ["Muscle", "Muscle Corporation"],
      "001D3D" => ["Avidyne", "Avidyne Corporation"],
      "001D3E" => ["SakaTech", "SAKA TECHNO SCIENCE CO.,LTD"],
      "001D3F" => ["MitronPt", "Mitron Pty Ltd"],
      "001D40" => ["LivingIn", "Living Independently Group, Inc."],
      "001D41" => ["HardyIns", "Hardy Instruments"],
      "001D42" => ["Nortel",""],
      "001D43" => ["Shenzhen", "Shenzhen G-link Digital Technology Co., Ltd."],
      "001D44" => ["Krohne",""],
      "001D45" => ["Cisco", "Cisco Systems"],
      "001D46" => ["Cisco", "Cisco Systems"],
      "001D47" => ["Covote", "Covote GmbH & Co KG"],
      "001D48" => ["Sensor-T", "Sensor-Technik Wiedemann GmbH"],
      "001D49" => ["Innovati", "Innovation Wireless Inc."],
      "001D4A" => ["Carestre", "Carestream Health, Inc."],
      "001D4B" => ["GridConn", "Grid Connect Inc."],
      "001D4C" => ["Alcatel-", "Alcatel-Lucent"],
      "001D4D" => ["Adaptive", "Adaptive Recognition Hungary, Inc"],
      "001D4E" => ["TcmMobil", "TCM Mobile LLC"],
      "001D4F" => ["AppleCom", "Apple Computer Inc."],
      "001D50" => ["Spinetix", "SPINETIX SA"],
      "001D51" => ["BabcockW", "Babcock & Wilcox Power Generation Group, Inc"],
      "001D52" => ["DefzoneB", "Defzone B.V."],
      "001D53" => ["S&OElect", "S&O Electronics (Malaysia) Sdn. Bhd."],
      "001D54" => ["SunnicTe", "Sunnic Technology & Merchandise INC."],
      "001D55" => ["Zantaz", "ZANTAZ, Inc"],
      "001D56" => ["KramerEl", "Kramer Electronics Ltd."],
      "001D57" => ["CaetecMe", "CAETEC Messtechnik"],
      "001D58" => ["Cq", "CQ Inc"],
      "001D59" => ["MitraEne", "Mitra Energy & Infrastructure"],
      "001D5A" => ["2wire", "2Wire Inc."],
      "001D5B" => ["TecvanIn", "Tecvan Informatica Ltda"],
      "001D5C" => ["TomCommu", "Tom Communication Industrial Co.,Ltd."],
      "001D5D" => ["ControlD", "Control Dynamics Pty. Ltd."],
      "001D5E" => ["ComingMe", "COMING MEDIA CORP."],
      "001D5F" => ["Overspee", "OverSpeed SARL"],
      "001D60" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "001D61" => ["Bij", "BIJ Corporation"],
      "001D62" => ["InphaseT", "InPhase Technologies"],
      "001D63" => ["MieleCie", "Miele & Cie. KG"],
      "001D64" => ["AdamComm", "Adam Communications Systems Int Ltd"],
      "001D65" => ["Microwav", "Microwave Radio Communications"],
      "001D66" => ["HyundaiT", "Hyundai Telecom"],
      "001D67" => ["Amec",""],
      "001D68" => ["ThomsonT", "Thomson Telecom Belgium"],
      "001D69" => ["Knorr-Br", "Knorr-Bremse AG"],
      "001D6A" => ["AlphaNet", "Alpha Networks Inc."],
      "001D6B" => ["Motorola", "Motorola (formerly Netopia, Inc"],
      "001D6C" => ["Clariphy", "ClariPhy Communications, Inc."],
      "001D6D" => ["Confidan", "Confidant International LLC"],
      "001D6E" => ["NokiaDan", "Nokia Danmark A/S"],
      "001D6F" => ["Chainzon", "Chainzone Technology Co., Ltd"],
      "001D70" => ["Cisco", "Cisco Systems"],
      "001D71" => ["Cisco", "Cisco Systems"],
      "001D72" => ["Wistron", "Wistron Corporation"],
      "001D73" => ["Buffalo", "Buffalo Inc."],
      "001D74" => ["TianjinC", "Tianjin China-Silicon Microelectronics Co., Ltd."],
      "001D75" => ["Radiosca", "Radioscape PLC"],
      "001D76" => ["Eyeheigh", "Eyeheight Ltd."],
      "001D77" => ["Nsgate",""],
      "001D78" => ["InvengoI", "Invengo Information Technology Co.,Ltd"],
      "001D79" => ["Signamax", "SIGNAMAX LLC"],
      "001D7A" => ["Wideband", "Wideband Semiconductor, Inc."],
      "001D7B" => ["IceEnerg", "Ice Energy, Inc."],
      "001D7C" => ["AbeElett", "ABE Elettronica S.p.A."],
      "001D7D" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "001D7E" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "001D7F" => ["TekronIn", "Tekron International Ltd"],
      "001D80" => ["BeijingH", "Beijing Huahuan Eletronics Co.,Ltd"],
      "001D81" => ["Guangzho", "GUANGZHOU GATEWAY ELECTRONICS CO., LTD"],
      "001D82" => ["GnGnNetc", "GN A/S (GN Netcom A/S)"],
      "001D83" => ["Emitech", "Emitech Corporation"],
      "001D84" => ["Gateway", "Gateway, Inc."],
      "001D85" => ["CallDire", "Call Direct Cellular Solutions"],
      "001D86" => ["ShinwaIn", "Shinwa Industries(China) Ltd."],
      "001D87" => ["VigtechL", "VigTech Labs Sdn Bhd"],
      "001D88" => ["Clearwir", "Clearwire"],
      "001D89" => ["Vaultsto", "VaultStor Corporation"],
      "001D8A" => ["Techtrex", "TechTrex Inc"],
      "001D8B" => ["AdbBroad", "ADB Broadband Italia"],
      "001D8C" => ["LaCrosse", "La Crosse Technology LTD"],
      "001D8D" => ["Raytek", "Raytek GmbH"],
      "001D8E" => ["Alereon", "Alereon, Inc."],
      "001D8F" => ["Purewave", "PureWave Networks"],
      "001D90" => ["EmcoFlow", "EMCO Flow Systems"],
      "001D91" => ["Digitize", "Digitize, Inc"],
      "001D92" => ["Micro-St", "MICRO-STAR INT\'L CO.,LTD."],
      "001D93" => ["Modacom",""],
      "001D94" => ["ClimaxTe", "Climax Technology Co., Ltd"],
      "001D95" => ["Flash", "Flash, Inc."],
      "001D96" => ["Watchgua", "WatchGuard Video"],
      "001D97" => ["AlertusT", "Alertus Technologies LLC"],
      "001D98" => ["NokiaDan", "Nokia Danmark A/S"],
      "001D99" => ["CyanOpti", "Cyan Optic, Inc."],
      "001D9A" => ["GodexInt", "GODEX INTERNATIONAL CO., LTD"],
      "001D9B" => ["HokuyoAu", "Hokuyo Automatic Co., Ltd."],
      "001D9C" => ["Rockwell", "Rockwell Automation"],
      "001D9D" => ["ArtjoyIn", "ARTJOY INTERNATIONAL LIMITED"],
      "001D9E" => ["AxionTec", "AXION TECHNOLOGIES"],
      "001D9F" => ["MattRPTr", "MATT   R.P.Traczynscy Sp.J."],
      "001DA0" => ["HengYuEl", "Heng Yu Electronic Manufacturing Company Limited"],
      "001DA1" => ["Cisco", "Cisco Systems"],
      "001DA2" => ["Cisco", "Cisco Systems"],
      "001DA3" => ["Sabioso",""],
      "001DA4" => ["Hangzhou", "Hangzhou System Technology CO., LTD"],
      "001DA5" => ["WbElectr", "WB Electronics"],
      "001DA6" => ["MediaNum", "Media Numerics Limited"],
      "001DA7" => ["Seamless", "Seamless Internet"],
      "001DA8" => ["Takahata", "Takahata Electronics Co.,Ltd"],
      "001DA9" => ["CastlesT", "Castles Technology, Co., LTD"],
      "001DAA" => ["Draytek", "DrayTek Corp."],
      "001DAB" => ["Swissqua", "SwissQual License AG"],
      "001DAC" => ["GigamonL", "Gigamon Systems LLC"],
      "001DAD" => ["Sinotech", "Sinotech Engineering Consultants, Inc.  Geotechnical Enginee"],
      "001DAE" => ["ChangTse", "CHANG TSENG TECHNOLOGY CO., LTD"],
      "001DAF" => ["Nortel",""],
      "001DB0" => ["FujianHe", "FuJian HengTong Information Technology Co.,Ltd"],
      "001DB1" => ["Crescend", "Crescendo Networks"],
      "001DB2" => ["Hokkaido", "HOKKAIDO ELECTRIC ENGINEERING CO.,LTD."],
      "001DB3" => ["Procurve", "ProCurve Networking by HP"],
      "001DB4" => ["KumhoEng", "KUMHO ENG CO.,LTD"],
      "001DB5" => ["JuniperN", "Juniper networks"],
      "001DB6" => ["Bestcomm", "BestComm Networks, Inc."],
      "001DB7" => ["TendrilN", "Tendril Networks, Inc."],
      "001DB8" => ["Intoto", "Intoto Inc."],
      "001DB9" => ["Wellspri", "Wellspring Wireless"],
      "001DBA" => ["Sony", "Sony Corporation"],
      "001DBB" => ["DynamicS", "Dynamic System Electronics Corp."],
      "001DBC" => ["Nintendo", "Nintendo Co., Ltd."],
      "001DBD" => ["Versamed", "Versamed Inc."],
      "001DBE" => ["Motorola", "Motorola Mobility, Inc."],
      "001DBF" => ["Radiient", "Radiient Technologies, Inc."],
      "001DC0" => ["EnphaseE", "Enphase Energy"],
      "001DC1" => ["Audinate", "Audinate Pty L"],
      "001DC2" => ["XortecOy", "XORTEC OY"],
      "001DC3" => ["RikorTv", "RIKOR TV, Ltd"],
      "001DC4" => ["Aioi", "AIOI Systems Co., Ltd."],
      "001DC5" => ["BeijingJ", "Beijing Jiaxun Feihong Electricial Co., Ltd."],
      "001DC6" => ["Snr", "SNR Inc."],
      "001DC7" => ["L-3Commu", "L-3 Communications Geneva Aerospace"],
      "001DC8" => ["Scadamet", "ScadaMetrcs, LLC."],
      "001DC9" => ["Gainspan", "GainSpan Corp."],
      "001DCA" => ["PavElect", "PAV Electronics Limited"],
      "001DCB" => ["ExensDev", "Exens Development Oy"],
      "001DCC" => ["HetraSec", "Hetra Secure Solutions"],
      "001DCD" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DCE" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DCF" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DD0" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DD1" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DD2" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DD3" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DD4" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DD5" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DD6" => ["ArrisGro", "ARRIS Group, Inc."],
      "001DD7" => ["Algolith",""],
      "001DD8" => ["Microsof", "Microsoft Corporation"],
      "001DD9" => ["HonHaiPr", "Hon Hai Precision Ind.Co.,Ltd."],
      "001DDA" => ["Mikroele", "Mikroelektronika spol. s r. o."],
      "001DDB" => ["C-Bel", "C-BEL Corporation"],
      "001DDC" => ["Hangzhou", "HangZhou DeChangLong Tech&Info Co.,Ltd"],
      "001DDD" => ["DatHK", "DAT H.K. LIMITED"],
      "001DDE" => ["Zhejiang", "Zhejiang Broadcast&Television Technology Co.,Ltd."],
      "001DDF" => ["SunitecE", "Sunitec Enterprise Co., Ltd."],
      "001DE0" => ["IntelCor", "Intel Corporate"],
      "001DE1" => ["IntelCor", "Intel Corporate"],
      "001DE2" => ["Radionor", "Radionor Communications"],
      "001DE3" => ["Intuicom",""],
      "001DE4" => ["Visionee", "Visioneered Image Systems"],
      "001DE5" => ["Cisco", "Cisco Systems"],
      "001DE6" => ["Cisco", "Cisco Systems"],
      "001DE7" => ["MarineSo", "Marine Sonic Technology, Ltd."],
      "001DE8" => ["NikkoDen", "Nikko Denki Tsushin Company(NDTC)"],
      "001DE9" => ["NokiaDan", "Nokia Danmark A/S"],
      "001DEA" => ["Commtest", "Commtest Instruments Ltd"],
      "001DEB" => ["DinecInt", "DINEC International"],
      "001DEC" => ["Marusys",""],
      "001DED" => ["GridNet", "Grid Net, Inc."],
      "001DEE" => ["Nextvisi", "NEXTVISION SISTEMAS DIGITAIS DE TELEVISAFO LTDA."],
      "001DEF" => ["Trimm", "TRIMM, INC."],
      "001DF0" => ["Vidient", "Vidient Systems, Inc."],
      "001DF1" => ["Intego", "Intego Systems, Inc."],
      "001DF2" => ["Netflix", "Netflix, Inc."],
      "001DF3" => ["SbsScien", "SBS Science & Technology Co., Ltd"],
      "001DF4" => ["Magellan", "Magellan Technology Pty Limited"],
      "001DF5" => ["Sunshine", "Sunshine Co,LTD"],
      "001DF6" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "001DF7" => ["RStahlSc", "R. STAHL Schaltgerate GmbH"],
      "001DF8" => ["WebproVi", "Webpro Vision Technology Corporation"],
      "001DF9" => ["Cybiotro", "Cybiotronics (Far East) Limited"],
      "001DFA" => ["FujianLa", "Fujian LANDI Commercial Equipment Co.,Ltd"],
      "001DFB" => ["Netcleus", "NETCLEUS Systems Corporation"],
      "001DFC" => ["Ksic",""],
      "001DFD" => ["NokiaDan", "Nokia Danmark A/S"],
      "001DFE" => ["Palm", "Palm, Inc"],
      "001DFF" => ["NetworkC", "Network Critical Solutions Ltd"],
      "001E00" => ["ShantouI", "Shantou Institute of Ultrasonic Instruments"],
      "001E01" => ["RenesasT", "Renesas Technology Sales Co., Ltd."],
      "001E02" => ["SougouKe", "Sougou Keikaku Kougyou Co.,Ltd."],
      "001E03" => ["Licomm", "LiComm Co., Ltd."],
      "001E04" => ["HansonRe", "Hanson Research Corporation"],
      "001E05" => ["XseedTec", "Xseed Technologies & Computing"],
      "001E06" => ["Wibrain",""],
      "001E07" => ["WinyTech", "Winy Technology Co., Ltd."],
      "001E08" => ["CentecNe", "Centec Networks Inc"],
      "001E09" => ["Zefatek", "ZEFATEK Co.,LTD"],
      "001E0A" => ["SybaTech", "Syba Tech Limited"],
      "001E0B" => ["Hewlett-", "Hewlett-Packard Company"],
      "001E0C" => ["Sherwood", "Sherwood Information Partners, Inc."],
      "001E0D" => ["Micran", "Micran Ltd."],
      "001E0E" => ["MaxiView", "MAXI VIEW HOLDINGS LIMITED"],
      "001E0F" => ["BriotInt", "Briot International"],
      "001E10" => ["Shenzhen", "ShenZhen Huawei Communication Technologies Co.,Ltd."],
      "001E11" => ["EleluxIn", "ELELUX INTERNATIONAL LTD"],
      "001E12" => ["Ecolab",""],
      "001E13" => ["Cisco", "Cisco Systems"],
      "001E14" => ["Cisco", "Cisco Systems"],
      "001E15" => ["BeechHil", "Beech Hill Electronics"],
      "001E16" => ["Keytroni", "Keytronix"],
      "001E17" => ["StnBv", "STN BV"],
      "001E18" => ["RadioAct", "Radio Activity srl"],
      "001E19" => ["Gtri",""],
      "001E1A" => ["BestSour", "Best Source Taiwan Inc."],
      "001E1B" => ["DigitalS", "Digital Stream Technology, Inc."],
      "001E1C" => ["SwsAustr", "SWS Australia Pty Limited"],
      "001E1D" => ["EastCoas", "East Coast Datacom, Inc."],
      "001E1E" => ["Honeywel", "Honeywell Life Safety"],
      "001E1F" => ["Nortel",""],
      "001E20" => ["Intertai", "Intertain Inc."],
      "001E21" => ["Qisda", "Qisda Co."],
      "001E22" => ["ArvooIma", "ARVOO Imaging Products BV"],
      "001E23" => ["Electron", "Electronic Educational Devices, Inc"],
      "001E24" => ["Zhejiang", "Zhejiang Bell Technology Co.,ltd"],
      "001E25" => ["IntekDig", "Intek Digital Inc"],
      "001E26" => ["Digifrie", "Digifriends Co. Ltd"],
      "001E27" => ["SbnTech", "SBN TECH Co.,Ltd."],
      "001E28" => ["Lumexis", "Lumexis Corporation"],
      "001E29" => ["Hyperthe", "Hypertherm Inc"],
      "001E2A" => ["Netgear", "Netgear Inc."],
      "001E2B" => ["RadioDes", "Radio Systems Design, Inc."],
      "001E2C" => ["Cyverse", "CyVerse Corporation"],
      "001E2D" => ["Stim",""],
      "001E2E" => ["SirtiSPA", "SIRTI S.p.A."],
      "001E2F" => ["DimotoPt", "DiMoto Pty Ltd"],
      "001E30" => ["Shireen", "Shireen Inc"],
      "001E31" => ["Infomark", "INFOMARK CO.,LTD."],
      "001E32" => ["Zensys",""],
      "001E33" => ["Inventec", "Inventec Corporation"],
      "001E34" => ["Cryptome", "CryptoMetrics"],
      "001E35" => ["Nintendo", "Nintendo Co., Ltd."],
      "001E36" => ["Ipte",""],
      "001E37" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "001E38" => ["Bluecard", "Bluecard Software Technology Co., Ltd."],
      "001E39" => ["ComsysCo", "Comsys Communication Ltd."],
      "001E3A" => ["NokiaDan", "Nokia Danmark A/S"],
      "001E3B" => ["NokiaDan", "Nokia Danmark A/S"],
      "001E3C" => ["LyngboxM", "Lyngbox Media AB"],
      "001E3D" => ["AlpsElec", "Alps Electric Co., Ltd"],
      "001E3E" => ["Kmw", "KMW Inc."],
      "001E3F" => ["Trellisw", "TrellisWare Technologies, Inc."],
      "001E40" => ["Shanghai", "Shanghai DareGlobal Technologies  Co.,Ltd."],
      "001E41" => ["Microwav", "Microwave Communication & Component, Inc."],
      "001E42" => ["Teltonik", "Teltonika"],
      "001E43" => ["AisinAw", "AISIN AW CO.,LTD."],
      "001E44" => ["Santec",""],
      "001E45" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "001E46" => ["Motorola", "Motorola Mobility, Inc."],
      "001E47" => ["PtHariff", "PT. Hariff Daya Tunggal Engineering"],
      "001E48" => ["Wi-Links",""],
      "001E49" => ["Cisco", "Cisco Systems"],
      "001E4A" => ["Cisco", "Cisco Systems"],
      "001E4B" => ["CityThea", "City Theatrical"],
      "001E4C" => ["HonHaiPr", "Hon Hai Precision Ind.Co., Ltd."],
      "001E4D" => ["WelkinSc", "Welkin Sciences, LLC"],
      "001E4E" => ["DakoEdv-", "DAKO EDV-Ingenieur- und Systemhaus GmbH"],
      "001E4F" => ["Dell", "Dell Inc."],
      "001E50" => ["Battisto", "BATTISTONI RESEARCH"],
      "001E51" => ["Converte", "Converter Industry Srl"],
      "001E52" => ["AppleCom", "Apple Computer Inc"],
      "001E53" => ["FurtherT", "Further Tech Co., LTD"],
      "001E54" => ["ToyoElec", "TOYO ELECTRIC Corporation"],
      "001E55" => ["Cowon", "COWON SYSTEMS,Inc."],
      "001E56" => ["BallyWul", "Bally Wulff Entertainment GmbH"],
      "001E57" => ["AlcomaSp", "ALCOMA, spol. s r.o."],
      "001E58" => ["D-Link", "D-Link Corporation"],
      "001E59" => ["SiliconT", "Silicon Turnkey Express, LLC"],
      "001E5A" => ["Motorola", "Motorola Mobility, Inc."],
      "001E5B" => ["Unitron", "Unitron Company, Inc."],
      "001E5C" => ["RbGenera", "RB GeneralEkonomik"],
      "001E5D" => ["HolosysD", "Holosys d.o.o."],
      "001E5E" => ["Computim", "COmputime Ltd."],
      "001E5F" => ["Kwikbyte", "KwikByte, LLC"],
      "001E60" => ["DigitalL", "Digital Lighting Systems, Inc"],
      "001E61" => ["Itec", "ITEC GmbH"],
      "001E62" => ["Siemon",""],
      "001E63" => ["Vibro-Me", "Vibro-Meter SA"],
      "001E64" => ["IntelCor", "Intel Corporate"],
      "001E65" => ["IntelCor", "Intel Corporate"],
      "001E66" => ["ResolEle", "RESOL Elektronische Regelungen GmbH"],
      "001E67" => ["IntelCor", "Intel Corporate"],
      "001E68" => ["QuantaCo", "Quanta Computer"],
      "001E69" => ["Thomson", "Thomson Inc."],
      "001E6A" => ["BeijingB", "Beijing Bluexon Technology Co.,Ltd"],
      "001E6B" => ["Scientif", "Scientific Atlanta, A Cisco Company"],
      "001E6C" => ["CarbonMo", "Carbon Mountain LLC"],
      "001E6D" => ["ItR&DCen", "IT R&D Center"],
      "001E6E" => ["Shenzhen", "Shenzhen First Mile Communications Ltd"],
      "001E6F" => ["Magna-Po", "Magna-Power Electronics, Inc."],
      "001E70" => ["CobhamDe", "Cobham Defence Communications Ltd"],
      "001E71" => ["Igeacare", "Igeacare Solutions Inc."],
      "001E72" => ["Pcs",""],
      "001E73" => ["Zte", "ZTE CORPORATION"],
      "001E74" => ["SagemCom", "SAGEM COMMUNICATION"],
      "001E75" => ["LgElectr", "LG Electronics"],
      "001E76" => ["ThermoFi", "Thermo Fisher Scientific"],
      "001E77" => ["Air2app",""],
      "001E78" => ["OwitekTe", "Owitek Technology Ltd.,"],
      "001E79" => ["Cisco", "Cisco Systems"],
      "001E7A" => ["Cisco", "Cisco Systems"],
      "001E7B" => ["RISRL", "R.I.CO. S.r.l."],
      "001E7C" => ["Taiwick", "Taiwick Limited"],
      "001E7D" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "001E7E" => ["Nortel",""],
      "001E7F" => ["CbmOfAme", "CBM of America"],
      "001E80" => ["LastMile", "Last Mile Ltd."],
      "001E81" => ["CnbTechn", "CNB Technology Inc."],
      "001E82" => ["Sandisk", "SanDisk Corporation"],
      "001E83" => ["Lan/ManS", "LAN/MAN Standards Association (LMSC)"],
      "001E84" => ["PikaTech", "Pika Technologies Inc."],
      "001E85" => ["Lagotek", "Lagotek Corporation"],
      "001E86" => ["Mel", "MEL Co.,Ltd."],
      "001E87" => ["Realease", "Realease Limited"],
      "001E88" => ["AndorSys", "ANDOR SYSTEM SUPPORT CO., LTD."],
      "001E89" => ["Crfs", "CRFS Limited"],
      "001E8A" => ["Ecopy", "eCopy, Inc"],
      "001E8B" => ["InfraAcc", "Infra Access Korea Co., Ltd."],
      "001E8C" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "001E8D" => ["Motorola", "Motorola Mobility, Inc."],
      "001E8E" => ["Hunkeler", "Hunkeler AG"],
      "001E8F" => ["Canon", "CANON INC."],
      "001E90" => ["Elitegro", "Elitegroup Computer Systems Co"],
      "001E91" => ["KiminEle", "KIMIN Electronic Co., Ltd."],
      "001E92" => ["JeulinSA", "JEULIN S.A."],
      "001E93" => ["Ciritech", "CiriTech Systems Inc"],
      "001E94" => ["Supercom", "SUPERCOM TECHNOLOGY CORPORATION"],
      "001E95" => ["Sigmalin", "SIGMALINK"],
      "001E96" => ["Sepura", "Sepura Plc"],
      "001E97" => ["MediumLi", "Medium Link System Technology CO., LTD,"],
      "001E98" => ["Greenlin", "GreenLine Communications"],
      "001E99" => ["Vantanol", "Vantanol Industrial Corporation"],
      "001E9A" => ["Hamilton", "HAMILTON Bonaduz AG"],
      "001E9B" => ["San-Eish", "San-Eisha, Ltd."],
      "001E9C" => ["Fidustro", "Fidustron INC"],
      "001E9D" => ["RecallTe", "Recall Technologies, Inc."],
      "001E9E" => ["DdmHopt+", "ddm hopt + schuler Gmbh + Co. KG"],
      "001E9F" => ["Visionee", "Visioneering Systems, Inc."],
      "001EA0" => ["Xln-T",""],
      "001EA1" => ["Brunata", "Brunata a/s"],
      "001EA2" => ["Symx", "Symx Systems, Inc."],
      "001EA3" => ["NokiaDan", "Nokia Danmark A/S"],
      "001EA4" => ["NokiaDan", "Nokia Danmark A/S"],
      "001EA5" => ["Robotous", "ROBOTOUS, Inc."],
      "001EA6" => ["BestItWo", "Best IT World (India) Pvt. Ltd."],
      "001EA7" => ["Actionte", "ActionTec Electronics, Inc"],
      "001EA8" => ["DatangMo", "Datang Mobile Communications Equipment CO.,LTD"],
      "001EA9" => ["Nintendo", "Nintendo Co., Ltd."],
      "001EAA" => ["E-SenzaT", "E-Senza Technologies GmbH"],
      "001EAB" => ["Telewell", "TeleWell Oy"],
      "001EAC" => ["Armadeus", "Armadeus Systems"],
      "001EAD" => ["Wingtech", "Wingtech Group Limited"],
      "001EAE" => ["Continen", "Continental Automotive Systems"],
      "001EAF" => ["OphirOpt", "Ophir Optronics Ltd"],
      "001EB0" => ["ImesdEle", "ImesD Electronica S.L."],
      "001EB1" => ["Cryptsof", "Cryptsoft Pty Ltd"],
      "001EB2" => ["LgInnote", "LG innotek"],
      "001EB3" => ["PrimexWi", "Primex Wireless"],
      "001EB4" => ["UnifatTe", "UNIFAT TECHNOLOGY LTD."],
      "001EB5" => ["EverSpar", "Ever Sparkle Technologies Ltd"],
      "001EB6" => ["TagHeuer", "TAG Heuer SA"],
      "001EB7" => ["Tbtech", "TBTech, Co., Ltd."],
      "001EB8" => ["Fortis", "Fortis, Inc."],
      "001EB9" => ["SingFaiT", "Sing Fai Technology Limited"],
      "001EBA" => ["HighDens", "High Density Devices AS"],
      "001EBB" => ["Blueligh", "BLUELIGHT TECHNOLOGY INC."],
      "001EBC" => ["WintechA", "WINTECH AUTOMATION CO.,LTD."],
      "001EBD" => ["Cisco", "Cisco Systems"],
      "001EBE" => ["Cisco", "Cisco Systems"],
      "001EBF" => ["HaasAuto", "Haas Automation Inc."],
      "001EC0" => ["Microchi", "Microchip Technology Inc."],
      "001EC1" => ["3comEuro", "3COM EUROPE LTD"],
      "001EC2" => ["Apple", "Apple, Inc"],
      "001EC3" => ["Kozio", "Kozio, Inc."],
      "001EC4" => ["Celio", "Celio Corp"],
      "001EC5" => ["MiddleAt", "Middle Atlantic Products Inc"],
      "001EC6" => ["ObviusHo", "Obvius Holdings LLC"],
      "001EC7" => ["2wire",""],
      "001EC8" => ["RapidMob", "Rapid Mobile (Pty) Ltd"],
      "001EC9" => ["Dell", "Dell Inc"],
      "001ECA" => ["Nortel",""],
      "001ECB" => ["Rpc Ene", "RPC Energoautomatika Ltd"],
      "001ECC" => ["Cdvi",""],
      "001ECD" => ["Kyland",""],
      "001ECE" => ["BisaTech", "BISA Technologies (Hong Kong) Limited"],
      "001ECF" => ["PhilipsE", "PHILIPS ELECTRONICS UK LTD"],
      "001ED0" => ["Connexiu", "CONNEXIUM"],
      "001ED1" => ["Keyproce", "Keyprocessor B.V."],
      "001ED2" => ["RayShine", "Ray Shine Video Technology Inc"],
      "001ED3" => ["DotTechn", "Dot Technology Int\'l Co., Ltd."],
      "001ED4" => ["DobleEng", "Doble Engineering"],
      "001ED5" => ["Tekon-Au", "Tekon-Automatics"],
      "001ED6" => ["AlentecO", "Alentec & Orion AB"],
      "001ED7" => ["H-Stream", "H-Stream Wireless, Inc."],
      "001ED8" => ["DigitalU", "Digital United Inc."],
      "001ED9" => ["Mitsubis", "Mitsubishi Precision Co.,LTd."],
      "001EDA" => ["Wesemann", "Wesemann Elektrotechniek B.V."],
      "001EDB" => ["GikenTra", "Giken Trastem Co., Ltd."],
      "001EDC" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "001EDD" => ["WaskoSA", "WASKO S.A."],
      "001EDE" => ["Byd", "BYD COMPANY LIMITED"],
      "001EDF" => ["MasterIn", "Master Industrialization Center Kista"],
      "001EE0" => ["UrmetDom", "Urmet Domus SpA"],
      "001EE1" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "001EE2" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "001EE3" => ["T&WElect", "T&W Electronics (ShenZhen) Co.,Ltd"],
      "001EE4" => ["AcsSolut", "ACS Solutions France"],
      "001EE5" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "001EE6" => ["Shenzhen", "Shenzhen Advanced Video Info-Tech Co., Ltd."],
      "001EE7" => ["Epic", "Epic Systems Inc"],
      "001EE8" => ["Mytek",""],
      "001EE9" => ["Stonerid", "Stoneridge Electronics AB"],
      "001EEA" => ["SensorSw", "Sensor Switch, Inc."],
      "001EEB" => ["Talk-A-P", "Talk-A-Phone Co."],
      "001EEC" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD."],
      "001EED" => ["Adventiq", "Adventiq Ltd."],
      "001EEE" => ["Etl", "ETL Systems Ltd"],
      "001EEF" => ["Cantroni", "Cantronic International Limited"],
      "001EF0" => ["GigafinN", "Gigafin Networks"],
      "001EF1" => ["Servimat",""],
      "001EF2" => ["MicroMot", "Micro Motion Inc"],
      "001EF3" => ["From2",""],
      "001EF4" => ["L-3Commu", "L-3 Communications Display Systems"],
      "001EF5" => ["HitekAut", "Hitek Automated Inc."],
      "001EF6" => ["Cisco", "Cisco Systems"],
      "001EF7" => ["Cisco", "Cisco Systems"],
      "001EF8" => ["Emfinity", "Emfinity Inc."],
      "001EF9" => ["PascomKo", "Pascom Kommunikations systeme GmbH."],
      "001EFA" => ["Protei", "PROTEI Ltd."],
      "001EFB" => ["TrioMoti", "Trio Motion Technology Ltd"],
      "001EFC" => ["Jsc Mass", "JSC MASSA-K"],
      "001EFD" => ["Microbit", "Microbit 2.0 AB"],
      "001EFE" => ["LevelSRO", "LEVEL s.r.o."],
      "001EFF" => ["Mueller-", "Mueller-Elektronik GmbH & Co. KG"],
      "001F00" => ["NokiaDan", "Nokia Danmark A/S"],
      "001F01" => ["NokiaDan", "Nokia Danmark A/S"],
      "001F02" => ["Pixelmet", "Pixelmetrix Corporation Pte Ltd"],
      "001F03" => ["Num", "NUM AG"],
      "001F04" => ["Granch", "Granch Ltd."],
      "001F05" => ["ItasTech", "iTAS Technology Corp."],
      "001F06" => ["Integrat", "Integrated Dispatch Solutions"],
      "001F07" => ["AzteqMob", "AZTEQ Mobile"],
      "001F08" => ["Risco", "RISCO LTD"],
      "001F09" => ["Jastec", "JASTEC CO., LTD."],
      "001F0A" => ["Nortel",""],
      "001F0B" => ["FederalS", "Federal State Unitary Enterprise Industrial Union Electropribor"],
      "001F0C" => ["Intellig", "Intelligent Digital Services GmbH"],
      "001F0D" => ["L3Commun", "L3 Communications - Telemetry West"],
      "001F0E" => ["JapanKya", "Japan Kyastem Co., Ltd"],
      "001F0F" => ["SelectEn", "Select Engineered Systems"],
      "001F10" => ["ToledoDo", "TOLEDO DO BRASIL INDUSTRIA DE BALANCAS  LTDA"],
      "001F11" => ["Openmoko", "OPENMOKO, INC."],
      "001F12" => ["JuniperN", "Juniper Networks"],
      "001F13" => ["SAS", "S.& A.S. Ltd."],
      "001F14" => ["Nexg",""],
      "001F15" => ["Bioscryp", "Bioscrypt Inc"],
      "001F16" => ["Wistron", "Wistron Corporation"],
      "001F17" => ["Idx", "IDX Company, Ltd."],
      "001F18" => ["HakusanM", "Hakusan.Mfg.Co,.Ltd"],
      "001F19" => ["Ben-RiEl", "BEN-RI ELECTRONICA S.A."],
      "001F1A" => ["Prominve", "Prominvest"],
      "001F1B" => ["Royaltek", "RoyalTek Company Ltd."],
      "001F1C" => ["KobishiE", "KOBISHI ELECTRIC Co.,Ltd."],
      "001F1D" => ["AtlasMat", "Atlas Material Testing Technology LLC"],
      "001F1E" => ["AstecTec", "Astec Technology Co., Ltd"],
      "001F1F" => ["EdimaxTe", "Edimax Technology Co. Ltd."],
      "001F20" => ["Logitech", "Logitech Europe SA"],
      "001F21" => ["InnerMon", "Inner Mongolia Yin An Science & Technology Development Co.,L"],
      "001F22" => ["SourcePh", "Source Photonics, Inc."],
      "001F23" => ["Interaco", "Interacoustics"],
      "001F24" => ["Digitvie", "DIGITVIEW TECHNOLOGY CO., LTD."],
      "001F25" => ["Mbs", "MBS GmbH"],
      "001F26" => ["Cisco", "Cisco Systems"],
      "001F27" => ["Cisco", "Cisco Systems"],
      "001F28" => ["Procurve", "ProCurve Networking by HP"],
      "001F29" => ["Hewlett-", "Hewlett-Packard Company"],
      "001F2A" => ["Accm",""],
      "001F2B" => ["OrangeLo", "Orange Logic"],
      "001F2C" => ["Starbrid", "Starbridge Networks"],
      "001F2D" => ["Electro-", "Electro-Optical Imaging, Inc."],
      "001F2E" => ["Triangle", "Triangle Research Int\'l Pte Ltd"],
      "001F2F" => ["Berker", "Berker GmbH & Co. KG"],
      "001F30" => ["Travelpi", "Travelping"],
      "001F31" => ["Radiocom", "Radiocomp"],
      "001F32" => ["Nintendo", "Nintendo Co., Ltd."],
      "001F33" => ["Netgear", "Netgear Inc."],
      "001F34" => ["LungHwaE", "Lung Hwa Electronics Co., Ltd."],
      "001F35" => ["Air802Ll", "AIR802 LLC"],
      "001F36" => ["BellwinI", "Bellwin Information Co. Ltd.,"],
      "001F37" => ["GenesisI", "Genesis I&C"],
      "001F38" => ["Positron",""],
      "001F39" => ["Construc", "Construcciones y Auxiliar de Ferrocarriles, S.A."],
      "001F3A" => ["HonHaiPr", "Hon Hai Precision Ind.Co., Ltd."],
      "001F3B" => ["IntelCor", "Intel Corporate"],
      "001F3C" => ["IntelCor", "Intel Corporate"],
      "001F3D" => ["Qbit", "Qbit GmbH"],
      "001F3E" => ["Rp-Techn", "RP-Technik e.K."],
      "001F3F" => ["Avm", "AVM GmbH"],
      "001F40" => ["Speakerc", "Speakercraft Inc."],
      "001F41" => ["RuckusWi", "Ruckus Wireless"],
      "001F42" => ["Ethersta", "Etherstack Pty Ltd"],
      "001F43" => ["EntesEle", "ENTES ELEKTRONIK"],
      "001F44" => ["GeTransp", "GE Transportation Systems"],
      "001F45" => ["Enterasy", "Enterasys"],
      "001F46" => ["Nortel",""],
      "001F47" => ["McsLogic", "MCS Logic Inc."],
      "001F48" => ["Mojix", "Mojix Inc."],
      "001F49" => ["EurosatD", "Eurosat Distribution Ltd"],
      "001F4A" => ["Albentia", "Albentia Systems S.A."],
      "001F4B" => ["LineageP", "Lineage Power"],
      "001F4C" => ["RosemanE", "Roseman Engineering Ltd"],
      "001F4D" => ["Segnetic", "Segnetics LLC"],
      "001F4E" => ["ConmedLi", "ConMed Linvatec"],
      "001F4F" => ["Thinkwar", "Thinkware Co. Ltd."],
      "001F50" => ["Swissdis", "Swissdis AG"],
      "001F51" => ["HdCommun", "HD Communications Corp"],
      "001F52" => ["UvtUnter", "UVT Unternehmensberatung fur Verkehr und Technik GmbH"],
      "001F53" => ["GemacGes", "GEMAC Gesellschaft fur Mikroelektronikanwendung Chemnitz mbH"],
      "001F54" => ["LorexTec", "Lorex Technology Inc."],
      "001F55" => ["Honeywel", "Honeywell Security (China) Co., Ltd."],
      "001F56" => ["DigitalF", "DIGITAL FORECAST"],
      "001F57" => ["PhonikIn", "Phonik Innovation Co.,LTD"],
      "001F58" => ["EmhEnerg", "EMH Energiemesstechnik GmbH & co.KG"],
      "001F59" => ["Kronback", "Kronback Tracers"],
      "001F5A" => ["Beckwith", "Beckwith Electric Co."],
      "001F5B" => ["Apple", "Apple, Inc."],
      "001F5C" => ["NokiaDan", "Nokia Danmark A/S"],
      "001F5D" => ["NokiaDan", "Nokia Danmark A/S"],
      "001F5E" => ["DynaTech", "Dyna Technology Co.,Ltd."],
      "001F5F" => ["Blatand", "Blatand GmbH"],
      "001F60" => ["Compass", "COMPASS SYSTEMS CORP."],
      "001F61" => ["TalentCo", "Talent Communication Networks Inc."],
      "001F62" => ["Jsc Stil", "JSC Stilsoft "],
      "001F63" => ["JscGoodw", "JSC Goodwin-Europa"],
      "001F64" => ["BeijingA", "Beijing Autelan Technology Inc."],
      "001F65" => ["KoreaEle", "KOREA ELECTRIC TERMINAL CO., LTD."],
      "001F66" => ["PlanarLl", "PLANAR LLC"],
      "001F67" => ["Hitachi", "Hitachi,Ltd."],
      "001F68" => ["Martinss", "Martinsson Elektronik AB"],
      "001F69" => ["PingoodT", "Pingood Technology Co., Ltd."],
      "001F6A" => ["Packetfl", "PacketFlux Technologies, Inc."],
      "001F6B" => ["LgElectr", "LG Electronics"],
      "001F6C" => ["Cisco", "Cisco Systems"],
      "001F6D" => ["Cisco", "Cisco Systems"],
      "001F6E" => ["VtechEng", "Vtech Engineering Corporation"],
      "001F6F" => ["FujianSu", "Fujian Sunnada Communication Co.,Ltd."],
      "001F70" => ["BotikTec", "Botik Technologies LTD"],
      "001F71" => ["XgTechno", "xG Technology, Inc."],
      "001F72" => ["QingdaoH", "QingDao Hiphone Technology Co,.Ltd"],
      "001F73" => ["Teraview", "Teraview Technology Co., Ltd."],
      "001F74" => ["EigenDev", "Eigen Development"],
      "001F75" => ["GibahnMe", "GiBahn Media"],
      "001F76" => ["Airlogic", "AirLogic Systems Inc."],
      "001F77" => ["HeolDesi", "HEOL DESIGN"],
      "001F78" => ["BlueFoxP", "Blue Fox Porini Textile"],
      "001F79" => ["LodamEle", "Lodam Electronics A/S"],
      "001F7A" => ["Wiwide", "WiWide Inc."],
      "001F7B" => ["Technexi", "TechNexion Ltd."],
      "001F7C" => ["Witelcom", "Witelcom AS"],
      "001F7D" => ["Embedded", "embedded wireless GmbH"],
      "001F7E" => ["Motorola", "Motorola Mobility, Inc."],
      "001F7F" => ["Phabrix", "Phabrix Limited"],
      "001F80" => ["LucasBv", "Lucas Holding bv"],
      "001F81" => ["AccelSem", "Accel Semiconductor Corp"],
      "001F82" => ["Cal-Comp", "Cal-Comp Electronics & Communications Co., Ltd"],
      "001F83" => ["Teleplan", "Teleplan Technology Services Sdn Bhd"],
      "001F84" => ["GigleSem", "Gigle Semiconductor"],
      "001F85" => ["AprivaIs", "Apriva ISS, LLC"],
      "001F86" => ["Digecor",""],
      "001F87" => ["Skydigit", "Skydigital Inc."],
      "001F88" => ["FmsForce", "FMS Force Measuring Systems AG"],
      "001F89" => ["Signalio", "Signalion GmbH"],
      "001F8A" => ["EllionDi", "Ellion Digital Inc."],
      "001F8B" => ["CacheIq", "Cache IQ"],
      "001F8C" => ["Ccs", "CCS Inc."],
      "001F8D" => ["Ingenieu", "Ingenieurbuero Stark GmbH und Ko. KG"],
      "001F8E" => ["MetrisUs", "Metris USA Inc."],
      "001F8F" => ["Shanghai", "Shanghai Bellmann Digital Source Co.,Ltd."],
      "001F90" => ["Actionte", "Actiontec Electronics, Inc"],
      "001F91" => ["DbsLodgi", "DBS Lodging Technologies, LLC"],
      "001F92" => ["Videoiq", "VideoIQ, Inc."],
      "001F93" => ["Xiotech", "Xiotech Corporation"],
      "001F94" => ["LascarEl", "Lascar Electronics Ltd"],
      "001F95" => ["SagemCom", "SAGEM COMMUNICATION"],
      "001F96" => ["Aprotech", "APROTECH CO.LTD"],
      "001F97" => ["BertanaS", "BERTANA SRL"],
      "001F98" => ["Daiichi-", "DAIICHI-DENTSU LTD."],
      "001F99" => ["Seronics", "SERONICS co.ltd"],
      "001F9A" => ["NortelNe", "Nortel Networks"],
      "001F9B" => ["Posbro",""],
      "001F9C" => ["Ledco",""],
      "001F9D" => ["Cisco", "Cisco Systems"],
      "001F9E" => ["Cisco", "Cisco Systems"],
      "001F9F" => ["ThomsonT", "Thomson Telecom Belgium"],
      "001FA0" => ["A10Netwo", "A10 Networks"],
      "001FA1" => ["Gtran", "Gtran Inc"],
      "001FA2" => ["DatronWo", "Datron World Communications, Inc."],
      "001FA3" => ["T&WElect", "T&W Electronics(Shenzhen)Co.,Ltd."],
      "001FA4" => ["Shenzhen", "ShenZhen Gongjin Electronics Co.,Ltd"],
      "001FA5" => ["Blue-Whi", "Blue-White Industries"],
      "001FA6" => ["StiloSrl", "Stilo srl"],
      "001FA7" => ["SonyComp", "Sony Computer Entertainment Inc."],
      "001FA8" => ["SmartEne", "Smart Energy Instruments Inc."],
      "001FA9" => ["AtlantaD", "Atlanta DTH, Inc."],
      "001FAA" => ["Taseon", "Taseon, Inc."],
      "001FAB" => ["ISHighTe", "I.S HIGH TECH.INC"],
      "001FAC" => ["Goodmill", "Goodmill Systems Ltd"],
      "001FAD" => ["BrownInn", "Brown Innovations, Inc"],
      "001FAE" => ["BlickSou", "Blick South Africa (Pty) Ltd"],
      "001FAF" => ["Nextio", "NextIO, Inc."],
      "001FB0" => ["Timeips", "TimeIPS, Inc."],
      "001FB1" => ["Cybertec", "Cybertech Inc."],
      "001FB2" => ["Sontheim", "Sontheim Industrie Elektronik GmbH"],
      "001FB3" => ["2wire",""],
      "001FB4" => ["Smartsha", "SmartShare Systems"],
      "001FB5" => ["I/OInter", "I/O Interconnect Inc."],
      "001FB6" => ["ChiLinTe", "Chi Lin Technology Co., Ltd."],
      "001FB7" => ["WimateTe", "WiMate Technologies Corp."],
      "001FB8" => ["Universa", "Universal Remote Control, Inc."],
      "001FB9" => ["Paltroni", "Paltronics"],
      "001FBA" => ["BoyoungT", "BoYoung Tech. & Marketing, Inc."],
      "001FBB" => ["Xenatech", "Xenatech Co.,LTD"],
      "001FBC" => ["Evga", "EVGA Corporation"],
      "001FBD" => ["KyoceraW", "Kyocera Wireless Corp."],
      "001FBE" => ["Shenzhen", "Shenzhen Mopnet Industrial Co.,Ltd"],
      "001FBF" => ["FulhuaMi", "Fulhua Microelectronics Corp. Taiwan Branch"],
      "001FC0" => ["ControlE", "Control Express Finland Oy"],
      "001FC1" => ["HanlongT", "Hanlong Technology Co.,LTD"],
      "001FC2" => ["JowTongT", "Jow Tong Technology Co Ltd"],
      "001FC3" => ["Smartsyn", "SmartSynch, Inc"],
      "001FC4" => ["Motorola", "Motorola Mobility, Inc."],
      "001FC5" => ["Nintendo", "Nintendo Co., Ltd."],
      "001FC6" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "001FC7" => ["CasioHit", "Casio Hitachi Mobile Comunications Co., Ltd."],
      "001FC8" => ["Up-Today", "Up-Today Industrial Co., Ltd."],
      "001FC9" => ["Cisco", "Cisco Systems"],
      "001FCA" => ["Cisco", "Cisco Systems"],
      "001FCB" => ["NiwSolut", "NIW Solutions"],
      "001FCC" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "001FCD" => ["SamsungE", "Samsung Electronics"],
      "001FCE" => ["QtechLlc", "QTECH LLC"],
      "001FCF" => ["MsiTechn", "MSI Technology GmbH"],
      "001FD0" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "001FD1" => ["Optex", "OPTEX CO.,LTD."],
      "001FD2" => ["Commtech", "COMMTECH TECHNOLOGY MACAO COMMERCIAL OFFSHORE LTD."],
      "001FD3" => ["RivaNetw", "RIVA Networks Inc."],
      "001FD4" => ["4ipnet", "4IPNET, INC."],
      "001FD5" => ["Microris", "MICRORISC s.r.o."],
      "001FD6" => ["Shenzhen", "Shenzhen Allywll"],
      "001FD7" => ["TeleradS", "TELERAD SA"],
      "001FD8" => ["A-TrustC", "A-TRUST COMPUTER CORPORATION"],
      "001FD9" => ["RsdCommu", "RSD Communications Ltd"],
      "001FDA" => ["NortelNe", "Nortel Networks"],
      "001FDB" => ["NetworkS", "Network Supply Corp.,"],
      "001FDC" => ["MobileSa", "Mobile Safe Track Ltd"],
      "001FDD" => ["GdiLlc", "GDI LLC"],
      "001FDE" => ["NokiaDan", "Nokia Danmark A/S"],
      "001FDF" => ["NokiaDan", "Nokia Danmark A/S"],
      "001FE0" => ["Edgevelo", "EdgeVelocity Corp"],
      "001FE1" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "001FE2" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "001FE3" => ["LgElectr", "LG Electronics"],
      "001FE4" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "001FE5" => ["In-Circu", "In-Circuit GmbH"],
      "001FE6" => ["Alphion", "Alphion Corporation"],
      "001FE7" => ["Simet",""],
      "001FE8" => ["Kurusuga", "KURUSUGAWA Electronics Industry Inc,."],
      "001FE9" => ["Printrex", "Printrex, Inc."],
      "001FEA" => ["AppliedM", "Applied Media Technologies Corporation"],
      "001FEB" => ["TrioData", "Trio Datacom Pty Ltd"],
      "001FEC" => ["Synapsee", "Synapse electronique"],
      "001FED" => ["Tecan", "Tecan Systems Inc."],
      "001FEE" => ["UbisysTe", "ubisys technologies GmbH"],
      "001FEF" => ["ShinseiI", "SHINSEI INDUSTRIES CO.,LTD"],
      "001FF0" => ["AudioPar", "Audio Partnership"],
      "001FF1" => ["ParadoxH", "Paradox Hellas S.A."],
      "001FF2" => ["ViaTechn", "VIA Technologies, Inc."],
      "001FF3" => ["Apple", "Apple, Inc"],
      "001FF4" => ["PowerMon", "Power Monitors, Inc."],
      "001FF5" => ["Kongsber", "Kongsberg Defence & Aerospace"],
      "001FF6" => ["PsAudioI", "PS Audio International"],
      "001FF7" => ["Nakajima", "Nakajima All Precision Co., Ltd."],
      "001FF8" => ["SiemensS", "Siemens AG, Sector Industry, Drive Technologies, Motion Control Systems"],
      "001FF9" => ["Advanced", "Advanced Knowledge Associates"],
      "001FFA" => ["Coretree", "Coretree, Co, Ltd"],
      "001FFB" => ["GreenPac", "Green Packet Bhd"],
      "001FFC" => ["Riccius+", "Riccius+Sohn GmbH"],
      "001FFD" => ["IndigoMo", "Indigo Mobile Technologies Corp."],
      "001FFE" => ["Procurve", "ProCurve Networking by HP"],
      "001FFF" => ["Respiron", "Respironics, Inc."],
      "002000" => ["LexmarkI", "LEXMARK INTERNATIONAL, INC."],
      "002001" => ["DspSolut", "DSP SOLUTIONS, INC."],
      "002002" => ["Seritech", "SERITECH ENTERPRISE CO., LTD."],
      "002003" => ["PixelPow", "PIXEL POWER LTD."],
      "002004" => ["Yamatake", "YAMATAKE-HONEYWELL CO., LTD."],
      "002005" => ["SimpleTe", "SIMPLE TECHNOLOGY"],
      "002006" => ["GarrettC", "GARRETT COMMUNICATIONS, INC."],
      "002007" => ["Sfa", "SFA, INC."],
      "002008" => ["CableCom", "CABLE & COMPUTER TECHNOLOGY"],
      "002009" => ["PackardB", "PACKARD BELL ELEC., INC."],
      "00200A" => ["Source-C", "SOURCE-COMM CORP."],
      "00200B" => ["Octagon", "OCTAGON SYSTEMS CORP."],
      "00200C" => ["Adastra", "ADASTRA SYSTEMS CORP."],
      "00200D" => ["CarlZeis", "CARL ZEISS"],
      "00200E" => ["Satellit", "SATELLITE TECHNOLOGY MGMT, INC"],
      "00200F" => ["Tanbac", "TANBAC CO., LTD."],
      "002010" => ["JeolSyst", "JEOL SYSTEM TECHNOLOGY CO. LTD"],
      "002011" => ["Canopus", "CANOPUS CO., LTD."],
      "002012" => ["Camtroni", "CAMTRONICS MEDICAL SYSTEMS"],
      "002013" => ["Diversif", "DIVERSIFIED TECHNOLOGY, INC."],
      "002014" => ["GlobalVi", "GLOBAL VIEW CO., LTD."],
      "002015" => ["ActisCom", "ACTIS COMPUTER SA"],
      "002016" => ["ShowaEle", "SHOWA ELECTRIC WIRE & CABLE CO"],
      "002017" => ["Orbotech",""],
      "002018" => ["CisTechn", "CIS TECHNOLOGY INC."],
      "002019" => ["Ohler", "OHLER GmbH"],
      "00201A" => ["MrvCommu", "MRV Communications, Inc."],
      "00201B" => ["Northern", "NORTHERN TELECOM/NETWORK"],
      "00201C" => ["Excel", "EXCEL, INC."],
      "00201D" => ["KatanaPr", "KATANA PRODUCTS"],
      "00201E" => ["Netquest", "NETQUEST CORPORATION"],
      "00201F" => ["BestPowe", "BEST POWER TECHNOLOGY, INC."],
      "002020" => ["Megatron", "MEGATRON COMPUTER INDUSTRIES PTY, LTD."],
      "002021" => ["Algorith", "ALGORITHMS SOFTWARE PVT. LTD."],
      "002022" => ["NmsCommu", "NMS Communications"],
      "002023" => ["TCTechno", "T.C. TECHNOLOGIES PTY. LTD"],
      "002024" => ["PacificC", "PACIFIC COMMUNICATION SCIENCES"],
      "002025" => ["ControlT", "CONTROL TECHNOLOGY, INC."],
      "002026" => ["Amkly", "AMKLY SYSTEMS, INC."],
      "002027" => ["MingFort", "MING FORTUNE INDUSTRY CO., LTD"],
      "002028" => ["WestEgg", "WEST EGG SYSTEMS, INC."],
      "002029" => ["Teleproc", "TELEPROCESSING PRODUCTS, INC."],
      "00202A" => ["NVDzine", "N.V. DZINE"],
      "00202B" => ["Advanced", "ADVANCED TELECOMMUNICATIONS MODULES, LTD."],
      "00202C" => ["Welltron", "WELLTRONIX CO., LTD."],
      "00202D" => ["Taiyo", "TAIYO CORPORATION"],
      "00202E" => ["DaystarD", "DAYSTAR DIGITAL"],
      "00202F" => ["ZetaComm", "ZETA COMMUNICATIONS, LTD."],
      "002030" => ["AnalogDi", "ANALOG & DIGITAL SYSTEMS"],
      "002031" => ["TattileS", "Tattile SRL"],
      "002032" => ["AlcatelT", "ALCATEL TAISEL"],
      "002033" => ["SynapseT", "SYNAPSE TECHNOLOGIES, INC."],
      "002034" => ["RotecInd", "ROTEC INDUSTRIEAUTOMATION GMBH"],
      "002035" => ["Ibm", "IBM Corp"],
      "002036" => ["BmcSoftw", "BMC SOFTWARE"],
      "002037" => ["SeagateT", "SEAGATE TECHNOLOGY"],
      "002038" => ["VmeMicro", "VME MICROSYSTEMS INTERNATIONAL CORPORATION"],
      "002039" => ["Scinets",""],
      "00203A" => ["DigitalB", "DIGITAL BI0METRICS INC."],
      "00203B" => ["Wisdm", "WISDM LTD."],
      "00203C" => ["Eurotime", "EUROTIME AB"],
      "00203D" => ["Honeywel", "Honeywell ECC"],
      "00203E" => ["LogicanT", "LogiCan Technologies, Inc."],
      "00203F" => ["Juki", "JUKI CORPORATION"],
      "002040" => ["Motorola", "Motorola Broadband Communications Sector"],
      "002041" => ["DataNet", "DATA NET"],
      "002042" => ["Datametr", "DATAMETRICS CORP."],
      "002043" => ["Neuron", "NEURON COMPANY LIMITED"],
      "002044" => ["Genitech", "GENITECH PTY LTD"],
      "002045" => ["IonNetwo", "ION Networks, Inc."],
      "002046" => ["Ciprico", "CIPRICO, INC."],
      "002047" => ["Steinbre", "STEINBRECHER CORP."],
      "002048" => ["MarconiC", "Marconi Communications"],
      "002049" => ["Comtron", "COMTRON, INC."],
      "00204A" => ["Pronet", "PRONET GMBH"],
      "00204B" => ["Autocomp", "AUTOCOMPUTER CO., LTD."],
      "00204C" => ["MitronCo", "MITRON COMPUTER PTE LTD."],
      "00204D" => ["Inovis", "INOVIS GMBH"],
      "00204E" => ["NetworkS", "NETWORK SECURITY SYSTEMS, INC."],
      "00204F" => ["Deutsche", "DEUTSCHE AEROSPACE AG"],
      "002050" => ["KoreaCom", "KOREA COMPUTER INC."],
      "002051" => ["Verilink", "Verilink Corporation"],
      "002052" => ["Ragula", "RAGULA SYSTEMS"],
      "002053" => ["Huntsvil", "HUNTSVILLE MICROSYSTEMS, INC."],
      "002054" => ["Sycamore", "Sycamore Networks"],
      "002055" => ["Altech", "ALTECH CO., LTD."],
      "002056" => ["Neoprodu", "NEOPRODUCTS"],
      "002057" => ["TitzeDat", "TITZE DATENTECHNIK GmbH"],
      "002058" => ["AlliedSi", "ALLIED SIGNAL INC."],
      "002059" => ["MiroComp", "MIRO COMPUTER PRODUCTS AG"],
      "00205A" => ["Computer", "COMPUTER IDENTICS"],
      "00205B" => ["KentroxL", "Kentrox, LLC"],
      "00205C" => ["Internet", "InterNet Systems of Florida, Inc."],
      "00205D" => ["Nanomati", "NANOMATIC OY"],
      "00205E" => ["CastleRo", "CASTLE ROCK, INC."],
      "00205F" => ["Gammadat", "GAMMADATA COMPUTER GMBH"],
      "002060" => ["AlcatelI", "ALCATEL ITALIA S.p.A."],
      "002061" => ["Garrettc", "GarrettCom, Inc."],
      "002062" => ["Scorpion", "SCORPION LOGIC, LTD."],
      "002063" => ["WiproInf", "WIPRO INFOTECH LTD."],
      "002064" => ["ProtecMi", "PROTEC MICROSYSTEMS, INC."],
      "002065" => ["Supernet", "SUPERNET NETWORKING INC."],
      "002066" => ["GeneralM", "GENERAL MAGIC, INC."],
      "002067" => ["Private",""],
      "002068" => ["Isdyne",""],
      "002069" => ["Isdn", "ISDN SYSTEMS CORPORATION"],
      "00206A" => ["OsakaCom", "OSAKA COMPUTER CORP."],
      "00206B" => ["KonicaMi", "KONICA MINOLTA HOLDINGS, INC."],
      "00206C" => ["Evergree", "EVERGREEN TECHNOLOGY CORP."],
      "00206D" => ["DataRace", "DATA RACE, INC."],
      "00206E" => ["Xact", "XACT, INC."],
      "00206F" => ["Flowpoin", "FLOWPOINT CORPORATION"],
      "002070" => ["Hynet", "HYNET, LTD."],
      "002071" => ["Ibr", "IBR GMBH"],
      "002072" => ["Worklink", "WORKLINK INNOVATIONS"],
      "002073" => ["Fusion", "FUSION SYSTEMS CORPORATION"],
      "002074" => ["Sungwoon", "SUNGWOON SYSTEMS"],
      "002075" => ["Motorola", "MOTOROLA COMMUNICATION ISRAEL"],
      "002076" => ["Reudo", "REUDO CORPORATION"],
      "002077" => ["Kardios", "KARDIOS SYSTEMS CORP."],
      "002078" => ["Runtop", "RUNTOP, INC."],
      "002079" => ["Mikron", "MIKRON GMBH"],
      "00207A" => ["WiseComm", "WiSE Communications, Inc."],
      "00207B" => ["Intel", "Intel Corporation"],
      "00207C" => ["Autec", "AUTEC GmbH"],
      "00207D" => ["Advanced", "ADVANCED COMPUTER APPLICATIONS"],
      "00207E" => ["Finecom", "FINECOM Co., Ltd."],
      "00207F" => ["KyoeiSan", "KYOEI SANGYO CO., LTD."],
      "002080" => ["SynergyU", "SYNERGY (UK) LTD."],
      "002081" => ["TitanEle", "TITAN ELECTRONICS"],
      "002082" => ["Oneac", "ONEAC CORPORATION"],
      "002083" => ["Prestico", "PRESTICOM INCORPORATED"],
      "002084" => ["OcePrint", "OCE PRINTING SYSTEMS, GMBH"],
      "002085" => ["3Com",""],
      "002086" => ["Microtec", "MICROTECH ELECTRONICS LIMITED"],
      "002087" => ["Memotec", "MEMOTEC, INC."],
      "002088" => ["GlobalVi", "GLOBAL VILLAGE COMMUNICATION"],
      "002089" => ["T3plusNe", "T3PLUS NETWORKING, INC."],
      "00208A" => ["SonixCom", "SONIX COMMUNICATIONS, LTD."],
      "00208B" => ["LapisTec", "LAPIS TECHNOLOGIES, INC."],
      "00208C" => ["GalaxyNe", "GALAXY NETWORKS, INC."],
      "00208D" => ["CmdTechn", "CMD TECHNOLOGY"],
      "00208E" => ["ChevinSo", "CHEVIN SOFTWARE ENG. LTD."],
      "00208F" => ["EciTelec", "ECI TELECOM LTD."],
      "002090" => ["Advanced", "ADVANCED COMPRESSION TECHNOLOGY, INC."],
      "002091" => ["J125Nati", "J125, NATIONAL SECURITY AGENCY"],
      "002092" => ["ChessEng", "CHESS ENGINEERING B.V."],
      "002093" => ["Landings", "LANDINGS TECHNOLOGY CORP."],
      "002094" => ["Cubix", "CUBIX CORPORATION"],
      "002095" => ["RivaElec", "RIVA ELECTRONICS"],
      "002096" => ["Invensys",""],
      "002097" => ["AppliedS", "APPLIED SIGNAL TECHNOLOGY"],
      "002098" => ["Hectroni", "HECTRONIC AB"],
      "002099" => ["BonElect", "BON ELECTRIC CO., LTD."],
      "00209A" => ["3do", "THE 3DO COMPANY"],
      "00209B" => ["ErsatEle", "ERSAT ELECTRONIC GMBH"],
      "00209C" => ["PrimaryA", "PRIMARY ACCESS CORP."],
      "00209D" => ["LippertA", "LIPPERT AUTOMATIONSTECHNIK"],
      "00209E" => ["BrownSOp", "BROWN\'S OPERATING SYSTEM SERVICES, LTD."],
      "00209F" => ["MercuryC", "MERCURY COMPUTER SYSTEMS, INC."],
      "0020A0" => ["OaLabora", "OA LABORATORY CO., LTD."],
      "0020A1" => ["Dovatron",""],
      "0020A2" => ["GalcomNe", "GALCOM NETWORKING LTD."],
      "0020A3" => ["Divicom", "DIVICOM INC."],
      "0020A4" => ["Multipoi", "MULTIPOINT NETWORKS"],
      "0020A5" => ["ApiEngin", "API ENGINEERING"],
      "0020A6" => ["ProximWi", "Proxim Wireless"],
      "0020A7" => ["Pairgain", "PAIRGAIN TECHNOLOGIES, INC."],
      "0020A8" => ["SastTech", "SAST TECHNOLOGY CORP."],
      "0020A9" => ["WhiteHor", "WHITE HORSE INDUSTRIAL"],
      "0020AA" => ["Digimedi", "DIGIMEDIA VISION LTD."],
      "0020AB" => ["MicroInd", "MICRO INDUSTRIES CORP."],
      "0020AC" => ["Interfle", "INTERFLEX DATENSYSTEME GMBH"],
      "0020AD" => ["Linq", "LINQ SYSTEMS"],
      "0020AE" => ["OrnetDat", "ORNET DATA COMMUNICATION TECH."],
      "0020AF" => ["3com", "3COM CORPORATION"],
      "0020B0" => ["GatewayD", "GATEWAY DEVICES, INC."],
      "0020B1" => ["ComtechR", "COMTECH RESEARCH INC."],
      "0020B2" => ["GkdGesel", "GKD Gesellschaft Fur Kommunikation Und Datentechnik"],
      "0020B3" => ["TattileS", "Tattile SRL"],
      "0020B4" => ["TermaEle", "TERMA ELEKTRONIK AS"],
      "0020B5" => ["YaskawaE", "YASKAWA ELECTRIC CORPORATION"],
      "0020B6" => ["AgileNet", "AGILE NETWORKS, INC."],
      "0020B7" => ["NamaquaC", "NAMAQUA COMPUTERWARE"],
      "0020B8" => ["PrimeOpt", "PRIME OPTION, INC."],
      "0020B9" => ["Metricom", "METRICOM, INC."],
      "0020BA" => ["CenterFo", "CENTER FOR HIGH PERFORMANCE"],
      "0020BB" => ["Zax", "ZAX CORPORATION"],
      "0020BC" => ["LongReac", "Long Reach Networks Pty Ltd"],
      "0020BD" => ["Niobrara", "NIOBRARA R & D CORPORATION"],
      "0020BE" => ["LanAcces", "LAN ACCESS CORP."],
      "0020BF" => ["AehrTest", "AEHR TEST SYSTEMS"],
      "0020C0" => ["PulseEle", "PULSE ELECTRONICS, INC."],
      "0020C1" => ["Saxa", "SAXA, Inc."],
      "0020C2" => ["TexasMem", "TEXAS MEMORY SYSTEMS, INC."],
      "0020C3" => ["CounterS", "COUNTER SOLUTIONS LTD."],
      "0020C4" => ["Inet", "INET,INC."],
      "0020C5" => ["EagleTec", "EAGLE TECHNOLOGY"],
      "0020C6" => ["Nectec",""],
      "0020C7" => ["AkaiProf", "AKAI Professional M.I. Corp."],
      "0020C8" => ["Larscom", "LARSCOM INCORPORATED"],
      "0020C9" => ["VictronB", "VICTRON BV"],
      "0020CA" => ["DigitalO", "DIGITAL OCEAN"],
      "0020CB" => ["PretecEl", "PRETEC ELECTRONICS CORP."],
      "0020CC" => ["DigitalS", "DIGITAL SERVICES, LTD."],
      "0020CD" => ["HybridNe", "HYBRID NETWORKS, INC."],
      "0020CE" => ["LogicalD", "LOGICAL DESIGN GROUP, INC."],
      "0020CF" => ["TestMeas", "TEST & MEASUREMENT SYSTEMS INC"],
      "0020D0" => ["Versalyn", "VERSALYNX CORPORATION"],
      "0020D1" => ["Microcom", "MICROCOMPUTER SYSTEMS (M) SDN."],
      "0020D2" => ["RadDataC", "RAD DATA COMMUNICATIONS, LTD."],
      "0020D3" => ["OstOuest", "OST (OUEST STANDARD TELEMATIQU"],
      "0020D4" => ["Cabletro", "CABLETRON - ZEITTNET INC."],
      "0020D5" => ["Vipa", "VIPA GMBH"],
      "0020D6" => ["Breezeco", "BREEZECOM"],
      "0020D7" => ["JapanMin", "JAPAN MINICOMPUTER SYSTEMS CO., Ltd."],
      "0020D8" => ["NortelNe", "Nortel Networks"],
      "0020D9" => ["Panasoni", "PANASONIC TECHNOLOGIES, INC./MIECO-US"],
      "0020DA" => ["AlcatelN", "Alcatel North America ESD"],
      "0020DB" => ["XnetTech", "XNET TECHNOLOGY, INC."],
      "0020DC" => ["Densitro", "DENSITRON TAIWAN LTD."],
      "0020DD" => ["Cybertec", "Cybertec Pty Ltd"],
      "0020DE" => ["JapanDig", "JAPAN DIGITAL LABORAT\'Y CO.LTD"],
      "0020DF" => ["KyosanEl", "KYOSAN ELECTRIC MFG. CO., LTD."],
      "0020E0" => ["Actionte", "Actiontec Electronics, Inc."],
      "0020E1" => ["AlamarEl", "ALAMAR ELECTRONICS"],
      "0020E2" => ["Informat", "INFORMATION RESOURCE ENGINEERING"],
      "0020E3" => ["McdKenco", "MCD KENCOM CORPORATION"],
      "0020E4" => ["HsingTec", "HSING TECH ENTERPRISE CO., LTD"],
      "0020E5" => ["ApexData", "APEX DATA, INC."],
      "0020E6" => ["Lidkopin", "LIDKOPING MACHINE TOOLS AB"],
      "0020E7" => ["B&WNucle", "B&W NUCLEAR SERVICE COMPANY"],
      "0020E8" => ["Datatrek", "DATATREK CORPORATION"],
      "0020E9" => ["Dantel",""],
      "0020EA" => ["Efficien", "EFFICIENT NETWORKS, INC."],
      "0020EB" => ["Cincinna", "CINCINNATI MICROWAVE, INC."],
      "0020EC" => ["Techware", "TECHWARE SYSTEMS CORP."],
      "0020ED" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO., LTD."],
      "0020EE" => ["Gtech", "GTECH CORPORATION"],
      "0020EF" => ["Usc", "USC CORPORATION"],
      "0020F0" => ["Universa", "UNIVERSAL MICROELECTRONICS CO."],
      "0020F1" => ["AltosInd", "ALTOS INDIA LIMITED"],
      "0020F2" => ["Oracle", "Oracle Corporation"],
      "0020F3" => ["Raynet", "RAYNET CORPORATION"],
      "0020F4" => ["Spectrix", "SPECTRIX CORPORATION"],
      "0020F5" => ["Pandatel", "PANDATEL AG"],
      "0020F6" => ["NetTekAn", "NET TEK  AND KARLNET, INC."],
      "0020F7" => ["Cyberdat", "CYBERDATA CORPORATION"],
      "0020F8" => ["CarreraC", "CARRERA COMPUTERS, INC."],
      "0020F9" => ["Paralink", "PARALINK NETWORKS, INC."],
      "0020FA" => ["Gde", "GDE SYSTEMS, INC."],
      "0020FB" => ["OctelCom", "OCTEL COMMUNICATIONS CORP."],
      "0020FC" => ["Matrox",""],
      "0020FD" => ["ItvTechn", "ITV TECHNOLOGIES, INC."],
      "0020FE" => ["Topware/", "TOPWARE INC. / GRAND COMPUTER"],
      "0020FF" => ["Symmetri", "SYMMETRICAL TECHNOLOGIES"],
      "002100" => ["GemtekTe", "GemTek Technology Co., Ltd."],
      "002101" => ["Aplicaci", "Aplicaciones Electronicas Quasar (AEQ)"],
      "002102" => ["Updatelo", "UpdateLogic Inc."],
      "002103" => ["GhiElect", "GHI Electronics, LLC"],
      "002104" => ["GigasetC", "Gigaset Communications GmbH"],
      "002105" => ["Alcatel-", "Alcatel-Lucent"],
      "002106" => ["RimTesti", "RIM Testing Services"],
      "002107" => ["Seowonin", "Seowonintech Co Ltd."],
      "002108" => ["NokiaDan", "Nokia Danmark A/S"],
      "002109" => ["NokiaDan", "Nokia Danmark A/S"],
      "00210A" => ["Byd:Sign", "byd:sign Corporation"],
      "00210B" => ["GeminiTr", "GEMINI TRAZE RFID PVT. LTD."],
      "00210C" => ["Cymtec", "Cymtec Systems, Inc."],
      "00210D" => ["SamsinIn", "SAMSIN INNOTEC"],
      "00210E" => ["OrpakLTD", "Orpak Systems L.T.D."],
      "00210F" => ["Cernium", "Cernium Corp"],
      "002110" => ["Clearbox", "Clearbox Systems"],
      "002111" => ["Uniphone", "Uniphone Inc."],
      "002112" => ["WiscomSy", "WISCOM SYSTEM CO.,LTD"],
      "002113" => ["Padtec", "Padtec S/A"],
      "002114" => ["HylabTec", "Hylab Technology Inc."],
      "002115" => ["PhyweSys", "PHYWE Systeme GmbH & Co. KG"],
      "002116" => ["Transcon", "Transcon Electronic Systems, spol. s r. o."],
      "002117" => ["Tellord",""],
      "002118" => ["AthenaTe", "Athena Tech, Inc."],
      "002119" => ["SamsungE", "Samsung Electro-Mechanics"],
      "00211A" => ["Lintech", "LInTech Corporation"],
      "00211B" => ["Cisco", "Cisco Systems"],
      "00211C" => ["Cisco", "Cisco Systems"],
      "00211D" => ["Dataline", "Dataline AB"],
      "00211E" => ["Motorola", "Motorola Mobility, Inc."],
      "00211F" => ["Shinsung", "SHINSUNG DELTATECH CO.,LTD."],
      "002120" => ["SequelTe", "Sequel Technologies"],
      "002121" => ["Vrmagic", "VRmagic GmbH"],
      "002122" => ["Chip-Pro", "Chip-pro Ltd."],
      "002123" => ["AerosatA", "Aerosat Avionics"],
      "002124" => ["Optos", "Optos Plc"],
      "002125" => ["KukJeTon", "KUK JE TONG SHIN Co.,LTD"],
      "002126" => ["Shenzhen", "Shenzhen Torch Equipment Co., Ltd."],
      "002127" => ["Tp-LinkT", "TP-LINK Technology Co., Ltd."],
      "002128" => ["Oracle", "Oracle Corporation"],
      "002129" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "00212A" => ["Audiovox", "Audiovox Corporation"],
      "00212B" => ["MsaAuer", "MSA Auer"],
      "00212C" => ["Semindia", "SemIndia System Private Limited"],
      "00212D" => ["Scimolex", "SCIMOLEX CORPORATION"],
      "00212E" => ["Dresden-", "dresden-elektronik"],
      "00212F" => ["PhoebeMi", "Phoebe Micro Inc."],
      "002130" => ["KeicoHig", "Keico Hightech Inc."],
      "002131" => ["Blynke", "Blynke Inc."],
      "002132" => ["Mastercl", "Masterclock, Inc."],
      "002133" => ["Building", "Building B, Inc"],
      "002134" => ["Brandywi", "Brandywine Communications"],
      "002135" => ["Alcatel-", "ALCATEL-LUCENT"],
      "002136" => ["Motorola", "Motorola Mobility, Inc."],
      "002137" => ["BayContr", "Bay Controls, LLC"],
      "002138" => ["Cepheid",""],
      "002139" => ["Escherlo", "Escherlogic Inc."],
      "00213A" => ["Winchest", "Winchester Systems Inc."],
      "00213B" => ["Berkshir", "Berkshire Products, Inc"],
      "00213C" => ["Aliphcom",""],
      "00213D" => ["Cermetek", "Cermetek Microelectronics, Inc."],
      "00213E" => ["Tomtom",""],
      "00213F" => ["A-TeamTe", "A-Team Technology Ltd."],
      "002140" => ["EnTechno", "EN Technologies Inc."],
      "002141" => ["Radlive",""],
      "002142" => ["Advanced", "Advanced Control Systems doo"],
      "002143" => ["Motorola", "Motorola Mobility, Inc."],
      "002144" => ["SsTeleco", "SS Telecoms"],
      "002145" => ["Semptian", "Semptian Technologies Ltd."],
      "002146" => ["SciTechn", "SCI Technology"],
      "002147" => ["Nintendo", "Nintendo Co., Ltd."],
      "002148" => ["KacoSola", "Kaco Solar Korea"],
      "002149" => ["ChinaDah", "China Daheng Group ,Inc."],
      "00214A" => ["PixelVel", "Pixel Velocity, Inc"],
      "00214B" => ["Shenzhen", "Shenzhen HAMP Science & Technology Co.,Ltd"],
      "00214C" => ["SamsungE", "SAMSUNG ELECTRONICS CO., LTD."],
      "00214D" => ["Guangzho", "Guangzhou Skytone Transmission Technology Com. Ltd."],
      "00214E" => ["GsYuasaP", "GS Yuasa Power Supply Ltd."],
      "00214F" => ["AlpsElec", "ALPS Electric Co., Ltd"],
      "002150" => ["EyeviewE", "EYEVIEW ELECTRONICS"],
      "002151" => ["Millinet", "Millinet Co., Ltd."],
      "002152" => ["GeneralS", "General Satellite Research & Development Limited"],
      "002153" => ["Seamicro", "SeaMicro Inc."],
      "002154" => ["D-TacqSo", "D-TACQ Solutions Ltd"],
      "002155" => ["Cisco", "Cisco Systems"],
      "002156" => ["Cisco", "Cisco Systems"],
      "002157" => ["National", "National Datacast, Inc."],
      "002158" => ["StyleFly", "Style Flying Technology Co."],
      "002159" => ["JuniperN", "Juniper Networks"],
      "00215A" => ["Hewlett-", "Hewlett-Packard Company"],
      "00215B" => ["Inotive",""],
      "00215C" => ["IntelCor", "Intel Corporate"],
      "00215D" => ["IntelCor", "Intel Corporate"],
      "00215E" => ["Ibm", "IBM Corp"],
      "00215F" => ["Ihse", "IHSE GmbH"],
      "002160" => ["HideaSol", "Hidea Solutions Co. Ltd."],
      "002161" => ["Yournet", "Yournet Inc."],
      "002162" => ["Nortel",""],
      "002163" => ["AskeyCom", "ASKEY COMPUTER CORP"],
      "002164" => ["SpecialD", "Special Design Bureau for Seismic Instrumentation"],
      "002165" => ["Presstek", "Presstek Inc."],
      "002166" => ["Novatel", "NovAtel Inc."],
      "002167" => ["HwaJinT&", "HWA JIN T&I Corp."],
      "002168" => ["IveiaLlc", "iVeia, LLC"],
      "002169" => ["Prologix", "Prologix, LLC."],
      "00216A" => ["IntelCor", "Intel Corporate"],
      "00216B" => ["IntelCor", "Intel Corporate"],
      "00216C" => ["Odva",""],
      "00216D" => ["Soltech", "Soltech Co., Ltd."],
      "00216E" => ["Function", "Function ATI (Huizhou) Telecommunications Co., Ltd."],
      "00216F" => ["Symcom", "SymCom, Inc."],
      "002170" => ["Dell", "Dell Inc"],
      "002171" => ["WesungTn", "Wesung TNC Co., Ltd."],
      "002172" => ["Seoultek", "Seoultek Valley"],
      "002173" => ["IonTorre", "Ion Torrent Systems, Inc."],
      "002174" => ["AvalanWi", "AvaLAN Wireless"],
      "002175" => ["PacificS", "Pacific Satellite International Ltd."],
      "002176" => ["YmaxTele", "YMax Telecom Ltd."],
      "002177" => ["WLGoreAs", "W. L. Gore & Associates"],
      "002178" => ["Matusche", "Matuschek Messtechnik GmbH"],
      "002179" => ["Iogear", "IOGEAR, Inc."],
      "00217A" => ["SejinEle", "Sejin Electron, Inc."],
      "00217B" => ["Bastec", "Bastec AB"],
      "00217C" => ["2wire",""],
      "00217D" => ["PyxisSRL", "PYXIS S.R.L."],
      "00217E" => ["TelitCom", "Telit Communication s.p.a"],
      "00217F" => ["IntracoT", "Intraco Technology Pte Ltd"],
      "002180" => ["Motorola", "Motorola Mobility, Inc."],
      "002181" => ["Si2Micro", "Si2 Microsystems Limited"],
      "002182" => ["Sandlink", "SandLinks Systems, Ltd."],
      "002183" => ["VatechHy", "VATECH HYDRO"],
      "002184" => ["Powersof", "POWERSOFT SRL"],
      "002185" => ["Micro-St", "MICRO-STAR INT\'L CO.,LTD."],
      "002186" => ["Universa", "Universal Global Scientific Industrial Co., Ltd"],
      "002187" => ["Imacs", "Imacs GmbH"],
      "002188" => ["Emc", "EMC Corporation"],
      "002189" => ["Apptech", "AppTech, Inc."],
      "00218A" => ["Electron", "Electronic Design and Manufacturing Company"],
      "00218B" => ["WesconTe", "Wescon Technology, Inc."],
      "00218C" => ["Topcontr", "TopControl GMBH"],
      "00218D" => ["ApRouter", "AP Router Ind. Eletronica LTDA"],
      "00218E" => ["Mekics", "MEKICS CO., LTD."],
      "00218F" => ["Avantgar", "Avantgarde Acoustic Lautsprechersysteme GmbH"],
      "002190" => ["GoliathS", "Goliath Solutions"],
      "002191" => ["D-Link", "D-Link Corporation"],
      "002192" => ["BaodingG", "Baoding Galaxy Electronic Technology  Co.,Ltd"],
      "002193" => ["Videofon", "Videofon MV"],
      "002194" => ["PingComm", "Ping Communication"],
      "002195" => ["GwdMedia", "GWD Media Limited"],
      "002196" => ["TelseySP", "Telsey  S.p.A."],
      "002197" => ["Elitegro", "ELITEGROUP COMPUTER SYSTEM"],
      "002198" => ["ThaiRadi", "Thai Radio Co, LTD"],
      "002199" => ["Vacon", "Vacon Plc"],
      "00219A" => ["Cambridg", "Cambridge Visual Networks Ltd"],
      "00219B" => ["Dell", "Dell Inc"],
      "00219C" => ["Honeywld", "Honeywld Technology Corp."],
      "00219D" => ["AdesysBv", "Adesys BV"],
      "00219E" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "00219F" => ["SatelOy", "SATEL OY"],
      "0021A0" => ["Cisco", "Cisco Systems"],
      "0021A1" => ["Cisco", "Cisco Systems"],
      "0021A2" => ["Eke-Elec", "EKE-Electronics Ltd."],
      "0021A3" => ["Micromin", "Micromint"],
      "0021A4" => ["DbiiNetw", "Dbii Networks"],
      "0021A5" => ["Erlphase", "ERLPhase Power Technologies Ltd."],
      "0021A6" => ["Videotec", "Videotec Spa"],
      "0021A7" => ["HantleSy", "Hantle System Co., Ltd."],
      "0021A8" => ["Telephon", "Telephonics Corporation"],
      "0021A9" => ["Mobilink", "Mobilink Telecom Co.,Ltd"],
      "0021AA" => ["NokiaDan", "Nokia Danmark A/S"],
      "0021AB" => ["NokiaDan", "Nokia Danmark A/S"],
      "0021AC" => ["Infrared", "Infrared Integrated Systems Ltd"],
      "0021AD" => ["NordicId", "Nordic ID Oy"],
      "0021AE" => ["Alcatel-", "ALCATEL-LUCENT FRANCE - WTD"],
      "0021AF" => ["RadioFre", "Radio Frequency Systems"],
      "0021B0" => ["TycoTele", "Tyco Telecommunications"],
      "0021B1" => ["DigitalS", "DIGITAL SOLUTIONS LTD"],
      "0021B2" => ["Fiberbla", "Fiberblaze A/S"],
      "0021B3" => ["RossCont", "Ross Controls"],
      "0021B4" => ["AproMedi", "APRO MEDIA CO., LTD"],
      "0021B5" => ["VyroGame", "Vyro Games Limited"],
      "0021B6" => ["TriactaP", "Triacta Power Technologies Inc."],
      "0021B7" => ["LexmarkI", "Lexmark International Inc."],
      "0021B8" => ["Inphi", "Inphi Corporation"],
      "0021B9" => ["Universa", "Universal Devices Inc."],
      "0021BA" => ["TexasIns", "Texas Instruments"],
      "0021BB" => ["RikenKei", "Riken Keiki Co., Ltd."],
      "0021BC" => ["ZalaComp", "ZALA COMPUTER"],
      "0021BD" => ["Nintendo", "Nintendo Co., Ltd."],
      "0021BE" => ["CiscoSer", "Cisco, Service Provider Video Technology Group"],
      "0021BF" => ["HitachiH", "Hitachi High-Tech Control Systems Corporation"],
      "0021C0" => ["MobileAp", "Mobile Appliance, Inc."],
      "0021C1" => ["AbbOy/Di", "ABB Oy / Distribution Automation"],
      "0021C2" => ["GlCommun", "GL Communications Inc"],
      "0021C3" => ["CornellC", "CORNELL Communications, Inc."],
      "0021C4" => ["Consiliu", "Consilium AB"],
      "0021C5" => ["3dsp", "3DSP Corp"],
      "0021C6" => ["CsjGloba", "CSJ Global, Inc."],
      "0021C7" => ["Russound",""],
      "0021C8" => ["LohuisNe", "LOHUIS Networks"],
      "0021C9" => ["WavecomA", "Wavecom Asia Pacific Limited"],
      "0021CA" => ["ArtSyste", "ART System Co., Ltd."],
      "0021CB" => ["SmsTecno", "SMS TECNOLOGIA ELETRONICA LTDA"],
      "0021CC" => ["Flextron", "Flextronics International"],
      "0021CD" => ["Livetv",""],
      "0021CE" => ["Ntc-Metr", "NTC-Metrotek"],
      "0021CF" => ["CryptoGr", "The Crypto Group"],
      "0021D0" => ["GlobalDi", "Global Display Solutions Spa"],
      "0021D1" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "0021D2" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "0021D3" => ["BocomSec", "BOCOM SECURITY(ASIA PACIFIC) LIMITED"],
      "0021D4" => ["VollmerW", "Vollmer Werke GmbH"],
      "0021D5" => ["X2e", "X2E GmbH"],
      "0021D6" => ["LxiConso", "LXI Consortium"],
      "0021D7" => ["Cisco", "Cisco Systems"],
      "0021D8" => ["Cisco", "Cisco Systems"],
      "0021D9" => ["Sekonic", "SEKONIC CORPORATION"],
      "0021DA" => ["Automati", "Automation Products Group Inc."],
      "0021DB" => ["Santachi", "Santachi Video Technology (Shenzhen) Co., Ltd."],
      "0021DC" => ["Tecnoala", "TECNOALARM S.r.l."],
      "0021DD" => ["Northsta", "Northstar Systems Corp"],
      "0021DE" => ["FireproW", "Firepro Wireless"],
      "0021DF" => ["MartinCh", "Martin Christ GmbH"],
      "0021E0" => ["Commagil", "CommAgility Ltd"],
      "0021E1" => ["NortelNe", "Nortel Networks"],
      "0021E2" => ["Creative", "Creative Electronic GmbH"],
      "0021E3" => ["Serialte", "SerialTek LLC"],
      "0021E4" => ["I-Win",""],
      "0021E5" => ["DisplayS", "Display Solution AG"],
      "0021E6" => ["Starligh", "Starlight Video Limited"],
      "0021E7" => ["Informat", "Informatics Services Corporation"],
      "0021E8" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "0021E9" => ["Apple", "Apple, Inc"],
      "0021EA" => ["Bystroni", "Bystronic Laser AG"],
      "0021EB" => ["EspLlc", "ESP SYSTEMS, LLC"],
      "0021EC" => ["Solutron", "Solutronic GmbH"],
      "0021ED" => ["Telegesi", "Telegesis"],
      "0021EE" => ["FullSpec", "Full Spectrum Inc."],
      "0021EF" => ["Kapsys",""],
      "0021F0" => ["Ew3Techn", "EW3 Technologies LLC"],
      "0021F1" => ["TutusDat", "Tutus Data AB"],
      "0021F2" => ["Easy3cal", "EASY3CALL Technology Limited"],
      "0021F3" => ["Si14", "Si14 SpA"],
      "0021F4" => ["Inrange", "INRange Systems, Inc"],
      "0021F5" => ["WesternE", "Western Engravers Supply, Inc."],
      "0021F6" => ["Oracle", "Oracle Corporation"],
      "0021F7" => ["Procurve", "ProCurve Networking by HP"],
      "0021F8" => ["Enseo", "Enseo, Inc."],
      "0021F9" => ["WirecomT", "WIRECOM Technologies"],
      "0021FA" => ["A4spTech", "A4SP Technologies Ltd."],
      "0021FB" => ["LgElectr", "LG Electronics"],
      "0021FC" => ["NokiaDan", "Nokia Danmark A/S"],
      "0021FD" => ["DstaSL", "DSTA S.L."],
      "0021FE" => ["NokiaDan", "Nokia Danmark A/S"],
      "0021FF" => ["CyfrowyP", "Cyfrowy Polsat SA"],
      "002200" => ["Ibm", "IBM Corp"],
      "002201" => ["AksysNet", "Aksys Networks Inc"],
      "002202" => ["ExcitoEl", "Excito Elektronik i Skane AB"],
      "002203" => ["Glensoun", "Glensound Electronics Ltd"],
      "002204" => ["Koratek",""],
      "002205" => ["WelinkSo", "WeLink Solutions, Inc."],
      "002206" => ["Cyberdyn", "Cyberdyne Inc."],
      "002207" => ["IntenoBr", "Inteno Broadband Technology AB"],
      "002208" => ["Certicom", "Certicom Corp"],
      "002209" => ["OmronHea", "Omron Healthcare Co., Ltd"],
      "00220A" => ["Onlive", "OnLive, Inc"],
      "00220B" => ["National", "National Source Coding Center"],
      "00220C" => ["Cisco", "Cisco Systems"],
      "00220D" => ["Cisco", "Cisco Systems"],
      "00220E" => ["IndigoSe", "Indigo Security Co., Ltd."],
      "00220F" => ["MocaMult", "MoCA (Multimedia over Coax Alliance)"],
      "002210" => ["Motorola", "Motorola Mobility, Inc."],
      "002211" => ["Rohati", "Rohati Systems"],
      "002212" => ["CaiNetwo", "CAI Networks, Inc."],
      "002213" => ["Pci", "PCI CORPORATION"],
      "002214" => ["RinnaiKo", "RINNAI KOREA"],
      "002215" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "002216" => ["Shibaura", "SHIBAURA VENDING MACHINE CORPORATION"],
      "002217" => ["NeatElec", "Neat Electronics"],
      "002218" => ["Verivue", "Verivue Inc."],
      "002219" => ["Dell", "Dell Inc"],
      "00221A" => ["AudioPre", "Audio Precision"],
      "00221B" => ["Morega", "Morega Systems"],
      "00221C" => ["Private",""],
      "00221D" => ["Freegene", "Freegene Technology LTD"],
      "00221E" => ["MediaDev", "Media Devices Co., Ltd."],
      "00221F" => ["EsangTec", "eSang Technologies Co., Ltd."],
      "002220" => ["MitacTec", "Mitac Technology Corp"],
      "002221" => ["ItohDenk", "ITOH DENKI CO,LTD."],
      "002222" => ["Schaffne", "Schaffner Deutschland GmbH"],
      "002223" => ["Timekeep", "TimeKeeping Systems, Inc."],
      "002224" => ["GoodWill", "Good Will Instrument Co., Ltd."],
      "002225" => ["ThalesAv", "Thales Avionics Ltd"],
      "002226" => ["Avaak", "Avaak, Inc."],
      "002227" => ["Uv-Elect", "uv-electronic GmbH"],
      "002228" => ["BreezeIn", "Breeze Innovations Ltd."],
      "002229" => ["Compumed", "Compumedics Ltd"],
      "00222A" => ["Soundear", "SoundEar A/S"],
      "00222B" => ["Nucomm", "Nucomm, Inc."],
      "00222C" => ["Ceton", "Ceton Corp"],
      "00222D" => ["SmcNetwo", "SMC Networks Inc."],
      "00222E" => ["Maintech", "maintech GmbH"],
      "00222F" => ["OpenGrid", "Open Grid Computing, Inc."],
      "002230" => ["Futurelo", "FutureLogic Inc."],
      "002231" => ["Smt&C", "SMT&C Co., Ltd."],
      "002232" => ["DesignDe", "Design Design Technology Ltd"],
      "002233" => ["AdbBroad", "ADB Broadband Italia"],
      "002234" => ["Corventi", "Corventis Inc."],
      "002235" => ["Strukton", "Strukton Systems bv"],
      "002236" => ["VectorSp", "VECTOR SP. Z O.O."],
      "002237" => ["Shinhint", "Shinhint Group"],
      "002238" => ["Logiplus",""],
      "002239" => ["IndianaL", "Indiana Life Sciences Incorporated"],
      "00223A" => ["Scientif", "Scientific Atlanta, Cisco SPVT Group"],
      "00223B" => ["Communic", "Communication Networks, LLC"],
      "00223C" => ["RatioEnt", "RATIO Entwicklungen GmbH"],
      "00223D" => ["JumpgenL", "JumpGen Systems, LLC"],
      "00223E" => ["Irtrans", "IRTrans GmbH"],
      "00223F" => ["Netgear", "Netgear Inc."],
      "002240" => ["Universa", "Universal Telecom S/A"],
      "002241" => ["Apple", "Apple, Inc"],
      "002242" => ["Alacron", "Alacron Inc."],
      "002243" => ["Azurewav", "AzureWave Technologies, Inc."],
      "002244" => ["ChengduL", "Chengdu Linkon Communications Device Co., Ltd"],
      "002245" => ["LeineLin", "Leine & Linde AB"],
      "002246" => ["EvocInte", "Evoc Intelligent Technology Co.,Ltd."],
      "002247" => ["DacEngin", "DAC ENGINEERING CO., LTD."],
      "002248" => ["Microsof", "Microsoft Corporation"],
      "002249" => ["HomeMult", "HOME MULTIENERGY SL"],
      "00224A" => ["Raylase", "RAYLASE AG"],
      "00224B" => ["AirtechT", "AIRTECH TECHNOLOGIES, INC."],
      "00224C" => ["Nintendo", "Nintendo Co., Ltd."],
      "00224D" => ["MitacInt", "MITAC INTERNATIONAL CORP."],
      "00224E" => ["Seenergy", "SEEnergy Corp."],
      "00224F" => ["ByzoroNe", "Byzoro Networks Ltd."],
      "002250" => ["PointSix", "Point Six Wireless, LLC"],
      "002251" => ["Lumasens", "Lumasense Technologies"],
      "002252" => ["ZollLife", "ZOLL Lifecor Corporation"],
      "002253" => ["Entorian", "Entorian Technologies"],
      "002254" => ["BigelowA", "Bigelow Aerospace"],
      "002255" => ["Cisco", "Cisco Systems"],
      "002256" => ["Cisco", "Cisco Systems"],
      "002257" => ["3comEuro", "3Com Europe Ltd"],
      "002258" => ["TaiyoYud", "Taiyo Yuden Co., Ltd."],
      "002259" => ["Guangzho", "Guangzhou New Postcom Equipment Co.,Ltd."],
      "00225A" => ["GardeSec", "Garde Security AB"],
      "00225B" => ["Teradici", "Teradici Corporation"],
      "00225C" => ["Multimed", "Multimedia & Communication Technology"],
      "00225D" => ["Digicabl", "Digicable Network India Pvt. Ltd."],
      "00225E" => ["UwinTech", "Uwin Technologies Co.,LTD"],
      "00225F" => ["LiteonTe", "Liteon Technology Corporation"],
      "002260" => ["Afreey", "AFREEY Inc."],
      "002261" => ["Frontier", "Frontier Silicon Ltd"],
      "002262" => ["BepMarin", "BEP Marine"],
      "002263" => ["KoosTech", "Koos Technical Services, Inc."],
      "002264" => ["Hewlett-", "Hewlett-Packard Company"],
      "002265" => ["NokiaDan", "Nokia Danmark A/S"],
      "002266" => ["NokiaDan", "Nokia Danmark A/S"],
      "002267" => ["NortelNe", "Nortel Networks"],
      "002268" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "002269" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "00226A" => ["Honeywel", "Honeywell"],
      "00226B" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "00226C" => ["Linkspri", "LinkSprite Technologies, Inc."],
      "00226D" => ["Shenzhen", "Shenzhen GIEC Electronics Co., Ltd."],
      "00226E" => ["GowellEl", "Gowell Electronic Limited"],
      "00226F" => ["3onedata", "3onedata Technology Co. Ltd."],
      "002270" => ["AbkNorth", "ABK North America, LLC"],
      "002271" => ["JA.GerCo", "JA.ger Computergesteuerte Messtechnik GmbH"],
      "002272" => ["American", "American Micro-Fuel Device Corp."],
      "002273" => ["Techway",""],
      "002274" => ["Familyph", "FamilyPhone AB"],
      "002275" => ["BelkinIn", "Belkin International, Inc."],
      "002276" => ["TripleEy", "Triple EYE B.V."],
      "002277" => ["NecAustr", "NEC Australia Pty Ltd"],
      "002278" => ["Shenzhen", "Shenzhen  Tongfang Multimedia  Technology Co.,Ltd."],
      "002279" => ["NipponCo", "Nippon Conlux Co., Ltd."],
      "00227A" => ["TelecomD", "Telecom Design"],
      "00227B" => ["ApogeeLa", "Apogee Labs, Inc."],
      "00227C" => ["WooriSmt", "Woori SMT Co.,ltd"],
      "00227D" => ["YeData", "YE DATA INC."],
      "00227E" => ["Chengdu3", "Chengdu 30Kaitian Communication Industry Co.Ltd"],
      "00227F" => ["RuckusWi", "Ruckus Wireless"],
      "002280" => ["A2bElect", "A2B Electronics AB"],
      "002281" => ["Daintree", "Daintree Networks Inc"],
      "002282" => ["8086", "8086 Limited"],
      "002283" => ["JuniperN", "Juniper Networks"],
      "002284" => ["DesayA&V", "DESAY A&V SCIENCE AND TECHNOLOGY CO.,LTD"],
      "002285" => ["NomusCom", "NOMUS COMM SYSTEMS"],
      "002286" => ["Astron",""],
      "002287" => ["TitanWir", "Titan Wireless LLC"],
      "002288" => ["Sagrad", "Sagrad, Inc."],
      "002289" => ["Optosecu", "Optosecurity Inc."],
      "00228A" => ["Teratron", "Teratronik elektronische systeme gmbh"],
      "00228B" => ["Kensingt", "Kensington Computer Products Group"],
      "00228C" => ["PhotonEu", "Photon Europe GmbH"],
      "00228D" => ["GbsLabor", "GBS Laboratories LLC"],
      "00228E" => ["Tv-Numer", "TV-NUMERIC"],
      "00228F" => ["Cnrs",""],
      "002290" => ["Cisco", "Cisco Systems"],
      "002291" => ["Cisco", "Cisco Systems"],
      "002292" => ["Cinetal",""],
      "002293" => ["Zte", "ZTE Corporation"],
      "002294" => ["Kyocera", "Kyocera Corporation"],
      "002295" => ["SgmTechn", "SGM Technology for lighting spa"],
      "002296" => ["Linowave", "LinoWave Corporation"],
      "002297" => ["XmosSemi", "XMOS Semiconductor"],
      "002298" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "002299" => ["Seamicro", "SeaMicro Inc."],
      "00229A" => ["Lastar", "Lastar, Inc."],
      "00229B" => ["Averlogi", "AverLogic Technologies, Inc."],
      "00229C" => ["VerismoN", "Verismo Networks Inc"],
      "00229D" => ["Pyung-Hw", "PYUNG-HWA IND.CO.,LTD"],
      "00229E" => ["SocialAi", "Social Aid Research Co., Ltd."],
      "00229F" => ["SensysTr", "Sensys Traffic AB"],
      "0022A0" => ["Delphi", "Delphi Corporation"],
      "0022A1" => ["HuaweiSy", "Huawei Symantec Technologies Co.,Ltd."],
      "0022A2" => ["XtramusT", "Xtramus Technologies"],
      "0022A3" => ["Californ", "California Eastern Laboratories"],
      "0022A4" => ["2wire",""],
      "0022A5" => ["TexasIns", "Texas Instruments"],
      "0022A6" => ["SonyComp", "Sony Computer Entertainment America"],
      "0022A7" => ["TycoElec", "Tyco Electronics AMP GmbH"],
      "0022A8" => ["OumanFin", "Ouman Finland Oy"],
      "0022A9" => ["LgElectr", "LG Electronics Inc"],
      "0022AA" => ["Nintendo", "Nintendo Co., Ltd."],
      "0022AB" => ["Shenzhen", "Shenzhen Turbosight Technology Ltd"],
      "0022AC" => ["Hangzhou", "Hangzhou Siyuan Tech. Co., Ltd"],
      "0022AD" => ["TelesisT", "TELESIS TECHNOLOGIES, INC."],
      "0022AE" => ["Mattel", "Mattel Inc."],
      "0022AF" => ["SafetyVi", "Safety Vision"],
      "0022B0" => ["D-Link", "D-Link Corporation"],
      "0022B1" => ["Elbit", "Elbit Systems"],
      "0022B2" => ["4rfCommu", "4RF Communications Ltd"],
      "0022B3" => ["SeiSPA", "Sei S.p.A."],
      "0022B4" => ["Motorola", "Motorola Mobility, Inc."],
      "0022B5" => ["Novita",""],
      "0022B6" => ["Superflo", "Superflow Technologies Group"],
      "0022B7" => ["GssGrund", "GSS Grundig SAT-Systems GmbH"],
      "0022B8" => ["Norcott",""],
      "0022B9" => ["Analogix", "Analogix Seminconductor, Inc"],
      "0022BA" => ["HuthElek", "HUTH Elektronik Systeme GmbH"],
      "0022BB" => ["Beyerdyn", "beyerdynamic GmbH & Co. KG"],
      "0022BC" => ["JdsuFran", "JDSU France SAS"],
      "0022BD" => ["Cisco", "Cisco Systems"],
      "0022BE" => ["Cisco", "Cisco Systems"],
      "0022BF" => ["SieampGr", "SieAmp Group of Companies"],
      "0022C0" => ["Shenzhen", "Shenzhen Forcelink Electronic Co, Ltd"],
      "0022C1" => ["ActiveSt", "Active Storage Inc."],
      "0022C2" => ["ProviewE", "Proview Eletronica do Brasil LTDA"],
      "0022C3" => ["ZeeportT", "Zeeport Technology Inc."],
      "0022C4" => ["Epro", "epro GmbH"],
      "0022C5" => ["Inforson", "INFORSON Co,Ltd."],
      "0022C6" => ["Sutus", "Sutus Inc"],
      "0022C7" => ["SeggerMi", "SEGGER Microcontroller GmbH & Co. KG"],
      "0022C8" => ["AppliedI", "Applied Instruments"],
      "0022C9" => ["LenordBa", "Lenord, Bauer & Co GmbH"],
      "0022CA" => ["AnvizBio", "Anviz Biometric Tech. Co., Ltd."],
      "0022CB" => ["Ionodes", "IONODES Inc."],
      "0022CC" => ["Scilog", "SciLog, Inc."],
      "0022CD" => ["AredTech", "Ared Technology Co., Ltd."],
      "0022CE" => ["CiscoSer", "Cisco, Service Provider Video Technology Group"],
      "0022CF" => ["PlanexCo", "PLANEX Communications INC"],
      "0022D0" => ["PolarEle", "Polar Electro Oy"],
      "0022D1" => ["Albrecht", "Albrecht Jung GmbH & Co. KG"],
      "0022D2" => ["AllEarth", "All Earth Comercio de Eletronicos LTDA."],
      "0022D3" => ["Hub-Tech",""],
      "0022D4" => ["Comworth", "ComWorth Co., Ltd."],
      "0022D5" => ["EatonEle", "Eaton Corp. Electrical Group Data Center Solutions - Pulizzi"],
      "0022D6" => ["Cypak", "Cypak AB"],
      "0022D7" => ["Nintendo", "Nintendo Co., Ltd."],
      "0022D8" => ["Shenzhen", "Shenzhen GST Security and Safety Technology Limited"],
      "0022D9" => ["FortexIn", "Fortex Industrial Ltd."],
      "0022DA" => ["AnatekLl", "ANATEK, LLC"],
      "0022DB" => ["Translog", "Translogic Corporation"],
      "0022DC" => ["VigilHea", "Vigil Health Solutions Inc."],
      "0022DD" => ["Protecta", "Protecta Electronics Ltd"],
      "0022DE" => ["OppoDigi", "OPPO Digital, Inc."],
      "0022DF" => ["TamuzMon", "TAMUZ Monitors"],
      "0022E0" => ["Atlantic", "Atlantic Software Technologies S.r.L."],
      "0022E1" => ["ZortLabs", "ZORT Labs, LLC."],
      "0022E2" => ["WabtecTr", "WABTEC Transit Division"],
      "0022E3" => ["Amerigon",""],
      "0022E4" => ["ApassTec", "APASS TECHNOLOGY CO., LTD."],
      "0022E5" => ["Fisher-R", "Fisher-Rosemount Systems Inc."],
      "0022E6" => ["Intellig", "Intelligent Data"],
      "0022E7" => ["WpsParki", "WPS Parking Systems"],
      "0022E8" => ["Applitio", "Applition Co., Ltd."],
      "0022E9" => ["Provisio", "ProVision Communications"],
      "0022EA" => ["Rustelco", "Rustelcom Inc."],
      "0022EB" => ["DataResp", "Data Respons A/S"],
      "0022EC" => ["IdealbtT", "IDEALBT TECHNOLOGY CORPORATION"],
      "0022ED" => ["TsiPower", "TSI Power Corporation"],
      "0022EE" => ["AlgoComm", "Algo Communication Products Ltd"],
      "0022EF" => ["IbisTekL", "Ibis Tek, LLC"],
      "0022F0" => ["3GreensA", "3 Greens Aviation Limited"],
      "0022F1" => ["Private",""],
      "0022F2" => ["Sunpower", "SunPower Corp"],
      "0022F3" => ["Sharp", "SHARP CORPORATION"],
      "0022F4" => ["AmpakTec", "AMPAK Technology, Inc."],
      "0022F5" => ["Advanced", "Advanced Realtime Tracking GmbH"],
      "0022F6" => ["Syracuse", "Syracuse Research Corporation"],
      "0022F7" => ["Conceptr", "Conceptronic"],
      "0022F8" => ["PimaElec", "PIMA Electronic Systems Ltd."],
      "0022F9" => ["PollinEl", "Pollin Electronic GmbH"],
      "0022FA" => ["IntelCor", "Intel Corporate"],
      "0022FB" => ["IntelCor", "Intel Corporate"],
      "0022FC" => ["NokiaDan", "Nokia Danmark A/S"],
      "0022FD" => ["NokiaDan", "Nokia Danmark A/S"],
      "0022FE" => ["Micropro", "Microprocessor Designs Inc"],
      "0022FF" => ["NivisLlc", "NIVIS LLC"],
      "002300" => ["CayeeCom", "Cayee Computer Ltd."],
      "002301" => ["WitronTe", "Witron Technology Limited"],
      "002302" => ["CobaltDi", "Cobalt Digital, Inc."],
      "002303" => ["Lite-OnI", "LITE-ON IT Corporation"],
      "002304" => ["Cisco", "Cisco Systems"],
      "002305" => ["Cisco", "Cisco Systems"],
      "002306" => ["AlpsElec", "ALPS Electric Co., Ltd"],
      "002307" => ["FutureIn", "FUTURE INNOVATION TECH CO.,LTD"],
      "002308" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "002309" => ["JanamTec", "Janam Technologies LLC"],
      "00230A" => ["Arburg", "ARBURG GmbH & Co KG"],
      "00230B" => ["Motorola", "Motorola Mobility, Inc."],
      "00230C" => ["CloverEl", "CLOVER ELECTRONICS CO.,LTD."],
      "00230D" => ["NortelNe", "Nortel Networks"],
      "00230E" => ["Gorba", "Gorba AG"],
      "00230F" => ["HirschEl", "Hirsch Electronics Corporation"],
      "002310" => ["LncTechn", "LNC Technology Co., Ltd."],
      "002311" => ["Gloscom", "Gloscom Co., Ltd."],
      "002312" => ["Apple", "Apple, Inc"],
      "002313" => ["QoolTech", "Qool Technologies Ltd."],
      "002314" => ["IntelCor", "Intel Corporate"],
      "002315" => ["IntelCor", "Intel Corporate"],
      "002316" => ["KisanEle", "KISAN ELECTRONICS CO"],
      "002317" => ["Lasercra", "Lasercraft Inc"],
      "002318" => ["Toshiba",""],
      "002319" => ["SieloxLl", "Sielox LLC"],
      "00231A" => ["Itf", "ITF Co., Ltd."],
      "00231B" => ["DanaherM", "Danaher Motion - Kollmorgen"],
      "00231C" => ["Fourier", "Fourier Systems Ltd."],
      "00231D" => ["Deltacom", "Deltacom Electronics Ltd"],
      "00231E" => ["CezzerMu", "Cezzer Multimedia Technologies"],
      "00231F" => ["GuangdaE", "Guangda Electronic & Telecommunication Technology Development Co., Ltd."],
      "002320" => ["NiciraNe", "Nicira Networks"],
      "002321" => ["AvitechI", "Avitech International Corp"],
      "002322" => ["KissTekn", "KISS Teknical Solutions, Inc."],
      "002323" => ["ZylinAs", "Zylin AS"],
      "002324" => ["G-ProCom", "G-PRO COMPUTER"],
      "002325" => ["Iolan", "IOLAN Holding"],
      "002326" => ["Fujitsu", "Fujitsu Limited"],
      "002327" => ["ShouyoEl", "Shouyo Electronics CO., LTD"],
      "002328" => ["AlconTel", "ALCON TELECOMMUNICATIONS CO., LTD."],
      "002329" => ["Ddrdrive", "DDRdrive LLC"],
      "00232A" => ["EonasIt-", "eonas IT-Beratung und -Entwicklung GmbH"],
      "00232B" => ["Ird", "IRD A/S"],
      "00232C" => ["Senticar", "Senticare"],
      "00232D" => ["Sandforc", "SandForce"],
      "00232E" => ["KedahEle", "Kedah Electronics Engineering, LLC"],
      "00232F" => ["Advanced", "Advanced Card Systems Ltd."],
      "002330" => ["Dizipia", "DIZIPIA, INC."],
      "002331" => ["Nintendo", "Nintendo Co., Ltd."],
      "002332" => ["Apple", "Apple, Inc"],
      "002333" => ["Cisco", "Cisco Systems"],
      "002334" => ["Cisco", "Cisco Systems"],
      "002335" => ["Linkflex", "Linkflex Co.,Ltd"],
      "002336" => ["MetelSRO", "METEL s.r.o."],
      "002337" => ["GlobalSt", "Global Star Solutions ULC"],
      "002338" => ["Oj-Elect", "OJ-Electronics A/S"],
      "002339" => ["SamsungE", "Samsung Electronics"],
      "00233A" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "00233B" => ["C-Matic", "C-Matic Systems Ltd"],
      "00233C" => ["Alflex",""],
      "00233D" => ["NoveroBV", "Novero holding B.V."],
      "00233E" => ["Alcatel-", "Alcatel-Lucent-IPD"],
      "00233F" => ["Purechoi", "Purechoice Inc"],
      "002340" => ["MixTelem", "MiX Telematics"],
      "002341" => ["SiemensI", "Siemens AG, Infrastructure & Cities Sector, Building Technologies Division"],
      "002342" => ["CoffeeEq", "Coffee Equipment Company"],
      "002343" => ["Tem", "TEM AG"],
      "002344" => ["Objectiv", "Objective Interface Systems"],
      "002345" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "002346" => ["Vestac",""],
      "002347" => ["Procurve", "ProCurve Networking by HP"],
      "002348" => ["SagemCom", "SAGEM COMMUNICATION"],
      "002349" => ["Helmholt", "Helmholtz Centre Berlin for Material and Energy"],
      "00234A" => ["Private",""],
      "00234B" => ["InyuanTe", "Inyuan Technology Inc."],
      "00234C" => ["Ktc", "KTC AB"],
      "00234D" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "00234E" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "00234F" => ["Luminous", "Luminous Power Technologies Pvt. Ltd."],
      "002350" => ["Lyntec",""],
      "002351" => ["2wire",""],
      "002352" => ["Datasens", "DATASENSOR S.p.A."],
      "002353" => ["FETElett", "F E T Elettronica snc"],
      "002354" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "002355" => ["KincoAut", "Kinco Automation(Shanghai) Ltd."],
      "002356" => ["PacketFo", "Packet Forensics LLC"],
      "002357" => ["Pitronot", "Pitronot Technologies and Engineering P.T.E. Ltd."],
      "002358" => ["SystelSa", "SYSTEL SA"],
      "002359" => ["Benchmar", "Benchmark Electronics ( Thailand ) Public Company Limited"],
      "00235A" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., Ltd."],
      "00235B" => ["Gulfstre", "Gulfstream"],
      "00235C" => ["Aprius", "Aprius, Inc."],
      "00235D" => ["Cisco", "Cisco Systems"],
      "00235E" => ["Cisco", "Cisco Systems"],
      "00235F" => ["SiliconM", "Silicon Micro Sensors GmbH"],
      "002360" => ["LookitTe", "Lookit Technology Co., Ltd"],
      "002361" => ["Unigen", "Unigen Corporation"],
      "002362" => ["Goldline", "Goldline Controls"],
      "002363" => ["ZhuhaiRa", "Zhuhai RaySharp Technology Co., Ltd."],
      "002364" => ["PowerIns", "Power Instruments Pte Ltd"],
      "002365" => ["Elka-Ele", "ELKA-Elektronik GmbH"],
      "002366" => ["BeijingS", "Beijing Siasun Electronic System Co.,Ltd."],
      "002367" => ["Unicontr", "UniControls a.s."],
      "002368" => ["Motorola",""],
      "002369" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "00236A" => ["Clearacc", "ClearAccess, Inc."],
      "00236B" => ["Xembedde", "Xembedded, Inc."],
      "00236C" => ["Apple", "Apple, Inc"],
      "00236D" => ["Resmed", "ResMed Ltd"],
      "00236E" => ["Burster", "Burster GmbH & Co KG"],
      "00236F" => ["DaqSyste", "DAQ System"],
      "002370" => ["Snell",""],
      "002371" => ["SoamSyst", "SOAM Systel"],
      "002372" => ["MoreStar", "MORE STAR INDUSTRIAL GROUP LIMITED"],
      "002373" => ["Gridiron", "GridIron Systems, Inc."],
      "002374" => ["Motorola", "Motorola Mobility, Inc."],
      "002375" => ["Motorola", "Motorola Mobility, Inc."],
      "002376" => ["Htc", "HTC Corporation"],
      "002377" => ["IsotekEl", "Isotek Electronics Ltd"],
      "002378" => ["GnNetcom", "GN Netcom A/S"],
      "002379" => ["UnionBus", "Union Business Machines Co. Ltd."],
      "00237A" => ["Rim",""],
      "00237B" => ["WhdiLlc", "WHDI LLC"],
      "00237C" => ["Neotion",""],
      "00237D" => ["Hewlett-", "Hewlett-Packard Company"],
      "00237E" => ["Elster", "ELSTER GMBH"],
      "00237F" => ["Plantron", "PLANTRONICS"],
      "002380" => ["Nanoteq",""],
      "002381" => ["LengdaTe", "Lengda Technology(Xiamen) Co.,Ltd."],
      "002382" => ["LihRongE", "Lih Rong Electronic Enterprise Co., Ltd."],
      "002383" => ["Inmage", "InMage Systems Inc"],
      "002384" => ["GghEngin", "GGH Engineering s.r.l."],
      "002385" => ["Antipode",""],
      "002386" => ["TourAnde", "Tour & Andersson AB"],
      "002387" => ["Thinkflo", "ThinkFlood, Inc."],
      "002388" => ["VTTelema", "V.T. Telematica S.p.a."],
      "002389" => ["Hangzhou", "HANGZHOU H3C Technologies Co., Ltd."],
      "00238A" => ["Ciena", "Ciena Corporation"],
      "00238B" => ["QuantaCo", "Quanta Computer Inc."],
      "00238C" => ["Private",""],
      "00238D" => ["TechnoDe", "Techno Design Co., Ltd."],
      "00238E" => ["AdbBroad", "ADB Broadband Italia"],
      "00238F" => ["NidecCop", "NIDEC COPAL CORPORATION"],
      "002390" => ["Algolwar", "Algolware Corporation"],
      "002391" => ["Maxian",""],
      "002392" => ["ProteusI", "Proteus Industries Inc."],
      "002393" => ["Ajinexte", "AJINEXTEK"],
      "002394" => ["Samjeon",""],
      "002395" => ["Motorola", "Motorola Mobility, Inc."],
      "002396" => ["AndesTec", "ANDES TECHNOLOGY CORPORATION"],
      "002397" => ["WestellT", "Westell Technologies Inc."],
      "002398" => ["SkyContr", "Sky Control"],
      "002399" => ["VdDivisi", "VD Division, Samsung Electronics Co."],
      "00239A" => ["Easydata", "EasyData Software GmbH"],
      "00239B" => ["ElsterSo", "Elster Solutions, LLC"],
      "00239C" => ["JuniperN", "Juniper Networks"],
      "00239D" => ["MapowerE", "Mapower Electronics Co., Ltd"],
      "00239E" => ["JiangsuL", "Jiangsu Lemote Technology Corporation Limited"],
      "00239F" => ["Institut", "Institut fur Pruftechnik"],
      "0023A0" => ["HanaCns", "Hana CNS Co., LTD."],
      "0023A1" => ["TrendEle", "Trend Electronics Ltd"],
      "0023A2" => ["Motorola", "Motorola Mobility, Inc."],
      "0023A3" => ["Motorola", "Motorola Mobility, Inc."],
      "0023A4" => ["NewConce", "New Concepts Development Corp."],
      "0023A5" => ["SagetvLl", "SageTV, LLC"],
      "0023A6" => ["E-Mon",""],
      "0023A7" => ["RedpineS", "Redpine Signals, Inc."],
      "0023A8" => ["Marshall", "Marshall Electronics"],
      "0023A9" => ["BeijingD", "Beijing Detianquan Electromechanical Equipment Co., Ltd"],
      "0023AA" => ["Hfr", "HFR, Inc."],
      "0023AB" => ["Cisco", "Cisco Systems"],
      "0023AC" => ["Cisco", "Cisco Systems"],
      "0023AD" => ["Xmark", "Xmark Corporation"],
      "0023AE" => ["Dell", "Dell Inc."],
      "0023AF" => ["Motorola", "Motorola Mobility, Inc."],
      "0023B0" => ["ComxionT", "COMXION Technology Inc."],
      "0023B1" => ["Longchee", "Longcheer Technology (Singapore) Pte Ltd"],
      "0023B2" => ["Intellig", "Intelligent Mechatronic Systems Inc"],
      "0023B3" => ["Lyyn", "Lyyn AB"],
      "0023B4" => ["NokiaDan", "Nokia Danmark A/S"],
      "0023B5" => ["Ortana", "ORTANA LTD"],
      "0023B6" => ["Securite", "SECURITE COMMUNICATIONS / HONEYWELL"],
      "0023B7" => ["Q-Light", "Q-Light Co., Ltd."],
      "0023B8" => ["SichuanJ", "Sichuan Jiuzhou Electronic Technology Co.,Ltd"],
      "0023B9" => ["EadsDeut", "EADS Deutschland GmbH"],
      "0023BA" => ["Chroma",""],
      "0023BB" => ["SchmittI", "Schmitt Industries"],
      "0023BC" => ["Eq-Sys", "EQ-SYS GmbH"],
      "0023BD" => ["DigitalA", "Digital Ally, Inc."],
      "0023BE" => ["CiscoSpv", "Cisco SPVTG"],
      "0023BF" => ["Mainpine", "Mainpine, Inc."],
      "0023C0" => ["Broadway", "Broadway Networks"],
      "0023C1" => ["Securita", "Securitas Direct AB"],
      "0023C2" => ["SamsungE", "SAMSUNG Electronics. Co. LTD"],
      "0023C3" => ["Logmein", "LogMeIn, Inc."],
      "0023C4" => ["LuxLumen", "Lux Lumen"],
      "0023C5" => ["Radiatio", "Radiation Safety and Control Services Inc"],
      "0023C6" => ["Smc", "SMC Corporation"],
      "0023C7" => ["Avsystem",""],
      "0023C8" => ["Team-R",""],
      "0023C9" => ["SichuanT", "Sichuan Tianyi Information Science & Technology Stock CO.,LTD"],
      "0023CA" => ["BehindSe", "Behind The Set, LLC"],
      "0023CB" => ["Shenzhen", "Shenzhen Full-join Technology Co.,Ltd"],
      "0023CC" => ["Nintendo", "Nintendo Co., Ltd."],
      "0023CD" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "0023CE" => ["KitaDens", "KITA DENSHI CORPORATION"],
      "0023CF" => ["Cummins-", "CUMMINS-ALLISON CORP."],
      "0023D0" => ["UnilocUs", "Uniloc USA Inc."],
      "0023D1" => ["Trg",""],
      "0023D2" => ["InhandEl", "Inhand Electronics, Inc."],
      "0023D3" => ["AirlinkW", "AirLink WiFi Networking Corp."],
      "0023D4" => ["TexasIns", "Texas Instruments"],
      "0023D5" => ["WaremaEl", "WAREMA electronic GmbH"],
      "0023D6" => ["SamsungE", "Samsung Electronics Co.,LTD"],
      "0023D7" => ["SamsungE", "Samsung Electronics"],
      "0023D8" => ["Ball-ItO", "Ball-It Oy"],
      "0023D9" => ["BannerEn", "Banner Engineering"],
      "0023DA" => ["Industri", "Industrial Computer Source (Deutschland)GmbH"],
      "0023DB" => ["Saxnet", "saxnet gmbh"],
      "0023DC" => ["Benein", "Benein, Inc"],
      "0023DD" => ["ElginSA", "ELGIN S.A."],
      "0023DE" => ["Ansync", "Ansync Inc."],
      "0023DF" => ["Apple", "Apple, Inc"],
      "0023E0" => ["InoThera", "INO Therapeutics LLC"],
      "0023E1" => ["CavenaIm", "Cavena Image Products AB"],
      "0023E2" => ["SeaSigna", "SEA Signalisation"],
      "0023E3" => ["Microtro", "Microtronic AG"],
      "0023E4" => ["Ipnect", "IPnect co. ltd."],
      "0023E5" => ["IpaxiomN", "IPaXiom Networks"],
      "0023E6" => ["Pirkus", "Pirkus, Inc."],
      "0023E7" => ["Hinke", "Hinke A/S"],
      "0023E8" => ["Demco", "Demco Corp."],
      "0023E9" => ["F5Networ", "F5 Networks, Inc."],
      "0023EA" => ["Cisco", "Cisco Systems"],
      "0023EB" => ["Cisco", "Cisco Systems"],
      "0023EC" => ["Algorith", "Algorithmix GmbH"],
      "0023ED" => ["Motorola", "Motorola CHS"],
      "0023EE" => ["Motorola", "Motorola Mobility, Inc."],
      "0023EF" => ["ZuendSys", "Zuend Systemtechnik AG"],
      "0023F0" => ["Shanghai", "Shanghai Jinghan Weighing Apparatus Co. Ltd."],
      "0023F1" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "0023F2" => ["Tvlogic",""],
      "0023F3" => ["Glocom", "Glocom, Inc."],
      "0023F4" => ["Masterna", "Masternaut"],
      "0023F5" => ["WiloSe", "WILO SE"],
      "0023F6" => ["Softwell", "Softwell Technology Co., Ltd."],
      "0023F7" => ["Private",""],
      "0023F8" => ["ZyxelCom", "ZyXEL Communications Corporation"],
      "0023F9" => ["Double-T", "Double-Take Software, INC."],
      "0023FA" => ["RgNets", "RG Nets, Inc."],
      "0023FB" => ["IpDatate", "IP Datatel, Inc."],
      "0023FC" => ["UltraSte", "Ultra Stereo Labs, Inc"],
      "0023FD" => ["AftAtlas", "AFT Atlas Fahrzeugtechnik GmbH"],
      "0023FE" => ["Biodevic", "Biodevices, SA"],
      "0023FF" => ["BeijingH", "Beijing HTTC Technology Ltd."],
      "002400" => ["NortelNe", "Nortel Networks"],
      "002401" => ["D-Link", "D-Link Corporation"],
      "002402" => ["Op-Tecti", "Op-Tection GmbH"],
      "002403" => ["NokiaDan", "Nokia Danmark A/S"],
      "002404" => ["NokiaDan", "Nokia Danmark A/S"],
      "002405" => ["DilogNor", "Dilog Nordic AB"],
      "002406" => ["Pointmob", "Pointmobile"],
      "002407" => ["TelemSas", "TELEM SAS"],
      "002408" => ["PacificB", "Pacific Biosciences"],
      "002409" => ["Toro", "The Toro Company"],
      "00240A" => ["UsBevera", "US Beverage Net"],
      "00240B" => ["VirtualC", "Virtual Computer Inc."],
      "00240C" => ["Delec", "DELEC GmbH"],
      "00240D" => ["OnepathN", "OnePath Networks LTD."],
      "00240E" => ["Inventec", "Inventec Besta Co., Ltd."],
      "00240F" => ["IshiiToo", "Ishii Tool & Engineering Corporation"],
      "002410" => ["NueteqTe", "NUETEQ Technology,Inc."],
      "002411" => ["Pharmasm", "PharmaSmart LLC"],
      "002412" => ["BenignTe", "Benign Technologies Co, Ltd."],
      "002413" => ["Cisco", "Cisco Systems"],
      "002414" => ["Cisco", "Cisco Systems"],
      "002415" => ["Magnetic", "Magnetic Autocontrol GmbH"],
      "002416" => ["AnyUse", "Any Use"],
      "002417" => ["ThomsonT", "Thomson Telecom Belgium"],
      "002418" => ["Nextwave", "Nextwave Semiconductor"],
      "002419" => ["Private",""],
      "00241A" => ["RedBeetl", "Red Beetle Inc."],
      "00241B" => ["IwowComm", "iWOW Communications Pte Ltd"],
      "00241C" => ["FugangEl", "FuGang Electronic (DG) Co.,Ltd"],
      "00241D" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "00241E" => ["Nintendo", "Nintendo Co., Ltd."],
      "00241F" => ["Dct-Delt", "DCT-Delta GmbH"],
      "002420" => ["Netup", "NetUP Inc."],
      "002421" => ["Micro-St", "MICRO-STAR INT\'L CO., LTD."],
      "002422" => ["KnappLog", "Knapp Logistik Automation GmbH"],
      "002423" => ["Azurewav", "AzureWave Technologies (Shanghai) Inc."],
      "002424" => ["AxisNetw", "Axis Network Technology"],
      "002425" => ["Shenzhen", "Shenzhenshi chuangzhicheng Technology Co.,Ltd"],
      "002426" => ["NohmiBos", "NOHMI BOSAI LTD."],
      "002427" => ["SsiCompu", "SSI COMPUTER CORP"],
      "002428" => ["Energyic", "EnergyICT"],
      "002429" => ["MkMaster", "MK MASTER INC."],
      "00242A" => ["HittiteM", "Hittite Microwave Corporation"],
      "00242B" => ["HonHaiPr", "Hon Hai Precision Ind.Co.,Ltd."],
      "00242C" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "00242E" => ["Datastri", "Datastrip Inc."],
      "00242F" => ["Virtensy", "VirtenSys Inc"],
      "002430" => ["RubyTech", "Ruby Tech Corp."],
      "002431" => ["Uni-V", "Uni-v co.,ltd"],
      "002432" => ["NeostarT", "Neostar Technology Co.,LTD"],
      "002433" => ["AlpsElec", "Alps Electric Co., Ltd"],
      "002434" => ["Lectroso", "Lectrosonics, Inc."],
      "002435" => ["Wide", "WIDE CORPORATION"],
      "002436" => ["Apple", "Apple, Inc"],
      "002437" => ["Motorola", "Motorola - BSG"],
      "002438" => ["BrocadeC", "Brocade Communications Systems, Inc"],
      "002439" => ["Essentia", "Essential Viewing Systems Limited"],
      "00243A" => ["LudlElec", "Ludl Electronic Products"],
      "00243B" => ["CssiSPte", "CSSI (S) Pte Ltd"],
      "00243C" => ["SAAA", "S.A.A.A."],
      "00243D" => ["EmersonA", "Emerson Appliance Motors and Controls"],
      "00243F" => ["Storwize", "Storwize, Inc."],
      "002440" => ["HaloMoni", "Halo Monitoring, Inc."],
      "002441" => ["WanzlMet", "Wanzl Metallwarenfabrik GmbH"],
      "002442" => ["Axona", "Axona Limited"],
      "002443" => ["NortelNe", "Nortel Networks"],
      "002444" => ["Nintendo", "Nintendo Co., Ltd."],
      "002445" => ["Liquidxs", "LiquidxStream Systems Inc."],
      "002446" => ["MmbResea", "MMB Research Inc."],
      "002447" => ["Kaztek", "Kaztek Systems"],
      "002448" => ["Spidercl", "SpiderCloud Wireless, Inc"],
      "002449" => ["ShenZhen", "Shen Zhen Lite Star Electronics Technology Co., Ltd"],
      "00244A" => ["VoyantIn", "Voyant International"],
      "00244B" => ["Perceptr", "PERCEPTRON INC"],
      "00244C" => ["Solartro", "Solartron Metrology Ltd"],
      "00244D" => ["Hokkaido", "Hokkaido Electronics Corporation"],
      "00244E" => ["Radchips", "RadChips, Inc."],
      "00244F" => ["Asantron", "Asantron Technologies Ltd."],
      "002450" => ["Cisco", "Cisco Systems"],
      "002451" => ["Cisco", "Cisco Systems"],
      "002452" => ["SiliconS", "Silicon Software GmbH"],
      "002453" => ["InitraDO", "Initra d.o.o."],
      "002454" => ["SamsungE", "Samsung Electronics Co., LTD"],
      "002455" => ["MulogicB", "MuLogic BV"],
      "002456" => ["2wire",""],
      "002458" => ["PaBastio", "PA Bastion CC"],
      "002459" => ["AbbStotz", "ABB STOTZ-KONTAKT GmbH"],
      "00245A" => ["NanjingP", "Nanjing Panda Electronics Company Limited"],
      "00245B" => ["RaidonTe", "RAIDON TECHNOLOGY, INC."],
      "00245C" => ["Design-C", "Design-Com Technologies Pty. Ltd."],
      "00245D" => ["TerbergB", "Terberg besturingstechniek B.V."],
      "00245E" => ["Hivision", "Hivision Co.,ltd"],
      "00245F" => ["VineTele", "Vine Telecom CO.,Ltd."],
      "002460" => ["GiavalSc", "Giaval Science Development Co. Ltd."],
      "002461" => ["ShinWang", "Shin Wang Tech."],
      "002462" => ["Rayzone", "Rayzone Corporation"],
      "002463" => ["Phybridg", "Phybridge Inc"],
      "002464" => ["BridgeTe", "Bridge Technologies Co AS"],
      "002465" => ["Elentec",""],
      "002466" => ["UnitronN", "Unitron nv"],
      "002467" => ["AocInter", "AOC International (Europe) GmbH"],
      "002468" => ["Sumavisi", "Sumavision Technologies Co.,Ltd"],
      "002469" => ["SmartDoo", "Smart Doorphones"],
      "00246A" => ["SolidYea", "Solid Year Co., Ltd."],
      "00246B" => ["Covia", "Covia, Inc."],
      "00246C" => ["ArubaNet", "ARUBA NETWORKS, INC."],
      "00246D" => ["Weinzier", "Weinzierl Engineering GmbH"],
      "00246E" => ["PhihongU", "Phihong USA Corp."],
      "00246F" => ["OndaComm", "Onda Communication spa"],
      "002470" => ["Aurotech", "AUROTECH ultrasound AS."],
      "002471" => ["FusionMu", "Fusion MultiSystems dba Fusion-io"],
      "002472" => ["Redriven", "ReDriven Power Inc."],
      "002473" => ["3comEuro", "3Com Europe Ltd"],
      "002474" => ["Autronic", "Autronica Fire And Securirty"],
      "002475" => ["CompassS", "Compass System(Embedded Dept.)"],
      "002476" => ["TapTv", "TAP.tv"],
      "002477" => ["TibboTec", "Tibbo Technology"],
      "002478" => ["MagTechE", "Mag Tech Electronics Co Limited"],
      "002479" => ["OptecDis", "Optec Displays, Inc."],
      "00247A" => ["FuYiChen", "FU YI CHENG Technology Co., Ltd."],
      "00247B" => ["Actionte", "Actiontec Electronics, Inc"],
      "00247C" => ["NokiaDan", "Nokia Danmark A/S"],
      "00247D" => ["NokiaDan", "Nokia Danmark A/S"],
      "00247E" => ["Universa", "Universal Global Scientific Industrial Co., Ltd"],
      "00247F" => ["NortelNe", "Nortel Networks"],
      "002480" => ["Meteocon", "Meteocontrol GmbH"],
      "002481" => ["Hewlett-", "Hewlett-Packard Company"],
      "002482" => ["RuckusWi", "Ruckus Wireless"],
      "002483" => ["LgElectr", "LG Electronics"],
      "002484" => ["BangAndO", "Bang and Olufsen Medicom a/s"],
      "002485" => ["Contextr", "ConteXtream Ltd"],
      "002486" => ["Designar", "DesignArt Networks"],
      "002487" => ["Blackboa", "Blackboard Inc."],
      "002488" => ["CentreFo", "Centre For Development Of Telematics"],
      "002489" => ["Vodafone", "Vodafone Omnitel N.V."],
      "00248A" => ["KagaElec", "Kaga Electronics Co., Ltd."],
      "00248B" => ["Hybus", "HYBUS CO., LTD."],
      "00248C" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "00248D" => ["SonyComp", "Sony Computer Entertainment Inc."],
      "00248E" => ["Infoware", "Infoware ZRt."],
      "00248F" => ["Do-Monix",""],
      "002490" => ["SamsungE", "Samsung Electronics Co.,LTD"],
      "002491" => ["SamsungE", "Samsung Electronics"],
      "002492" => ["Motorola", "Motorola, Broadband Solutions Group"],
      "002493" => ["Motorola", "Motorola, Inc"],
      "002494" => ["Shenzhen", "Shenzhen Baoxin Tech CO., Ltd."],
      "002495" => ["Motorola", "Motorola Mobility, Inc."],
      "002496" => ["Ginzinge", "Ginzinger electronic systems"],
      "002497" => ["Cisco", "Cisco Systems"],
      "002498" => ["Cisco", "Cisco Systems"],
      "002499" => ["AquilaTe", "Aquila Technologies"],
      "00249A" => ["BeijingZ", "Beijing Zhongchuang Telecommunication Test Co., Ltd."],
      "00249B" => ["ActionSt", "Action Star Enterprise Co., Ltd."],
      "00249C" => ["BimengCo", "Bimeng Comunication System Co. Ltd"],
      "00249D" => ["NesTechn", "NES Technology Inc."],
      "00249E" => ["Adc-Elek", "ADC-Elektronik GmbH"],
      "00249F" => ["RimTesti", "RIM Testing Services"],
      "0024A0" => ["Motorola", "Motorola Mobility, Inc."],
      "0024A1" => ["Motorola", "Motorola Mobility, Inc."],
      "0024A2" => ["HongKong", "Hong Kong Middleware Technology Limited"],
      "0024A3" => ["SonimTec", "Sonim Technologies Inc"],
      "0024A4" => ["SikluCom", "Siklu Communication"],
      "0024A5" => ["Buffalo", "Buffalo Inc."],
      "0024A6" => ["Telestar", "TELESTAR DIGITAL GmbH"],
      "0024A7" => ["Advanced", "Advanced Video Communications Inc."],
      "0024A8" => ["Procurve", "ProCurve Networking by HP"],
      "0024A9" => ["LeaderTe", "Ag Leader Technology"],
      "0024AA" => ["DycorTec", "Dycor Technologies Ltd."],
      "0024AB" => ["A7Engine", "A7 Engineering, Inc."],
      "0024AC" => ["Hangzhou", "Hangzhou DPtech Technologies Co., Ltd."],
      "0024AD" => ["AdolfThi", "Adolf Thies Gmbh & Co. KG"],
      "0024AE" => ["Morpho",""],
      "0024AF" => ["Echostar", "EchoStar Technologies"],
      "0024B0" => ["Esab", "ESAB AB"],
      "0024B1" => ["CoulombT", "Coulomb Technologies"],
      "0024B2" => ["Netgear",""],
      "0024B3" => ["Graf-Syt", "Graf-Syteco GmbH & Co. KG"],
      "0024B4" => ["Escatron", "ESCATRONIC GmbH"],
      "0024B5" => ["NortelNe", "Nortel Networks"],
      "0024B6" => ["SeagateT", "Seagate Technology"],
      "0024B7" => ["Gridpoin", "GridPoint, Inc."],
      "0024B8" => ["FreeAlli", "free alliance sdn bhd"],
      "0024B9" => ["WuhanHig", "Wuhan Higheasy Electronic Technology Development Co.Ltd"],
      "0024BA" => ["TexasIns", "Texas Instruments"],
      "0024BB" => ["Central", "CENTRAL Corporation"],
      "0024BC" => ["Hurob", "HuRob Co.,Ltd"],
      "0024BD" => ["HainzlIn", "Hainzl Industriesysteme GmbH"],
      "0024BE" => ["Sony", "Sony Corporation"],
      "0024BF" => ["Ciat",""],
      "0024C0" => ["NtiComod", "NTI COMODO INC"],
      "0024C1" => ["Motorola", "Motorola Mobility, Inc."],
      "0024C2" => ["Asumo", "Asumo Co.,Ltd."],
      "0024C3" => ["Cisco", "Cisco Systems"],
      "0024C4" => ["Cisco", "Cisco Systems"],
      "0024C5" => ["Meridian", "Meridian Audio Limited"],
      "0024C6" => ["HagerEle", "Hager Electro SAS"],
      "0024C7" => ["Mobilarm", "Mobilarm Ltd"],
      "0024C8" => ["Broadban", "Broadband Solutions Group"],
      "0024C9" => ["Broadban", "Broadband Solutions Group"],
      "0024CA" => ["TobiiTec", "Tobii Technology AB"],
      "0024CB" => ["AutonetM", "Autonet Mobile"],
      "0024CC" => ["Fascinat", "Fascinations Toys and Gifts, Inc."],
      "0024CD" => ["WillowGa", "Willow Garage, Inc."],
      "0024CE" => ["Exeltech", "Exeltech Inc"],
      "0024CF" => ["InscapeD", "Inscape Data Corporation"],
      "0024D0" => ["Shenzhen", "Shenzhen SOGOOD Industry CO.,LTD."],
      "0024D1" => ["Thomson", "Thomson Inc."],
      "0024D2" => ["AskeyCom", "Askey Computer"],
      "0024D3" => ["Qualica", "QUALICA Inc."],
      "0024D4" => ["FreeboxS", "FREEBOX SA"],
      "0024D5" => ["WinwardI", "Winward Industrial Limited"],
      "0024D6" => ["IntelCor", "Intel Corporate"],
      "0024D7" => ["IntelCor", "Intel Corporate"],
      "0024D8" => ["IlsungPr", "IlSung Precision"],
      "0024D9" => ["Bicom", "BICOM, Inc."],
      "0024DA" => ["Innovar", "Innovar Systems Limited"],
      "0024DB" => ["AlcoholM", "Alcohol Monitoring Systems"],
      "0024DC" => ["JuniperN", "Juniper Networks"],
      "0024DD" => ["Centrak", "Centrak, Inc."],
      "0024DE" => ["GlobalTe", "GLOBAL Technology Inc."],
      "0024DF" => ["Digitalb", "Digitalbox Europe GmbH"],
      "0024E0" => ["DsTechLl", "DS Tech, LLC"],
      "0024E1" => ["ConveyCo", "Convey Computer Corp."],
      "0024E2" => ["Hasegawa", "HASEGAWA ELECTRIC CO.,LTD."],
      "0024E3" => ["CaoGroup", "CAO Group"],
      "0024E4" => ["Withings",""],
      "0024E5" => ["SeerTech", "Seer Technology, Inc"],
      "0024E6" => ["InMotion", "In Motion Technology Inc."],
      "0024E7" => ["PlasterN", "Plaster Networks"],
      "0024E8" => ["Dell", "Dell Inc."],
      "0024E9" => ["SamsungE", "Samsung Electronics Co., Ltd., Storage System Division"],
      "0024EA" => ["Iris-Gmb", "iris-GmbH infrared & intelligent sensors"],
      "0024EB" => ["Clearpat", "ClearPath Networks, Inc."],
      "0024EC" => ["UnitedIn", "United Information Technology Co.,Ltd."],
      "0024ED" => ["YtElec", "YT Elec. Co,.Ltd."],
      "0024EE" => ["Wynmax", "Wynmax Inc."],
      "0024EF" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "0024F0" => ["Seanodes",""],
      "0024F1" => ["Shenzhen", "Shenzhen Fanhai Sanjiang Electronics Co., Ltd."],
      "0024F2" => ["Uniphone", "Uniphone Telecommunication Co., Ltd."],
      "0024F3" => ["Nintendo", "Nintendo Co., Ltd."],
      "0024F4" => ["Kaminari", "Kaminario Technologies Ltd."],
      "0024F5" => ["NdsSurgi", "NDS Surgical Imaging"],
      "0024F6" => ["MiyoshiE", "MIYOSHI ELECTRONICS CORPORATION"],
      "0024F7" => ["Cisco", "Cisco Systems"],
      "0024F8" => ["Technica", "Technical Solutions Company Ltd."],
      "0024F9" => ["Cisco", "Cisco Systems"],
      "0024FA" => ["HilgerUK", "Hilger u. Kern GMBH"],
      "0024FB" => ["Private",""],
      "0024FC" => ["Quopin", "QuoPin Co., Ltd."],
      "0024FD" => ["Prosilie", "Prosilient Technologies AB"],
      "0024FE" => ["Avm", "AVM GmbH"],
      "0024FF" => ["Qlogic", "QLogic Corporation"],
      "002500" => ["Apple", "Apple, Inc"],
      "002501" => ["Jsc Supe", "JSC  Supertel"],
      "002502" => ["Naturalp", "NaturalPoint"],
      "002503" => ["Ibm", "IBM Corp"],
      "002504" => ["ValiantC", "Valiant Communications Limited"],
      "002505" => ["EksEngel", "eks Engel GmbH & Co. KG"],
      "002506" => ["AIAntita", "A.I. ANTITACCHEGGIO ITALIA SRL"],
      "002507" => ["Astak", "ASTAK Inc."],
      "002508" => ["MaquetCa", "Maquet Cardiopulmonary AG"],
      "002509" => ["Sharetro", "SHARETRONIC Group LTD"],
      "00250A" => ["Security", "Security Expert Co. Ltd"],
      "00250B" => ["Centrofa", "CENTROFACTOR  INC"],
      "00250C" => ["Enertrac",""],
      "00250D" => ["GztTelko", "GZT Telkom-Telmor sp. z o.o."],
      "00250E" => ["GtGerman", "gt german telematics gmbh"],
      "00250F" => ["On-RampW", "On-Ramp Wireless, Inc."],
      "002510" => ["Pico-Tes", "Pico-Tesla Magnetic Therapies"],
      "002511" => ["Elitegro", "ELITEGROUP COMPUTER SYSTEM CO., LTD."],
      "002512" => ["Zte", "ZTE Corporation"],
      "002513" => ["CxpDigit", "CXP DIGITAL BV"],
      "002514" => ["PcWorthI", "PC Worth Int\'l Co., Ltd."],
      "002515" => ["Sfr",""],
      "002516" => ["Integrat", "Integrated Design Tools, Inc."],
      "002517" => ["VenntisL", "Venntis, LLC"],
      "002518" => ["PowerPlu", "Power PLUS Communications AG"],
      "002519" => ["Viaas", "Viaas Inc"],
      "00251A" => ["PsiberDa", "Psiber Data Systems Inc."],
      "00251B" => ["PhilipsC", "Philips CareServant"],
      "00251C" => ["Edt",""],
      "00251D" => ["DsaEncor", "DSA Encore, LLC"],
      "00251E" => ["RotelTec", "ROTEL TECHNOLOGIES"],
      "00251F" => ["ZynusVis", "ZYNUS VISION INC."],
      "002520" => ["SmaRailw", "SMA Railway Technology GmbH"],
      "002521" => ["LogitekE", "Logitek Electronic Systems, Inc."],
      "002522" => ["AsrockIn", "ASRock Incorporation"],
      "002523" => ["Ocp", "OCP Inc."],
      "002524" => ["Lightcom", "Lightcomm Technology Co., Ltd"],
      "002525" => ["CteraNet", "CTERA Networks Ltd."],
      "002526" => ["GenuineT", "Genuine Technologies Co., Ltd."],
      "002527" => ["Bitrode", "Bitrode Corp."],
      "002528" => ["DaidoSig", "Daido Signal Co., Ltd."],
      "002529" => ["ComelitG", "COMELIT GROUP S.P.A"],
      "00252A" => ["ChengduG", "Chengdu GeeYa Technology Co.,LTD"],
      "00252B" => ["Stirling", "Stirling Energy Systems"],
      "00252C" => ["Entourag", "Entourage Systems, Inc."],
      "00252D" => ["KiryungE", "Kiryung Electronics"],
      "00252E" => ["CiscoSpv", "Cisco SPVTG"],
      "00252F" => ["Energy", "Energy, Inc."],
      "002530" => ["Aetas", "Aetas Systems Inc."],
      "002531" => ["CloudEng", "Cloud Engines, Inc."],
      "002532" => ["DigitalR", "Digital Recorders"],
      "002533" => ["Wittenst", "WITTENSTEIN AG"],
      "002535" => ["Minimax", "Minimax GmbH & Co KG"],
      "002536" => ["OkiElect", "Oki Electric Industry Co., Ltd."],
      "002537" => ["RuncomTe", "Runcom Technologies Ltd."],
      "002538" => ["SamsungE", "Samsung Electronics Co., Ltd., Memory Division"],
      "002539" => ["Ifta", "IfTA GmbH"],
      "00253A" => ["Ceva", "CEVA, Ltd."],
      "00253B" => ["DinDietm", "din Dietmar Nocker Facilitymanagement GmbH"],
      "00253C" => ["2wire",""],
      "00253D" => ["DrsConso", "DRS Consolidated Controls"],
      "00253E" => ["SensusMe", "Sensus Metering Systems"],
      "002540" => ["QuasarTe", "Quasar Technologies, Inc."],
      "002541" => ["MaquetCr", "Maquet Critical Care AB"],
      "002542" => ["Pittasof", "Pittasoft"],
      "002543" => ["Moneytec", "MONEYTECH"],
      "002544" => ["Lojack", "LoJack Corporation"],
      "002545" => ["Cisco", "Cisco Systems"],
      "002546" => ["Cisco", "Cisco Systems"],
      "002547" => ["NokiaDan", "Nokia Danmark A/S"],
      "002548" => ["NokiaDan", "Nokia Danmark A/S"],
      "002549" => ["JeorichT", "Jeorich Tech. Co.,Ltd."],
      "00254A" => ["Ringcube", "RingCube Technologies, Inc."],
      "00254B" => ["Apple", "Apple, Inc"],
      "00254C" => ["VideonCe", "Videon Central, Inc."],
      "00254D" => ["Singapor", "Singapore Technologies Electronics Limited"],
      "00254E" => ["VertexWi", "Vertex Wireless Co., Ltd."],
      "00254F" => ["Elettrol", "ELETTROLAB Srl"],
      "002550" => ["Riverbed", "Riverbed Technology"],
      "002551" => ["Se-Elekt", "SE-Elektronic GmbH"],
      "002552" => ["Vxi", "VXI CORPORATION"],
      "002553" => ["AdbBroad", "ADB Broadband Italia"],
      "002554" => ["Pixel8Ne", "Pixel8 Networks"],
      "002555" => ["VisonicT", "Visonic Technologies 1993 Ltd"],
      "002556" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "002557" => ["Research", "Research In Motion"],
      "002558" => ["Mpedia",""],
      "002559" => ["SyphanTe", "Syphan Technologies Ltd"],
      "00255A" => ["Tantalus", "Tantalus Systems Corp."],
      "00255B" => ["Coachcom", "CoachComm, LLC"],
      "00255C" => ["Nec", "NEC Corporation"],
      "00255D" => ["Mornings", "Morningstar Corporation"],
      "00255E" => ["Shanghai", "Shanghai Dare Technologies Co.,Ltd."],
      "00255F" => ["Sentec", "SenTec AG"],
      "002560" => ["IbridgeN", "Ibridge Networks & Communications Ltd."],
      "002561" => ["Procurve", "ProCurve Networking by HP"],
      "002562" => ["Interbro", "interbro Co. Ltd."],
      "002563" => ["Luxtera", "Luxtera Inc"],
      "002564" => ["Dell", "Dell Inc."],
      "002565" => ["Vizimax", "Vizimax Inc."],
      "002566" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "002567" => ["SamsungE", "Samsung Electronics"],
      "002568" => ["Shenzhen", "Shenzhen Huawei Communication Technologies Co., Ltd"],
      "002569" => ["SagemCom", "SAGEM COMMUNICATION"],
      "00256A" => ["Init-Ins", "inIT - Institut Industrial IT"],
      "00256B" => ["AtenixEE", "ATENIX E.E. s.r.l."],
      "00256C" => ["Azimut", "Azimut Production Association JSC"],
      "00256D" => ["Broadban", "Broadband Forum"],
      "00256E" => ["VanBreda", "Van Breda B.V."],
      "00256F" => ["Dantherm", "Dantherm Power"],
      "002570" => ["EasternC", "Eastern Communications Company Limited"],
      "002571" => ["Zhejiang", "Zhejiang Tianle Digital Electric Co.,Ltd"],
      "002572" => ["Nemo-QIn", "Nemo-Q International AB"],
      "002573" => ["StElectr", "ST Electronics (Info-Security) Pte Ltd"],
      "002574" => ["KunimiMe", "KUNIMI MEDIA DEVICE Co., Ltd."],
      "002575" => ["Fiberple", "FiberPlex Inc"],
      "002576" => ["NeliTech", "NELI TECHNOLOGIES"],
      "002577" => ["D-BoxTec", "D-BOX Technologies"],
      "002578" => ["Jsc Conc", "JSC Concern Sozvezdie"],
      "002579" => ["JFLabs", "J & F Labs"],
      "00257A" => ["CamcoPro", "CAMCO Produktions- und Vertriebs-GmbH fur Beschallungs- und Beleuchtungsanlagen"],
      "00257B" => ["StjElect", "STJ  ELECTRONICS  PVT  LTD"],
      "00257C" => ["Huachent", "Huachentel Technology Development Co., Ltd"],
      "00257D" => ["Pointred", "PointRed Telecom Private Ltd."],
      "00257E" => ["NewPosTe", "NEW POS Technology Limited"],
      "00257F" => ["Calltech", "CallTechSolution Co.,Ltd"],
      "002580" => ["Equipson", "Equipson S.A."],
      "002581" => ["X-StarNe", "x-star networks Inc."],
      "002582" => ["MaksatTe", "Maksat Technologies (P) Ltd"],
      "002583" => ["Cisco", "Cisco Systems"],
      "002584" => ["Cisco", "Cisco Systems"],
      "002585" => ["KokuyoS&", "KOKUYO S&T Co., Ltd."],
      "002586" => ["Tp-LinkT", "TP-LINK Technologies Co., Ltd."],
      "002587" => ["Vitality", "Vitality, Inc."],
      "002588" => ["GenieInd", "Genie Industries, Inc."],
      "002589" => ["HillsInd", "Hills Industries Limited"],
      "00258A" => ["Pole/Zer", "Pole/Zero Corporation"],
      "00258B" => ["Mellanox", "Mellanox Technologies Ltd"],
      "00258C" => ["EsusElek", "ESUS ELEKTRONIK SAN. VE DIS. TIC. LTD. STI."],
      "00258D" => ["Haier",""],
      "00258E" => ["WeatherC", "The Weather Channel"],
      "00258F" => ["TridentM", "Trident Microsystems, Inc."],
      "002590" => ["SuperMic", "Super Micro Computer, Inc."],
      "002591" => ["Nextek", "NEXTEK, Inc."],
      "002592" => ["Guangzho", "Guangzhou Shirui Electronic Co., Ltd"],
      "002593" => ["DatnetIn", "DatNet Informatikai Kft."],
      "002594" => ["Eurodesi", "Eurodesign BG LTD"],
      "002595" => ["Northwes", "Northwest Signal Supply, Inc"],
      "002596" => ["Gigavisi", "GIGAVISION srl"],
      "002597" => ["KalkiCom", "Kalki Communication Technologies"],
      "002598" => ["ZhongSha", "Zhong Shan City Litai Electronic Industrial Co. Ltd"],
      "002599" => ["HedonEDB", "Hedon e.d. B.V."],
      "00259A" => ["Cestroni", "CEStronics GmbH"],
      "00259B" => ["BeijingP", "Beijing PKUNITY Microsystems Technology Co., Ltd"],
      "00259C" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "00259D" => ["Private",""],
      "00259E" => ["HuaweiTe", "Huawei Technologies Co., Ltd."],
      "00259F" => ["Technodi", "TechnoDigital Technologies GmbH"],
      "0025A0" => ["Nintendo", "Nintendo Co., Ltd."],
      "0025A1" => ["Enalasys",""],
      "0025A2" => ["AltaDefi", "Alta Definicion LINCEO S.L."],
      "0025A3" => ["TrimaxWi", "Trimax Wireless, Inc."],
      "0025A4" => ["Eurodesi", "EuroDesign embedded technologies GmbH"],
      "0025A5" => ["WalnutMe", "Walnut Media Network"],
      "0025A6" => ["CentralN", "Central Network Solution Co., Ltd."],
      "0025A7" => ["Comverge", "Comverge, Inc."],
      "0025A8" => ["KontronB", "Kontron (BeiJing) Technology Co.,Ltd"],
      "0025A9" => ["Shanghai", "Shanghai Embedway Information Technologies Co.,Ltd"],
      "0025AA" => ["BeijingS", "Beijing Soul Technology Co.,Ltd."],
      "0025AB" => ["AioLcdPc", "AIO LCD PC BU / TPV"],
      "0025AC" => ["I-Tech", "I-Tech corporation"],
      "0025AD" => ["Manufact", "Manufacturing Resources International"],
      "0025AE" => ["Microsof", "Microsoft Corporation"],
      "0025AF" => ["ComfileT", "COMFILE Technology"],
      "0025B0" => ["Schmartz", "Schmartz Inc"],
      "0025B1" => ["Maya-Cre", "Maya-Creation Corporation"],
      "0025B2" => ["Lfk-Lenk", "LFK-LenkflugkA rpersysteme GmbH"],
      "0025B3" => ["Hewlett-", "Hewlett-Packard Company"],
      "0025B4" => ["Cisco", "Cisco Systems"],
      "0025B5" => ["Cisco", "Cisco Systems"],
      "0025B6" => ["TelecomF", "Telecom FM"],
      "0025B7" => ["CostarEl", "Costar  electronics, inc.,"],
      "0025B8" => ["AgileCom", "Agile Communications, Inc."],
      "0025B9" => ["Agilink", "Agilink Systems Corp."],
      "0025BA" => ["Alcatel-", "Alcatel-Lucent IPD"],
      "0025BB" => ["Innerint", "INNERINT Co., Ltd."],
      "0025BC" => ["Apple", "Apple, Inc"],
      "0025BD" => ["Italdata", "Italdata Ingegneria dell\'Idea S.p.A."],
      "0025BE" => ["Tektrap", "Tektrap Systems Inc."],
      "0025BF" => ["Wireless", "Wireless Cables Inc."],
      "0025C0" => ["Zilliont", "ZillionTV Corporation"],
      "0025C1" => ["NawooKor", "Nawoo Korea Corp."],
      "0025C2" => ["Ringbell", "RingBell Co.,Ltd."],
      "0025C3" => ["NortelNe", "Nortel Networks"],
      "0025C4" => ["RuckusWi", "Ruckus Wireless"],
      "0025C5" => ["StarLink", "Star Link Communication Pvt. Ltd."],
      "0025C6" => ["Kasercor", "kasercorp, ltd"],
      "0025C7" => ["Altek", "altek Corporation"],
      "0025C8" => ["S-Access", "S-Access GmbH"],
      "0025C9" => ["Shenzhen", "SHENZHEN HUAPU DIGITAL CO., LTD"],
      "0025CA" => ["LsResear", "LS Research, LLC"],
      "0025CB" => ["ReinerSc", "Reiner SCT"],
      "0025CC" => ["MobileCo", "Mobile Communications Korea Incorporated"],
      "0025CD" => ["SkylaneO", "Skylane Optics"],
      "0025CE" => ["Innerspa", "InnerSpace"],
      "0025CF" => ["NokiaDan", "Nokia Danmark A/S"],
      "0025D0" => ["NokiaDan", "Nokia Danmark A/S"],
      "0025D1" => ["EastechE", "Eastech Electronics (Taiwan) Inc."],
      "0025D2" => ["Inpegvis", "InpegVision Co., Ltd"],
      "0025D3" => ["Azurewav", "AzureWave Technologies, Inc"],
      "0025D4" => ["Fortress", "Fortress Technologies"],
      "0025D5" => ["Robonica", "Robonica (Pty) Ltd"],
      "0025D6" => ["Kroger", "The Kroger Co."],
      "0025D7" => ["Cedo",""],
      "0025D8" => ["KoreaMai", "KOREA MAINTENANCE"],
      "0025D9" => ["Datafab", "DataFab Systems Inc."],
      "0025DA" => ["SecuraKe", "Secura Key"],
      "0025DB" => ["AtiElect", "ATI Electronics(Shenzhen) Co., LTD"],
      "0025DC" => ["Sumitomo", "Sumitomo Electric Networks, Inc"],
      "0025DD" => ["Sunnytek", "SUNNYTEK INFORMATION CO., LTD."],
      "0025DE" => ["Probits", "Probits Co., LTD."],
      "0025DF" => ["Private",""],
      "0025E0" => ["CeedtecS", "CeedTec Sdn Bhd"],
      "0025E1" => ["Shanghai", "SHANGHAI SEEYOO ELECTRONIC & TECHNOLOGY CO., LTD"],
      "0025E2" => ["Everspri", "Everspring Industry Co., Ltd."],
      "0025E3" => ["Hanshini", "Hanshinit Inc."],
      "0025E4" => ["Omni-Wif", "OMNI-WiFi, LLC"],
      "0025E5" => ["LgElectr", "LG Electronics Inc"],
      "0025E6" => ["BelgianM", "Belgian Monitoring Systems bvba"],
      "0025E7" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "0025E8" => ["IdahoTec", "Idaho Technology"],
      "0025E9" => ["I-MateDe", "i-mate Development, Inc."],
      "0025EA" => ["IphionBv", "Iphion BV"],
      "0025EB" => ["ReutechR", "Reutech Radar Systems (PTY) Ltd"],
      "0025EC" => ["Humanwar", "Humanware"],
      "0025ED" => ["NuvoTech", "NuVo Technologies LLC"],
      "0025EE" => ["Avtex", "Avtex Ltd"],
      "0025EF" => ["I-Tec", "I-TEC Co., Ltd."],
      "0025F0" => ["SugaElec", "Suga Electronics Limited"],
      "0025F1" => ["Motorola", "Motorola Mobility, Inc."],
      "0025F2" => ["Motorola", "Motorola Mobility, Inc."],
      "0025F3" => ["Nordwest", "Nordwestdeutsche Zahlerrevision"],
      "0025F4" => ["KocoConn", "KoCo Connector AG"],
      "0025F5" => ["DvsKorea", "DVS Korea, Co., Ltd"],
      "0025F6" => ["NettalkC", "netTALK.com, Inc."],
      "0025F7" => ["AnsaldoS", "Ansaldo STS USA"],
      "0025F9" => ["GmkElect", "GMK electronic design GmbH"],
      "0025FA" => ["J&MAnaly", "J&M Analytik AG"],
      "0025FB" => ["Tunstall", "Tunstall Healthcare A/S"],
      "0025FC" => ["EndaEndu", "ENDA ENDUSTRIYEL ELEKTRONIK LTD. STI."],
      "0025FD" => ["ObrCentr", "OBR Centrum Techniki Morskiej S.A."],
      "0025FE" => ["PilotEle", "Pilot Electronics Corporation"],
      "0025FF" => ["CrenovaT", "CreNova Technology GmbH"],
      "002600" => ["TeacAust", "TEAC Australia Pty Ltd."],
      "002601" => ["Cutera", "Cutera Inc"],
      "002602" => ["SmartTem", "SMART Temps LLC"],
      "002603" => ["Shenzhen", "Shenzhen Wistar Technology Co., Ltd"],
      "002604" => ["AudioPro", "Audio Processing Technology Ltd"],
      "002605" => ["Cc", "CC Systems AB"],
      "002606" => ["Raumfeld", "RAUMFELD GmbH"],
      "002607" => ["Enabling", "Enabling Technology Pty Ltd"],
      "002608" => ["Apple", "Apple, Inc"],
      "002609" => ["Phyllis", "Phyllis Co., Ltd."],
      "00260A" => ["Cisco", "Cisco Systems"],
      "00260B" => ["Cisco", "Cisco Systems"],
      "00260C" => ["Dataram",""],
      "00260D" => ["Micronet", "Micronetics, Inc."],
      "00260E" => ["AblazeLl", "Ablaze Systems, LLC"],
      "00260F" => ["LinnProd", "Linn Products Ltd"],
      "002610" => ["Apacewav", "Apacewave Technologies"],
      "002611" => ["Licera", "Licera AB"],
      "002612" => ["SpaceExp", "Space Exploration Technologies"],
      "002613" => ["EngelAxi", "Engel Axil S.L."],
      "002614" => ["Ktnf",""],
      "002615" => ["Teracom", "Teracom Limited"],
      "002616" => ["Rosemoun", "Rosemount Inc."],
      "002617" => ["OemWorld", "OEM Worldwide"],
      "002618" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "002619" => ["Frc",""],
      "00261A" => ["Femtocom", "Femtocomm System Technology Corp."],
      "00261B" => ["LaurelBa", "LAUREL BANK MACHINES CO., LTD."],
      "00261C" => ["Neovia", "NEOVIA INC."],
      "00261D" => ["CopSecur", "COP SECURITY SYSTEM CORP."],
      "00261E" => ["Qingbang", "QINGBANG ELEC(SZ) CO., LTD"],
      "00261F" => ["SaeMagne", "SAE Magnetics (H.K.) Ltd."],
      "002620" => ["Isgus", "ISGUS GmbH"],
      "002621" => ["Intelicl", "InteliCloud Technology Inc."],
      "002622" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD."],
      "002623" => ["JrdCommu", "JRD Communication Inc"],
      "002624" => ["Thomson", "Thomson Inc."],
      "002625" => ["Mediaspu", "MediaSputnik"],
      "002626" => ["Geophysi", "Geophysical Survey Systems, Inc."],
      "002627" => ["Truesell",""],
      "002628" => ["Companyt", "companytec automacAo e controle ltda"],
      "002629" => ["JuphoonS", "Juphoon System Software Inc."],
      "00262A" => ["Proxense", "Proxense, LLC"],
      "00262B" => ["WongsEle", "Wongs Electronics Co. Ltd."],
      "00262C" => ["IktAdvan", "IKT Advanced Technologies s.r.o."],
      "00262D" => ["Wistron", "Wistron Corporation"],
      "00262E" => ["ChengduJ", "Chengdu Jiuzhou Electronic Technology Inc"],
      "00262F" => ["Hamamats", "HAMAMATSU TOA ELECTRONICS"],
      "002630" => ["AcorelSA", "ACOREL S.A.S"],
      "002631" => ["Commtact", "COMMTACT LTD"],
      "002632" => ["Instrume", "Instrumentation Technologies d.d."],
      "002633" => ["Mir-Medi", "MIR - Medical International Research"],
      "002634" => ["Infineta", "Infineta Systems, Inc"],
      "002635" => ["Bluetech", "Bluetechnix GmbH"],
      "002636" => ["Motorola", "Motorola Mobility, Inc."],
      "002637" => ["SamsungE", "Samsung Electro-Mechanics"],
      "002638" => ["XiaMenJo", "Xia Men Joyatech Co., Ltd."],
      "002639" => ["TMElectr", "T.M. Electronics, Inc."],
      "00263A" => ["Digitec", "Digitec Systems"],
      "00263B" => ["Onbnetec", "Onbnetech"],
      "00263C" => ["Bachmann", "Bachmann GmbH & Co. KG"],
      "00263D" => ["Mia", "MIA Corporation"],
      "00263E" => ["TrapezeN", "Trapeze Networks"],
      "00263F" => ["LiosTech", "LIOS Technology GmbH"],
      "002640" => ["BaustemB", "Baustem Broadband Technologies, Ltd."],
      "002641" => ["Motorola", "Motorola, Inc"],
      "002642" => ["Motorola", "Motorola, Inc"],
      "002643" => ["AlpsElec", "Alps Electric Co., Ltd"],
      "002644" => ["ThomsonT", "Thomson Telecom Belgium"],
      "002645" => ["Circontr", "Circontrol S.A."],
      "002646" => ["Shenyang", "SHENYANG TONGFANG MULTIMEDIA TECHNOLOGY COMPANY LIMITED"],
      "002647" => ["WfeTechn", "WFE TECHNOLOGY CORP."],
      "002648" => ["Emitech", "Emitech Corp."],
      "00264A" => ["Apple", "Apple, Inc"],
      "00264C" => ["Shanghai", "Shanghai DigiVision Technology Co., Ltd."],
      "00264D" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "00264E" => ["RailRoad", "Rail & Road Protec GmbH"],
      "00264F" => ["Kruger&G", "Kruger&Gothe GmbH"],
      "002650" => ["2wire",""],
      "002651" => ["Cisco", "Cisco Systems"],
      "002652" => ["Cisco", "Cisco Systems"],
      "002653" => ["Dayseque", "DaySequerra Corporation"],
      "002654" => ["3com", "3Com Corporation"],
      "002655" => ["Hewlett-", "Hewlett-Packard Company"],
      "002656" => ["Sansonic", "Sansonic Electronics USA"],
      "002657" => ["OooNppEk", "OOO NPP EKRA"],
      "002658" => ["T-Platfo", "T-Platforms (Cyprus) Limited"],
      "002659" => ["Nintendo", "Nintendo Co., Ltd."],
      "00265A" => ["D-Link", "D-Link Corporation"],
      "00265B" => ["HitronTe", "Hitron Technologies. Inc"],
      "00265C" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "00265D" => ["SamsungE", "Samsung Electronics"],
      "00265E" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "00265F" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "002660" => ["Logiways",""],
      "002661" => ["Irumtek", "Irumtek Co., Ltd."],
      "002662" => ["Actionte", "Actiontec Electronics, Inc"],
      "002663" => ["Shenzhen", "Shenzhen Huitaiwei Tech. Ltd, co."],
      "002664" => ["CoreSyst", "Core System Japan"],
      "002665" => ["Protecte", "ProtectedLogic Corporation"],
      "002666" => ["EfmNetwo", "EFM Networks"],
      "002667" => ["Carecom", "CARECOM CO.,LTD."],
      "002668" => ["NokiaDan", "Nokia Danmark A/S"],
      "002669" => ["NokiaDan", "Nokia Danmark A/S"],
      "00266A" => ["Essensiu", "ESSENSIUM NV"],
      "00266B" => ["ShineUni", "SHINE UNION ENTERPRISE LIMITED"],
      "00266C" => ["Inventec",""],
      "00266D" => ["Mobileac", "MobileAccess Networks"],
      "00266E" => ["Nissho-D", "Nissho-denki Co.,LTD."],
      "00266F" => ["Coordiwi", "Coordiwise Technology Corp."],
      "002670" => ["CinchCon", "Cinch Connectors"],
      "002671" => ["Autovisi", "AUTOVISION Co., Ltd"],
      "002672" => ["AampOfAm", "AAMP of America"],
      "002673" => ["Ricoh", "RICOH COMPANY LTD."],
      "002674" => ["Electron", "Electronic Solutions, Inc."],
      "002675" => ["AztechEl", "Aztech Electronics Pte Ltd"],
      "002676" => ["CommidtA", "COMMidt AS"],
      "002677" => ["Deif", "DEIF A/S"],
      "002678" => ["LogicIns", "Logic Instrument SA"],
      "002679" => ["Euphonic", "Euphonic Technologies, Inc."],
      "00267A" => ["WuhanHon", "wuhan hongxin telecommunication technologies co.,ltd"],
      "00267B" => ["GsiHelmh", "GSI Helmholtzzentrum fA r Schwerionenforschung GmbH"],
      "00267C" => ["Metz-Wer", "Metz-Werke GmbH & Co KG"],
      "00267D" => ["A-MaxTec", "A-Max Technology Macao Commercial Offshore Company Limited"],
      "00267E" => ["ParrotSa", "Parrot SA"],
      "00267F" => ["Zenterio", "Zenterio AB"],
      "002680" => ["LockieIn", "Lockie Innovation Pty Ltd"],
      "002681" => ["Interspi", "Interspiro AB"],
      "002682" => ["GemtekTe", "Gemtek Technology Co., Ltd."],
      "002683" => ["AjohoEnt", "Ajoho Enterprise Co., Ltd."],
      "002684" => ["KisanSys", "KISAN SYSTEM"],
      "002685" => ["DigitalI", "Digital Innovation"],
      "002686" => ["Quantenn", "Quantenna Communcations, Inc."],
      "002687" => ["AlliedTe", "ALLIED TELESIS, K.K corega division."],
      "002688" => ["JuniperN", "Juniper Networks"],
      "002689" => ["GeneralD", "General Dynamics Robotic Systems"],
      "00268A" => ["TerrierS", "Terrier SC Ltd"],
      "00268B" => ["Guangzho", "Guangzhou Escene Computer Technology Limited"],
      "00268C" => ["Starleaf", "StarLeaf Ltd."],
      "00268D" => ["CelltelS", "CellTel S.p.A."],
      "00268E" => ["AltaSolu", "Alta Solutions, Inc."],
      "00268F" => ["Mta", "MTA SpA"],
      "002690" => ["IDoIt", "I DO IT"],
      "002691" => ["SagemCom", "SAGEM COMMUNICATION"],
      "002692" => ["Mitsubis", "Mitsubishi Electric Co."],
      "002693" => ["QvidiumT", "QVidium Technologies, Inc."],
      "002694" => ["Senscien", "Senscient Ltd"],
      "002695" => ["ZtGroupI", "ZT Group Int\'l Inc"],
      "002696" => ["Noolix", "NOOLIX Co., Ltd"],
      "002697" => ["CheetahT", "Cheetah Technologies, L.P."],
      "002698" => ["Cisco", "Cisco Systems"],
      "002699" => ["Cisco", "Cisco Systems"],
      "00269A" => ["CarinaSy", "carina system co., ltd."],
      "00269B" => ["Sokrat", "SOKRAT Ltd."],
      "00269C" => ["ItusJapa", "ITUS JAPAN CO. LTD"],
      "00269D" => ["M2mnet", "M2Mnet Co., Ltd."],
      "00269E" => ["QuantaCo", "Quanta Computer Inc"],
      "00269F" => ["Private",""],
      "0026A0" => ["Moblic",""],
      "0026A1" => ["Megger",""],
      "0026A2" => ["Instrume", "Instrumentation Technology Systems"],
      "0026A3" => ["FqIngeni", "FQ Ingenieria Electronica S.A."],
      "0026A4" => ["NovusPro", "Novus Produtos Eletronicos Ltda"],
      "0026A5" => ["Microrob", "MICROROBOT.CO.,LTD"],
      "0026A6" => ["Trixell",""],
      "0026A7" => ["ConnectS", "CONNECT SRL"],
      "0026A8" => ["DaehapHy", "DAEHAP HYPER-TECH"],
      "0026A9" => ["StrongTe", "Strong Technologies Pty Ltd"],
      "0026AA" => ["KenmecMe", "Kenmec Mechanical Engineering Co., Ltd."],
      "0026AB" => ["SeikoEps", "SEIKO EPSON CORPORATION"],
      "0026AC" => ["Shanghai", "Shanghai LUSTER Teraband photonic Co., Ltd."],
      "0026AD" => ["Arada", "Arada Systems, Inc."],
      "0026AE" => ["Wireless", "Wireless Measurement Ltd"],
      "0026AF" => ["Duelco", "Duelco A/S"],
      "0026B0" => ["Apple", "Apple, Inc"],
      "0026B1" => ["NavisAut", "Navis Auto Motive Systems, Inc."],
      "0026B2" => ["Setrix", "Setrix AG"],
      "0026B3" => ["ThalesCo", "Thales Communications Inc"],
      "0026B4" => ["FordMoto", "Ford Motor Company"],
      "0026B5" => ["IcommTel", "ICOMM Tele Ltd"],
      "0026B6" => ["AskeyCom", "Askey Computer"],
      "0026B7" => ["Kingston", "Kingston Technology Company, Inc."],
      "0026B8" => ["Actionte", "Actiontec Electronics, Inc"],
      "0026B9" => ["Dell", "Dell Inc"],
      "0026BA" => ["Motorola", "Motorola Mobility, Inc."],
      "0026BB" => ["Apple", "Apple, Inc"],
      "0026BC" => ["GeneralJ", "General Jack Technology Ltd."],
      "0026BD" => ["JtecCard", "JTEC Card & Communication Co., Ltd."],
      "0026BE" => ["Schoonde", "Schoonderbeek Elektronica Systemen B.V."],
      "0026BF" => ["Shenzhen", "ShenZhen Temobi Science&Tech Development Co.,Ltd"],
      "0026C0" => ["Energyhu", "EnergyHub"],
      "0026C1" => ["Artray", "ARTRAY CO., LTD."],
      "0026C2" => ["Scdi", "SCDI Co. LTD"],
      "0026C3" => ["Insighte", "Insightek Corp."],
      "0026C4" => ["CadmosMi", "Cadmos microsystems S.r.l."],
      "0026C5" => ["Guangdon", "Guangdong Gosun Telecommunications Co.,Ltd"],
      "0026C6" => ["IntelCor", "Intel Corporate"],
      "0026C7" => ["IntelCor", "Intel Corporate"],
      "0026C8" => ["SystemSe", "System Sensor"],
      "0026C9" => ["Proventi", "Proventix Systems, Inc."],
      "0026CA" => ["Cisco", "Cisco Systems"],
      "0026CB" => ["Cisco", "Cisco Systems"],
      "0026CC" => ["NokiaDan", "Nokia Danmark A/S"],
      "0026CD" => ["Purpleco", "PurpleComm, Inc."],
      "0026CE" => ["KozumiUs", "Kozumi USA Corp."],
      "0026CF" => ["DekaR&D", "DEKA R&D"],
      "0026D0" => ["Semihalf",""],
      "0026D1" => ["SSquared", "S Squared Innovations Inc."],
      "0026D2" => ["Pcube", "Pcube Systems, Inc."],
      "0026D3" => ["ZenoInfo", "Zeno Information System"],
      "0026D4" => ["Irca", "IRCA SpA"],
      "0026D5" => ["OrySoluc", "Ory Solucoes em Comercio de Informatica Ltda."],
      "0026D6" => ["NingboAn", "Ningbo Andy Optoelectronic Co., Ltd."],
      "0026D7" => ["XiamenBb", "Xiamen BB Electron & Technology Co., Ltd."],
      "0026D8" => ["MagicPoi", "Magic Point Inc."],
      "0026D9" => ["Pace", "Pace plc"],
      "0026DA" => ["Universa", "Universal Media Corporation /Slovakia/ s.r.o."],
      "0026DB" => ["IonicsEm", "Ionics EMS Inc."],
      "0026DC" => ["OpticalD", "Optical Systems Design"],
      "0026DD" => ["Fival", "Fival Corporation"],
      "0026DE" => ["FdiMatel", "FDI MATELEC"],
      "0026DF" => ["TaidocTe", "TaiDoc Technology Corp."],
      "0026E0" => ["Asiteq",""],
      "0026E1" => ["Stanford", "Stanford University, OpenFlow Group"],
      "0026E2" => ["LgElectr", "LG Electronics"],
      "0026E3" => ["Dti",""],
      "0026E4" => ["CanalOve", "CANAL OVERSEAS"],
      "0026E5" => ["AegPower", "AEG Power Solutions"],
      "0026E6" => ["Visionhi", "Visionhitech Co., Ltd."],
      "0026E7" => ["Shanghai", "Shanghai ONLAN Communication Tech. Co., Ltd."],
      "0026E8" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "0026E9" => ["Sp", "SP Corp"],
      "0026EA" => ["Cheerchi", "Cheerchip Electronic Technology (ShangHai) Co., Ltd."],
      "0026EB" => ["Advanced", "Advanced Spectrum Technology Co., Ltd."],
      "0026EC" => ["LegrandH", "Legrand Home Systems, Inc"],
      "0026ED" => ["Zte", "zte corporation"],
      "0026EE" => ["Tkm", "TKM GmbH"],
      "0026EF" => ["Technolo", "Technology Advancement Group, Inc."],
      "0026F0" => ["CtrixsIn", "cTrixs International GmbH."],
      "0026F1" => ["Procurve", "ProCurve Networking by HP"],
      "0026F2" => ["Netgear",""],
      "0026F3" => ["SmcNetwo", "SMC Networks"],
      "0026F4" => ["Nesslab",""],
      "0026F5" => ["Xrplus", "XRPLUS Inc."],
      "0026F6" => ["Military", "Military Communication Institute"],
      "0026F7" => ["InfosysT", "Infosys Technologies Ltd."],
      "0026F8" => ["GoldenHi", "Golden Highway Industry Development Co., Ltd."],
      "0026F9" => ["SEMSrl", "S.E.M. srl"],
      "0026FA" => ["Bandrich", "BandRich Inc."],
      "0026FB" => ["AirdioWi", "AirDio Wireless, Inc."],
      "0026FC" => ["AcsipTec", "AcSiP Technology Corp."],
      "0026FD" => ["Interact", "Interactive Intelligence"],
      "0026FE" => ["MkdTechn", "MKD Technology Inc."],
      "0026FF" => ["Research", "Research In Motion"],
      "002700" => ["Shenzhen", "Shenzhen Siglent Technology Co., Ltd."],
      "002701" => ["Incostar", "INCOstartec GmbH"],
      "002702" => ["Solaredg", "SolarEdge Technologies"],
      "002703" => ["TestechE", "Testech Electronics Pte Ltd"],
      "002704" => ["Accelera", "Accelerated Concepts, Inc"],
      "002705" => ["Sectroni", "Sectronic"],
      "002706" => ["Yoisys",""],
      "002707" => ["LiftComp", "Lift Complex DS, JSC"],
      "002708" => ["NordiagA", "Nordiag ASA"],
      "002709" => ["Nintendo", "Nintendo Co., Ltd."],
      "00270A" => ["IeeSA", "IEE S.A."],
      "00270B" => ["AduraTec", "Adura Technologies"],
      "00270C" => ["Cisco", "Cisco Systems"],
      "00270D" => ["Cisco", "Cisco Systems"],
      "00270E" => ["IntelCor", "Intel Corporate"],
      "00270F" => ["Envision", "Envisionnovation Inc"],
      "002710" => ["IntelCor", "Intel Corporate"],
      "002711" => ["Lanpro", "LanPro Inc"],
      "002712" => ["Maxvisio", "MaxVision LLC"],
      "002713" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "002714" => ["Grainmus", "Grainmustards, Co,ltd."],
      "002715" => ["ReboundT", "Rebound Telecom. Co., Ltd"],
      "002716" => ["Adachi-S", "Adachi-Syokai Co., Ltd."],
      "002717" => ["CeDigita", "CE Digital(Zhenjiang)Co.,Ltd"],
      "002718" => ["SuzhouNe", "Suzhou NEW SEAUNION Video Technology Co.,Ltd"],
      "002719" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "00271A" => ["GeenovoT", "Geenovo Technology Ltd."],
      "00271B" => ["AlecSich", "Alec Sicherheitssysteme GmbH"],
      "00271C" => ["Mercury", "MERCURY CORPORATION"],
      "00271D" => ["CombaTel", "Comba Telecom Systems (China) Ltd."],
      "00271E" => ["XagylCom", "Xagyl Communications"],
      "00271F" => ["MiproEle", "MIPRO Electronics Co., Ltd"],
      "002720" => ["New-SolC", "NEW-SOL COM"],
      "002721" => ["Shenzhen", "Shenzhen Baoan Fenda Industrial Co., Ltd"],
      "002722" => ["Ubiquiti", "Ubiquiti Networks"],
      "0027F8" => ["BrocadeC", "Brocade Communications Systems, Inc"],
      "002A6A" => ["Cisco", "Cisco Systems"],
      "002AAF" => ["Larsys-A", "LARsys-Automation GmbH"],
      "002D76" => ["Titech", "TITECH GmbH"],
      "003000" => ["AllwellT", "ALLWELL TECHNOLOGY CORP."],
      "003001" => ["Smp",""],
      "003002" => ["ExpandNe", "Expand Networks"],
      "003003" => ["Phasys", "Phasys Ltd."],
      "003004" => ["LeadtekR", "LEADTEK RESEARCH INC."],
      "003005" => ["FujitsuS", "Fujitsu Siemens Computers"],
      "003006" => ["Superpow", "SUPERPOWER COMPUTER"],
      "003007" => ["Opti", "OPTI, INC."],
      "003008" => ["AvioDigi", "AVIO DIGITAL, INC."],
      "003009" => ["TachionN", "Tachion Networks, Inc."],
      "00300A" => ["AztechEl", "AZTECH Electronics Pte Ltd"],
      "00300B" => ["MphaseTe", "mPHASE Technologies, Inc."],
      "00300C" => ["Congruen", "CONGRUENCY, LTD."],
      "00300D" => ["MmcTechn", "MMC Technology, Inc."],
      "00300E" => ["KlotzDig", "Klotz Digital AG"],
      "00300F" => ["Imt-Info", "IMT - Information Management T"],
      "003010" => ["Visionet", "VISIONETICS INTERNATIONAL"],
      "003011" => ["HmsIndus", "HMS Industrial Networks"],
      "003012" => ["DigitalE", "DIGITAL ENGINEERING LTD."],
      "003013" => ["Nec", "NEC Corporation"],
      "003014" => ["Divio", "DIVIO, INC."],
      "003015" => ["CpClare", "CP CLARE CORP."],
      "003016" => ["Ishida", "ISHIDA CO., LTD."],
      "003017" => ["BluearcU", "BlueArc UK Ltd"],
      "003018" => ["JetwayIn", "Jetway Information Co., Ltd."],
      "003019" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00301A" => ["Smartbri", "SMARTBRIDGES PTE. LTD."],
      "00301B" => ["Shuttle", "SHUTTLE, INC."],
      "00301C" => ["Altvater", "ALTVATER AIRDATA SYSTEMS"],
      "00301D" => ["Skystrea", "SKYSTREAM, INC."],
      "00301E" => ["3comEuro", "3COM Europe Ltd."],
      "00301F" => ["OpticalN", "OPTICAL NETWORKS, INC."],
      "003020" => ["Tsi", "TSI, Inc.."],
      "003021" => ["HsingTec", "HSING TECH. ENTERPRISE CO.,LTD"],
      "003022" => ["FongKaiI", "Fong Kai Industrial Co., Ltd."],
      "003023" => ["CogentCo", "COGENT COMPUTER SYSTEMS, INC."],
      "003024" => ["Cisco", "CISCO SYSTEMS, INC."],
      "003025" => ["Checkout", "CHECKOUT COMPUTER SYSTEMS, LTD"],
      "003026" => ["HeitelDi", "HeiTel Digital Video GmbH"],
      "003027" => ["Kerbango", "KERBANGO, INC."],
      "003028" => ["FaseSald", "FASE Saldatura srl"],
      "003029" => ["Opicom",""],
      "00302A" => ["Southern", "SOUTHERN INFORMATION"],
      "00302B" => ["InalpNet", "INALP NETWORKS, INC."],
      "00302C" => ["Sylantro", "SYLANTRO SYSTEMS CORPORATION"],
      "00302D" => ["QuantumB", "QUANTUM BRIDGE COMMUNICATIONS"],
      "00302E" => ["HoftWess", "Hoft & Wessel AG"],
      "00302F" => ["GeAviati", "GE Aviation System"],
      "003030" => ["Harmonix", "HARMONIX CORPORATION"],
      "003031" => ["Lightwav", "LIGHTWAVE COMMUNICATIONS, INC."],
      "003032" => ["Magicram", "MagicRam, Inc."],
      "003033" => ["OrientTe", "ORIENT TELECOM CO., LTD."],
      "003034" => ["SetEngin", "SET ENGINEERING"],
      "003035" => ["Corning", "Corning Incorporated"],
      "003036" => ["RmpElekt", "RMP ELEKTRONIKSYSTEME GMBH"],
      "003037" => ["PackardB", "Packard Bell Nec Services"],
      "003038" => ["Xcp", "XCP, INC."],
      "003039" => ["Softbook", "SOFTBOOK PRESS"],
      "00303A" => ["Maatel",""],
      "00303B" => ["Powercom", "PowerCom Technology"],
      "00303C" => ["Onnto", "ONNTO CORP."],
      "00303D" => ["Iva", "IVA CORPORATION"],
      "00303E" => ["Radcom", "Radcom Ltd."],
      "00303F" => ["Turbocom", "TurboComm Tech Inc."],
      "003040" => ["Cisco", "CISCO SYSTEMS, INC."],
      "003041" => ["SaejinTM", "SAEJIN T & M CO., LTD."],
      "003042" => ["Detewe-D", "DeTeWe-Deutsche Telephonwerke"],
      "003043" => ["IdreamTe", "IDREAM TECHNOLOGIES, PTE. LTD."],
      "003044" => ["Cradlepo", "CradlePoint, Inc"],
      "003045" => ["VillageN", "Village Networks, Inc. (VNI)"],
      "003046" => ["Controll", "Controlled Electronic Manageme"],
      "003047" => ["NisseiEl", "NISSEI ELECTRIC CO., LTD."],
      "003048" => ["Supermic", "Supermicro Computer, Inc."],
      "003049" => ["BryantTe", "BRYANT TECHNOLOGY, LTD."],
      "00304A" => ["Fraunhof", "Fraunhofer IPMS"],
      "00304B" => ["Orbacom", "ORBACOM SYSTEMS, INC."],
      "00304C" => ["AppianCo", "APPIAN COMMUNICATIONS, INC."],
      "00304D" => ["Esi",""],
      "00304E" => ["BustecPr", "BUSTEC PRODUCTION LTD."],
      "00304F" => ["PlanetTe", "PLANET Technology Corporation"],
      "003050" => ["VersaTec", "Versa Technology"],
      "003051" => ["OrbitAvi", "ORBIT AVIONIC & COMMUNICATION"],
      "003052" => ["ElasticN", "ELASTIC NETWORKS"],
      "003053" => ["Basler", "Basler AG"],
      "003054" => ["Castlene", "CASTLENET TECHNOLOGY, INC."],
      "003055" => ["RenesasT", "Renesas Technology America, Inc."],
      "003056" => ["BeckIpc", "Beck IPC GmbH"],
      "003057" => ["Qtelnet", "QTelNet, Inc."],
      "003058" => ["ApiMotio", "API MOTION"],
      "003059" => ["KontronC", "KONTRON COMPACT COMPUTERS AG"],
      "00305A" => ["Telgen", "TELGEN CORPORATION"],
      "00305B" => ["Toko", "Toko Inc."],
      "00305C" => ["SmarLabo", "SMAR Laboratories Corp."],
      "00305D" => ["Digitra", "DIGITRA SYSTEMS, INC."],
      "00305E" => ["AbelkoIn", "Abelko Innovation"],
      "00305F" => ["Hasselbl", "Hasselblad"],
      "003060" => ["Powerfil", "Powerfile, Inc."],
      "003061" => ["Mobytel",""],
      "003062" => ["Path1Net", "PATH 1 NETWORK TECHNOL\'S INC."],
      "003063" => ["Santera", "SANTERA SYSTEMS, INC."],
      "003064" => ["AdlinkTe", "ADLINK TECHNOLOGY, INC."],
      "003065" => ["AppleCom", "APPLE COMPUTER, INC."],
      "003066" => ["Rfm",""],
      "003067" => ["BiostarM", "BIOSTAR MICROTECH INT\'L CORP."],
      "003068" => ["Cybernet", "CYBERNETICS TECH. CO., LTD."],
      "003069" => ["ImpacctT", "IMPACCT TECHNOLOGY CORP."],
      "00306A" => ["PentaMed", "PENTA MEDIA CO., LTD."],
      "00306B" => ["Cmos", "CMOS SYSTEMS, INC."],
      "00306C" => ["Hitex", "Hitex Holding GmbH"],
      "00306D" => ["LucentTe", "LUCENT TECHNOLOGIES"],
      "00306E" => ["HewlettP", "HEWLETT PACKARD"],
      "00306F" => ["SeyeonTe", "SEYEON TECH. CO., LTD."],
      "003070" => ["1net", "1Net Corporation"],
      "003071" => ["Cisco", "Cisco Systems, Inc."],
      "003072" => ["Intellib", "Intellibyte Inc."],
      "003073" => ["Internat", "International Microsystems, In"],
      "003074" => ["Equiinet", "EQUIINET LTD."],
      "003075" => ["Adtech",""],
      "003076" => ["Akamba", "Akamba Corporation"],
      "003077" => ["OnpremNe", "ONPREM NETWORKS"],
      "003078" => ["Cisco", "Cisco Systems, Inc."],
      "003079" => ["Cqos", "CQOS, INC."],
      "00307A" => ["Advanced", "Advanced Technology & Systems"],
      "00307B" => ["Cisco", "Cisco Systems, Inc."],
      "00307C" => ["AdidSa", "ADID SA"],
      "00307D" => ["GreAmeri", "GRE AMERICA, INC."],
      "00307E" => ["RedflexC", "Redflex Communication Systems"],
      "00307F" => ["Irlan", "IRLAN LTD."],
      "003080" => ["Cisco", "CISCO SYSTEMS, INC."],
      "003081" => ["AltosC&C", "ALTOS C&C"],
      "003082" => ["TaihanEl", "TAIHAN ELECTRIC WIRE CO., LTD."],
      "003083" => ["Ivron", "Ivron Systems"],
      "003084" => ["AlliedTe", "ALLIED TELESYN INTERNAIONAL"],
      "003085" => ["Cisco", "CISCO SYSTEMS, INC."],
      "003086" => ["Transist", "Transistor Devices, Inc."],
      "003087" => ["VegaGrie", "VEGA GRIESHABER KG"],
      "003088" => ["Ericsson",""],
      "003089" => ["Spectrap", "Spectrapoint Wireless, LLC"],
      "00308A" => ["NicotraS", "NICOTRA SISTEMI S.P.A"],
      "00308B" => ["BrixNetw", "Brix Networks"],
      "00308C" => ["Quantum", "Quantum Corporation"],
      "00308D" => ["Pinnacle", "Pinnacle Systems, Inc."],
      "00308E" => ["CrossMat", "CROSS MATCH TECHNOLOGIES, INC."],
      "00308F" => ["Micrilor", "MICRILOR, Inc."],
      "003090" => ["CyraTech", "CYRA TECHNOLOGIES, INC."],
      "003091" => ["TaiwanFi", "TAIWAN FIRST LINE ELEC. CORP."],
      "003092" => ["Modunorm", "ModuNORM GmbH"],
      "003093" => ["SonnetTe", "Sonnet Technologies, Inc"],
      "003094" => ["Cisco", "Cisco Systems, Inc."],
      "003095" => ["ProcompI", "Procomp Informatics, Ltd."],
      "003096" => ["Cisco", "CISCO SYSTEMS, INC."],
      "003097" => ["Regin", "AB Regin"],
      "003098" => ["GlobalCo", "Global Converging Technologies"],
      "003099" => ["BoenigUn", "BOENIG UND KALLENBACH OHG"],
      "00309A" => ["AstroTer", "ASTRO TERRA CORP."],
      "00309B" => ["Smartwar", "Smartware"],
      "00309C" => ["TimingAp", "Timing Applications, Inc."],
      "00309D" => ["NimbleMi", "Nimble Microsystems, Inc."],
      "00309E" => ["Workbit", "WORKBIT CORPORATION."],
      "00309F" => ["AmberNet", "AMBER NETWORKS"],
      "0030A0" => ["TycoSubm", "TYCO SUBMARINE SYSTEMS, LTD."],
      "0030A1" => ["Webgate", "WEBGATE Inc."],
      "0030A2" => ["Lightner", "Lightner Engineering"],
      "0030A3" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0030A4" => ["Woodwind", "Woodwind Communications System"],
      "0030A5" => ["ActivePo", "ACTIVE POWER"],
      "0030A6" => ["VianetTe", "VIANET TECHNOLOGIES, LTD."],
      "0030A7" => ["Schweitz", "SCHWEITZER ENGINEERING"],
      "0030A8" => ["OlECommu", "OL\'E COMMUNICATIONS, INC."],
      "0030A9" => ["Netivers", "Netiverse, Inc."],
      "0030AA" => ["AxusMicr", "AXUS MICROSYSTEMS, INC."],
      "0030AB" => ["DeltaNet", "DELTA NETWORKS, INC."],
      "0030AC" => ["SystemeL", "Systeme Lauer GmbH & Co., Ltd."],
      "0030AD" => ["Shanghai", "SHANGHAI COMMUNICATION"],
      "0030AE" => ["TimesNSy", "Times N System, Inc."],
      "0030AF" => ["Honeywel", "Honeywell GmbH"],
      "0030B0" => ["Converge", "Convergenet Technologies"],
      "0030B1" => ["Trunknet",""],
      "0030B2" => ["L-3Sonom", "L-3 Sonoma EO"],
      "0030B3" => ["SanValle", "San Valley Systems, Inc."],
      "0030B4" => ["Intersil", "INTERSIL CORP."],
      "0030B5" => ["TadiranM", "Tadiran Microwave Networks"],
      "0030B6" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0030B7" => ["Teletrol", "Teletrol Systems, Inc."],
      "0030B8" => ["Riverdel", "RiverDelta Networks"],
      "0030B9" => ["Ectel",""],
      "0030BA" => ["Ac&TSyst", "AC&T SYSTEM CO., LTD."],
      "0030BB" => ["Cacheflo", "CacheFlow, Inc."],
      "0030BC" => ["Optronic", "Optronic AG"],
      "0030BD" => ["BelkinCo", "BELKIN COMPONENTS"],
      "0030BE" => ["City-Net", "City-Net Technology, Inc."],
      "0030BF" => ["Multidat", "MULTIDATA GMBH"],
      "0030C0" => ["LaraTech", "Lara Technology, Inc."],
      "0030C1" => ["Hewlett-", "HEWLETT-PACKARD"],
      "0030C2" => ["Comone",""],
      "0030C3" => ["Flueckig", "FLUECKIGER ELEKTRONIK AG"],
      "0030C4" => ["CanonIma", "Canon Imaging Systems Inc."],
      "0030C5" => ["CadenceD", "CADENCE DESIGN SYSTEMS"],
      "0030C6" => ["ControlS", "CONTROL SOLUTIONS, INC."],
      "0030C7" => ["Macromat", "Macromate Corp."],
      "0030C8" => ["GadLine", "GAD LINE, LTD."],
      "0030C9" => ["LuxnN", "LuxN, N"],
      "0030CA" => ["Discover", "Discovery Com"],
      "0030CB" => ["OmniFlow", "OMNI FLOW COMPUTERS, INC."],
      "0030CC" => ["TenorNet", "Tenor Networks, Inc."],
      "0030CD" => ["Conexant", "CONEXANT SYSTEMS, INC."],
      "0030CE" => ["Zaffire",""],
      "0030CF" => ["TwoTechn", "TWO TECHNOLOGIES, INC."],
      "0030D0" => ["Tellabs",""],
      "0030D1" => ["Inova", "INOVA CORPORATION"],
      "0030D2" => ["WinTechn", "WIN TECHNOLOGIES, CO., LTD."],
      "0030D3" => ["AgilentT", "Agilent Technologies"],
      "0030D4" => ["Aae", "AAE Systems, Inc"],
      "0030D5" => ["Dresearc", "DResearch GmbH"],
      "0030D6" => ["MscVertr", "MSC VERTRIEBS GMBH"],
      "0030D7" => ["Innovati", "Innovative Systems, L.L.C."],
      "0030D8" => ["Sitek",""],
      "0030D9" => ["Datacore", "DATACORE SOFTWARE CORP."],
      "0030DA" => ["Comtrend", "COMTREND CO."],
      "0030DB" => ["Mindread", "Mindready Solutions, Inc."],
      "0030DC" => ["Rightech", "RIGHTECH CORPORATION"],
      "0030DD" => ["Indigita", "INDIGITA CORPORATION"],
      "0030DE" => ["WagoKont", "WAGO Kontakttechnik GmbH"],
      "0030DF" => ["Kb/TelTe", "KB/TEL TELECOMUNICACIONES"],
      "0030E0" => ["OxfordSe", "OXFORD SEMICONDUCTOR LTD."],
      "0030E1" => ["NetworkE", "Network Equipment Technologies, Inc."],
      "0030E2" => ["Garnet", "GARNET SYSTEMS CO., LTD."],
      "0030E3" => ["SedonaNe", "SEDONA NETWORKS CORP."],
      "0030E4" => ["ChiyodaS", "CHIYODA SYSTEM RIKEN"],
      "0030E5" => ["AmperDat", "Amper Datos S.A."],
      "0030E6" => ["DraegerM", "Draeger Medical Systems, Inc."],
      "0030E7" => ["CnfMobil", "CNF MOBILE SOLUTIONS, INC."],
      "0030E8" => ["Ensim", "ENSIM CORP."],
      "0030E9" => ["GmaCommu", "GMA COMMUNICATION MANUFACT\'G"],
      "0030EA" => ["Teraforc", "TeraForce Technology Corporation"],
      "0030EB" => ["Turbonet", "TURBONET COMMUNICATIONS, INC."],
      "0030EC" => ["Borgardt",""],
      "0030ED" => ["ExpertMa", "Expert Magnetics Corp."],
      "0030EE" => ["DsgTechn", "DSG Technology, Inc."],
      "0030EF" => ["NeonTech", "NEON TECHNOLOGY, INC."],
      "0030F0" => ["UniformI", "Uniform Industrial Corp."],
      "0030F1" => ["AcctonTe", "Accton Technology Corp."],
      "0030F2" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0030F3" => ["AtWorkCo", "At Work Computers"],
      "0030F4" => ["StardotT", "STARDOT TECHNOLOGIES"],
      "0030F5" => ["WildLab", "Wild Lab. Ltd."],
      "0030F6" => ["Securelo", "SECURELOGIX CORPORATION"],
      "0030F7" => ["Ramix", "RAMIX INC."],
      "0030F8" => ["Dynapro", "Dynapro Systems, Inc."],
      "0030F9" => ["Sollae", "Sollae Systems Co., Ltd."],
      "0030FA" => ["Telica", "TELICA, INC."],
      "0030FB" => ["AzsTechn", "AZS Technology AG"],
      "0030FC" => ["Terawave", "Terawave Communications, Inc."],
      "0030FD" => ["Integrat", "INTEGRATED SYSTEMS DESIGN"],
      "0030FE" => ["Dsa", "DSA GmbH"],
      "0030FF" => ["Datafab", "DATAFAB SYSTEMS, INC."],
      "00336C" => ["Synapsen", "SynapSense Corporation"],
      "0034F1" => ["RadicomR", "Radicom Research, Inc."],
      "003532" => ["Electro-", "Electro-Metrics Corporation"],
      "0036F8" => ["ContiTem", "Conti Temic microelectronic GmbH"],
      "0036FE" => ["Supervis", "SuperVision"],
      "00376D" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "003A98" => ["Cisco", "Cisco Systems"],
      "003A99" => ["Cisco", "Cisco Systems"],
      "003A9A" => ["Cisco", "Cisco Systems"],
      "003A9B" => ["Cisco", "Cisco Systems"],
      "003A9C" => ["Cisco", "Cisco Systems"],
      "003A9D" => ["NecAcces", "NEC AccessTechnica, Ltd."],
      "003AAF" => ["Bluebit", "BlueBit Ltd."],
      "003CC5" => ["WonwooEn", "WONWOO Engineering Co., Ltd"],
      "003D41" => ["Hattelan", "Hatteland Computer AS"],
      "003EE1" => ["Apple", "Apple, Inc."],
      "004000" => ["PciCompo", "PCI COMPONENTES DA AMZONIA LTD"],
      "004001" => ["ZeroOneT", "Zero One Technology Co. Ltd."],
      "004002" => ["Perle", "PERLE SYSTEMS LIMITED"],
      "004003" => ["EmersonP", "Emerson Process Management Power & Water Solutions, Inc."],
      "004004" => ["Icm", "ICM CO. LTD."],
      "004005" => ["AniCommu", "ANI COMMUNICATIONS INC."],
      "004006" => ["SampoTec", "SAMPO TECHNOLOGY CORPORATION"],
      "004007" => ["TelmatIn", "TELMAT INFORMATIQUE"],
      "004008" => ["APlusInf", "A PLUS INFO CORPORATION"],
      "004009" => ["Tachiban", "TACHIBANA TECTRON CO., LTD."],
      "00400A" => ["PivotalT", "PIVOTAL TECHNOLOGIES, INC."],
      "00400B" => ["Cresc",""],
      "00400C" => ["GeneralM", "GENERAL MICRO SYSTEMS, INC."],
      "00400D" => ["LannetDa", "LANNET DATA COMMUNICATIONS,LTD"],
      "00400E" => ["Memotec", "MEMOTEC, INC."],
      "00400F" => ["DatacomT", "DATACOM TECHNOLOGIES"],
      "004010" => ["Sonic", "SONIC SYSTEMS, INC."],
      "004011" => ["AndoverC", "ANDOVER CONTROLS CORPORATION"],
      "004012" => ["Windata", "WINDATA, INC."],
      "004013" => ["NttDataC", "NTT DATA COMM. SYSTEMS CORP."],
      "004014" => ["Comsoft", "COMSOFT GMBH"],
      "004015" => ["AscomInf", "ASCOM INFRASYS AG"],
      "004016" => ["Adc-Glob", "ADC - Global Connectivity Solutions Division"],
      "004017" => ["SilexTec", "Silex Technology America"],
      "004018" => ["Adobe", "ADOBE SYSTEMS, INC."],
      "004019" => ["Aeon", "AEON SYSTEMS, INC."],
      "00401A" => ["FujiElec", "FUJI ELECTRIC CO., LTD."],
      "00401B" => ["Printer", "PRINTER SYSTEMS CORP."],
      "00401C" => ["AstResea", "AST RESEARCH, INC."],
      "00401D" => ["Invisibl", "INVISIBLE SOFTWARE, INC."],
      "00401E" => ["Icc",""],
      "00401F" => ["Colorgra", "COLORGRAPH LTD"],
      "004020" => ["TeConnec", "TE Connectivity Ltd."],
      "004021" => ["RasterGr", "RASTER GRAPHICS"],
      "004022" => ["KleverCo", "KLEVER COMPUTERS, INC."],
      "004023" => ["Logic", "LOGIC CORPORATION"],
      "004024" => ["Compac", "COMPAC INC."],
      "004025" => ["Molecula", "MOLECULAR DYNAMICS"],
      "004026" => ["Buffalo", "Buffalo, Inc"],
      "004027" => ["SmcMassa", "SMC MASSACHUSETTS, INC."],
      "004028" => ["Netcomm", "NETCOMM LIMITED"],
      "004029" => ["Compex",""],
      "00402A" => ["Canoga-P", "CANOGA-PERKINS"],
      "00402B" => ["TrigemCo", "TRIGEM COMPUTER, INC."],
      "00402C" => ["IsisDist", "ISIS DISTRIBUTED SYSTEMS, INC."],
      "00402D" => ["HarrisAd", "HARRIS ADACOM CORPORATION"],
      "00402E" => ["Precisio", "PRECISION SOFTWARE, INC."],
      "00402F" => ["XlntDesi", "XLNT DESIGNS INC."],
      "004030" => ["GkComput", "GK COMPUTER"],
      "004031" => ["KokusaiE", "KOKUSAI ELECTRIC CO., LTD"],
      "004032" => ["DigitalC", "DIGITAL COMMUNICATIONS"],
      "004033" => ["AddtronT", "ADDTRON TECHNOLOGY CO., LTD."],
      "004034" => ["Bustek", "BUSTEK CORPORATION"],
      "004035" => ["Opcom",""],
      "004036" => ["TribeCom", "TRIBE COMPUTER WORKS, INC."],
      "004037" => ["Sea-Ilan", "SEA-ILAN, INC."],
      "004038" => ["TalentEl", "TALENT ELECTRIC INCORPORATED"],
      "004039" => ["OptecDai", "OPTEC DAIICHI DENKO CO., LTD."],
      "00403A" => ["ImpactTe", "IMPACT TECHNOLOGIES"],
      "00403B" => ["Synerjet", "SYNERJET INTERNATIONAL CORP."],
      "00403C" => ["Forks", "FORKS, INC."],
      "00403D" => ["Teradata", "Teradata Corporation"],
      "00403E" => ["RasterOp", "RASTER OPS CORPORATION"],
      "00403F" => ["Ssangyon", "SSANGYONG COMPUTER SYSTEMS"],
      "004040" => ["RingAcce", "RING ACCESS, INC."],
      "004041" => ["Fujikura", "FUJIKURA LTD."],
      "004042" => ["NAT", "N.A.T. GMBH"],
      "004043" => ["NokiaSie", "Nokia Siemens Networks GmbH & Co. KG."],
      "004044" => ["QnixComp", "QNIX COMPUTER CO., LTD."],
      "004045" => ["Twinhead", "TWINHEAD CORPORATION"],
      "004046" => ["UdcResea", "UDC RESEARCH LIMITED"],
      "004047" => ["WindRive", "WIND RIVER SYSTEMS"],
      "004048" => ["SmdInfor", "SMD INFORMATICA S.A."],
      "004049" => ["RocheDia", "Roche Diagnostics Ltd."],
      "00404A" => ["WestAust", "WEST AUSTRALIAN DEPARTMENT"],
      "00404B" => ["MapleCom", "MAPLE COMPUTER SYSTEMS"],
      "00404C" => ["Hypertec", "HYPERTEC PTY LTD."],
      "00404D" => ["Telecomm", "TELECOMMUNICATIONS TECHNIQUES"],
      "00404E" => ["Fluent", "FLUENT, INC."],
      "00404F" => ["SpaceNav", "SPACE & NAVAL WARFARE SYSTEMS"],
      "004050" => ["Ironics", "IRONICS, INCORPORATED"],
      "004051" => ["Gracilis", "GRACILIS, INC."],
      "004052" => ["StarTech", "STAR TECHNOLOGIES, INC."],
      "004053" => ["AmproCom", "AMPRO COMPUTERS"],
      "004054" => ["Connecti", "CONNECTION MACHINES SERVICES"],
      "004055" => ["Metronix", "METRONIX GMBH"],
      "004056" => ["McmJapan", "MCM JAPAN LTD."],
      "004057" => ["Lockheed", "LOCKHEED - SANDERS"],
      "004058" => ["Kronos", "KRONOS, INC."],
      "004059" => ["YoshidaK", "YOSHIDA KOGYO K. K."],
      "00405A" => ["Goldstar", "GOLDSTAR INFORMATION & COMM."],
      "00405B" => ["Funasset", "FUNASSET LIMITED"],
      "00405C" => ["Future", "FUTURE SYSTEMS, INC."],
      "00405D" => ["Star-Tek", "STAR-TEK, INC."],
      "00405E" => ["NorthHil", "NORTH HILLS ISRAEL"],
      "00405F" => ["AfeCompu", "AFE COMPUTERS LTD."],
      "004060" => ["Comendec", "COMENDEC LTD"],
      "004061" => ["Datatech", "DATATECH ENTERPRISES CO., LTD."],
      "004062" => ["E-System", "E-SYSTEMS, INC./GARLAND DIV."],
      "004063" => ["ViaTechn", "VIA TECHNOLOGIES, INC."],
      "004064" => ["KlaInstr", "KLA INSTRUMENTS CORPORATION"],
      "004065" => ["GteSpace", "GTE SPACENET"],
      "004066" => ["HitachiC", "HITACHI CABLE, LTD."],
      "004067" => ["Omnibyte", "OMNIBYTE CORPORATION"],
      "004068" => ["Extended", "EXTENDED SYSTEMS"],
      "004069" => ["Lemcom", "LEMCOM SYSTEMS, INC."],
      "00406A" => ["KentekIn", "KENTEK INFORMATION SYSTEMS,INC"],
      "00406B" => ["Sysgen",""],
      "00406C" => ["Coperniq", "COPERNIQUE"],
      "00406D" => ["Lanco", "LANCO, INC."],
      "00406E" => ["Corollar", "COROLLARY, INC."],
      "00406F" => ["SyncRese", "SYNC RESEARCH INC."],
      "004070" => ["Interwar", "INTERWARE CO., LTD."],
      "004071" => ["AtmCompu", "ATM COMPUTER GMBH"],
      "004072" => ["AppliedI", "Applied Innovation Inc."],
      "004073" => ["BassAsso", "BASS ASSOCIATES"],
      "004074" => ["CableAnd", "CABLE AND WIRELESS"],
      "004075" => ["TattileS", "Tattile SRL"],
      "004076" => ["SunConve", "Sun Conversion Technologies"],
      "004077" => ["MaxtonTe", "MAXTON TECHNOLOGY CORPORATION"],
      "004078" => ["WearnesA", "WEARNES AUTOMATION PTE LTD"],
      "004079" => ["JukoManu", "JUKO MANUFACTURE COMPANY, LTD."],
      "00407A" => ["SocieteD", "SOCIETE D\'EXPLOITATION DU CNIT"],
      "00407B" => ["Scientif", "SCIENTIFIC ATLANTA"],
      "00407C" => ["Qume", "QUME CORPORATION"],
      "00407D" => ["Extensio", "EXTENSION TECHNOLOGY CORP."],
      "00407E" => ["Evergree", "EVERGREEN SYSTEMS, INC."],
      "00407F" => ["Flir", "FLIR Systems"],
      "004080" => ["Athenix", "ATHENIX CORPORATION"],
      "004081" => ["Mannesma", "MANNESMANN SCANGRAPHIC GMBH"],
      "004082" => ["Laborato", "LABORATORY EQUIPMENT CORP."],
      "004083" => ["TdaIndus", "TDA INDUSTRIA DE PRODUTOS"],
      "004084" => ["Honeywel", "HONEYWELL ACS"],
      "004085" => ["SaabInst", "SAAB INSTRUMENTS AB"],
      "004086" => ["MichelsK", "MICHELS & KLEBERHOFF COMPUTER"],
      "004087" => ["Ubitrex", "UBITREX CORPORATION"],
      "004088" => ["MobiusTe", "MOBIUS TECHNOLOGIES, INC."],
      "004089" => ["Meidensh", "MEIDENSHA CORPORATION"],
      "00408A" => ["TpsTelep", "TPS TELEPROCESSING SYS. GMBH"],
      "00408B" => ["Raylan", "RAYLAN CORPORATION"],
      "00408C" => ["AxisComm", "AXIS COMMUNICATIONS AB"],
      "00408D" => ["Goodyear", "THE GOODYEAR TIRE & RUBBER CO."],
      "00408E" => ["TattileS", "Tattile SRL"],
      "00408F" => ["Wm-DataM", "WM-DATA MINFO AB"],
      "004090" => ["AnselCom", "ANSEL COMMUNICATIONS"],
      "004091" => ["ProcompI", "PROCOMP INDUSTRIA ELETRONICA"],
      "004092" => ["AspCompu", "ASP COMPUTER PRODUCTS, INC."],
      "004093" => ["PaxdataN", "PAXDATA NETWORKS LTD."],
      "004094" => ["Shograph", "SHOGRAPHICS, INC."],
      "004095" => ["RPTInter", "R.P.T. INTERGROUPS INT\'L LTD."],
      "004096" => ["Aironet			", "Cisco Systems, Inc."],
      "004097" => ["DatexDiv", "DATEX DIVISION OF"],
      "004098" => ["Dressler", "DRESSLER GMBH & CO."],
      "004099" => ["Newgen", "NEWGEN SYSTEMS CORP."],
      "00409A" => ["NetworkE", "NETWORK EXPRESS, INC."],
      "00409B" => ["HalCompu", "HAL COMPUTER SYSTEMS INC."],
      "00409C" => ["Transwar", "TRANSWARE"],
      "00409D" => ["Digiboar", "DIGIBOARD, INC."],
      "00409E" => ["Concurre", "CONCURRENT TECHNOLOGIES  LTD."],
      "00409F" => ["Telco", "Telco Systems, Inc."],
      "0040A0" => ["Goldstar", "GOLDSTAR CO., LTD."],
      "0040A1" => ["ErgoComp", "ERGO COMPUTING"],
      "0040A2" => ["Kingstar", "KINGSTAR TECHNOLOGY INC."],
      "0040A3" => ["Microuni", "MICROUNITY SYSTEMS ENGINEERING"],
      "0040A4" => ["RoseElec", "ROSE ELECTRONICS"],
      "0040A5" => ["Clinicom", "CLINICOMP INTL."],
      "0040A6" => ["Cray", "Cray, Inc."],
      "0040A7" => ["ItautecP", "ITAUTEC PHILCO S.A."],
      "0040A8" => ["ImfInter", "IMF INTERNATIONAL LTD."],
      "0040A9" => ["Datacom", "DATACOM INC."],
      "0040AA" => ["ValmetAu", "VALMET AUTOMATION INC."],
      "0040AB" => ["RolandDg", "ROLAND DG CORPORATION"],
      "0040AC" => ["SuperWor", "SUPER WORKSTATION, INC."],
      "0040AD" => ["SmaRegel", "SMA REGELSYSTEME GMBH"],
      "0040AE" => ["DeltaCon", "DELTA CONTROLS, INC."],
      "0040AF" => ["DigitalP", "DIGITAL PRODUCTS, INC."],
      "0040B0" => ["BytexEng", "BYTEX CORPORATION, ENGINEERING"],
      "0040B1" => ["Codonics", "CODONICS INC."],
      "0040B2" => ["Systemfo", "SYSTEMFORSCHUNG"],
      "0040B3" => ["Partech", "ParTech Inc."],
      "0040B4" => ["NextcomK", "NEXTCOM K.K."],
      "0040B5" => ["VideoTec", "VIDEO TECHNOLOGY COMPUTERS LTD"],
      "0040B6" => ["Computer", "COMPUTERM  CORPORATION"],
      "0040B7" => ["StealthC", "STEALTH COMPUTER SYSTEMS"],
      "0040B8" => ["IdeaAsso", "IDEA ASSOCIATES"],
      "0040B9" => ["MacqElec", "MACQ ELECTRONIQUE SA"],
      "0040BA" => ["AlliantC", "ALLIANT COMPUTER SYSTEMS CORP."],
      "0040BB" => ["Goldstar", "GOLDSTAR CABLE CO., LTD."],
      "0040BC" => ["Algorith", "ALGORITHMICS LTD."],
      "0040BD" => ["Starligh", "STARLIGHT NETWORKS, INC."],
      "0040BE" => ["BoeingDe", "BOEING DEFENSE & SPACE"],
      "0040BF" => ["ChannelI", "CHANNEL SYSTEMS INTERN\'L INC."],
      "0040C0" => ["VistaCon", "VISTA CONTROLS CORPORATION"],
      "0040C1" => ["Bizerba-", "BIZERBA-WERKE WILHEIM KRAUT"],
      "0040C2" => ["AppliedC", "APPLIED COMPUTING DEVICES"],
      "0040C3" => ["FischerA", "FISCHER AND PORTER CO."],
      "0040C4" => ["KinkeiSy", "KINKEI SYSTEM CORPORATION"],
      "0040C5" => ["MicomCom", "MICOM COMMUNICATIONS INC."],
      "0040C6" => ["Fibernet", "FIBERNET RESEARCH, INC."],
      "0040C7" => ["RubyTech", "RUBY TECH CORPORATION"],
      "0040C8" => ["MilanTec", "MILAN TECHNOLOGY CORPORATION"],
      "0040C9" => ["Ncube",""],
      "0040CA" => ["FirstInt", "FIRST INTERNAT\'L COMPUTER, INC"],
      "0040CB" => ["LanwanTe", "LANWAN TECHNOLOGIES"],
      "0040CC" => ["SilcomMa", "SILCOM MANUF\'G TECHNOLOGY INC."],
      "0040CD" => ["TeraMicr", "TERA MICROSYSTEMS, INC."],
      "0040CE" => ["Net-Sour", "NET-SOURCE, INC."],
      "0040CF" => ["Strawber", "STRAWBERRY TREE, INC."],
      "0040D0" => ["MitacInt", "MITAC INTERNATIONAL CORP."],
      "0040D1" => ["FukudaDe", "FUKUDA DENSHI CO., LTD."],
      "0040D2" => ["Pagine", "PAGINE CORPORATION"],
      "0040D3" => ["Kimpsion", "KIMPSION INTERNATIONAL CORP."],
      "0040D4" => ["GageTalk", "GAGE TALKER CORP."],
      "0040D5" => ["Sartoriu", "Sartorius Mechatronics T&H GmbH"],
      "0040D6" => ["Locamati", "LOCAMATION B.V."],
      "0040D7" => ["StudioGe", "STUDIO GEN INC."],
      "0040D8" => ["OceanOff", "OCEAN OFFICE AUTOMATION LTD."],
      "0040D9" => ["American", "AMERICAN MEGATRENDS INC."],
      "0040DA" => ["Telspec", "TELSPEC LTD"],
      "0040DB" => ["Advanced", "ADVANCED TECHNICAL SOLUTIONS"],
      "0040DC" => ["TritecEl", "TRITEC ELECTRONIC GMBH"],
      "0040DD" => ["HongTech", "HONG TECHNOLOGIES"],
      "0040DE" => ["ElsagDat", "Elsag Datamat spa"],
      "0040DF" => ["Digalog", "DIGALOG SYSTEMS, INC."],
      "0040E0" => ["Atomwide", "ATOMWIDE LTD."],
      "0040E1" => ["MarnerIn", "MARNER INTERNATIONAL, INC."],
      "0040E2" => ["MesaRidg", "MESA RIDGE TECHNOLOGIES, INC."],
      "0040E3" => ["Quin", "QUIN SYSTEMS LTD"],
      "0040E4" => ["E-MTechn", "E-M TECHNOLOGY, INC."],
      "0040E5" => ["Sybus", "SYBUS CORPORATION"],
      "0040E6" => ["CAEN", "C.A.E.N."],
      "0040E7" => ["ArnosIns", "ARNOS INSTRUMENTS & COMPUTER"],
      "0040E8" => ["CharlesR", "CHARLES RIVER DATA SYSTEMS,INC"],
      "0040E9" => ["Accord", "ACCORD SYSTEMS, INC."],
      "0040EA" => ["PlainTre", "PLAIN TREE SYSTEMS INC"],
      "0040EB" => ["MartinMa", "MARTIN MARIETTA CORPORATION"],
      "0040EC" => ["MikasaSy", "MIKASA SYSTEM ENGINEERING"],
      "0040ED" => ["NetworkC", "NETWORK CONTROLS INT\'NATL INC."],
      "0040EE" => ["Optimem",""],
      "0040EF" => ["Hypercom", "HYPERCOM, INC."],
      "0040F0" => ["Microbra", "MicroBrain,Inc."],
      "0040F1" => ["ChuoElec", "CHUO ELECTRONICS CO., LTD."],
      "0040F2" => ["JanichKl", "JANICH & KLASS COMPUTERTECHNIK"],
      "0040F3" => ["Netcor",""],
      "0040F4" => ["CameoCom", "CAMEO COMMUNICATIONS, INC."],
      "0040F5" => ["OemEngin", "OEM ENGINES"],
      "0040F6" => ["KatronCo", "KATRON COMPUTERS INC."],
      "0040F7" => ["Polaroid", "Polaroid Corporation"],
      "0040F8" => ["Systemha", "SYSTEMHAUS DISCOM"],
      "0040F9" => ["Combinet",""],
      "0040FA" => ["Microboa", "MICROBOARDS, INC."],
      "0040FB" => ["CascadeC", "CASCADE COMMUNICATIONS CORP."],
      "0040FC" => ["IbrCompu", "IBR COMPUTER TECHNIK GMBH"],
      "0040FD" => ["Lxe",""],
      "0040FE" => ["SymplexC", "SYMPLEX COMMUNICATIONS"],
      "0040FF" => ["Telebit", "TELEBIT CORPORATION"],
      "0041B4" => ["WuxiZhon", "Wuxi Zhongxing Optoelectronics Technology Co.,Ltd."],
      "004252" => ["RlxTechn", "RLX Technologies"],
      "0043FF" => ["KetronSR", "KETRON S.R.L."],
      "004501" => ["VersusTe", "Versus Technology, Inc."],
      "00464B" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "004854" => ["DigitalS", "Digital SemiConductor		21143/2 based 10/100"],
      "004F49" => ["Realtek",""],
      "004F4B" => ["PineTech", "Pine Technology Ltd."],
      "005000" => ["NexoComm", "NEXO COMMUNICATIONS, INC."],
      "005001" => ["Yamashit", "YAMASHITA SYSTEMS CORP."],
      "005002" => ["Omnisec", "OMNISEC AG"],
      "005003" => ["Xrite", "Xrite Inc"],
      "005004" => ["3com", "3COM CORPORATION"],
      "005006" => ["Tac", "TAC AB"],
      "005007" => ["SiemensT", "SIEMENS TELECOMMUNICATION SYSTEMS LIMITED"],
      "005008" => ["TivaMicr", "TIVA MICROCOMPUTER CORP. (TMC)"],
      "005009" => ["PhilipsB", "PHILIPS BROADBAND NETWORKS"],
      "00500A" => ["IrisTech", "IRIS TECHNOLOGIES, INC."],
      "00500B" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00500C" => ["E-TekLab", "e-Tek Labs, Inc."],
      "00500D" => ["SatoriEl", "SATORI ELECTORIC CO., LTD."],
      "00500E" => ["Chromati", "CHROMATIS NETWORKS, INC."],
      "00500F" => ["Cisco", "CISCO SYSTEMS, INC."],
      "005010" => ["NovanetL", "NovaNET Learning, Inc."],
      "005012" => ["Cbl-", "CBL - GMBH"],
      "005013" => ["Chaparra", "Chaparral Network Storage"],
      "005014" => ["Cisco", "CISCO SYSTEMS, INC."],
      "005015" => ["BrightSt", "BRIGHT STAR ENGINEERING"],
      "005016" => ["Sst/Wood", "SST/WOODHEAD INDUSTRIES"],
      "005017" => ["RsrSRL", "RSR S.R.L."],
      "005018" => ["Amit", "AMIT, Inc."],
      "005019" => ["SpringTi", "SPRING TIDE NETWORKS, INC."],
      "00501A" => ["Iqinvisi", "IQinVision"],
      "00501B" => ["AblCanad", "ABL CANADA, INC."],
      "00501C" => ["Jatom", "JATOM SYSTEMS, INC."],
      "00501E" => ["MirandaT", "Miranda Technologies, Inc."],
      "00501F" => ["Mrg", "MRG SYSTEMS, LTD."],
      "005020" => ["Mediasta", "MEDIASTAR CO., LTD."],
      "005021" => ["EisInter", "EIS INTERNATIONAL, INC."],
      "005022" => ["ZonetTec", "ZONET TECHNOLOGY, INC."],
      "005023" => ["PgDesign", "PG DESIGN ELECTRONICS, INC."],
      "005024" => ["Navic", "NAVIC SYSTEMS, INC."],
      "005026" => ["Cosystem", "COSYSTEMS, INC."],
      "005027" => ["Genicom", "GENICOM CORPORATION"],
      "005028" => ["AvalComm", "AVAL COMMUNICATIONS"],
      "005029" => ["1394Prin", "1394 PRINTER WORKING GROUP"],
      "00502A" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00502B" => ["Genrad", "GENRAD LTD."],
      "00502C" => ["SoyoComp", "SOYO COMPUTER, INC."],
      "00502D" => ["Accel", "ACCEL, INC."],
      "00502E" => ["Cambex", "CAMBEX CORPORATION"],
      "00502F" => ["Tollbrid", "TollBridge Technologies, Inc."],
      "005030" => ["FuturePl", "FUTURE PLUS SYSTEMS"],
      "005031" => ["Aeroflex", "AEROFLEX LABORATORIES, INC."],
      "005032" => ["PicazoCo", "PICAZO COMMUNICATIONS, INC."],
      "005033" => ["MayanNet", "MAYAN NETWORKS"],
      "005036" => ["Netcam", "NETCAM, LTD."],
      "005037" => ["KogaElec", "KOGA ELECTRONICS CO."],
      "005038" => ["DainTele", "DAIN TELECOM CO., LTD."],
      "005039" => ["MarinerN", "MARINER NETWORKS"],
      "00503A" => ["DatongEl", "DATONG ELECTRONICS LTD."],
      "00503B" => ["Mediafir", "MEDIAFIRE CORPORATION"],
      "00503C" => ["Tsinghua", "TSINGHUA NOVEL ELECTRONICS"],
      "00503E" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00503F" => ["AnchorGa", "ANCHOR GAMES"],
      "005040" => ["Panasoni", "Panasonic Electric Works Co., Ltd."],
      "005041" => ["Coretron", "Coretronic Corporation"],
      "005042" => ["SciManuf", "SCI MANUFACTURING SINGAPORE PTE, LTD."],
      "005043" => ["MarvellS", "MARVELL SEMICONDUCTOR, INC."],
      "005044" => ["Asaca", "ASACA CORPORATION"],
      "005045" => ["Rioworks", "RIOWORKS SOLUTIONS, INC."],
      "005046" => ["MenicxIn", "MENICX INTERNATIONAL CO., LTD."],
      "005047" => ["Private",""],
      "005048" => ["Infolibr", "INFOLIBRIA"],
      "005049" => ["ArborNet", "Arbor Networks Inc"],
      "00504A" => ["EltecoAS", "ELTECO A.S."],
      "00504B" => ["Barconet", "BARCONET N.V."],
      "00504C" => ["GalilMot", "Galil Motion Control"],
      "00504D" => ["TokyoEle", "Tokyo Electron Device Limited"],
      "00504E" => ["SierraMo", "SIERRA MONITOR CORP."],
      "00504F" => ["OlencomE", "OLENCOM ELECTRONICS"],
      "005050" => ["Cisco", "CISCO SYSTEMS, INC."],
      "005051" => ["IwatsuEl", "IWATSU ELECTRIC CO., LTD."],
      "005052" => ["TiaraNet", "TIARA NETWORKS, INC."],
      "005053" => ["Cisco", "CISCO SYSTEMS, INC."],
      "005054" => ["Cisco", "CISCO SYSTEMS, INC."],
      "005055" => ["Doms", "DOMS A/S"],
      "005056" => ["Vmware", "VMware, Inc."],
      "005057" => ["Broadban", "BROADBAND ACCESS SYSTEMS"],
      "005058" => ["Vegastre", "VegaStream Group Limted"],
      "005059" => ["Ibahn",""],
      "00505A" => ["NetworkA", "NETWORK ALCHEMY, INC."],
      "00505B" => ["Kawasaki", "KAWASAKI LSI U.S.A., INC."],
      "00505C" => ["Tundo", "TUNDO CORPORATION"],
      "00505E" => ["DigitekM", "DIGITEK MICROLOGIC S.A."],
      "00505F" => ["BrandInn", "BRAND INNOVATORS"],
      "005060" => ["Tandberg", "TANDBERG TELECOM AS"],
      "005062" => ["KouwellE", "KOUWELL ELECTRONICS CORP.  **"],
      "005063" => ["OyComsel", "OY COMSEL SYSTEM AB"],
      "005064" => ["CaeElect", "CAE ELECTRONICS"],
      "005065" => ["Tdk-Lamb", "TDK-Lambda Corporation"],
      "005066" => ["AtecomAd", "AtecoM GmbH advanced telecomunication modules"],
      "005067" => ["Aerocomm", "AEROCOMM, INC."],
      "005068" => ["Electron", "ELECTRONIC INDUSTRIES ASSOCIATION"],
      "005069" => ["Pixstrea", "PixStream Incorporated"],
      "00506A" => ["Edeva", "EDEVA, INC."],
      "00506B" => ["Spx-Ateg",""],
      "00506C" => ["BeijerEl", "Beijer Electronics Products AB"],
      "00506D" => ["Videojet", "VIDEOJET SYSTEMS"],
      "00506E" => ["CorderEn", "CORDER ENGINEERING CORPORATION"],
      "00506F" => ["G-Connec", "G-CONNECT"],
      "005070" => ["Chaintec", "CHAINTECH COMPUTER CO., LTD."],
      "005071" => ["Aiwa", "AIWA CO., LTD."],
      "005072" => ["Corvis", "CORVIS CORPORATION"],
      "005073" => ["Cisco", "CISCO SYSTEMS, INC."],
      "005074" => ["Advanced", "ADVANCED HI-TECH CORP."],
      "005075" => ["KestrelS", "KESTREL SOLUTIONS"],
      "005076" => ["Ibm", "IBM Corp"],
      "005077" => ["Prolific", "PROLIFIC TECHNOLOGY, INC."],
      "005078" => ["MegatonH", "MEGATON HOUSE, LTD."],
      "005079" => ["Private",""],
      "00507A" => ["Xpeed", "XPEED, INC."],
      "00507B" => ["MerlotCo", "MERLOT COMMUNICATIONS"],
      "00507C" => ["Videocon", "VIDEOCON AG"],
      "00507D" => ["Ifp",""],
      "00507E" => ["NewerTec", "NEWER TECHNOLOGY"],
      "00507F" => ["Draytek", "DrayTek Corp."],
      "005080" => ["Cisco", "CISCO SYSTEMS, INC."],
      "005081" => ["MurataMa", "MURATA MACHINERY, LTD."],
      "005082" => ["Foresson", "FORESSON CORPORATION"],
      "005083" => ["Gilbarco", "GILBARCO, INC."],
      "005084" => ["AtlProdu", "ATL PRODUCTS"],
      "005086" => ["TelkomSa", "TELKOM SA, LTD."],
      "005087" => ["Terasaki", "TERASAKI ELECTRIC CO., LTD."],
      "005088" => ["Amano", "AMANO CORPORATION"],
      "005089" => ["SafetyMa", "SAFETY MANAGEMENT SYSTEMS"],
      "00508B" => ["Hewlett-", "Hewlett-Packard Company"],
      "00508C" => ["Rsi", "RSI SYSTEMS"],
      "00508D" => ["AbitComp", "ABIT COMPUTER CORPORATION"],
      "00508E" => ["Optimati", "OPTIMATION, INC."],
      "00508F" => ["AsitaTec", "ASITA TECHNOLOGIES INT\'L LTD."],
      "005090" => ["Dctri",""],
      "005091" => ["Netacces", "NETACCESS, INC."],
      "005092" => ["RigakuIn", "RIGAKU INDUSTRIAL CORPORATION"],
      "005093" => ["Boeing",""],
      "005094" => ["Pace", "PACE plc"],
      "005095" => ["PeracomN", "PERACOM NETWORKS"],
      "005096" => ["SalixTec", "SALIX TECHNOLOGIES, INC."],
      "005097" => ["Mmc-Embe", "MMC-EMBEDDED COMPUTERTECHNIK GmbH"],
      "005098" => ["Globaloo", "GLOBALOOP, LTD."],
      "005099" => ["3comEuro", "3COM EUROPE, LTD."],
      "00509A" => ["TagElect", "TAG ELECTRONIC SYSTEMS"],
      "00509B" => ["Switchco", "SWITCHCORE AB"],
      "00509C" => ["BetaRese", "BETA RESEARCH"],
      "00509D" => ["Industre", "THE INDUSTREE B.V."],
      "00509E" => ["LesTechn", "Les Technologies SoftAcoustik Inc."],
      "00509F" => ["HorizonC", "HORIZON COMPUTER"],
      "0050A0" => ["DeltaCom", "DELTA COMPUTER SYSTEMS, INC."],
      "0050A1" => ["CarloGav", "CARLO GAVAZZI, INC."],
      "0050A2" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0050A3" => ["Transmed", "TransMedia Communications, Inc."],
      "0050A4" => ["IoTech", "IO TECH, INC."],
      "0050A5" => ["CapitolB", "CAPITOL BUSINESS SYSTEMS, LTD."],
      "0050A6" => ["Optronic", "OPTRONICS"],
      "0050A7" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0050A8" => ["Opencon", "OpenCon Systems, Inc."],
      "0050A9" => ["MoldatWi", "MOLDAT WIRELESS TECHNOLGIES"],
      "0050AA" => ["KonicaMi", "KONICA MINOLTA HOLDINGS, INC."],
      "0050AB" => ["Naltec", "NALTEC, Inc."],
      "0050AC" => ["MapleCom", "MAPLE COMPUTER CORPORATION"],
      "0050AD" => ["Communiq", "CommUnique Wireless Corp."],
      "0050AE" => ["IwakiEle", "IWAKI ELECTRONICS CO., LTD."],
      "0050AF" => ["Intergon", "INTERGON, INC."],
      "0050B0" => ["Technolo", "TECHNOLOGY ATLANTA CORPORATION"],
      "0050B1" => ["Giddings", "GIDDINGS & LEWIS"],
      "0050B2" => ["BrodelAu", "BRODEL AUTOMATION"],
      "0050B3" => ["Voiceboa", "VOICEBOARD CORPORATION"],
      "0050B4" => ["Satchwel", "SATCHWELL CONTROL SYSTEMS, LTD"],
      "0050B5" => ["Fichet-B", "FICHET-BAUCHE"],
      "0050B6" => ["GoodWayI", "GOOD WAY IND. CO., LTD."],
      "0050B7" => ["BoserTec", "BOSER TECHNOLOGY CO., LTD."],
      "0050B8" => ["InovaCom", "INOVA COMPUTERS GMBH & CO. KG"],
      "0050B9" => ["XitronTe", "XITRON TECHNOLOGIES, INC."],
      "0050BA" => ["D-Link",""],
      "0050BB" => ["CmsTechn", "CMS TECHNOLOGIES"],
      "0050BC" => ["HammerSt", "HAMMER STORAGE SOLUTIONS"],
      "0050BD" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0050BE" => ["FastMult", "FAST MULTIMEDIA AG"],
      "0050BF" => ["Metallig", "Metalligence Technology Corp."],
      "0050C0" => ["Gatan", "GATAN, INC."],
      "0050C1" => ["GemflexN", "GEMFLEX NETWORKS, LTD."],
      "0050C2" => ["IeeeRegi", "IEEE REGISTRATION AUTHORITY"],
      "0050C4" => ["Imd",""],
      "0050C5" => ["AdsTechn", "ADS Technologies, Inc"],
      "0050C6" => ["LoopTele", "LOOP TELECOMMUNICATION INTERNATIONAL, INC."],
      "0050C8" => ["Addonics", "Addonics Technologies, Inc."],
      "0050C9" => ["MasproDe", "MASPRO DENKOH CORP."],
      "0050CA" => ["NetToNet", "NET TO NET TECHNOLOGIES"],
      "0050CB" => ["Jetter",""],
      "0050CC" => ["Xyratex",""],
      "0050CD" => ["Digiansw", "DIGIANSWER A/S"],
      "0050CE" => ["LgIntern", "LG INTERNATIONAL CORP."],
      "0050CF" => ["VanlinkC", "VANLINK COMMUNICATION TECHNOLOGY RESEARCH INSTITUTE"],
      "0050D0" => ["Minerva", "MINERVA SYSTEMS"],
      "0050D1" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0050D2" => ["CmcElect", "CMC Electronics Inc"],
      "0050D3" => ["DigitalA", "DIGITAL AUDIO PROCESSING PTY. LTD."],
      "0050D4" => ["JoohongI", "JOOHONG INFORMATION &"],
      "0050D5" => ["Ad", "AD SYSTEMS CORP."],
      "0050D6" => ["AtlasCop", "ATLAS COPCO TOOLS AB"],
      "0050D7" => ["Telstrat",""],
      "0050D8" => ["UnicornC", "UNICORN COMPUTER CORP."],
      "0050D9" => ["Engetron", "ENGETRON-ENGENHARIA ELETRONICA IND. e COM. LTDA"],
      "0050DA" => ["3com", "3COM CORPORATION"],
      "0050DB" => ["Contempo", "CONTEMPORARY CONTROL"],
      "0050DC" => ["TasTelef", "TAS TELEFONBAU A. SCHWABE GMBH & CO. KG"],
      "0050DD" => ["SerraSol", "SERRA SOLDADURA, S.A."],
      "0050DE" => ["Signum", "SIGNUM SYSTEMS CORP."],
      "0050DF" => ["Airfiber", "AirFiber, Inc."],
      "0050E1" => ["NsTechEl", "NS TECH ELECTRONICS SDN BHD"],
      "0050E2" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0050E3" => ["Motorola", "Motorola, Inc."],
      "0050E4" => ["AppleCom", "APPLE COMPUTER, INC."],
      "0050E6" => ["Hakusan", "HAKUSAN CORPORATION"],
      "0050E7" => ["Paradise", "PARADISE INNOVATIONS (ASIA)"],
      "0050E8" => ["Nomadix", "NOMADIX INC."],
      "0050EA" => ["XelCommu", "XEL COMMUNICATIONS, INC."],
      "0050EB" => ["Alpha-To", "ALPHA-TOP CORPORATION"],
      "0050EC" => ["Olicom", "OLICOM A/S"],
      "0050ED" => ["AndaNetw", "ANDA NETWORKS"],
      "0050EE" => ["TekDigit", "TEK DIGITEL CORPORATION"],
      "0050EF" => ["SpeSyste", "SPE Systemhaus GmbH"],
      "0050F0" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0050F1" => ["Intel", "Intel Corporation"],
      "0050F2" => ["Microsof", "MICROSOFT CORP."],
      "0050F3" => ["GlobalNe", "GLOBAL NET INFORMATION CO., Ltd."],
      "0050F4" => ["Sigmatek", "SIGMATEK GMBH & CO. KG"],
      "0050F6" => ["Pan-Inte", "PAN-INTERNATIONAL INDUSTRIAL CORP."],
      "0050F7" => ["VentureM", "VENTURE MANUFACTURING (SINGAPORE) LTD."],
      "0050F8" => ["EntregaT", "ENTREGA TECHNOLOGIES, INC."],
      "0050F9" => ["Sensorma", "SENSORMATIC ACD"],
      "0050FA" => ["Oxtel", "OXTEL, LTD."],
      "0050FB" => ["VskElect", "VSK ELECTRONICS"],
      "0050FC" => ["EdimaxTe", "EDIMAX TECHNOLOGY CO., LTD."],
      "0050FD" => ["Visionco", "VISIONCOMM CO., LTD."],
      "0050FE" => ["PctvnetA", "PCTVnet ASA"],
      "0050FF" => ["HakkoEle", "HAKKO ELECTRONICS CO., LTD."],
      "005218" => ["WuxiKebo", "Wuxi Keboda Electron Co.Ltd"],
      "0054AF" => ["Continen", "Continental Automotive Systems Inc."],
      "005500" => ["Xerox",""],
      "005CB1" => ["GospellD", "Gospell DIGITAL TECHNOLOGY CO., LTD"],
      "006000" => ["Xycom", "XYCOM INC."],
      "006001" => ["Innosys", "InnoSys, Inc."],
      "006002" => ["ScreenSu", "SCREEN SUBTITLING SYSTEMS, LTD"],
      "006003" => ["TeraokaW", "TERAOKA WEIGH SYSTEM PTE, LTD."],
      "006004" => ["Computad", "COMPUTADORES MODULARES SA"],
      "006005" => ["Feedback", "FEEDBACK DATA LTD."],
      "006006" => ["Sotec", "SOTEC CO., LTD"],
      "006007" => ["AcresGam", "ACRES GAMING, INC."],
      "006008" => ["3com", "3COM CORPORATION"],
      "006009" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00600A" => ["SordComp", "SORD COMPUTER CORPORATION"],
      "00600B" => ["Logware", "LOGWARE GmbH"],
      "00600C" => ["Eurotech", "Eurotech Inc."],
      "00600D" => ["DigitalL", "Digital Logic GmbH"],
      "00600E" => ["WavenetI", "WAVENET INTERNATIONAL, INC."],
      "00600F" => ["Westell", "WESTELL, INC."],
      "006010" => ["NetworkM", "NETWORK MACHINES, INC."],
      "006011" => ["CrystalS", "CRYSTAL SEMICONDUCTOR CORP."],
      "006012" => ["PowerCom", "POWER COMPUTING CORPORATION"],
      "006013" => ["NetstalM", "NETSTAL MASCHINEN AG"],
      "006014" => ["Edec", "EDEC CO., LTD."],
      "006015" => ["Net2net", "NET2NET CORPORATION"],
      "006016" => ["Clariion",""],
      "006017" => ["Tokimec", "TOKIMEC INC."],
      "006018" => ["StellarO", "STELLAR ONE CORPORATION"],
      "006019" => ["RocheDia", "Roche Diagnostics"],
      "00601A" => ["Keithley", "KEITHLEY INSTRUMENTS"],
      "00601B" => ["MesaElec", "MESA ELECTRONICS"],
      "00601C" => ["Telxon", "TELXON CORPORATION"],
      "00601D" => ["LucentTe", "LUCENT TECHNOLOGIES"],
      "00601E" => ["Softlab", "SOFTLAB, INC."],
      "00601F" => ["Stallion", "STALLION TECHNOLOGIES"],
      "006020" => ["PivotalN", "PIVOTAL NETWORKING, INC."],
      "006021" => ["Dsc", "DSC CORPORATION"],
      "006022" => ["Vicom", "VICOM SYSTEMS, INC."],
      "006023" => ["PericomS", "PERICOM SEMICONDUCTOR CORP."],
      "006024" => ["Gradient", "GRADIENT TECHNOLOGIES, INC."],
      "006025" => ["ActiveIm", "ACTIVE IMAGING PLC"],
      "006026" => ["VikingMo", "VIKING Modular Solutions"],
      "006027" => ["Superior", "Superior Modular Products"],
      "006028" => ["Macrovis", "MACROVISION CORPORATION"],
      "006029" => ["CaryPeri", "CARY PERIPHERALS INC."],
      "00602A" => ["Symicron", "SYMICRON COMPUTER COMMUNICATIONS, LTD."],
      "00602B" => ["PeakAudi", "PEAK AUDIO"],
      "00602C" => ["LinxData", "LINX Data Terminals, Inc."],
      "00602D" => ["AlertonT", "ALERTON TECHNOLOGIES, INC."],
      "00602E" => ["Cyclades", "CYCLADES CORPORATION"],
      "00602F" => ["Cisco", "CISCO SYSTEMS, INC."],
      "006030" => ["VillageT", "VILLAGE TRONIC ENTWICKLUNG"],
      "006031" => ["Hrk", "HRK SYSTEMS"],
      "006032" => ["I-Cube", "I-CUBE, INC."],
      "006033" => ["AcuityIm", "ACUITY IMAGING, INC."],
      "006034" => ["RobertBo", "ROBERT BOSCH GmbH"],
      "006035" => ["DallasSe", "DALLAS SEMICONDUCTOR, INC."],
      "006036" => ["AitAustr", "AIT Austrian Institute of Technology GmbH"],
      "006037" => ["NxpSemic", "NXP Semiconductors"],
      "006038" => ["NortelNe", "Nortel Networks"],
      "006039" => ["SancomTe", "SanCom Technology, Inc."],
      "00603A" => ["QuickCon", "QUICK CONTROLS LTD."],
      "00603B" => ["Amtec", "AMTEC spa"],
      "00603C" => ["Hagiwara", "HAGIWARA SYS-COM CO., LTD."],
      "00603D" => ["3cx",""],
      "00603E" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00603F" => ["Patapsco", "PATAPSCO DESIGNS"],
      "006040" => ["Netro", "NETRO CORP."],
      "006041" => ["Yokogawa", "Yokogawa Electric Corporation"],
      "006042" => ["TksUsa", "TKS (USA), INC."],
      "006043" => ["Idirect", "iDirect, INC."],
      "006044" => ["Litton/P", "LITTON/POLY-SCIENTIFIC"],
      "006045" => ["Pathligh", "PATHLIGHT TECHNOLOGIES"],
      "006046" => ["Vmetro", "VMETRO, INC."],
      "006047" => ["Cisco", "CISCO SYSTEMS, INC."],
      "006048" => ["Emc", "EMC CORPORATION"],
      "006049" => ["VinaTech", "VINA TECHNOLOGIES"],
      "00604A" => ["SaicIdea", "SAIC IDEAS GROUP"],
      "00604B" => ["Safe-Com", "Safe-com GmbH & Co. KG"],
      "00604C" => ["SagemCom", "SAGEM COMMUNICATION"],
      "00604D" => ["MmcNetwo", "MMC NETWORKS, INC."],
      "00604E" => ["CycleCom", "CYCLE COMPUTER CORPORATION, INC."],
      "00604F" => ["TattileS", "Tattile SRL"],
      "006050" => ["Internix", "INTERNIX INC."],
      "006051" => ["QualityS", "QUALITY SEMICONDUCTOR"],
      "006052" => ["Peripher", "PERIPHERALS ENTERPRISE CO., Ltd."],
      "006053" => ["ToyodaMa", "TOYODA MACHINE WORKS, LTD."],
      "006054" => ["Controlw", "CONTROLWARE GMBH"],
      "006055" => ["CornellU", "CORNELL UNIVERSITY"],
      "006056" => ["NetworkT", "NETWORK TOOLS, INC."],
      "006057" => ["MurataMa", "MURATA MANUFACTURING CO., LTD."],
      "006058" => ["CopperMo", "COPPER MOUNTAIN COMMUNICATIONS, INC."],
      "006059" => ["Technica", "TECHNICAL COMMUNICATIONS CORP."],
      "00605A" => ["Celcore", "CELCORE, INC."],
      "00605B" => ["Intraser", "IntraServer Technology, Inc."],
      "00605C" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00605D" => ["Scanival", "SCANIVALVE CORP."],
      "00605E" => ["LibertyT", "LIBERTY TECHNOLOGY NETWORKING"],
      "00605F" => ["NipponUn", "NIPPON UNISOFT CORPORATION"],
      "006060" => ["DawningT", "DAWNING TECHNOLOGIES, INC."],
      "006061" => ["WhistleC", "WHISTLE COMMUNICATIONS CORP."],
      "006062" => ["Telesync", "TELESYNC, INC."],
      "006063" => ["PsionDac", "PSION DACOM PLC."],
      "006064" => ["Netcomm", "NETCOMM LIMITED"],
      "006065" => ["Bernecke", "BERNECKER & RAINER INDUSTRIE-ELEKTRONIC GmbH"],
      "006066" => ["LacroixT", "LACROIX Trafic"],
      "006067" => ["AcerNetx", "ACER NETXUS INC."],
      "006068" => ["Dialogic", "Dialogic Corporation"],
      "006069" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "00606A" => ["Mitsubis", "MITSUBISHI WIRELESS COMMUNICATIONS. INC."],
      "00606B" => ["Synclaye", "Synclayer Inc."],
      "00606C" => ["Arescom",""],
      "00606D" => ["DigitalE", "DIGITAL EQUIPMENT CORP."],
      "00606E" => ["DavicomS", "DAVICOM SEMICONDUCTOR, INC."],
      "00606F" => ["ClarionO", "CLARION CORPORATION OF AMERICA"],
      "006070" => ["Cisco", "CISCO SYSTEMS, INC."],
      "006071" => ["MidasLab", "MIDAS LAB, INC."],
      "006072" => ["VxlInstr", "VXL INSTRUMENTS, LIMITED"],
      "006073" => ["Redcreek", "REDCREEK COMMUNICATIONS, INC."],
      "006074" => ["QscAudio", "QSC AUDIO PRODUCTS"],
      "006075" => ["Pentek", "PENTEK, INC."],
      "006076" => ["Schlumbe", "SCHLUMBERGER TECHNOLOGIES RETAIL PETROLEUM SYSTEMS"],
      "006077" => ["PrisaNet", "PRISA NETWORKS"],
      "006078" => ["PowerMea", "POWER MEASUREMENT LTD."],
      "006079" => ["Mainstre", "Mainstream Data, Inc."],
      "00607A" => ["Dvs", "DVS GmbH"],
      "00607B" => ["Fore", "FORE SYSTEMS, INC."],
      "00607C" => ["Waveacce", "WaveAccess, Ltd."],
      "00607D" => ["Sentient", "SENTIENT NETWORKS INC."],
      "00607E" => ["Gigalabs", "GIGALABS, INC."],
      "00607F" => ["AuroraTe", "AURORA TECHNOLOGIES, INC."],
      "006080" => ["Microtro", "MICROTRONIX DATACOM LTD."],
      "006081" => ["Tv/ComIn", "TV/COM INTERNATIONAL"],
      "006082" => ["Novalink", "NOVALINK TECHNOLOGIES, INC."],
      "006083" => ["Cisco", "CISCO SYSTEMS, INC."],
      "006084" => ["DigitalV", "DIGITAL VIDEO"],
      "006085" => ["StorageC", "Storage Concepts"],
      "006086" => ["LogicRep", "LOGIC REPLACEMENT TECH. LTD."],
      "006087" => ["KansaiEl", "KANSAI ELECTRIC CO., LTD."],
      "006088" => ["WhiteMou", "WHITE MOUNTAIN DSP, INC."],
      "006089" => ["Xata",""],
      "00608A" => ["CitadelC", "CITADEL COMPUTER"],
      "00608B" => ["Conferte", "ConferTech International"],
      "00608C" => ["3com", "3COM CORPORATION"],
      "00608D" => ["Unipulse", "UNIPULSE CORP."],
      "00608E" => ["HeElectr", "HE ELECTRONICS, TECHNOLOGIE & SYSTEMTECHNIK GmbH"],
      "00608F" => ["TekramTe", "TEKRAM TECHNOLOGY CO., LTD."],
      "006090" => ["ArtizaNe", "Artiza Networks Inc"],
      "006091" => ["FirstPac", "FIRST PACIFIC NETWORKS, INC."],
      "006092" => ["Micro/Sy", "MICRO/SYS, INC."],
      "006093" => ["Varian",""],
      "006094" => ["Ibm", "IBM Corp"],
      "006095" => ["Accu-Tim", "ACCU-TIME SYSTEMS, INC."],
      "006096" => ["TSMicrot", "T.S. MICROTECH INC."],
      "006097" => ["3com", "3COM CORPORATION"],
      "006098" => ["HtCommun", "HT COMMUNICATIONS"],
      "006099" => ["Sbe", "SBE, Inc."],
      "00609A" => ["NjkTechn", "NJK TECHNO CO."],
      "00609B" => ["Astro-Me", "ASTRO-MED, INC."],
      "00609C" => ["Perkin-E", "Perkin-Elmer Incorporated"],
      "00609D" => ["PmiFoodE", "PMI FOOD EQUIPMENT GROUP"],
      "00609E" => ["AscX3-In", "ASC X3 - INFORMATION TECHNOLOGY STANDARDS SECRETARIATS"],
      "00609F" => ["Phast", "PHAST CORPORATION"],
      "0060A0" => ["Switched", "SWITCHED NETWORK TECHNOLOGIES, INC."],
      "0060A1" => ["Vpnet", "VPNet, Inc."],
      "0060A2" => ["NihonUni", "NIHON UNISYS LIMITED CO."],
      "0060A3" => ["Continuu", "CONTINUUM TECHNOLOGY CORP."],
      "0060A4" => ["Grinaker", "GRINAKER SYSTEM TECHNOLOGIES"],
      "0060A5" => ["Performa", "PERFORMANCE TELECOM CORP."],
      "0060A6" => ["Particle", "PARTICLE MEASURING SYSTEMS"],
      "0060A7" => ["Microsen", "MICROSENS GmbH & CO. KG"],
      "0060A8" => ["Tidomat", "TIDOMAT AB"],
      "0060A9" => ["GesytecM", "GESYTEC MbH"],
      "0060AA" => ["Intellig", "INTELLIGENT DEVICES INC. (IDI)"],
      "0060AB" => ["Larscom", "LARSCOM INCORPORATED"],
      "0060AC" => ["Resilien", "RESILIENCE CORPORATION"],
      "0060AD" => ["Megachip", "MegaChips Corporation"],
      "0060AE" => ["TrioInfo", "TRIO INFORMATION SYSTEMS AB"],
      "0060AF" => ["PacificM", "PACIFIC MICRO DATA, INC."],
      "0060B0" => ["HP",""],
      "0060B1" => ["Input/Ou", "INPUT/OUTPUT, INC."],
      "0060B2" => ["ProcessC", "PROCESS CONTROL CORP."],
      "0060B3" => ["Z-Com", "Z-COM, INC."],
      "0060B4" => ["Glenayre", "GLENAYRE R&D INC."],
      "0060B5" => ["Keba", "KEBA GmbH"],
      "0060B6" => ["LandComp", "LAND COMPUTER CO., LTD."],
      "0060B7" => ["Channelm", "CHANNELMATIC, INC."],
      "0060B8" => ["Corelis", "CORELIS Inc."],
      "0060B9" => ["NecInfro", "NEC Infrontia Corporation"],
      "0060BA" => ["SaharaNe", "SAHARA NETWORKS, INC."],
      "0060BB" => ["Cabletro", "CABLETRON - NETLINK, INC."],
      "0060BC" => ["Keunyoun", "KeunYoung Electronics & Communication Co., Ltd."],
      "0060BD" => ["Hubbell-", "HUBBELL-PULSECOM"],
      "0060BE" => ["Webtroni", "WEBTRONICS"],
      "0060BF" => ["Macraigo", "MACRAIGOR SYSTEMS, INC."],
      "0060C0" => ["NeraNetw", "Nera Networks AS"],
      "0060C1" => ["Wavespan", "WaveSpan Corporation"],
      "0060C2" => ["Mpl", "MPL AG"],
      "0060C3" => ["Netvisio", "NETVISION CORPORATION"],
      "0060C4" => ["SolitonK", "SOLITON SYSTEMS K.K."],
      "0060C5" => ["Ancot", "ANCOT CORP."],
      "0060C6" => ["Dcs", "DCS AG"],
      "0060C7" => ["AmatiCom", "AMATI COMMUNICATIONS CORP."],
      "0060C8" => ["KukaWeld", "KUKA WELDING SYSTEMS & ROBOTS"],
      "0060C9" => ["Controln", "ControlNet, Inc."],
      "0060CA" => ["Harmonic", "HARMONIC SYSTEMS INCORPORATED"],
      "0060CB" => ["HitachiZ", "HITACHI ZOSEN CORPORATION"],
      "0060CC" => ["Emtrak", "EMTRAK, INCORPORATED"],
      "0060CD" => ["Videoser", "VideoServer, Inc."],
      "0060CE" => ["AcclaimC", "ACCLAIM COMMUNICATIONS"],
      "0060CF" => ["AlteonNe", "ALTEON NETWORKS, INC."],
      "0060D0" => ["SnmpRese", "SNMP RESEARCH INCORPORATED"],
      "0060D1" => ["CascadeC", "CASCADE COMMUNICATIONS"],
      "0060D2" => ["LucentTe", "LUCENT TECHNOLOGIES TAIWAN TELECOMMUNICATIONS CO., LTD."],
      "0060D3" => ["At&T",""],
      "0060D4" => ["EldatCom", "ELDAT COMMUNICATION LTD."],
      "0060D5" => ["MiyachiT", "MIYACHI TECHNOS CORP."],
      "0060D6" => ["NovatelW", "NovAtel Wireless Technologies Ltd."],
      "0060D7" => ["EcolePol", "ECOLE POLYTECHNIQUE FEDERALE DE LAUSANNE (EPFL)"],
      "0060D8" => ["Elmic", "ELMIC SYSTEMS, INC."],
      "0060D9" => ["TransysN", "TRANSYS NETWORKS INC."],
      "0060DA" => ["JbmElect", "JBM ELECTRONICS CO."],
      "0060DB" => ["NtpElekt", "NTP ELEKTRONIK A/S"],
      "0060DC" => ["ToyoNetw", "Toyo Network Systems  & System Integration Co. LTD"],
      "0060DD" => ["Myricom", "MYRICOM, INC."],
      "0060DE" => ["Kayser-T", "Kayser-Threde GmbH"],
      "0060DF" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "0060E0" => ["AxiomTec", "AXIOM TECHNOLOGY CO., LTD."],
      "0060E1" => ["OrckitCo", "ORCKIT COMMUNICATIONS LTD."],
      "0060E2" => ["QuestEng", "QUEST ENGINEERING & DEVELOPMENT"],
      "0060E3" => ["ArbinIns", "ARBIN INSTRUMENTS"],
      "0060E4" => ["Compuser", "COMPUSERVE, INC."],
      "0060E5" => ["FujiAuto", "FUJI AUTOMATION CO., LTD."],
      "0060E6" => ["Shomiti", "SHOMITI SYSTEMS INCORPORATED"],
      "0060E7" => ["Randata",""],
      "0060E8" => ["HitachiC", "HITACHI COMPUTER PRODUCTS (AMERICA), INC."],
      "0060E9" => ["AtopTech", "ATOP TECHNOLOGIES, INC."],
      "0060EA" => ["Streamlo", "StreamLogic"],
      "0060EB" => ["Fourthtr", "FOURTHTRACK SYSTEMS"],
      "0060EC" => ["HermaryO", "HERMARY OPTO ELECTRONICS INC."],
      "0060ED" => ["RicardoT", "RICARDO TEST AUTOMATION LTD."],
      "0060EE" => ["Apollo",""],
      "0060EF" => ["FlytechT", "FLYTECH TECHNOLOGY CO., LTD."],
      "0060F0" => ["JohnsonJ", "JOHNSON & JOHNSON MEDICAL, INC"],
      "0060F1" => ["ExpCompu", "EXP COMPUTER, INC."],
      "0060F2" => ["Lasergra", "LASERGRAPHICS, INC."],
      "0060F3" => ["Performa", "Performance Analysis Broadband, Spirent plc"],
      "0060F4" => ["Advanced", "ADVANCED COMPUTER SOLUTIONS, Inc."],
      "0060F5" => ["IconWest", "ICON WEST, INC."],
      "0060F6" => ["NextestC", "NEXTEST COMMUNICATIONS PRODUCTS, INC."],
      "0060F7" => ["Datafusi", "DATAFUSION SYSTEMS"],
      "0060F8" => ["LoranInt", "Loran International Technologies Inc."],
      "0060F9" => ["DiamondL", "DIAMOND LANE COMMUNICATIONS"],
      "0060FA" => ["Educatio", "EDUCATIONAL TECHNOLOGY RESOURCES, INC."],
      "0060FB" => ["Packetee", "PACKETEER, INC."],
      "0060FC" => ["Conserva", "CONSERVATION THROUGH INNOVATION LTD."],
      "0060FD" => ["Netics", "NetICs, Inc."],
      "0060FE" => ["LynxSyst", "LYNX SYSTEM DEVELOPERS, INC."],
      "0060FF" => ["Quvis", "QuVis, Inc."],
      "006440" => ["Cisco", "Cisco Systems"],
      "0064A6" => ["MaquetCa", "Maquet CardioVascular"],
      "006B9E" => ["Vizio", "VIZIO Inc"],
      "006BA0" => ["Shenzhen", "SHENZHEN UNIVERSAL INTELLISYS PTE LTD"],
      "006DFB" => ["VutrixUk", "Vutrix (UK) Ltd"],
      "0070B0" => ["M/A-ComC", "M/A-COM INC. COMPANIES"],
      "0070B3" => ["DataReca", "DATA RECALL LTD."],
      "00789E" => ["Sagemcom",""],
      "007F28" => ["Actionte", "Actiontec Electronics, Inc"],
      "008000" => ["Multitec", "MULTITECH SYSTEMS, INC."],
      "008001" => ["Periphon", "PERIPHONICS CORPORATION"],
      "008002" => ["Satelcom", "SATELCOM (UK) LTD"],
      "008003" => ["HytecEle", "HYTEC ELECTRONICS LTD."],
      "008004" => ["AntlowCo", "ANTLOW COMMUNICATIONS, LTD."],
      "008005" => ["CactusCo", "CACTUS COMPUTER INC."],
      "008006" => ["Compuadd", "COMPUADD CORPORATION"],
      "008007" => ["DlogNc-S", "DLOG NC-SYSTEME"],
      "008008" => ["Dynatech", "DYNATECH COMPUTER SYSTEMS"],
      "008009" => ["Jupiter", "JUPITER SYSTEMS, INC."],
      "00800A" => ["JapanCom", "JAPAN COMPUTER CORP."],
      "00800B" => ["Csk", "CSK CORPORATION"],
      "00800C" => ["Videcom", "VIDECOM LIMITED"],
      "00800D" => ["Vosswink", "VOSSWINKEL F.U."],
      "00800E" => ["Atlantix", "ATLANTIX CORPORATION"],
      "00800F" => ["SMC",""],
      "008010" => ["Commodor", "COMMODORE INTERNATIONAL"],
      "008011" => ["DigitalI", "DIGITAL SYSTEMS INT\'L. INC."],
      "008012" => ["Integrat", "INTEGRATED MEASUREMENT SYSTEMS"],
      "008013" => ["Thomas-C", "THOMAS-CONRAD CORPORATION"],
      "008014" => ["Esprit", "ESPRIT SYSTEMS"],
      "008015" => ["Seiko", "SEIKO SYSTEMS, INC."],
      "008016" => ["WandelAn", "WANDEL AND GOLTERMANN"],
      "008017" => ["Pfu", "PFU LIMITED"],
      "008018" => ["KobeStee", "KOBE STEEL, LTD."],
      "008019" => ["DaynaCom", "DAYNA COMMUNICATIONS, INC."],
      "00801A" => ["BellAtla", "BELL ATLANTIC"],
      "00801B" => ["KodiakTe", "KODIAK TECHNOLOGY"],
      "00801C" => ["Cisco		", "NEWPORT SYSTEMS SOLUTIONS"],
      "00801D" => ["Integrat", "INTEGRATED INFERENCE MACHINES"],
      "00801E" => ["Xinetron", "XINETRON, INC."],
      "00801F" => ["KruppAtl", "KRUPP ATLAS ELECTRONIK GMBH"],
      "008020" => ["NetworkP", "NETWORK PRODUCTS"],
      "008021" => ["AlcatelC", "Alcatel Canada Inc."],
      "008022" => ["Scan-Opt", "SCAN-OPTICS"],
      "008023" => ["Integrat", "INTEGRATED BUSINESS NETWORKS"],
      "008024" => ["Kalpana", "KALPANA, INC."],
      "008025" => ["Stollman", "STOLLMANN GMBH"],
      "008026" => ["NetworkP", "NETWORK PRODUCTS CORPORATION"],
      "008027" => ["Adaptive", "ADAPTIVE SYSTEMS, INC."],
      "008028" => ["Tradpost", "TRADPOST (HK) LTD"],
      "008029" => ["EagleTec", "EAGLE TECHNOLOGY, INC."],
      "00802A" => ["TestSimu", "TEST SYSTEMS & SIMULATIONS INC"],
      "00802B" => ["Integrat", "INTEGRATED MARKETING CO"],
      "00802C" => ["SageGrou", "THE SAGE GROUP PLC"],
      "00802D" => ["Xylogics", "XYLOGICS INC"],
      "00802E" => ["CastleRo", "CASTLE ROCK COMPUTING"],
      "00802F" => ["National", "NATIONAL INSTRUMENTS CORP."],
      "008030" => ["NexusEle", "NEXUS ELECTRONICS"],
      "008031" => ["Basys", "BASYS, CORP."],
      "008032" => ["Access", "ACCESS CO., LTD."],
      "008033" => ["EmsAviat", "EMS Aviation, Inc."],
      "008034" => ["SmtGoupi", "SMT GOUPIL"],
      "008035" => ["Technolo", "TECHNOLOGY WORKS, INC."],
      "008036" => ["ReflexMa", "REFLEX MANUFACTURING SYSTEMS"],
      "008037" => ["Ericsson", "Ericsson Group"],
      "008038" => ["DataRese", "DATA RESEARCH & APPLICATIONS"],
      "008039" => ["AlcatelS", "ALCATEL STC AUSTRALIA"],
      "00803A" => ["Varitype", "VARITYPER, INC."],
      "00803B" => ["AptCommu", "APT COMMUNICATIONS, INC."],
      "00803C" => ["TvsElect", "TVS ELECTRONICS LTD"],
      "00803D" => ["Surigike", "SURIGIKEN CO.,  LTD."],
      "00803E" => ["Synernet", "SYNERNETICS"],
      "00803F" => ["Tatung", "TATUNG COMPANY"],
      "008040" => ["JohnFluk", "JOHN FLUKE MANUFACTURING CO."],
      "008041" => ["VebKombi", "VEB KOMBINAT ROBOTRON"],
      "008042" => ["EmersonN", "Emerson Network Power"],
      "008043" => ["Networld", "NETWORLD, INC."],
      "008044" => ["SystechC", "SYSTECH COMPUTER CORP."],
      "008045" => ["Matsushi", "MATSUSHITA ELECTRIC IND. CO"],
      "008046" => ["TattileS", "Tattile SRL"],
      "008047" => ["In-Net", "IN-NET CORP."],
      "008048" => ["Compex", "COMPEX INCORPORATED"],
      "008049" => ["NissinEl", "NISSIN ELECTRIC CO., LTD."],
      "00804A" => ["Pro-Log",""],
      "00804B" => ["EagleTec", "EAGLE TECHNOLOGIES PTY.LTD."],
      "00804C" => ["Contec", "CONTEC CO., LTD."],
      "00804D" => ["CycloneM", "CYCLONE MICROSYSTEMS, INC."],
      "00804E" => ["ApexComp", "APEX COMPUTER COMPANY"],
      "00804F" => ["DaikinIn", "DAIKIN INDUSTRIES, LTD."],
      "008050" => ["Ziatech", "ZIATECH CORPORATION"],
      "008051" => ["Fibermux",""],
      "008052" => ["Technica", "TECHNICALLY ELITE CONCEPTS"],
      "008053" => ["Intellic", "INTELLICOM, INC."],
      "008054" => ["Frontier", "FRONTIER TECHNOLOGIES CORP."],
      "008055" => ["Fermilab",""],
      "008056" => ["SphinxEl", "SPHINX ELEKTRONIK GMBH"],
      "008057" => ["Adsoft", "ADSOFT, LTD."],
      "008058" => ["Printer", "PRINTER SYSTEMS CORPORATION"],
      "008059" => ["StanleyE", "STANLEY ELECTRIC CO., LTD"],
      "00805A" => ["TulipCom", "TULIP COMPUTERS INTERNAT\'L B.V"],
      "00805B" => ["Condor", "CONDOR SYSTEMS, INC."],
      "00805C" => ["Agilis", "AGILIS CORPORATION"],
      "00805D" => ["Canstar",""],
      "00805E" => ["LsiLogic", "LSI LOGIC CORPORATION"],
      "00805F" => ["Hewlett-", "Hewlett-Packard Company"],
      "008060" => ["NetworkI", "NETWORK INTERFACE CORPORATION"],
      "008061" => ["Litton", "LITTON SYSTEMS, INC."],
      "008062" => ["Interfac", "INTERFACE  CO."],
      "008063" => ["Hirschma", "Hirschmann Automation and Control GmbH"],
      "008064" => ["TattileS", "Tattile SRL"],
      "008065" => ["Cybergra", "CYBERGRAPHIC SYSTEMS PTY LTD."],
      "008066" => ["ArcomCon", "ARCOM CONTROL SYSTEMS, LTD."],
      "008067" => ["SquareD", "SQUARE D COMPANY"],
      "008068" => ["Yamatech", "YAMATECH SCIENTIFIC LTD."],
      "008069" => ["Computon", "COMPUTONE SYSTEMS"],
      "00806A" => ["EriEmpac", "ERI (EMPAC RESEARCH INC.)"],
      "00806B" => ["SchmidTe", "SCHMID TELECOMMUNICATION"],
      "00806C" => ["CegelecP", "CEGELEC PROJECTS LTD"],
      "00806D" => ["Century", "CENTURY SYSTEMS CORP."],
      "00806E" => ["NipponSt", "NIPPON STEEL CORPORATION"],
      "00806F" => ["Onelan", "ONELAN LTD."],
      "008070" => ["Computad", "COMPUTADORAS MICRON"],
      "008071" => ["SaiTechn", "SAI TECHNOLOGY"],
      "008072" => ["Microple", "MICROPLEX SYSTEMS LTD."],
      "008073" => ["DwbAssoc", "DWB ASSOCIATES"],
      "008074" => ["FisherCo", "FISHER CONTROLS"],
      "008075" => ["Parsytec", "PARSYTEC GMBH"],
      "008076" => ["Mcnc",""],
      "008077" => ["BrotherI", "BROTHER INDUSTRIES, LTD."],
      "008078" => ["Practica", "PRACTICAL PERIPHERALS, INC."],
      "008079" => ["Microbus", "MICROBUS DESIGNS LTD."],
      "00807A" => ["Aitech", "AITECH SYSTEMS LTD."],
      "00807B" => ["ArtelCom", "ARTEL COMMUNICATIONS CORP."],
      "00807C" => ["Fibercom", "FIBERCOM, INC."],
      "00807D" => ["Equinox", "EQUINOX SYSTEMS INC."],
      "00807E" => ["Southern", "SOUTHERN PACIFIC LTD."],
      "00807F" => ["Dy-4", "DY-4 INCORPORATED"],
      "008080" => ["Datamedi", "DATAMEDIA CORPORATION"],
      "008081" => ["KendallS", "KENDALL SQUARE RESEARCH CORP."],
      "008082" => ["PepModul", "PEP MODULAR COMPUTERS GMBH"],
      "008083" => ["Amdahl",""],
      "008084" => ["Cloud", "THE CLOUD INC."],
      "008085" => ["H-Three", "H-THREE SYSTEMS CORPORATION"],
      "008086" => ["Computer", "COMPUTER GENERATION INC."],
      "008087" => ["OkiElect", "OKI ELECTRIC INDUSTRY CO., LTD"],
      "008088" => ["VictorOf", "VICTOR COMPANY OF JAPAN, LTD."],
      "008089" => ["Tecnetic", "TECNETICS (PTY) LTD."],
      "00808A" => ["SummitMi", "SUMMIT MICROSYSTEMS CORP."],
      "00808B" => ["Dacoll", "DACOLL LIMITED"],
      "00808C" => ["Netscout", "NetScout Systems, Inc."],
      "00808D" => ["Westcoas", "WESTCOAST TECHNOLOGY B.V."],
      "00808E" => ["Radstone", "RADSTONE TECHNOLOGY"],
      "00808F" => ["CItohEle", "C. ITOH ELECTRONICS, INC."],
      "008090" => ["Microtek", "MICROTEK INTERNATIONAL, INC."],
      "008091" => ["TokyoEle", "TOKYO ELECTRIC CO.,LTD"],
      "008092" => ["SilexTec", "Silex Technology, Inc."],
      "008093" => ["Xyron", "XYRON CORPORATION"],
      "008094" => ["AlfaLava", "ALFA LAVAL AUTOMATION AB"],
      "008095" => ["BasicMer", "BASIC MERTON HANDELSGES.M.B.H."],
      "008096" => ["HDS",""],
      "008097" => ["Centralp", "CENTRALP AUTOMATISMES"],
      "008098" => ["Tdk", "TDK CORPORATION"],
      "008099" => ["EatonInd", "Eaton Industries GmbH"],
      "00809A" => ["NovusNet", "NOVUS NETWORKS LTD"],
      "00809B" => ["Justsyst", "JUSTSYSTEM CORPORATION"],
      "00809C" => ["Luxcom", "LUXCOM, INC."],
      "00809D" => ["Commscra", "Commscraft Ltd."],
      "00809E" => ["Datus", "DATUS GMBH"],
      "00809F" => ["AlcatelB", "ALCATEL BUSINESS SYSTEMS"],
      "0080A0" => ["EdisaHew", "EDISA HEWLETT PACKARD S/A"],
      "0080A1" => ["Microtes", "MICROTEST, INC."],
      "0080A2" => ["TattileS", "Tattile SRL"],
      "0080A3" => ["Lantroni", "Lantronix"],
      "0080A4" => ["LibertyE", "LIBERTY ELECTRONICS"],
      "0080A5" => ["SpeedInt", "SPEED INTERNATIONAL"],
      "0080A6" => ["Republic", "REPUBLIC TECHNOLOGY, INC."],
      "0080A7" => ["Honeywel", "Honeywell International Inc"],
      "0080A8" => ["Vitacom", "VITACOM CORPORATION"],
      "0080A9" => ["Clearpoi", "CLEARPOINT RESEARCH"],
      "0080AA" => ["Maxpeed",""],
      "0080AB" => ["DukaneNe", "DUKANE NETWORK INTEGRATION"],
      "0080AC" => ["ImlogixD", "IMLOGIX, DIVISION OF GENESYS"],
      "0080AD" => ["Telebit",""],
      "0080AE" => ["HughesNe", "HUGHES NETWORK SYSTEMS"],
      "0080AF" => ["Allumer", "ALLUMER CO., LTD."],
      "0080B0" => ["Advanced", "ADVANCED INFORMATION"],
      "0080B1" => ["Softcom", "SOFTCOM A/S"],
      "0080B2" => ["NetworkE", "NETWORK EQUIPMENT TECHNOLOGIES"],
      "0080B3" => ["AvalData", "AVAL DATA CORPORATION"],
      "0080B4" => ["Sophia", "SOPHIA SYSTEMS"],
      "0080B5" => ["UnitedNe", "UNITED NETWORKS INC."],
      "0080B6" => ["ThemisCo", "THEMIS COMPUTER"],
      "0080B7" => ["StellarC", "STELLAR COMPUTER"],
      "0080B8" => ["Bug", "BUG, INCORPORATED"],
      "0080B9" => ["ArcheTec", "ARCHE TECHNOLIGIES INC."],
      "0080BA" => ["Speciali", "SPECIALIX (ASIA) PTE, LTD"],
      "0080BB" => ["HughesLa", "HUGHES LAN SYSTEMS"],
      "0080BC" => ["HitachiE", "HITACHI ENGINEERING CO., LTD"],
      "0080BD" => ["Furukawa", "THE FURUKAWA ELECTRIC CO., LTD"],
      "0080BE" => ["AriesRes", "ARIES RESEARCH"],
      "0080BF" => ["TakaokaE", "TAKAOKA ELECTRIC MFG. CO. LTD."],
      "0080C0" => ["PenrilDa", "PENRIL DATACOMM"],
      "0080C1" => ["Lanex", "LANEX CORPORATION"],
      "0080C2" => ["Ieee8021", "IEEE 802.1 COMMITTEE"],
      "0080C3" => ["BiccInfo", "BICC INFORMATION SYSTEMS & SVC"],
      "0080C4" => ["Document", "DOCUMENT TECHNOLOGIES, INC."],
      "0080C5" => ["Novellco", "NOVELLCO DE MEXICO"],
      "0080C6" => ["National", "NATIONAL DATACOMM CORPORATION"],
      "0080C7" => ["Xircom",""],
      "0080C8" => ["D-Link", "D-LINK SYSTEMS, INC."],
      "0080C9" => ["AlbertaM", "ALBERTA MICROELECTRONIC CENTRE"],
      "0080CA" => ["NetcomRe", "NETCOM RESEARCH INCORPORATED"],
      "0080CB" => ["FalcoDat", "FALCO DATA PRODUCTS"],
      "0080CC" => ["Microwav", "MICROWAVE BYPASS SYSTEMS"],
      "0080CD" => ["Micronic", "MICRONICS COMPUTER, INC."],
      "0080CE" => ["Broadcas", "BROADCAST TELEVISION SYSTEMS"],
      "0080CF" => ["Embedded", "EMBEDDED PERFORMANCE INC."],
      "0080D0" => ["Computer", "COMPUTER PERIPHERALS, INC."],
      "0080D1" => ["Kimtron", "KIMTRON CORPORATION"],
      "0080D2" => ["Shinniho", "SHINNIHONDENKO CO., LTD."],
      "0080D3" => ["Shiva", "SHIVA CORP."],
      "0080D4" => ["ChaseRes", "CHASE RESEARCH LTD."],
      "0080D5" => ["CadreTec", "CADRE TECHNOLOGIES"],
      "0080D6" => ["Nuvotech", "NUVOTECH, INC."],
      "0080D7" => ["FantumEn", "Fantum Engineering"],
      "0080D8" => ["NetworkP", "NETWORK PERIPHERALS INC."],
      "0080D9" => ["EmkElekt", "EMK Elektronik GmbH & Co. KG"],
      "0080DA" => ["BruelKja", "Bruel & Kjaer Sound & Vibration Measurement A/S"],
      "0080DB" => ["Graphon", "GRAPHON CORPORATION"],
      "0080DC" => ["PickerIn", "PICKER INTERNATIONAL"],
      "0080DD" => ["GmxInc/G", "GMX INC/GIMIX"],
      "0080DE" => ["GipsiSA", "GIPSI S.A."],
      "0080DF" => ["AdcCoden", "ADC CODENOLL TECHNOLOGY CORP."],
      "0080E0" => ["Xtp", "XTP SYSTEMS, INC."],
      "0080E1" => ["Stmicroe", "STMICROELECTRONICS"],
      "0080E2" => ["TDI", "T.D.I. CO., LTD."],
      "0080E3" => ["CoralNet", "CORAL NETWORK CORPORATION"],
      "0080E4" => ["Northwes", "NORTHWEST DIGITAL SYSTEMS, INC"],
      "0080E5" => ["LsiLogic", "LSI Logic Corporation"],
      "0080E6" => ["PeerNetw", "PEER NETWORKS, INC."],
      "0080E7" => ["LynwoodS", "LYNWOOD SCIENTIFIC DEV. LTD."],
      "0080E8" => ["CumulusC", "CUMULUS CORPORATIION"],
      "0080E9" => ["Madge", "Madge Ltd."],
      "0080EA" => ["AdvaOpti", "ADVA Optical Networking Ltd."],
      "0080EB" => ["Compcont", "COMPCONTROL B.V."],
      "0080EC" => ["Supercom", "SUPERCOMPUTING SOLUTIONS, INC."],
      "0080ED" => ["IqTechno", "IQ TECHNOLOGIES, INC."],
      "0080EE" => ["ThomsonC", "THOMSON CSF"],
      "0080EF" => ["Rational",""],
      "0080F0" => ["Panasoni", "Panasonic Communications Co., Ltd."],
      "0080F1" => ["Opus", "OPUS SYSTEMS"],
      "0080F2" => ["Raycom", "RAYCOM SYSTEMS INC"],
      "0080F3" => ["SunElect", "SUN ELECTRONICS CORP."],
      "0080F4" => ["Telemeca", "TELEMECANIQUE ELECTRIQUE"],
      "0080F5" => ["Quantel", "Quantel Ltd"],
      "0080F6" => ["SynergyM", "SYNERGY MICROSYSTEMS"],
      "0080F7" => ["ZenithEl", "ZENITH ELECTRONICS"],
      "0080F8" => ["Mizar", "MIZAR, INC."],
      "0080F9" => ["Heurikon", "HEURIKON CORPORATION"],
      "0080FA" => ["Rwt", "RWT GMBH"],
      "0080FB" => ["Bvm", "BVM LIMITED"],
      "0080FC" => ["Avatar", "AVATAR CORPORATION"],
      "0080FD" => ["ExsceedC", "EXSCEED CORPRATION"],
      "0080FE" => ["AzureTec", "AZURE TECHNOLOGIES, INC."],
      "0080FF" => ["SocDeTel", "SOC. DE TELEINFORMATIQUE RTC"],
      "008C10" => ["BlackBox", "Black Box Corp."],
      "008CFA" => ["Inventec", "Inventec Corporation"],
      "008D4E" => ["CjscNiiS", "CJSC NII STT"],
      "008DDA" => ["LinkOne", "Link One Co., Ltd."],
      "008EF2" => ["Netgear", "NETGEAR INC.,"],
      "009000" => ["DiamondM", "DIAMOND MULTIMEDIA"],
      "009001" => ["NishimuE", "NISHIMU ELECTRONICS INDUSTRIES CO., LTD."],
      "009002" => ["Allgon", "ALLGON AB"],
      "009003" => ["Aplio",""],
      "009004" => ["3comEuro", "3COM EUROPE LTD."],
      "009005" => ["Protech", "PROTECH SYSTEMS CO., LTD."],
      "009006" => ["Hamamats", "HAMAMATSU PHOTONICS K.K."],
      "009007" => ["DomexTec", "DOMEX TECHNOLOGY CORP."],
      "009008" => ["Hana", "HanA Systems Inc."],
      "009009" => ["IControl", "i Controls, Inc."],
      "00900A" => ["ProtonEl", "PROTON ELECTRONIC INDUSTRIAL CO., LTD."],
      "00900B" => ["LannerEl", "LANNER ELECTRONICS, INC."],
      "00900C" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00900D" => ["Overland", "Overland Storage Inc."],
      "00900E" => ["Handlink", "HANDLINK TECHNOLOGIES, INC."],
      "00900F" => ["Kawasaki", "KAWASAKI HEAVY INDUSTRIES, LTD"],
      "009010" => ["Simulati", "SIMULATION LABORATORIES, INC."],
      "009011" => ["Wavtrace", "WAVTrace, Inc."],
      "009012" => ["Globespa", "GLOBESPAN SEMICONDUCTOR, INC."],
      "009013" => ["Samsan", "SAMSAN CORP."],
      "009014" => ["RotorkIn", "ROTORK INSTRUMENTS, LTD."],
      "009015" => ["Centigra", "CENTIGRAM COMMUNICATIONS CORP."],
      "009016" => ["Zac",""],
      "009017" => ["Zypcom", "Zypcom, Inc"],
      "009018" => ["ItoElect", "ITO ELECTRIC INDUSTRY CO, LTD."],
      "009019" => ["HermesEl", "HERMES ELECTRONICS CO., LTD."],
      "00901A" => ["Unispher", "UNISPHERE SOLUTIONS"],
      "00901B" => ["DigitalC", "DIGITAL CONTROLS"],
      "00901C" => ["MpsSoftw", "mps Software Gmbh"],
      "00901D" => ["PecNz", "PEC (NZ) LTD."],
      "00901E" => ["SelestaI", "Selesta Ingegneria S.p.A."],
      "00901F" => ["AdtecPro", "ADTEC PRODUCTIONS, INC."],
      "009020" => ["PhilipsA", "PHILIPS ANALYTICAL X-RAY B.V."],
      "009021" => ["Cisco", "CISCO SYSTEMS, INC."],
      "009022" => ["Ivex",""],
      "009023" => ["Zilog", "ZILOG INC."],
      "009024" => ["Pipelink", "PIPELINKS, INC."],
      "009025" => ["BaeAustr", "BAE Systems Australia (Electronic Systems) Pty Ltd"],
      "009026" => ["Advanced", "ADVANCED SWITCHING COMMUNICATIONS, INC."],
      "009027" => ["Intel", "INTEL CORPORATION"],
      "009028" => ["NipponSi", "NIPPON SIGNAL CO., LTD."],
      "009029" => ["Crypto", "CRYPTO AG"],
      "00902A" => ["Communic", "COMMUNICATION DEVICES, INC."],
      "00902B" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00902C" => ["DataCont", "DATA & CONTROL EQUIPMENT LTD."],
      "00902D" => ["DataElec", "DATA ELECTRONICS (AUST.) PTY, LTD."],
      "00902E" => ["Namco", "NAMCO LIMITED"],
      "00902F" => ["Netcore", "NETCORE SYSTEMS, INC."],
      "009030" => ["Honeywel", "HONEYWELL-DATING"],
      "009031" => ["Mysticom", "MYSTICOM, LTD."],
      "009032" => ["Pelcombe", "PELCOMBE GROUP LTD."],
      "009033" => ["Innovaph", "INNOVAPHONE AG"],
      "009034" => ["Imagic", "IMAGIC, INC."],
      "009035" => ["AlphaTel", "ALPHA TELECOM, INC."],
      "009036" => ["Ens", "ens, inc."],
      "009037" => ["Acucomm", "ACUCOMM, INC."],
      "009038" => ["Fountain", "FOUNTAIN TECHNOLOGIES, INC."],
      "009039" => ["ShastaNe", "SHASTA NETWORKS"],
      "00903A" => ["NihonMed", "NIHON MEDIA TOOL INC."],
      "00903B" => ["TriemsRe", "TriEMS Research Lab, Inc."],
      "00903C" => ["Atlantic", "ATLANTIC NETWORK SYSTEMS"],
      "00903D" => ["Biopac", "BIOPAC SYSTEMS, INC."],
      "00903E" => ["NVPhilip", "N.V. PHILIPS INDUSTRIAL ACTIVITIES"],
      "00903F" => ["AztecRad", "AZTEC RADIOMEDIA"],
      "009040" => ["SiemensN", "Siemens Network Convergence LLC"],
      "009041" => ["AppliedD", "APPLIED DIGITAL ACCESS"],
      "009042" => ["Eccs", "ECCS, Inc."],
      "009043" => ["TattileS", "Tattile SRL"],
      "009044" => ["AssuredD", "ASSURED DIGITAL, INC."],
      "009045" => ["MarconiC", "Marconi Communications"],
      "009046" => ["Dexdyne", "DEXDYNE, LTD."],
      "009047" => ["GigaFast", "GIGA FAST E. LTD."],
      "009048" => ["Zeal", "ZEAL CORPORATION"],
      "009049" => ["Entridia", "ENTRIDIA CORPORATION"],
      "00904A" => ["ConcurSy", "CONCUR SYSTEM TECHNOLOGIES"],
      "00904B" => ["GemtekTe", "GemTek Technology Co., Ltd."],
      "00904C" => ["Epigram", "EPIGRAM, INC."],
      "00904D" => ["SpecSA", "SPEC S.A."],
      "00904E" => ["DelemBv", "DELEM BV"],
      "00904F" => ["AbbPower", "ABB POWER T&D COMPANY, INC."],
      "009050" => ["TelesteO", "TELESTE OY"],
      "009051" => ["Ultimate", "ULTIMATE TECHNOLOGY CORP."],
      "009052" => ["SelcomEl", "SELCOM ELETTRONICA S.R.L."],
      "009053" => ["DaewooEl", "DAEWOO ELECTRONICS CO., LTD."],
      "009054" => ["Innovati", "INNOVATIVE SEMICONDUCTORS, INC"],
      "009055" => ["ParkerHa", "PARKER HANNIFIN CORPORATION COMPUMOTOR DIVISION"],
      "009056" => ["Telestre", "TELESTREAM, INC."],
      "009057" => ["Aanetcom", "AANetcom, Inc."],
      "009058" => ["UltraEle", "Ultra Electronics Ltd., Command and Control Systems"],
      "009059" => ["TelecomD", "TELECOM DEVICE K.K."],
      "00905A" => ["Dearborn", "DEARBORN GROUP, INC."],
      "00905B" => ["RaymondA", "RAYMOND AND LAE ENGINEERING"],
      "00905C" => ["Edmi",""],
      "00905D" => ["NetcomSi", "NETCOM SICHERHEITSTECHNIK GmbH"],
      "00905E" => ["Rauland-", "RAULAND-BORG CORPORATION"],
      "00905F" => ["Cisco", "CISCO SYSTEMS, INC."],
      "009060" => ["SystemCr", "SYSTEM CREATE CORP."],
      "009061" => ["PacificR", "PACIFIC RESEARCH & ENGINEERING CORPORATION"],
      "009062" => ["IcpVorte", "ICP VORTEX COMPUTERSYSTEME GmbH"],
      "009063" => ["Coherent", "COHERENT COMMUNICATIONS SYSTEMS CORPORATION"],
      "009064" => ["Thomson", "Thomson Inc."],
      "009065" => ["Finisar", "FINISAR CORPORATION"],
      "009066" => ["TroikaNe", "Troika Networks, Inc."],
      "009067" => ["Walkabou", "WalkAbout Computers, Inc."],
      "009068" => ["Dvt", "DVT CORP."],
      "009069" => ["JuniperN", "JUNIPER NETWORKS, INC."],
      "00906A" => ["Turnston", "TURNSTONE SYSTEMS, INC."],
      "00906B" => ["AppliedR", "APPLIED RESOURCES, INC."],
      "00906C" => ["Sartoriu", "Sartorius Hamburg GmbH"],
      "00906D" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00906E" => ["Praxon", "PRAXON, INC."],
      "00906F" => ["Cisco", "CISCO SYSTEMS, INC."],
      "009070" => ["NeoNetwo", "NEO NETWORKS, INC."],
      "009071" => ["AppliedI", "Applied Innovation Inc."],
      "009072" => ["SimradAs", "SIMRAD AS"],
      "009073" => ["GaioTech", "GAIO TECHNOLOGY"],
      "009074" => ["ArgonNet", "ARGON NETWORKS, INC."],
      "009075" => ["NecDoBra", "NEC DO BRASIL S.A."],
      "009076" => ["FmtAircr", "FMT AIRCRAFT GATE SUPPORT SYSTEMS AB"],
      "009077" => ["Advanced", "ADVANCED FIBRE COMMUNICATIONS"],
      "009078" => ["MerTelem", "MER TELEMANAGEMENT SOLUTIONS, LTD."],
      "009079" => ["Clearone", "ClearOne, Inc."],
      "00907A" => ["Polycom", "Polycom, Inc."],
      "00907B" => ["E-Tech", "E-TECH, INC."],
      "00907C" => ["Digitalc", "DIGITALCAST, INC."],
      "00907D" => ["LakeComm", "Lake Communications"],
      "00907E" => ["Vetronix", "VETRONIX CORP."],
      "00907F" => ["Watchgua", "WatchGuard Technologies, Inc."],
      "009080" => ["Not", "NOT LIMITED, INC."],
      "009081" => ["AlohaNet", "ALOHA NETWORKS, INC."],
      "009082" => ["ForceIns", "FORCE INSTITUTE"],
      "009083" => ["TurboCom", "TURBO COMMUNICATION, INC."],
      "009084" => ["AtechSys", "ATECH SYSTEM"],
      "009085" => ["GoldenEn", "GOLDEN ENTERPRISES, INC."],
      "009086" => ["Cisco", "CISCO SYSTEMS, INC."],
      "009087" => ["Itis",""],
      "009088" => ["BaxallSe", "BAXALL SECURITY LTD."],
      "009089" => ["SoftcomM", "SOFTCOM MICROSYSTEMS, INC."],
      "00908A" => ["BaylyCom", "BAYLY COMMUNICATIONS, INC."],
      "00908B" => ["TattileS", "Tattile SRL"],
      "00908C" => ["EtrendEl", "ETREND ELECTRONICS, INC."],
      "00908D" => ["VickersE", "VICKERS ELECTRONICS SYSTEMS"],
      "00908E" => ["NortelNe", "Nortel Networks Broadband Access"],
      "00908F" => ["AudioCod", "AUDIO CODES LTD."],
      "009090" => ["I-Bus",""],
      "009091" => ["Digitals", "DigitalScape, Inc."],
      "009092" => ["Cisco", "CISCO SYSTEMS, INC."],
      "009093" => ["Nanao", "NANAO CORPORATION"],
      "009094" => ["OspreyTe", "OSPREY TECHNOLOGIES, INC."],
      "009095" => ["Universa", "UNIVERSAL AVIONICS"],
      "009096" => ["AskeyCom", "ASKEY COMPUTER CORP."],
      "009097" => ["Sycamore", "Sycamore Networks"],
      "009098" => ["SbcDesig", "SBC DESIGNS, INC."],
      "009099" => ["AlliedTe", "ALLIED TELESIS, K.K."],
      "00909A" => ["OneWorld", "ONE WORLD SYSTEMS, INC."],
      "00909B" => ["Imaje",""],
      "00909C" => ["Motorola", "Motorola, Inc."],
      "00909D" => ["Novatech", "NovaTech Process Solutions, LLC"],
      "00909E" => ["Critical", "Critical IO, LLC"],
      "00909F" => ["Digi-Dat", "DIGI-DATA CORPORATION"],
      "0090A0" => ["8x8", "8X8 INC."],
      "0090A1" => ["FlyingPi", "Flying Pig Systems/High End Systems Inc."],
      "0090A2" => ["Cybertan", "CYBERTAN TECHNOLOGY, INC."],
      "0090A3" => ["Corecess", "Corecess Inc."],
      "0090A4" => ["AltigaNe", "ALTIGA NETWORKS"],
      "0090A5" => ["SpectraL", "SPECTRA LOGIC"],
      "0090A6" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0090A7" => ["Clientec", "CLIENTEC CORPORATION"],
      "0090A8" => ["Ninetile", "NineTiles Networks, Ltd."],
      "0090A9" => ["WesternD", "WESTERN DIGITAL"],
      "0090AA" => ["IndigoAc", "INDIGO ACTIVE VISION SYSTEMS LIMITED"],
      "0090AB" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0090AC" => ["Optivisi", "OPTIVISION, INC."],
      "0090AD" => ["AspectEl", "ASPECT ELECTRONICS, INC."],
      "0090AE" => ["ItaltelS", "ITALTEL S.p.A."],
      "0090AF" => ["JMoritaM", "J. MORITA MFG. CORP."],
      "0090B0" => ["Vadem",""],
      "0090B1" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0090B2" => ["Avici", "AVICI SYSTEMS INC."],
      "0090B3" => ["Agranat", "AGRANAT SYSTEMS"],
      "0090B4" => ["Willowbr", "WILLOWBROOK TECHNOLOGIES"],
      "0090B5" => ["Nikon", "NIKON CORPORATION"],
      "0090B6" => ["Fibex", "FIBEX SYSTEMS"],
      "0090B7" => ["DigitalL", "DIGITAL LIGHTWAVE, INC."],
      "0090B8" => ["RohdeSch", "ROHDE & SCHWARZ GMBH & CO. KG"],
      "0090B9" => ["BeranIns", "BERAN INSTRUMENTS LTD."],
      "0090BA" => ["ValidNet", "VALID NETWORKS, INC."],
      "0090BB" => ["TainetCo", "TAINET COMMUNICATION SYSTEM Corp."],
      "0090BC" => ["Telemann", "TELEMANN CO., LTD."],
      "0090BD" => ["OmniaCom", "OMNIA COMMUNICATIONS, INC."],
      "0090BE" => ["Ibc/Inte", "IBC/INTEGRATED BUSINESS COMPUTERS"],
      "0090BF" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0090C0" => ["KJLawEng", "K.J. LAW ENGINEERS, INC."],
      "0090C1" => ["PecoIi", "Peco II, Inc."],
      "0090C2" => ["JkMicros", "JK microsystems, Inc."],
      "0090C3" => ["TopicSem", "TOPIC SEMICONDUCTOR CORP."],
      "0090C4" => ["Javelin", "JAVELIN SYSTEMS, INC."],
      "0090C5" => ["Internet", "INTERNET MAGIC, INC."],
      "0090C6" => ["Optim", "OPTIM SYSTEMS, INC."],
      "0090C7" => ["Icom", "ICOM INC."],
      "0090C8" => ["Waveride", "WAVERIDER COMMUNICATIONS (CANADA) INC."],
      "0090C9" => ["DpacTech", "DPAC Technologies"],
      "0090CA" => ["AccordVi", "ACCORD VIDEO TELECOMMUNICATIONS, LTD."],
      "0090CB" => ["Wireless", "Wireless OnLine, Inc."],
      "0090CC" => ["PlanexCo", "Planex Communications"],
      "0090CD" => ["Ent-Empr", "ENT-EMPRESA NACIONAL DE TELECOMMUNICACOES, S.A."],
      "0090CE" => ["Tetra", "TETRA GmbH"],
      "0090CF" => ["Nortel",""],
      "0090D0" => ["ThomsonT", "Thomson Telecom Belgium"],
      "0090D1" => ["LeichuEn", "LEICHU ENTERPRISE CO., LTD."],
      "0090D2" => ["ArtelVid", "ARTEL VIDEO SYSTEMS"],
      "0090D3" => ["Giesecke", "GIESECKE & DEVRIENT GmbH"],
      "0090D4" => ["Bindview", "BindView Development Corp."],
      "0090D5" => ["Euphonix", "EUPHONIX, INC."],
      "0090D6" => ["CrystalG", "CRYSTAL GROUP"],
      "0090D7" => ["Netboost", "NetBoost Corp."],
      "0090D8" => ["Whitecro", "WHITECROSS SYSTEMS"],
      "0090D9" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0090DA" => ["Dynarc", "DYNARC, INC."],
      "0090DB" => ["NextLeve", "NEXT LEVEL COMMUNICATIONS"],
      "0090DC" => ["TecoInfo", "TECO INFORMATION SYSTEMS"],
      "0090DD" => ["MiharuCo", "THE MIHARU COMMUNICATIONS CO., LTD."],
      "0090DE" => ["Cardkey", "CARDKEY SYSTEMS, INC."],
      "0090DF" => ["Mitsubis", "MITSUBISHI CHEMICAL AMERICA, INC."],
      "0090E0" => ["Systran", "SYSTRAN CORP."],
      "0090E1" => ["TelenaSP", "TELENA S.P.A."],
      "0090E2" => ["Distribu", "DISTRIBUTED PROCESSING TECHNOLOGY"],
      "0090E3" => ["AvexElec", "AVEX ELECTRONICS INC."],
      "0090E4" => ["NecAmeri", "NEC AMERICA, INC."],
      "0090E5" => ["Teknema", "TEKNEMA, INC."],
      "0090E6" => ["Ali", "ALi Corporation"],
      "0090E7" => ["HorschEl", "HORSCH ELEKTRONIK AG"],
      "0090E8" => ["MoxaTech", "MOXA TECHNOLOGIES CORP., LTD."],
      "0090E9" => ["JanzComp", "JANZ COMPUTER AG"],
      "0090EA" => ["AlphaTec", "ALPHA TECHNOLOGIES, INC."],
      "0090EB" => ["SentryTe", "SENTRY TELECOM SYSTEMS"],
      "0090EC" => ["Pyrescom",""],
      "0090ED" => ["CentralS", "CENTRAL SYSTEM RESEARCH CO., LTD."],
      "0090EE" => ["Personal", "PERSONAL COMMUNICATIONS TECHNOLOGIES"],
      "0090EF" => ["Integrix", "INTEGRIX, INC."],
      "0090F0" => ["Harmonic", "Harmonic Video Systems Ltd."],
      "0090F1" => ["DotHill", "DOT HILL SYSTEMS CORPORATION"],
      "0090F2" => ["Cisco", "CISCO SYSTEMS, INC."],
      "0090F3" => ["AspectCo", "ASPECT COMMUNICATIONS"],
      "0090F4" => ["Lightnin", "LIGHTNING INSTRUMENTATION"],
      "0090F5" => ["Clevo", "CLEVO CO."],
      "0090F6" => ["Escalate", "ESCALATE NETWORKS, INC."],
      "0090F7" => ["NbaseCom", "NBASE COMMUNICATIONS LTD."],
      "0090F8" => ["Mediatri", "MEDIATRIX TELECOM"],
      "0090F9" => ["Leitch",""],
      "0090FA" => ["Emulex", "EMULEX Corp"],
      "0090FB" => ["Portwell", "PORTWELL, INC."],
      "0090FC" => ["NetworkC", "NETWORK COMPUTING DEVICES"],
      "0090FD" => ["Copperco", "CopperCom, Inc."],
      "0090FE" => ["ElecomLa", "ELECOM CO., LTD.  (LANEED DIV.)"],
      "0090FF" => ["TellusTe", "TELLUS TECHNOLOGY INC."],
      "0091D6" => ["CrystalG", "Crystal Group, Inc."],
      "0091FA" => ["SynapseP", "Synapse Product Development"],
      "009363" => ["Uni-Link", "Uni-Link Technology Co., Ltd."],
      "0097FF" => ["HeimannS", "Heimann Sensor GmbH"],
      "009C02" => ["Hewlett-", "Hewlett-Packard Company"],
      "009D8E" => ["CardiacR", "CARDIAC RECORDERS, INC."],
      "00A000" => ["Centilli", "CENTILLION NETWORKS, INC."],
      "00A001" => ["DrsSigna", "DRS Signal Solutions"],
      "00A002" => ["LeedsNor", "LEEDS & NORTHRUP AUSTRALIA PTY LTD"],
      "00A003" => ["SiemensS", "Siemens Switzerland Ltd., I B T HVP"],
      "00A004" => ["Netpower", "NETPOWER, INC."],
      "00A005" => ["DanielIn", "DANIEL INSTRUMENTS, LTD."],
      "00A006" => ["ImageDat", "IMAGE DATA PROCESSING SYSTEM GROUP"],
      "00A007" => ["ApexxTec", "APEXX TECHNOLOGY, INC."],
      "00A008" => ["Netcorp",""],
      "00A009" => ["Whitetre", "WHITETREE NETWORK"],
      "00A00A" => ["Airspan",""],
      "00A00B" => ["Computex", "COMPUTEX CO., LTD."],
      "00A00C" => ["KingmaxT", "KINGMAX TECHNOLOGY, INC."],
      "00A00D" => ["PandaPro", "THE PANDA PROJECT"],
      "00A00E" => ["VisualNe", "VISUAL NETWORKS, INC."],
      "00A00F" => ["Broadban", "Broadband Technologies"],
      "00A010" => ["Syslogic", "SYSLOGIC DATENTECHNIK AG"],
      "00A011" => ["MutohInd", "MUTOH INDUSTRIES LTD."],
      "00A012" => ["Telco", "Telco Systems, Inc."],
      "00A013" => ["Teltrend", "TELTREND LTD."],
      "00A014" => ["Csir",""],
      "00A015" => ["Wyle",""],
      "00A016" => ["Micropol", "MICROPOLIS CORP."],
      "00A017" => ["JBM", "J B M CORPORATION"],
      "00A018" => ["Creative", "CREATIVE CONTROLLERS, INC."],
      "00A019" => ["NebulaCo", "NEBULA CONSULTANTS, INC."],
      "00A01A" => ["BinarEle", "BINAR ELEKTRONIK AB"],
      "00A01B" => ["Premisys", "PREMISYS COMMUNICATIONS, INC."],
      "00A01C" => ["NascentN", "NASCENT NETWORKS CORPORATION"],
      "00A01D" => ["Sixnet",""],
      "00A01E" => ["Est", "EST CORPORATION"],
      "00A01F" => ["Tricord", "TRICORD SYSTEMS, INC."],
      "00A020" => ["Citicorp", "CITICORP/TTI"],
      "00A021" => ["GeneralD", "General Dynamics"],
      "00A022" => ["CentreFo", "CENTRE FOR DEVELOPMENT OF ADVANCED COMPUTING"],
      "00A023" => ["AppliedC", "APPLIED CREATIVE TECHNOLOGY, INC."],
      "00A024" => ["3com", "3COM CORPORATION"],
      "00A025" => ["RedcomLa", "REDCOM LABS INC."],
      "00A026" => ["TeldatSA", "TELDAT, S.A."],
      "00A027" => ["Firepowe", "FIREPOWER SYSTEMS, INC."],
      "00A028" => ["ConnerPe", "CONNER PERIPHERALS"],
      "00A029" => ["Coulter", "COULTER CORPORATION"],
      "00A02A" => ["Trancell", "TRANCELL SYSTEMS"],
      "00A02B" => ["Transiti", "TRANSITIONS RESEARCH CORP."],
      "00A02C" => ["Interwav", "interWAVE Communications"],
      "00A02D" => ["1394Trad", "1394 Trade Association"],
      "00A02E" => ["BrandCom", "BRAND COMMUNICATIONS, LTD."],
      "00A02F" => ["PirelliC", "PIRELLI CAVI"],
      "00A030" => ["CaptorNv", "CAPTOR NV/SA"],
      "00A031" => ["Hazeltin", "HAZELTINE CORPORATION, MS 1-17"],
      "00A032" => ["GesSinga", "GES SINGAPORE PTE. LTD."],
      "00A033" => ["ImcMebsy", "imc MeBsysteme GmbH"],
      "00A034" => ["Axel",""],
      "00A035" => ["Cylink", "CYLINK CORPORATION"],
      "00A036" => ["AppliedN", "APPLIED NETWORK TECHNOLOGY"],
      "00A037" => ["MindrayD", "Mindray DS USA, Inc."],
      "00A038" => ["EmailEle", "EMAIL ELECTRONICS"],
      "00A039" => ["RossTech", "ROSS TECHNOLOGY, INC."],
      "00A03A" => ["Kubotek", "KUBOTEK CORPORATION"],
      "00A03B" => ["ToshinEl", "TOSHIN ELECTRIC CO., LTD."],
      "00A03C" => ["Eg&GNucl", "EG&G NUCLEAR INSTRUMENTS"],
      "00A03D" => ["Opto-22",""],
      "00A03E" => ["AtmForum", "ATM FORUM"],
      "00A03F" => ["Computer", "COMPUTER SOCIETY MICROPROCESSOR & MICROPROCESSOR STANDARDS C"],
      "00A040" => ["AppleCom", "APPLE COMPUTER"],
      "00A041" => ["Inficon",""],
      "00A042" => ["SpurProd", "SPUR PRODUCTS CORP."],
      "00A043" => ["American", "AMERICAN TECHNOLOGY LABS, INC."],
      "00A044" => ["NttIt", "NTT IT CO., LTD."],
      "00A045" => ["PhoenixC", "PHOENIX CONTACT GMBH & CO."],
      "00A046" => ["Scitex", "SCITEX CORP. LTD."],
      "00A047" => ["Integrat", "INTEGRATED FITNESS CORP."],
      "00A048" => ["Questech", "QUESTECH, LTD."],
      "00A049" => ["Digitech", "DIGITECH INDUSTRIES, INC."],
      "00A04A" => ["NisshinE", "NISSHIN ELECTRIC CO., LTD."],
      "00A04B" => ["TflLan", "TFL LAN INC."],
      "00A04C" => ["Innovati", "INNOVATIVE SYSTEMS & TECHNOLOGIES, INC."],
      "00A04D" => ["EdaInstr", "EDA INSTRUMENTS, INC."],
      "00A04E" => ["VoelkerT", "VOELKER TECHNOLOGIES, INC."],
      "00A04F" => ["Ameritec", "AMERITEC CORP."],
      "00A050" => ["CypressS", "CYPRESS SEMICONDUCTOR"],
      "00A051" => ["AngiaCom", "ANGIA COMMUNICATIONS. INC."],
      "00A052" => ["Stanilit", "STANILITE ELECTRONICS PTY. LTD"],
      "00A053" => ["CompactD", "COMPACT DEVICES, INC."],
      "00A054" => ["Private",""],
      "00A055" => ["DataDevi", "Data Device Corporation"],
      "00A056" => ["Micropro", "MICROPROSS"],
      "00A057" => ["Lancom", "LANCOM Systems GmbH"],
      "00A058" => ["Glory", "GLORY, LTD."],
      "00A059" => ["Hamilton", "HAMILTON HALLMARK"],
      "00A05A" => ["KofaxIma", "KOFAX IMAGE PRODUCTS"],
      "00A05B" => ["Marquip", "MARQUIP, INC."],
      "00A05C" => ["Inventor", "INVENTORY CONVERSION, INC./"],
      "00A05D" => ["CsComput", "CS COMPUTER SYSTEME GmbH"],
      "00A05E" => ["MyriadLo", "MYRIAD LOGIC INC."],
      "00A05F" => ["BtgElect", "BTG Electronics Design BV"],
      "00A060" => ["AcerPeri", "ACER PERIPHERALS, INC."],
      "00A061" => ["PuritanB", "PURITAN BENNETT"],
      "00A062" => ["AesProda", "AES PRODATA"],
      "00A063" => ["Jrl", "JRL SYSTEMS, INC."],
      "00A064" => ["Kvb/Anal", "KVB/ANALECT"],
      "00A065" => ["Symantec", "Symantec Corporation"],
      "00A066" => ["Isa", "ISA CO., LTD."],
      "00A067" => ["NetworkS", "NETWORK SERVICES GROUP"],
      "00A068" => ["Bhp", "BHP LIMITED"],
      "00A069" => ["Symmetri", "Symmetricom, Inc."],
      "00A06A" => ["Verilink", "Verilink Corporation"],
      "00A06B" => ["DmsDorsc", "DMS DORSCH MIKROSYSTEM GMBH"],
      "00A06C" => ["Shindeng", "SHINDENGEN ELECTRIC MFG. CO., LTD."],
      "00A06D" => ["Mannesma", "MANNESMANN TALLY CORPORATION"],
      "00A06E" => ["Austron", "AUSTRON, INC."],
      "00A06F" => ["AppconGr", "THE APPCON GROUP, INC."],
      "00A070" => ["Coastcom",""],
      "00A071" => ["VideoLot", "VIDEO LOTTERY TECHNOLOGIES,INC"],
      "00A072" => ["Ovation", "OVATION SYSTEMS LTD."],
      "00A073" => ["Com21", "COM21, INC."],
      "00A074" => ["Percepti", "PERCEPTION TECHNOLOGY"],
      "00A075" => ["MicronTe", "MICRON TECHNOLOGY, INC."],
      "00A076" => ["Cardware", "CARDWARE LAB, INC."],
      "00A077" => ["FujitsuN", "FUJITSU NEXION, INC."],
      "00A078" => ["MarconiC", "Marconi Communications"],
      "00A079" => ["AlpsElec", "ALPS ELECTRIC (USA), INC."],
      "00A07A" => ["Advanced", "ADVANCED PERIPHERALS TECHNOLOGIES, INC."],
      "00A07B" => ["DawnComp", "DAWN COMPUTER INCORPORATION"],
      "00A07C" => ["TonyangN", "TONYANG NYLON CO., LTD."],
      "00A07D" => ["SeeqTech", "SEEQ TECHNOLOGY, INC."],
      "00A07E" => ["AvidTech", "AVID TECHNOLOGY, INC."],
      "00A07F" => ["Gsm-Synt", "GSM-SYNTEL, LTD."],
      "00A080" => ["TattileS", "Tattile SRL"],
      "00A081" => ["AlcatelD", "ALCATEL DATA NETWORKS"],
      "00A082" => ["NktElekt", "NKT ELEKTRONIK A/S"],
      "00A083" => ["Asimmpho", "ASIMMPHONY TURKEY"],
      "00A084" => ["Dataplex", "Dataplex Pty Ltd"],
      "00A085" => ["Private",""],
      "00A086" => ["AmberWav", "AMBER WAVE SYSTEMS, INC."],
      "00A087" => ["ZarlinkS", "Zarlink Semiconductor Ltd."],
      "00A088" => ["Essentia", "ESSENTIAL COMMUNICATIONS"],
      "00A089" => ["XpointTe", "XPOINT TECHNOLOGIES, INC."],
      "00A08A" => ["Brooktro", "BROOKTROUT TECHNOLOGY, INC."],
      "00A08B" => ["AstonEle", "ASTON ELECTRONIC DESIGNS LTD."],
      "00A08C" => ["Multimed", "MultiMedia LANs, Inc."],
      "00A08D" => ["Jacomo", "JACOMO CORPORATION"],
      "00A08E" => ["CheckPoi", "Check Point Software Technologies"],
      "00A08F" => ["Desknet", "DESKNET SYSTEMS, INC."],
      "00A090" => ["Timestep", "TimeStep Corporation"],
      "00A091" => ["Applicom", "APPLICOM INTERNATIONAL"],
      "00A092" => ["HBollman", "H. BOLLMANN MANUFACTURERS, LTD"],
      "00A093" => ["B/EAeros", "B/E AEROSPACE, Inc."],
      "00A094" => ["Comsat", "COMSAT CORPORATION"],
      "00A095" => ["AcaciaNe", "ACACIA NETWORKS, INC."],
      "00A096" => ["MitsumiE", "MITSUMI ELECTRIC CO., LTD."],
      "00A097" => ["JcInform", "JC INFORMATION SYSTEMS"],
      "00A098" => ["Netapp",""],
      "00A099" => ["K-Net", "K-NET LTD."],
      "00A09A" => ["NihonKoh", "NIHON KOHDEN AMERICA"],
      "00A09B" => ["QpsxComm", "QPSX COMMUNICATIONS, LTD."],
      "00A09C" => ["Xyplex", "Xyplex, Inc."],
      "00A09D" => ["Johnatho", "JOHNATHON FREEMAN TECHNOLOGIES"],
      "00A09E" => ["Ictv",""],
      "00A09F" => ["Commvisi", "COMMVISION CORP."],
      "00A0A0" => ["CompactD", "COMPACT DATA, LTD."],
      "00A0A1" => ["EpicData", "EPIC DATA INC."],
      "00A0A2" => ["DigicomS", "DIGICOM S.P.A."],
      "00A0A3" => ["Reliable", "RELIABLE POWER METERS"],
      "00A0A4" => ["Micros", "MICROS SYSTEMS, INC."],
      "00A0A5" => ["TeknorMi", "TEKNOR MICROSYSTEME, INC."],
      "00A0A6" => ["MIKK", "M.I. SYSTEMS, K.K."],
      "00A0A7" => ["Vorax", "VORAX CORPORATION"],
      "00A0A8" => ["Renex", "RENEX CORPORATION"],
      "00A0A9" => ["NavtelCo", "NAVTEL COMMUNICATIONS INC."],
      "00A0AA" => ["Spacelab", "SPACELABS MEDICAL"],
      "00A0AB" => ["NetcsInf", "NETCS INFORMATIONSTECHNIK GMBH"],
      "00A0AC" => ["GilatSat", "GILAT SATELLITE NETWORKS, LTD."],
      "00A0AD" => ["Marconi", "MARCONI SPA"],
      "00A0AE" => ["Nucom", "NUCOM SYSTEMS, INC."],
      "00A0AF" => ["WmsIndus", "WMS INDUSTRIES"],
      "00A0B0" => ["I-ODataD", "I-O DATA DEVICE, INC."],
      "00A0B1" => ["FirstVir", "FIRST VIRTUAL CORPORATION"],
      "00A0B2" => ["ShimaSei", "SHIMA SEIKI"],
      "00A0B3" => ["Zykronix",""],
      "00A0B4" => ["TexasMic", "TEXAS MICROSYSTEMS, INC."],
      "00A0B5" => ["3hTechno", "3H TECHNOLOGY"],
      "00A0B6" => ["SanritzA", "SANRITZ AUTOMATION CO., LTD."],
      "00A0B7" => ["Cordant", "CORDANT, INC."],
      "00A0B8" => ["SymbiosL", "SYMBIOS LOGIC INC."],
      "00A0B9" => ["EagleTec", "EAGLE TECHNOLOGY, INC."],
      "00A0BA" => ["PattonEl", "PATTON ELECTRONICS CO."],
      "00A0BB" => ["Hilan", "HILAN GMBH"],
      "00A0BC" => ["Viasat", "VIASAT, INCORPORATED"],
      "00A0BD" => ["I-Tech", "I-TECH CORP."],
      "00A0BE" => ["Integrat", "INTEGRATED CIRCUIT SYSTEMS, INC. COMMUNICATIONS GROUP"],
      "00A0BF" => ["Wireless", "WIRELESS DATA GROUP MOTOROLA"],
      "00A0C0" => ["DigitalL", "DIGITAL LINK CORP."],
      "00A0C1" => ["OrtivusM", "ORTIVUS MEDICAL AB"],
      "00A0C2" => ["RA", "R.A. SYSTEMS CO., LTD."],
      "00A0C3" => ["Unicompu", "UNICOMPUTER GMBH"],
      "00A0C4" => ["CristieE", "CRISTIE ELECTRONICS LTD."],
      "00A0C5" => ["ZyxelCom", "ZYXEL COMMUNICATION"],
      "00A0C6" => ["Qualcomm", "QUALCOMM INCORPORATED"],
      "00A0C7" => ["TadiranT", "TADIRAN TELECOMMUNICATIONS"],
      "00A0C8" => ["Adtran", "ADTRAN INC."],
      "00A0C9" => ["Intel-Hf", "INTEL CORPORATION - HF1-06"],
      "00A0CA" => ["FujitsuD", "FUJITSU DENSO LTD."],
      "00A0CB" => ["ArkTelec", "ARK TELECOMMUNICATIONS, INC."],
      "00A0CC" => ["Lite-OnC", "LITE-ON COMMUNICATIONS, INC."],
      "00A0CD" => ["DrJohann", "DR. JOHANNES HEIDENHAIN GmbH"],
      "00A0CE" => ["Ecessa",""],
      "00A0CF" => ["Sotas", "SOTAS, INC."],
      "00A0D0" => ["TenXTech", "TEN X TECHNOLOGY, INC."],
      "00A0D1" => ["Inventec", "INVENTEC CORPORATION"],
      "00A0D2" => ["AlliedTe", "ALLIED TELESIS INTERNATIONAL CORPORATION"],
      "00A0D3" => ["InstemCo", "INSTEM COMPUTER SYSTEMS, LTD."],
      "00A0D4" => ["Radiolan", "RADIOLAN,  INC."],
      "00A0D5" => ["SierraWi", "SIERRA WIRELESS INC."],
      "00A0D6" => ["Sbe", "SBE, INC."],
      "00A0D7" => ["KastenCh", "KASTEN CHASE APPLIED RESEARCH"],
      "00A0D8" => ["Spectra-", "SPECTRA - TEK"],
      "00A0D9" => ["ConvexCo", "CONVEX COMPUTER CORPORATION"],
      "00A0DA" => ["Integrat", "INTEGRATED SYSTEMS Technology, Inc."],
      "00A0DB" => ["FisherPa", "FISHER & PAYKEL PRODUCTION"],
      "00A0DC" => ["ONElectr", "O.N. ELECTRONIC CO., LTD."],
      "00A0DD" => ["Azonix", "AZONIX CORPORATION"],
      "00A0DE" => ["Yamaha", "YAMAHA CORPORATION"],
      "00A0DF" => ["StsTechn", "STS TECHNOLOGIES, INC."],
      "00A0E0" => ["Tennyson", "TENNYSON TECHNOLOGIES PTY LTD"],
      "00A0E1" => ["Westport", "WESTPORT RESEARCH ASSOCIATES, INC."],
      "00A0E2" => ["Keisokug", "Keisokugiken Corporation"],
      "00A0E3" => ["Xkl", "XKL SYSTEMS CORP."],
      "00A0E4" => ["Optiques", "OPTIQUEST"],
      "00A0E5" => ["NhcCommu", "NHC COMMUNICATIONS"],
      "00A0E6" => ["Dialogic", "DIALOGIC CORPORATION"],
      "00A0E7" => ["CentralD", "CENTRAL DATA CORPORATION"],
      "00A0E8" => ["ReutersH", "REUTERS HOLDINGS PLC"],
      "00A0E9" => ["Electron", "ELECTRONIC RETAILING SYSTEMS INTERNATIONAL"],
      "00A0EA" => ["Ethercom", "ETHERCOM CORP."],
      "00A0EB" => ["EncoreNe", "Encore Networks, Inc."],
      "00A0EC" => ["Transmit", "TRANSMITTON LTD."],
      "00A0ED" => ["BrooksAu", "Brooks Automation, Inc."],
      "00A0EE" => ["NashobaN", "NASHOBA NETWORKS"],
      "00A0EF" => ["Lucidata", "LUCIDATA LTD."],
      "00A0F0" => ["TorontoM", "TORONTO MICROELECTRONICS INC."],
      "00A0F1" => ["Mti",""],
      "00A0F2" => ["InfotekC", "INFOTEK COMMUNICATIONS, INC."],
      "00A0F3" => ["Staubli",""],
      "00A0F4" => ["Ge",""],
      "00A0F5" => ["Radguard", "RADGUARD LTD."],
      "00A0F6" => ["Autogas", "AutoGas Systems Inc."],
      "00A0F7" => ["VIComput", "V.I COMPUTER CORP."],
      "00A0F8" => ["SymbolTe", "SYMBOL TECHNOLOGIES, INC."],
      "00A0F9" => ["BintecCo", "BINTEC COMMUNICATIONS GMBH"],
      "00A0FA" => ["MarconiC", "Marconi Communication GmbH"],
      "00A0FB" => ["TorayEng", "TORAY ENGINEERING CO., LTD."],
      "00A0FC" => ["ImageSci", "IMAGE SCIENCES, INC."],
      "00A0FD" => ["ScitexDi", "SCITEX DIGITAL PRINTING, INC."],
      "00A0FE" => ["BostonTe", "BOSTON TECHNOLOGY, INC."],
      "00A0FF" => ["TellabsO", "TELLABS OPERATIONS, INC."],
      "00A1DE" => ["Shenzhen", "ShenZhen ShiHua Technology CO.,LTD"],
      "00A2DA" => ["Inat", "INAT GmbH"],
      "00AA00" => ["Intel", "INTEL CORPORATION"],
      "00AA01" => ["Intel", "INTEL CORPORATION"],
      "00AA02" => ["Intel", "INTEL CORPORATION"],
      "00AA3C" => ["Olivetti", "OLIVETTI TELECOM SPA (OLTECO)"],
      "00AA70" => ["LgElectr", "LG Electronics"],
      "00B009" => ["GrassVal", "Grass Valley Group"],
      "00B017" => ["Infogear", "InfoGear Technology Corp."],
      "00B019" => ["UtcCcs", "UTC CCS"],
      "00B01C" => ["Westport", "Westport Technologies"],
      "00B01E" => ["RanticLa", "Rantic Labs, Inc."],
      "00B02A" => ["Orsys", "ORSYS GmbH"],
      "00B02D" => ["ViagateT", "ViaGate Technologies, Inc."],
      "00B033" => ["Oao Izhe", "OAO  Izhevskiy radiozavod"],
      "00B03B" => ["HiqNetwo", "HiQ Networks"],
      "00B048" => ["MarconiC", "Marconi Communications Inc."],
      "00B04A" => ["Cisco", "Cisco Systems, Inc."],
      "00B052" => ["AtherosC", "Atheros Communications"],
      "00B064" => ["Cisco", "Cisco Systems, Inc."],
      "00B069" => ["Honewell", "Honewell Oy"],
      "00B06D" => ["JonesFut", "Jones Futurex Inc."],
      "00B080" => ["Mannesma", "Mannesmann Ipulsys B.V."],
      "00B086" => ["Locsoft", "LocSoft Limited"],
      "00B08E" => ["Cisco", "Cisco Systems, Inc."],
      "00B091" => ["Transmet", "Transmeta Corp."],
      "00B094" => ["Alaris", "Alaris, Inc."],
      "00B09A" => ["MorrowTe", "Morrow Technologies Corp."],
      "00B09D" => ["PointGre", "Point Grey Research Inc."],
      "00B0AC" => ["Siae-Mic", "SIAE-Microelettronica S.p.A."],
      "00B0AE" => ["Symmetri", "Symmetricom"],
      "00B0B3" => ["Xstreami", "Xstreamis PLC"],
      "00B0C2" => ["Cisco", "Cisco Systems, Inc."],
      "00B0C7" => ["TellabsO", "Tellabs Operations, Inc."],
      "00B0CE" => ["Technolo", "TECHNOLOGY RESCUE"],
      "00B0D0" => ["DellComp", "Dell Computer Corp."],
      "00B0DB" => ["Nextcell", "Nextcell, Inc."],
      "00B0DF" => ["Reldata", "RELDATA Inc"],
      "00B0E7" => ["BritishF", "British Federal Ltd."],
      "00B0EC" => ["Eacem",""],
      "00B0EE" => ["Ajile", "Ajile Systems, Inc."],
      "00B0F0" => ["CalyNetw", "CALY NETWORKS"],
      "00B0F5" => ["Networth", "NetWorth Technologies, Inc."],
      "00B338" => ["KontronD", "Kontron Design Manufacturing Services (M) Sdn. Bhd"],
      "00B342" => ["Macrosan", "MacroSAN Technologies Co., Ltd."],
      "00B5D6" => ["Omnibit", "Omnibit Inc."],
      "00B9F6" => ["Shenzhen", "Shenzhen Super Rich Electronics Co.,Ltd"],
      "00BAC0" => ["Biometri", "Biometric Access Company"],
      "00BB01" => ["Octothor", "OCTOTHORPE CORP."],
      "00BB8E" => ["Hme", "HME Co., Ltd."],
      "00BBF0" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00BD27" => ["Exar", "Exar Corp."],
      "00BD3A" => ["Nokia", "Nokia Corporation"],
      "00BF15" => ["Genetec", "Genetec Inc."],
      "00C000" => ["Lanoptic", "LANOPTICS, LTD."],
      "00C001" => ["DiatekPa", "DIATEK PATIENT MANAGMENT"],
      "00C002" => ["Sercomm", "SERCOMM CORPORATION"],
      "00C003" => ["Globalne", "GLOBALNET COMMUNICATIONS"],
      "00C004" => ["JapanBus", "JAPAN BUSINESS COMPUTER CO.LTD"],
      "00C005" => ["Livingst", "LIVINGSTON ENTERPRISES, INC."],
      "00C006" => ["NipponAv", "NIPPON AVIONICS CO., LTD."],
      "00C007" => ["Pinnacle", "PINNACLE DATA SYSTEMS, INC."],
      "00C008" => ["SecoSrl", "SECO SRL"],
      "00C009" => ["KtTechno", "KT TECHNOLOGY (S) PTE LTD"],
      "00C00A" => ["MicroCra", "MICRO CRAFT"],
      "00C00B" => ["Norcontr", "NORCONTROL A.S."],
      "00C00C" => ["ReliaTec", "RELIA TECHNOLGIES"],
      "00C00D" => ["Advanced", "ADVANCED LOGIC RESEARCH, INC."],
      "00C00E" => ["Psitech", "PSITECH, INC."],
      "00C00F" => ["QuantumS", "QUANTUM SOFTWARE SYSTEMS LTD."],
      "00C010" => ["Hirakawa", "HIRAKAWA HEWTECH CORP."],
      "00C011" => ["Interact", "INTERACTIVE COMPUTING DEVICES"],
      "00C012" => ["Netspan", "NETSPAN CORPORATION"],
      "00C013" => ["Netrix",""],
      "00C014" => ["Telemati", "TELEMATICS CALABASAS INT\'L,INC"],
      "00C015" => ["NewMedia", "NEW MEDIA CORPORATION"],
      "00C016" => ["Electron", "ELECTRONIC THEATRE CONTROLS"],
      "00C017" => ["Fluke", "Fluke Corporation"],
      "00C018" => ["Lanart", "LANART CORPORATION"],
      "00C019" => ["LeapTech", "LEAP TECHNOLOGY, INC."],
      "00C01A" => ["Corometr", "COROMETRICS MEDICAL SYSTEMS"],
      "00C01B" => ["SocketCo", "SOCKET COMMUNICATIONS, INC."],
      "00C01C" => ["Interlin", "INTERLINK COMMUNICATIONS LTD."],
      "00C01D" => ["GrandJun", "GRAND JUNCTION NETWORKS, INC."],
      "00C01E" => ["LaFranca", "LA FRANCAISE DES JEUX"],
      "00C01F" => ["SERCEL", "S.E.R.C.E.L."],
      "00C020" => ["ArcoElec", "ARCO ELECTRONIC, CONTROL LTD."],
      "00C021" => ["Netexpre", "NETEXPRESS"],
      "00C022" => ["Lasermas", "LASERMASTER TECHNOLOGIES, INC."],
      "00C023" => ["Tutankha", "TUTANKHAMON ELECTRONICS"],
      "00C024" => ["EdenSist", "EDEN SISTEMAS DE COMPUTACAO SA"],
      "00C025" => ["Dataprod", "DATAPRODUCTS CORPORATION"],
      "00C026" => ["LansTech", "LANS TECHNOLOGY CO., LTD."],
      "00C027" => ["Cipher", "CIPHER SYSTEMS, INC."],
      "00C028" => ["Jasco", "JASCO CORPORATION"],
      "00C029" => ["NexansDe", "Nexans Deutschland GmbH - ANS"],
      "00C02A" => ["OhkuraEl", "OHKURA ELECTRIC CO., LTD."],
      "00C02B" => ["GerloffG", "GERLOFF GESELLSCHAFT FUR"],
      "00C02C" => ["CentrumC", "CENTRUM COMMUNICATIONS, INC."],
      "00C02D" => ["FujiPhot", "FUJI PHOTO FILM CO., LTD."],
      "00C02E" => ["Netwiz",""],
      "00C02F" => ["Okuma", "OKUMA CORPORATION"],
      "00C030" => ["Integrat", "INTEGRATED ENGINEERING B. V."],
      "00C031" => ["DesignRe", "DESIGN RESEARCH SYSTEMS, INC."],
      "00C032" => ["I-Cubed", "I-CUBED LIMITED"],
      "00C033" => ["TelebitC", "TELEBIT COMMUNICATIONS APS"],
      "00C034" => ["Transact", "TRANSACTION NETWORK"],
      "00C035" => ["Quintar", "QUINTAR COMPANY"],
      "00C036" => ["RaytechE", "RAYTECH ELECTRONIC CORP."],
      "00C037" => ["Dynatem",""],
      "00C038" => ["RasterIm", "RASTER IMAGE PROCESSING SYSTEM"],
      "00C039" => ["Teridian", "Teridian Semiconductor Corporation"],
      "00C03A" => ["Men-Mikr", "MEN-MIKRO ELEKTRONIK GMBH"],
      "00C03B" => ["Multiacc", "MULTIACCESS COMPUTING CORP."],
      "00C03C" => ["TowerTec", "TOWER TECH S.R.L."],
      "00C03D" => ["Wieseman", "WIESEMANN & THEIS GMBH"],
      "00C03E" => ["FaGebrHe", "FA. GEBR. HELLER GMBH"],
      "00C03F" => ["StoresAu", "STORES AUTOMATED SYSTEMS, INC."],
      "00C040" => ["Ecci",""],
      "00C041" => ["DigitalT", "DIGITAL TRANSMISSION SYSTEMS"],
      "00C042" => ["Datalux", "DATALUX CORP."],
      "00C043" => ["Strataco", "STRATACOM"],
      "00C044" => ["Emcom", "EMCOM CORPORATION"],
      "00C045" => ["Isolatio", "ISOLATION SYSTEMS, LTD."],
      "00C046" => ["BlueChip", "Blue Chip Technology Ltd"],
      "00C047" => ["Unimicro", "UNIMICRO SYSTEMS, INC."],
      "00C048" => ["BayTechn", "BAY TECHNICAL ASSOCIATES"],
      "00C049" => ["USRoboti", "U.S. ROBOTICS, INC."],
      "00C04A" => ["Group200", "GROUP 2000 AG"],
      "00C04B" => ["Creative", "CREATIVE MICROSYSTEMS"],
      "00C04C" => ["Departme", "DEPARTMENT OF FOREIGN AFFAIRS"],
      "00C04D" => ["Mitec", "MITEC, INC."],
      "00C04E" => ["Comtrol", "COMTROL CORPORATION"],
      "00C04F" => ["DellComp", "DELL COMPUTER CORPORATION"],
      "00C050" => ["ToyoDenk", "TOYO DENKI SEIZO K.K."],
      "00C051" => ["Advanced", "ADVANCED INTEGRATION RESEARCH"],
      "00C052" => ["Burr-Bro", "BURR-BROWN"],
      "00C053" => ["AspectSo", "Aspect Software Inc."],
      "00C054" => ["NetworkP", "NETWORK PERIPHERALS, LTD."],
      "00C055" => ["ModularC", "MODULAR COMPUTING TECHNOLOGIES"],
      "00C056" => ["Somelec",""],
      "00C057" => ["MycoElec", "MYCO ELECTRONICS"],
      "00C058" => ["Dataexpe", "DATAEXPERT CORP."],
      "00C059" => ["Denso", "DENSO CORPORATION"],
      "00C05A" => ["Semaphor", "SEMAPHORE COMMUNICATIONS CORP."],
      "00C05B" => ["Networks", "NETWORKS NORTHWEST, INC."],
      "00C05C" => ["Elonex", "ELONEX PLC"],
      "00C05D" => ["L&NTechn", "L&N TECHNOLOGIES"],
      "00C05E" => ["Vari-Lit", "VARI-LITE, INC."],
      "00C05F" => ["Fine-Pal", "FINE-PAL COMPANY LIMITED"],
      "00C060" => ["IdScandi", "ID SCANDINAVIA AS"],
      "00C061" => ["Solectek", "SOLECTEK CORPORATION"],
      "00C062" => ["ImpulseT", "IMPULSE TECHNOLOGY"],
      "00C063" => ["MorningS", "MORNING STAR TECHNOLOGIES, INC"],
      "00C064" => ["GeneralD", "GENERAL DATACOMM IND. INC."],
      "00C065" => ["ScopeCom", "SCOPE COMMUNICATIONS, INC."],
      "00C066" => ["Docupoin", "DOCUPOINT, INC."],
      "00C067" => ["UnitedBa", "UNITED BARCODE INDUSTRIES"],
      "00C068" => ["HmeClear", "HME Clear-Com LTD."],
      "00C069" => ["Axxceler", "Axxcelera Broadband Wireless"],
      "00C06A" => ["Zahner-E", "ZAHNER-ELEKTRIK GMBH & CO. KG"],
      "00C06B" => ["OsiPlus", "OSI PLUS CORPORATION"],
      "00C06C" => ["SvecComp", "SVEC COMPUTER CORP."],
      "00C06D" => ["BocaRese", "BOCA RESEARCH, INC."],
      "00C06E" => ["HaftTech", "HAFT TECHNOLOGY, INC."],
      "00C06F" => ["Komatsu", "KOMATSU LTD."],
      "00C070" => ["SectraSe", "SECTRA SECURE-TRANSMISSION AB"],
      "00C071" => ["AreanexC", "AREANEX COMMUNICATIONS, INC."],
      "00C072" => ["Knx", "KNX LTD."],
      "00C073" => ["Xedia", "XEDIA CORPORATION"],
      "00C074" => ["ToyodaAu", "TOYODA AUTOMATIC LOOM"],
      "00C075" => ["Xante", "XANTE CORPORATION"],
      "00C076" => ["I-DataIn", "I-DATA INTERNATIONAL A-S"],
      "00C077" => ["DaewooTe", "DAEWOO TELECOM LTD."],
      "00C078" => ["Computer", "COMPUTER SYSTEMS ENGINEERING"],
      "00C079" => ["Fonsys", "FONSYS CO.,LTD."],
      "00C07A" => ["PrivaBV", "PRIVA B.V."],
      "00C07B" => ["AscendCo", "ASCEND COMMUNICATIONS, INC."],
      "00C07C" => ["Hightech", "HIGHTECH INFORMATION"],
      "00C07D" => ["RiscDeve", "RISC DEVELOPMENTS LTD."],
      "00C07E" => ["KubotaEl", "KUBOTA CORPORATION ELECTRONIC"],
      "00C07F" => ["NuponCom", "NUPON COMPUTING CORP."],
      "00C080" => ["Netstar", "NETSTAR, INC."],
      "00C081" => ["Metrodat", "METRODATA LTD."],
      "00C082" => ["MoorePro", "MOORE PRODUCTS CO."],
      "00C083" => ["TraceMou", "TRACE MOUNTAIN PRODUCTS, INC."],
      "00C084" => ["DataLink", "DATA LINK CORP. LTD."],
      "00C085" => ["Electron", "ELECTRONICS FOR IMAGING, INC."],
      "00C086" => ["Lynk", "THE LYNK CORPORATION"],
      "00C087" => ["UunetTec", "UUNET TECHNOLOGIES, INC."],
      "00C088" => ["EkfElekt", "EKF ELEKTRONIK GMBH"],
      "00C089" => ["Telindus", "TELINDUS DISTRIBUTION"],
      "00C08A" => ["Lauterba", "Lauterbach GmbH"],
      "00C08B" => ["RisqModu", "RISQ MODULAR SYSTEMS, INC."],
      "00C08C" => ["Performa", "PERFORMANCE TECHNOLOGIES, INC."],
      "00C08D" => ["TronixPr", "TRONIX PRODUCT DEVELOPMENT"],
      "00C08E" => ["NetworkI", "NETWORK INFORMATION TECHNOLOGY"],
      "00C08F" => ["Panasoni", "Panasonic Electric Works Co., Ltd."],
      "00C090" => ["PraimSRL", "PRAIM S.R.L."],
      "00C091" => ["JabilCir", "JABIL CIRCUIT, INC."],
      "00C092" => ["MennenMe", "MENNEN MEDICAL INC."],
      "00C093" => ["AltaRese", "ALTA RESEARCH CORP."],
      "00C094" => ["Vmx", "VMX INC."],
      "00C095" => ["Znyx",""],
      "00C096" => ["Tamura", "TAMURA CORPORATION"],
      "00C097" => ["Archipel", "ARCHIPEL SA"],
      "00C098" => ["ChuntexE", "CHUNTEX ELECTRONIC CO., LTD."],
      "00C099" => ["YoshikiI", "YOSHIKI INDUSTRIAL CO.,LTD."],
      "00C09A" => ["Photonic", "PHOTONICS CORPORATION"],
      "00C09B" => ["Reliance", "RELIANCE COMM/TEC, R-TEC"],
      "00C09C" => ["HiokiEE", "HIOKI E.E. CORPORATION"],
      "00C09D" => ["Distribu", "DISTRIBUTED SYSTEMS INT\'L, INC"],
      "00C09E" => ["CacheCom", "CACHE COMPUTERS, INC."],
      "00C09F" => ["QuantaCo", "QUANTA COMPUTER, INC."],
      "00C0A0" => ["AdvanceM", "ADVANCE MICRO RESEARCH, INC."],
      "00C0A1" => ["TokyoDen", "TOKYO DENSHI SEKEI CO."],
      "00C0A2" => ["Intermed", "INTERMEDIUM A/S"],
      "00C0A3" => ["DualEnte", "DUAL ENTERPRISES CORPORATION"],
      "00C0A4" => ["UnigrafO", "UNIGRAF OY"],
      "00C0A5" => ["DickensD", "DICKENS DATA SYSTEMS"],
      "00C0A6" => ["ExicomAu", "EXICOM AUSTRALIA PTY. LTD"],
      "00C0A7" => ["Seel", "SEEL LTD."],
      "00C0A8" => ["Gvc", "GVC CORPORATION"],
      "00C0A9" => ["BarronMc", "BARRON MCCANN LTD."],
      "00C0AA" => ["SiliconV", "SILICON VALLEY COMPUTER"],
      "00C0AB" => ["Telco", "Telco Systems, Inc."],
      "00C0AC" => ["GambitCo", "GAMBIT COMPUTER COMMUNICATIONS"],
      "00C0AD" => ["MarbenCo", "MARBEN COMMUNICATION SYSTEMS"],
      "00C0AE" => ["Towercom", "TOWERCOM CO. INC. DBA PC HOUSE"],
      "00C0AF" => ["Teklogix", "TEKLOGIX INC."],
      "00C0B0" => ["GccTechn", "GCC TECHNOLOGIES,INC."],
      "00C0B1" => ["GeniusNe", "GENIUS NET CO."],
      "00C0B2" => ["Norand", "NORAND CORPORATION"],
      "00C0B3" => ["ComstatD", "COMSTAT DATACOMM CORPORATION"],
      "00C0B4" => ["MysonTec", "MYSON TECHNOLOGY, INC."],
      "00C0B5" => ["Corporat", "CORPORATE NETWORK SYSTEMS,INC."],
      "00C0B6" => ["Overland", "Overland Storage, Inc."],
      "00C0B7" => ["American", "AMERICAN POWER CONVERSION CORP"],
      "00C0B8" => ["FraserSH", "FRASER\'S HILL LTD."],
      "00C0B9" => ["FunkSoft", "FUNK SOFTWARE, INC."],
      "00C0BA" => ["Netvanta", "NETVANTAGE"],
      "00C0BB" => ["ForvalCr", "FORVAL CREATIVE, INC."],
      "00C0BC" => ["TelecomA", "TELECOM AUSTRALIA/CSSC"],
      "00C0BD" => ["InexTech", "INEX TECHNOLOGIES, INC."],
      "00C0BE" => ["Alcatel-", "ALCATEL - SEL"],
      "00C0BF" => ["Technolo", "TECHNOLOGY CONCEPTS, LTD."],
      "00C0C0" => ["ShoreMic", "SHORE MICROSYSTEMS, INC."],
      "00C0C1" => ["Quad/Gra", "QUAD/GRAPHICS, INC."],
      "00C0C2" => ["Infinite", "INFINITE NETWORKS LTD."],
      "00C0C3" => ["AcusonCo", "ACUSON COMPUTED SONOGRAPHY"],
      "00C0C4" => ["Computer", "COMPUTER OPERATIONAL"],
      "00C0C5" => ["SidInfor", "SID INFORMATICA"],
      "00C0C6" => ["Personal", "PERSONAL MEDIA CORP."],
      "00C0C7" => ["Sparktru", "SPARKTRUM MICROSYSTEMS, INC."],
      "00C0C8" => ["MicroByt", "MICRO BYTE PTY. LTD."],
      "00C0C9" => ["ElsagBai", "ELSAG BAILEY PROCESS"],
      "00C0CA" => ["Alfa", "ALFA, INC."],
      "00C0CB" => ["ControlT", "CONTROL TECHNOLOGY CORPORATION"],
      "00C0CC" => ["Telescie", "TELESCIENCES CO SYSTEMS, INC."],
      "00C0CD" => ["ComeltaS", "COMELTA, S.A."],
      "00C0CE" => ["CeiEngin", "CEI SYSTEMS & ENGINEERING PTE"],
      "00C0CF" => ["ImatranV", "IMATRAN VOIMA OY"],
      "00C0D0" => ["RatocSys", "RATOC SYSTEM INC."],
      "00C0D1" => ["ComtreeT", "COMTREE TECHNOLOGY CORPORATION"],
      "00C0D2" => ["Syntelle", "SYNTELLECT, INC."],
      "00C0D3" => ["OlympusI", "OLYMPUS IMAGE SYSTEMS, INC."],
      "00C0D4" => ["AxonNetw", "AXON NETWORKS, INC."],
      "00C0D5" => ["Werbeage", "Werbeagentur Jurgen Siebert"],
      "00C0D6" => ["J1", "J1 SYSTEMS, INC."],
      "00C0D7" => ["TaiwanTr", "TAIWAN TRADING CENTER DBA"],
      "00C0D8" => ["Universa", "UNIVERSAL DATA SYSTEMS"],
      "00C0D9" => ["QuinteNe", "QUINTE NETWORK CONFIDENTIALITY"],
      "00C0DA" => ["Nice", "NICE SYSTEMS LTD."],
      "00C0DB" => ["IpcPte", "IPC CORPORATION (PTE) LTD."],
      "00C0DC" => ["EosTechn", "EOS TECHNOLOGIES, INC."],
      "00C0DD" => ["Qlogic", "QLogic Corporation"],
      "00C0DE" => ["Zcomm", "ZCOMM, INC."],
      "00C0DF" => ["Kye", "KYE Systems Corp."],
      "00C0E0" => ["DscCommu", "DSC COMMUNICATION CORP."],
      "00C0E1" => ["SonicSol", "SONIC SOLUTIONS"],
      "00C0E2" => ["Calcomp", "CALCOMP, INC."],
      "00C0E3" => ["OsitechC", "OSITECH COMMUNICATIONS, INC."],
      "00C0E4" => ["SiemensB", "SIEMENS BUILDING"],
      "00C0E5" => ["GespacSA", "GESPAC, S.A."],
      "00C0E6" => ["Verilink", "Verilink Corporation"],
      "00C0E7" => ["Fiberdat", "FIBERDATA AB"],
      "00C0E8" => ["Plexcom", "PLEXCOM, INC."],
      "00C0E9" => ["OakSolut", "OAK SOLUTIONS, LTD."],
      "00C0EA" => ["ArrayTec", "ARRAY TECHNOLOGY LTD."],
      "00C0EB" => ["SehCompu", "SEH COMPUTERTECHNIK GMBH"],
      "00C0EC" => ["DauphinT", "DAUPHIN TECHNOLOGY"],
      "00C0ED" => ["UsArmyEl", "US ARMY ELECTRONIC"],
      "00C0EE" => ["Kyocera", "KYOCERA CORPORATION"],
      "00C0EF" => ["Abit", "ABIT CORPORATION"],
      "00C0F0" => ["Kingston", "KINGSTON TECHNOLOGY CORP."],
      "00C0F1" => ["ShinkoEl", "SHINKO ELECTRIC CO., LTD."],
      "00C0F2" => ["Transiti", "TRANSITION NETWORKS"],
      "00C0F3" => ["NetworkC", "NETWORK COMMUNICATIONS CORP."],
      "00C0F4" => ["Interlin", "INTERLINK SYSTEM CO., LTD."],
      "00C0F5" => ["Metacomp", "METACOMP, INC."],
      "00C0F6" => ["CelanTec", "CELAN TECHNOLOGY INC."],
      "00C0F7" => ["EngageCo", "ENGAGE COMMUNICATION, INC."],
      "00C0F8" => ["AboutCom", "ABOUT COMPUTING INC."],
      "00C0F9" => ["EmersonN", "Emerson Network Power"],
      "00C0FA" => ["CanaryCo", "CANARY COMMUNICATIONS, INC."],
      "00C0FB" => ["Advanced", "ADVANCED TECHNOLOGY LABS"],
      "00C0FC" => ["ElasticR", "ELASTIC REALITY, INC."],
      "00C0FD" => ["Prosum",""],
      "00C0FE" => ["AptecCom", "APTEC COMPUTER SYSTEMS, INC."],
      "00C0FF" => ["DotHill", "DOT HILL SYSTEMS CORPORATION"],
      "00C610" => ["Apple", "Apple, Inc."],
      "00CBBD" => ["Cambridg", "Cambridge Broadband Networks Ltd."],
      "00CD90" => ["MasElekt", "MAS Elektronik AG"],
      "00CF1C" => ["Communic", "COMMUNICATION MACHINERY CORP."],
      "00D000" => ["FerranSc", "FERRAN SCIENTIFIC, INC."],
      "00D001" => ["VstTechn", "VST TECHNOLOGIES, INC."],
      "00D002" => ["Ditech", "DITECH CORPORATION"],
      "00D003" => ["ComdaEnt", "COMDA ENTERPRISES CORP."],
      "00D004" => ["Pentacom", "PENTACOM LTD."],
      "00D005" => ["ZhsZeitm", "ZHS ZEITMANAGEMENTSYSTEME"],
      "00D006" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D007" => ["MicAssoc", "MIC ASSOCIATES, INC."],
      "00D008" => ["Mactell", "MACTELL CORPORATION"],
      "00D009" => ["HsingTec", "HSING TECH. ENTERPRISE CO. LTD"],
      "00D00A" => ["Lanacces", "LANACCESS TELECOM S.A."],
      "00D00B" => ["RhkTechn", "RHK TECHNOLOGY, INC."],
      "00D00C" => ["SnijderM", "SNIJDER MICRO SYSTEMS"],
      "00D00D" => ["Micromer", "MICROMERITICS INSTRUMENT"],
      "00D00E" => ["Pluris", "PLURIS, INC."],
      "00D00F" => ["SpeechDe", "SPEECH DESIGN GMBH"],
      "00D010" => ["Converge", "CONVERGENT NETWORKS, INC."],
      "00D011" => ["PrismVid", "PRISM VIDEO, INC."],
      "00D012" => ["Gatework", "GATEWORKS CORP."],
      "00D013" => ["PrimexAe", "PRIMEX AEROSPACE COMPANY"],
      "00D014" => ["Root", "ROOT, INC."],
      "00D015" => ["UnivexMi", "UNIVEX MICROTECHNOLOGY CORP."],
      "00D016" => ["ScmMicro", "SCM MICROSYSTEMS, INC."],
      "00D017" => ["SyntechI", "SYNTECH INFORMATION CO., LTD."],
      "00D018" => ["QwesCom", "QWES. COM, INC."],
      "00D019" => ["Dainippo", "DAINIPPON SCREEN CORPORATE"],
      "00D01A" => ["UrmetTlc", "URMET  TLC S.P.A."],
      "00D01B" => ["MimakiEn", "MIMAKI ENGINEERING CO., LTD."],
      "00D01C" => ["SbsTechn", "SBS TECHNOLOGIES,"],
      "00D01D" => ["FurunoEl", "FURUNO ELECTRIC CO., LTD."],
      "00D01E" => ["Pingtel", "PINGTEL CORP."],
      "00D01F" => ["CtamPty", "CTAM PTY. LTD."],
      "00D020" => ["AimSyste", "AIM SYSTEM, INC."],
      "00D021" => ["RegentEl", "REGENT ELECTRONICS CORP."],
      "00D022" => ["Incredib", "INCREDIBLE TECHNOLOGIES, INC."],
      "00D023" => ["Infortre", "INFORTREND TECHNOLOGY, INC."],
      "00D024" => ["Cognex", "Cognex Corporation"],
      "00D025" => ["Xrosstec", "XROSSTECH, INC."],
      "00D026" => ["Hirschma", "HIRSCHMANN AUSTRIA GMBH"],
      "00D027" => ["AppliedA", "APPLIED AUTOMATION, INC."],
      "00D028" => ["OmneonVi", "OMNEON VIDEO NETWORKS"],
      "00D029" => ["Wakefern", "WAKEFERN FOOD CORPORATION"],
      "00D02A" => ["Voxent", "Voxent Systems Ltd."],
      "00D02B" => ["Jetcell", "JETCELL, INC."],
      "00D02C" => ["Campbell", "CAMPBELL SCIENTIFIC, INC."],
      "00D02D" => ["Ademco",""],
      "00D02E" => ["Communic", "COMMUNICATION AUTOMATION CORP."],
      "00D02F" => ["VlsiTech", "VLSI TECHNOLOGY INC."],
      "00D030" => ["Safetran", "Safetran Systems Corp"],
      "00D031" => ["Industri", "INDUSTRIAL LOGIC CORPORATION"],
      "00D032" => ["YanoElec", "YANO ELECTRIC CO., LTD."],
      "00D033" => ["DalianDa", "DALIAN DAXIAN NETWORK"],
      "00D034" => ["Ormec", "ORMEC SYSTEMS CORP."],
      "00D035" => ["Behavior", "BEHAVIOR TECH. COMPUTER CORP."],
      "00D036" => ["Technolo", "TECHNOLOGY ATLANTA CORP."],
      "00D037" => ["PaceFran", "Pace France"],
      "00D038" => ["Fivemere", "FIVEMERE, LTD."],
      "00D039" => ["Utilicom", "UTILICOM, INC."],
      "00D03A" => ["Zoneworx", "ZONEWORX, INC."],
      "00D03B" => ["VisionPr", "VISION PRODUCTS PTY. LTD."],
      "00D03C" => ["Vieo", "Vieo, Inc."],
      "00D03D" => ["GalileoT", "GALILEO TECHNOLOGY, LTD."],
      "00D03E" => ["Rocketch", "ROCKETCHIPS, INC."],
      "00D03F" => ["American", "AMERICAN COMMUNICATION"],
      "00D040" => ["Sysmate", "SYSMATE CO., LTD."],
      "00D041" => ["AmigoTec", "AMIGO TECHNOLOGY CO., LTD."],
      "00D042" => ["MahloUg", "MAHLO GMBH & CO. UG"],
      "00D043" => ["ZonalRet", "ZONAL RETAIL DATA SYSTEMS"],
      "00D044" => ["AlidianN", "ALIDIAN NETWORKS, INC."],
      "00D045" => ["Kvaser", "KVASER AB"],
      "00D046" => ["DolbyLab", "DOLBY LABORATORIES, INC."],
      "00D047" => ["XnTechno", "XN TECHNOLOGIES"],
      "00D048" => ["Ecton", "ECTON, INC."],
      "00D049" => ["Impresst", "IMPRESSTEK CO., LTD."],
      "00D04A" => ["Presence", "PRESENCE TECHNOLOGY GMBH"],
      "00D04B" => ["LaCieGro", "LA CIE GROUP S.A."],
      "00D04C" => ["EurotelT", "EUROTEL TELECOM LTD."],
      "00D04D" => ["DivOfRes", "DIV OF RESEARCH & STATISTICS"],
      "00D04E" => ["Logibag",""],
      "00D04F" => ["Bitronic", "BITRONICS, INC."],
      "00D050" => ["Iskratel",""],
      "00D051" => ["O2Micro", "O2 MICRO, INC."],
      "00D052" => ["AscendCo", "ASCEND COMMUNICATIONS, INC."],
      "00D053" => ["Connecte", "CONNECTED SYSTEMS"],
      "00D054" => ["SasInsti", "SAS INSTITUTE INC."],
      "00D055" => ["Kathrein", "KATHREIN-WERKE KG"],
      "00D056" => ["Somat", "SOMAT CORPORATION"],
      "00D057" => ["Ultrak", "ULTRAK, INC."],
      "00D058" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D059" => ["AmbitMic", "AMBIT MICROSYSTEMS CORP."],
      "00D05A" => ["Symbioni", "SYMBIONICS, LTD."],
      "00D05B" => ["Acroloop", "ACROLOOP MOTION CONTROL"],
      "00D05C" => ["Technotr", "TECHNOTREND SYSTEMTECHNIK GMBH"],
      "00D05D" => ["Intelliw", "INTELLIWORXX, INC."],
      "00D05E" => ["Stratabe", "STRATABEAM TECHNOLOGY, INC."],
      "00D05F" => ["Valcom", "VALCOM, INC."],
      "00D060" => ["Panasoni", "Panasonic Europe Ltd."],
      "00D061" => ["TremonEn", "TREMON ENTERPRISES CO., LTD."],
      "00D062" => ["Digigram",""],
      "00D063" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D064" => ["Multitel",""],
      "00D065" => ["TokoElec", "TOKO ELECTRIC"],
      "00D066" => ["Wintriss", "WINTRISS ENGINEERING CORP."],
      "00D067" => ["CampioCo", "CAMPIO COMMUNICATIONS"],
      "00D068" => ["Iwill", "IWILL CORPORATION"],
      "00D069" => ["Technolo", "TECHNOLOGIC SYSTEMS"],
      "00D06A" => ["Linkup", "LINKUP SYSTEMS CORPORATION"],
      "00D06B" => ["SrTeleco", "SR TELECOM INC."],
      "00D06C" => ["Sharewav", "SHAREWAVE, INC."],
      "00D06D" => ["Acrison", "ACRISON, INC."],
      "00D06E" => ["Trendvie", "TRENDVIEW RECORDERS LTD."],
      "00D06F" => ["KmcContr", "KMC CONTROLS"],
      "00D070" => ["LongWell", "LONG WELL ELECTRONICS CORP."],
      "00D071" => ["Echelon", "ECHELON CORP."],
      "00D072" => ["Broadlog", "BROADLOGIC"],
      "00D073" => ["AcnAdvan", "ACN ADVANCED COMMUNICATIONS"],
      "00D074" => ["Taqua", "TAQUA SYSTEMS, INC."],
      "00D075" => ["AlarisMe", "ALARIS MEDICAL SYSTEMS, INC."],
      "00D076" => ["BankOfAm", "Bank of America"],
      "00D077" => ["LucentTe", "LUCENT TECHNOLOGIES"],
      "00D078" => ["EltexOfS", "Eltex of Sweden AB"],
      "00D079" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D07A" => ["Amaquest", "AMAQUEST COMPUTER CORP."],
      "00D07B" => ["ComcamIn", "COMCAM INTERNATIONAL INC"],
      "00D07C" => ["KoyoElec", "KOYO ELECTRONICS INC. CO.,LTD."],
      "00D07D" => ["CosineCo", "COSINE COMMUNICATIONS"],
      "00D07E" => ["Keycorp", "KEYCORP LTD."],
      "00D07F" => ["Strategy", "STRATEGY & TECHNOLOGY, LIMITED"],
      "00D080" => ["Exabyte", "EXABYTE CORPORATION"],
      "00D081" => ["RtdEmbed", "RTD Embedded Technologies, Inc."],
      "00D082" => ["Iowave", "IOWAVE INC."],
      "00D083" => ["Invertex", "INVERTEX, INC."],
      "00D084" => ["Nexcomm", "NEXCOMM SYSTEMS, INC."],
      "00D085" => ["OtisElev", "OTIS ELEVATOR COMPANY"],
      "00D086" => ["Foveon", "FOVEON, INC."],
      "00D087" => ["Microfir", "MICROFIRST INC."],
      "00D088" => ["Motorola", "Motorola, Inc."],
      "00D089" => ["Dynacolo", "DYNACOLOR, INC."],
      "00D08A" => ["PhotronU", "PHOTRON USA"],
      "00D08B" => ["AdvaOpti", "ADVA Optical Networking Ltd"],
      "00D08C" => ["GenoaTec", "GENOA TECHNOLOGY, INC."],
      "00D08D" => ["PhoenixG", "PHOENIX GROUP, INC."],
      "00D08E" => ["Nvision", "NVISION INC."],
      "00D08F" => ["ArdentTe", "ARDENT TECHNOLOGIES, INC."],
      "00D090" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D091" => ["Smartsan", "SMARTSAN SYSTEMS, INC."],
      "00D092" => ["Glenayre", "GLENAYRE WESTERN MULTIPLEX"],
      "00D093" => ["Tq-Compo", "TQ - COMPONENTS GMBH"],
      "00D094" => ["Timeline", "TIMELINE VISTA, INC."],
      "00D095" => ["Alcatel-", "Alcatel-Lucent, Enterprise Business Group"],
      "00D096" => ["3comEuro", "3COM EUROPE LTD."],
      "00D097" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D098" => ["PhotonDy", "Photon Dynamics Canada Inc."],
      "00D099" => ["ElcardOy", "ELCARD OY"],
      "00D09A" => ["Filanet", "FILANET CORPORATION"],
      "00D09B" => ["Spectel", "SPECTEL LTD."],
      "00D09C" => ["KapadiaC", "KAPADIA COMMUNICATIONS"],
      "00D09D" => ["VerisInd", "VERIS INDUSTRIES"],
      "00D09E" => ["2wire", "2WIRE, INC."],
      "00D09F" => ["NovtekTe", "NOVTEK TEST SYSTEMS"],
      "00D0A0" => ["MipsDenm", "MIPS DENMARK"],
      "00D0A1" => ["OskarVie", "OSKAR VIERLING GMBH + CO. KG"],
      "00D0A2" => ["Integrat", "INTEGRATED DEVICE"],
      "00D0A3" => ["VocalDat", "VOCAL DATA, INC."],
      "00D0A4" => ["AlantroC", "ALANTRO COMMUNICATIONS"],
      "00D0A5" => ["American", "AMERICAN ARIUM"],
      "00D0A6" => ["LanbirdT", "LANBIRD TECHNOLOGY CO., LTD."],
      "00D0A7" => ["TokyoSok", "TOKYO SOKKI KENKYUJO CO., LTD."],
      "00D0A8" => ["NetworkE", "NETWORK ENGINES, INC."],
      "00D0A9" => ["ShinanoK", "SHINANO KENSHI CO., LTD."],
      "00D0AA" => ["ChaseCom", "CHASE COMMUNICATIONS"],
      "00D0AB" => ["Deltakab", "DELTAKABEL TELECOM CV"],
      "00D0AC" => ["GraysonW", "GRAYSON WIRELESS"],
      "00D0AD" => ["TlIndust", "TL INDUSTRIES"],
      "00D0AE" => ["OresisCo", "ORESIS COMMUNICATIONS, INC."],
      "00D0AF" => ["Cutler-H", "CUTLER-HAMMER, INC."],
      "00D0B0" => ["Bitswitc", "BITSWITCH LTD."],
      "00D0B1" => ["OmegaEle", "OMEGA ELECTRONICS SA"],
      "00D0B2" => ["Xiotech", "XIOTECH CORPORATION"],
      "00D0B3" => ["DrsTechn", "DRS Technologies Canada Ltd"],
      "00D0B4" => ["Katsujim", "KATSUJIMA CO., LTD."],
      "00D0B5" => ["IpricotF", "IPricot formerly DotCom"],
      "00D0B6" => ["Crescent", "CRESCENT NETWORKS, INC."],
      "00D0B7" => ["Intel", "INTEL CORPORATION"],
      "00D0B8" => ["Iomega", "Iomega Corporation"],
      "00D0B9" => ["Microtek", "MICROTEK INTERNATIONAL, INC."],
      "00D0BA" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D0BB" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D0BC" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D0BD" => ["SiliconI", "Silicon Image GmbH"],
      "00D0BE" => ["Emutec", "EMUTEC INC."],
      "00D0BF" => ["PivotalT", "PIVOTAL TECHNOLOGIES"],
      "00D0C0" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D0C1" => ["Harmonic", "HARMONIC DATA SYSTEMS, LTD."],
      "00D0C2" => ["Balthaza", "BALTHAZAR TECHNOLOGY AB"],
      "00D0C3" => ["VividTec", "VIVID TECHNOLOGY PTE, LTD."],
      "00D0C4" => ["Teratech", "TERATECH CORPORATION"],
      "00D0C5" => ["Computat", "COMPUTATIONAL SYSTEMS, INC."],
      "00D0C6" => ["ThomasBe", "THOMAS & BETTS CORP."],
      "00D0C7" => ["Pathway", "PATHWAY, INC."],
      "00D0C8" => ["Prevas", "Prevas A/S"],
      "00D0C9" => ["Advantec", "ADVANTECH CO., LTD."],
      "00D0CA" => ["Intrinsy", "Intrinsyc Software International Inc."],
      "00D0CB" => ["Dasan", "DASAN CO., LTD."],
      "00D0CC" => ["Technolo", "TECHNOLOGIES LYRE INC."],
      "00D0CD" => ["AtanTech", "ATAN TECHNOLOGY INC."],
      "00D0CE" => ["AsystEle", "ASYST ELECTRONIC"],
      "00D0CF" => ["MoretonB", "MORETON BAY"],
      "00D0D0" => ["Zhongxin", "ZHONGXING TELECOM LTD."],
      "00D0D1" => ["Sycamore", "Sycamore Networks"],
      "00D0D2" => ["Epilog", "EPILOG CORPORATION"],
      "00D0D3" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D0D4" => ["V-Bits", "V-BITS, INC."],
      "00D0D5" => ["Grundig", "GRUNDIG AG"],
      "00D0D6" => ["AethraTe", "AETHRA TELECOMUNICAZIONI"],
      "00D0D7" => ["B2c2", "B2C2, INC."],
      "00D0D8" => ["3com", "3Com Corporation"],
      "00D0D9" => ["Dedicate", "DEDICATED MICROCOMPUTERS"],
      "00D0DA" => ["TaicomDa", "TAICOM DATA SYSTEMS CO., LTD."],
      "00D0DB" => ["McquayIn", "MCQUAY INTERNATIONAL"],
      "00D0DC" => ["ModularM", "MODULAR MINING SYSTEMS, INC."],
      "00D0DD" => ["SunriseT", "SUNRISE TELECOM, INC."],
      "00D0DE" => ["PhilipsM", "PHILIPS MULTIMEDIA NETWORK"],
      "00D0DF" => ["KuzumiEl", "KUZUMI ELECTRONICS, INC."],
      "00D0E0" => ["DooinEle", "DOOIN ELECTRONICS CO."],
      "00D0E1" => ["Avionite", "AVIONITEK ISRAEL INC."],
      "00D0E2" => ["MrtMicro", "MRT MICRO, INC."],
      "00D0E3" => ["Ele-Chem", "ELE-CHEM ENGINEERING CO., LTD."],
      "00D0E4" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D0E5" => ["Solidum", "SOLIDUM SYSTEMS CORP."],
      "00D0E6" => ["Ibond", "IBOND INC."],
      "00D0E7" => ["VconTele", "VCON TELECOMMUNICATION LTD."],
      "00D0E8" => ["MacSyste", "MAC SYSTEM CO., LTD."],
      "00D0E9" => ["Advantag", "Advantage Century Telecommunication Corp."],
      "00D0EA" => ["NextoneC", "NEXTONE COMMUNICATIONS, INC."],
      "00D0EB" => ["Lightera", "LIGHTERA NETWORKS, INC."],
      "00D0EC" => ["NakayoTe", "NAKAYO TELECOMMUNICATIONS, INC"],
      "00D0ED" => ["Xiox",""],
      "00D0EE" => ["Dictapho", "DICTAPHONE CORPORATION"],
      "00D0EF" => ["Igt",""],
      "00D0F0" => ["Convisio", "CONVISION TECHNOLOGY GMBH"],
      "00D0F1" => ["SegaEnte", "SEGA ENTERPRISES, LTD."],
      "00D0F2" => ["Monterey", "MONTEREY NETWORKS"],
      "00D0F3" => ["SolariDi", "SOLARI DI UDINE SPA"],
      "00D0F4" => ["Carinthi", "CARINTHIAN TECH INSTITUTE"],
      "00D0F5" => ["OrangeMi", "ORANGE MICRO, INC."],
      "00D0F6" => ["AlcatelC", "Alcatel Canada"],
      "00D0F7" => ["NextNets", "NEXT NETS CORPORATION"],
      "00D0F8" => ["FujianSt", "FUJIAN STAR TERMINAL"],
      "00D0F9" => ["AcuteCom", "ACUTE COMMUNICATIONS CORP."],
      "00D0FA" => ["ThalesE-", "Thales e-Security Ltd."],
      "00D0FB" => ["TekMicro", "TEK MICROSYSTEMS, INCORPORATED"],
      "00D0FC" => ["GraniteM", "GRANITE MICROSYSTEMS"],
      "00D0FD" => ["OptimaTe", "OPTIMA TELE.COM, INC."],
      "00D0FE" => ["AstralPo", "ASTRAL POINT"],
      "00D0FF" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00D11C" => ["Acetel",""],
      "00D38D" => ["HotelTec", "Hotel Technology Next Generation"],
      "00D632" => ["GeEnergy", "GE Energy"],
      "00DB45" => ["Thamway", "THAMWAY CO.,LTD."],
      "00DBDF" => ["IntelCor", "Intel Corporate"],
      "00DD00" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD01" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD02" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD03" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD04" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD05" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD06" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD07" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD08" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD09" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD0A" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD0B" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD0C" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD0D" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD0E" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DD0F" => ["Ungerman", "UNGERMANN-BASS INC."],
      "00DEFB" => ["Cisco", "Cisco Systems"],
      "00E000" => ["Fujitsu", "Fujitsu Limited"],
      "00E001" => ["StrandLi", "STRAND LIGHTING LIMITED"],
      "00E002" => ["Crossroa", "CROSSROADS SYSTEMS, INC."],
      "00E003" => ["NokiaWir", "NOKIA WIRELESS BUSINESS COMMUN"],
      "00E004" => ["Pmc-Sier", "PMC-SIERRA, INC."],
      "00E005" => ["Technica", "TECHNICAL CORP."],
      "00E006" => ["SiliconI", "SILICON INTEGRATED SYS. CORP."],
      "00E007" => ["AvayaEcs", "Avaya ECS Ltd"],
      "00E008" => ["AmazingC", "AMAZING CONTROLS! INC."],
      "00E009" => ["Marathon", "MARATHON TECHNOLOGIES CORP."],
      "00E00A" => ["Diba", "DIBA, INC."],
      "00E00B" => ["RooftopC", "ROOFTOP COMMUNICATIONS CORP."],
      "00E00C" => ["Motorola",""],
      "00E00D" => ["Radiant", "RADIANT SYSTEMS"],
      "00E00E" => ["AvalonIm", "AVALON IMAGING SYSTEMS, INC."],
      "00E00F" => ["Shanghai", "SHANGHAI BAUD DATA"],
      "00E010" => ["HessSb-A", "HESS SB-AUTOMATENBAU GmbH"],
      "00E011" => ["Uniden", "Uniden Corporation"],
      "00E012" => ["PlutoTec", "PLUTO TECHNOLOGIES INTERNATIONAL INC."],
      "00E013" => ["EasternE", "EASTERN ELECTRONIC CO., LTD."],
      "00E014" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E015" => ["Heiwa", "HEIWA CORPORATION"],
      "00E016" => ["RapidCit", "RAPID CITY COMMUNICATIONS"],
      "00E017" => ["Exxact", "EXXACT GmbH"],
      "00E018" => ["AsustekC", "ASUSTEK COMPUTER INC."],
      "00E019" => ["IngGiord", "ING. GIORDANO ELETTRONICA"],
      "00E01A" => ["Comtec", "COMTEC SYSTEMS. CO., LTD."],
      "00E01B" => ["SphereCo", "SPHERE COMMUNICATIONS, INC."],
      "00E01C" => ["Cradlepo", "Cradlepoint, Inc"],
      "00E01D" => ["WebtvNet", "WebTV NETWORKS, INC."],
      "00E01E" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E01F" => ["Avidia", "AVIDIA Systems, Inc."],
      "00E020" => ["Tecnomen", "TECNOMEN OY"],
      "00E021" => ["Freegate", "FREEGATE CORP."],
      "00E022" => ["AnalogDe", "Analog Devices Inc."],
      "00E023" => ["Telrad",""],
      "00E024" => ["GadzooxN", "GADZOOX NETWORKS"],
      "00E025" => ["Dit", "dit Co., Ltd."],
      "00E026" => ["RedlakeM", "Redlake MASD LLC"],
      "00E027" => ["Dux", "DUX, INC."],
      "00E028" => ["Aptix", "APTIX CORPORATION"],
      "00E029" => ["Standard", "STANDARD MICROSYSTEMS CORP."],
      "00E02A" => ["Tandberg", "TANDBERG TELEVISION AS"],
      "00E02B" => ["ExtremeN", "EXTREME NETWORKS"],
      "00E02C" => ["AstCompu", "AST COMPUTER"],
      "00E02D" => ["Innomedi", "InnoMediaLogic, Inc."],
      "00E02E" => ["SpcElect", "SPC ELECTRONICS CORPORATION"],
      "00E02F" => ["McnsHold", "MCNS HOLDINGS, L.P."],
      "00E030" => ["MelitaIn", "MELITA INTERNATIONAL CORP."],
      "00E031" => ["Hagiwara", "HAGIWARA ELECTRIC CO., LTD."],
      "00E032" => ["MisysFin", "MISYS FINANCIAL SYSTEMS, LTD."],
      "00E033" => ["EEPD", "E.E.P.D. GmbH"],
      "00E034" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E035" => ["EmersonN", "Emerson Network Power"],
      "00E036" => ["Pioneer", "PIONEER CORPORATION"],
      "00E037" => ["Century", "CENTURY CORPORATION"],
      "00E038" => ["Proxima", "PROXIMA CORPORATION"],
      "00E039" => ["Paradyne", "PARADYNE CORP."],
      "00E03A" => ["Cabletro", "CABLETRON SYSTEMS, INC."],
      "00E03B" => ["Prominet", "PROMINET CORPORATION"],
      "00E03C" => ["Advansys",""],
      "00E03D" => ["FoconEle", "FOCON ELECTRONIC SYSTEMS A/S"],
      "00E03E" => ["Alfatech", "ALFATECH, INC."],
      "00E03F" => ["Jaton", "JATON CORPORATION"],
      "00E040" => ["Deskstat", "DeskStation Technology, Inc."],
      "00E041" => ["Cspi",""],
      "00E042" => ["Pacom", "Pacom Systems Ltd."],
      "00E043" => ["Vitalcom",""],
      "00E044" => ["Lsics", "LSICS CORPORATION"],
      "00E045" => ["Touchwav", "TOUCHWAVE, INC."],
      "00E046" => ["BentlyNe", "BENTLY NEVADA CORP."],
      "00E047" => ["Infocus", "InFocus Corporation"],
      "00E048" => ["SdlCommu", "SDL COMMUNICATIONS, INC."],
      "00E049" => ["MicrowiE", "MICROWI ELECTRONIC GmbH"],
      "00E04A" => ["Enhanced", "ENHANCED MESSAGING SYSTEMS, INC"],
      "00E04B" => ["JumpIndu", "JUMP INDUSTRIELLE COMPUTERTECHNIK GmbH"],
      "00E04C" => ["RealtekS", "REALTEK SEMICONDUCTOR CORP."],
      "00E04D" => ["Internet", "INTERNET INITIATIVE JAPAN, INC"],
      "00E04E" => ["SanyoDen", "SANYO DENKI CO., LTD."],
      "00E04F" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E050" => ["Executon", "EXECUTONE INFORMATION SYSTEMS, INC."],
      "00E051" => ["Talx", "TALX CORPORATION"],
      "00E052" => ["BrocadeC", "Brocade Communications Systems, Inc"],
      "00E053" => ["Cellport", "CELLPORT LABS, INC."],
      "00E054" => ["KodaiHit", "KODAI HITEC CO., LTD."],
      "00E055" => ["Ingenier", "INGENIERIA ELECTRONICA COMERCIAL INELCOM S.A."],
      "00E056" => ["Holontec", "HOLONTECH CORPORATION"],
      "00E057" => ["HanMicro", "HAN MICROTELECOM. CO., LTD."],
      "00E058" => ["PhaseOne", "PHASE ONE DENMARK A/S"],
      "00E059" => ["Controll", "CONTROLLED ENVIRONMENTS, LTD."],
      "00E05A" => ["GaleaNet", "GALEA NETWORK SECURITY"],
      "00E05B" => ["WestEnd", "WEST END SYSTEMS CORP."],
      "00E05C" => ["Matsushi", "MATSUSHITA KOTOBUKI ELECTRONICS INDUSTRIES, LTD."],
      "00E05D" => ["Unitec", "UNITEC CO., LTD."],
      "00E05E" => ["JapanAvi", "JAPAN AVIATION ELECTRONICS INDUSTRY, LTD."],
      "00E05F" => ["E-Net", "e-Net, Inc."],
      "00E060" => ["Sherwood",""],
      "00E061" => ["Edgepoin", "EdgePoint Networks, Inc."],
      "00E062" => ["HostEngi", "HOST ENGINEERING"],
      "00E063" => ["Cabletro", "CABLETRON - YAGO SYSTEMS, INC."],
      "00E064" => ["SamsungE", "SAMSUNG ELECTRONICS"],
      "00E065" => ["OpticalA", "OPTICAL ACCESS INTERNATIONAL"],
      "00E066" => ["Promax", "ProMax Systems, Inc."],
      "00E067" => ["EacAutom", "eac AUTOMATION-CONSULTING GmbH"],
      "00E068" => ["Merrimac", "MERRIMAC SYSTEMS INC."],
      "00E069" => ["Jaycor",""],
      "00E06A" => ["Kapsch", "KAPSCH AG"],
      "00E06B" => ["W&GSpeci", "W&G SPECIAL PRODUCTS"],
      "00E06C" => ["AepInter", "AEP Systems International Ltd"],
      "00E06D" => ["Compuwar", "COMPUWARE CORPORATION"],
      "00E06E" => ["FarSPA", "FAR SYSTEMS S.p.A."],
      "00E06F" => ["Motorola", "Motorola, Inc."],
      "00E070" => ["DhTechno", "DH TECHNOLOGY"],
      "00E071" => ["EpisMicr", "EPIS MICROCOMPUTER"],
      "00E072" => ["Lynk",""],
      "00E073" => ["National", "NATIONAL AMUSEMENT NETWORK, INC."],
      "00E074" => ["TiernanC", "TIERNAN COMMUNICATIONS, INC."],
      "00E075" => ["Verilink", "Verilink Corporation"],
      "00E076" => ["Developm", "DEVELOPMENT CONCEPTS, INC."],
      "00E077" => ["Webgear", "WEBGEAR, INC."],
      "00E078" => ["Berkeley", "BERKELEY NETWORKS"],
      "00E079" => ["ATNR", "A.T.N.R."],
      "00E07A" => ["Mikrodid", "MIKRODIDAKT AB"],
      "00E07B" => ["BayNetwo", "BAY NETWORKS"],
      "00E07C" => ["Mettler-", "METTLER-TOLEDO, INC."],
      "00E07D" => ["Netronix", "NETRONIX, INC."],
      "00E07E" => ["WaltDisn", "WALT DISNEY IMAGINEERING"],
      "00E07F" => ["Logistis", "LOGISTISTEM s.r.l."],
      "00E080" => ["ControlR", "CONTROL RESOURCES CORPORATION"],
      "00E081" => ["TyanComp", "TYAN COMPUTER CORP."],
      "00E082" => ["Anerma",""],
      "00E083" => ["JatoTech", "JATO TECHNOLOGIES, INC."],
      "00E084" => ["Compulit", "COMPULITE R&D"],
      "00E085" => ["GlobalMa", "GLOBAL MAINTECH, INC."],
      "00E086" => ["CybexCom", "CYBEX COMPUTER PRODUCTS"],
      "00E087" => ["Lecroy-N", "LeCroy - Networking Productions Division"],
      "00E088" => ["Ltx", "LTX CORPORATION"],
      "00E089" => ["IonNetwo", "ION Networks, Inc."],
      "00E08A" => ["GecAvery", "GEC AVERY, LTD."],
      "00E08B" => ["Qlogic", "QLogic Corp."],
      "00E08C" => ["Neoparad", "NEOPARADIGM LABS, INC."],
      "00E08D" => ["Pressure", "PRESSURE SYSTEMS, INC."],
      "00E08E" => ["Utstarco", "UTSTARCOM"],
      "00E08F" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E090" => ["BeckmanL", "BECKMAN LAB. AUTOMATION DIV."],
      "00E091" => ["LgElectr", "LG ELECTRONICS, INC."],
      "00E092" => ["Admtek", "ADMTEK INCORPORATED"],
      "00E093" => ["AckfinNe", "ACKFIN NETWORKS"],
      "00E094" => ["OsaiSrl", "OSAI SRL"],
      "00E095" => ["Advanced", "ADVANCED-VISION TECHNOLGIES CORP."],
      "00E096" => ["Shimadzu", "SHIMADZU CORPORATION"],
      "00E097" => ["CarrierA", "CARRIER ACCESS CORPORATION"],
      "00E098" => ["Trend",""],
      "00E099" => ["Samson", "SAMSON AG"],
      "00E09A" => ["Positron", "Positron Inc."],
      "00E09B" => ["EngageNe", "ENGAGE NETWORKS, INC."],
      "00E09C" => ["Mii",""],
      "00E09D" => ["Sarnoff", "SARNOFF CORPORATION"],
      "00E09E" => ["Quantum", "QUANTUM CORPORATION"],
      "00E09F" => ["PixelVis", "PIXEL VISION"],
      "00E0A0" => ["Wiltron", "WILTRON CO."],
      "00E0A1" => ["HimaPaul", "HIMA PAUL HILDEBRANDT GmbH Co. KG"],
      "00E0A2" => ["Microsla", "MICROSLATE INC."],
      "00E0A3" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E0A4" => ["EsaoteSP", "ESAOTE S.p.A."],
      "00E0A5" => ["ComcoreS", "ComCore Semiconductor, Inc."],
      "00E0A6" => ["TelogyNe", "TELOGY NETWORKS, INC."],
      "00E0A7" => ["IpcInfor", "IPC INFORMATION SYSTEMS, INC."],
      "00E0A8" => ["Sat", "SAT GmbH & Co."],
      "00E0A9" => ["FunaiEle", "FUNAI ELECTRIC CO., LTD."],
      "00E0AA" => ["Electros", "ELECTROSONIC LTD."],
      "00E0AB" => ["DimatSA", "DIMAT S.A."],
      "00E0AC" => ["Midsco", "MIDSCO, INC."],
      "00E0AD" => ["EesTechn", "EES TECHNOLOGY, LTD."],
      "00E0AE" => ["Xaqti", "XAQTI CORPORATION"],
      "00E0AF" => ["GeneralD", "GENERAL DYNAMICS INFORMATION SYSTEMS"],
      "00E0B0" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E0B1" => ["Alcatel-", "Alcatel-Lucent, Enterprise Business Group"],
      "00E0B2" => ["TelmaxCo", "TELMAX COMMUNICATIONS CORP."],
      "00E0B3" => ["Etherwan", "EtherWAN Systems, Inc."],
      "00E0B4" => ["TechnoSc", "TECHNO SCOPE CO., LTD."],
      "00E0B5" => ["ArdentCo", "ARDENT COMMUNICATIONS CORP."],
      "00E0B6" => ["EntradaN", "Entrada Networks"],
      "00E0B7" => ["PiGroup", "PI GROUP, LTD."],
      "00E0B8" => ["Gateway2", "GATEWAY 2000"],
      "00E0B9" => ["Byas", "BYAS SYSTEMS"],
      "00E0BA" => ["BerghofA", "BERGHOF AUTOMATIONSTECHNIK GmbH"],
      "00E0BB" => ["Nbx", "NBX CORPORATION"],
      "00E0BC" => ["SymonCom", "SYMON COMMUNICATIONS, INC."],
      "00E0BD" => ["Interfac", "INTERFACE SYSTEMS, INC."],
      "00E0BE" => ["GenrocoI", "GENROCO INTERNATIONAL, INC."],
      "00E0BF" => ["TorrentN", "TORRENT NETWORKING TECHNOLOGIES CORP."],
      "00E0C0" => ["SeiwaEle", "SEIWA ELECTRIC MFG. CO., LTD."],
      "00E0C1" => ["MemorexT", "MEMOREX TELEX JAPAN, LTD."],
      "00E0C2" => ["NecsySPA", "NECSY S.p.A."],
      "00E0C3" => ["SakaiSys", "SAKAI SYSTEM DEVELOPMENT CORP."],
      "00E0C4" => ["HornerEl", "HORNER ELECTRIC, INC."],
      "00E0C5" => ["BcomElec", "BCOM ELECTRONICS INC."],
      "00E0C6" => ["Link2itL", "LINK2IT, L.L.C."],
      "00E0C7" => ["Eurotech", "EUROTECH SRL"],
      "00E0C8" => ["VirtualA", "VIRTUAL ACCESS, LTD."],
      "00E0C9" => ["Automate", "AutomatedLogic Corporation"],
      "00E0CA" => ["BestData", "BEST DATA PRODUCTS"],
      "00E0CB" => ["Reson", "RESON, INC."],
      "00E0CC" => ["Hero", "HERO SYSTEMS, LTD."],
      "00E0CD" => ["Sensis", "SENSIS CORPORATION"],
      "00E0CE" => ["Arn",""],
      "00E0CF" => ["Integrat", "INTEGRATED DEVICE TECHNOLOGY, INC."],
      "00E0D0" => ["Netspeed", "NETSPEED, INC."],
      "00E0D1" => ["Telsis", "TELSIS LIMITED"],
      "00E0D2" => ["Versanet", "VERSANET COMMUNICATIONS, INC."],
      "00E0D3" => ["Datentec", "DATENTECHNIK GmbH"],
      "00E0D4" => ["Excellen", "EXCELLENT COMPUTER"],
      "00E0D5" => ["Emulex", "Emulex Corporation"],
      "00E0D6" => ["Computer", "COMPUTER & COMMUNICATION RESEARCH LAB."],
      "00E0D7" => ["Sunshine", "SUNSHINE ELECTRONICS, INC."],
      "00E0D8" => ["LanbitCo", "LANBit Computer, Inc."],
      "00E0D9" => ["Tazmo", "TAZMO CO., LTD."],
      "00E0DA" => ["AlcatelN", "Alcatel North America ESD"],
      "00E0DB" => ["Viavideo", "ViaVideo Communications, Inc."],
      "00E0DC" => ["Nexware", "NEXWARE CORP."],
      "00E0DD" => ["ZenithEl", "ZENITH ELECTRONICS CORPORATION"],
      "00E0DE" => ["DataxNv", "DATAX NV"],
      "00E0DF" => ["Keymile", "KEYMILE GmbH"],
      "00E0E0" => ["SiElectr", "SI ELECTRONICS, LTD."],
      "00E0E1" => ["G2Networ", "G2 NETWORKS, INC."],
      "00E0E2" => ["Innova", "INNOVA CORP."],
      "00E0E3" => ["Sk-Elekt", "SK-ELEKTRONIK GmbH"],
      "00E0E4" => ["FanucRob", "FANUC ROBOTICS NORTH AMERICA, Inc."],
      "00E0E5" => ["CincoNet", "CINCO NETWORKS, INC."],
      "00E0E6" => ["IncaaDat", "INCAA DATACOM B.V."],
      "00E0E7" => ["Raytheon", "RAYTHEON E-SYSTEMS, INC."],
      "00E0E8" => ["Gretacod", "GRETACODER Data Systems AG"],
      "00E0E9" => ["DataLabs", "DATA LABS, INC."],
      "00E0EA" => ["InnovatC", "INNOVAT COMMUNICATIONS, INC."],
      "00E0EB" => ["Digicom", "DIGICOM SYSTEMS, INCORPORATED"],
      "00E0EC" => ["Celestic", "CELESTICA INC."],
      "00E0ED" => ["Silicom", "SILICOM, LTD."],
      "00E0EE" => ["MarelHf", "MAREL HF"],
      "00E0EF" => ["Dionex",""],
      "00E0F0" => ["AblerTec", "ABLER TECHNOLOGY, INC."],
      "00E0F1" => ["That", "THAT CORPORATION"],
      "00E0F2" => ["ArlottoC", "ARLOTTO COMNET, INC."],
      "00E0F3" => ["Websprin", "WebSprint Communications, Inc."],
      "00E0F4" => ["InsideTe", "INSIDE Technology A/S"],
      "00E0F5" => ["Teles", "TELES AG"],
      "00E0F6" => ["Decision", "DECISION EUROPE"],
      "00E0F7" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E0F8" => ["DicnaCon", "DICNA CONTROL AB"],
      "00E0F9" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E0FA" => ["TrlTechn", "TRL TECHNOLOGY, LTD."],
      "00E0FB" => ["Leightro", "LEIGHTRONIX, INC."],
      "00E0FC" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO., LTD."],
      "00E0FD" => ["A-TrendT", "A-TREND TECHNOLOGY CO., LTD."],
      "00E0FE" => ["Cisco", "CISCO SYSTEMS, INC."],
      "00E0FF" => ["Security", "SECURITY DYNAMICS TECHNOLOGIES, Inc."],
      "00E175" => ["Ak-Syste", "AK-Systems Ltd"],
      "00E6D3" => ["NixdorfC", "NIXDORF COMPUTER CORP."],
      "00E8AB" => ["MeggittT", "Meggitt Training Systems, Inc."],
      "00F051" => ["Kwb", "KWB Gmbh"],
      "00F403" => ["OrbisOy", "Orbis Systems Oy"],
      "00F4B9" => ["Apple", "Apple, Inc."],
      "00F860" => ["PtPanggu", "PT. Panggung Electric Citrabuana"],
      "00FA3B" => ["CloosEle", "CLOOS ELECTRONIC GMBH"],
      "00FC58" => ["Websilic", "WebSilicon Ltd."],
      "00FC70" => ["Intrepid", "Intrepid Control Systems, Inc."],
      "00FD4C" => ["Nevatec",""],
      "010ECF" => ["PN-MC		", "PROFINET Multicast"],
      "020406" => ["BbnInter", "BBN				internal usage (not registered)"],
      "020701" => ["Racal-Da", "RACAL-DATACOM"],
      "021C7C" => ["Perq", "PERQ SYSTEMS CORPORATION"],
      "022048" => ["Marconi		", "At least some 2810 send with locally assigned flag set"],
      "026060" => ["3com",""],
      "026086" => ["LogicRep", "LOGIC REPLACEMENT TECH. LTD."],
      "02608C" => ["3com", "3COM CORPORATION"],
      "027001" => ["Racal-Da", "RACAL-DATACOM"],
      "0270B0" => ["M/A-ComC", "M/A-COM INC. COMPANIES"],
      "0270B3" => ["DataReca", "DATA RECALL LTD"],
      "029D8E" => ["CardiacR", "CARDIAC RECORDERS INC."],
      "02A0C9" => ["Intel",""],
      "02AA3C" => ["Olivetti", "OLIVETTI TELECOMM SPA (OLTECO)"],
      "02BB01" => ["Octothor", "OCTOTHORPE CORP."],
      "02C08C" => ["3com", "3COM CORPORATION"],
      "02CF1C" => ["Communic", "COMMUNICATION MACHINERY CORP."],
      "02CF1F" => ["CMC",""],
      "02E03B" => ["Prominet", "Prominet Corporation		Gigabit Ethernet Switch"],
      "02E6D3" => ["NixdorfC", "NIXDORF COMPUTER CORPORATION"],
      "040A83" => ["Alcatel-", "Alcatel-Lucent"],
      "040AE0" => ["XmitComp", "XMIT AG COMPUTER NETWORKS"],
      "040CCE" => ["Apple", "Apple, Inc."],
      "040EC2" => ["Viewsoni", "ViewSonic Mobile China Limited"],
      "04180F" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "0418B6" => ["Private",""],
      "0418D6" => ["Ubiquiti", "Ubiquiti Networks"],
      "041D10" => ["DreamWar", "Dream Ware Inc."],
      "041E64" => ["Apple", "Apple, Inc"],
      "04209A" => ["Panasoni", "Panasonic AVC Networks Company"],
      "042234" => ["Wireless", "Wireless Standard Extensions"],
      "042605" => ["GfrGesel", "GFR Gesellschaft f r Regelungstechnik und Energieeinsparung mbH"],
      "042BBB" => ["Picocela", "PicoCELA, Inc."],
      "042F56" => ["AtocsShe", "ATOCS (Shenzhen) LTD"],
      "0432F4" => ["Partron",""],
      "043604" => ["Gyeyoung", "Gyeyoung I&T"],
      "044665" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "044A50" => ["RamaxelT", "Ramaxel Technology (Shenzhen) limited company"],
      "044FAA" => ["RuckusWi", "Ruckus Wireless"],
      "045453" => ["Apple", "Apple, Inc."],
      "0455CA" => ["BriviewX", "BriView (Xiamen) Corp."],
      "045A95" => ["Nokia", "Nokia Corporation"],
      "045C06" => ["ZmodoTec", "Zmodo Technology Corporation"],
      "045D56" => ["CamtronI", "camtron industrial inc."],
      "0462D7" => ["AlstomHy", "ALSTOM HYDRO FRANCE"],
      "0463E0" => ["NomeOy", "Nome Oy"],
      "046D42" => ["Bryston", "Bryston Ltd."],
      "0470BC" => ["Globalst", "Globalstar Inc."],
      "0474A1" => ["AligeraE", "Aligera Equipamentos Digitais Ltda"],
      "0475F5" => ["Csst",""],
      "04766E" => ["Alps", "ALPS Co,. Ltd."],
      "047D7B" => ["QuantaCo", "Quanta Computer Inc."],
      "0481AE" => ["Clack", "Clack Corporation"],
      "048845" => ["BayNetwo", "Bay Networks			token ring line card"],
      "04888C" => ["Eifelwer", "Eifelwerk Butler Systeme GmbH"],
      "048A15" => ["Avaya", "Avaya, Inc"],
      "048B42" => ["Skspruce", "Skspruce Technology Limited"],
      "0494A1" => ["CatchWin", "CATCH THE WIND INC"],
      "0498F3" => ["AlpsElec", "ALPS Electric Co,. Ltd."],
      "049C62" => ["BmtMedic", "BMT Medical Technology s.r.o."],
      "049F81" => ["SimenaLl", "Simena, LLC"],
      "04A3F3" => ["Emicon",""],
      "04A82A" => ["Nokia", "Nokia Corporation"],
      "04B3B6" => ["SeamapUk", "Seamap (UK) Ltd"],
      "04B466" => ["Bsp", "BSP Co., Ltd."],
      "04C05B" => ["TigoEner", "Tigo Energy"],
      "04C06F" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "04C1B9" => ["Fiberhom", "Fiberhome Telecommunication Tech.Co.,Ltd."],
      "04C5A4" => ["Cisco", "Cisco Systems"],
      "04C880" => ["Samtec", "Samtec Inc"],
      "04CE14" => ["Wilocity", "Wilocity LTD."],
      "04D783" => ["Y&HE&C", "Y&H E&C Co.,LTD."],
      "04DD4C" => ["Ipblaze",""],
      "04E0C4" => ["Triumph-", "TRIUMPH-ADLER AG"],
      "04E1C8" => ["ImsSolu ", "IMS Solu  es em Energia Ltda."],
      "04E2F8" => ["AepSrl", "AEP srl"],
      "04E451" => ["TexasIns", "Texas Instruments"],
      "04E548" => ["CohdaWir", "Cohda Wireless Pty Ltd"],
      "04E662" => ["Acroname", "Acroname Inc."],
      "04EE91" => ["X-Fabric", "x-fabric GmbH"],
      "04F021" => ["CompexPt", "Compex Systems Pte Ltd"],
      "04F17D" => ["TaranaWi", "Tarana Wireless"],
      "04F4BC" => ["XenaNetw", "Xena Networks"],
      "04FE7F" => ["Cisco", "Cisco Systems"],
      "04FF51" => ["Novamedi", "NOVAMEDIA INNOVISION SP. Z O.O."],
      "080001" => ["Computer", "COMPUTERVISION CORPORATION"],
      "080002" => ["3Com",""],
      "080003" => ["ACC",""],
      "080004" => ["Cromemco", "CROMEMCO INCORPORATED"],
      "080005" => ["Symbolic", "SYMBOLICS INC."],
      "080006" => ["Siemens", "SIEMENS AG"],
      "080007" => ["AppleCom", "APPLE COMPUTER INC."],
      "080008" => ["BBN",""],
      "080009" => ["HP",""],
      "08000A" => ["Nestar", "NESTAR SYSTEMS INCORPORATED"],
      "08000B" => ["Unisys", "UNISYS CORPORATION"],
      "08000C" => ["MiklynDe", "MIKLYN DEVELOPMENT CO."],
      "08000D" => ["Internat", "INTERNATIONAL COMPUTERS LTD."],
      "08000E" => ["Ncr", "NCR CORPORATION"],
      "08000F" => ["Mitel", "MITEL CORPORATION"],
      "080010" => ["At&T[Mis", "AT&T [misrepresentation of 800010?],"],
      "080011" => ["Tektroni", "TEKTRONIX INC."],
      "080012" => ["BellAtla", "BELL ATLANTIC INTEGRATED SYST."],
      "080013" => ["Exxon",""],
      "080014" => ["Excelan",""],
      "080015" => ["StcBusin", "STC BUSINESS SYSTEMS"],
      "080016" => ["Barriste", "BARRISTER INFO SYS CORP"],
      "080017" => ["National", "NATIONAL SEMICONDUCTOR"],
      "080018" => ["PirelliF", "PIRELLI FOCOM NETWORKS"],
      "080019" => ["GeneralE", "GENERAL ELECTRIC CORPORATION"],
      "08001A" => ["DataGenl	", "Data General"],
      "08001B" => ["Emc", "EMC Corporation"],
      "08001C" => ["Kdd-Koku", "KDD-KOKUSAI DEBNSIN DENWA CO."],
      "08001D" => ["AbleComm", "ABLE COMMUNICATIONS INC."],
      "08001E" => ["ApolloCo", "APOLLO COMPUTER INC."],
      "08001F" => ["Sharp", "SHARP CORPORATION"],
      "080020" => ["Oracle", "Oracle Corporation"],
      "080021" => ["3m", "3M COMPANY"],
      "080022" => ["Nbi", "NBI INC."],
      "080023" => ["Panasoni", "Panasonic Communications Co., Ltd."],
      "080024" => ["10netCom", "10NET COMMUNICATIONS/DCA"],
      "080025" => ["ControlD", "CONTROL DATA"],
      "080026" => ["NorskDat", "NORSK DATA A.S."],
      "080027" => ["CadmusCo", "CADMUS COMPUTER SYSTEMS"],
      "080028" => ["TexasIns", "Texas Instruments"],
      "080029" => ["Megatek", "MEGATEK CORPORATION"],
      "08002A" => ["MosaicTe", "MOSAIC TECHNOLOGIES INC."],
      "08002B" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "08002C" => ["BrittonL", "BRITTON LEE INC."],
      "08002D" => ["Lan-Tec", "LAN-TEC INC."],
      "08002E" => ["Metaphor", "METAPHOR COMPUTER SYSTEMS"],
      "08002F" => ["PrimeCom", "PRIME COMPUTER INC."],
      "080030" => ["NetworkR", "NETWORK RESEARCH CORPORATION"],
      "080031" => ["LittleMa", "LITTLE MACHINES INC."],
      "080032" => ["Tigan", "TIGAN INCORPORATED"],
      "080033" => ["BauschLo", "BAUSCH & LOMB"],
      "080034" => ["Filenet", "FILENET CORPORATION"],
      "080035" => ["Microfiv", "MICROFIVE CORPORATION"],
      "080036" => ["Intergra", "INTERGRAPH CORPORATION"],
      "080037" => ["Fuji-Xer", "FUJI-XEROX CO. LTD."],
      "080038" => ["Bull",""],
      "080039" => ["Spider", "SPIDER SYSTEMS LIMITED"],
      "08003A" => ["Orcatech", "ORCATECH INC."],
      "08003B" => ["Torus", "TORUS SYSTEMS LIMITED"],
      "08003C" => ["Schlumbe", "SCHLUMBERGER WELL SERVICES"],
      "08003D" => ["Cadnetix", "CADNETIX CORPORATIONS"],
      "08003E" => ["Motorola",""],
      "08003F" => ["FredKosc", "FRED KOSCHARA ENTERPRISES"],
      "080040" => ["Ferranti", "FERRANTI COMPUTER SYS. LIMITED"],
      "080041" => ["Racal-Mi", "RACAL-MILGO INFORMATION SYS.."],
      "080042" => ["JapanMac", "JAPAN MACNICS CORP."],
      "080043" => ["PixelCom", "PIXEL COMPUTER INC."],
      "080044" => ["David", "DAVID SYSTEMS INC."],
      "080045" => ["Concurre", "CONCURRENT COMPUTER CORP."],
      "080046" => ["Sony", "Sony Corporation"],
      "080047" => ["SequentC", "SEQUENT COMPUTER SYSTEMS INC."],
      "080048" => ["Eurother", "EUROTHERM GAUGING SYSTEMS"],
      "080049" => ["Univatio", "UNIVATION"],
      "08004A" => ["Banyan", "BANYAN SYSTEMS INC."],
      "08004B" => ["Planning", "PLANNING RESEARCH CORP."],
      "08004C" => ["HydraCom", "HYDRA COMPUTER SYSTEMS INC."],
      "08004D" => ["Corvus", "CORVUS SYSTEMS INC."],
      "08004E" => ["3comEuro", "3COM EUROPE LTD."],
      "08004F" => ["Cygnet", "CYGNET SYSTEMS"],
      "080050" => ["Daisy", "DAISY SYSTEMS CORP."],
      "080051" => ["Experdat", "EXPERDATA"],
      "080052" => ["Insystec",""],
      "080053" => ["MiddleEa", "MIDDLE EAST TECH. UNIVERSITY"],
      "080055" => ["Stanford", "STANFORD TELECOMM. INC."],
      "080056" => ["Stanford", "STANFORD LINEAR ACCEL. CENTER"],
      "080057" => ["EvansSut", "EVANS & SUTHERLAND"],
      "080058" => ["Concepts", "SYSTEMS CONCEPTS"],
      "080059" => ["Mycron", "A/S MYCRON"],
      "08005A" => ["Ibm", "IBM Corp"],
      "08005B" => ["VtaTechn", "VTA TECHNOLOGIES INC."],
      "08005C" => ["FourPhas", "FOUR PHASE SYSTEMS"],
      "08005D" => ["Gould", "GOULD INC."],
      "08005E" => ["Counterp", "COUNTERPOINT COMPUTER INC."],
      "08005F" => ["SaberTec", "SABER TECHNOLOGY CORP."],
      "080060" => ["Industri", "INDUSTRIAL NETWORKING INC."],
      "080061" => ["Jarogate", "JAROGATE LTD."],
      "080062" => ["GeneralD", "GENERAL DYNAMICS"],
      "080063" => ["Plessey",""],
      "080064" => ["Autophon", "AUTOPHON AG"],
      "080065" => ["Genrad", "GENRAD INC."],
      "080066" => ["Agfa", "AGFA CORPORATION"],
      "080067" => ["Comdesig", "COMDESIGN"],
      "080068" => ["RidgeCom", "RIDGE COMPUTERS"],
      "080069" => ["SGI",""],
      "08006A" => ["AttBellL", "ATT BELL LABORATORIES"],
      "08006B" => ["AccelTec", "ACCEL TECHNOLOGIES INC."],
      "08006C" => ["SuntekTe", "SUNTEK TECHNOLOGY INT\'L"],
      "08006D" => ["Whitecha", "WHITECHAPEL COMPUTER WORKS"],
      "08006E" => ["Masscomp",""],
      "08006F" => ["PhilipsA", "PHILIPS APELDOORN B.V."],
      "080070" => ["Mitsubis", "MITSUBISHI ELECTRIC CORP."],
      "080071" => ["MatraDsi", "MATRA (DSIE)"],
      "080072" => ["XeroxUni", "XEROX CORP UNIV GRANT PROGRAM"],
      "080073" => ["Tecmar", "TECMAR INC."],
      "080074" => ["CasioCom", "CASIO COMPUTER CO. LTD."],
      "080075" => ["DanskDat", "DANSK DATA ELECTRONIK"],
      "080076" => ["PcLanTec", "PC LAN TECHNOLOGIES"],
      "080077" => ["TslCommu", "TSL COMMUNICATIONS LTD."],
      "080078" => ["Accell", "ACCELL CORPORATION"],
      "080079" => ["SGI",""],
      "08007A" => ["Indata",""],
      "08007B" => ["SanyoEle", "SANYO ELECTRIC CO. LTD."],
      "08007C" => ["Vitalink", "VITALINK COMMUNICATIONS CORP."],
      "08007E" => ["Amalgama", "AMALGAMATED WIRELESS(AUS) LTD"],
      "08007F" => ["Carnegie", "CARNEGIE-MELLON UNIVERSITY"],
      "080080" => ["AesData", "AES DATA INC."],
      "080081" => ["Astech", ",ASTECH INC."],
      "080082" => ["VeritasS", "VERITAS SOFTWARE"],
      "080083" => ["SeikoIns", "Seiko Instruments Inc."],
      "080084" => ["TomenEle", "TOMEN ELECTRONICS CORP."],
      "080085" => ["Elxsi",""],
      "080086" => ["KonicaMi", "KONICA MINOLTA HOLDINGS, INC."],
      "080087" => ["Xyplex",""],
      "080088" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "080089" => ["Kinetics",""],
      "08008A" => ["Perftech", "PerfTech, Inc."],
      "08008B" => ["PyramidT", "PYRAMID TECHNOLOGY CORP."],
      "08008C" => ["NetworkR", "NETWORK RESEARCH CORPORATION"],
      "08008D" => ["Xyvision", "XYVISION INC."],
      "08008E" => ["TandemCo", "TANDEM COMPUTERS"],
      "08008F" => ["Chipcom", "CHIPCOM CORPORATION"],
      "080090" => ["Retix",""],
      "0808EA" => ["Amsc",""],
      "080CC9" => ["MissionT", "Mission Technology Group, dba Magma"],
      "080D84" => ["Geco", "GECO, Inc."],
      "081196" => ["IntelCor", "Intel Corporate"],
      "081443" => ["Unibrain", "UNIBRAIN S.A."],
      "081651" => ["Shenzhen", "Shenzhen Sea Star Technology Co.,Ltd"],
      "081735" => ["Cisco", "Cisco Systems"],
      "0817F4" => ["Ibm", "IBM Corp"],
      "08181A" => ["Zte", "zte corporation"],
      "08184C" => ["ASThomas", "A. S. Thomas, Inc."],
      "0819A6" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "081FF3" => ["Cisco", "Cisco Systems"],
      "082522" => ["Advansee",""],
      "082AD0" => ["SrdInnov", "SRD Innovations Inc."],
      "082E5F" => ["HewlettP", "Hewlett Packard"],
      "08379C" => ["Topaz", "Topaz Co. LTD."],
      "0838A5" => ["Funkwerk", "Funkwerk plettac electronic GmbH"],
      "083E8E" => ["HonHaiPr", "Hon Hai Precision Ind.Co.Ltd"],
      "084E1C" => ["H2aLlc", "H2A Systems, LLC"],
      "084EBF" => ["BroadNet", "Broad Net Mux Corporation"],
      "08512E" => ["OrionDia", "Orion Diagnostica Oy"],
      "085B0E" => ["Fortinet", "Fortinet, Inc."],
      "087572" => ["ObeluxOy", "Obelux Oy"],
      "087618" => ["VieTechn", "ViE Technologies Sdn. Bhd."],
      "087695" => ["AutoIndu", "Auto Industrial Co., Ltd."],
      "0876FF" => ["ThomsonT", "Thomson Telecom Belgium"],
      "087D21" => ["AltasecT", "Altasec technology corporation"],
      "08863B" => ["BelkinIn", "Belkin International, Inc."],
      "088DC8" => ["RyowaEle", "Ryowa Electronics Co.,Ltd"],
      "088F2C" => ["HillsSou", "Hills Sound Vision & Lighting"],
      "089E01" => ["QuantaCo", "QUANTA COMPUTER INC."],
      "089F97" => ["LeroyAut", "LEROY AUTOMATION"],
      "08A12B" => ["Shenzhen", "ShenZhen EZL Technology Co., Ltd"],
      "08A95A" => ["Azurewav", "Azurewave"],
      "08ACA5" => ["BenuVide", "Benu Video, Inc."],
      "08B4CF" => ["AbicomIn", "Abicom International"],
      "08B7EC" => ["Wireless", "Wireless Seismic"],
      "08BBCC" => ["Ak-NordE", "AK-NORD EDV VERTRIEBSGES. mbH"],
      "08BE09" => ["AstrolEl", "Astrol Electronic AG"],
      "08D09F" => ["Cisco", "Cisco Systems"],
      "08D29A" => ["Proforma", "Proformatique"],
      "08D40C" => ["IntelCor", "Intel Corporate"],
      "08D5C0" => ["SeersTec", "Seers Technology Co., Ltd"],
      "08E672" => ["JebseeEl", "JEBSEE ELECTRONICS CO.,LTD."],
      "08EA44" => ["Aerohive", "Aerohive Networks, Inc."],
      "08EDB9" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "08F2F4" => ["NetOnePa", "Net One Partners Co.,Ltd."],
      "08F6F8" => ["GetEngin", "GET Engineering"],
      "08FAE0" => ["FohhnAud", "Fohhn Audio AG"],
      "08FC52" => ["OpenxsBv", "OpenXS BV"],
      "09006A" => ["AT&T",""],
      "0C130B" => ["Uniqoteq", "Uniqoteq Ltd."],
      "0C15C5" => ["Sdtec", "SDTEC Co., Ltd."],
      "0C17F1" => ["Telecsys",""],
      "0C1DC2" => ["SeahNetw", "SeAH Networks"],
      "0C2755" => ["Valuable", "Valuable Techologies Limited"],
      "0C2A69" => ["Electric", "electric imp, incorporated"],
      "0C37DC" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "0C3956" => ["Observat", "Observator instruments"],
      "0C3C65" => ["DomeImag", "Dome Imaging Inc"],
      "0C469D" => ["MsSedco", "MS Sedco"],
      "0C4C39" => ["Mitrasta", "Mitrastar Technology"],
      "0C51F7" => ["ChauvinA", "CHAUVIN ARNOUX"],
      "0C565C" => ["HybroadV", "HyBroad Vision (Hong Kong) Technology Co Ltd"],
      "0C57EB" => ["Mueller", "Mueller Systems"],
      "0C5A19" => ["AxtionSd", "Axtion Sdn Bhd"],
      "0C6076" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "0C6E4F" => ["Primevol", "PrimeVOLT Co., Ltd."],
      "0C715D" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "0C74C2" => ["Apple", "Apple, Inc."],
      "0C7523" => ["BeijingG", "BEIJING GEHUA CATV NETWORK CO.,LTD"],
      "0C771A" => ["Apple", "Apple, Inc."],
      "0C7D7C" => ["KexiangI", "Kexiang Information Technology Co, Ltd."],
      "0C8112" => ["Private",""],
      "0C8230" => ["Shenzhen", "SHENZHEN MAGNUS TECHNOLOGIES CO.,LTD"],
      "0C826A" => ["WuhanHua", "Wuhan Huagong Genuine Optics Technology Co., Ltd"],
      "0C8411" => ["AOSmithW", "A.O. Smith Water Products"],
      "0C8525" => ["Cisco", "Cisco Systems"],
      "0C8BFD" => ["IntelCor", "Intel Corporate"],
      "0C8D98" => ["TopEight", "TOP EIGHT IND CORP"],
      "0C924E" => ["RiceLake", "Rice Lake Weighing Systems"],
      "0C9D56" => ["ConsortC", "Consort Controls Ltd"],
      "0C9E91" => ["Sankosha", "Sankosha Corporation"],
      "0CA138" => ["BlinqWir", "Blinq Wireless Inc."],
      "0CA2F4" => ["Chameleo", "Chameleon Technology (UK) Limited"],
      "0CA402" => ["AlcatelL", "Alcatel Lucent IPD"],
      "0CA42A" => ["ObTeleco", "OB Telecom Electronic Technology Co., Ltd"],
      "0CAF5A" => ["GenusPow", "GENUS POWER INFRASTRUCTURES LIMITED"],
      "0CB4EF" => ["Digience", "Digience Co.,Ltd."],
      "0CBF15" => ["Genetec",""],
      "0CC0C0" => ["MagnetiM", "MAGNETI MARELLI SISTEMAS ELECTRONICOS MEXICO"],
      "0CC3A7" => ["Meritec",""],
      "0CC6AC" => ["Dags",""],
      "0CC9C6" => ["SamwinHo", "Samwin Hong Kong Limited"],
      "0CCDD3" => ["Eastrive", "EASTRIVER TECHNOLOGY CO., LTD."],
      "0CD292" => ["IntelCor", "Intel Corporate"],
      "0CD2B5" => ["Binatone", "Binatone Telecommunication Pvt. Ltd"],
      "0CD502" => ["Westell",""],
      "0CD696" => ["Amimon", "Amimon Ltd"],
      "0CD7C2" => ["AxiumTec", "Axium Technologies, Inc."],
      "0CD996" => ["Cisco", "Cisco Systems"],
      "0CD9C1" => ["JohnsonC", "Johnson Controls-ASG"],
      "0CDCCC" => ["InalaTec", "Inala Technologies"],
      "0CDDEF" => ["Nokia", "Nokia Corporation"],
      "0CDFA4" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "0CE5D3" => ["DhElectr", "DH electronics GmbH"],
      "0CE709" => ["FoxCrypt", "Fox Crypto B.V."],
      "0CE82F" => ["Bonfigli", "Bonfiglioli Vectron GmbH"],
      "0CE936" => ["ElimosSr", "ELIMOS srl"],
      "0CEEE6" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "0CEF7C" => ["Anacom", "AnaCom Inc"],
      "0CF0B4" => ["Globalsa", "Globalsat International Technology Ltd"],
      "0CF3EE" => ["EmMicroe", "EM Microelectronic"],
      "0CFC83" => ["AirohaTe", "Airoha Technology Corp.,"],
      "100000" => ["Private",""],
      "10005A" => ["Ibm", "IBM Corp"],
      "100090" => ["HP",""],
      "1000D4" => ["DEC",""],
      "1000E0" => ["AppleA/U", "Apple A/UX			(modified addresses for licensing)"],
      "1000E8" => ["National", "NATIONAL SEMICONDUCTOR"],
      "1000FD" => ["Laonpeop", "LaonPeople"],
      "10090C" => ["JanomeSe", "Janome Sewing Machine Co., Ltd."],
      "100BA9" => ["IntelCor", "Intel Corporate"],
      "100C24" => ["Pomdevic", "pomdevices, LLC"],
      "100D2F" => ["OnlineSe", "Online Security Pty. Ltd."],
      "100D32" => ["Embedian", "Embedian, Inc."],
      "100E2B" => ["NecCasio", "NEC CASIO Mobile Communications"],
      "1010B6" => ["Mccain", "McCain Inc"],
      "101212" => ["VivoInte", "Vivo International Corporation Pty Ltd"],
      "1013EE" => ["JustecIn", "Justec International Technology INC."],
      "10189E" => ["ElmoMoti", "Elmo Motion Control"],
      "101B54" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "101DC0" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "101F74" => ["Hewlett-", "Hewlett-Packard Company"],
      "102D96" => ["Looxcie", "Looxcie Inc."],
      "102EAF" => ["TexasIns", "Texas Instruments"],
      "103711" => ["SimlinkA", "Simlink AS"],
      "1040F3" => ["Apple", "Apple, Inc."],
      "104369" => ["Soundmax", "Soundmax Electronic Limited"],
      "10445A" => ["ShaanxiH", "Shaanxi Hitech Electronic Co., LTD"],
      "1045BE" => ["Norphoni", "Norphonic AS"],
      "1045F8" => ["Lnt-Auto", "LNT-Automation GmbH"],
      "104780" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "1056CA" => ["PeplinkI", "Peplink International Ltd."],
      "105F49" => ["CiscoSpv", "Cisco SPVTG"],
      "1062C9" => ["Adatis", "Adatis GmbH & Co. KG"],
      "1064E2" => ["AdfwebCo", "ADFweb.com s.r.l."],
      "1065A3" => ["Panamax", "Panamax Inc."],
      "106F3F" => ["Buffalo", "Buffalo Inc."],
      "1071F9" => ["CloudTel", "Cloud Telecomputers, LLC"],
      "10768A" => ["Eocell",""],
      "1078D2" => ["Elitegro", "ELITEGROUP COMPUTER SYSTEM CO., LTD."],
      "1083D2" => ["Microsev", "Microseven Systems, LLC"],
      "10880F" => ["DarumaTe", "DARUMA TELECOMUNICAA A.ES E INFORMA TICA S/A"],
      "108CCF" => ["Cisco", "Cisco Systems"],
      "1093E9" => ["Apple", "Apple, Inc."],
      "109ADD" => ["Apple", "Apple, Inc."],
      "109FA9" => ["Actionte", "Actiontec Electronics, Inc"],
      "10A13B" => ["Fujikura", "FUJIKURA RUBBER LTD."],
      "10A932" => ["BeijingC", "Beijing Cyber Cloud Technology Co. ,Ltd."],
      "10B7F6" => ["Plastofo", "Plastoform Industries Ltd."],
      "10BAA5" => ["GanaI&C", "GANA I&C CO., LTD"],
      "10BD18" => ["Cisco", "Cisco Systems"],
      "10BF48" => ["AsustekC", "ASUSTEK COMPUTER INC."],
      "10C2BA" => ["Utt", "UTT Co., Ltd."],
      "10C586" => ["BioSound", "BIO SOUND LAB CO., LTD."],
      "10C61F" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "10C6FC" => ["GarminIn", "Garmin International"],
      "10C73F" => ["MidasKla", "Midas Klark Teknik Ltd"],
      "10CA81" => ["Precia",""],
      "10CCDB" => ["AximumPr", "AXIMUM PRODUITS ELECTRONIQUES"],
      "10D1DC" => ["InstarDe", "INSTAR Deutschland GmbH"],
      "10E2D5" => ["QiHardwa", "Qi Hardware Inc."],
      "10E3C7" => ["SeohwaTe", "Seohwa Telecom"],
      "10E4AF" => ["AprLlc", "APR, LLC"],
      "10E6AE" => ["SourceTe", "Source Technologies, LLC"],
      "10E8EE" => ["Phasespa", "PhaseSpace"],
      "10EED9" => ["CanogaPe", "Canoga Perkins Corporation"],
      "10F96F" => ["LgElectr", "LG Electronics"],
      "10F9EE" => ["Nokia", "Nokia Corporation"],
      "10FC54" => ["ShanyEle", "Shany Electronic Co., Ltd."],
      "1100AA" => ["Private",""],
      "140708" => ["Private",""],
      "1407E0" => ["Abrantix", "Abrantix AG"],
      "14144B" => ["FujianSt", "FUJIAN STAR-NET COMMUNICATION CO.,LTD"],
      "141A51" => ["Treetech", "Treetech Sistemas Digitais"],
      "141BBD" => ["Volex", "Volex Inc."],
      "142DF5" => ["Amphitec", "Amphitech"],
      "14307A" => ["Avermetr", "Avermetrics"],
      "14358B" => ["Mediabri", "Mediabridge Products, LLC."],
      "1435B3" => ["FutureDe", "Future Designs, Inc."],
      "143605" => ["Nokia", "Nokia Corporation"],
      "14373B" => ["Procom", "PROCOM Systems"],
      "143AEA" => ["Dynapowe", "Dynapower Company LLC"],
      "143E60" => ["Alcatel-", "Alcatel-Lucent"],
      "144319" => ["Creative", "Creative&Link Technology Limited"],
      "144978" => ["DigitalC", "Digital Control Incorporated"],
      "144C1A" => ["MaxCommu", "Max Communication GmbH"],
      "145412" => ["Entis", "Entis Co., Ltd."],
      "145A05" => ["Apple", "Apple, Inc."],
      "146308" => ["JabilCir", "JABIL CIRCUIT (SHANGHAI) LTD."],
      "146A0B" => ["CypressE", "Cypress Electronics Limited"],
      "146E0A" => ["Private",""],
      "147373" => ["TubitakU", "TUBITAK UEKAE"],
      "147411" => ["Rim",""],
      "147DB3" => ["JoaTelec", "JOA TELECOM.CO.,LTD"],
      "147DC5" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "14825B" => ["HefeiRad", "Hefei Radio Communication Technology Co., Ltd"],
      "148A70" => ["Ads", "ADS GmbH"],
      "148FC6" => ["Apple", "Apple, Inc."],
      "149090" => ["KongtopI", "KongTop industrial(shen zhen)CO.,LTD"],
      "149FE8" => ["LenovoMo", "Lenovo Mobile Communication Technology Ltd."],
      "14A62C" => ["SMDezacS", "S.M. Dezac S.A."],
      "14A86B" => ["Shenzhen", "ShenZhen Telacom Science&Technology Co., Ltd"],
      "14A9E3" => ["Mst", "MST CORPORATION"],
      "14B1C8" => ["Infiniwi", "InfiniWing, Inc."],
      "14B73D" => ["ArcheanT", "ARCHEAN Technologies"],
      "14C21D" => ["SabtechI", "Sabtech Industries"],
      "14CF8D" => ["OhsungEl", "OHSUNG ELECTRONICS CO., LTD."],
      "14D4FE" => ["Pace", "Pace plc"],
      "14D64D" => ["D-LinkIn", "D-Link International"],
      "14D76E" => ["ConchEle", "CONCH ELECTRONIC Co.,Ltd"],
      "14DAE9" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "14E4EC" => ["MlogicLl", "mLogic LLC"],
      "14E6E4" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "14EB33" => ["Bsmedias", "BSMediasoft Co., Ltd."],
      "14EE9D" => ["AirnavLl", "AirNav Systems LLC"],
      "14F0C5" => ["Xtremio", "Xtremio Ltd."],
      "14FEAF" => ["Sagittar", "SAGITTAR LIMITED"],
      "14FEB5" => ["Dell", "Dell Inc"],
      "1801E3" => ["Elektrob", "Elektrobit Wireless Communications Ltd"],
      "180373" => ["Dell", "Dell Inc"],
      "1803FA" => ["IbtInter", "IBT Interfaces"],
      "180675" => ["DilaxInt", "DILAX Intelcom GmbH"],
      "180B52" => ["Nanotron", "Nanotron Technologies GmbH"],
      "180C77" => ["Westingh", "Westinghouse Electric Company, LLC"],
      "181420" => ["TebSas", "TEB SAS"],
      "181456" => ["Nokia", "Nokia Corporation"],
      "181714" => ["Daewoois",""],
      "18193F" => ["TamtronO", "Tamtron Oy"],
      "182032" => ["Apple", "Apple, Inc."],
      "182861" => ["AirtiesW", "AirTies Wireless Networks"],
      "182B05" => ["8dTechno", "8D Technologies"],
      "182C91" => ["ConceptD", "Concept Development, Inc."],
      "18339D" => ["Cisco", "Cisco Systems"],
      "183451" => ["Apple", "Apple, Inc."],
      "183825" => ["WuhanLin", "Wuhan Lingjiu High-tech Co.,Ltd."],
      "183919" => ["Unicoi", "Unicoi Systems"],
      "183BD2" => ["BydPreci", "BYD Precision Manufacture Company Ltd."],
      "183DA2" => ["IntelCor", "Intel Corporate"],
      "183F47" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "18421D" => ["Private",""],
      "18422F" => ["AlcatelL", "Alcatel Lucent"],
      "184617" => ["SamsungE", "Samsung Electronics"],
      "1848D8" => ["Fastback", "Fastback Networks"],
      "184E94" => ["MessoaTe", "MESSOA TECHNOLOGIES INC."],
      "185933" => ["CiscoSpv", "Cisco SPVTG"],
      "1866E3" => ["Veros", "Veros Systems, Inc."],
      "186751" => ["KomegInd", "KOMEG Industrielle Messtechnik GmbH"],
      "186D99" => ["Adanis", "Adanis Inc."],
      "187C81" => ["ValeoVis", "Valeo Vision Systems"],
      "1880CE" => ["Barberry", "Barberry Solutions Ltd"],
      "1880F5" => ["Alcatel-", "Alcatel-Lucent Shanghai Bell Co., Ltd"],
      "18863A" => ["DigitalA", "DIGITAL ART SYSTEM"],
      "1886AC" => ["NokiaDan", "Nokia Danmark A/S"],
      "188796" => ["Htc", "HTC Corporation"],
      "188ED5" => ["PhilipsI", "Philips Innovative Application NV"],
      "18922C" => ["VirtualI", "Virtual Instruments"],
      "1897FF" => ["Techfait", "TechFaith Wireless Technology Limited"],
      "189A67" => ["Cse-Serv", "CSE-Servelec Limited"],
      "189EFC" => ["Apple", "Apple Inc"],
      "18A905" => ["Hewlett-", "Hewlett-Packard Company"],
      "18ABF5" => ["UltraEle", "Ultra Electronics - Electrics"],
      "18AD4D" => ["Polostar", "Polostar Technology Corporation"],
      "18AEBB" => ["SiemensP", "Siemens Programm- und Systementwicklung GmbH&Co.KG"],
      "18AF9F" => ["Digitron", "DIGITRONIC Automationsanlagen GmbH"],
      "18B209" => ["TorreyPi", "Torrey Pines Logic, Inc"],
      "18B3BA" => ["Netlogic", "Netlogic AB"],
      "18B430" => ["NestLabs", "Nest Labs Inc."],
      "18B591" => ["I-Storm",""],
      "18B79E" => ["Invoxia",""],
      "18C086" => ["Broadcom", "Broadcom Corporation"],
      "18C451" => ["TucsonEm", "Tucson Embedded Systems"],
      "18D071" => ["DasanSmc", "DASAN SMC, Inc."],
      "18D66A" => ["Inmarsat",""],
      "18E288" => ["SttCondi", "STT Condigi"],
      "18E2C2" => ["SamsungE", "Samsung Electronics"],
      "18E7F4" => ["Apple", "Apple, Inc."],
      "18E80F" => ["VikingEl", "Viking Electronics Inc."],
      "18EF63" => ["Cisco", "Cisco Systems"],
      "18F46A" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "18F650" => ["Multimed", "Multimedia Pacific Limited"],
      "18F87A" => ["I3Intern", "i3 International Inc."],
      "18FC9F" => ["ChangheE", "Changhe Electronics Co., Ltd."],
      "1C0656" => ["Idy", "IDY Corporation"],
      "1C0B52" => ["EpicomSA", "EPICOM S.A"],
      "1C0FCF" => ["SyproOpt", "Sypro Optics GmbH"],
      "1C129D" => ["IeeePesP", "IEEE PES PSRC/SUB"],
      "1C1448" => ["Motorola", "Motorola Mobility, Inc."],
      "1C17D3" => ["Cisco", "Cisco Systems"],
      "1C184A" => ["Shenzhen", "ShenZhen RicherLink Technologies Co.,LTD"],
      "1C19DE" => ["Eyevis", "eyevis GmbH"],
      "1C1D67" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "1C334D" => ["ItsTelec", "ITS Telecom"],
      "1C3477" => ["Innovati", "Innovation Wireless"],
      "1C35F1" => ["NewLiftN", "NEW Lift Neue Elektronische Wege Steuerungsbau GmbH"],
      "1C3A4F" => ["Accuspec", "AccuSpec Electronics, LLC"],
      "1C3DE7" => ["SigmaKok", "Sigma Koki Co.,Ltd."],
      "1C43EC" => ["JapanCir", "JAPAN CIRCUIT CO.,LTD"],
      "1C4593" => ["TexasIns", "Texas Instruments"],
      "1C4BD6" => ["Azurewav", "AzureWave"],
      "1C51B5" => ["Techaya", "Techaya LTD"],
      "1C5C55" => ["PrimaCin", "PRIMA Cinema, Inc"],
      "1C5C60" => ["Shenzhen", "Shenzhen Belzon Technology Co.,LTD."],
      "1C5FFF" => ["BeijingE", "Beijing Ereneben Information Technology Co.,Ltd Shenzhen Branch"],
      "1C62B8" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "1C659D" => ["LiteonTe", "Liteon Technology Corporation"],
      "1C666D" => ["HonHaiPr", "Hon Hai Precision Ind.Co.Ltd"],
      "1C69A5" => ["Research", "Research In Motion"],
      "1C6BCA" => ["Mitsunam", "Mitsunami Co., Ltd."],
      "1C6F65" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "1C7508" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD."],
      "1C7C11" => ["Eid", "EID"],
      "1C7C45" => ["VitekInd", "Vitek Industrial Video Products, Inc."],
      "1C7EE5" => ["D-LinkIn", "D-Link International"],
      "1C83B0" => ["LinkedIp", "Linked IP GmbH"],
      "1C8464" => ["FormosaW", "FORMOSA WIRELESS COMMUNICATION CORP."],
      "1C8E8E" => ["DbCommun", "DB Communication & Systems Co., ltd."],
      "1C8F8A" => ["PhaseMot", "Phase Motion Control SpA"],
      "1C955D" => ["I-LaxEle", "I-LAX ELECTRONICS INC."],
      "1C973D" => ["PricomDe", "PRICOM Design"],
      "1CAA07" => ["Cisco", "Cisco Systems"],
      "1CABA7" => ["Apple", "Apple, Inc."],
      "1CAFF7" => ["D-LinkIn", "D-LINK INTERNATIONAL PTE LIMITED"],
      "1CB094" => ["Htc", "HTC Corporation"],
      "1CB17F" => ["NecAcces", "NEC AccessTechnica, Ltd."],
      "1CB243" => ["Tdc", "TDC A/S"],
      "1CBBA8" => ["Ojsc Ufi", "OJSC Ufimskiy Zavod Promsvyaz"],
      "1CBD0E" => ["Amplifie", "Amplified Engineering Pty Ltd"],
      "1CBDB9" => ["D-LinkIn", "D-LINK INTERNATIONAL PTE LIMITED"],
      "1CC1DE" => ["Hewlett-", "Hewlett-Packard Company"],
      "1CC63C" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "1CD40C" => ["KriwanIn", "Kriwan Industrie-Elektronik GmbH"],
      "1CDF0F" => ["Cisco", "Cisco Systems"],
      "1CE165" => ["Marshal", "Marshal Corporation"],
      "1CE192" => ["Qisda", "Qisda Corporation"],
      "1CE2CC" => ["TexasIns", "Texas Instruments"],
      "1CF061" => ["Scaps", "SCAPS GmbH"],
      "1CF4CA" => ["Aviwest",""],
      "1CF5E7" => ["TurtleIn", "Turtle Industry Co., Ltd."],
      "1CFEA7" => ["Identyte", "IDentytech Solutins Ltd."],
      "20014F" => ["LineaRes", "Linea Research Ltd"],
      "2002AF" => ["MurataMa", "Murata Manufactuaring Co.,Ltd."],
      "200505" => ["RadmaxCo", "RADMAX COMMUNICATION PRIVATE LIMITED"],
      "2005E8" => ["Ooo Inpr", "OOO InProMedia"],
      "200A5E" => ["Xiangsha", "Xiangshan Giant Eagle Technology Developing co.,LTD"],
      "20107A" => ["GemtekTe", "Gemtek Technology Co., Ltd."],
      "201257" => ["MostLuck", "Most Lucky Trading Ltd"],
      "2013E0" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "2021A5" => ["LgElectr", "LG Electronics Inc"],
      "202598" => ["Teleview",""],
      "202BC1" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "202CB7" => ["KongYueE", "Kong Yue Electronics & Information Industry (Xinhui) Ltd."],
      "203706" => ["Cisco", "Cisco Systems"],
      "2037BC" => ["KuipersE", "Kuipers Electronic Engineering BV"],
      "204005" => ["Feno", "feno GmbH"],
      "20415A" => ["SmartehD", "Smarteh d.o.o."],
      "20443A" => ["Schneide", "Schneider Electric Asia Pacific Ltd"],
      "2046A1" => ["Vecow", "VECOW Co., Ltd"],
      "2046F9" => ["Advanced", "Advanced Network Devices (dba:AND)"],
      "204AAA" => ["HanscanS", "Hanscan Spain S.A."],
      "204E6B" => ["AxxanaIs", "Axxana(israel) ltd"],
      "204E7F" => ["Netgear",""],
      "205476" => ["SonyMobi", "Sony Mobile Communications AB"],
      "2059A0" => ["ParagonT", "Paragon Technologies Inc."],
      "205B2A" => ["Private",""],
      "205B5E" => ["Shenzhen", "Shenzhen Wonhe Technology Co., Ltd"],
      "206432" => ["SamsungE", "SAMSUNG ELECTRO MECHANICS CO.,LTD."],
      "2067B1" => ["Pluto", "Pluto inc."],
      "206A8A" => ["WistronI", "Wistron InfoComm Manufacturing(Kunshan)Co.,Ltd."],
      "206AFF" => ["AtlasEle", "Atlas Elektronik UK Limited"],
      "206FEC" => ["BraemacC", "Braemac CA LLC"],
      "207600" => ["Actionte", "Actiontec Electronics, Inc"],
      "207C8F" => ["QuantaMi", "Quanta Microsystems,Inc."],
      "208984" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD"],
      "209BA5" => ["JiaxingG", "JIAXING GLEAD Electronics Co.,Ltd"],
      "20A2E7" => ["Lee-Dick", "Lee-Dickens Ltd"],
      "20AA25" => ["Ip-NetLl", "IP-NET LLC"],
      "20AA4B" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "20B0F7" => ["Enclustr", "Enclustra GmbH"],
      "20B399" => ["Enterasy", "Enterasys"],
      "20B7C0" => ["OmicronE", "Omicron electronics GmbH"],
      "20BBC6" => ["JabilCir", "Jabil Circuit Hungary Ltd."],
      "20BFDB" => ["Dvl",""],
      "20C1AF" => ["IWitDigi", "i Wit Digital Co., Limited"],
      "20C8B3" => ["Shenzhen", "SHENZHEN BUL-TECH CO.,LTD."],
      "20C9D0" => ["Apple", "Apple Inc"],
      "20CF30" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "20D5AB" => ["KoreaInf", "Korea Infocom Co.,Ltd."],
      "20D607" => ["Nokia", "Nokia Corporation"],
      "20D906" => ["Iota", "Iota, Inc."],
      "20DC93" => ["CheetahH", "Cheetah Hi-Tech, Inc."],
      "20E52A" => ["Netgear", "NETGEAR INC.,"],
      "20E564" => ["Motorola", "Motorola Mobility, Inc."],
      "20EEC6" => ["Elefirst", "Elefirst Science & Tech Co ., ltd"],
      "20F002" => ["MtdataDe", "MTData Developments Pty. Ltd."],
      "20F3A3" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "20F85E" => ["DeltaEle", "Delta Electronics"],
      "20FABB" => ["Cambridg", "Cambridge Executive Limited"],
      "20FDF1" => ["3comEuro", "3COM EUROPE LTD"],
      "20FECD" => ["SystemIn", "System In Frontier Inc."],
      "20FEDB" => ["M2mSolut", "M2M Solution S.A.S."],
      "240917" => ["DevlinEl", "Devlin Electronics Limited"],
      "240B2A" => ["ViettelG", "Viettel Group"],
      "240BB1" => ["KostalIn", "KOSTAL Industrie Elektrik GmbH"],
      "241064" => ["Shenzhen", "Shenzhen Ecsino Tecnical Co. Ltd"],
      "241125" => ["Hutek", "Hutek Co., Ltd."],
      "241A8C" => ["Squarehe", "Squarehead Technology AS"],
      "241B13" => ["Shanghai", "Shanghai Nutshell Electronic Co., Ltd."],
      "241F2C" => ["Calsys", "Calsys, Inc."],
      "2421AB" => ["SonyEric", "Sony Ericsson Mobile Communications"],
      "24374C" => ["CiscoSpv", "Cisco SPVTG"],
      "2437EF" => ["EmcElect", "EMC Electronic Media Communication SA"],
      "243C20" => ["Dynamode", "Dynamode Group"],
      "244597" => ["GemueGeb", "GEMUE Gebr. Mueller Apparatebau"],
      "24470E" => ["Pentroni", "PentronicAB"],
      "24497B" => ["Innovati", "Innovative Converged Devices Inc"],
      "245FDF" => ["Kyocera", "KYOCERA Corporation"],
      "246511" => ["Avm", "AVM GmbH"],
      "24767D" => ["CiscoSpv", "Cisco SPVTG"],
      "247703" => ["IntelCor", "Intel Corporate"],
      "24828A" => ["ProwaveT", "Prowave Technologies Ltd."],
      "2486F4" => ["Ctek", "Ctek, Inc."],
      "248707" => ["Senergy", "SEnergy Corporation"],
      "249442" => ["OpenRoad", "OPEN ROAD SOLUTIONS , INC."],
      "24A42C" => ["KoukaamA", "KOUKAAM a.s."],
      "24A43C" => ["Ubiquiti", "Ubiquiti Networks, INC"],
      "24A937" => ["PureStor", "PURE Storage"],
      "24AB81" => ["Apple", "Apple, Inc."],
      "24AF4A" => ["Alcatel-", "Alcatel-Lucent-IPD"],
      "24AF54" => ["NexgenMe", "NEXGEN Mediatech Inc."],
      "24B657" => ["Cisco", "Cisco Systems"],
      "24B6B8" => ["Friem", "FRIEM SPA"],
      "24B6FD" => ["Dell", "Dell Inc"],
      "24B88C" => ["Crenus", "Crenus Co.,Ltd."],
      "24B8D2" => ["OpzoonTe", "Opzoon Technology Co.,Ltd."],
      "24BA30" => ["Technica", "Technical Consumer Products, Inc."],
      "24BBC1" => ["Absolute", "Absolute Analysis"],
      "24BC82" => ["DaliWire", "Dali Wireless, Inc."],
      "24BE05" => ["HewlettP", "Hewlett Packard"],
      "24BF74" => ["Private",""],
      "24C0B3" => ["Rsf",""],
      "24C86E" => ["ChaneyIn", "Chaney Instrument Co."],
      "24C9DE" => ["Genoray",""],
      "24CBE7" => ["Myk", "MYK, Inc."],
      "24CF21" => ["Shenzhen", "Shenzhen State Micro Technology Co., Ltd"],
      "24D2CC" => ["Smartdri", "SmartDrive Systems Inc."],
      "24D921" => ["Avaya", "Avaya, Inc"],
      "24DAB6" => ["Sistemas", "Sistemas de Gesti n Energ tica S.A. de C.V."],
      "24DBAC" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "24DBAD" => ["Shoppert", "ShopperTrak RCT Corporation"],
      "24E6BA" => ["JscZavod", "JSC Zavod im. Kozitsky"],
      "24EC99" => ["AskeyCom", "Askey Computer Corp"],
      "24F0FF" => ["Ght", "GHT Co., Ltd."],
      "2804E0" => ["FermaxEl", "FERMAX ELECTRONICA S.A.U."],
      "28061E" => ["NingboGl", "NINGBO GLOBAL USEFUL ELECTRIC CO.,LTD"],
      "28068D" => ["ItlLlc", "ITL, LLC"],
      "280CB8" => ["Mikrosay", "Mikrosay Yazilim ve Elektronik A.S."],
      "280DFC" => ["SonyComp", "Sony Computer Entertainment Inc."],
      "28107B" => ["D-LinkIn", "D-Link International"],
      "281471" => ["Lantis", "Lantis co., LTD."],
      "28162E" => ["2wire",""],
      "2817CE" => ["Omnisens", "Omnisense Ltd"],
      "2818FD" => ["AdityaIn", "Aditya Infotech Ltd."],
      "2826A6" => ["PbrElect", "PBR electronics GmbH"],
      "2829D9" => ["Globalbe", "GlobalBeiMing technology (Beijing)Co. Ltd"],
      "283410" => ["EnigmaDi", "Enigma Diagnostics Limited"],
      "283737" => ["Apple", "Apple, Inc."],
      "2838CF" => ["Gen2wave",""],
      "2839E7" => ["PrecenoT", "Preceno Technology Pte.Ltd."],
      "283CE4" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "28401A" => ["C8Medise", "C8 MediSensors, Inc."],
      "284121" => ["Optisens", "OptiSense Network, LLC"],
      "284846" => ["Gridcent", "GridCentric Inc."],
      "284C53" => ["IntuneNe", "Intune Networks"],
      "285132" => ["Shenzhen", "Shenzhen Prayfly Technology Co.,Ltd"],
      "285FDB" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "286046" => ["LantechC", "Lantech Communications Global, Inc."],
      "286094" => ["Capelec",""],
      "286AB8" => ["Apple", "Apple, Inc."],
      "286ABA" => ["Apple", "Apple, Inc."],
      "286ED4" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "287184" => ["SpirePay", "Spire Payments"],
      "2872C5" => ["Smartmat", "Smartmatic Corp"],
      "2872F0" => ["Athena",""],
      "28852D" => ["TouchNet", "Touch Networks"],
      "288915" => ["Cashguar", "CashGuard Sverige AB"],
      "2891D0" => ["StageTec", "Stage Tec Entwicklungsgesellschaft fuer professionelle Audiotechnik mbH"],
      "28924A" => ["HewlettP", "Hewlett Packard"],
      "2893FE" => ["Cisco", "Cisco Systems"],
      "28940F" => ["Cisco", "Cisco Systems"],
      "28987B" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "28A574" => ["MillerEl", "Miller Electric Mfg. Co."],
      "28AF0A" => ["SiriusXm", "Sirius XM Radio Inc"],
      "28B0CC" => ["XenyaDOO", "Xenya d.o.o."],
      "28BA18" => ["NextnavL", "NextNav, LLC"],
      "28BE9B" => ["Technico", "Technicolor USA Inc."],
      "28C0DA" => ["JuniperN", "Juniper Networks"],
      "28C718" => ["Altierre",""],
      "28C914" => ["Taimag", "Taimag Corporation"],
      "28CCFF" => ["Corporac", "Corporacion Empresarial Altra SL"],
      "28CD1C" => ["EspotelO", "Espotel Oy"],
      "28CD4C" => ["Individu", "Individual Computers GmbH"],
      "28CFDA" => ["Apple", "Apple, Inc."],
      "28D1AF" => ["Nokia", "Nokia Corporation"],
      "28D576" => ["PremierW", "Premier Wireless, Inc."],
      "28D997" => ["YuduanMo", "Yuduan Mobile Co., Ltd."],
      "28E02C" => ["Apple", "Apple, Inc."],
      "28E297" => ["Shanghai", "Shanghai InfoTM Microelectronics Co.,Ltd."],
      "28E608" => ["Tokheim",""],
      "28E794" => ["Microtim", "Microtime Computer Inc."],
      "28E7CF" => ["Apple", "Apple, Inc."],
      "28ED58" => ["JagJakob", "JAG Jakob AG"],
      "28EE2C" => ["Frontlin", "Frontline Test Equipment"],
      "28EF01" => ["Private",""],
      "28F358" => ["2c-Trifo", "2C - Trifonov & Co"],
      "28F606" => ["SyesSrl", "Syes srl"],
      "28FBD3" => ["Shanghai", "Shanghai RagenTek Communication Technology Co.,Ltd."],
      "2C002C" => ["Unowhy",""],
      "2C0033" => ["Econtrol", "EControls, LLC"],
      "2C00F7" => ["Xos",""],
      "2C0623" => ["WinLeade", "Win Leader Inc."],
      "2C10C1" => ["Nintendo", "Nintendo Co., Ltd."],
      "2C1984" => ["IdnTelec", "IDN Telecom, Inc."],
      "2C1EEA" => ["Aerodev",""],
      "2C2172" => ["JuniperN", "Juniper Networks"],
      "2C27D7" => ["Hewlett-", "Hewlett-Packard Company"],
      "2C2D48" => ["BctElect", "bct electronic GesmbH"],
      "2C3068" => ["Pantech", "Pantech Co.,Ltd"],
      "2C3427" => ["Erco&Amp", "ERCO &amp; GENER"],
      "2C36A0" => ["Capisco", "Capisco Limited"],
      "2C36F8" => ["Cisco", "Cisco Systems"],
      "2C3A28" => ["FagorEle", "Fagor Electr nica"],
      "2C3F38" => ["Cisco", "Cisco Systems"],
      "2C3F3E" => ["Alge-Tim", "Alge-Timing GmbH"],
      "2C4138" => ["Hewlett-", "Hewlett-Packard Company"],
      "2C4401" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "2C542D" => ["Cisco", "Cisco Systems"],
      "2C6289" => ["Regeners", "Regenersis (Glenrothes) Ltd"],
      "2C67FB" => ["Shenzhen", "ShenZhen Zhengjili Electronics Co., LTD"],
      "2C6BF5" => ["JuniperN", "Juniper networks"],
      "2C750F" => ["Shanghai", "Shanghai Dongzhou-Lawton Communication Technology Co. Ltd."],
      "2C768A" => ["Hewlett-", "Hewlett-Packard Company"],
      "2C7AFE" => ["Iee&E Bl", "IEE&E Black ops"],
      "2C7ECF" => ["Onzo", "Onzo Ltd"],
      "2C8065" => ["HartingO", "HARTING Inc. of North America"],
      "2C8158" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd"],
      "2C8BF2" => ["HitachiM", "Hitachi Metals America Ltd"],
      "2C9127" => ["Eintechn", "Eintechno Corporation"],
      "2C9717" => ["ICYBV", "I.C.Y. B.V."],
      "2C9E5F" => ["Motorola", "Motorola Mobility, Inc."],
      "2C9EFC" => ["Canon", "CANON INC."],
      "2CA157" => ["Acromate", "ACROMATE, INC."],
      "2CA780" => ["TrueTech", "True Technologies Inc."],
      "2CA835" => ["Rim",""],
      "2CB05D" => ["Netgear",""],
      "2CB0DF" => ["SolitonT", "Soliton Technologies Pvt Ltd"],
      "2CB69D" => ["RedDigit", "RED Digital Cinema"],
      "2CBE97" => ["Ingenieu", "Ingenieurbuero Bickele und Buehler GmbH"],
      "2CC260" => ["Ravello", "Ravello Systems"],
      "2CCD27" => ["Precor", "Precor Inc"],
      "2CCD43" => ["SummitTe", "Summit Technology Group"],
      "2CD1DA" => ["Sanjole", "Sanjole, Inc."],
      "2CD2E7" => ["Nokia", "Nokia Corporation"],
      "2CD444" => ["Fujitsu", "Fujitsu Limited"],
      "2CDD0C" => ["Discover", "Discovergy GmbH"],
      "2CE412" => ["Sagemcom", "SAGEMCOM SAS"],
      "2CEDEB" => ["AlpheusD", "Alpheus Digital Company Limited"],
      "2CEE26" => ["Petroleu", "Petroleum Geo-Services"],
      "2CF4C5" => ["Avaya", "Avaya Inc"],
      "2E2E2E" => ["LaaLocal", "LAA (Locally Administered Address) for Meditech Systems"],
      "300B9C" => ["DeltaMob", "Delta Mobile Systems, Inc."],
      "300ED5" => ["HonHaiPr", "Hon Hai Precision Ind.Co.Ltd"],
      "30142D" => ["Piciorgr", "Piciorgros GmbH"],
      "30144A" => ["WistronN", "Wistron Neweb Corp."],
      "30168D" => ["Prolon",""],
      "3017C8" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "3018CF" => ["DeosCont", "DEOS control systems GmbH"],
      "301A28" => ["MakoNetw", "Mako Networks Ltd"],
      "302DE8" => ["JdaLlcJd", "JDA, LLC (JDA Systems)"],
      "3032D4" => ["Hanilstm", "Hanilstm Co., Ltd."],
      "3037A6" => ["Cisco", "Cisco Systems"],
      "303855" => ["Nokia", "Nokia Corporation"],
      "303926" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "303955" => ["Shenzhen", "Shenzhen Jinhengjia Electronic Co., Ltd."],
      "3039F2" => ["AdbBroad", "ADB Broadband Italia"],
      "304174" => ["AltecLan", "ALTEC LANSING LLC"],
      "30469A" => ["Netgear",""],
      "30493B" => ["NanjingZ", "Nanjing Z-Com Wireless Co.,Ltd"],
      "304C7E" => ["Panasoni", "Panasonic Electric Works Automation Controls Techno Co.,Ltd."],
      "304EC3" => ["TianjinT", "Tianjin Techua Technology Co., Ltd."],
      "30525A" => ["Nst", "NST Co., LTD"],
      "3055ED" => ["TrexNetw", "Trex Network LLC"],
      "3057AC" => ["Irlab", "IRLAB LTD."],
      "305D38" => ["Beissbar", "Beissbarth"],
      "306118" => ["Paradom", "Paradom Inc."],
      "30688C" => ["ReachTec", "Reach Technology Inc."],
      "30694B" => ["Rim",""],
      "306CBE" => ["Skymotio", "Skymotion Technology (HK) Limited"],
      "306E5C" => ["ValidusT", "Validus Technologies"],
      "3071B2" => ["Hangzhou", "Hangzhou Prevail Optoelectronic Equipment Co.,LTD."],
      "307C30" => ["Rim",""],
      "307ECB" => ["Sfr",""],
      "3085A9" => ["AsustekC", "Asustek Computer Inc"],
      "308730" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "308CFB" => ["Dropcam",""],
      "30AEF6" => ["RadioMob", "Radio Mobile Access"],
      "30B216" => ["HytecGer", "Hytec Geraetebau GmbH"],
      "30B3A2" => ["Shenzhen", "Shenzhen Heguang Measurement & Control Technology Co.,Ltd"],
      "30DE86" => ["CedacSof", "Cedac Software S.r.l."],
      "30E48E" => ["Vodafone", "Vodafone UK"],
      "30E4DB" => ["Cisco", "Cisco Systems"],
      "30EB25" => ["IntekDig", "INTEK DIGITAL"],
      "30EFD1" => ["AlstomSt", "Alstom Strongwish (Shenzhen) Co., Ltd."],
      "30F33A" => ["+PluggSr", "+plugg srl"],
      "30F70D" => ["Cisco", "Cisco Systems"],
      "30F9ED" => ["Sony", "Sony Corporation"],
      "30FD11" => ["Macrotec", "MACROTECH (USA) INC."],
      "3407FB" => ["Ericsson", "Ericsson AB"],
      "340804" => ["D-Link", "D-Link Corporation"],
      "34159E" => ["Apple", "Apple, Inc"],
      "342109" => ["JensenSc", "Jensen Scandinavia AS"],
      "34255D" => ["Shenzhen", "Shenzhen Loadcom Technology Co.,Ltd"],
      "3429EA" => ["McdElect", "MCD ELECTRONICS SP. Z O.O."],
      "342F6E" => ["Anywire", "Anywire corporation"],
      "3440B5" => ["Ibm",""],
      "344B3D" => ["Fiberhom", "Fiberhome Telecommunication Tech.Co.,Ltd."],
      "344B50" => ["Zte", "ZTE Corporation"],
      "344F69" => ["EkinopsS", "EKINOPS SAS"],
      "3451C9" => ["Apple", "Apple, Inc."],
      "345B11" => ["EviHeat", "EVI HEAT AB"],
      "34684A" => ["Terawork", "Teraworks Co., Ltd."],
      "346BD3" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "346E8A" => ["Ecosense",""],
      "346F92" => ["WhiteRod", "White Rodgers Division"],
      "3476C5" => ["I-ODataD", "I-O DATA DEVICE, INC."],
      "347877" => ["O-NetCom", "O-NET Communications(Shenzhen) Limited"],
      "347E39" => ["NokiaDan", "Nokia Danmark A/S"],
      "348137" => ["UnicardS", "UNICARD SA"],
      "3482DE" => ["KayoTech", "Kayo Technology, Inc."],
      "348302" => ["Iforcom", "iForcom Co., Ltd"],
      "34862A" => ["HeinzLac", "Heinz Lackmann GmbH & Co KG"],
      "3497FB" => ["Advanced", "ADVANCED RF TECHNOLOGIES INC"],
      "34996F" => ["VpiEngin", "VPI Engineering"],
      "3499D7" => ["Universa", "Universal Flow Monitors, Inc."],
      "349A0D" => ["ZbdDispl", "ZBD Displays Ltd"],
      "34A183" => ["Aware", "AWare, Inc"],
      "34A55D" => ["Technoso", "TECHNOSOFT INTERNATIONAL SRL"],
      "34A709" => ["TrevilSr", "Trevil srl"],
      "34A7BA" => ["FischerI", "Fischer International Systems Corporation"],
      "34AA99" => ["Alcatel-", "Alcatel-Lucent"],
      "34AAEE" => ["Mikrovis", "Mikrovisatos Servisas UAB"],
      "34B571" => ["Plds",""],
      "34BA51" => ["Se-KureC", "Se-Kure Controls, Inc."],
      "34BA9A" => ["Asiatelc", "Asiatelco Technologies Co."],
      "34BB1F" => ["Research", "Research In Motion"],
      "34BCA6" => ["BeijingD", "Beijing Ding Qing Technology, Ltd."],
      "34BDC8" => ["Cisco", "Cisco Systems"],
      "34BDF9" => ["Shanghai", "Shanghai WDK Industrial Co.,Ltd."],
      "34C3AC" => ["SamsungE", "Samsung Electronics"],
      "34C69A" => ["Enecsys", "Enecsys Ltd"],
      "34C731" => ["AlpsElec", "ALPS Electric Co,. Ltd."],
      "34CE94" => ["ParsecPt", "Parsec (Pty) Ltd"],
      "34D09B" => ["Mobilmax", "MobilMAX Technology Inc."],
      "34D2C4" => ["RenaPrin", "RENA GmbH Print Systeme"],
      "34D7B4" => ["Tributar", "Tributary Systems, Inc."],
      "34DF2A" => ["FujikonI", "Fujikon Industrial Co.,Limited"],
      "34E0D7" => ["Dongguan", "DONGGUAN QISHENG ELECTRONICS INDUSTRIAL CO., LTD"],
      "34EF44" => ["2wire",""],
      "34EF8B" => ["NttCommu", "NTT Communications Corporation"],
      "34F39B" => ["Wizlan", "WizLAN Ltd."],
      "34F968" => ["AtekProd", "ATEK Products, LLC"],
      "34FC6F" => ["Alcea",""],
      "380197" => ["ToshibaS", "Toshiba Samsung Storage Technolgoy Korea Corporation"],
      "380A0A" => ["Sky-City", "Sky-City Communication and Electronics Limited Company"],
      "380A94" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "380DD4" => ["PrimaxEl", "Primax Electronics LTD."],
      "3816D1" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "381C4A" => ["SimcomWi", "SIMCom Wireless Solutions Co.,Ltd."],
      "38229D" => ["AdbBroad", "ADB Broadband Italia"],
      "3822D6" => ["H3cTechn", "H3C Technologies Co., Limited"],
      "3826CD" => ["Andtek", "ANDTEK"],
      "3828EA" => ["FujianNe", "Fujian Netcom Technology Co., LTD"],
      "3831AC" => ["Weg",""],
      "383F10" => ["DblTechn", "DBL Technology Ltd."],
      "38458C" => ["MycloudT", "MyCloud Technology corporation"],
      "384608" => ["Zte", "ZTE Corporation"],
      "38521A" => ["Alcatel-", "Alcatel-Lucent 7705"],
      "38580C" => ["Panacces", "Panaccess Systems GmbH"],
      "3859F9" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "385FC3" => ["YuJeongS", "Yu Jeong System, Co.Ltd"],
      "386077" => ["Pegatron", "PEGATRON CORPORATION"],
      "3863F6" => ["3nodMult", "3NOD MULTIMEDIA(SHENZHEN)CO.,LTD"],
      "386BBB" => ["Motorola", "Motorola Mobility, Inc."],
      "386E21" => ["WasionGr", "Wasion Group Ltd."],
      "3872C0" => ["Comtrend",""],
      "388345" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "388AB7" => ["Panasoni", "Panasonic Telecom Co.,Ltd"],
      "3891FB" => ["XenoxBv", "Xenox Holding BV"],
      "389592" => ["BeijingT", "Beijing Tendyron Corporation"],
      "389F83" => ["OtnNV", "OTN Systems N.V."],
      "38A5B6" => ["Shenzhen", "SHENZHEN MEGMEET ELECTRICAL CO.,LTD"],
      "38A851" => ["Quickset", "Quickset International Inc"],
      "38A95F" => ["Actifio", "Actifio Inc"],
      "38B12D" => ["Sonotron", "Sonotronic Nagel GmbH"],
      "38BB23" => ["Ozvision", "OzVision America LLC"],
      "38BF33" => ["NecCasio", "NEC CASIO Mobile Communications"],
      "38C7BA" => ["CsServic", "CS Services Co.,Ltd."],
      "38C85C" => ["CiscoSpv", "Cisco SPVTG"],
      "38D135" => ["EasyioSd", "EasyIO Corporation Sdn. Bhd."],
      "38DE60" => ["Mohlenho", "Mohlenhoff GmbH"],
      "38E08E" => ["Mitsubis", "Mitsubishi Electric Co."],
      "38E7D8" => ["Htc", "HTC Corporation"],
      "38E8DF" => ["BMedien+", "b gmbh medien + datenbanken"],
      "38E98C" => ["RecoSPA", "Reco S.p.A."],
      "38ECE4" => ["SamsungE", "Samsung Electronics"],
      "38EE9D" => ["Anedo", "Anedo Ltd."],
      "38F8B7" => ["V2comPar", "V2COM PARTICIPACOES S.A."],
      "38FEC5" => ["EllipsBV", "Ellips B.V."],
      "3C0000" => ["3Com",""],
      "3C02B1" => ["Creation", "Creation Technologies LP"],
      "3C04BF" => ["Pravis", "PRAVIS SYSTEMS Co.Ltd.,"],
      "3C05AB" => ["ProductC", "Product Creation Studio"],
      "3C0754" => ["Apple", "Apple, Inc."],
      "3C096D" => ["Powerhou", "Powerhouse Dynamics"],
      "3C0FC1" => ["KbcNetwo", "KBC Networks"],
      "3C106F" => ["Albahith", "ALBAHITH TECHNOLOGIES"],
      "3C1915" => ["GfiChron", "GFI Chrono Time"],
      "3C197D" => ["Ericsson", "Ericsson AB"],
      "3C1A79" => ["HuayuanT", "Huayuan Technology CO.,LTD"],
      "3C1CBE" => ["JadakLlc", "JADAK LLC"],
      "3C26D5" => ["SoteraWi", "Sotera Wireless"],
      "3C2763" => ["SleQuali", "SLE quality engineering GmbH &amp; Co. KG"],
      "3C2DB7" => ["TexasIns", "Texas Instruments"],
      "3C2F3A" => ["Sforzato", "SFORZATO Corp."],
      "3C363D" => ["Nokia", "Nokia Corporation"],
      "3C3888" => ["Connectq", "ConnectQuest, llc"],
      "3C39C3" => ["JwElectr", "JW Electronics Co., Ltd."],
      "3C3A73" => ["Avaya", "Avaya, Inc"],
      "3C438E" => ["Motorola", "Motorola Mobility, Inc."],
      "3C4A92" => ["Hewlett-", "Hewlett-Packard Company"],
      "3C4C69" => ["Infinity", "Infinity System S.L."],
      "3C4E47" => ["Etronic", "Etronic A/S"],
      "3C5A37" => ["SamsungE", "Samsung Electronics"],
      "3C5F01" => ["Synerchi", "Synerchip Co., Ltd."],
      "3C6200" => ["SamsungE", "Samsung electronics CO., LTD"],
      "3C6278" => ["Shenzhen", "SHENZHEN JETNET TECHNOLOGY CO.,LTD."],
      "3C672C" => ["Sciovid", "Sciovid Inc."],
      "3C6A7D" => ["NiigataP", "Niigata Power Systems Co., Ltd."],
      "3C6F45" => ["Fiberpro", "Fiberpro Inc."],
      "3C7059" => ["Makerbot", "MakerBot Industries"],
      "3C7437" => ["Rim",""],
      "3C754A" => ["Motorola", "Motorola Mobility, Inc."],
      "3C7DB1" => ["TexasIns", "Texas Instruments"],
      "3C81D8" => ["Sagemcom", "SAGEMCOM SAS"],
      "3C8BFE" => ["SamsungE", "Samsung Electronics"],
      "3C9157" => ["Hangzhou", "Hangzhou Yulong Conmunication Co.,Ltd"],
      "3C9174" => ["AlongCom", "ALONG COMMUNICATION TECHNOLOGY"],
      "3C970E" => ["WistronI", "Wistron InfoComm(Kunshan)Co.,Ltd."],
      "3C98BF" => ["QuestCon", "Quest Controls, Inc."],
      "3C99F7" => ["Lansente", "Lansentechnology AB"],
      "3C9F81" => ["Shenzhen", "Shenzhen CATIC Bit Communications Technology Co.,Ltd"],
      "3CA315" => ["BlessInf", "Bless Information & Communications Co., Ltd"],
      "3CA72B" => ["MrvCommu", "MRV Communications (Networks) LTD"],
      "3CA9F4" => ["IntelCor", "Intel Corporate"],
      "3CB15B" => ["Avaya", "Avaya, Inc"],
      "3CB17F" => ["Wattwatc", "Wattwatchers Pty Ld"],
      "3CB87A" => ["Private",""],
      "3CB9A6" => ["BeldenDe", "Belden Deutschland GmbH"],
      "3CBDD8" => ["LgElectr", "LG ELECTRONICS INC"],
      "3CC0C6" => ["D&Amp;BA", "d&amp;b audiotechnik GmbH"],
      "3CC1F6" => ["MelangeP", "Melange Systems Pvt. Ltd."],
      "3CC99E" => ["HuiyangT", "Huiyang Technology Co., Ltd"],
      "3CCE73" => ["Cisco", "Cisco Systems"],
      "3CD0F8" => ["Apple", "Apple, Inc."],
      "3CD16E" => ["Telepowe", "Telepower Communication Co., Ltd"],
      "3CD92B" => ["Hewlett-", "Hewlett-Packard Company"],
      "3CDF1E" => ["Cisco", "Cisco Systems"],
      "3CE5A6" => ["Hangzhou", "Hangzhou H3C Technologies Co., Ltd."],
      "3CE5B4" => ["KidasenI", "KIDASEN INDUSTRIA E COMERCIO DE ANTENAS LTDA"],
      "3CE624" => ["LgDispla", "LG Display"],
      "3CEA4F" => ["2wire",""],
      "3CEAFB" => ["Nse", "NSE AG"],
      "3CF392" => ["Virtualt", "Virtualtek. Co. Ltd"],
      "3CF52C" => ["Dspecial", "DSPECIALISTS GmbH"],
      "3CF72A" => ["Nokia", "Nokia Corporation"],
      "400003" => ["NetWare?", "Net Ware (?)"],
      "4001C6" => ["3comEuro", "3COM EUROPE LTD"],
      "40040C" => ["A&T",""],
      "400E67" => ["Tremol", "Tremol Ltd."],
      "4012E4" => ["Compass-", "Compass-EOS"],
      "4013D9" => ["GlobalEs", "Global ES"],
      "401597" => ["ProtectA", "Protect America, Inc."],
      "40169F" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "4016FA" => ["EkmMeter", "EKM Metering"],
      "4018B1" => ["Aerohive", "Aerohive Networks Inc."],
      "4018D7" => ["WyleTele", "Wyle Telemetry and Data Systems"],
      "401D59" => ["Biometri", "Biometric Associates, LP"],
      "4022ED" => ["DigitalP", "Digital Projection Ltd"],
      "4025C2" => ["IntelCor", "Intel Corporate"],
      "402BA1" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "402CF4" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "403004" => ["Apple", "Apple, Inc."],
      "40336C" => ["GodrejBo", "Godrej & Boyce Mfg. co. ltd"],
      "4037AD" => ["MacroIma", "Macro Image Technology, Inc."],
      "403CFC" => ["Apple", "Apple, Inc."],
      "404022" => ["Ziv",""],
      "40406B" => ["Icomera",""],
      "404A03" => ["ZyxelCom", "ZyXEL Communications Corporation"],
      "404D8E" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "4050E0" => ["MiltonSe", "Milton Security Group LLC"],
      "40520D" => ["PicoTech", "Pico Technology"],
      "405539" => ["Cisco", "Cisco Systems"],
      "405A9B" => ["Anovo",""],
      "405FBE" => ["Rim",""],
      "405FC2" => ["TexasIns", "Texas Instruments"],
      "40605A" => ["HawkeyeT", "Hawkeye Tech Co. Ltd"],
      "406186" => ["Micro-St", "MICRO-STAR INT\'L CO.,LTD"],
      "40618E" => ["Stella-G", "Stella-Green Co"],
      "40667A" => ["Mediola-", "mediola - connected living AG"],
      "406AAB" => ["Rim",""],
      "406C8F" => ["Apple", "Apple, Inc."],
      "40704A" => ["PowerIde", "Power Idea Technology Limited"],
      "407074" => ["LifeTech", "Life Technology (China) Co., Ltd"],
      "407B1B" => ["MettleNe", "Mettle Networks Inc."],
      "4083DE" => ["Motorola",""],
      "408493" => ["Claviste", "Clavister AB"],
      "4088E0" => ["BeijingE", "Beijing Ereneben Information Technology Limited Shenzhen Branch"],
      "408A9A" => ["Titeng", "TITENG CO., Ltd."],
      "408B07" => ["Actionte", "Actiontec Electronics, Inc"],
      "408BF6" => ["Shenzhen", "Shenzhen TCL New Technology Co; Ltd."],
      "409558" => ["Aisino", "Aisino Corporation"],
      "4097D1" => ["BkElectr", "BK Electronics cc"],
      "40984C" => ["CasacomS", "Casacom Solutions AG"],
      "40984E" => ["TexasIns", "Texas Instruments"],
      "40987B" => ["Aisino", "Aisino Corporation"],
      "409FC7" => ["Baekchun", "BAEKCHUN ENC Co., Ltd."],
      "40A6A4" => ["Passivsy", "PassivSystems Ltd"],
      "40A6D9" => ["Apple", "Apple, Inc."],
      "40AC8D" => ["DataMana", "Data Management, Inc."],
      "40B2C8" => ["NortelNe", "Nortel Networks"],
      "40B3FC" => ["Logital", "Logital Co. Limited"],
      "40B7F3" => ["Motorola", "Motorola Mobility, Inc."],
      "40BA61" => ["ArimaCom", "Arima Communications Corp."],
      "40BC8B" => ["Itelio", "itelio GmbH"],
      "40BF17" => ["Digistar", "Digistar Telecom. SA"],
      "40C245" => ["Shenzhen", "Shenzhen Hexicom Technology Co., Ltd."],
      "40C7C9" => ["Naviit", "Naviit Inc."],
      "40CD3A" => ["Z3Techno", "Z3 Technology"],
      "40D32D" => ["Apple", "Apple, Inc"],
      "40D40E" => ["Biodata", "Biodata Ltd"],
      "40D559" => ["MicroSER", "MICRO S.E.R.I."],
      "40E793" => ["Shenzhen", "Shenzhen Siviton Technology Co.,Ltd"],
      "40ECF8" => ["Siemens", "Siemens AG"],
      "40EF4C" => ["Fihonest", "Fihonest communication co.,Ltd"],
      "40F14C" => ["IseEurop", "ISE Europe SPRL"],
      "40F407" => ["Nintendo", "Nintendo Co., Ltd."],
      "40F4EC" => ["Cisco", "Cisco Systems"],
      "40F52E" => ["LeicaMic", "Leica Microsystems (Schweiz) AG"],
      "40FC89" => ["Motorola", "Motorola Mobility, Inc."],
      "440CFD" => ["Netman", "NetMan Co., Ltd."],
      "441319" => ["WkkTechn", "WKK TECHNOLOGY LTD."],
      "441EA1" => ["Hewlett-", "Hewlett-Packard Company"],
      "4423AA" => ["Farmage", "Farmage Co., Ltd."],
      "4425BB" => ["BambooEn", "Bamboo Entertainment Corporation"],
      "442A60" => ["Apple", "Apple, Inc."],
      "442B03" => ["Cisco", "Cisco Systems"],
      "44322A" => ["Avaya", "Avaya Inc"],
      "44348F" => ["MxtIndus", "MXT INDUSTRIAL LTDA"],
      "443719" => ["2SaveEne", "2 Save Energy Ltd"],
      "44376F" => ["YoungEle", "Young Electric Sign Co"],
      "4437E6" => ["HonHaiPr", "Hon Hai Precision Ind.Co.Ltd"],
      "443839" => ["CumulusN", "Cumulus Networks, inc"],
      "443D21" => ["Nuvolt",""],
      "443EB2" => ["Deotron", "DEOTRON Co., LTD."],
      "444553" => ["Microsoft",""],
      "444649" => ["DfiDiamo", "DFI (Diamond Flower Industries)"],
      "444E1A" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "444F5E" => ["PanStudi", "Pan Studios Co.,Ltd."],
      "4451DB" => ["Raytheon", "Raytheon BBN Technologies"],
      "4454C0" => ["Thompson", "Thompson Aerospace"],
      "44568D" => ["PncTechn", "PNC Technologies  Co., Ltd."],
      "4456B7" => ["SpawnLab", "Spawn Labs, Inc"],
      "445829" => ["CiscoSpv", "Cisco SPVTG"],
      "44599F" => ["Criticar", "Criticare Systems, Inc"],
      "445EF3" => ["Tonalite", "Tonalite Holding B.V."],
      "445F7A" => ["ShihlinE", "Shihlin Electric & Engineering Corp."],
      "446132" => ["Ecobee", "ecobee inc"],
      "4468AB" => ["Juin", "JUIN COMPANY, LIMITED"],
      "446C24" => ["ReallinE", "Reallin Electronic Co.,Ltd"],
      "446D57" => ["LiteonTe", "Liteon Technology Corporation"],
      "447C7F" => ["Innoligh", "Innolight Technology Corporation"],
      "447DA5" => ["VtionInf", "VTION INFORMATION TECHNOLOGY (FUJIAN) CO.,LTD"],
      "447E95" => ["AlphaAnd", "Alpha and Omega, Inc"],
      "448312" => ["Star-Net",""],
      "448500" => ["Intel", "Intel Corporation"],
      "4487FC" => ["Elitegro", "ELITEGROUP COMPUTER SYSTEM CO., LTD."],
      "448C52" => ["Ktis", "KTIS CO., Ltd"],
      "448E12" => ["DtResear", "DT Research, Inc."],
      "448E81" => ["Vig",""],
      "4491DB" => ["Shanghai", "Shanghai Huaqin Telecom Technology Co.,Ltd"],
      "4495FA" => ["QingdaoS", "Qingdao Santong Digital Technology Co.Ltd"],
      "449CB5" => ["Alcomp", "Alcomp, Inc"],
      "44A42D" => ["TctMobil", "TCT Mobile Limited"],
      "44A689" => ["PromaxEl", "PROMAX ELECTRONICA SA"],
      "44A7CF" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "44A8C2" => ["SewooTec", "SEWOO TECH CO., LTD"],
      "44AA27" => ["Udworks", "udworks Co., Ltd."],
      "44AAE8" => ["NanotecE", "Nanotec Electronic GmbH & Co. KG"],
      "44B382" => ["Kuang-Ch", "Kuang-chi Institute of Advanced Technology"],
      "44C15C" => ["TexasIns", "Texas Instruments"],
      "44C233" => ["Guangzho", "Guangzhou Comet Technology Development Co.Ltd"],
      "44C9A2" => ["Greenwal", "Greenwald Industries"],
      "44D15E" => ["Shanghai", "Shanghai Kingto Information Technology Ltd"],
      "44D2CA" => ["AnviaTvO", "Anvia TV Oy"],
      "44D3CA" => ["Cisco", "Cisco Systems"],
      "44D63D" => ["TalariNe", "Talari Networks"],
      "44D832" => ["Azurewav", "Azurewave Technologies, Inc."],
      "44D884" => ["Apple", "Apple, Inc."],
      "44DC91" => ["PlanexCo", "PLANEX COMMUNICATIONS INC."],
      "44DCCB" => ["Semindia", "SEMINDIA SYSTEMS PVT LTD"],
      "44E08E" => ["CiscoSpv", "Cisco SPVTG"],
      "44E49A" => ["Omnitron", "OMNITRONICS PTY LTD"],
      "44E4D9" => ["Cisco", "Cisco Systems"],
      "44E8A5" => ["MyrekaTe", "Myreka Technologies Sdn. Bhd."],
      "44ED57" => ["Longicor", "Longicorn, inc."],
      "44F459" => ["SamsungE", "Samsung Electronics"],
      "475443" => ["GtcNotRe", "GTC (Not registered!)		(This number is a multicast!)"],
      "48022A" => ["B-LinkEl", "B-Link Electronic Limited"],
      "481249" => ["LuxcomTe", "Luxcom Technologies Inc."],
      "4813F3" => ["BbkElect", "BBK Electronics Corp., Ltd."],
      "48174C" => ["Micropow", "MicroPower technologies"],
      "481BD2" => ["IntronSc", "Intron Scientific co., ltd."],
      "48282F" => ["Zte", "ZTE Corporation"],
      "482CEA" => ["Motorola", "Motorola Inc Business Light Radios"],
      "4833DD" => ["ZennioAv", "ZENNIO AVANCE Y TECNOLOGIA, S.L."],
      "48343D" => ["Iep", "IEP GmbH"],
      "484453" => ["Hds???", "HDS ???"],
      "484487" => ["CiscoSpv", "Cisco SPVTG"],
      "4844F7" => ["SamsungE", "Samsung Electronics Co., LTD"],
      "4846F1" => ["UrosOy", "Uros Oy"],
      "484C00" => ["NetworkS", "Network Solutions"],
      "4854E8" => ["Winbond?",""],
      "485B39" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "485D60" => ["Azurewav", "Azurewave Technologies, Inc."],
      "4860BC" => ["Apple", "Apple, Inc."],
      "4861A3" => ["Concern", "Concern Axion JSC"],
      "486B91" => ["Fleetwoo", "Fleetwood Group Inc."],
      "486FD2" => ["Storsimp", "StorSimple Inc"],
      "487119" => ["SgbGroup", "SGB GROUP LTD."],
      "488E42" => ["Digalog", "DIGALOG GmbH"],
      "489153" => ["Weinmann", "Weinmann Ger te f r Medizin GmbH + Co. KG"],
      "4891F6" => ["Shenzhen", "Shenzhen Reach software technology CO.,LTD"],
      "489BE2" => ["SciInnov", "SCI Innovations Ltd"],
      "48A22D" => ["Shenzhen", "Shenzhen Huaxuchang Telecom Technology Co.,Ltd"],
      "48A6D2" => ["GjsunOpt", "GJsun Optical Science and Tech Co.,Ltd."],
      "48AA5D" => ["StoreEle", "Store Electronic Systems"],
      "48B253" => ["Marketax", "Marketaxess Corporation"],
      "48C1AC" => ["Plantron", "PLANTRONICS, INC."],
      "48C862" => ["SimoWire", "Simo Wireless,Inc."],
      "48C8B6" => ["Systec", "SysTec GmbH"],
      "48CB6E" => ["CelloEle", "Cello Electronics (UK) Ltd"],
      "48D54C" => ["JedaNetw", "Jeda Networks"],
      "48D7FF" => ["BlankomA", "BLANKOM Antennentechnik GmbH"],
      "48D8FE" => ["ClaridyS", "ClarIDy Solutions, Inc."],
      "48DCFB" => ["Nokia", "Nokia Corporation"],
      "48DF1C" => ["WuhanNec", "Wuhan NEC Fibre Optic Communications industry Co. Ltd"],
      "48E1AF" => ["Vity",""],
      "48EA63" => ["Zhejiang", "Zhejiang Uniview Technologies Co., Ltd."],
      "48EB30" => ["EternaTe", "ETERNA TECHNOLOGY, INC."],
      "48ED80" => ["DaesungE", "daesung eltec"],
      "48F317" => ["Private",""],
      "48F47D" => ["Techvisi", "TechVision Holding  Internation Limited"],
      "48F7F1" => ["Alcatel-", "Alcatel-Lucent"],
      "48F8E1" => ["AlcatelL", "Alcatel Lucent WT"],
      "48FCB8" => ["Woodstre", "Woodstream Corporation"],
      "4C022E" => ["CmrKorea", "CMR KOREA CO., LTD"],
      "4C0289" => ["LexCompu", "LEX COMPUTECH CO., LTD"],
      "4C068A" => ["BaslerEl", "Basler Electric Company"],
      "4C07C9" => ["Computer", "COMPUTER OFFICE Co.,Ltd."],
      "4C09B4" => ["Zte", "zte corporation"],
      "4C0B3A" => ["TctMobil", "TCT Mobile Limited"],
      "4C0F6E" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "4C0FC7" => ["EardaEle", "Earda Electronics Co.,Ltd"],
      "4C1480" => ["Noregon", "NOREGON SYSTEMS, INC"],
      "4C17EB" => ["Sagemcom",""],
      "4C1A3A" => ["PrimaRes", "PRIMA Research And Production Enterprise Ltd."],
      "4C1FCC" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "4C2C80" => ["BeijingS", "Beijing Skyway Technologies Co.,Ltd"],
      "4C2F9D" => ["IcmContr", "ICM Controls"],
      "4C3089" => ["ThalesTr", "Thales Transportation Systems GmbH"],
      "4C322D" => ["Teledata", "TELEDATA NETWORKS"],
      "4C32D9" => ["MRuttyHo", "M Rutty Holdings Pty. Ltd."],
      "4C3910" => ["NewtekEl", "Newtek Electronics co., Ltd."],
      "4C3B74" => ["VogtecHK", "VOGTEC(H.K.) Co., Ltd"],
      "4C424C" => ["Informat", "Information Modes software modified addresses (not registered?)"],
      "4C4B68" => ["MobileDe", "Mobile Device, Inc."],
      "4C5427" => ["LineproS", "Linepro Sp. z o.o."],
      "4C5499" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "4C5585" => ["Hamilton", "Hamilton Systems"],
      "4C5DCD" => ["OyFinnis", "Oy Finnish Electric Vehicle Technologies Ltd"],
      "4C5FD2" => ["Alcatel-", "Alcatel-Lucent"],
      "4C60D5" => ["Airpoint", "airPointe of New Hampshire"],
      "4C60DE" => ["Netgear",""],
      "4C63EB" => ["Applicat", "Application Solutions (Electronics and Vision) Ltd"],
      "4C64D9" => ["Guangdon", "Guangdong Leawin Group Co., Ltd"],
      "4C72B9" => ["Pegatron", "Pegatron Corporation"],
      "4C7367" => ["GeniusBy", "Genius Bytes Software Solutions GmbH"],
      "4C73A5" => ["Kove",""],
      "4C774F" => ["Embedded", "Embedded Wireless Labs"],
      "4C7897" => ["Arrowhea", "Arrowhead Alarm Products Ltd"],
      "4C8093" => ["IntelCor", "Intel Corporate"],
      "4C8B55" => ["GrupoDig", "Grupo Digicon"],
      "4C98EF" => ["Zeo",""],
      "4C9E80" => ["KyokkoEl", "KYOKKO ELECTRIC Co., Ltd."],
      "4C9EE4" => ["HanyangN", "Hanyang Navicom Co.,Ltd."],
      "4CA74B" => ["AlcatelL", "Alcatel Lucent"],
      "4CAA16" => ["Azurewav", "AzureWave Technologies (Shanghai) Inc."],
      "4CAC0A" => ["Zte", "ZTE Corporation"],
      "4CB16C" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "4CB199" => ["Apple", "Apple, Inc."],
      "4CB4EA" => ["HrdSPte", "HRD (S) PTE., LTD."],
      "4CB9C8" => ["Conet", "CONET CO., LTD."],
      "4CBAA3" => ["BisonEle", "Bison Electronics Inc."],
      "4CC452" => ["ShangHai", "Shang Hai Tyd. Electon Technology Ltd."],
      "4CC602" => ["Radios", "Radios, Inc."],
      "4CC94F" => ["Alcatel-", "Alcatel-Lucent"],
      "4CE676" => ["Buffalo", "Buffalo Inc."],
      "4CEB42" => ["IntelCor", "Intel Corporate"],
      "4CEDDE" => ["AskeyCom", "Askey Computer Corp"],
      "4CF737" => ["SamjiEle", "SamJi Electronics Co., Ltd"],
      "50008C" => ["HongKong", "Hong Kong Telecommunications (HKT) Limited"],
      "5001BB" => ["SamsungE", "Samsung Electronics"],
      "50053D" => ["CyweeGro", "CyWee Group Ltd"],
      "500B32" => ["FoxdaTec", "Foxda Technology Industrial(ShenZhen)Co.,LTD"],
      "500E6D" => ["Trafficc", "TrafficCast International"],
      "502267" => ["Pixelink",""],
      "50252B" => ["NethraIm", "Nethra Imaging Incorporated"],
      "502690" => ["Fujitsu", "Fujitsu Limited"],
      "502A7E" => ["SmartEle", "Smart electronic GmbH"],
      "502A8B" => ["TelekomR", "Telekom Research and Development Sdn Bhd"],
      "502D1D" => ["Nokia", "Nokia Corporation"],
      "502DA2" => ["IntelCor", "Intel Corporate"],
      "502DF4" => ["PhytecMe", "Phytec Messtechnik GmbH"],
      "502ECE" => ["AsahiEle", "Asahi Electronics Co.,Ltd"],
      "503DE5" => ["Cisco", "Cisco Systems"],
      "5048EB" => ["BeijingH", "BEIJING HAIHEJINSHENG NETWORK TECHNOLOGY CO. LTD."],
      "504A5E" => ["Masimo", "Masimo Corporation"],
      "505663" => ["TexasIns", "Texas Instruments"],
      "5057A8" => ["Cisco", "Cisco Systems"],
      "506028" => ["Xirrus", "Xirrus Inc."],
      "506313" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "506441" => ["Greenlee",""],
      "5067F0" => ["ZyxelCom", "ZyXEL Communications Corporation"],
      "506F9A" => ["Wi-FiAll", "Wi-Fi Alliance"],
      "5070E5" => ["HeShanWo", "He Shan World Fair Electronics Technology Limited"],
      "5076A6" => ["EcilInfo", "Ecil Informatica Ind. Com. Ltda"],
      "50795B" => ["Interexp", "Interexport Telecomunicaciones S.A."],
      "507D02" => ["Biodit",""],
      "5087B8" => ["Nuvyyo", "Nuvyyo Inc"],
      "508A42" => ["UptmateT", "Uptmate Technology Co., LTD"],
      "508ACB" => ["Shenzhen", "SHENZHEN MAXMADE TECHNOLOGY CO., LTD."],
      "508C77" => ["Dirmeier", "DIRMEIER Schanktechnik GmbH &Co KG"],
      "50934F" => ["GradualT", "Gradual Tecnologia Ltda."],
      "509772" => ["Westingh", "Westinghouse Digital"],
      "50A6E3" => ["DavidCla", "David Clark Company"],
      "50A733" => ["RuckusWi", "Ruckus Wireless"],
      "50AF73" => ["Shenzhen", "Shenzhen Bitland Information Technology Co., Ltd."],
      "50C58D" => ["JuniperN", "Juniper Networks"],
      "50C971" => ["GnNetcom", "GN Netcom A/S"],
      "50CCF8" => ["SamsungE", "Samsung Electro Mechanics"],
      "50CE75" => ["MeasyEle", "Measy Electronics Ltd"],
      "50D274" => ["Steffes", "Steffes Corporation"],
      "50D6D7" => ["Takahata", "Takahata Precision"],
      "50E549" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "50EAD6" => ["Apple", "Apple, Inc."],
      "50EB1A" => ["BrocadeC", "Brocade Communications Systems, Inc"],
      "50ED94" => ["EgatelSl", "Egatel SL"],
      "50F003" => ["OpenStac", "Open Stack, Inc."],
      "50F61A" => ["KunshanJ", "Kunshan JADE Technologies co., Ltd."],
      "50FAAB" => ["L-TekDOO", "L-tek d.o.o."],
      "50FC30" => ["Treehous", "Treehouse Labs"],
      "525400" => ["RealtekU", "Realtek (UpTech? also reported)"],
      "52544C" => ["Novell20", "Novell 2000"],
      "5254AB" => ["RealtekA", "REALTEK (a Realtek 8029 based PCI Card)"],
      "5403F5" => ["EbnTechn", "EBN Technology Corp."],
      "540496" => ["Gigawave", "Gigawave LTD"],
      "5404A6" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "54055F" => ["AlcatelL", "Alcatel Lucent"],
      "541DFB" => ["Freestyl", "Freestyle Energy Ltd"],
      "542018" => ["TelyLabs", "Tely Labs"],
      "542A9C" => ["LsyDefen", "LSY Defense, LLC."],
      "543131" => ["RasterVi", "Raster Vision Ltd"],
      "5435DF" => ["Symeo", "Symeo GmbH"],
      "543968" => ["Edgewate", "Edgewater Networks Inc"],
      "544249" => ["Sony", "Sony Corporation"],
      "54466B" => ["Shenzhen", "Shenzhen CZTIC Electronic Technology Co., Ltd"],
      "544A05" => ["WenglorS", "wenglor sensoric gmbh"],
      "5453ED" => ["Sony", "Sony Corporation"],
      "545EBD" => ["NlTechno", "NL Technologies"],
      "545FA9" => ["Teracom", "Teracom Limited"],
      "547398" => ["ToyoElec", "Toyo Electronics Corporation"],
      "5475D0" => ["Cisco", "Cisco Systems"],
      "547F54" => ["Ingenico",""],
      "547FEE" => ["Cisco", "Cisco Systems"],
      "54847B" => ["DigitalD", "Digital Devices GmbH"],
      "548922" => ["Zelfy", "Zelfy Inc"],
      "548998" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "5492BE" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "549478" => ["Silversh", "Silvershore Technology Partners"],
      "549A16" => ["UzushioE", "Uzushio Electric Co.,Ltd."],
      "549B12" => ["SamsungE", "Samsung Electronics"],
      "549D85" => ["Eneracce", "EnerAccess inc"],
      "54A51B" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "54A9D4" => ["Minibar", "Minibar Systems"],
      "54B620" => ["SuhdolE&", "SUHDOL E&C Co.Ltd."],
      "54CDA7" => ["FujianSh", "Fujian Shenzhou Electronic Co.,Ltd"],
      "54D0ED" => ["AximComm", "AXIM Communications"],
      "54D1B0" => ["Universa", "Universal Laser Systems, Inc"],
      "54D46F" => ["CiscoSpv", "Cisco SPVTG"],
      "54E63F" => ["Shenzhen", "ShenZhen LingKeWeiEr Technology Co., Ltd."],
      "54E6FC" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "54F5B6" => ["Oriental", "ORIENTAL PACIFIC INTERNATIONAL LIMITED"],
      "54FDBF" => ["ScheidtB", "Scheidt & Bachmann GmbH"],
      "565857" => ["AculabPl", "Aculab plc			audio bridges"],
      "580556" => ["Elettron", "Elettronica GF S.r.L."],
      "5808FA" => ["FiberOpt", "Fiber Optic &amp; telecommunication INC."],
      "581243" => ["AcsipTec", "AcSiP Technology Corp."],
      "581626" => ["Avaya", "Avaya, Inc"],
      "58170C" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "581D91" => ["Advanced", "Advanced Mobile Telecom co.,ltd."],
      "581FAA" => ["Apple", "Apple, Inc."],
      "581FEF" => ["Tuttnaer", "Tuttnaer LTD"],
      "582EFE" => ["Lighting", "Lighting Science Group"],
      "582F42" => ["Universa", "Universal Electric Corporation"],
      "58343B" => ["GlovastT", "Glovast Technology Ltd."],
      "5835D9" => ["Cisco", "Cisco Systems"],
      "583CC6" => ["Omnealit", "Omneality Ltd."],
      "5842E4" => ["SigmaInt", "Sigma International General Medical Apparatus, LLC."],
      "5846E1" => ["BaxterHe", "Baxter Healthcare"],
      "5848C0" => ["Coflec",""],
      "5849BA" => ["ChitaiEl", "Chitai Electronic Corp."],
      "584C19" => ["Chongqin", "Chongqing Guohong Technology Development Company Limited"],
      "584CEE" => ["DigitalO", "Digital One Technologies, Limited"],
      "585076" => ["LinearEq", "Linear Equipamentos Eletronicos SA"],
      "5850E6" => ["BestBuy", "Best Buy Corporation"],
      "5855CA" => ["Apple", "Apple, Inc."],
      "58570D" => ["DanfossS", "Danfoss Solar Inverters"],
      "5866BA" => ["Hangzhou", "Hangzhou H3C Technologies Co., Limited"],
      "58671A" => ["Barnes&N", "BARNES&NOBLE.COM"],
      "58677F" => ["ClareCon", "Clare Controls Inc."],
      "58696C" => ["FujianRu", "Fujian Ruijie Networks co, ltd"],
      "5869F9" => ["FusionTr", "Fusion Transactive Ltd."],
      "586D8F" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "586ED6" => ["Private",""],
      "587521" => ["CjscRtso", "CJSC RTSoft"],
      "587675" => ["BeijingE", "Beijing ECHO Technologies Co.,Ltd"],
      "587FC8" => ["S2m",""],
      "58874C" => ["Lite-OnC", "LITE-ON CLEAN ENERGY TECHNOLOGY CORP."],
      "588D09" => ["Cisco", "Cisco Systems"],
      "5891CF" => ["IntelCor", "Intel Corporate"],
      "58920D" => ["KineticA", "Kinetic Avionics Limited"],
      "589396" => ["RuckusWi", "Ruckus Wireless"],
      "58946B" => ["IntelCor", "Intel Corporate"],
      "589835" => ["Technico", "Technicolor"],
      "58A76F" => ["Id", "iD corporation"],
      "58B035" => ["Apple", "Apple, Inc"],
      "58B0D4" => ["Zunidata", "ZuniData Systems Inc."],
      "58B9E1" => ["Crystalf", "Crystalfontz America, Inc."],
      "58BC27" => ["Cisco", "Cisco Systems"],
      "58BDA3" => ["Nintendo", "Nintendo Co., Ltd."],
      "58BFEA" => ["Cisco", "Cisco Systems"],
      "58C38B" => ["SamsungE", "Samsung Electronics"],
      "58CF4B" => ["LufkinIn", "Lufkin Industries"],
      "58D08F" => ["Ieee1904", "IEEE 1904.1 Working Group"],
      "58DB8D" => ["Fast", "Fast Co., Ltd."],
      "58E476" => ["CentronC", "CENTRON COMMUNICATIONS TECHNOLOGIES FUJIAN CO.,LTD"],
      "58E636" => ["EvrsafeT", "EVRsafe Technologies"],
      "58E747" => ["Deltanet", "Deltanet AG"],
      "58E808" => ["Autonics", "AUTONICS CORPORATION"],
      "58ECE1" => ["Newport", "Newport Corporation"],
      "58EECE" => ["IconTime", "Icon Time Systems"],
      "58F67B" => ["XiaMenUn", "Xia Men UnionCore Technology LTD."],
      "58F6BF" => ["KyotoUni", "Kyoto University"],
      "58F98E" => ["Secudos", "SECUDOS GmbH"],
      "58FD20" => ["BravidaS", "Bravida Sakerhet AB"],
      "5C076F" => ["ThoughtC", "Thought Creator"],
      "5C0A5B" => ["SamsungE", "SAMSUNG ELECTRO-MECHANICS CO., LTD."],
      "5C0CBB" => ["Celizion", "CELIZION Inc."],
      "5C0E8B" => ["Motorola",""],
      "5C1437" => ["Thyssenk", "Thyssenkrupp Aufzugswerke GmbH"],
      "5C16C7" => ["BigSwitc", "Big Switch Networks"],
      "5C1737" => ["I-ViewNo", "I-View Now, LLC."],
      "5C17D3" => ["Lge", "LGE"],
      "5C18B5" => ["TalonCom", "Talon Communications"],
      "5C2479" => ["Baltech", "Baltech AG"],
      "5C260A" => ["Dell", "Dell Inc."],
      "5C338E" => ["AlphaNet", "Alpha Networkc Inc."],
      "5C353B" => ["CompalBr", "Compal Broadband Networks Inc."],
      "5C35DA" => ["ThereOy", "There Corporation Oy"],
      "5C4058" => ["Jefferso", "Jefferson Audio Video Systems, Inc."],
      "5C4CA9" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "5C5015" => ["Cisco", "Cisco Systems"],
      "5C56ED" => ["3pleplay", "3pleplay Electronics Private Limited"],
      "5C57C8" => ["Nokia", "Nokia Corporation"],
      "5C5948" => ["Apple", "Apple, Inc."],
      "5C5EAB" => ["JuniperN", "Juniper Networks"],
      "5C63BF" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "5C6984" => ["Nuvico",""],
      "5C6A7D" => ["Kentkart", "KENTKART EGE ELEKTRONIK SAN. VE TIC. LTD. STI."],
      "5C6B32" => ["TexasIns", "Texas Instruments"],
      "5C6D20" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "5C6F4F" => ["SASistel", "S.A. SISTEL"],
      "5C7757" => ["Haivisio", "Haivision Network Video"],
      "5C864A" => ["SecretLa", "Secret Labs LLC"],
      "5C8778" => ["Cybertel", "Cybertelbridge co.,ltd"],
      "5C95AE" => ["Apple", "Apple Inc"],
      "5C9AD8" => ["Fujitsu", "Fujitsu Limited"],
      "5CAC4C" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "5CB524" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "5CBD9E" => ["Hongkong", "HONGKONG MIRACLE EAGLE TECHNOLOGY(GROUP) LIMITED"],
      "5CC213" => ["FrSauter", "Fr. Sauter AG"],
      "5CC6D0" => ["Skyworth", "Skyworth Digital technology(shenzhen)co.ltd."],
      "5CC9D3" => ["Palladiu", "PALLADIUM ENERGY ELETRONICA DA AMAZONIA LTDA"],
      "5CCA32" => ["Theben", "Theben AG"],
      "5CCEAD" => ["Cdyne", "CDYNE Corporation"],
      "5CD135" => ["XtremePo", "Xtreme Power Systems"],
      "5CD4AB" => ["Zektor",""],
      "5CD998" => ["D-Link", "D-Link Corporation"],
      "5CDAD4" => ["MurataMa", "Murata Manufacturing Co., Ltd."],
      "5CE223" => ["DelphinT", "Delphin Technology AG"],
      "5CE286" => ["NortelNe", "Nortel Networks"],
      "5CE2F4" => ["AcsipTec", "AcSiP Technology Corp."],
      "5CE8EB" => ["SamsungE", "Samsung Electronics"],
      "5CEB4E" => ["RStahlHm", "R. STAHL HMI Systems GmbH"],
      "5CEE79" => ["GlobalDi", "Global Digitech Co LTD"],
      "5CF207" => ["SpecoTec", "Speco Technologies"],
      "5CF3FC" => ["Ibm", "IBM Corp"],
      "5CF9DD" => ["Dell", "Dell Inc"],
      "5CFF35" => ["Wistron", "Wistron Corporation"],
      "601199" => ["Data-Tes", "Data-Tester Inc."],
      "601283" => ["Solucion", "Soluciones Tecnologicas para la Salud y el Bienestar SA"],
      "6015C7" => ["Idatech",""],
      "60190C" => ["Rramac",""],
      "601929" => ["Voltroni", "VOLTRONIC POWER TECHNOLOGY(SHENZHEN) CORP."],
      "601D0F" => ["MidniteS", "Midnite Solar"],
      "602A54" => ["Cardiote", "CardioTek B.V."],
      "602AD0" => ["CiscoSpv", "Cisco SPVTG"],
      "6032F0" => ["MplusTec", "Mplus technology"],
      "60334B" => ["Apple", "Apple, Inc."],
      "603553" => ["BuwonTec", "Buwon Technology"],
      "6036DD" => ["IntelCor", "Intel Corporate"],
      "60380E" => ["AlpsElec", "Alps Electric Co.,"],
      "60391F" => ["Abb", "ABB Ltd"],
      "603FC5" => ["Cox", "COX CO., LTD"],
      "6044F5" => ["EasyDigi", "Easy Digital Ltd."],
      "60455E" => ["LiptelSR", "Liptel s.r.o."],
      "6045BD" => ["Microsof", "Microsoft"],
      "6052D0" => ["FactsEng", "FACTS Engineering"],
      "605464" => ["EyedroGr", "Eyedro Green Solutions Inc."],
      "6063FD" => ["Transcen", "Transcend Communication Beijing Co.,Ltd."],
      "606720" => ["IntelCor", "Intel Corporate"],
      "606BBD" => ["SamsungE", "Samsung Electronics Co., LTD"],
      "606C66" => ["IntelCor", "Intel Corporate"],
      "607688" => ["Velodyne",""],
      "6083B2" => ["GkwareEK", "GkWare e.K."],
      "60843B" => ["Soladigm", "Soladigm, Inc."],
      "608645" => ["AveryWei", "Avery Weigh-Tronix, LLC"],
      "60893C" => ["ThermoFi", "Thermo Fisher Scientific P.O.A."],
      "6089B1" => ["KeyDigit", "Key Digital Systems"],
      "6089B7" => ["KaelM He", "KAEL M HENDISLIK ELEKTRONIK TICARET SANAYI Limited  irketi"],
      "608C2B" => ["HansonTe", "Hanson Technology"],
      "608D17" => ["SentrusG", "Sentrus Government Systems Division, Inc"],
      "609084" => ["Dssd", "DSSD Inc"],
      "609AA4" => ["GviSecur", "GVI SECURITY INC."],
      "609E64" => ["Vivonic", "Vivonic GmbH"],
      "609F9D" => ["Cloudswi", "CloudSwitch"],
      "60A10A" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "60B3C4" => ["ElberSrl", "Elber Srl"],
      "60B606" => ["Phorus",""],
      "60B933" => ["DeutronE", "Deutron Electronics Corp."],
      "60B982" => ["RoVeRLab", "RO.VE.R. Laboratories S.p.A."],
      "60C547" => ["Apple", "Apple, Inc."],
      "60C980" => ["Trymus",""],
      "60CBFB" => ["Airscape", "AirScape Inc."],
      "60D0A9" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "60D1AA" => ["VishalTe", "Vishal Telecommunications Pvt Ltd"],
      "60D2B9" => ["RealandB", "REALAND BIO CO., LTD."],
      "60D30A" => ["Quatius", "Quatius Limited"],
      "60D819" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "60DA23" => ["Estech", "Estech Co.,Ltd"],
      "60E956" => ["AylaNetw", "Ayla Networks, Inc"],
      "60EB69" => ["QuantaCo", "Quanta computer Inc."],
      "60F13D" => ["Jablocom", "JABLOCOM s.r.o."],
      "60F281" => ["TranwoTe", "TRANWO TECHNOLOGY CO., LTD."],
      "60F2EF" => ["Visionve", "VisionVera International Co., Ltd."],
      "60F3DA" => ["LogicWay", "Logic Way GmbH"],
      "60F59C" => ["Cru-Data", "CRU-Dataport"],
      "60F673" => ["Terumo", "TERUMO CORPORATION"],
      "60FACD" => ["Apple", "Apple, Inc."],
      "60FB42" => ["Apple", "Apple, Inc"],
      "6400F1" => ["Cisco", "Cisco Systems"],
      "64094C" => ["BeijingS", "Beijing Superbee Wireless Technology Co.,Ltd"],
      "640E36" => ["Taztag",""],
      "640E94" => ["Pluribus", "Pluribus Networks, Inc."],
      "640F28" => ["2wire",""],
      "641084" => ["HexiumTe", "HEXIUM Technical Development Co., Ltd."],
      "64168D" => ["Cisco", "Cisco Systems"],
      "6416F0" => ["Shehzhen", "Shehzhen Huawei Communication Technologies Co., Ltd."],
      "641A22" => ["Heliospe", "Heliospectra/Woodhill Investments"],
      "641E81" => ["Dowslake", "Dowslake Microsystems"],
      "64200C" => ["Apple", "Apple, Inc."],
      "642216" => ["Shandong", "Shandong Taixin Electronic co.,Ltd"],
      "642400" => ["Xorcom", "Xorcom Ltd."],
      "642737" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "642DB7" => ["SeungilE", "SEUNGIL ELECTRONICS"],
      "643150" => ["Hewlett-", "Hewlett-Packard Company"],
      "64317E" => ["Dexin", "Dexin Corporation"],
      "643409" => ["BitwaveP", "BITwave Pte Ltd"],
      "644346" => ["Guangdon", "GuangDong Quick Network Computer CO.,LTD"],
      "644BC3" => ["Shanghai", "Shanghai WOASiS Telecommunications Ltd., Co."],
      "644BF0" => ["Caldigit", "CalDigit, Inc"],
      "644D70" => ["Dspace", "dSPACE GmbH"],
      "644F74" => ["Lenus", "LENUS Co., Ltd."],
      "64517E" => ["LongBenD", "LONG BEN (DONGGUAN) ELECTRONIC TECHNOLOGY CO.,LTD."],
      "645299" => ["Chamberl", "Chamberlain"],
      "645422" => ["EquinoxP", "Equinox Payments"],
      "645563" => ["Inteligh", "Intelight Inc."],
      "64557F" => ["NsfocusI", "NSFOCUS Information Technology Co., Ltd."],
      "645DD7" => ["Shenzhen", "Shenzhen Lifesense Medical Electronics Co., Ltd."],
      "645EBE" => ["Yahoo!Ja", "Yahoo! JAPAN"],
      "6465C0" => ["Nuvon", "Nuvon, Inc"],
      "6466B3" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "646707" => ["BeijingO", "Beijing Omnific Technology, Ltd."],
      "64680C" => ["Comtrend",""],
      "6469BC" => ["HyteraCo", "Hytera Communications Co .,ltd"],
      "646E6C" => ["RadioDat", "Radio Datacom LLC"],
      "647002" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "6473E2" => ["Arbiter", "Arbiter Systems, Inc."],
      "647657" => ["Innovati", "Innovative Security Designs"],
      "647BD4" => ["TexasIns", "Texas Instruments"],
      "647C34" => ["UbeeInte", "Ubee Interactive Corp."],
      "647D81" => ["YokotaIn", "YOKOTA INDUSTRIAL CO,.LTD"],
      "647FDA" => ["Tektelic", "TEKTELIC Communications Inc."],
      "64808B" => ["VgContro", "VG Controls, Inc."],
      "648099" => ["Intel", "Intel Corporation"],
      "648125" => ["Alphatro", "Alphatron Marine BV"],
      "648788" => ["JuniperN", "Juniper Networks"],
      "6487D7" => ["AdbBroad", "ADB Broadband Italia"],
      "64995D" => ["Lge", "LGE"],
      "649B24" => ["VTechnol", "V Technology Co., Ltd."],
      "649C8E" => ["TexasIns", "Texas Instruments"],
      "649EF3" => ["Cisco", "Cisco Systems"],
      "649FF7" => ["KoneOyj", "Kone OYj"],
      "64A0E7" => ["Cisco", "Cisco Systems"],
      "64A232" => ["OooSamli", "OOO Samlight"],
      "64A769" => ["Htc", "HTC Corporation"],
      "64A837" => ["JuniKore", "Juni Korea Co., Ltd"],
      "64AE0C" => ["Cisco", "Cisco Systems"],
      "64AE88" => ["Polytec", "Polytec GmbH"],
      "64B64A" => ["Vivotech", "ViVOtech, Inc."],
      "64B9E8" => ["Apple", "Apple, Inc"],
      "64BC11" => ["Combiq", "CombiQ AB"],
      "64C5AA" => ["SouthAfr", "South African Broadcasting Corporation"],
      "64C6AF" => ["AxerraNe", "AXERRA Networks Ltd"],
      "64D02D" => ["NextGene", "Next Generation Integration (NGI)"],
      "64D1A3" => ["SitecomE", "Sitecom Europe BV"],
      "64D241" => ["KeithKoe", "Keith & Koep GmbH"],
      "64D4DA" => ["IntelCor", "Intel Corporate"],
      "64D814" => ["Cisco", "Cisco Systems"],
      "64D912" => ["Solidica", "Solidica, Inc."],
      "64D989" => ["Cisco", "Cisco Systems"],
      "64DB18" => ["Openpatt", "OpenPattern"],
      "64DC01" => ["StaticGr", "Static Systems Group PLC"],
      "64DE1C" => ["Kingneti", "Kingnetic Pte Ltd"],
      "64E161" => ["Dep", "DEP Corp."],
      "64E682" => ["Apple", "Apple, Inc."],
      "64E84F" => ["Serialwa", "Serialway Communication Technology Co. Ltd"],
      "64E8E6" => ["GlobalMo", "global moisture management system"],
      "64ED57" => ["Motorola", "Motorola Mobility, Inc."],
      "64ED62" => ["Woori", "WOORI SYSTEMS Co., Ltd"],
      "64F242" => ["GerdesAk", "Gerdes Aktiengesellschaft"],
      "64F970" => ["KenadeEl", "Kenade Electronics Technology Co.,LTD."],
      "64F987" => ["Avvasi", "Avvasi Inc."],
      "64FC8C" => ["Zonar", "Zonar Systems"],
      "6805CA" => ["Intel", "Intel Corporation"],
      "680927" => ["Apple", "Apple, Inc."],
      "68122D" => ["SpecialI", "Special Instrument Development Co., Ltd."],
      "681605" => ["AndElect", "Systems And Electronic Development FZCO"],
      "681AB2" => ["Zte", "zte corporation"],
      "681FD8" => ["Advanced", "Advanced Telemetry"],
      "68234B" => ["NihonDen", "Nihon Dengyo Kousaku"],
      "684352" => ["Bhuu", "Bhuu Limited"],
      "684B88" => ["Galtroni", "Galtronics Telemetry Inc."],
      "6854F5" => ["Enlighte", "enLighted Inc"],
      "68597F" => ["AlcatelL", "Alcatel Lucent"],
      "685B36" => ["Powertec", "POWERTECH INDUSTRIAL CO., LTD."],
      "685D43" => ["IntelCor", "Intel Corporate"],
      "685E6B" => ["Powerray", "PowerRay Co., Ltd."],
      "686359" => ["Advanced", "Advanced Digital Broadcast SA"],
      "686E23" => ["Wi3", "Wi3 Inc."],
      "687251" => ["Ubiquiti", "Ubiquiti Networks"],
      "68784C" => ["NortelNe", "Nortel Networks"],
      "687924" => ["Els-Gmbh", "ELS-GmbH & Co. KG"],
      "6879ED" => ["Sharp", "SHARP Corporation"],
      "687F74" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "688470" => ["Essys", "eSSys Co.,Ltd"],
      "688540" => ["IgiMobil", "IGI Mobile, Inc."],
      "68876B" => ["InqMobil", "INQ Mobile Limited"],
      "689234" => ["RuckusWi", "Ruckus Wireless"],
      "68967B" => ["Apple", "Apple Inc"],
      "68974B" => ["Shenzhen", "Shenzhen Costar Electronics Co. Ltd."],
      "689C5E" => ["AcsipTec", "AcSiP Technology Corp."],
      "68A1B7" => ["HonghaoM", "Honghao Mingchuan Technology (Beijing) CO.,Ltd."],
      "68A3C4" => ["LiteonTe", "Liteon Technology Corporation"],
      "68A86D" => ["Apple", "Apple, Inc."],
      "68AAD2" => ["Datecs", "DATECS LTD.,"],
      "68AB8A" => ["RfIdeas", "RF IDeas"],
      "68B43A" => ["Waterfur", "WaterFurnace International, Inc."],
      "68B599" => ["Hewlett-", "Hewlett-Packard Company"],
      "68B6FC" => ["HitronTe", "Hitron Technologies. Inc"],
      "68BC0C" => ["Cisco", "Cisco Systems"],
      "68BDAB" => ["Cisco", "Cisco Systems"],
      "68CA00" => ["Octopus", "Octopus Systems Limited"],
      "68CC9C" => ["MineSite", "Mine Site Technologies"],
      "68CD0F" => ["UTek", "U Tek Company Limited"],
      "68CE4E" => ["L-3Commu", "L-3 Communications Infrared Products"],
      "68D1FD" => ["Shenzhen", "Shenzhen Trimax Technology Co.,Ltd"],
      "68D925" => ["ProsysDe", "ProSys Development Services"],
      "68DB96" => ["OpwillTe", "OPWILL Technologies CO .,LTD"],
      "68DCE8" => ["Packetst", "PacketStorm Communications"],
      "68E41F" => ["Unglaube", "Unglaube Identech GmbH"],
      "68EBAE" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "68EBC5" => ["Angstrem", "Angstrem Telecom"],
      "68ED43" => ["Research", "Research In Motion"],
      "68EFBD" => ["Cisco", "Cisco Systems"],
      "68F125" => ["DataCont", "Data Controls Inc."],
      "68F895" => ["Redflow", "Redflow Limited"],
      "6C0460" => ["RbhAcces", "RBH Access Technologies Inc."],
      "6C0E0D" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "6C0F6A" => ["JdcTech", "JDC Tech Co., Ltd."],
      "6C1811" => ["DecaturE", "Decatur Electronics"],
      "6C22AB" => ["Ainswort", "Ainsworth Game Technology"],
      "6C23B9" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "6C2E33" => ["Accelink", "Accelink Technologies Co.,Ltd."],
      "6C2E85" => ["Sagemcom",""],
      "6C32DE" => ["IndieonT", "Indieon Technologies Pvt. Ltd."],
      "6C33A9" => ["Magicjac", "Magicjack LP"],
      "6C391D" => ["BeijingZ", "Beijing ZhongHuaHun Network Information center"],
      "6C3A84" => ["Shenzhen", "Shenzhen Aero-Startech. Co.Ltd"],
      "6C3E6D" => ["Apple", "Apple Inc"],
      "6C3E9C" => ["KeKneste", "KE Knestel Elektronik GmbH"],
      "6C504D" => ["Cisco", "Cisco Systems"],
      "6C5CDE" => ["Sunrepor", "SunReports, Inc."],
      "6C5D63" => ["Shenzhen", "ShenZhen Rapoo Technology Co., Ltd."],
      "6C5E7A" => ["Ubiquito", "Ubiquitous Internet Telecom Co., Ltd"],
      "6C626D" => ["Micro-St", "Micro-Star INT\'L CO., LTD"],
      "6C6F18" => ["Stereota", "Stereotaxis, Inc."],
      "6C7039" => ["Novar", "Novar GmbH"],
      "6C81FE" => ["Mitsuba", "Mitsuba Corporation"],
      "6C8336" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "6C8CDB" => ["OtusTech", "Otus Technologies Ltd"],
      "6C8D65" => ["Wireless", "Wireless Glue Networks, Inc."],
      "6C92BF" => ["InspurEl", "Inspur Electronic Information Industry Co.,Ltd."],
      "6C9B02" => ["Nokia", "Nokia Corporation"],
      "6C9CE9" => ["NimbleSt", "Nimble Storage"],
      "6C9CED" => ["Cisco", "Cisco Systems"],
      "6CA682" => ["EdamInfo", "EDAM information & communications"],
      "6CA780" => ["Nokia", "Nokia Corporation"],
      "6CA906" => ["Telefiel", "Telefield Ltd"],
      "6CA96F" => ["Transpac", "TransPacket AS"],
      "6CAB4D" => ["DigitalP", "Digital Payment Technologies"],
      "6CAC60" => ["Venetex", "Venetex Corp"],
      "6CAD3F" => ["HubbellB", "Hubbell Building Automation, Inc."],
      "6CAE8B" => ["Ibm", "IBM Corporation"],
      "6CBEE9" => ["Alcatel-", "Alcatel-Lucent-IPD"],
      "6CC1D2" => ["Motorola", "Motorola Mobility, Inc."],
      "6CC26B" => ["Apple", "Apple, Inc."],
      "6CD68A" => ["LgElectr", "LG Electronics Inc"],
      "6CDC6A" => ["Promethe", "Promethean Limited"],
      "6CE0B0" => ["Sound4",""],
      "6CE4CE" => ["Villiger", "Villiger Security Solutions AG"],
      "6CE907" => ["Nokia", "Nokia Corporation"],
      "6CE983" => ["Gastron", "Gastron Co., LTD."],
      "6CF049" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "6CF37F" => ["ArubaNet", "Aruba Networks"],
      "6CFDB9" => ["ProwareT", "Proware Technologies Co Ltd."],
      "6CFFBE" => ["MpbCommu", "MPB Communications Inc."],
      "700258" => ["01db-Met", "01DB-METRAVIB"],
      "700514" => ["LgElectr", "LG Electronics"],
      "700BC0" => ["DewavTec", "Dewav Technology Company"],
      "701404" => ["Liabilit", "Limited Liability Company Research Center Bresler"],
      "701A04" => ["LiteonTe", "Liteon Tech Corp."],
      "701AED" => ["Advas", "ADVAS CO., LTD."],
      "702393" => ["Fos4x", "fos4X GmbH"],
      "702B1D" => ["E-DomusI", "E-Domus International Limited"],
      "702F4B" => ["Polyvisi", "PolyVision Inc."],
      "702F97" => ["AavaMobi", "Aava Mobile Oy"],
      "703018" => ["Avaya", "Avaya, Inc"],
      "703187" => ["Acx", "ACX GmbH"],
      "7032D5" => ["AthenaWi", "Athena Wireless Communications Inc"],
      "7038EE" => ["Avaya", "Avaya Inc"],
      "703AD8" => ["Shenzhen", "Shenzhen Afoundry Electronic Co., Ltd"],
      "703C39" => ["SeawingK", "SEAWING Kft"],
      "7041B7" => ["EdwardsL", "Edwards Lifesciences LLC"],
      "704642" => ["ChyngHon", "CHYNG HONG ELECTRONIC CO., LTD."],
      "704AAE" => ["XstreamF", "Xstream Flow (Pty) Ltd"],
      "705681" => ["Apple", "Apple Inc"],
      "705812" => ["Panasoni", "Panasonic AVC Networks Company"],
      "705AB6" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD."],
      "705CAD" => ["KonamiGa", "Konami Gaming Inc"],
      "705EAA" => ["ActionTa", "Action Target, Inc."],
      "706417" => ["OrbisTec", "ORBIS TECNOLOGIA ELECTRICA S.A."],
      "706582" => ["SuzhouHa", "Suzhou Hanming Technologies Co., Ltd."],
      "706F81" => ["Private",""],
      "70704C" => ["PurpleCo", "Purple Communications, Inc"],
      "7071BC" => ["Pegatron", "PEGATRON CORPORATION"],
      "7072CF" => ["Edgecore", "EdgeCore Networks"],
      "7073CB" => ["Apple", "Apple, Inc."],
      "7076F0" => ["Levelone", "LevelOne Communications (India) Private Limited"],
      "707BE8" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "707E43" => ["Motorola", "Motorola Mobility, Inc."],
      "707EDE" => ["Nastec", "NASTEC LTD."],
      "708105" => ["Cisco", "Cisco Systems"],
      "70828E" => ["Oleumtec", "OleumTech Corporation"],
      "708B78" => ["Citygrow", "citygrow technology co., ltd"],
      "709756" => ["Happyele", "Happyelectronics Co.,Ltd"],
      "709A0B" => ["ItalianI", "Italian Institute of Technology"],
      "709BA5" => ["Shenzhen", "Shenzhen Y&D Electronics Co.,LTD."],
      "709E86" => ["X6d", "X6D Limited"],
      "70A191" => ["Trendset", "Trendsetter Medical, LLC"],
      "70A41C" => ["Advanced", "Advanced Wireless Dynamics S.L."],
      "70A66A" => ["ProxDyna", "Prox Dynamics AS"],
      "70AAB2" => ["Research", "Research In Motion"],
      "70B035" => ["Shenzhen", "Shenzhen Zowee Technology Co., Ltd"],
      "70B08C" => ["ShenouCo", "Shenou Communication Equipment Co.,Ltd"],
      "70B265" => ["HiltronS", "Hiltron s.r.l."],
      "70B599" => ["Embedded", "Embedded Technologies s.r.o."],
      "70B921" => ["Fiberhom", "FiberHome Telecommunication Technologies CO.,LTD"],
      "70CA9B" => ["Cisco", "Cisco Systems"],
      "70CD60" => ["Apple", "Apple, Inc."],
      "70D4F2" => ["Rim",""],
      "70D57E" => ["Scalar", "Scalar Corporation"],
      "70D5E7" => ["Wellcore", "Wellcore Corporation"],
      "70D6B6" => ["MetrumTe", "Metrum Technologies"],
      "70D880" => ["UposSyst", "Upos System sp. z o.o."],
      "70DDA1" => ["Tellabs",""],
      "70DEE2" => ["Apple", "Apple, Inc."],
      "70E139" => ["3view", "3view Ltd"],
      "70E24C" => ["SaeIt-Sy", "SAE IT-systems GmbH & Co. KG"],
      "70E843" => ["BeijingC", "Beijing C&W Optical Communication Technology Co.,Ltd."],
      "70EE50" => ["Netatmo",""],
      "70F1A1" => ["LiteonTe", "Liteon Technology Corporation"],
      "70F395" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "740ABC" => ["JsjsDesi", "JSJS Designs (Europe) Limited"],
      "741489" => ["SrtWirel", "SRT Wireless"],
      "7415E2" => ["Tri-Sen", "Tri-Sen Systems Corporation"],
      "741E93" => ["Fiberhom", "Fiberhome Telecommunication Tech.Co.,Ltd."],
      "742B0F" => ["Infinida", "Infinidat Ltd."],
      "742F68" => ["Azurewav", "Azurewave Technologies, Inc."],
      "743170" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "743256" => ["Nt-WareS", "NT-ware Systemprg GmbH"],
      "743889" => ["AnnaxAnz", "ANNAX Anzeigesysteme GmbH"],
      "744401" => ["Netgear",""],
      "745327" => ["Commsen", "COMMSEN CO., LIMITED"],
      "745612" => ["Motorola", "Motorola Mobility, Inc."],
      "745798" => ["TrumpfLa", "TRUMPF Laser GmbH + Co. KG"],
      "745E1C" => ["Pioneer", "PIONEER CORPORATION"],
      "7463DF" => ["Vts", "VTS GmbH"],
      "7465D1" => ["Atlinks",""],
      "746A89" => ["Rezolt", "Rezolt Corporation"],
      "746B82" => ["Movek", "MOVEK"],
      "7472F2" => ["ChipsipT", "Chipsip Technology Co., Ltd."],
      "747818" => ["Servicea", "ServiceAssure"],
      "747B7A" => ["Eth", "ETH Inc."],
      "747DB6" => ["AliweiCo", "Aliwei Communications, Inc"],
      "747E1A" => ["RedEmbed", "Red Embedded Design Limited"],
      "747E2D" => ["BeijingT", "Beijing Thomson CITIC Digital Technology Co. LTD."],
      "74888B" => ["AdbBroad", "ADB Broadband Italia"],
      "748EF8" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "749050" => ["RenesasE", "Renesas Electronics Corporation"],
      "74911A" => ["RuckusWi", "Ruckus Wireless"],
      "7493A4" => ["ZebraTec", "Zebra Technologies Corp."],
      "749975" => ["Ibm", "IBM Corporation"],
      "749DDC" => ["2wire",""],
      "74A4A7" => ["QrsMusic", "QRS Music Technologies, Inc."],
      "74A722" => ["LgElectr", "LG Electronics"],
      "74AE76" => ["InovoBro", "iNovo Broadband, Inc."],
      "74B00C" => ["NetworkV", "Network Video Technologies, Inc"],
      "74B9EB" => ["FujianJi", "Fujian JinQianMao Electronic Technology Co.,Ltd"],
      "74BE08" => ["AtekProd", "ATEK Products, LLC"],
      "74CD0C" => ["SmithMye", "Smith Myers Communications Ltd."],
      "74CE56" => ["PacketFo", "Packet Force Technology Limited Company"],
      "74D0DC" => ["Ericsson", "ERICSSON AB"],
      "74D675" => ["WymaTecn", "WYMA Tecnologia"],
      "74D850" => ["Evrisko", "Evrisko Systems"],
      "74DE2B" => ["LiteonTe", "Liteon Technology Corporation"],
      "74E06E" => ["Ergophon", "Ergophone GmbH"],
      "74E1B6" => ["Apple", "Apple, Inc."],
      "74E2F5" => ["Apple", "Apple Inc"],
      "74E50B" => ["IntelCor", "Intel Corporate"],
      "74E537" => ["Radspin",""],
      "74E543" => ["LiteonTe", "Liteon Technology Corporation"],
      "74E7C6" => ["Motorola", "Motorola Mobility, Inc."],
      "74EA3A" => ["Tp-LinkT", "TP-LINK Technologies Co.,Ltd."],
      "74F06D" => ["Azurewav", "AzureWave Technologies, Inc."],
      "74F07D" => ["Bncom", "BnCOM Co.,Ltd"],
      "74F612" => ["Motorola", "Motorola Mobility, Inc."],
      "74F726" => ["NeuronRo", "Neuron Robotics"],
      "74FDA0" => ["Compupal", "Compupal (Group) Corporation"],
      "74FF7D" => ["WrenSoun", "Wren Sound Systems, LLC"],
      "78028F" => ["Adaptive", "Adaptive Spectrum and Signal Alignment (ASSIA), Inc."],
      "780738" => ["ZUKElzab", "Z.U.K. Elzab S.A."],
      "781185" => ["NbsPayme", "NBS Payment Solutions Inc."],
      "7812B8" => ["Orantek", "ORANTEK LIMITED"],
      "781881" => ["Azurewav", "AzureWave Technologies, Inc."],
      "78192E" => ["NascentT", "NASCENT Technology"],
      "7819F7" => ["JuniperN", "Juniper Networks"],
      "781C5A" => ["Sharp", "SHARP Corporation"],
      "781DBA" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "781DFD" => ["Jabil", "Jabil Inc"],
      "78223D" => ["Affirmed", "Affirmed Networks"],
      "782544" => ["Omnima", "Omnima Limited"],
      "7825AD" => ["SamsungE", "SAMSUNG ELECTRONICS CO., LTD."],
      "782BCB" => ["Dell", "Dell Inc"],
      "782EEF" => ["Nokia", "Nokia Corporation"],
      "7830E1" => ["Ultracle", "UltraClenz, LLC"],
      "783F15" => ["Easysync", "EasySYNC Ltd."],
      "784405" => ["FujituHo", "FUJITU(HONG KONG) ELECTRONIC Co.,LTD."],
      "784476" => ["ZioncomT", "Zioncom technology co.,ltd"],
      "7845C4" => ["Dell", "Dell Inc"],
      "7846C4" => ["DaehapHy", "DAEHAP HYPER-TECH"],
      "78471D" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "78510C" => ["Liveu", "LiveU Ltd."],
      "785262" => ["Shenzhen", "Shenzhen Hojy Software Co., Ltd."],
      "785712" => ["MobileIn", "Mobile Integration Workgroup"],
      "78593E" => ["Rafi", "RAFI GmbH & Co.KG"],
      "785C72" => ["HiosoTec", "Hioso Technology Co., Ltd."],
      "78617C" => ["MitsumiE", "MITSUMI ELECTRIC CO.,LTD"],
      "7866AE" => ["ZtecInst", "ZTEC Instruments, Inc."],
      "787F62" => ["GikMbh", "GiK mbH"],
      "78818F" => ["ServerRa", "Server Racks Australia Pty Ltd"],
      "78843C" => ["Sony", "Sony Corporation"],
      "7884EE" => ["IndraEsp", "INDRA ESPACIO S.A."],
      "788973" => ["Cmc",""],
      "788C54" => ["EnkomTec", "Enkom Technologies Ltd."],
      "78929C" => ["IntelCor", "Intel Corporate"],
      "78998F" => ["Mediline", "MEDILINE ITALIA SRL"],
      "78A051" => ["IinetLab", "iiNet Labs Pty Ltd"],
      "78A183" => ["Advidia",""],
      "78A2A0" => ["Nintendo", "Nintendo Co., Ltd."],
      "78A3E4" => ["Apple", "Apple, Inc."],
      "78A5DD" => ["Shenzhen", "Shenzhen Smarteye Digital Electronics Co., Ltd"],
      "78A683" => ["Precidat", "Precidata"],
      "78A6BD" => ["DaeyeonC", "DAEYEON Control&Instrument Co,.Ltd"],
      "78A714" => ["Amphenol",""],
      "78ACC0" => ["Hewlett-", "Hewlett-Packard Company"],
      "78B6C1" => ["AoboTele", "AOBO Telecom Co.,Ltd"],
      "78B81A" => ["InterSal", "INTER SALES A/S"],
      "78BAD0" => ["Shinybow", "Shinybow Technology Co. Ltd."],
      "78BEB6" => ["Enhanced", "Enhanced Vision"],
      "78BEBD" => ["Stulz", "STULZ GmbH"],
      "78C40E" => ["H&DWirel", "H&D Wireless"],
      "78C4AB" => ["Shenzhen", "Shenzhen Runsil Technology Co.,Ltd"],
      "78C5E5" => ["TexasIns", "Texas Instruments"],
      "78C6BB" => ["Innovasi", "Innovasic, Inc."],
      "78CA04" => ["Nokia", "Nokia Corporation"],
      "78CA39" => ["Apple", "Apple, Inc."],
      "78CD8E" => ["SmcNetwo", "SMC Networks Inc"],
      "78D004" => ["NeousysT", "Neousys Technology Inc."],
      "78D34F" => ["Pace-O-M", "Pace-O-Matic, Inc."],
      "78D6F0" => ["SamsungE", "Samsung Electro Mechanics"],
      "78DD08" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "78DDD6" => ["C-Scape",""],
      "78DEE4" => ["TexasIns", "Texas Instruments"],
      "78E3B5" => ["Hewlett-", "Hewlett-Packard Company"],
      "78E400" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "78E7D1" => ["Hewlett-", "Hewlett-Packard Company"],
      "78EC22" => ["Shanghai", "Shanghai Qihui Telecom Technology Co., LTD"],
      "78EF4C" => ["Unetconv", "Unetconvergence Co., Ltd."],
      "78F5FD" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "78F7D0" => ["Silverbr", "Silverbrook Research"],
      "78FE3D" => ["JuniperN", "Juniper Networks"],
      "7C02BC" => ["HansungE", "Hansung Electronics Co. LTD"],
      "7C034C" => ["Sagemcom",""],
      "7C051E" => ["Rafael", "RAFAEL LTD."],
      "7C08D9" => ["Shanghai", "Shanghai Engineering Research Center for Broadband Technologies and Applications"],
      "7C11BE" => ["Apple", "Apple, Inc."],
      "7C1476" => ["DamallTe", "Damall Technologies S.A.S. Di Ludovic Anselme Glaglanon & C."],
      "7C160D" => ["Saia-Bur", "Saia-Burgess Controls AG"],
      "7C1E52" => ["Microsof", "Microsoft"],
      "7C1EB3" => ["2nTeleko", "2N TELEKOMUNIKACE a.s."],
      "7C2064" => ["AlcatelL", "Alcatel Lucent IPD"],
      "7C2CF3" => ["SecureEl", "Secure Electrans Ltd"],
      "7C2E0D" => ["Blackmag", "Blackmagic Design"],
      "7C2F80" => ["GigasetC", "Gigaset Communications GmbH"],
      "7C336E" => ["MegElect", "MEG Electronics Inc."],
      "7C386C" => ["RealTime", "Real Time Logic"],
      "7C3920" => ["SsomaSec", "SSOMA SECURITY"],
      "7C3BD5" => ["ImagoGro", "Imago Group"],
      "7C3E9D" => ["Patech",""],
      "7C4A82" => ["Portsmit", "Portsmith LLC"],
      "7C4AA8" => ["Mindtree", "MindTree Wireless PVT Ltd"],
      "7C4B78" => ["RedSunSy", "Red Sun Synthesis Pte Ltd"],
      "7C4C58" => ["ScaleCom", "Scale Computing, Inc."],
      "7C4CA5" => ["Bskyb", "BSkyB Ltd"],
      "7C4FB5" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "7C55E7" => ["Ysi", "YSI, Inc."],
      "7C6193" => ["Htc", "HTC Corporation"],
      "7C6ADB" => ["Safetone", "SafeTone Technology Co.,Ltd"],
      "7C6B33" => ["TenyuTec", "Tenyu Tech Co. Ltd."],
      "7C6B52" => ["TigaroWi", "Tigaro Wireless"],
      "7C6C39" => ["PixsysSr", "PIXSYS SRL"],
      "7C6C8F" => ["AmsNeve", "AMS NEVE LTD"],
      "7C6D62" => ["Apple", "Apple, Inc"],
      "7C6F06" => ["Caterpil", "Caterpillar Trimble Control Technologies"],
      "7C7673" => ["Enmas", "ENMAS GmbH"],
      "7C7BE4" => ["Z&","39;Se"],
      "7C7D41" => ["JinmuyuE", "Jinmuyu Electronics Co., Ltd."],
      "7C8EE4" => ["TexasIns", "Texas Instruments"],
      "7C94B2" => ["PhilipsH", "Philips Healthcare PCCI"],
      "7CA29B" => ["DSignt&A", "D.SignT GmbH &amp; Co. KG"],
      "7CA61D" => ["MhlLlc", "MHL, LLC"],
      "7CACB2" => ["BoschSof", "Bosch Software Innovations GmbH"],
      "7CB03E" => ["Osram", "OSRAM AG"],
      "7CB21B" => ["CiscoSpv", "Cisco SPVTG"],
      "7CB542" => ["AcesTech", "ACES Technology"],
      "7CBB6F" => ["CoscoEle", "Cosco Electronics Co., Ltd."],
      "7CBFB1" => ["Motorola", "Motorola Mobility, Inc."],
      "7CC3A1" => ["Apple", "Apple, Inc."],
      "7CC537" => ["Apple", "Apple, Inc."],
      "7CC8D0" => ["TianjinY", "TIANJIN YAAN TECHNOLOGY CO., LTD."],
      "7CC8D7" => ["Damalisk",""],
      "7CCB0D" => ["AaxeonTe", "Aaxeon Technologies Inc."],
      "7CCFCF" => ["Shanghai", "Shanghai SEARI Intelligent System Co., Ltd"],
      "7CD1C3" => ["Apple", "Apple Inc"],
      "7CD9FE" => ["NewCosmo", "New Cosmos Electric Co., Ltd."],
      "7CDA84" => ["Dongnian", "Dongnian Networks Inc."],
      "7CDD11" => ["Chongqin", "Chongqing MAS SCI&TECH.Co.,Ltd"],
      "7CDD20" => ["IoxosTec", "IOXOS Technologies S.A."],
      "7CDD90" => ["Shenzhen", "Shenzhen Ogemray Technology Co., Ltd."],
      "7CE044" => ["Neon", "NEON Inc"],
      "7CE9D3" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "7CEBEA" => ["Asct",""],
      "7CED8D" => ["Microsof", "MICROSOFT"],
      "7CEF18" => ["Creative", "Creative Product Design Pty. Ltd."],
      "7CEF8A" => ["InhonInt", "Inhon International Ltd."],
      "7CF05F" => ["Apple", "Apple, Inc."],
      "7CF098" => ["BeeBeans", "Bee Beans Technologies, Inc."],
      "7CF0BA" => ["Linkwell", "Linkwell Telesystems Pvt Ltd"],
      "7CF429" => ["Nuuo", "NUUO Inc."],
      "7CFE28" => ["Salutron", "Salutron Inc."],
      "80000B" => ["IntelCor", "Intel Corporate"],
      "800010" => ["AttBellL", "ATT BELL LABORATORIES"],
      "800A06" => ["Comtec", "COMTEC co.,ltd"],
      "801440" => ["SunlitSy", "Sunlit System Technology Corp"],
      "8016B7" => ["BrunelUn", "Brunel University"],
      "80177D" => ["NortelNe", "Nortel Networks"],
      "8018A7" => ["SamsungE", "Samsung Eletronics Co., Ltd"],
      "801F02" => ["EdimaxTe", "Edimax Technology Co. Ltd."],
      "8020AF" => ["TradeFid", "Trade FIDES, a.s."],
      "802275" => ["BeijingB", "Beijing Beny Wave Technology Co Ltd"],
      "802AFA" => ["Germanee", "Germaneers GmbH"],
      "802DE1" => ["Solarbri", "Solarbridge Technologies"],
      "802E14" => ["AzetiNet", "azeti Networks AG"],
      "803457" => ["Ot", "OT Systems Limited"],
      "8038FD" => ["Leapfrog", "LeapFrog Enterprises, Inc."],
      "8039E5" => ["Patlite", "PATLITE CORPORATION"],
      "803B9A" => ["Ghe-CesE", "ghe-ces electronic ag"],
      "803F5D" => ["Winstars", "Winstars Technology Ltd"],
      "80427C" => ["AdolfTed", "Adolf Tedsen GmbH & Co. KG"],
      "804731" => ["PacketDe", "Packet Design, Inc."],
      "804971" => ["Apple", "Apple Inc"],
      "804F58" => ["Thinkeco", "ThinkEco, Inc."],
      "80501B" => ["Nokia", "Nokia Corporation"],
      "8058C5" => ["NovatecK", "NovaTec Kommunikationstechnik GmbH"],
      "806007" => ["Rim",""],
      "806459" => ["Nimbus", "Nimbus Inc."],
      "8065E9" => ["Benq", "BenQ Corporation"],
      "806629" => ["Prescope", "Prescope Technologies CO.,LTD."],
      "806CBC" => ["NetNewEl", "NET New Electronic Technology GmbH"],
      "80711F" => ["JuniperN", "Juniper Networks"],
      "807693" => ["NewagSa", "Newag SA"],
      "807A7F" => ["AbbGenwa", "ABB Genway Xiamen Electrical Equipment CO., LTD"],
      "807D1B" => ["Neosyste", "Neosystem Co. Ltd."],
      "807DE3" => ["Chongqin", "Chongqing Sichuan Instrument Microcircuit Co.LTD."],
      "8081A5" => ["Tongqing", "TONGQING COMMUNICATION EQUIPMENT (SHENZHEN) Co.,Ltd"],
      "808698" => ["Netronic", "Netronics Technologies Inc."],
      "80912A" => ["LihRongE", "Lih Rong electronic Enterprise Co., Ltd."],
      "8091C0" => ["Agilemes", "AgileMesh, Inc."],
      "809393" => ["Xapt", "Xapt GmbH"],
      "80946C" => ["TokyoRad", "TOKYO RADAR CORPORATION"],
      "8096B1" => ["Motorola", "Motorola Mobility"],
      "80971B" => ["Altenerg", "Altenergy Power System,Inc."],
      "809B20" => ["IntelCor", "Intel Corporate"],
      "80A1D7" => ["Shanghai", "Shanghai DareGlobal Technologies Co.,Ltd"],
      "80AAA4" => ["Usag",""],
      "80AD00" => ["CnetTech", "CNET Technology Inc. (Probably an error, see instead 0080AD)"],
      "80B289" => ["Forworld", "Forworld Electronics Ltd."],
      "80B32A" => ["AlstomGr", "Alstom Grid"],
      "80B686" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "80BAAC" => ["Teleadap", "TeleAdapt Ltd"],
      "80C16E" => ["HewlettP", "Hewlett Packard"],
      "80C63F" => ["RemecBro", "Remec Broadband Wireless , LLC"],
      "80C6AB" => ["Technico", "Technicolor USA Inc."],
      "80C6CA" => ["EndianSR", "Endian s.r.l."],
      "80C862" => ["Openpeak", "Openpeak, Inc"],
      "80CEB1" => ["Theissen", "Theissen Training Systems GmbH"],
      "80D019" => ["Embed", "Embed, Inc"],
      "80D18B" => ["Hangzhou", "Hangzhou I\'converge Technology Co.,Ltd"],
      "80DB31" => ["PowerQuo", "Power Quotient International Co., Ltd."],
      "80EE73" => ["Shuttle", "Shuttle Inc."],
      "80F593" => ["IrcoSist", "IRCO Sistemas de Telecomunicaci n S.A."],
      "80F62E" => ["Hangzhou", "Hangzhou H3C Technologies Co., Limited"],
      "80FB06" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "80FFA8" => ["Unidis",""],
      "8400D2" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "841888" => ["JuniperN", "Juniper Networks"],
      "841B5E" => ["Netgear",""],
      "842141" => ["Shenzhen", "Shenzhen Ginwave Technologies Ltd."],
      "84248D" => ["Motorola", "Motorola Solutions Inc"],
      "8425DB" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "8427CE" => ["OfPresid", "Corporation of the Presiding Bishop of The Church of Jesus Christ of Latter-day Saints"],
      "842914" => ["EmporiaT", "EMPORIA TELECOM Produktions- und VertriebsgesmbH & Co KG"],
      "842999" => ["Apple", "Apple Inc"],
      "842B2B" => ["Dell", "Dell Inc."],
      "842B50" => ["Huria", "Huria Co.,Ltd."],
      "8430E5" => ["Skyhawke", "SkyHawke Technologies, LLC"],
      "843611" => ["Hyungseu", "hyungseul publishing networks"],
      "843A4B" => ["IntelCor", "Intel Corporate"],
      "843F4E" => ["Tri-Tech", "Tri-Tech Manufacturing, Inc."],
      "844823" => ["WoxterTe", "WOXTER TECHNOLOGY Co. Ltd"],
      "844915" => ["VarmourN", "vArmour Networks, Inc."],
      "844BF5" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "845787" => ["DvrC&C", "DVR C&C Co., Ltd."],
      "845DD7" => ["Shenzhen", "Shenzhen Netcom Electronics Co.,Ltd"],
      "846AED" => ["Wireless", "Wireless Tsukamoto.,co.LTD"],
      "846EB1" => ["ParkAssi", "Park Assist LLC"],
      "84742A" => ["Zte", "zte corporation"],
      "847E40" => ["TexasIns", "Texas Instruments"],
      "848D84" => ["Rajant", "Rajant Corporation"],
      "848F69" => ["Dell", "Dell Inc."],
      "849000" => ["Arnold&A", "Arnold &amp; Richter Cine Technik"],
      "8497B8" => ["Memjet", "Memjet Inc."],
      "84A6C8" => ["IntelCor", "Intel Corporate"],
      "84A8E4" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "84A991" => ["CyberTra", "Cyber Trans Japan Co.,Ltd."],
      "84AF1F" => ["BeatSyst", "Beat System Service Co,. Ltd."],
      "84C727" => ["Gnodal", "Gnodal Ltd"],
      "84C7A9" => ["C3poSA", "C3PO S.A."],
      "84C9B2" => ["D-LinkIn", "D-Link International"],
      "84D32A" => ["IeeeP190", "IEEE P1905.1"],
      "84D9C8" => ["Unipatte", "Unipattern Co.,"],
      "84DB2F" => ["SierraWi", "Sierra Wireless Inc"],
      "84DE3D" => ["CrystalV", "Crystal Vision Ltd"],
      "84EA99" => ["Vieworks",""],
      "84F64C" => ["CrossPoi", "Cross Point BV"],
      "881036" => ["PanodicS", "Panodic(ShenZhen) Electronics Limted"],
      "8818AE" => ["Tamron", "Tamron Co., Ltd"],
      "882012" => ["LmiTechn", "LMI Technologies"],
      "8821E3" => ["Nebusens", "Nebusens, S.L."],
      "8823FE" => ["TttechCo", "TTTech Computertechnik AG"],
      "88252C" => ["Arcadyan", "Arcadyan Technology Corporation"],
      "88308A" => ["MurataMa", "Murata Manufactuaring Co.,Ltd."],
      "8841C1" => ["OrbisatD", "ORBISAT DA AMAZONIA IND E AEROL SA"],
      "8843E1" => ["Cisco", "Cisco Systems"],
      "884B39" => ["SiemensH", "Siemens AG, Healthcare Sector"],
      "88532E" => ["IntelCor", "Intel Corporate"],
      "8853D4" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "885C4F" => ["AlcatelL", "Alcatel Lucent"],
      "88615A" => ["SianoMob", "Siano Mobile Silicon Ltd."],
      "886B76" => ["ChinaHop", "CHINA HOPEFUL GROUP HOPEFUL ELECTRIC CO.,LTD"],
      "8886A0" => ["SimtonTe", "Simton Technologies, Ltd."],
      "888717" => ["Canon", "CANON INC."],
      "888B5D" => ["StorageA", "Storage Appliance Corporation"],
      "888C19" => ["BradyAsi", "Brady Corp Asia Pacific Ltd"],
      "8891DD" => ["Racktivi", "Racktivity"],
      "8894F9" => ["GemicomT", "Gemicom Technology, Inc."],
      "8895B9" => ["UnifiedP", "Unified Packet Systems Crop"],
      "889676" => ["TtcMarco", "TTC MARCONI s.r.o."],
      "8897DF" => ["Entrypas", "Entrypass Corporation Sdn. Bhd."],
      "889821" => ["Teraon",""],
      "889FFA" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "88A5BD" => ["Qpcom", "QPCOM INC."],
      "88ACC1" => ["Generito", "Generiton Co., Ltd."],
      "88AE1D" => ["CompalIn", "COMPAL INFORMATION(KUNSHAN)CO.,LTD"],
      "88B168" => ["DeltaCon", "Delta Control GmbH"],
      "88B627" => ["GembirdE", "Gembird Europe BV"],
      "88BA7F" => ["Qfiednet", "Qfiednet Co., Ltd."],
      "88BFD5" => ["SimpleAu", "Simple Audio Ltd"],
      "88C36E" => ["BeijingE", "Beijing Ereneben lnformation Technology Limited"],
      "88C663" => ["Apple", "Apple, Inc."],
      "88DC96" => ["SenaoNet", "SENAO Networks, Inc."],
      "88DD79" => ["Voltaire",""],
      "88E0A0" => ["Shenzhen", "Shenzhen VisionSTOR Technologies Co., Ltd"],
      "88E0F3" => ["JuniperN", "Juniper Networks"],
      "88E712" => ["Whirlpoo", "Whirlpool Corporation"],
      "88E7A6" => ["Iknowled", "iKnowledge Integration Corp."],
      "88E917" => ["Tamaggo",""],
      "88ED1C" => ["CudoComm", "Cudo Communication Co., Ltd."],
      "88F077" => ["Cisco", "Cisco Systems"],
      "88F488" => ["CellonCo", "cellon communications technology(shenzhen)Co.,Ltd."],
      "88FD15" => ["Lineeye", "LINEEYE CO., LTD"],
      "8C0CA3" => ["Amper",""],
      "8C11CB" => ["AbusSecu", "ABUS Security-Center GmbH & Co. KG"],
      "8C1F94" => ["RfSurgic", "RF Surgical System Inc."],
      "8C210A" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "8C271D" => ["Quanthou", "QuantHouse"],
      "8C278A" => ["Vocollec", "Vocollect Inc"],
      "8C3C4A" => ["NakayoTe", "NAKAYO TELECOMMUNICATIONS,INC."],
      "8C4435" => ["Shanghai", "Shanghai BroadMobi Communication Technology Co., Ltd."],
      "8C4DEA" => ["Cerio", "Cerio Corporation"],
      "8C5105" => ["Shenzhen", "Shenzhen ireadygo Information Technology CO.,LTD."],
      "8C53F7" => ["A&DEngin", "A&D ENGINEERING CO., LTD."],
      "8C541D" => ["Lge", "LGE"],
      "8C56C5" => ["Nintendo", "Nintendo Co., Ltd."],
      "8C57FD" => ["LvxWeste", "LVX Western"],
      "8C5877" => ["Apple", "Apple, Inc."],
      "8C598B" => ["CTechnol", "C Technologies AB"],
      "8C5CA1" => ["D-Broad", "d-broad,INC"],
      "8C5FDF" => ["BeijingR", "Beijing Railway Signal Factory"],
      "8C604F" => ["Cisco", "Cisco Systems"],
      "8C640B" => ["BeyondDe", "Beyond Devices d.o.o."],
      "8C6422" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "8C6878" => ["Nortek-A", "Nortek-AS"],
      "8C6AE4" => ["Viogem", "Viogem Limited"],
      "8C705A" => ["IntelCor", "Intel Corporate"],
      "8C71F8" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "8C736E" => ["Fujitsu", "Fujitsu Limited"],
      "8C7712" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "8C7B9D" => ["Apple", "Apple, Inc."],
      "8C7CB5" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "8C7CFF" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "8C7EB3" => ["Lytro", "Lytro, Inc."],
      "8C82A8" => ["InsigmaT", "Insigma Technology Co.,Ltd"],
      "8C8401" => ["Private",""],
      "8C89A5" => ["Micro-St", "Micro-Star INT\'L CO., LTD"],
      "8C8A6E" => ["EstunAut", "ESTUN AUTOMATION TECHNOLOY CO., LTD"],
      "8C8E76" => ["Taskit", "taskit GmbH"],
      "8C90D3" => ["AlcatelL", "Alcatel Lucent"],
      "8C9236" => ["AusLinxT", "Aus.Linx Technology Co., Ltd."],
      "8C94CF" => ["EncellTe", "Encell Technology, Inc."],
      "8CA048" => ["BeijingN", "Beijing NeTopChip Technology Co.,LTD"],
      "8CA982" => ["IntelCor", "Intel Corporate"],
      "8CB64F" => ["Cisco", "Cisco Systems"],
      "8CB82C" => ["IpitomyC", "IPitomy Communications"],
      "8CB864" => ["AcsipTec", "AcSiP Technology Corp."],
      "8CC121" => ["Panasoni", "Panasonic AVC Networks Company"],
      "8CC7AA" => ["RadinetC", "Radinet Communications Inc."],
      "8CC8CD" => ["SamsungE", "Samsung Electronics Co., LTD"],
      "8CCF5C" => ["Befega", "BEFEGA GmbH"],
      "8CD17B" => ["CgMobile", "CG Mobile"],
      "8CD3A2" => ["VissimAs", "VisSim AS"],
      "8CD628" => ["IkorMete", "Ikor Metering"],
      "8CDB25" => ["EsgSolut", "ESG Solutions"],
      "8CDD8D" => ["Wifly-Ci", "Wifly-City System Inc."],
      "8CDE52" => ["IsscTech", "ISSC Technologies Corp."],
      "8CE748" => ["Private",""],
      "8CE7B3" => ["Sonardyn", "Sonardyne International Ltd"],
      "8CF9C9" => ["MesadaTe", "MESADA Technology Co.,Ltd."],
      "8CFABA" => ["Apple", "Apple Inc"],
      "8CFDF0" => ["Qualcomm", "QUALCOMM Incorporated"],
      "90004E" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "90013B" => ["Sagemcom",""],
      "9002A9" => ["Zhejiang", "ZHEJIANG DAHUA TECHNOLOGY CO.,LTD"],
      "9003B7" => ["Parrot",""],
      "900917" => ["Far-Sigh", "Far-sighted mobile"],
      "900A3A" => ["PsgPlast", "PSG Plastic Service GmbH"],
      "900D66" => ["Digimore", "Digimore Electronics Co., Ltd"],
      "90185E" => ["ApexTool", "Apex Tool Group GmbH & Co OHG"],
      "9018AE" => ["Shanghai", "Shanghai Meridian Technologies, Co. Ltd."],
      "901900" => ["ScsSa", "SCS SA"],
      "901B0E" => ["FujitsuT", "Fujitsu Technology Solutions GmbH"],
      "901EDD" => ["GreatCom", "GREAT COMPUTER CORPORATION"],
      "902155" => ["Htc", "HTC Corporation"],
      "9027E4" => ["Apple", "Apple, Inc."],
      "902B34" => ["Giga-Byt", "GIGA-BYTE TECHNOLOGY CO.,LTD."],
      "902E87" => ["Labjack",""],
      "90342B" => ["Gatekeep", "Gatekeeper Systems, Inc."],
      "9034FC" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "903AA0" => ["Alcatel-", "Alcatel-Lucent"],
      "903CAE" => ["YunnanKs", "Yunnan KSEC Digital Technology Co.,Ltd."],
      "903D5A" => ["Shenzhen", "Shenzhen Wision Technology Holding Limited"],
      "903D6B" => ["ZiconTec", "Zicon Technology Corp."],
      "904716" => ["Rorze", "RORZE CORPORATION"],
      "904CE5" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "90507B" => ["Advanced", "Advanced PANMOBIL Systems GmbH & Co. KG"],
      "90513F" => ["Elettron", "Elettronica Santerno"],
      "905446" => ["TesElect", "TES ELECTRONIC SOLUTIONS"],
      "9055AE" => ["Ericsson", "Ericsson, EAB/RWI/K"],
      "905682" => ["Lenbrook", "Lenbrook Industries Limited"],
      "905F8D" => ["Modas", "modas GmbH"],
      "90610C" => ["FidaInte", "Fida International (S) Pte Ltd"],
      "9067B5" => ["Alcatel-", "Alcatel-Lucent"],
      "9067F3" => ["AlcatelL", "Alcatel Lucent"],
      "906DC8" => ["DlgAutom", "DLG AutomacAo Industrial Ltda"],
      "906EBB" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "907025" => ["GareaMic", "Garea Microsys Co.,Ltd."],
      "907F61" => ["ChiconyE", "Chicony Electronics Co., Ltd."],
      "90840D" => ["Apple", "Apple, Inc"],
      "9088A2" => ["IonicsTe", "IONICS TECHNOLOGY ME LTDA"],
      "908D1D" => ["GhTechno", "GH Technologies"],
      "908FCF" => ["UnoSyste", "UNO System Co., Ltd"],
      "90903C" => ["TrisonTe", "TRISON TECHNOLOGY CORPORATION"],
      "909060" => ["RsiVideo", "RSI VIDEO TECHNOLOGIES"],
      "9092B4" => ["DiehlBgt", "Diehl BGT Defence GmbH & Co. KG"],
      "9094E4" => ["D-LinkIn", "D-Link International"],
      "909DE0" => ["NewlandD", "Newland Design + Assoc. Inc."],
      "90A2DA" => ["GheoSa", "GHEO SA"],
      "90A4DE" => ["WistronN", "Wistron Neweb Corp."],
      "90A783" => ["JswPacif", "JSW PACIFIC CORPORATION"],
      "90A7C1" => ["PakedgeD", "Pakedge Device and Software Inc."],
      "90AC3F" => ["Brightsi", "BrightSign LLC"],
      "90B134" => ["Motorola", "Motorola Mobility, Inc."],
      "90B8D0" => ["Joyent", "Joyent, Inc."],
      "90B97D" => ["JohnsonO", "Johnson Outdoors Marine Electronics d/b/a Minnkota"],
      "90C115" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "90CF15" => ["Nokia", "Nokia Corporation"],
      "90CF7D" => ["QingdaoH", "Qingdao Hisense Electric Co.,Ltd."],
      "90D11B" => ["PalomarM", "Palomar Medical Technologies"],
      "90D74F" => ["Bookeen",""],
      "90D7EB" => ["TexasIns", "Texas Instruments"],
      "90D852" => ["Comtec", "Comtec Co., Ltd."],
      "90D92C" => ["Hug-Wits", "HUG-WITSCHI AG"],
      "90E0F0" => ["IeeeP172", "IEEE P1722"],
      "90E2BA" => ["Intel", "Intel Corporation"],
      "90E6BA" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "90EA60" => ["SpiLaser", "SPI Lasers Ltd"],
      "90F278" => ["RadiusGa", "Radius Gateway"],
      "90F4C1" => ["RandMcna", "Rand McNally"],
      "90F652" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "90F72F" => ["Phillips", "Phillips Machine & Welding Co., Inc."],
      "90FB5B" => ["Avaya", "Avaya, Inc"],
      "90FBA6" => ["HonHaiPr", "Hon Hai Precision Ind.Co.Ltd"],
      "940070" => ["Nokia", "Nokia Corporation"],
      "940149" => ["Autohotb", "AutoHotBox"],
      "940B2D" => ["NetviewT", "NetView Technologies(Shenzhen) Co., Ltd"],
      "940C6D" => ["Tp-LinkT", "TP-LINK Technologies Co.,Ltd."],
      "9411DA" => ["ItfFrosc", "ITF Froschl GmbH"],
      "941673" => ["PointCor", "Point Core SARL"],
      "941D1C" => ["TlabWest", "TLab West Systems AB"],
      "942053" => ["Nokia", "Nokia Corporation"],
      "942197" => ["Stalmart", "Stalmart Technology Limited"],
      "94236E" => ["Shenzhen", "Shenzhen Junlan Electronic Ltd"],
      "942E17" => ["Schneide", "Schneider Electric Canada Inc"],
      "942E63" => ["Finsecur",""],
      "94319B" => ["Alphatro", "Alphatronics BV"],
      "9433DD" => ["TacoElec", "Taco Electronic Solutions, Inc."],
      "9439E5" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "943AF0" => ["Nokia", "Nokia Corporation"],
      "944444" => ["LgInnote", "LG Innotek"],
      "944452" => ["BelkinIn", "Belkin International, Inc."],
      "944696" => ["Baudtec", "BaudTec Corporation"],
      "944A09" => ["BitwiseC", "BitWise Controls"],
      "945103" => ["SamsungE", "Samsung Electronics"],
      "94592D" => ["EkeBuild", "EKE Building Technology Systems Ltd"],
      "945B7E" => ["Trilobit", "TRILOBIT LTDA."],
      "946124" => ["Pason", "Pason Systems"],
      "9463D1" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "9471AC" => ["TctMobil", "TCT Mobile Limited"],
      "9481A4" => ["AzurayTe", "Azuray Technologies"],
      "94857A" => ["Evantage", "Evantage Industries Corp"],
      "948854" => ["TexasIns", "Texas Instruments"],
      "948B03" => ["EagetInn", "EAGET Innovation and Technology Co., Ltd."],
      "948D50" => ["BeamexOy", "Beamex Oy Ab"],
      "948FEE" => ["HughesTe", "Hughes Telematics, Inc."],
      "949C55" => ["AltaData", "Alta Data Technologies"],
      "94A7BC" => ["Bodymedi", "BodyMedia, Inc."],
      "94AAB8" => ["JoviewBe", "Joview(Beijing) Technology Co. Ltd."],
      "94AE61" => ["AlcatelL", "Alcatel Lucent"],
      "94BA31" => ["Visionte", "Visiontec da Amazonia Ltda."],
      "94C4E9" => ["Powerlay", "PowerLayer Microsystems HongKong Limited"],
      "94C6EB" => ["NovaElec", "NOVA electronics, Inc."],
      "94C7AF" => ["RayliosT", "Raylios Technology"],
      "94CA0F" => ["Honeywel", "Honeywell Analytics"],
      "94CCB9" => ["Motorola", "Motorola Mobility, Inc."],
      "94CDAC" => ["Creowave", "Creowave Oy"],
      "94D019" => ["Cydle", "Cydle Corp."],
      "94D723" => ["Shanghai", "Shanghai DareGlobal Technologies Co., Ltd"],
      "94D93C" => ["Enelps",""],
      "94DB49" => ["Sitcorp",""],
      "94DBC9" => ["Azurewav", "Azurewave"],
      "94DD3F" => ["A+VLinkT", "A+V Link Technologies, Corp."],
      "94DE0E" => ["Smartopt", "SmartOptics AS"],
      "94DF58" => ["IjElectr", "IJ Electron CO.,Ltd."],
      "94E0D0" => ["Healthst", "HealthStream Taiwan Inc."],
      "94E226" => ["DOrtizCo", "D. ORtiz Consulting, LLC"],
      "94E711" => ["XirkaDam", "Xirka Dama Persada PT"],
      "94E848" => ["FyldeMic", "FYLDE MICRO LTD"],
      "94F692" => ["Geminico", "Geminico co.,Ltd."],
      "94F720" => ["TianjinD", "Tianjin Deviser Electronics Instrument Co., Ltd"],
      "94FAE8" => ["Shenzhen", "Shenzhen Eycom Technology Co., Ltd"],
      "94FD1D" => ["Wherewhe", "WhereWhen Corp"],
      "94FEF4" => ["Sagemcom",""],
      "980284" => ["Theobrom", "Theobroma Systems GmbH"],
      "9803A0" => ["AbbNVPow", "ABB n.v. Power Quality Products"],
      "9803D8" => ["Apple", "Apple, Inc."],
      "980C82" => ["SamsungE", "Samsung Electro Mechanics"],
      "980EE4" => ["Private",""],
      "98262A" => ["AppliedR", "Applied Research Associates, Inc"],
      "98291D" => ["JaguarDe", "Jaguar de Mexico, SA de CV"],
      "98293F" => ["FujianSt", "Fujian Start Computer Equipment Co.,Ltd"],
      "982CBE" => ["2wire",""],
      "982D56" => ["Resoluti", "Resolution Audio"],
      "983000" => ["BeijingK", "Beijing KEMACOM Technologies Co., Ltd."],
      "983571" => ["Sub10", "Sub10 Systems Ltd"],
      "9835B8" => ["Assemble", "Assembled Products Corporation"],
      "984246" => ["SolIndus", "SOL INDUSTRY PTE., LTD"],
      "984A47" => ["ChgHospi", "CHG Hospital Beds"],
      "984B4A" => ["Motorola", "Motorola Mobility Inc."],
      "984BE1" => ["Hewlett-", "Hewlett-Packard Company"],
      "984E97" => ["Starligh", "Starlight Marketing (H. K.) Ltd."],
      "98588A" => ["Sysgrati", "SYSGRATION Ltd."],
      "985945" => ["TexasIns", "Texas Instruments"],
      "985E1B" => ["Conversd", "ConversDigital Co., Ltd."],
      "986022" => ["Emw", "EMW Co., Ltd."],
      "9866EA" => ["Industri", "Industrial Control Communications, Inc."],
      "986DC8" => ["ToshibaM", "TOSHIBA MITSUBISHI-ELECTRIC INDUSTRIAL SYSTEMS CORPORATION"],
      "9873C4" => ["SageElec", "Sage Electronic Engineering LLC"],
      "988217" => ["Disrupti", "Disruptive Ltd"],
      "9889ED" => ["AnademIn", "Anadem Information Inc."],
      "988B5D" => ["SagemCom", "SAGEM COMMUNICATION"],
      "988BAD" => ["Corintec", "Corintech Ltd."],
      "988E34" => ["Zhejiang", "ZHEJIANG BOXSAM ELECTRONIC CO.,LTD"],
      "988EDD" => ["RaychemI", "Raychem International"],
      "989080" => ["Linkpowe", "Linkpower Network System Inc Ltd."],
      "989449" => ["Skyworth", "Skyworth Wireless Technology Ltd."],
      "98A7B0" => ["McstZao", "MCST ZAO"],
      "98AAD7" => ["BlueWave", "BLUE WAVE NETWORKING CO LTD"],
      "98BC57" => ["SvaTechn", "SVA TECHNOLOGIES CO.LTD"],
      "98BC99" => ["Edeltech", "Edeltech Co.,Ltd."],
      "98C845" => ["Packetac", "PacketAccess"],
      "98D686" => ["ChyiLeeI", "Chyi Lee industry Co., ltd."],
      "98D6BB" => ["Apple", "Apple, Inc."],
      "98D88C" => ["NortelNe", "Nortel Networks"],
      "98DCD9" => ["Unitec", "UNITEC Co., Ltd."],
      "98E165" => ["Accutome",""],
      "98E79A" => ["FoxconnN", "Foxconn(NanJing) Communication Co.,Ltd."],
      "98EC65" => ["CosesyAp", "Cosesy ApS"],
      "98F537" => ["Zte", "zte corporation"],
      "98F8DB" => ["MariniIm", "Marini Impianti Industriali s.r.l."],
      "98FC11" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "98FE03" => ["Ericsson", "Ericsson - North America"],
      "9C0111" => ["Shenzhen", "Shenzhen Newabel Electronic Co., Ltd."],
      "9C0298" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "9C066E" => ["HyteraCo", "Hytera Communications Corporation Limited"],
      "9C0DAC" => ["Tymphany", "Tymphany HK Limited"],
      "9C1874" => ["NokiaDan", "Nokia Danmark A/S"],
      "9C1FDD" => ["Accupix", "Accupix Inc."],
      "9C207B" => ["Apple", "Apple Inc"],
      "9C220E" => ["TascanSe", "TASCAN Service GmbH"],
      "9C28BF" => ["Continen", "Continental Automotive Czech Republic s.r.o."],
      "9C31B6" => ["KuliteSe", "Kulite Semiconductor Products Inc"],
      "9C417C" => ["HameTech", "Hame  Technology Co.,  Limited"],
      "9C4563" => ["DimepSis", "DIMEP Sistemas"],
      "9C4A7B" => ["Nokia", "Nokia Corporation"],
      "9C4CAE" => ["MesaLabs", "Mesa Labs"],
      "9C4E20" => ["Cisco", "Cisco Systems"],
      "9C4E36" => ["IntelCor", "Intel Corporate"],
      "9C4E8E" => ["Alt", "ALT Systems Ltd"],
      "9C53CD" => ["EngicamS", "ENGICAM s.r.l."],
      "9C54CA" => ["Zhengzho", "Zhengzhou VCOM Science and Technology Co.,Ltd"],
      "9C55B4" => ["ISESRL", "I.S.E. S.r.l."],
      "9C5711" => ["FeitianX", "Feitian Xunda(Beijing) Aeronautical Information Technology Co., Ltd."],
      "9C5B96" => ["Nmr", "NMR Corporation"],
      "9C5C8D" => ["FiremaxI", "FIREMAX IND STRIA E COM RCIO DE PRODUTOS ELETR NICOS LTDA"],
      "9C5D12" => ["Aerohive", "Aerohive Networks Inc"],
      "9C5D95" => ["VtcElect", "VTC Electronics Corp."],
      "9C5E73" => ["CalibreU", "Calibre UK Ltd"],
      "9C611D" => ["Omni-IdU", "Omni-ID USA, Inc."],
      "9C645E" => ["HarmanCo", "Harman Consumer Group"],
      "9C6ABE" => ["QeesAps", "QEES ApS."],
      "9C7514" => ["WildixSr", "Wildix srl"],
      "9C77AA" => ["Nadasnv",""],
      "9C7BD2" => ["NeolabCo", "NEOLAB Convergence"],
      "9C807D" => ["Syscable", "SYSCABLE Korea Inc."],
      "9C8BF1" => ["Warehous", "The Warehouse Limited"],
      "9C8E99" => ["Hewlett-", "Hewlett-Packard Company"],
      "9C8EDC" => ["Teracom", "Teracom Limited"],
      "9C934E" => ["Xerox", "Xerox Corporation"],
      "9C95F8" => ["Smartdoo", "SmartDoor Systems, LLC"],
      "9CA134" => ["Nike", "Nike, Inc."],
      "9CA3BA" => ["SakuraIn", "SAKURA Internet Inc."],
      "9CADEF" => ["ObihaiTe", "Obihai Technology, Inc."],
      "9CAFCA" => ["Cisco", "Cisco Systems"],
      "9CB008" => ["Ubiquito", "Ubiquitous Computing Technology Corporation"],
      "9CB206" => ["Procente", "PROCENTEC"],
      "9CB70D" => ["LiteonTe", "Liteon Technology Corporation"],
      "9CC077" => ["Printcou", "PrintCounts, LLC"],
      "9CC0D2" => ["Conducti", "Conductix-Wampfler AG"],
      "9CC7A6" => ["Avm", "AVM GmbH"],
      "9CC7D1" => ["Sharp", "SHARP Corporation"],
      "9CCAD9" => ["Nokia", "Nokia Corporation"],
      "9CCD82" => ["ChengUei", "CHENG UEI PRECISION INDUSTRY CO.,LTD"],
      "9CD24B" => ["Zte", "zte corporation"],
      "9CDF03" => ["Harman/B", "Harman/Becker Automotive Systems GmbH"],
      "9CE10E" => ["Nctech", "NCTech Ltd"],
      "9CEBE8" => ["BizlinkK", "BizLink (Kunshan) Co.,Ltd"],
      "9CF61A" => ["UtcFireA", "UTC Fire and Security"],
      "9CF67D" => ["RicardoP", "Ricardo Prague, s.r.o."],
      "9CF938" => ["ArevaNp", "AREVA NP GmbH"],
      "9CFFBE" => ["Otsl", "OTSL Inc."],
      "A00798" => ["SamsungE", "Samsung Electronics"],
      "A007B6" => ["Advanced", "Advanced Technical Support, Inc."],
      "A00BBA" => ["SamsungE", "SAMSUNG ELECTRO-MECHANICS"],
      "A00CA1" => ["Sktb Ski", "SKTB  SKiT"],
      "A0133B" => ["Copyrigh", "Copyright   HiTi Digital, Inc."],
      "A0165C" => ["Tangotec", "TangoTec Ltd."],
      "A01859" => ["Shenzhen", "Shenzhen Yidashi Electronics Co Ltd"],
      "A021B7" => ["Netgear",""],
      "A0231B" => ["Telecomp", "TeleComp R&amp;D Corp."],
      "A02EF3" => ["UnitedIn", "United Integrated Services Co., Led."],
      "A0369F" => ["Intel", "Intel Corporation"],
      "A036FA" => ["EttusRes", "Ettus Research LLC"],
      "A03A75" => ["PssBelgi", "PSS Belgium N.V."],
      "A04025" => ["Actionca", "Actioncable, Inc."],
      "A04041" => ["Samwonfa", "SAMWONFA Co.,Ltd."],
      "A041A7" => ["NlMinist", "NL Ministry of Defense"],
      "A0423F" => ["TyanComp", "Tyan Computer Corp"],
      "A04CC1" => ["Helixtec", "Helixtech Corp."],
      "A04E04" => ["Nokia", "Nokia Corporation"],
      "A051C6" => ["Avaya", "Avaya, Inc"],
      "A055DE" => ["Pace", "Pace plc"],
      "A0593A" => ["VDSVideo", "V.D.S. Video Display Systems srl"],
      "A05AA4" => ["GrandPro", "Grand Products Nevada, Inc."],
      "A05DC1" => ["Tmct", "TMCT Co., LTD."],
      "A05DE7" => ["Directv", "DIRECTV, Inc."],
      "A05E6B" => ["Melper", "MELPER Co., Ltd."],
      "A06986" => ["WellavTe", "Wellav Technologies Ltd"],
      "A06A00" => ["Verilink", "Verilink Corporation"],
      "A06CEC" => ["Rim",""],
      "A06D09" => ["Intelcan", "Intelcan Technosystems Inc."],
      "A06E50" => ["NanotekE", "Nanotek Elektronik Sistemler Ltd. Sti."],
      "A071A9" => ["Nokia", "Nokia Corporation"],
      "A07332" => ["Cashmast", "Cashmaster International Limited"],
      "A07591" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "A078BA" => ["Pantech", "Pantech Co., Ltd."],
      "A082C7" => ["PTI", "P.T.I Co.,LTD"],
      "A086EC" => ["SaehanHi", "SAEHAN HITEC Co., Ltd"],
      "A088B4" => ["IntelCor", "Intel Corporate"],
      "A08C9B" => ["XtremeTe", "Xtreme Technologies Corp"],
      "A090DE" => ["VeedimsL", "VEEDIMS,LLC"],
      "A09805" => ["OpenvoxC", "OpenVox Communication Co Ltd"],
      "A098ED" => ["Shandong", "Shandong Intelligent Optical Communication Development Co., Ltd."],
      "A09A5A" => ["TimeDoma", "Time Domain"],
      "A0A763" => ["Polytron", "Polytron Vertrieb GmbH"],
      "A0AAFD" => ["Erathink", "EraThink Technologies Corp."],
      "A0B3CC" => ["HewlettP", "Hewlett Packard"],
      "A0B5DA" => ["Hongkong", "HongKong THTF Co., Ltd"],
      "A0B662" => ["Acutvist", "Acutvista Innovation Co., Ltd."],
      "A0B9ED" => ["Skytap",""],
      "A0BFA5" => ["Coresys",""],
      "A0C3DE" => ["TritonEl", "Triton Electronic Systems Ltd."],
      "A0CF5B" => ["Cisco", "Cisco Systems"],
      "A0DC04" => ["Becker-A", "Becker-Antriebe GmbH"],
      "A0DDE5" => ["Sharp", "SHARP CORPORATION"],
      "A0DE05" => ["Jsc Irbi", "JSC Irbis-T"],
      "A0E201" => ["AvtraceC", "AVTrace Ltd.(China)"],
      "A0E295" => ["DatSyste", "DAT System Co.,Ltd"],
      "A0E534" => ["StratecB", "Stratec Biomedical AG"],
      "A0E9DB" => ["NingboFr", "Ningbo FreeWings Technologies Co.,Ltd"],
      "A0EF84" => ["SeineIma", "Seine Image Int\'l Co., Ltd"],
      "A0F217" => ["GeMedica", "GE Medical System(China) Co., Ltd."],
      "A0F3C1" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "A0F3E4" => ["Alcatel-", "Alcatel -Lucent IPD"],
      "A0F419" => ["Nokia", "Nokia Corporation"],
      "A0F450" => ["Htc", "HTC Corporation"],
      "A40130" => ["Abisyste", "ABIsystems Co., LTD"],
      "A40BED" => ["CarryTec", "Carry Technology Co.,Ltd"],
      "A40CC3" => ["Cisco", "Cisco Systems"],
      "A4134E" => ["Luxul", "Luxul"],
      "A41875" => ["Cisco", "Cisco Systems"],
      "A41BC0" => ["FastecIm", "Fastec Imaging Corporation"],
      "A4218A" => ["NortelNe", "Nortel Networks"],
      "A424B3" => ["Flatfrog", "FlatFrog Laboratories AB"],
      "A429B7" => ["Bluesky",""],
      "A433D1" => ["Fibrlink", "Fibrlink Communications Co.,Ltd."],
      "A438FC" => ["PlasticL", "Plastic Logic"],
      "A4466B" => ["EocTechn", "EOC Technology"],
      "A446FA" => ["AmtranVi", "AmTRAN Video Corporation"],
      "A44B15" => ["SunCupid", "Sun Cupid Technology (HK) LTD"],
      "A44C11" => ["Cisco", "Cisco Systems"],
      "A45055" => ["BuswareD", "busware.de"],
      "A4526F" => ["AdbBroad", "ADB Broadband Italia"],
      "A4561B" => ["Mcot", "MCOT Corporation"],
      "A45630" => ["Cisco", "Cisco Systems"],
      "A45A1C" => ["Smart-El", "smart-electronic GmbH"],
      "A45C27" => ["Nintendo", "Nintendo Co., Ltd."],
      "A46706" => ["Apple", "Apple, Inc."],
      "A479E4" => ["Klinfo", "KLINFO Corp"],
      "A47AA4" => ["Motorola", "Motorola Mobility, Inc."],
      "A47C14" => ["Chargest", "ChargeStorm AB"],
      "A47C1F" => ["GlobalMi", "Global Microwave Systems Inc."],
      "A4856B" => ["QElectro", "Q Electronics Ltd"],
      "A49005" => ["ChinaGre", "CHINA GREATWALL COMPUTER SHENZHEN CO.,LTD"],
      "A4934C" => ["Cisco", "Cisco Systems"],
      "A497BB" => ["HitachiI", "Hitachi Industrial Equipment Systems Co.,Ltd"],
      "A49947" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "A49981" => ["FujianEl", "FuJian Elite Power Tech CO.,LTD."],
      "A49B13" => ["Burrough", "Burroughs Payment Systems, Inc."],
      "A4A24A" => ["CiscoSpv", "Cisco SPVTG"],
      "A4A80F" => ["Shenzhen", "Shenzhen Coship Electronics Co., Ltd."],
      "A4AD00" => ["Ragsdale", "Ragsdale Technology"],
      "A4ADB8" => ["VitecGro", "Vitec Group, Camera Dynamics Ltd"],
      "A4AE9A" => ["MaestroW", "Maestro Wireless Solutions ltd."],
      "A4B121" => ["Arantia2", "Arantia 2010 S.L."],
      "A4B197" => ["Apple", "Apple, Inc."],
      "A4B1E9" => ["Technico", "Technicolor"],
      "A4B1EE" => ["HZander", "H. ZANDER GmbH & Co. KG"],
      "A4B2A7" => ["AdaxysSo", "Adaxys Solutions AG"],
      "A4B36A" => ["JscSdoCh", "JSC SDO Chromatec"],
      "A4B980" => ["ParkingB", "Parking BOXX Inc."],
      "A4BADB" => ["Dell", "Dell Inc."],
      "A4BE61" => ["Eutrovis", "EutroVision System, Inc."],
      "A4C0E1" => ["Nintendo", "Nintendo Co., Ltd."],
      "A4C2AB" => ["Hangzhou", "Hangzhou LEAD-IT Information & Technology Co.,Ltd"],
      "A4D18F" => ["Shenzhen", "Shenzhen Skyee Optical Fiber Communication Technology Ltd."],
      "A4D1D1" => ["Ecotalit", "ECOtality North America"],
      "A4D1D2" => ["Apple", "Apple, Inc."],
      "A4DA3F" => ["Bionics", "Bionics Corp."],
      "A4DB2E" => ["Kingspan", "Kingspan Environmental Ltd"],
      "A4DE50" => ["TotalWal", "Total Walther GmbH"],
      "A4E32E" => ["Silicon&", "Silicon &amp; Software Systems Ltd."],
      "A4E391" => ["DenyFont", "DENY FONTAINE"],
      "A4E731" => ["Nokia", "Nokia Corporation"],
      "A4E7E4" => ["Connex", "Connex GmbH"],
      "A4ED4E" => ["Motorola", "Motorola Mobility, Inc."],
      "A4EE57" => ["SeikoEps", "SEIKO EPSON CORPORATION"],
      "A4EF52" => ["Telewave", "Telewave Co., Ltd."],
      "A4F7D0" => ["LanAcces", "LAN Accessories Co., Ltd."],
      "A816B2" => ["LgElectr", "LG Electronics"],
      "A81758" => ["Elektron", "Elektronik System i Ume  AB"],
      "A81B18" => ["Xts", "XTS CORP"],
      "A82066" => ["Apple", "Apple Inc"],
      "A826D9" => ["Htc", "HTC Corporation"],
      "A82BD6" => ["ShinaSys", "Shina System Co., Ltd"],
      "A83944" => ["Actionte", "Actiontec Electronics, Inc"],
      "A84041" => ["DraginoT", "Dragino Technology Co., Limited"],
      "A849A5" => ["Lisantec", "Lisantech Co., Ltd."],
      "A854B2" => ["WistronN", "Wistron Neweb Corp."],
      "A8556A" => ["Pocketne", "Pocketnet Technology Inc."],
      "A85BB0" => ["Shenzhen", "Shenzhen Dehoo Technology Co.,Ltd"],
      "A85BF3" => ["Audivo", "Audivo GmbH"],
      "A862A2" => ["Jiwumedi", "JIWUMEDIA CO., LTD."],
      "A863DF" => ["Displ\'Ai", "DISPL\'AIRE CORPORATION"],
      "A863F2" => ["TexasIns", "Texas Instruments"],
      "A865B2" => ["Dongguan", "DONGGUAN YISHANG ELECTRONIC TECHNOLOGY CO., LIMITED"],
      "A86A6F" => ["Rim",""],
      "A870A5" => ["Unicomm", "UniComm Inc."],
      "A8776F" => ["Zonoff",""],
      "A87B39" => ["Nokia", "Nokia Corporation"],
      "A87E33" => ["NokiaDan", "Nokia Danmark A/S"],
      "A88792" => ["Broadban", "Broadband Antenna Tracking Systems"],
      "A887ED" => ["ArcWirel", "ARC Wireless LLC"],
      "A88CEE" => ["Micromad", "MicroMade Galka i Drozdz sp.j."],
      "A8922C" => ["LgElectr", "LG Electronics"],
      "A893E6" => ["JiangxiJ", "JIANGXI JINGGANGSHAN CKING COMMUNICATION TECHNOLOGY CO.,LTD"],
      "A898C6" => ["Shinbo", "Shinbo Co., Ltd."],
      "A8995C" => ["Aizo", "aizo ag"],
      "A89B10" => ["Inmotion", "inMotion Ltd."],
      "A8B0AE" => ["Leoni", "LEONI"],
      "A8B1D4" => ["Cisco", "Cisco Systems"],
      "A8BD1A" => ["HoneyBee", "Honey Bee (Hong Kong) Limited"],
      "A8C222" => ["Tm-Resea", "TM-Research Inc."],
      "A8CB95" => ["EastBest", "EAST BEST CO., LTD."],
      "A8CE90" => ["Cvc",""],
      "A8D0E5" => ["JuniperN", "Juniper Networks"],
      "A8D3C8" => ["Wachendo", "Wachendorff Elektronik  GmbH &amp; Co. KG"],
      "A8E018" => ["Nokia", "Nokia Corporation"],
      "A8E3EE" => ["SonyComp", "Sony Computer Entertainment Inc."],
      "A8EF26" => ["Tritonwa", "Tritonwave"],
      "A8F274" => ["SamsungE", "Samsung Electronics"],
      "A8F470" => ["FujianNe", "Fujian Newland Communication Science Technologies Co.,Ltd."],
      "A8F94B" => ["EltexEnt", "Eltex Enterprise Ltd."],
      "A8FCB7" => ["Consolid", "Consolidated Resource Imaging"],
      "AA0000" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "AA0001" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "AA0002" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "AA0003" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "AA0004" => ["DigitalE", "DIGITAL EQUIPMENT CORPORATION"],
      "AC0142" => ["UrielTec", "Uriel Technologies SIA"],
      "AC02CF" => ["RwTecnol", "RW Tecnologia Industria e Comercio Ltda"],
      "AC02EF" => ["Comsis",""],
      "AC0613" => ["Senselog", "Senselogix Ltd"],
      "AC0A61" => ["LaborSRL", "Labor S.r.L."],
      "AC0DFE" => ["Ekon-Myg", "Ekon GmbH - myGEKKO"],
      "AC1461" => ["Ataw", "ATAW  Co., Ltd."],
      "AC14D2" => ["Wi-Daq", "wi-daq, inc."],
      "AC162D" => ["HewlettP", "Hewlett Packard"],
      "AC199F" => ["SungrowP", "SUNGROW POWER SUPPLY CO.,LTD."],
      "AC20AA" => ["Dmatek", "DMATEK Co., Ltd."],
      "AC2FA8" => ["Humannix", "Humannix Co.,Ltd."],
      "AC319D" => ["Shenzhen", "Shenzhen TG-NET Botone Technology Co.,Ltd."],
      "AC34CB" => ["ShanhaiG", "Shanhai GBCOM Communication Technology Co. Ltd"],
      "AC3D05" => ["Instores", "Instorescreen Aisa"],
      "AC3D75" => ["Hangzhou", "HANGZHOU ZHIWAY TECHNOLOGIES CO.,LTD."],
      "AC3FA4" => ["TaiyoYud", "TAIYO YUDEN CO.,LTD"],
      "AC40EA" => ["C&TSolut", "C&T Solution Inc."],
      "AC44F2" => ["Revolabs", "Revolabs Inc"],
      "AC4723" => ["Genelec",""],
      "AC4AFE" => ["HisenseB", "Hisense Broadband Multimedia Technology Co.,Ltd."],
      "AC4BC8" => ["JuniperN", "Juniper Networks"],
      "AC4FFC" => ["Svs-Vist", "SVS-VISTEK GmbH"],
      "AC5135" => ["MpiTech", "MPI TECH"],
      "AC51EE" => ["Cambridg", "Cambridge Communication Systems Ltd"],
      "AC54EC" => ["IeeeP182", "IEEE P1823 Standards Working Group"],
      "AC583B" => ["HumanAss", "Human Assembler, Inc."],
      "AC5E8C" => ["Utillink",""],
      "AC6123" => ["Drivven", "Drivven, Inc."],
      "AC6706" => ["RuckusWi", "Ruckus Wireless"],
      "AC6F4F" => ["Enspert", "Enspert Inc"],
      "AC6FBB" => ["TatungTe", "TATUNG Technology Inc."],
      "AC6FD9" => ["Valueplu", "Valueplus Inc."],
      "AC7289" => ["IntelCor", "Intel Corporate"],
      "AC7A42" => ["Iconnect", "iConnectivity"],
      "AC80D6" => ["Hexatron", "Hexatronic AB"],
      "AC8112" => ["GemtekTe", "Gemtek Technology Co., Ltd."],
      "AC81F3" => ["Nokia", "Nokia Corporation"],
      "AC8317" => ["Shenzhen", "Shenzhen Furtunetel Communication Co., Ltd"],
      "AC83F0" => ["MagentaV", "Magenta Video Networks"],
      "AC8674" => ["OpenMesh", "Open Mesh, Inc."],
      "AC867E" => ["CreateNe", "Create New Technology (HK) Limited Company"],
      "AC8ACD" => ["RogerDWe", "ROGER D.Wensker, G.Wensker sp.j."],
      "AC932F" => ["Nokia", "Nokia Corporation"],
      "AC9403" => ["Envision", "Envision Peripherals Inc"],
      "AC9A96" => ["LantiqDe", "Lantiq Deutschland GmbH"],
      "AC9B84" => ["SmakTecn", "Smak Tecnologia e Automacao"],
      "AC9CE4" => ["Alcatel-", "Alcatel-Lucent Shanghai Bell Co., Ltd"],
      "ACA016" => ["Cisco", "Cisco Systems"],
      "ACAB8D" => ["LyngsoMa", "Lyngso Marine A/S"],
      "ACBE75" => ["UfineTec", "Ufine Technologies Co.,Ltd."],
      "ACBEB6" => ["Visualed", "Visualedge Technology Co., Ltd."],
      "ACC2EC" => ["CltIntLI", "CLT INT\'L IND. CORP."],
      "ACC698" => ["KohzuPre", "Kohzu Precision Co., Ltd."],
      "ACC935" => ["Ness", "Ness Corporation"],
      "ACCA54" => ["TelldusT", "Telldus Technologies AB"],
      "ACCABA" => ["Midokura", "Midokura Co., Ltd."],
      "ACCB09" => ["HefcomMe", "Hefcom Metering (Pty) Ltd"],
      "ACCC8E" => ["AxisComm", "Axis Communications AB"],
      "ACCE8F" => ["HwaYaoTe", "HWA YAO TECHNOLOGIES CO., LTD"],
      "ACCF23" => ["Hi-Flyin", "Hi-flying electronics technology Co.,Ltd"],
      "ACD180" => ["Crexendo", "Crexendo Business Solutions, Inc."],
      "ACD364" => ["AbbAbbSa", "ABB SPA, ABB SACE DIV."],
      "ACD9D6" => ["Tci", "tci GmbH"],
      "ACDE48" => ["Private",""],
      "ACE348" => ["Madgetec", "MadgeTech, Inc"],
      "ACE87B" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "ACE9AA" => ["Hay", "Hay Systems Ltd"],
      "ACEA6A" => ["GenixInf", "GENIX INFOCOMM CO., LTD."],
      "ACEE3B" => ["6harmoni", "6harmonics Inc"],
      "ACF0B2" => ["BeckerEl", "Becker Electronics Taiwan Ltd."],
      "ACF97E" => ["Elesys", "ELESYS INC."],
      "B01266" => ["Futaba-K", "Futaba-Kikaku"],
      "B01B7C" => ["OntrolAS", "Ontrol A.S."],
      "B01C91" => ["Elim", "Elim Co"],
      "B03829" => ["Siliconw", "Siliconware Precision Industries Co., Ltd."],
      "B0435D" => ["Nuleds", "NuLEDs, Inc."],
      "B0487A" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "B0518E" => ["HollTech", "Holl technology CO.Ltd."],
      "B058C4" => ["Broadcas", "Broadcast Microwave Services, Inc"],
      "B05B1F" => ["ThermoFi", "THERMO FISHER SCIENTIFIC S.P.A."],
      "B05CE5" => ["Nokia", "Nokia Corporation"],
      "B06563" => ["Shanghai", "Shanghai Railway Communication Factory"],
      "B065BD" => ["Apple", "Apple Inc"],
      "B06CBF" => ["3alityDi", "3ality Digital Systems GmbH"],
      "B0750C" => ["QaCafe", "QA Cafe"],
      "B075D5" => ["Zte", "ZTE Corporation"],
      "B07D62" => ["Dipl-Ing", "Dipl.-Ing. H. Horstmann GmbH"],
      "B081D8" => ["I-Sys", "I-sys Corp"],
      "B08991" => ["Lge", "LGE"],
      "B08E1A" => ["Uradio", "URadio Systems Co., Ltd"],
      "B09074" => ["FulanEle", "Fulan Electronics Limited"],
      "B09134" => ["Taleo",""],
      "B0973A" => ["E-Fuel", "E-Fuel Corporation"],
      "B09928" => ["Fujitsu", "Fujitsu Limited"],
      "B09AE2" => ["StemmerI", "STEMMER IMAGING GmbH"],
      "B09BD4" => ["GnhSoftw", "GNH Software India Private Limited"],
      "B0A10A" => ["Pivotal", "Pivotal Systems Corporation"],
      "B0A72A" => ["Ensemble", "Ensemble Designs, Inc."],
      "B0A86E" => ["JuniperN", "Juniper Networks"],
      "B0AA36" => ["Guangdon", "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD."],
      "B0B2DC" => ["ZyxelCom", "Zyxel Communications Corporation"],
      "B0B32B" => ["SlicanSp", "Slican Sp. z o.o."],
      "B0B8D5" => ["NanjingN", "Nanjing Nengrui Auto Equipment CO.,Ltd"],
      "B0BD6D" => ["Echostre", "Echostreams Innovative Solutions"],
      "B0BDA1" => ["ZakladEl", "ZAKLAD ELEKTRONICZNY SIMS"],
      "B0BF99" => ["Wizitdon", "WIZITDONGDO"],
      "B0C69A" => ["JuniperN", "Juniper Networks"],
      "B0C83F" => ["JiangsuC", "Jiangsu Cynray IOT Co., Ltd."],
      "B0C8AD" => ["PeoplePo", "People Power Company"],
      "B0CF4D" => ["Mi-ZoneT", "MI-Zone Technology Ireland"],
      "B0D09C" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "B0D2F5" => ["Vello", "Vello Systems, Inc."],
      "B0E39D" => ["CatSyste", "CAT SYSTEM CO.,LTD."],
      "B0E50E" => ["Nrg", "NRG SYSTEMS INC"],
      "B0E754" => ["2wire",""],
      "B0E892" => ["SeikoEps", "SEIKO EPSON CORPORATION"],
      "B0E97E" => ["Advanced", "Advanced Micro Peripherals"],
      "B0EC71" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "B0F1BC" => ["DhemaxIn", "Dhemax Ingenieros Ltda"],
      "B40142" => ["GciScien", "GCI Science & Technology Co.,LTD"],
      "B40418" => ["Smartchi", "Smartchip Integrated Inc."],
      "B407F9" => ["SamsungE", "SAMSUNG ELECTRO-MECHANICS"],
      "B40832" => ["TcCommun", "TC Communications"],
      "B40B7A" => ["BrusaEle", "Brusa Elektronik AG"],
      "B40C25" => ["PaloAlto", "Palo Alto Networks"],
      "B40E96" => ["Heran", "HERAN"],
      "B40EDC" => ["Lg-Erics", "LG-Ericsson Co.,Ltd."],
      "B41489" => ["Cisco", "Cisco Systems"],
      "B41DEF" => ["Internet", "Internet Laboratories, Inc."],
      "B4211D" => ["BeijingG", "Beijing GuangXin Technology Co., Ltd"],
      "B4218A" => ["DogHunte", "Dog Hunter LLC"],
      "B428F1" => ["E-Prime", "E-Prime Co., Ltd."],
      "B42A39" => ["OrbitMer", "ORBIT MERRET, spol. s r. o."],
      "B42CBE" => ["DirectPa", "Direct Payment Solutions Limited"],
      "B431B8" => ["Aviwest",""],
      "B43564" => ["FujianTi", "Fujian Tian Cheng Electron Science & Technical Development Co.,Ltd."],
      "B435F7" => ["Zhejiang", "Zhejiang Pearmain Electronics Co.ltd."],
      "B43741" => ["Consert", "Consert, Inc."],
      "B439D6" => ["Procurve", "ProCurve Networking by HP"],
      "B43DB2" => ["Degreane", "Degreane Horizon"],
      "B4417A" => ["Shenzhen", "ShenZhen Gongjin Electronics Co.,Ltd"],
      "B44CC2" => ["NrElectr", "NR ELECTRIC CO., LTD"],
      "B451F9" => ["NbSoftwa", "NB Software"],
      "B45253" => ["SeagateT", "Seagate Technology"],
      "B45570" => ["Borea",""],
      "B45861" => ["CremoteL", "CRemote, LLC"],
      "B45CA4" => ["Thing-Ta", "Thing-talk Wireless Communication Technologies Corporation Limited"],
      "B46238" => ["Exablox",""],
      "B46293" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "B467E9" => ["QingdaoG", "Qingdao GoerTek Technology Co., Ltd."],
      "B4749F" => ["AskeyCom", "askey computer corp"],
      "B48255" => ["Research", "Research Products Corporation"],
      "B482C5" => ["Relay2", "Relay2, Inc."],
      "B482FE" => ["AskeyCom", "Askey Computer Corp"],
      "B48910" => ["CosterTE", "Coster T.E. S.P.A."],
      "B4944E" => ["Weteleco", "WeTelecom Co., Ltd."],
      "B499BA" => ["Hewlett-", "Hewlett-Packard Company"],
      "B49EE6" => ["Shenzhen", "SHENZHEN TECHNOLOGY CO LTD"],
      "B4A4B5" => ["ZenEye", "Zen Eye Co.,Ltd"],
      "B4A4E3" => ["Cisco", "Cisco Systems"],
      "B4A5A9" => ["Modi", "MODI GmbH"],
      "B4AA4D" => ["Ensequen", "Ensequence, Inc."],
      "B4B017" => ["Avaya", "Avaya, Inc"],
      "B4B362" => ["Zte", "ZTE Corporation"],
      "B4B52F" => ["HewlettP", "Hewlett Packard"],
      "B4B5AF" => ["MinsungE", "Minsung Electronics"],
      "B4B676" => ["IntelCor", "Intel Corporate"],
      "B4B88D" => ["Thuh", "Thuh Company"],
      "B4C44E" => ["VxlEtech", "VXL eTech Pvt Ltd"],
      "B4C799" => ["Motorola", "Motorola Solutions Inc."],
      "B4C810" => ["UmpiElet", "UMPI Elettronica"],
      "B4CFDB" => ["Shenzhen", "Shenzhen Jiuzhou Electric Co.,LTD"],
      "B4D8A9" => ["Betterbo", "BetterBots"],
      "B4D8DE" => ["IotaComp", "iota Computing, Inc."],
      "B4E0CD" => ["IoTurbin", "IO Turbine, Inc."],
      "B4E1EB" => ["Private",""],
      "B4ED19" => ["PieDigit", "Pie Digital, Inc."],
      "B4ED54" => ["WohlerTe", "Wohler Technologies"],
      "B4EED4" => ["TexasIns", "Texas Instruments"],
      "B4F323" => ["Petatel", "PETATEL INC."],
      "B4FC75" => ["SemaElec", "SEMA Electronics(HK) CO.,LTD"],
      "B80305" => ["IntelCor", "Intel Corporate"],
      "B80B9D" => ["RopexInd", "ROPEX Industrie-Elektronik GmbH"],
      "B81413" => ["KeenHigh", "Keen High Holding(HK) Ltd."],
      "B817C2" => ["Apple", "Apple, Inc."],
      "B81999" => ["Nesys",""],
      "B820E7" => ["Guangzho", "Guangzhou Horizontal Information & Network Integration Co. Ltd"],
      "B82410" => ["MagnetiM", "Magneti Marelli Slovakia s.r.o."],
      "B826D4" => ["Furukawa", "Furukawa Industrial S.A. Produtos El tricos"],
      "B827EB" => ["Raspberr", "Raspberry Pi Foundation"],
      "B8288B" => ["ParkerHa", "Parker Hannifin"],
      "B82ADC" => ["EfrEurop", "EFR Europ ische Funk-Rundsteuerung GmbH"],
      "B82CA0" => ["Honeywel", "Honeywell HomMed"],
      "B83A7B" => ["Worldpla", "Worldplay (Canada) Inc."],
      "B83D4E" => ["Shenzhen", "Shenzhen Cultraview Digital Technology Co.,Ltd Shanghai Branch"],
      "B8415F" => ["Asp", "ASP AG"],
      "B85510" => ["ZioncomE", "Zioncom Electronics (Shenzhen) Ltd."],
      "B8616F" => ["AcctonWi", "Accton Wireless Broadband(AWB), Corp."],
      "B8621F" => ["Cisco", "Cisco Systems"],
      "B86491" => ["CkTeleco", "CK Telecom Ltd"],
      "B8653B" => ["Bolymin", "Bolymin, Inc."],
      "B86B23" => ["Toshiba",""],
      "B870F4" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD."],
      "B87424" => ["Viessman", "Viessmann Elektronik GmbH"],
      "B87447" => ["Converge", "Convergence Technologies"],
      "B8797E" => ["SecureMe", "Secure Meters (UK) Limited"],
      "B8871E" => ["GoodMind", "Good Mind Industries Co., Ltd."],
      "B888E3" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD"],
      "B88D12" => ["Apple", "Apple, Inc."],
      "B88E3A" => ["Infinite", "Infinite Technologies JLT"],
      "B88F14" => ["Analytic", "Analytica GmbH"],
      "B8921D" => ["BgT&Amp;", "BG T&amp;A"],
      "B894D2" => ["RetailIn", "Retail Innovation HTT AB"],
      "B89674" => ["Alldsp&A", "AllDSP GmbH &amp; Co. KG"],
      "B8975A" => ["BiostarM", "BIOSTAR Microtech Int\'l Corp."],
      "B89AED" => ["Oceanser", "OceanServer Technology, Inc"],
      "B89BC9" => ["SmcNetwo", "SMC Networks Inc"],
      "B8A386" => ["D-LinkIn", "D-Link International"],
      "B8A3E0" => ["BenruiTe", "BenRui Technology Co.,Ltd"],
      "B8A8AF" => ["LogicSPA", "Logic S.p.A."],
      "B8AC6F" => ["Dell", "Dell Inc"],
      "B8AF67" => ["Hewlett-", "Hewlett-Packard Company"],
      "B8B1C7" => ["Bt&Com", "BT&COM CO.,LTD"],
      "B8B42E" => ["GioneeCo", "Gionee Communication Equipment Co,Ltd.ShenZhen"],
      "B8B94E" => ["Shenzhen", "Shenzhen iBaby Labs, Inc."],
      "B8BA68" => ["XiAnJizh", "Xi\'an Jizhong Digital Communication Co.,Ltd"],
      "B8BA72" => ["Cynove",""],
      "B8BB6D" => ["Eneres", "ENERES Co.,Ltd."],
      "B8BEBF" => ["Cisco", "Cisco Systems"],
      "B8C716" => ["Fiberhom", "Fiberhome Telecommunication Technologies Co.,LTD"],
      "B8C75D" => ["Apple", "Apple, Inc."],
      "B8CDA7" => ["MaxelerT", "Maxeler Technologies Ltd."],
      "B8D06F" => ["Guangzho", "GUANGZHOU HKUST FOK YING TUNG RESEARCH INSTITUTE"],
      "B8D49D" => ["MSevenSy", "M Seven System Ltd."],
      "B8D9CE" => ["SamsungE", "Samsung Electronics"],
      "B8DAF7" => ["Advanced", "Advanced Photonics, Inc."],
      "B8E589" => ["PayterBv", "Payter BV"],
      "B8E625" => ["2wire",""],
      "B8E779" => ["9solutio", "9Solutions Oy"],
      "B8E937" => ["Sonos", "Sonos, Inc."],
      "B8EE79" => ["YwireTec", "YWire Technologies, Inc."],
      "B8F4D0" => ["Herrmann", "Herrmann Ultraschalltechnik GmbH & Co. Kg"],
      "B8F5E7" => ["Waytools", "WayTools, LLC"],
      "B8F6B1" => ["Apple", "Apple, Inc."],
      "B8F732" => ["AryakaNe", "Aryaka Networks Inc"],
      "B8F934" => ["SonyEric", "Sony Ericsson Mobile Communications AB"],
      "B8FD32" => ["Zhejiang", "Zhejiang ROICX Microelectronics"],
      "B8FF61" => ["Apple", "Apple, Inc."],
      "B8FF6F" => ["Shanghai", "Shanghai Typrotech Technology Co.Ltd"],
      "B8FFFE" => ["TexasIns", "Texas Instruments"],
      "BC0200" => ["StewartA", "Stewart Audio"],
      "BC0543" => ["Avm", "AVM GmbH"],
      "BC0DA5" => ["TexasIns", "Texas Instruments"],
      "BC0F2B" => ["FortuneT", "FORTUNE TECHGROUP CO.,LTD"],
      "BC125E" => ["BeijingW", "Beijing  WisVideo  INC."],
      "BC1401" => ["HitronTe", "Hitron Technologies. Inc"],
      "BC15A6" => ["TaiwanJa", "Taiwan Jantek Electronics,Ltd."],
      "BC20BA" => ["InspurSh", "Inspur (Shandong) Electronic Information Co., Ltd"],
      "BC2846" => ["NextbitC", "NextBIT Computing Pvt. Ltd."],
      "BC28D6" => ["RowleyAs", "Rowley Associates Limited"],
      "BC2C55" => ["BearFlag", "Bear Flag Design, Inc."],
      "BC305B" => ["Dell", "Dell Inc."],
      "BC35E5" => ["Hydro", "Hydro Systems Company"],
      "BC38D2" => ["Pandachi", "Pandachip Limited"],
      "BC3E13" => ["Accordan", "Accordance Systems Inc."],
      "BC4377" => ["HangZhou", "Hang Zhou Huite Technology Co.,ltd."],
      "BC4760" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "BC4B79" => ["Sensingt", "SensingTek"],
      "BC4E3C" => ["CoreStaf", "CORE STAFF CO., LTD."],
      "BC52B7" => ["Apple", "Apple Inc"],
      "BC5FF4" => ["AsrockIn", "ASRock Incorporation"],
      "BC6778" => ["Apple", "Apple Inc"],
      "BC6784" => ["Environi", "Environics Oy"],
      "BC6A16" => ["Tdvine",""],
      "BC6A29" => ["TexasIns", "Texas Instruments"],
      "BC6E76" => ["GreenEne", "Green Energy Options Ltd"],
      "BC71C1" => ["Xtrillio", "XTrillion, Inc."],
      "BC764E" => ["Rackspac", "Rackspace US, Inc."],
      "BC7670" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "BC7737" => ["IntelCor", "Intel Corporate"],
      "BC779F" => ["Sbm", "SBM Co., Ltd."],
      "BC7DD1" => ["RadioDat", "Radio Data Comms"],
      "BC811F" => ["Ingate", "Ingate Systems"],
      "BC8199" => ["Basic", "BASIC Co.,Ltd."],
      "BC83A7" => ["Shenzhen", "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LT"],
      "BC851F" => ["SamsungE", "Samsung Electronics"],
      "BC8B55" => ["NppEliks", "NPP ELIKS America Inc. DBA T&M Atlantic"],
      "BC99BC" => ["FonseeTe", "FonSee Technology Inc."],
      "BC9DA5" => ["DascomEu", "DASCOM Europe GmbH"],
      "BCA4E1" => ["Nabto",""],
      "BCA9D6" => ["Cyber-Ra", "Cyber-Rain, Inc."],
      "BCAEC5" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "BCB181" => ["Sharp", "SHARP CORPORATION"],
      "BCB1F3" => ["SamsungE", "Samsung Electronics"],
      "BCB852" => ["Cybera", "Cybera, Inc."],
      "BCBBC9" => ["Kellendo", "Kellendonk Elektronik GmbH"],
      "BCC168" => ["DinboxSv", "DInBox Sverige AB"],
      "BCC23A" => ["ThomsonV", "Thomson Video Networks"],
      "BCC61A" => ["SpectraE", "SPECTRA EMBEDDED SYSTEMS"],
      "BCC810" => ["CiscoSpv", "Cisco SPVTG"],
      "BCCD45" => ["Voismart",""],
      "BCD5B6" => ["D2dTechn", "d2d technologies"],
      "BCD940" => ["Asr", "ASR Co,.Ltd."],
      "BCE09D" => ["Eoslink",""],
      "BCE59F" => ["Waterwor", "WATERWORLD Technology Co.,LTD"],
      "BCEA2B" => ["Citycom", "CityCom GmbH"],
      "BCF2AF" => ["Devolo", "devolo AG"],
      "BCF685" => ["D-LinkIn", "D-Link International"],
      "BCFE8C" => ["Altronic", "Altronic, LLC"],
      "BCFFAC" => ["Topcon", "TOPCON CORPORATION"],
      "C00000" => ["WesternD", "Western Digital (may be reversed 00 00 C0?)"],
      "C00D7E" => ["Additech", "Additech, Inc."],
      "C01242" => ["AlphaSec", "Alpha Security Products"],
      "C0143D" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "C01885" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "C01E9B" => ["PixaviAs", "Pixavi AS"],
      "C02250" => ["Private",""],
      "C02506" => ["Avm", "AVM GmbH"],
      "C027B9" => ["BeijingN", "Beijing National Railway Research & Design Institute  of Signal & Communication"],
      "C02973" => ["Audyssey", "Audyssey Laboratories Inc."],
      "C029F3" => ["Xysystem",""],
      "C02BFC" => ["InesAppl", "iNES. applied informatics GmbH"],
      "C02C7A" => ["ShenZhen", "Shen Zhen Horn audio Co., Ltd."],
      "C035BD" => ["Velocyte", "Velocytech Aps"],
      "C038F9" => ["NokiaDan", "Nokia Danmark A/S"],
      "C03B8F" => ["MinicomD", "Minicom Digital Signage"],
      "C03F0E" => ["Netgear",""],
      "C03F2A" => ["Biscotti", "Biscotti, Inc."],
      "C041F6" => ["LgElectr", "LG Electronics Inc"],
      "C0493D" => ["Maitrise", "MAITRISE TECHNOLOGIQUE"],
      "C058A7" => ["Pico", "Pico Systems Co., Ltd."],
      "C05E79" => ["Shenzhen", "SHENZHEN HUAXUN ARK TECHNOLOGIES CO.,LTD"],
      "C0626B" => ["Cisco", "Cisco Systems"],
      "C06C0F" => ["DobbsSta", "Dobbs Stanford"],
      "C07E40" => ["Shenzhen", "SHENZHEN XDK COMMUNICATION EQUIPMENT CO.,LTD"],
      "C08170" => ["EffigisG", "Effigis GeoSolutions"],
      "C0830A" => ["2wire",""],
      "C0847A" => ["Apple", "Apple, Inc."],
      "C08ADE" => ["RuckusWi", "Ruckus Wireless"],
      "C08B6F" => ["SISistem", "S I Sistemas Inteligentes Eletronicos Ltda"],
      "C09132" => ["PatriotM", "Patriot Memory"],
      "C09134" => ["Procurve", "ProCurve Networking by HP"],
      "C09C92" => ["Coby",""],
      "C09F42" => ["Apple", "Apple Inc"],
      "C0A0DE" => ["MultiTou", "Multi Touch Oy"],
      "C0A26D" => ["AbbottPo", "Abbott Point of Care"],
      "C0A364" => ["3dBurlin", "3D Systems Burlington"],
      "C0AC54" => ["Sagemcom",""],
      "C0B357" => ["YoshikiE", "Yoshiki Electronics Industry Ltd."],
      "C0BAE6" => ["Applicat", "Application Solutions (Safety and Security) Ltd"],
      "C0BD42" => ["ZpaSmart", "ZPA Smart Energy a.s."],
      "C0C1C0" => ["Cisco-Li", "Cisco-Linksys, LLC"],
      "C0C520" => ["RuckusWi", "Ruckus Wireless"],
      "C0C946" => ["MitsuyaL", "MITSUYA LABORATORIES INC."],
      "C0CB38" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "C0CFA3" => ["Creative", "Creative Electronics &amp; Software, Inc."],
      "C0D044" => ["Sagemcom",""],
      "C0D962" => ["AskeyCom", "Askey Computer Corp."],
      "C0DF77" => ["ConradEl", "Conrad Electronic SE"],
      "C0E422" => ["TexasIns", "Texas Instruments"],
      "C0E54E" => ["DenxComp", "DENX Computer Systems GmbH"],
      "C0EAE4" => ["Sonicwal", "Sonicwall"],
      "C0F8DA" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "C40142" => ["Maxmedia", "MaxMedia Technology Limited"],
      "C4017C" => ["RuckusWi", "Ruckus Wireless"],
      "C401B1" => ["Seektech", "SeekTech INC"],
      "C40ACB" => ["Cisco", "Cisco Systems"],
      "C40F09" => ["HermesEl", "Hermes electronic GmbH"],
      "C4108A" => ["RuckusWi", "Ruckus Wireless"],
      "C416FA" => ["Prysm", "Prysm Inc"],
      "C417FE" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "C4198B" => ["Dominion", "Dominion Voting Systems Corporation"],
      "C41ECE" => ["HmiSourc", "HMI Sources Ltd."],
      "C4237A" => ["Whiznets", "WhizNets Inc."],
      "C4242E" => ["Galvanic", "Galvanic Applied Sciences Inc"],
      "C42C03" => ["Apple", "Apple, Inc."],
      "C436DA" => ["Rustelet", "Rusteletech Ltd."],
      "C438D3" => ["Tagatec", "TAGATEC CO.,LTD"],
      "C4393A" => ["SmcNetwo", "SMC Networks Inc"],
      "C43A9F" => ["Siconix", "Siconix Inc."],
      "C43C3C" => ["CybelecS", "CYBELEC SA"],
      "C43DC7" => ["Netgear",""],
      "C44619" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "C44AD0" => ["Fireflie", "FIREFLIES RTLS"],
      "C44B44" => ["Omniprin", "Omniprint Inc."],
      "C455A6" => ["CadacHol", "Cadac Holdings Ltd"],
      "C455C2" => ["Bach-Sim", "Bach-Simpson"],
      "C45600" => ["GalleonE", "Galleon Embedded Computing"],
      "C45976" => ["Fugoo",""],
      "C46044" => ["EverexEl", "Everex Electronics Limited"],
      "C46354" => ["U-Raku", "U-Raku, Inc."],
      "C46413" => ["Cisco", "Cisco Systems"],
      "C467B5" => ["Libraton", "Libratone A/S"],
      "C46AB7" => ["XiaomiTe", "Xiaomi Technology,Inc."],
      "C47130" => ["FonTechn", "Fon Technology S.L."],
      "C471FE" => ["Cisco", "Cisco Systems"],
      "C4731E" => ["SamsungE", "Samsung Eletronics Co., Ltd"],
      "C47B2F" => ["BeijingJ", "Beijing JoinHope Image Technology Ltd."],
      "C47BA3" => ["Navis", "NAVIS Inc."],
      "C47D4F" => ["Cisco", "Cisco Systems"],
      "C4823F" => ["FujianNe", "Fujian Newland Auto-ID Tech. Co,.Ltd."],
      "C48508" => ["Intel", "Intel Corporation"],
      "C49300" => ["8devices",""],
      "C49313" => ["100fioNe", "100fio networks technology llc"],
      "C495A2" => ["Shenzhen", "SHENZHEN WEIJIU INDUSTRY AND TRADE DEVELOPMENT CO., LTD"],
      "C49805" => ["MinieumN", "Minieum Networks, Inc"],
      "C4AAA1" => ["SummitDe", "SUMMIT DEVELOPMENT, spol.s r.o."],
      "C4B512" => ["GeneralE", "General Electric Digital Energy"],
      "C4BA99" => ["I+MeActi", "I+ME Actia Informatik und Mikro-Elektronik GmbH"],
      "C4C19F" => ["National", "National Oilwell Varco Instrumentation, Monitoring, and Optimization (NOV IMO)"],
      "C4CAD9" => ["Hangzhou", "Hangzhou H3C Technologies Co., Limited"],
      "C4CD45" => ["BeijingB", "Beijing Boomsense Technology CO.,LTD."],
      "C4D489" => ["JiangsuJ", "JiangSu Joyque Information Industry Co.,Ltd"],
      "C4D987" => ["IntelCor", "Intel Corporate"],
      "C4E17C" => ["U2s", "U2S co."],
      "C4EEAE" => ["VssMonit", "VSS Monitoring"],
      "C4EEF5" => ["Oclaro", "Oclaro, Inc."],
      "C4F464" => ["SpicaInt", "Spica international"],
      "C4F57C" => ["BrocadeC", "Brocade Communications Systems, Inc."],
      "C4FCE4" => ["DishtvNz", "DishTV NZ Ltd"],
      "C802A6" => ["BeijingN", "Beijing Newmine Technology"],
      "C80718" => ["Tdsi",""],
      "C80AA9" => ["QuantaCo", "Quanta Computer Inc."],
      "C80E77" => ["LeShiZhi", "Le Shi Zhi Xin Electronic Technology (Tianjin)  Co.,Ltd"],
      "C819F7" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "C81AFE" => ["Dlogic", "DLOGIC GmbH"],
      "C81E8E" => ["AdvSecur", "ADV Security (S) Pte Ltd"],
      "C8208E" => ["Storaged", "Storagedata"],
      "C8292A" => ["BarunEle", "Barun Electronics"],
      "C82A14" => ["Apple", "Apple, Inc"],
      "C82E94" => ["HalfaEnt", "Halfa Enterprise Co., Ltd."],
      "C83232" => ["HuntingI", "Hunting Innova"],
      "C8334B" => ["Apple", "Apple, Inc."],
      "C835B8" => ["Ericsson", "Ericsson, EAB/RWI/K"],
      "C83A35" => ["TendaTec", "Tenda Technology Co., Ltd."],
      "C83B45" => ["Jri-Maxa", "JRI-Maxant"],
      "C83E99" => ["TexasIns", "Texas Instruments"],
      "C83EA7" => ["Kunbus", "KUNBUS GmbH"],
      "C84529" => ["ImkNetwo", "IMK Networks Co.,Ltd"],
      "C84544" => ["Shanghai", "Shanghai Enlogic Electric Technology Co., Ltd."],
      "C848F5" => ["MedisonX", "MEDISON Xray Co., Ltd"],
      "C84C75" => ["Cisco", "Cisco Systems"],
      "C85645" => ["Intermas", "Intermas France"],
      "C86000" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "C864C7" => ["Zte", "zte corporation"],
      "C86C1E" => ["Display", "Display Systems Ltd"],
      "C86C87" => ["ZyxelCom", "Zyxel Communications Corp"],
      "C86CB6" => ["Optcom", "Optcom Co., Ltd."],
      "C87248" => ["AplicomO", "Aplicom Oy"],
      "C87B5B" => ["Zte", "zte corporation"],
      "C87CBC" => ["Valink", "Valink Co., Ltd."],
      "C87D77" => ["Shenzhen", "Shenzhen Kingtech Communication Equipment Co.,Ltd"],
      "C87E75" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "C88439" => ["SunriseT", "Sunrise Technologies"],
      "C88447" => ["Beautifu", "Beautiful Enterprise Co., Ltd"],
      "C8873B" => ["NetOptic", "Net Optics"],
      "C88B47" => ["OpticosS", "Opticos s.r.l."],
      "C8903E" => ["PaktonTe", "Pakton Technologies"],
      "C89383" => ["Embedded", "Embedded Automation, Inc."],
      "C894D2" => ["JiangsuD", "Jiangsu Datang  Electronic Products Co., Ltd"],
      "C8979F" => ["Nokia", "Nokia Corporation"],
      "C89C1D" => ["Cisco", "Cisco Systems"],
      "C89CDC" => ["Elitegro", "ELITEGROUP COMPUTER SYSTEM CO., LTD."],
      "C89F42" => ["VdiiInno", "VDII Innovation AB"],
      "C8A1B6" => ["Shenzhen", "Shenzhen Longway Technologies Co., Ltd"],
      "C8A1BA" => ["Neul", "Neul Ltd"],
      "C8A620" => ["Nebula", "Nebula, Inc"],
      "C8A70A" => ["VerizonB", "Verizon Business"],
      "C8A729" => ["Systroni", "SYStronics Co., Ltd."],
      "C8AA21" => ["Motorola", "Motorola Mobility, Inc."],
      "C8AACC" => ["Private",""],
      "C8AE9C" => ["Shanghai", "Shanghai TYD Elecronic Technology Co. Ltd"],
      "C8AF40" => ["MarcoSys", "marco Systemanalyse und Entwicklung GmbH"],
      "C8BBD3" => ["Embrane",""],
      "C8BCC8" => ["Apple", "Apple, Inc."],
      "C8BE19" => ["D-LinkIn", "D-Link International"],
      "C8C126" => ["ZpmIndus", "ZPM Industria e Comercio Ltda"],
      "C8C13C" => ["Ruggedte", "RuggedTek Hangzhou Co., Ltd"],
      "C8CD72" => ["Sagemcom",""],
      "C8D15E" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "C8D1D1" => ["AgaitTec", "AGAiT Technology Corporation"],
      "C8D2C1" => ["JetlunSh", "Jetlun (Shenzhen) Corporation"],
      "C8D5FE" => ["Shenzhen", "Shenzhen Zowee Technology Co., Ltd"],
      "C8D719" => ["CiscoCon", "Cisco Consumer Products, LLC"],
      "C8DE51" => ["IntegraN", "Integra Networks, Inc."],
      "C8DF7C" => ["Nokia", "Nokia Corporation"],
      "C8EE08" => ["TangtopT", "TANGTOP TECHNOLOGY CO.,LTD"],
      "C8EF2E" => ["BeijingG", "Beijing Gefei Tech. Co., Ltd"],
      "C8F406" => ["Avaya", "Avaya, Inc"],
      "C8F704" => ["Building", "Building Block Video"],
      "C8F733" => ["IntelCor", "Intel Corporate"],
      "C8F981" => ["SenecaSR", "Seneca s.r.l."],
      "C8F9F9" => ["Cisco", "Cisco Systems"],
      "C8FE30" => ["BejingDa", "Bejing DAYO Mobile Communication Technology Ltd."],
      "CC0080" => ["TrustSys", "TRUST SYSTEM Co.,"],
      "CC051B" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "CC08E0" => ["Apple", "Apple, Inc."],
      "CC09C8" => ["Imaqliq", "IMAQLIQ LTD"],
      "CC0CDA" => ["Miljovak", "Miljovakt AS"],
      "CC14A6" => ["YichunMy", "Yichun MyEnergy Domain, Inc"],
      "CC187B" => ["Manzanit", "Manzanita Systems, Inc."],
      "CC1EFF" => ["Metrolog", "Metrological Group BV"],
      "CC2218" => ["Innodigi", "InnoDigital Co., Ltd."],
      "CC34D7" => ["GewissSP", "GEWISS S.P.A."],
      "CC43E3" => ["TrumpSA", "Trump s.a."],
      "CC501C" => ["KvhIndus", "KVH Industries, Inc."],
      "CC5076" => ["OcomComm", "Ocom Communications, Inc."],
      "CC52AF" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "CC5459" => ["OntimeNe", "OnTime Networks AS"],
      "CC55AD" => ["Rim",""],
      "CC5C75" => ["Weightec", "Weightech Com. Imp. Exp. Equip. Pesagem Ltda"],
      "CC5D4E" => ["ZyxelCom", "ZyXEL Communications Corporation"],
      "CC60BB" => ["EmpowerR", "Empower RF Systems"],
      "CC69B0" => ["GlobalTr", "Global Traffic Technologies, LLC"],
      "CC6B98" => ["MinetecW", "Minetec Wireless Technologies"],
      "CC6BF1" => ["SoundMas", "Sound Masking Inc."],
      "CC6DA0" => ["Roku", "Roku, Inc."],
      "CC6DEF" => ["TjkTieto", "TJK Tietolaite Oy"],
      "CC7669" => ["Seetech",""],
      "CC7A30" => ["CmaxWire", "CMAX Wireless Co., Ltd."],
      "CC7D37" => ["Motorola", "Motorola Mobility, Inc."],
      "CC7EE7" => ["Panasoni", "Panasonic AVC Networks Company"],
      "CC8CE3" => ["TexasIns", "Texas Instruments"],
      "CC9093" => ["HansongT", "Hansong Tehnologies"],
      "CC912B" => ["TeConnec", "TE Connectivity Touch Solutions"],
      "CC944A" => ["Pfeiffer", "Pfeiffer Vacuum GmbH"],
      "CC96A0" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "CC9E00" => ["Nintendo", "Nintendo Co., Ltd."],
      "CCA374" => ["Guangdon", "Guangdong Guanglian Electronic Technology Co.Ltd"],
      "CCAF78" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "CCB255" => ["D-LinkIn", "D-Link International"],
      "CCB55A" => ["Fraunhof", "Fraunhofer ITWM"],
      "CCB888" => ["AnbSecur", "AnB Securite s.a."],
      "CCB8F1" => ["EagleKin", "EAGLE KINGDOM TECHNOLOGIES LIMITED"],
      "CCBE71" => ["Optilogi", "OptiLogix BV"],
      "CCC104" => ["AppliedT", "Applied Technical Systems"],
      "CCC50A" => ["Shenzhen", "SHENZHEN DAJIAHAO TECHNOLOGY CO.,LTD"],
      "CCC62B" => ["Tri-Syst", "Tri-Systems Corporation"],
      "CCC8D7" => ["CiasElet", "CIAS Elettronica srl"],
      "CCCC4E" => ["SunFount", "Sun Fountainhead USA. Corp"],
      "CCCC81" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "CCCD64" => ["Sm-Elect", "SM-Electronic GmbH"],
      "CCCE40" => ["Janteq", "Janteq Corp"],
      "CCD811" => ["AiconnTe", "Aiconn Technology Corporation"],
      "CCD9E9" => ["ScrEngin", "SCR Engineers Ltd."],
      "CCE7DF" => ["American", "American Magnetics, Inc."],
      "CCEA1C" => ["Dconwork", "DCONWORKS  Co., Ltd"],
      "CCEED9" => ["DetoMech", "Deto Mechatronic GmbH"],
      "CCEF48" => ["Cisco", "Cisco Systems"],
      "CCF3A5" => ["ChiMeiCo", "Chi Mei Communication Systems, Inc"],
      "CCF67A" => ["AyeckaCo", "Ayecka Communication Systems LTD"],
      "CCF841" => ["Lumewave",""],
      "CCF8F0" => ["XiAnHisu", "Xi\'an HISU Multimedia Technology Co.,Ltd."],
      "CCF954" => ["Avaya", "Avaya, Inc"],
      "CCF9E8" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "CCFC6D" => ["RizTrans", "RIZ TRANSMITTERS"],
      "CCFCB1" => ["Wireless", "Wireless Technology, Inc."],
      "CCFE3C" => ["SamsungE", "Samsung Electronics"],
      "D00790" => ["TexasIns", "Texas Instruments"],
      "D0131E" => ["SunrexTe", "Sunrex Technology Corp"],
      "D0154A" => ["Zte", "zte corporation"],
      "D0176A" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "D01AA7" => ["Uniprint",""],
      "D01CBB" => ["BeijingC", "Beijing Ctimes Digital Technology Co., Ltd."],
      "D023DB" => ["Apple", "Apple, Inc."],
      "D02788" => ["HonHaiPr", "Hon Hai Precision Ind.Co.Ltd"],
      "D03110" => ["IngenicS", "Ingenic Semiconductor Co.,Ltd"],
      "D03761" => ["TexasIns", "Texas Instruments"],
      "D0542D" => ["Cambridg", "Cambridge Industries(Group) Co.,Ltd."],
      "D0574C" => ["Cisco", "Cisco Systems"],
      "D05785" => ["Pantech", "Pantech Co., Ltd."],
      "D05875" => ["ActiveCo", "Active Control Technology Inc."],
      "D059C3" => ["Ceramicr", "CeraMicro Technology Corporation"],
      "D05A0F" => ["I-BtDigi", "I-BT DIGITAL CO.,LTD"],
      "D05FCE" => ["HitachiD", "Hitachi Data Systems"],
      "D0667B" => ["SamsungE", "Samsung Electronics Co., LTD"],
      "D067E5" => ["Dell", "Dell Inc"],
      "D0699E" => ["LuminexL", "LUMINEX Lighting Control Equipment"],
      "D075BE" => ["RenoA&Am", "Reno A&amp;E"],
      "D07DE5" => ["ForwardP", "Forward Pay Systems, Inc."],
      "D07E28" => ["HewlettP", "Hewlett Packard"],
      "D08999" => ["Apcon", "APCON, Inc."],
      "D08CB5" => ["TexasIns", "Texas Instruments"],
      "D08CFF" => ["Upwis", "UPWIS AB"],
      "D093F8" => ["Stonestr", "Stonestreet One LLC"],
      "D09B05" => ["Emtronix",""],
      "D0A311" => ["Neuberge", "Neuberger Geb udeautomation GmbH"],
      "D0AEEC" => ["AlphaNet", "Alpha Networks Inc."],
      "D0AFB6" => ["LinktopT", "Linktop Technology Co., LTD"],
      "D0B33F" => ["Shenzhen", "SHENZHEN TINNO MOBILE TECHNOLOGY CO.,LTD."],
      "D0B53D" => ["SeproRob", "SEPRO ROBOTIQUE"],
      "D0BB80" => ["ShlTelem", "SHL Telemedicine International Ltd."],
      "D0C1B1" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "D0C282" => ["Cisco", "Cisco Systems"],
      "D0CF5E" => ["EnergyMi", "Energy Micro AS"],
      "D0D0FD" => ["Cisco", "Cisco Systems"],
      "D0D212" => ["K2net", "K2NET Co.,Ltd."],
      "D0D286" => ["BeckmanC", "Beckman Coulter Biomedical K.K."],
      "D0D3FC" => ["Mios", "Mios, Ltd."],
      "D0DB32" => ["Nokia", "Nokia Corporation"],
      "D0DF9A" => ["LiteonTe", "Liteon Technology Corporation"],
      "D0DFC7" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "D0E347" => ["Yoga",""],
      "D0E40B" => ["Wearable", "Wearable Inc."],
      "D0E54D" => ["Pace", "Pace plc"],
      "D0EB9E" => ["Seowoo", "Seowoo Inc."],
      "D0F0DB" => ["Ericsson",""],
      "D0F73B" => ["HelmutMa", "Helmut Mauell GmbH"],
      "D4000D" => ["PhoenixB", "Phoenix Broadband Technologies, LLC."],
      "D4024A" => ["Delphian", "Delphian Systems LLC"],
      "D411D6" => ["Shotspot", "ShotSpotter, Inc."],
      "D41296" => ["AnobitTe", "Anobit Technologies Ltd."],
      "D412BB" => ["Quadrant", "Quadrant Components Inc. Ltd"],
      "D41C1C" => ["RcfSPA", "RCF S.P.A."],
      "D41E35" => ["TohoElec", "TOHO Electronics INC."],
      "D41F0C" => ["TviVisio", "TVI Vision Oy"],
      "D4206D" => ["Htc", "HTC Corporation"],
      "D428B2" => ["Iobridge", "ioBridge, Inc."],
      "D42C3D" => ["SkyLight", "Sky Light Digital Limited"],
      "D43AE9" => ["Dongguan", "DONGGUAN ipt INDUSTRIAL CO., LTD"],
      "D43D67" => ["CarmaInd", "Carma Industries Inc."],
      "D43D7E" => ["Micro-St", "Micro-Star Int\'l Co, Ltd"],
      "D443A8" => ["Changzho", "Changzhou Haojie Electric Co., Ltd."],
      "D44B5E" => ["TaiyoYud", "TAIYO YUDEN CO., LTD."],
      "D44C24" => ["Vuppalam", "Vuppalamritha Magnetic Components LTD"],
      "D44CA7" => ["Informte", "Informtekhnika & Communication, LLC"],
      "D44F80" => ["KemperDi", "Kemper Digital GmbH"],
      "D4507A" => ["CeivaLog", "CEIVA Logic, Inc"],
      "D45251" => ["IbtIngen", "IBT Ingenieurbureau Broennimann Thun"],
      "D45297" => ["Nstreams", "nSTREAMS Technologies, Inc."],
      "D453AF" => ["VigoSyst", "VIGO System S.A."],
      "D45AB2" => ["Galleon", "Galleon Systems"],
      "D45D42" => ["Nokia", "Nokia Corporation"],
      "D466A8" => ["RiedoNet", "Riedo Networks GmbH"],
      "D46CBF" => ["Goodrich", "Goodrich ISR"],
      "D46CDA" => ["Csm", "CSM GmbH"],
      "D46F42" => ["WaxessUs", "WAXESS USA Inc"],
      "D479C3" => ["Camerone", "Cameronet GmbH &amp; Co. KG"],
      "D47B75" => ["HartingE", "HARTING Electronics GmbH & Co. KG"],
      "D4823E" => ["ArgosyTe", "Argosy Technologies, Ltd."],
      "D48564" => ["Hewlett-", "Hewlett-Packard Company"],
      "D487D8" => ["SamsungE", "Samsung Electronics"],
      "D48890" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "D48CB5" => ["Cisco", "Cisco Systems"],
      "D48FAA" => ["SogecamI", "Sogecam Industrial, S.A."],
      "D491AF" => ["Electroa", "Electroacustica General Iberica, S.A."],
      "D4945A" => ["Cosmo", "COSMO CO., LTD"],
      "D494A1" => ["TexasIns", "Texas Instruments"],
      "D496DF" => ["SungjinC", "SUNGJIN C&T CO.,LTD"],
      "D49A20" => ["Apple", "Apple, Inc"],
      "D49C28" => ["JaybirdG", "JayBird Gear LLC"],
      "D49C8E" => ["Universi", "University of FUKUI"],
      "D49E6D" => ["WuhanZho", "Wuhan Zhongyuan Huadian Science & Technology Co.,"],
      "D4A02A" => ["Cisco", "Cisco Systems"],
      "D4A425" => ["SmaxTech", "SMAX Technology Co., Ltd."],
      "D4A928" => ["Greenwav", "GreenWave Reality Inc"],
      "D4AAFF" => ["MicroWor", "MICRO WORLD"],
      "D4AE52" => ["Dell", "Dell Inc"],
      "D4BED9" => ["Dell", "Dell Inc"],
      "D4C1FC" => ["Nokia", "Nokia Corporation"],
      "D4C766" => ["Acentic", "Acentic GmbH"],
      "D4CA6D" => ["Routerbo", "Routerboard.com"],
      "D4CBAF" => ["Nokia", "Nokia Corporation"],
      "D4CEB8" => ["Enatel", "Enatel LTD"],
      "D4D184" => ["AdbBroad", "ADB Broadband Italia"],
      "D4D249" => ["PowerEth", "Power Ethernet"],
      "D4D748" => ["Cisco", "Cisco Systems"],
      "D4D898" => ["KoreaCno", "Korea CNO Tech Co., Ltd"],
      "D4DF57" => ["Alpinion", "Alpinion Medical Systems"],
      "D4E32C" => ["SSiedleS", "S. Siedle & Sohne"],
      "D4E33F" => ["Alcatel-", "Alcatel-Lucent"],
      "D4E8B2" => ["SamsungE", "Samsung Electronics"],
      "D4EC0C" => ["Harley-D", "Harley-Davidson Motor Company"],
      "D4F027" => ["NavetasE", "Navetas Energy Management"],
      "D4F0B4" => ["NapcoSec", "Napco Security Technologies"],
      "D4F143" => ["Iproad", "IPROAD.,Inc"],
      "D4F63F" => ["IeaSRL", "IEA S.R.L."],
      "D8052E" => ["Skyviia", "Skyviia Corporation"],
      "D806D1" => ["Honeywel", "Honeywell Fire System (Shanghai) Co,. Ltd."],
      "D80DE3" => ["FxiTechn", "FXI TECHNOLOGIES AS"],
      "D8160A" => ["NipponEl", "Nippon Electro-Sensory Devices"],
      "D81BFE" => ["Twinlinx", "TWINLINX CORPORATION"],
      "D81C14" => ["Compacta", "Compacta International, Ltd."],
      "D824BD" => ["Cisco", "Cisco Systems"],
      "D826B9" => ["Guangdon", "Guangdong Coagent Electronics S &T Co., Ltd."],
      "D828C9" => ["GeneralE", "General Electric Consumer and Industrial"],
      "D82986" => ["BestWish", "Best Wish Technology LTD"],
      "D82A7E" => ["Nokia", "Nokia Corporation"],
      "D82DE1" => ["Tricasca", "Tricascade Inc."],
      "D83062" => ["Apple", "Apple, Inc"],
      "D8337F" => ["OfficeFa", "Office FA.com Co.,Ltd."],
      "D842AC" => ["Freecomm", "FreeComm Data Communication Co.,Ltd."],
      "D84606" => ["SiliconV", "Silicon Valley Global Marketing"],
      "D84B2A" => ["Cognitas", "Cognitas Technologies, Inc."],
      "D8543A" => ["TexasIns", "Texas Instruments"],
      "D857EF" => ["SamsungE", "Samsung Electronics"],
      "D85D4C" => ["Tp-LinkT", "TP-LINK Technologies Co.,Ltd."],
      "D85D84" => ["CaxSoft", "CAx soft GmbH"],
      "D867D9" => ["Cisco", "Cisco Systems"],
      "D86BF7" => ["Nintendo", "Nintendo Co., Ltd."],
      "D86CE9" => ["Sagemcom", "SAGEMCOM SAS"],
      "D87157" => ["LenovoMo", "Lenovo Mobile Communication Technology Ltd."],
      "D87533" => ["Nokia", "Nokia Corporation"],
      "D8760A" => ["Escort", "Escort, Inc."],
      "D878E5" => ["KuhnSa", "KUHN SA"],
      "D87988" => ["HonHaiPr", "Hon Hai Precision Ind. Co., Ltd."],
      "D88A3B" => ["Unit-Em",""],
      "D8952F" => ["TexasIns", "Texas Instruments"],
      "D89685" => ["Gopro",""],
      "D8973B" => ["EmersonN", "Emerson Network Power Embedded Power"],
      "D89760" => ["C2Develo", "C2 Development, Inc."],
      "D89DB9" => ["Emegatec", "eMegatech International Corp."],
      "D89E3F" => ["Apple", "Apple, Inc."],
      "D8A25E" => ["Apple", "Apple, Inc."],
      "D8AE90" => ["ItibiaTe", "Itibia Technologies"],
      "D8AF3B" => ["Hangzhou", "Hangzhou Bigbright Integrated communications system Co.,Ltd"],
      "D8AFF1" => ["Panasoni", "Panasonic Appliances Company"],
      "D8B12A" => ["Panasoni", "Panasonic Mobile Communications Co., Ltd."],
      "D8B377" => ["Htc", "HTC Corporation"],
      "D8B6C1" => ["Networka", "NetworkAccountant, Inc."],
      "D8B8F6" => ["Nantwork", "Nantworks"],
      "D8B90E" => ["TripleDo", "Triple Domain Vision Co.,Ltd."],
      "D8BF4C" => ["VictoryC", "Victory Concept Electronics Limited"],
      "D8C068" => ["Netgenet", "Netgenetech.co.,ltd."],
      "D8C3FB" => ["Detracom",""],
      "D8C691" => ["HichanTe", "Hichan Technology Corp."],
      "D8C7C8" => ["ArubaNet", "Aruba Networks"],
      "D8C99D" => ["EaDispla", "EA DISPLAY LIMITED"],
      "D8D385" => ["Hewlett-", "Hewlett-Packard Company"],
      "D8D67E" => ["GskCncEq", "GSK CNC EQUIPMENT CO.,LTD"],
      "D8DF0D" => ["Beronet", "beroNet GmbH"],
      "D8E3AE" => ["CirtecMe", "CIRTEC MEDICAL SYSTEMS"],
      "D8E72B" => ["OnpathTe", "OnPATH Technologies"],
      "D8E743" => ["Wush", "Wush, Inc"],
      "D8E952" => ["Keopsys",""],
      "D8EB97" => ["Trendnet", "TRENDnet, Inc."],
      "D8F0F2" => ["Zeebo", "Zeebo Inc"],
      "D8FE8F" => ["Idfone", "IDFone Co., Ltd."],
      "DC0265" => ["Meditech", "Meditech Kft"],
      "DC05ED" => ["Nabtesco", "Nabtesco  Corporation"],
      "DC07C1" => ["Hangzhou", "HangZhou QiYang Technology Co.,Ltd."],
      "DC0B1A" => ["AdbBroad", "ADB Broadband SpA"],
      "DC0EA1" => ["CompalIn", "COMPAL INFORMATION (KUNSHAN) CO., LTD"],
      "DC16A2" => ["Medtroni", "Medtronic Diabetes"],
      "DC175A" => ["HitachiH", "Hitachi High-Technologies Corporation"],
      "DC1D9F" => ["UBTech", "U & B tech"],
      "DC1EA3" => ["Accensus", "Accensus LLC"],
      "DC2008" => ["AsdElect", "ASD Electronics Ltd"],
      "DC2B61" => ["Apple", "Apple, Inc."],
      "DC2B66" => ["Infobloc", "Infoblock"],
      "DC2C26" => ["ItonTech", "Iton Technology Limited"],
      "DC2E6A" => ["Hct", "HCT. Co., Ltd."],
      "DC309C" => ["Say", "SAY Systems Limited"],
      "DC3350" => ["Techsat", "TechSAT GmbH"],
      "DC37D2" => ["HunanHkt", "Hunan HKT Electronic Technology Co., Ltd"],
      "DC3C2E" => ["Manufact", "Manufacturing System Insights, Inc."],
      "DC3C84" => ["TicomGeo", "Ticom Geomatics, Inc."],
      "DC3E51" => ["SolbergA", "Solberg & Andersen AS"],
      "DC49C9" => ["CascoSig", "CASCO SIGNAL LTD"],
      "DC4EDE" => ["ShinyeiT", "SHINYEI TECHNOLOGY CO., LTD."],
      "DC7144" => ["SamsungE", "Samsung Electro Mechanics"],
      "DC7B94" => ["Cisco", "Cisco Systems"],
      "DC85DE" => ["Azurewav", "Azurewave Technologies., inc."],
      "DC9B1E" => ["Intercom", "Intercom, Inc."],
      "DC9C52" => ["Sapphire", "Sapphire Technology Limited."],
      "DC9FDB" => ["Ubiquiti", "Ubiquiti Networks, Inc."],
      "DCA6BD" => ["BeijingL", "Beijing Lanbo Technology Co., Ltd."],
      "DCA7D9" => ["Compress", "Compressor Controls Corp"],
      "DCA8CF" => ["NewSpinG", "New Spin Golf, LLC."],
      "DCA971" => ["IntelCor", "Intel Corporate"],
      "DCB4C4" => ["Microsof", "Microsoft XCG"],
      "DCC101" => ["SolidTec", "SOLiD Technologies, Inc."],
      "DCCBA8" => ["ExploraT", "Explora Technologies Inc"],
      "DCCE41" => ["FeGlobal", "FE GLOBAL HONG KONG LIMITED"],
      "DCCF94" => ["BeijingR", "Beijing Rongcheng Hutong Technology Co., Ltd."],
      "DCD0F7" => ["Bentek", "Bentek Systems Ltd."],
      "DCD321" => ["HumaxTld", "HUMAX co.,tld"],
      "DCD87F" => ["Shenzhen", "Shenzhen JoinCyber Telecom Equipment Ltd"],
      "DCDECA" => ["Akyllor",""],
      "DCE2AC" => ["LumensDi", "Lumens Digital Optics Inc."],
      "DCE71C" => ["AugElekt", "AUG Elektronik GmbH"],
      "DCF05D" => ["LettaTek", "Letta Teknoloji"],
      "DCF858" => ["LorentNe", "Lorent Networks   Inc."],
      "DCFAD5" => ["StrongGe", "STRONG Ges.m.b.H."],
      "E005C5" => ["Tp-LinkT", "TP-LINK Technologies Co.,Ltd."],
      "E006E6" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "E00B28" => ["Inovonic", "Inovonics"],
      "E00C7F" => ["Nintendo", "Nintendo Co., Ltd."],
      "E0143E" => ["Modoosis", "Modoosis Inc."],
      "E01C41" => ["Aerohive", "Aerohive Networks Inc."],
      "E01CEE" => ["BravoTec", "Bravo Tech, Inc."],
      "E01D3B" => ["Cambridg", "Cambridge Industries(Group) Co.,Ltd"],
      "E01E07" => ["AniteTel", "Anite Telecoms  US. Inc"],
      "E01F0A" => ["XslentEn", "Xslent Energy Technologies. LLC"],
      "E0247F" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "E02538" => ["TitanPet", "Titan Pet Products"],
      "E02630" => ["Intrigue", "Intrigue Technologies, Inc."],
      "E02636" => ["NortelNe", "Nortel Networks"],
      "E0271A" => ["TtcNext-", "TTC Next-generation Home Network System WG"],
      "E02A82" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "E03005" => ["Alcatel-", "Alcatel-Lucent Shanghai Bell Co., Ltd"],
      "E039D7" => ["Plexxi", "Plexxi, Inc."],
      "E03C5B" => ["Shenzhen", "SHENZHEN JIAXINJIE ELECTRON CO.,LTD"],
      "E03E7D" => ["Data-Com", "data-complex GmbH"],
      "E0469A" => ["Netgear",""],
      "E0589E" => ["LaerdalM", "Laerdal Medical"],
      "E05B70" => ["Innovid", "Innovid, Co., Ltd."],
      "E05DA6" => ["DetlefFi", "Detlef Fink Elektronik &amp; Softwareentwicklung"],
      "E05FB9" => ["Cisco", "Cisco Systems"],
      "E061B2" => ["Hangzhou", "HANGZHOU ZENOINTEL TECHNOLOGY CO., LTD"],
      "E06290" => ["JinanJov", "Jinan Jovision Science & Technology Co., Ltd."],
      "E064BB" => ["Digiview", "DigiView S.r.l."],
      "E06995" => ["Pegatron", "PEGATRON CORPORATION"],
      "E087B1" => ["Nata-Inf", "Nata-Info Ltd."],
      "E08A7E" => ["Exponent",""],
      "E08FEC" => ["Repotec", "REPOTEC CO., LTD."],
      "E09153" => ["XaviTech", "XAVi Technologies Corp."],
      "E091F5" => ["Netgear",""],
      "E09467" => ["IntelCor", "Intel Corporate"],
      "E09579" => ["Orthosof", "ORTHOsoft inc, d/b/a Zimmer CAS"],
      "E09DB8" => ["PlanexCo", "PLANEX COMMUNICATIONS INC."],
      "E0A1D7" => ["Sfr",""],
      "E0A30F" => ["Pevco",""],
      "E0A670" => ["Nokia", "Nokia Corporation"],
      "E0AAB0" => ["GeneralV", "GENERAL VISION ELECTRONICS CO. LTD."],
      "E0ABFE" => ["OrbNetwo", "Orb Networks, Inc."],
      "E0AE5E" => ["AlpsElec", "ALPS Electric Co,. Ltd."],
      "E0B9A5" => ["Azurewav", "Azurewave"],
      "E0B9BA" => ["Apple", "Apple, Inc."],
      "E0BC43" => ["C2Micros", "C2 Microsystems, Inc."],
      "E0C286" => ["AisaiCom", "Aisai Communication Technology Co., Ltd."],
      "E0C79D" => ["TexasIns", "Texas Instruments"],
      "E0C922" => ["JirehEne", "Jireh Energy Tech., Ltd."],
      "E0C97A" => ["Apple", "Apple Inc"],
      "E0CA4D" => ["Shenzhen", "Shenzhen Unistar Communication Co.,LTD"],
      "E0CA94" => ["AskeyCom", "Askey Computer"],
      "E0CB1D" => ["Private",""],
      "E0CB4E" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "E0CF2D" => ["Gemintek", "Gemintek Corporation"],
      "E0D10A" => ["Katouden", "Katoudenkikougyousyo co ltd"],
      "E0D7BA" => ["TexasIns", "Texas Instruments"],
      "E0DADC" => ["JvcKenwo", "JVC KENWOOD Corporation"],
      "E0DB55" => ["Dell", "Dell Inc"],
      "E0E751" => ["Nintendo", "Nintendo Co., Ltd."],
      "E0E8E8" => ["OliveTel", "Olive Telecommunication Pvt. Ltd"],
      "E0ED1A" => ["Vastrive", "vastriver Technology Co., Ltd"],
      "E0EE1B" => ["Panasoni", "Panasonic Automotive Systems Company of America"],
      "E0EF25" => ["LintesTe", "Lintes Technology Co., Ltd."],
      "E0F211" => ["Digitalw", "Digitalwatt"],
      "E0F379" => ["Vaddio",""],
      "E0F5CA" => ["ChengUei", "CHENG UEI PRECISION INDUSTRY CO.,LTD."],
      "E0F847" => ["Apple", "Apple, Inc."],
      "E0F9BE" => ["Cloudena", "Cloudena Corp."],
      "E20C0F" => ["Kingston", "Kingston Technologies"],
      "E4115B" => ["HewlettP", "Hewlett Packard"],
      "E41289" => ["Topsyste", "topsystem Systemhaus GmbH"],
      "E41C4B" => ["V2Techno", "V2 TECHNOLOGY, INC."],
      "E41F13" => ["Ibm", "IBM Corp"],
      "E425E9" => ["Color-Ch", "Color-Chip"],
      "E42771" => ["Smartlab", "Smartlabs"],
      "E42AD3" => ["MagnetiM", "Magneti Marelli S.p.A. Powertrain"],
      "E42C56" => ["Lilee", "Lilee Systems, Ltd."],
      "E42F26" => ["Fiberhom", "Fiberhome Telecommunication Tech.Co.,Ltd."],
      "E42FF6" => ["UnicoreC", "Unicore communication Inc."],
      "E43593" => ["Hangzhou", "Hangzhou GoTo technology Co.Ltd"],
      "E435FB" => ["SabreTec", "Sabre Technology (Hull) Ltd"],
      "E437D7" => ["HenriDep", "HENRI DEPAEPE S.A.S."],
      "E43FA2" => ["WuxiDspT", "Wuxi DSP Technologies Inc."],
      "E441E6" => ["OttecTec", "Ottec Technology GmbH"],
      "E446BD" => ["C&CTechn", "C&C TECHNIC TAIWAN CO., LTD."],
      "E448C7" => ["CiscoSpv", "Cisco SPVTG"],
      "E44E18" => ["Gardasof", "Gardasoft VisionLimited"],
      "E44F29" => ["MaLighti", "MA Lighting Technology GmbH"],
      "E455EA" => ["Dedicate", "Dedicated Computing"],
      "E46449" => ["Motorola", "Motorola Mobility, Inc."],
      "E467BA" => ["DanishIn", "Danish Interpretation Systems A/S"],
      "E46C21" => ["Messma", "messMa GmbH"],
      "E47185" => ["Securifi", "Securifi Ltd"],
      "E4751E" => ["GetingeS", "Getinge Sterilization AB"],
      "E477D4" => ["MinrrayI", "Minrray Industry Co.,Ltd"],
      "E47CF9" => ["SamsungE", "Samsung Electronics Co., LTD"],
      "E48399" => ["Motorola", "Motorola Mobility, Inc."],
      "E48AD5" => ["RfWindow", "RF WINDOW CO., LTD."],
      "E49069" => ["Rockwell", "Rockwell Automation"],
      "E497F0" => ["Shanghai", "Shanghai VLC Technologies Ltd. Co."],
      "E4A5EF" => ["TronLink", "TRON LINK ELECTRONICS CO., LTD."],
      "E4AB46" => ["UabSelte", "UAB Selteka"],
      "E4AD7D" => ["SclEleme", "SCL Elements"],
      "E4AFA1" => ["Hes-So",""],
      "E4B021" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "E4C6E6" => ["MophieLl", "Mophie, LLC"],
      "E4C806" => ["CeiecEle", "Ceiec Electric Technology Inc."],
      "E4CE8F" => ["Apple", "Apple, Inc."],
      "E4D53D" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "E4D71D" => ["OrayaThe", "Oraya Therapeutics"],
      "E4DD79" => ["En-Visio", "En-Vision America, Inc."],
      "E4E0C5" => ["SamsungE", "Samsung Electronics Co., LTD"],
      "E4EC10" => ["Nokia", "Nokia Corporation"],
      "E4FA1D" => ["PadPerip", "PAD Peripheral Advanced Design Inc."],
      "E4FFDD" => ["Electron", "ELECTRON INDIA"],
      "E8039A" => ["SamsungE", "Samsung Electronics Co.,LTD"],
      "E8040B" => ["Apple", "Apple, Inc."],
      "E80462" => ["Cisco", "Cisco Systems"],
      "E8056D" => ["NortelNe", "Nortel Networks"],
      "E80688" => ["Apple", "Apple, Inc."],
      "E80B13" => ["AkibTaiw", "Akib Systems Taiwan, INC"],
      "E80C38" => ["Daeyoung", "DAEYOUNG INFORMATION SYSTEM CO., LTD"],
      "E80C75" => ["Syncbak", "Syncbak, Inc."],
      "E8102E" => ["ReallySi", "Really Simple Software, Inc"],
      "E81132" => ["SamsungE", "Samsung Electronics Co.,LTD"],
      "E81324" => ["Guangzho", "GuangZhou Bonsoninfo System CO.,LTD"],
      "E82877" => ["Tmy", "TMY Co., Ltd."],
      "E828D5" => ["CotsTech", "Cots Technology"],
      "E83935" => ["HewlettP", "Hewlett Packard"],
      "E839DF" => ["AskeyCom", "Askey Computer"],
      "E83A97" => ["OczTechn", "OCZ Technology Group"],
      "E83EB6" => ["Rim",""],
      "E83EFB" => ["Geodesic", "GEODESIC LTD."],
      "E84040" => ["Cisco", "Cisco Systems"],
      "E840F2" => ["Pegatron", "PEGATRON CORPORATION"],
      "E843B6" => ["Qnap", "QNAP Systems, Inc."],
      "E84E06" => ["EdupInte", "EDUP INTERNATIONAL (HK) CO., LTD"],
      "E84ECE" => ["Nintendo", "Nintendo Co., Ltd."],
      "E85484" => ["NeoInfor", "NEO INFORMATION SYSTEMS CO., LTD."],
      "E856D6" => ["Nctech", "NCTech Ltd"],
      "E85B5B" => ["LgElectr", "LG ELECTRONICS INC"],
      "E85BF0" => ["ImagingD", "Imaging Diagnostics"],
      "E85E53" => ["Infratec", "Infratec Datentechnik GmbH"],
      "E86CDA" => ["Supercom", "Supercomputers and Neurocomputers Research Center"],
      "E86D52" => ["Motorola", "Motorola Mobility, Inc."],
      "E86D6E" => ["ControlD", "Control & Display Systems Ltd t/a CDSRail"],
      "E8757F" => ["FirsTech", "FIRS Technologies(Shenzhen) Co., Ltd"],
      "E878A1" => ["BeoviewI", "BEOVIEW INTERCOM DOO"],
      "E87AF3" => ["S5TechSR", "S5 Tech S.r.l."],
      "E88DF5" => ["ZnyxNetw", "ZNYX Networks, Inc."],
      "E8944C" => ["CogentHe", "Cogent Healthcare Systems Ltd"],
      "E8995A" => ["PiigabPr", "PiiGAB, Processinformation i Goteborg AB"],
      "E899C4" => ["Htc", "HTC Corporation"],
      "E89A8F" => ["QuantaCo", "Quanta Computer Inc."],
      "E89D87" => ["Toshiba",""],
      "E8A4C1" => ["DeepSeaE", "Deep Sea Electronics PLC"],
      "E8B4AE" => ["Shenzhen", "Shenzhen C&D Electronics Co.,Ltd"],
      "E8B748" => ["Cisco", "Cisco Systems"],
      "E8BA70" => ["Cisco", "Cisco Systems"],
      "E8BE81" => ["Sagemcom",""],
      "E8C229" => ["H-Displa", "H-Displays (MSC) Bhd"],
      "E8C320" => ["AustcoCo", "Austco Communication Systems Pty Ltd"],
      "E8CBA1" => ["Nokia", "Nokia Corporation"],
      "E8CC32" => ["Micronet", "Micronet  LTD"],
      "E8D0FA" => ["MksInstr", "MKS Instruments Deutschland GmbH"],
      "E8D483" => ["Ultimate", "ULTIMATE Europe Transportation Equipment GmbH"],
      "E8DA96" => ["ZhuhaiTi", "Zhuhai Tianrui Electrical Power Tech. Co., Ltd."],
      "E8DAAA" => ["Videohom", "VideoHome Technology Corp."],
      "E8DFF2" => ["Prf", "PRF Co., Ltd."],
      "E8E08F" => ["Gravotec", "GRAVOTECH MARKING SAS"],
      "E8E0B7" => ["Toshiba",""],
      "E8E1E2" => ["Energote", "Energotest"],
      "E8E5D6" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "E8E732" => ["Alcatel-", "Alcatel-Lucent"],
      "E8E776" => ["Shenzhen", "Shenzhen Kootion Technology Co., Ltd"],
      "E8F1B0" => ["Sagemcom", "SAGEMCOM SAS"],
      "E8F928" => ["RftechSr", "RFTECH SRL"],
      "EC0ED6" => ["ItechIns", "ITECH INSTRUMENTS SAS"],
      "EC1000" => ["EnanceSo", "Enance Source Co., Ltd.	PC clones(?)"],
      "EC1120" => ["Flodesig", "FloDesign Wind Turbine Corporation"],
      "EC14F6" => ["Biocontr", "BioControl AS"],
      "EC172F" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "EC1A59" => ["BelkinIn", "Belkin International Inc."],
      "EC233D" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "EC2368" => ["Intelliv", "IntelliVoice Co.,Ltd."],
      "EC3091" => ["Cisco", "Cisco Systems"],
      "EC3BF0" => ["Novelsat",""],
      "EC3F05" => ["Institut", "Institute 706, The Second Academy China Aerospace Science & Industry Corp"],
      "EC42F0" => ["AdlEmbed", "ADL Embedded Solutions, Inc."],
      "EC43E6" => ["Awcer", "AWCER Ltd."],
      "EC4476" => ["Cisco", "Cisco Systems"],
      "EC4644" => ["TtkSas", "TTK SAS"],
      "EC4670" => ["Meinberg", "Meinberg Funkuhren GmbH &amp; Co. KG"],
      "EC4C4D" => ["ZaoNpkRo", "ZAO NPK RoTeK"],
      "EC542E" => ["Shanghai", "Shanghai XiMei Electronic Technology Co. Ltd"],
      "EC55F9" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "EC5C69" => ["Mitsubis", "MITSUBISHI HEAVY INDUSTRIES MECHATRONICS SYSTEMS,LTD."],
      "EC6264" => ["Global41", "Global411 Internet Services, LLC"],
      "EC63E5" => ["EpboardD", "ePBoard Design LLC"],
      "EC66D1" => ["B&Amp;WG", "B&amp;W Group LTD"],
      "EC6C9F" => ["ChengduV", "Chengdu Volans Technology CO.,LTD"],
      "EC7C74" => ["JustoneT", "Justone Technologies Co., Ltd."],
      "EC7D9D" => ["Mei",""],
      "EC836C" => ["RmTech", "RM Tech Co., Ltd."],
      "EC852F" => ["Apple", "Apple, Inc."],
      "EC888F" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "EC8EAD" => ["Dlx",""],
      "EC9233" => ["EddyfiNd", "Eddyfi NDT Inc"],
      "EC9327" => ["Memmert+", "MEMMERT GmbH + Co. KG"],
      "EC9681" => ["2276427O", "2276427 Ontario Inc"],
      "EC986C" => ["LufftMes", "Lufft Mess- und Regeltechnik GmbH"],
      "EC98C1" => ["BeijingR", "Beijing Risbo Network Technology Co.,Ltd"],
      "EC9A74" => ["HewlettP", "Hewlett Packard"],
      "EC9B5B" => ["Nokia", "Nokia Corporation"],
      "EC9ECD" => ["EmersonN", "Emerson Network Power and Embedded Computing"],
      "ECA29B" => ["KemppiOy", "Kemppi Oy"],
      "ECA86B" => ["Elitegro", "ELITEGROUP COMPUTER SYSTEMS CO., LTD."],
      "ECB106" => ["AcuroNet", "Acuro Networks, Inc"],
      "ECBBAE" => ["Digivoic", "Digivoice Tecnologia em Eletronica Ltda"],
      "ECBD09" => ["FusionEl", "FUSION Electronics Ltd"],
      "ECC38A" => ["Accuener", "Accuenergy (CANADA) Inc"],
      "ECC882" => ["Cisco", "Cisco Systems"],
      "ECCD6D" => ["AlliedTe", "Allied Telesis, Inc."],
      "ECD00E" => ["Miraerec", "MiraeRecognition Co., Ltd."],
      "ECD19A" => ["ZhuhaiLi", "Zhuhai Liming Industries Co., Ltd"],
      "ECDE3D" => ["LampreyN", "Lamprey Networks, Inc."],
      "ECE09B" => ["SamsungE", "Samsung electronics CO., LTD"],
      "ECE555" => ["Hirschma", "Hirschmann Automation"],
      "ECE744" => ["OmntecMf", "Omntec mfg. inc"],
      "ECE90B" => ["SistemaS", "SISTEMA SOLUCOES ELETRONICAS LTDA - EASYTECH"],
      "ECE9F8" => ["GuangZho", "Guang Zhou TRI-SUN Electronics Technology  Co., Ltd"],
      "ECEA03" => ["DarfonLi", "DARFON LIGHTING CORP"],
      "ECF00E" => ["Abocom",""],
      "ECF236" => ["Neomonta", "NEOMONTANA ELECTRONICS"],
      "ECFAAA" => ["Ims", "The IMS Company"],
      "ECFE7E" => ["Blueradi", "BlueRadios, Inc."],
      "F0007F" => ["Janz-Con", "Janz - Contadores de Energia, SA"],
      "F0022B" => ["Chrontel",""],
      "F00248" => ["Smartebu", "SmarteBuilding"],
      "F00786" => ["Shandong", "Shandong Bittel Electronics Co., Ltd"],
      "F008F1" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "F013C3" => ["Shenzhen", "SHENZHEN FENDA TECHNOLOGY CO., LTD"],
      "F01C13" => ["LgElectr", "LG Electronics"],
      "F02408" => ["TalarisS", "Talaris (Sweden) AB"],
      "F02572" => ["Cisco", "Cisco Systems"],
      "F0264C" => ["DrSigris", "Dr. Sigrist AG"],
      "F02A61" => ["WaldoNet", "Waldo Networks, Inc."],
      "F02FD8" => ["Bi2-Visi", "Bi2-Vision"],
      "F03A55" => ["OmegaEle", "Omega Elektronik AS"],
      "F04335" => ["DvnShang", "DVN(Shanghai)Ltd."],
      "F04A2B" => ["PyramidC", "PYRAMID Computer GmbH"],
      "F04B6A" => ["Scientif", "Scientific Production Association Siberian Arsenal, Ltd."],
      "F04BF2" => ["JtechCom", "JTECH Communications, Inc."],
      "F04DA2" => ["Dell", "Dell Inc."],
      "F05849" => ["Careview", "CareView Communications"],
      "F05D89" => ["Dycon", "Dycon Limited"],
      "F0620D" => ["Shenzhen", "Shenzhen Egreat Tech Corp.,Ltd"],
      "F06281" => ["Procurve", "ProCurve Networking by HP"],
      "F065DD" => ["PrimaxEl", "Primax Electronics Ltd."],
      "F06853" => ["Integrat", "Integrated Corporation"],
      "F077D0" => ["Xcellen",""],
      "F07BCB" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "F07D68" => ["D-Link", "D-Link Corporation"],
      "F081AF" => ["IrzAutom", "IRZ AUTOMATION TECHNOLOGIES LTD"],
      "F08BFE" => ["Costel", "COSTEL.,CO.LTD"],
      "F0933A" => ["Nxtconec", "NxtConect"],
      "F093C5" => ["GarlandT", "Garland Technology"],
      "F09CBB" => ["Raonthin", "RaonThink Inc."],
      "F09CE9" => ["Aerohive", "Aerohive Networks Inc"],
      "F0A225" => ["Private",""],
      "F0A764" => ["Gst", "GST Co., Ltd."],
      "F0AD4E" => ["Globalsc", "Globalscale Technologies, Inc."],
      "F0AE51" => ["Xi3", "Xi3 Corp"],
      "F0B479" => ["Apple", "Apple, Inc."],
      "F0B6EB" => ["PoslabTe", "Poslab Technology Co., Ltd."],
      "F0BCC8" => ["MaxidPty", "MaxID (Pty) Ltd"],
      "F0BDF1" => ["Sipod", "Sipod Inc."],
      "F0BF97" => ["Sony", "Sony Corporation"],
      "F0C24C" => ["Zhejiang", "Zhejiang FeiYue Digital Technology Co., Ltd"],
      "F0C27C" => ["Mianyang", "Mianyang Netop Telecom Equipment Co.,Ltd."],
      "F0C88C" => ["Leddarte", "LeddarTech Inc."],
      "F0CBA1" => ["Apple", "Apple, Inc."],
      "F0D14F" => ["LinearLl", "LINEAR LLC"],
      "F0D3E7" => ["Sensomet", "Sensometrix SA"],
      "F0D767" => ["AxemaPas", "Axema Passagekontroll AB"],
      "F0DA7C" => ["RlhIndus", "RLH INDUSTRIES,INC."],
      "F0DB30" => ["Yottabyt", "Yottabyte"],
      "F0DCE2" => ["Apple", "Apple Inc"],
      "F0DE71" => ["Shanghai", "Shanghai EDO Technologies Co.,Ltd."],
      "F0DEB9" => ["Shanghai", "ShangHai Y&Y Electronics Co., Ltd"],
      "F0DEF1" => ["WistronI", "Wistron InfoComm (Kunshan)Co"],
      "F0E5C3" => ["Draegerw", "Draegerwerk AG &amp;amp; Co. KG aA"],
      "F0E77E" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "F0EC39" => ["Essec",""],
      "F0ED1E" => ["BilkonBi", "Bilkon Bilgisayar Kontrollu Cih. Im.Ltd."],
      "F0EEBB" => ["Vipar", "VIPAR GmbH"],
      "F0F002" => ["HonHaiPr", "Hon Hai Precision Ind. Co.,Ltd."],
      "F0F755" => ["Cisco", "Cisco Systems"],
      "F0F7B3" => ["Phorm",""],
      "F0F842" => ["Keebox", "KEEBOX, Inc."],
      "F0F9F7" => ["Ies&Amp;", "IES GmbH &amp; Co. KG"],
      "F0FDA0" => ["AcurixNe", "Acurix Networks LP"],
      "F40321" => ["BenextBV", "BeNeXt B.V."],
      "F4044C" => ["Valencet", "ValenceTech Limited"],
      "F40B93" => ["Research", "Research In Motion"],
      "F40F9B" => ["Wavelink",""],
      "F41F0B" => ["Yamabish", "YAMABISHI Corporation"],
      "F436E1" => ["AbilisSa", "Abilis Systems SARL"],
      "F43814" => ["Shanghai", "Shanghai Howell Electronic Co.,Ltd"],
      "F43D80" => ["FagIndus", "FAG Industrial Services GmbH"],
      "F43E61" => ["Shenzhen", "Shenzhen Gongjin Electronics Co., Ltd"],
      "F43E9D" => ["BenuNetw", "Benu Networks, Inc."],
      "F44227" => ["SSResear", "S & S Research Inc."],
      "F44450" => ["Bnd", "BND Co., Ltd."],
      "F445ED" => ["Portable", "Portable Innovation Technology Ltd."],
      "F44848" => ["Amscreen", "Amscreen Group Ltd"],
      "F44EFD" => ["ActionsS", "Actions Semiconductor Co.,Ltd.(Cayman Islands)"],
      "F450EB" => ["Telechip", "Telechips Inc"],
      "F45433" => ["Rockwell", "Rockwell Automation"],
      "F45595" => ["Hengbao", "HENGBAO Corporation LTD."],
      "F4559C" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "F455E0" => ["NicewayC", "Niceway CNC Technology Co.,Ltd.Hunan Province"],
      "F45FD4" => ["CiscoSpv", "Cisco SPVTG"],
      "F45FF7" => ["DqTechno", "DQ Technology Inc."],
      "F4600D" => ["Panoptic", "Panoptic Technology, Inc"],
      "F46349" => ["Diffon", "Diffon Corporation"],
      "F46D04" => ["AsustekC", "ASUSTek COMPUTER INC."],
      "F473CA" => ["Conversi", "Conversion Sound Inc."],
      "F47626" => ["Viltechm", "Viltechmeda UAB"],
      "F47ACC" => ["Solidfir", "SolidFire, Inc."],
      "F47F35" => ["Cisco", "Cisco Systems"],
      "F48771" => ["Infoblox",""],
      "F48E09" => ["Nokia", "Nokia Corporation"],
      "F490EA" => ["DecisoBV", "Deciso B.V."],
      "F49461" => ["NexgenSt", "NexGen Storage"],
      "F49F54" => ["SamsungE", "Samsung Electronics"],
      "F4A52A" => ["HawaTech", "Hawa Technologies Inc"],
      "F4ACC1" => ["Cisco", "Cisco Systems"],
      "F4B164" => ["Lightnin", "Lightning Telecommunications Technology Co. Ltd"],
      "F4B549" => ["YeastarT", "Yeastar Technology Co., Ltd."],
      "F4B72A" => ["TimeInte", "TIME INTERCONNECT LTD"],
      "F4C714" => ["HuaweiDe", "Huawei Device Co., Ltd"],
      "F4C795" => ["WeyElekt", "WEY Elektronik AG"],
      "F4CAE5" => ["FreeboxS", "FREEBOX SA"],
      "F4CE46" => ["Hewlett-", "Hewlett-Packard Company"],
      "F4D9FB" => ["SamsungE", "Samsung Electronics CO., LTD"],
      "F4DC4D" => ["BeijingC", "Beijing CCD Digital Technology Co., Ltd"],
      "F4DCDA" => ["ZhuhaiJi", "Zhuhai Jiahe Communication Technology Co., limited"],
      "F4E142" => ["DeltaEle", "Delta Elektronika BV"],
      "F4E6D7" => ["SolarPow", "Solar Power Technologies, Inc."],
      "F4EA67" => ["Cisco", "Cisco Systems"],
      "F4EC38" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "F4FC32" => ["TexasIns", "Texas Instruments"],
      "F80332" => ["Khomp",""],
      "F8051C" => ["DrsImagi", "DRS Imaging and Targeting Solutions"],
      "F80CF3" => ["LgElectr", "LG Electronics"],
      "F80F41" => ["WistronI", "Wistron InfoComm(ZhongShan) Corporation"],
      "F80F84" => ["NaturalS", "Natural Security SAS"],
      "F81037" => ["AtopiaLp", "Atopia Systems, LP"],
      "F81A67" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "F81D93" => ["Longdhua", "Longdhua(Beijing) Controls Technology Co.,Ltd"],
      "F81EDF" => ["Apple", "Apple, Inc"],
      "F82F5B" => ["EgaugeLl", "eGauge Systems LLC"],
      "F83094" => ["Alcatel-", "Alcatel-Lucent Telecom Limited"],
      "F8313E" => ["Endeavou", "endeavour GmbH"],
      "F83376" => ["GoodMind", "Good Mind Innovation Co., Ltd."],
      "F83553" => ["MagentaR", "Magenta Research Ltd."],
      "F83DFF" => ["HuaweiTe", "Huawei Technologies Co., Ltd"],
      "F8462D" => ["SyntecIn", "SYNTEC Incorporation"],
      "F8472D" => ["X2genDig", "X2gen Digital Corp. Ltd"],
      "F85063" => ["Verathon",""],
      "F852DF" => ["VnlEurop", "VNL Europe AB"],
      "F85F2A" => ["Nokia", "Nokia Corporation"],
      "F866F2" => ["Cisco", "Cisco Systems"],
      "F86971" => ["SeibuEle", "Seibu Electric Co.,"],
      "F86ECF" => ["Arcx", "Arcx Inc"],
      "F871FE" => ["GoldmanS", "The Goldman Sachs Group, Inc."],
      "F8769B" => ["Neopis", "Neopis Co., Ltd."],
      "F87B7A" => ["Motorola", "Motorola Mobility, Inc."],
      "F87B8C" => ["AmpedWir", "Amped Wireless"],
      "F8811A" => ["Overkiz",""],
      "F88C1C" => ["KaishunE", "KAISHUN ELECTRONIC TECHNOLOGY CO., LTD. BEIJING"],
      "F88DEF" => ["Tenebrae", "Tenebraex"],
      "F88FCA" => ["GoogleFi", "Google Fiber, Inc"],
      "F8912A" => ["GlpGerma", "GLP German Light Products GmbH"],
      "F893F3" => ["Volans",""],
      "F897CF" => ["Daeshin-", "DAESHIN-INFORMATION TECHNOLOGY CO., LTD."],
      "F89955" => ["Fortress", "Fortress Technology Inc"],
      "F89D0D" => ["ControlT", "Control Technology Inc."],
      "F8A03D" => ["DinstarT", "Dinstar Technologies Co., Ltd."],
      "F8A9DE" => ["Puissanc", "PUISSANCE PLUS"],
      "F8AC6D" => ["Deltenna", "Deltenna Ltd"],
      "F8B599" => ["Guangzho", "Guangzhou CHNAVS Digital Technology Co.,Ltd"],
      "F8C001" => ["JuniperN", "Juniper Networks"],
      "F8C091" => ["Highgate", "Highgates Technology"],
      "F8C678" => ["Carefusi", "Carefusion"],
      "F8D0AC" => ["SonyComp", "Sony Computer Entertainment Inc."],
      "F8D0BD" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "F8D111" => ["Tp-LinkT", "TP-LINK TECHNOLOGIES CO., LTD."],
      "F8D3A9" => ["AxanNetw", "AXAN Networks"],
      "F8D462" => ["Pumatron", "Pumatronix Equipamentos Eletronicos Ltda."],
      "F8D756" => ["SimmTron", "Simm Tronic Limited"],
      "F8DAE2" => ["BetaLase", "Beta LaserMike"],
      "F8DAF4" => ["TaishanO", "Taishan Online Technology Co., Ltd."],
      "F8DB4C" => ["PnyTechn", "PNY Technologies, INC."],
      "F8DB7F" => ["Htc", "HTC Corporation"],
      "F8DC7A" => ["Variscit", "Variscite LTD"],
      "F8E7B5" => ["UtechEng", "uTech Engenharia e Automa ao LTDA"],
      "F8E968" => ["EgkerKft", "Egker Kft."],
      "F8EA0A" => ["Dipl-Mat", "Dipl.-Math. Michael Rauch"],
      "F8F014" => ["Rackware", "RackWare Inc."],
      "F8F25A" => ["G-Lab", "G-Lab GmbH"],
      "F8F7D3" => ["Internat", "International Communications Corporation"],
      "F8F7FF" => ["Syn-Tech", "SYN-TECH SYSTEMS INC"],
      "F8FB2F" => ["Santur", "Santur Corporation"],
      "F8FE5C" => ["Reciproc", "Reciprocal Labs Corp"],
      "FC0012" => ["ToshibaS", "Toshiba Samsung Storage Technolgoy Korea Corporation"],
      "FC01CD" => ["Fundacio", "FUNDACION TEKNIKER"],
      "FC0877" => ["PrentkeR", "Prentke Romich Company"],
      "FC0A81" => ["Motorola", "Motorola Solutions Inc."],
      "FC0FE6" => ["SonyComp", "Sony Computer Entertainment Inc."],
      "FC10BD" => ["ControlS", "Control Sistematizado S.A."],
      "FC1794" => ["Intercre", "InterCreative Co., Ltd"],
      "FC1D59" => ["ISmartCi", "I Smart Cities HK Ltd"],
      "FC1FC0" => ["Eurecam",""],
      "FC253F" => ["Apple", "Apple, Inc."],
      "FC2A54" => ["Connecte", "connected data"],
      "FC2E2D" => ["LoromInd", "Lorom Industrial Co.LTD."],
      "FC2F40" => ["Calxeda", "Calxeda, Inc."],
      "FC3598" => ["Favite", "Favite Inc."],
      "FC4463" => ["Universa", "Universal Audio"],
      "FC455F" => ["JiangxiS", "JIANGXI SHANSHUI OPTOELECTRONIC TECHNOLOGY CO.,LTD"],
      "FC48EF" => ["HuaweiTe", "HUAWEI TECHNOLOGIES CO.,LTD"],
      "FC4DD4" => ["Universa", "Universal Global Scientific Industrial Co., Ltd."],
      "FC5090" => ["SimexSpZ", "SIMEX Sp. z o.o."],
      "FC5B24" => ["WeibelSc", "Weibel Scientific A/S"],
      "FC5B26" => ["Mikrobit", "MikroBits"],
      "FC6198" => ["NecPerso", "NEC Personal Products, Ltd"],
      "FC683E" => ["Directed", "Directed Perception, Inc"],
      "FC6C31" => ["Lxinstru", "LXinstruments GmbH"],
      "FC7516" => ["D-LinkIn", "D-Link International"],
      "FC75E6" => ["Handream", "Handreamnet"],
      "FC7CE7" => ["FciUsaLl", "FCI USA LLC"],
      "FC8329" => ["TreiTech", "Trei technics"],
      "FC8399" => ["Avaya", "Avaya, Inc"],
      "FC8E7E" => ["Pace", "Pace plc"],
      "FC8FC4" => ["Intellig", "Intelligent Technology Inc."],
      "FC946C" => ["Ubivelox",""],
      "FC94E3" => ["Technico", "Technicolor USA Inc."],
      "FCA13E" => ["SamsungE", "Samsung Electronics"],
      "FCA841" => ["Avaya", "Avaya, Inc"],
      "FCAF6A" => ["Conemtec", "Conemtech AB"],
      "FCC23D" => ["Atmel", "Atmel Corporation"],
      "FCC734" => ["SamsungE", "Samsung Electronics Co.,Ltd"],
      "FCC897" => ["Zte", "ZTE Corporation"],
      "FCCCE4" => ["Ascon", "Ascon Ltd."],
      "FCCF62" => ["Ibm", "IBM Corp"],
      "FCD4F2" => ["CocaCola", "The Coca Cola Company"],
      "FCD4F6" => ["MessanaA", "Messana Air.Ray Conditioning s.r.l."],
      "FCD6BD" => ["RobertBo", "Robert Bosch GmbH"],
      "FCE192" => ["SichuanJ", "Sichuan Jinwangtong Electronic Science&Technology Co,.Ltd"],
      "FCE23F" => ["ClayPaky", "CLAY PAKY SPA"],
      "FCE557" => ["Nokia", "Nokia Corporation"],
      "FCE892" => ["Hangzhou", "Hangzhou Lancable Technology Co.,Ltd"],
      "FCEDB9" => ["Arrayent",""],
      "FCF1CD" => ["Optex-Fa", "OPTEX-FA CO.,LTD."],
      "FCF8AE" => ["IntelCor", "Intel Corporate"],
      "FCFAF7" => ["Shanghai", "Shanghai Baud Data Communication Co.,Ltd."],
      "FCFBFB" => ["Cisco", "Cisco Systems"],
      "FFFFFF" => ["BROADCAST", ""]
    }
end
end
