/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;
import java.util.function.Predicate;

public class UniOnFailureTransform<I, O>
extends UniOperator<I, O> {
    private final Function<? super Throwable, ? extends Throwable> mapper;
    private final Predicate<? super Throwable> predicate;

    public UniOnFailureTransform(Uni<I> upstream, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(UniSubscriber<? super O> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnFailureTransformProcessor(subscriber));
    }

    private class UniOnFailureTransformProcessor
    extends UniOperatorProcessor<I, O> {
        public UniOnFailureTransformProcessor(UniSubscriber<? super O> downstream) {
            super(downstream);
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isCancelled()) {
                boolean test;
                try {
                    test = UniOnFailureTransform.this.predicate.test(failure);
                }
                catch (Throwable err) {
                    this.downstream.onFailure(new CompositeException(failure, err));
                    return;
                }
                if (test) {
                    Throwable outcome;
                    try {
                        outcome = UniOnFailureTransform.this.mapper.apply(failure);
                    }
                    catch (Throwable e) {
                        this.downstream.onFailure(e);
                        return;
                    }
                    if (outcome == null) {
                        this.downstream.onFailure(new NullPointerException("The supplier returned `null`"));
                    } else {
                        this.downstream.onFailure(outcome);
                    }
                } else {
                    this.downstream.onFailure(failure);
                }
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }
    }
}

