/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.NotIndexedCollectionException;
import org.hibernate.query.PathException;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPluralJoin;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmListPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmTreatedEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmPluralValuedSimplePath<C>
extends AbstractSqmSimplePath<C> {
    public SqmPluralValuedSimplePath(NavigablePath navigablePath, SqmPluralPersistentAttribute<?, C, ?> referencedNavigable, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        this(navigablePath, referencedNavigable, lhs, (String)null, nodeBuilder);
    }

    public SqmPluralValuedSimplePath(NavigablePath navigablePath, SqmPluralPersistentAttribute<?, C, ?> referencedNavigable, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, lhs, explicitAlias, nodeBuilder);
    }

    @Override
    public SqmPluralValuedSimplePath<C> copy(SqmCopyContext context) {
        SqmPluralValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmExpression lhsCopy = this.getLhs().copy(context);
        SqmPluralValuedSimplePath<C> path = context.registerCopy(this, new SqmPluralValuedSimplePath<C>(this.getNavigablePathCopy((SqmPath<?>)lhsCopy), (SqmPluralPersistentAttribute)this.getModel(), (SqmPath<?>)lhsCopy, this.getExplicitAlias(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    public PluralPersistentAttribute<?, C, ?> getPluralAttribute() {
        return (SqmPluralPersistentAttribute)this.getModel();
    }

    @Override
    public JavaType<C> getJavaTypeDescriptor() {
        return this.getPluralAttribute().getAttributeJavaType();
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitPluralValuedPath(this);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromNameExact(name);
        if (nature == null) {
            throw new PathException("Plural path '" + String.valueOf(this.getNavigablePath()) + "' refers to a collection and so element attribute '" + name + "' may not be referenced directly (use element() function)");
        }
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        SqmPathRegistry pathRegistry = creationState.getCurrentProcessingState().getPathRegistry();
        String alias = selector.toHqlString();
        NavigablePath navigablePath = this.getNavigablePath().getParent().append(this.getNavigablePath().getLocalName(), alias).append(CollectionPart.Nature.ELEMENT.getName());
        Object indexedPath = pathRegistry.findFromByPath(navigablePath);
        if (indexedPath != null) {
            return indexedPath;
        }
        Object path = pathRegistry.findFromByPath(navigablePath.getParent());
        if (path == null) {
            Expression index;
            AbstractSqmPluralJoin join;
            SqmPathSource referencedPathSource = this.getReferencedPathSource();
            Object parent = pathRegistry.resolveFrom((SqmPath<?>)this.getLhs());
            if (referencedPathSource instanceof ListPersistentAttribute) {
                join = new SqmListJoin(parent, (SqmListPersistentAttribute)referencedPathSource, alias, SqmJoinType.INNER, false, parent.nodeBuilder());
                index = ((SqmListJoin)join).index();
            } else if (referencedPathSource instanceof MapPersistentAttribute) {
                join = new SqmMapJoin(parent, (SqmMapPersistentAttribute)referencedPathSource, alias, SqmJoinType.INNER, false, parent.nodeBuilder());
                index = ((SqmMapJoin)join).key();
            } else {
                throw new NotIndexedCollectionException("Index operator applied to path '" + String.valueOf(this.getNavigablePath()) + "' which is not a list or map");
            }
            join.setJoinPredicate((SqmPredicate)creationState.getCreationContext().getNodeBuilder().equal(index, selector));
            parent.addSqmJoin(join);
            path = join;
            pathRegistry.register((SqmPath<?>)path);
        }
        SqmIndexedCollectionAccessPath result = new SqmIndexedCollectionAccessPath(navigablePath, (SqmPath<?>)path, selector);
        pathRegistry.register(result);
        return result;
    }

    @Override
    public SqmExpression<Class<? extends C>> type() {
        throw new UnsupportedOperationException("Cannot access the type of plural valued simple paths");
    }

    @Override
    public <S extends C> SqmTreatedPath<C, S> treatAs(Class<S> treatJavaType) throws PathException {
        throw new UnsupportedOperationException("Cannot treat plural valued simple paths");
    }

    @Override
    public <S extends C> SqmTreatedEntityValuedSimplePath<C, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        throw new UnsupportedOperationException("Cannot treat plural valued simple paths");
    }
}

