/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.QueryTimeoutException;
import org.hibernate.Timeouts;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.H2AggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.H2FinalTableIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.internal.H2LockingSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.H2V1SequenceSupport;
import org.hibernate.dialect.sequence.H2V2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sql.ast.H2SqlAstTranslator;
import org.hibernate.dialect.temptable.H2GlobalTemporaryTableStrategy;
import org.hibernate.dialect.temptable.StandardLocalTemporaryTableStrategy;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.dialect.type.H2DurationIntervalSecondJdbcType;
import org.hibernate.dialect.type.H2JsonArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.H2JsonJdbcType;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.EnumJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.OrdinalEnumJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeUtcAsOffsetTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsInstantJdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class H2Dialect
extends Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(2, 1, 214);
    private final boolean ansiSequence;
    private final boolean cascadeConstraints;
    private final boolean useLocalTime;
    private final SequenceInformationExtractor sequenceInformationExtractor;
    private final String querySequenceString;
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate(this);
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
        case 23505 -> {
            int onIndex;
            String constraint = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violation: \"", "\"", sqle.getMessage());
            int v0 = onIndex = constraint == null ? -1 : constraint.indexOf(" ON ");
            if (onIndex > 0) {
                yield constraint.substring(0, onIndex);
            }
            yield constraint;
        }
        case 23502 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("column \"", "\"", sqle.getMessage());
        case 23503, 23506, 23513, 23514 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("constraint violation: \"", ":", sqle.getMessage());
        default -> null;
    });

    public H2Dialect(DialectResolutionInfo info) {
        this(H2Dialect.staticDetermineDatabaseVersion(info));
        this.registerKeywords(info);
    }

    public H2Dialect() {
        this(MINIMUM_VERSION);
    }

    public H2Dialect(DatabaseVersion version) {
        super(version);
        this.ansiSequence = true;
        this.cascadeConstraints = true;
        this.useLocalTime = true;
        this.sequenceInformationExtractor = SequenceInformationExtractorLegacyImpl.INSTANCE;
        this.querySequenceString = "select * from INFORMATION_SCHEMA.SEQUENCES";
    }

    @Override
    public DatabaseVersion determineDatabaseVersion(DialectResolutionInfo info) {
        return H2Dialect.staticDetermineDatabaseVersion(info);
    }

    private static DatabaseVersion staticDetermineDatabaseVersion(DialectResolutionInfo info) {
        DatabaseVersion version = info.makeCopyOrDefault(MINIMUM_VERSION);
        return info.getDatabaseVersion() != null ? DatabaseVersion.make(version.getMajor(), version.getMinor(), H2Dialect.parseBuildId(info)) : version;
    }

    private static int parseBuildId(DialectResolutionInfo info) {
        String databaseVersion = info.getDatabaseVersion();
        if (databaseVersion == null) {
            return 0;
        }
        String[] bits = StringHelper.split(". -", databaseVersion);
        return bits.length > 2 ? Integer.parseInt(bits[2]) : 0;
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    @Override
    public boolean supportsStandardArrays() {
        return true;
    }

    @Override
    public boolean useArrayForMultiValuedParameters() {
        return false;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -15 -> this.columnType(1);
            case -9 -> this.columnType(12);
            case 2011 -> this.columnType(2005);
            default -> super.columnType(sqlTypeCode);
        };
    }

    @Override
    protected String castType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -15, 1 -> "char";
            case -9, 12, 4001, 4002 -> "varchar";
            case -3, -2, 4003 -> "varbinary";
            default -> super.castType(sqlTypeCode);
        };
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3100, "interval second($p,$s)", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "json", this));
        ddlTypeRegistry.addDescriptor(new NativeEnumDdlTypeImpl(this));
        ddlTypeRegistry.addDescriptor(new NativeOrdinalEnumDdlTypeImpl(this));
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(TimeUtcAsOffsetTimeJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(TimestampUtcAsInstantJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent(UUIDJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent(H2DurationIntervalSecondJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent(H2JsonJdbcType.INSTANCE);
        jdbcTypeRegistry.addTypeConstructor(H2JsonArrayJdbcTypeConstructor.INSTANCE);
        jdbcTypeRegistry.addDescriptor(EnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(OrdinalEnumJdbcType.INSTANCE);
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return H2AggregateSupport.valueOf(this);
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public boolean hasOddDstBehavior() {
        return true;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.pi();
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.mod_operator();
        functionFactory.rand();
        functionFactory.soundex();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.bitAndOr();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayOfWeekMonthYear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        if (this.useLocalTime) {
            functionFactory.localtimeLocaltimestamp();
        }
        functionFactory.trunc_dateTrunc();
        functionFactory.dateTrunc();
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.octetLength();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.chr_char();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.trim1();
        functionFactory.concat_pipeOperator();
        functionFactory.nowCurdateCurtime();
        functionFactory.sysdate();
        functionFactory.insert();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        functionFactory.format_formatdatetime();
        functionFactory.rownum();
        functionFactory.windowFunctions();
        functionFactory.listagg(null);
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.array();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_h2(this.getMaximumArraySize());
        functionFactory.arrayPositions_h2(this.getMaximumArraySize());
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_operator();
        functionFactory.arrayPrepend_operator();
        functionFactory.arrayAppend_operator();
        functionFactory.arrayContains_h2(this.getMaximumArraySize());
        functionFactory.arrayIntersects_h2(this.getMaximumArraySize());
        functionFactory.arrayGet_h2();
        functionFactory.arraySet_h2(this.getMaximumArraySize());
        functionFactory.arrayRemove_h2(this.getMaximumArraySize());
        functionFactory.arrayRemoveIndex_h2(this.getMaximumArraySize());
        functionFactory.arraySlice();
        functionFactory.arrayReplace_h2(this.getMaximumArraySize());
        functionFactory.arrayTrim_trim_array();
        functionFactory.arrayFill_h2();
        functionFactory.arrayToString_h2(this.getMaximumArraySize());
        functionFactory.jsonObject();
        functionFactory.jsonArray();
        if (this.getVersion().isSameOrAfter(2, 2, 220)) {
            functionFactory.jsonValue_h2();
            functionFactory.jsonQuery_h2();
            functionFactory.jsonExists_h2();
            functionFactory.jsonArrayAgg_h2();
            functionFactory.jsonObjectAgg_h2();
        }
        functionFactory.xmlelement_h2();
        functionFactory.xmlcomment();
        functionFactory.xmlforest_h2();
        functionFactory.xmlconcat_h2();
        functionFactory.xmlpi_h2();
        functionFactory.unnest_h2(this.getMaximumArraySize());
        functionFactory.generateSeries_h2(this.getMaximumSeriesSize());
        functionFactory.jsonTable_h2(this.getMaximumArraySize());
        functionFactory.hex("rawtohex(?1)");
        functionFactory.sha("hash('SHA-256', ?1)");
        functionFactory.md5("hash('MD5', ?1)");
    }

    protected int getMaximumArraySize() {
        return 1000;
    }

    protected int getMaximumSeriesSize() {
        return 10000;
    }

    @Override
    public @Nullable String getDefaultOrdinalityColumnName() {
        return "nord";
    }

    @Override
    public void augmentPhysicalTableTypes(List<String> tableTypesList) {
        tableTypesList.add("BASE TABLE");
    }

    @Override
    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        return switch (columnTypeName) {
            case "FLOAT(24)" -> 7;
            default -> super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
        };
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 6: {
                if (!"DOUBLE PRECISION".equals(columnTypeName)) break;
                return jdbcTypeRegistry.getDescriptor(8);
            }
            case 1111: {
                if ("GEOMETRY".equals(columnTypeName)) {
                    return jdbcTypeRegistry.getDescriptor(3200);
                }
                if (!"JSON".equals(columnTypeName)) break;
                return jdbcTypeRegistry.getDescriptor(3001);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    protected Integer resolveSqlTypeCode(String typeName, String baseTypeName, TypeConfiguration typeConfiguration) {
        return switch (baseTypeName) {
            case "CHARACTER VARYING" -> 12;
            default -> super.resolveSqlTypeCode(typeName, baseTypeName, typeConfiguration);
        };
    }

    @Override
    public int getMaxVarcharLength() {
        return 0x100000;
    }

    @Override
    public String currentTime() {
        return this.useLocalTime ? "localtime" : super.currentTime();
    }

    @Override
    public String currentTimestamp() {
        return this.useLocalTime ? "localtimestamp" : super.currentTimestamp();
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new H2SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return unit == TemporalUnit.SECOND ? "(" + super.extractPattern(unit) + "+extract(nanosecond from ?2)/1e9)" : super.extractPattern(unit);
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (from == CastType.STRING && to == CastType.BOOLEAN) {
            return "cast(?1 as ?2)";
        }
        return super.castPattern(from, to);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        return unit == TemporalUnit.SECOND ? "dateadd(nanosecond,?2*1e9,?3)" : "dateadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        return "datediff(?1,?2,?3)";
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, true, jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, false, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, date, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, date);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, calendar, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, calendar);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean supportsTimeLiteralOffset() {
        return true;
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    @Override
    public boolean supportsIsTrue() {
        return true;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public LockingSupport getLockingSupport() {
        return this.getVersion().isSameOrAfter(2, 2, 220) ? H2LockingSupport.INSTANCE : H2LockingSupport.LEGACY_INSTANCE;
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait";
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.getForUpdateString() + " skip locked";
    }

    @Override
    public String getForUpdateString(Timeout timeout) {
        return this.withRealTimeout(this.getForUpdateString(), timeout);
    }

    private String withRealTimeout(String lockString, Timeout timeout) {
        assert (Timeouts.isRealTimeout(timeout));
        return lockString + " wait " + Timeouts.getTimeoutInSeconds(timeout);
    }

    private String withRealTimeout(String lockString, int millis) {
        assert (Timeouts.isRealTimeout(millis));
        return lockString + " wait " + Timeouts.getTimeoutInSeconds(millis);
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return !this.supportsIfExistsBeforeTableName();
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public String getCascadeConstraintsString() {
        return this.cascadeConstraints ? " cascade " : super.getCascadeConstraintsString();
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "alter column " + columnName + " set data type " + columnType;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.ansiSequence ? H2V2SequenceSupport.INSTANCE : H2V1SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.sequenceInformationExtractor;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(entityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(entityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return H2GlobalTemporaryTableStrategy.INSTANCE.getTemporaryTableCreateOptions();
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    @Override
    public TemporaryTableStrategy getGlobalTemporaryTableStrategy() {
        return H2GlobalTemporaryTableStrategy.INSTANCE;
    }

    @Override
    public TemporaryTableStrategy getLocalTemporaryTableStrategy() {
        return StandardLocalTemporaryTableStrategy.INSTANCE;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> switch (JdbcExceptionHelper.extractErrorCode(sqlException)) {
            case 40001 -> new LockAcquisitionException(message, sqlException, sql);
            case 50200 -> new LockTimeoutException(message, sqlException, sql);
            case 23505 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case 23502 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.NOT_NULL, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case 23503, 23506 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.FOREIGN_KEY, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case 23513, 23514 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.CHECK, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case 57014 -> new QueryTimeoutException(message, sqlException, sql);
            default -> null;
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.ALIAS;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return true;
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_GROUP_AND_CONSTANTS;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return H2FinalTableIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsInsertReturning() {
        return true;
    }

    @Override
    public boolean supportsInsertReturningRowId() {
        return false;
    }

    @Override
    public boolean supportsInsertReturningGeneratedKeys() {
        return true;
    }

    @Override
    public boolean unquoteGetGeneratedKeys() {
        return true;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        return position;
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return H2Dialect.addUseIndexQueryHint(query, hints);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(new Replacer(format, "'", "''").replace("e", "u").replace("xxx", "XXX").replace("xx", "XX").replace("x", "X").result());
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_MONTH -> "day";
            case TemporalUnit.WEEK -> "iso_week";
            default -> unit.toString();
        };
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    @Override
    public boolean canDisableConstraints() {
        return true;
    }

    @Override
    public String getEnableConstraintsStatement() {
        return "set referential_integrity true";
    }

    @Override
    public String getEnumTypeDeclaration(String name, String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        return type.append(')').toString();
    }

    @Override
    public String getDisableConstraintsStatement() {
        return "set referential_integrity false";
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public String rowId(String rowId) {
        return "_rowid_";
    }

    @Override
    public int rowIdSqlType() {
        return -5;
    }

    @Override
    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return new H2SqlAstTranslator(factory, optionalTableUpdate).createMergeOperation(optionalTableUpdate);
    }

    @Override
    public ParameterMarkerStrategy getNativeParameterMarkerStrategy() {
        return OrdinalParameterMarkerStrategy.INSTANCE;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsBindingNullSqlTypeForSetNull() {
        return true;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public String getDual() {
        return "dual";
    }

    @Override
    public boolean supportsFilterClause() {
        return true;
    }

    @Override
    public boolean supportsRowConstructor() {
        return true;
    }

    @Override
    public boolean supportsArrayConstructor() {
        return true;
    }

    @Override
    public boolean supportsJoinInMutationStatementSubquery() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorDistinctFromSyntax() {
        return true;
    }

    @Override
    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return true;
    }

    public static class OrdinalParameterMarkerStrategy
    implements ParameterMarkerStrategy {
        public static final OrdinalParameterMarkerStrategy INSTANCE = new OrdinalParameterMarkerStrategy();

        @Override
        public String createMarker(int position, JdbcType jdbcType) {
            return "?" + position;
        }
    }
}

