/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;

public class AliasedExpression
implements SelfRenderingExpression {
    private final Expression expression;
    private final String alias;

    public AliasedExpression(Expression expression, String alias) {
        this.expression = expression;
        this.alias = alias;
    }

    @Override
    public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
        this.expression.accept(walker);
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.alias);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.expression.getExpressionType();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getAlias() {
        return this.alias;
    }
}

