/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.BuiltinValidators;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class ImmutableAttributeValidator
implements SimpleValidator {
    public static final String ID = "up-immutable-attribute";
    private static final String DEFAULT_ERROR_MESSAGE = "error-user-attribute-read-only";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values;
        List currentValue;
        UserProfileAttributeValidationContext ac = (UserProfileAttributeValidationContext)context;
        AttributeContext attributeContext = ac.getAttributeContext();
        UserModel user = attributeContext.getUser();
        if (user == null) {
            return context;
        }
        Stream<String> rawValues = user.getAttributeStream(inputHint).filter(Objects::nonNull);
        if (!user.isFederated() && "username".equals(inputHint)) {
            rawValues = rawValues.map(String::toLowerCase);
        }
        if (!CollectionUtil.collectionEquals(currentValue = rawValues.collect(Collectors.toList()), (Collection)(values = (List)input)) && this.isReadOnly(attributeContext)) {
            if (currentValue.isEmpty() && !BuiltinValidators.notBlankValidator().validate((Object)values).isValid()) {
                return context;
            }
            RealmModel realm = ac.getSession().getContext().getRealm();
            if (realm.isRegistrationEmailAsUsername()) {
                String attributeName = attributeContext.getMetadata().getName();
                if ("email".equals(attributeName)) {
                    return context;
                }
                List email = attributeContext.getAttributes().get("email");
                if ("username".equals(attributeName) && CollectionUtil.collectionEquals((Collection)values, (Collection)email)) {
                    return context;
                }
            }
            context.addError(new ValidationError(ID, inputHint, DEFAULT_ERROR_MESSAGE));
        }
        return context;
    }

    private boolean isReadOnly(AttributeContext attributeContext) {
        return attributeContext.getMetadata().isReadOnly(attributeContext);
    }
}

