/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Service(value={Service.Level.PROJECT})
@State(name="GradleLocalSettings", storages={@Storage(value="$CACHE_FILE$")})
public final class GradleLocalSettings
extends AbstractExternalSystemLocalSettings<MyState>
implements PersistentStateComponent<MyState> {
    public GradleLocalSettings(@NotNull Project project) {
        if (project == null) {
            GradleLocalSettings.$$$reportNull$$$0(0);
        }
        super(GradleConstants.SYSTEM_ID, project, (AbstractExternalSystemLocalSettings.State)new MyState());
    }

    @NotNull
    public static GradleLocalSettings getInstance(@NotNull Project project) {
        if (project == null) {
            GradleLocalSettings.$$$reportNull$$$0(1);
        }
        GradleLocalSettings gradleLocalSettings = (GradleLocalSettings)((Object)project.getService(GradleLocalSettings.class));
        if (gradleLocalSettings == null) {
            GradleLocalSettings.$$$reportNull$$$0(2);
        }
        return gradleLocalSettings;
    }

    @Nullable
    public String getGradleHome(String linkedProjectPath) {
        return (String)ContainerUtil.notNullize(((MyState)this.state).myGradleHomes).get(linkedProjectPath);
    }

    @Nullable
    public String getGradleVersion(String linkedProjectPath) {
        return (String)ContainerUtil.notNullize(((MyState)this.state).myGradleVersions).get(linkedProjectPath);
    }

    public void setGradleHome(@NotNull String linkedProjectPath, @NotNull String gradleHome) {
        if (linkedProjectPath == null) {
            GradleLocalSettings.$$$reportNull$$$0(3);
        }
        if (gradleHome == null) {
            GradleLocalSettings.$$$reportNull$$$0(4);
        }
        if (((MyState)this.state).myGradleHomes == null) {
            ((MyState)this.state).myGradleHomes = new HashMap<String, String>();
        }
        ((MyState)this.state).myGradleHomes.put(linkedProjectPath, gradleHome);
        if (((MyState)this.state).myGradleVersions == null) {
            ((MyState)this.state).myGradleVersions = new HashMap<String, String>();
        }
        ((MyState)this.state).myGradleVersions.put(linkedProjectPath, GradleInstallationManager.getGradleVersion(Path.of(gradleHome, new String[0])));
    }

    @ApiStatus.Internal
    @Nullable
    public String getGradleUserHome() {
        return ((MyState)this.state).myGradleUserHome;
    }

    @ApiStatus.Internal
    public void setGradleUserHome(@Nullable String gradleUserHome) {
        ((MyState)this.state).myGradleUserHome = gradleUserHome;
        GradleSystemSettings.getInstance().setServiceDirectoryPath(gradleUserHome);
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        if (linkedProjectPathsToForget == null) {
            GradleLocalSettings.$$$reportNull$$$0(5);
        }
        super.forgetExternalProjects(linkedProjectPathsToForget);
        for (String path : linkedProjectPathsToForget) {
            if (((MyState)this.state).myGradleHomes != null) {
                ((MyState)this.state).myGradleHomes.remove(path);
            }
            if (((MyState)this.state).myGradleVersions == null) continue;
            ((MyState)this.state).myGradleVersions.remove(path);
        }
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            GradleLocalSettings.$$$reportNull$$$0(6);
        }
        super.loadState((AbstractExternalSystemLocalSettings.State)state);
        String serviceDirectoryPath = GradleSystemSettings.getInstance().getServiceDirectoryPath();
        if (state.myGradleUserHome == null && serviceDirectoryPath != null) {
            state.myGradleUserHome = serviceDirectoryPath;
        }
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        if (((MyState)this.state).myGradleHomes != null) {
            ((MyState)this.state).myGradleHomes.clear();
        }
        if (((MyState)this.state).myGradleVersions != null) {
            ((MyState)this.state).myGradleVersions.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleLocalSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleHome";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPathsToForget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleLocalSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGradleHome";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forgetExternalProjects";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class MyState
    extends AbstractExternalSystemLocalSettings.State {
        public String myGradleUserHome;
        public Map<String, String> myGradleHomes;
        public Map<String, String> myGradleVersions;
    }
}

