/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualTo;
import org.assertj.core.error.ShouldBeAfterYear;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualTo;
import org.assertj.core.error.ShouldBeBeforeYear;
import org.assertj.core.error.ShouldBeBetween;
import org.assertj.core.error.ShouldBeCloseTo;
import org.assertj.core.error.ShouldBeEqualWithTimePrecision;
import org.assertj.core.error.ShouldBeInSameDay;
import org.assertj.core.error.ShouldBeInSameHour;
import org.assertj.core.error.ShouldBeInSameHourWindow;
import org.assertj.core.error.ShouldBeInSameMinute;
import org.assertj.core.error.ShouldBeInSameMinuteWindow;
import org.assertj.core.error.ShouldBeInSameMonth;
import org.assertj.core.error.ShouldBeInSameSecond;
import org.assertj.core.error.ShouldBeInSameSecondWindow;
import org.assertj.core.error.ShouldBeInSameYear;
import org.assertj.core.error.ShouldBeInTheFuture;
import org.assertj.core.error.ShouldBeInThePast;
import org.assertj.core.error.ShouldBeToday;
import org.assertj.core.error.ShouldHaveDateField;
import org.assertj.core.error.ShouldHaveSameTime;
import org.assertj.core.error.ShouldHaveTime;
import org.assertj.core.error.ShouldNotBeBetween;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.DateUtil;

public class Dates {
    private static final Dates INSTANCE = new Dates();
    Failures failures = Failures.instance();
    private final ComparisonStrategy comparisonStrategy;

    public static Dates instance() {
        return INSTANCE;
    }

    Dates() {
        this(StandardComparisonStrategy.instance());
    }

    public Dates(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    public Comparator<?> getComparator() {
        Comparator<?> comparator;
        ComparisonStrategy comparisonStrategy = this.comparisonStrategy;
        if (comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            ComparatorBasedComparisonStrategy strategy = (ComparatorBasedComparisonStrategy)comparisonStrategy;
            comparator = strategy.getComparator();
        } else {
            comparator = null;
        }
        return comparator;
    }

    public void assertIsBefore(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!this.isBefore(actual, other)) {
            throw this.failures.failure(info, ShouldBeBefore.shouldBeBefore(actual, other, this.comparisonStrategy));
        }
    }

    public void assertIsBeforeOrEqualTo(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!this.isBeforeOrEqualTo(actual, other)) {
            throw this.failures.failure(info, ShouldBeBeforeOrEqualTo.shouldBeBeforeOrEqualTo(actual, other, this.comparisonStrategy));
        }
    }

    public void assertIsAfter(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!this.isAfter(actual, other)) {
            throw this.failures.failure(info, ShouldBeAfter.shouldBeAfter(actual, other, this.comparisonStrategy));
        }
    }

    public void assertIsAfterOrEqualTo(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!this.isAfterOrEqualTo(actual, other)) {
            throw this.failures.failure(info, ShouldBeAfterOrEqualTo.shouldBeAfterOrEqualTo(actual, other, this.comparisonStrategy));
        }
    }

    public void assertIsEqualWithPrecision(AssertionInfo info, Date actual, Date other, TimeUnit precision) {
        this.assertNotNull(info, actual);
        Calendar calendarActual = Calendar.getInstance();
        calendarActual.setTime(actual);
        Calendar calendarOther = Calendar.getInstance();
        calendarOther.setTime(other);
        switch (precision) {
            case DAYS: {
                calendarActual.set(7, 0);
                calendarOther.set(7, 0);
            }
            case HOURS: {
                calendarActual.set(11, 0);
                calendarOther.set(11, 0);
            }
            case MINUTES: {
                calendarActual.set(12, 0);
                calendarOther.set(12, 0);
            }
            case SECONDS: {
                calendarActual.set(13, 0);
                calendarOther.set(13, 0);
            }
            case MILLISECONDS: {
                calendarActual.set(14, 0);
                calendarOther.set(14, 0);
            }
            case MICROSECONDS: {
                break;
            }
        }
        if (calendarActual.compareTo(calendarOther) != 0) {
            throw this.failures.failure(info, ShouldBeEqualWithTimePrecision.shouldBeEqual(actual, other, precision));
        }
    }

    public void assertIsBetween(AssertionInfo info, Date actual, Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        if (!this.actualIsBetweenGivenPeriod(info, actual, start, end, inclusiveStart, inclusiveEnd)) {
            throw this.failures.failure(info, ShouldBeBetween.shouldBeBetween(actual, start, end, inclusiveStart, inclusiveEnd, this.comparisonStrategy));
        }
    }

    private boolean actualIsBetweenGivenPeriod(AssertionInfo info, Date actual, Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.assertNotNull(info, actual);
        Dates.startDateParameterIsNotNull(start);
        Dates.endDateParameterIsNotNull(end);
        boolean checkLowerBoundaryPeriod = inclusiveStart ? this.isAfterOrEqualTo(actual, start) : this.isAfter(actual, start);
        boolean checkUpperBoundaryPeriod = inclusiveEnd ? this.isBeforeOrEqualTo(actual, end) : this.isBefore(actual, end);
        return checkLowerBoundaryPeriod && checkUpperBoundaryPeriod;
    }

    public void assertIsNotBetween(AssertionInfo info, Date actual, Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        if (this.actualIsBetweenGivenPeriod(info, actual, start, end, inclusiveStart, inclusiveEnd)) {
            throw this.failures.failure(info, ShouldNotBeBetween.shouldNotBeBetween(actual, start, end, inclusiveStart, inclusiveEnd, this.comparisonStrategy));
        }
    }

    public void assertIsInThePast(AssertionInfo info, Date actual) {
        this.assertNotNull(info, actual);
        if (!this.isBefore(actual, DateUtil.now())) {
            throw this.failures.failure(info, ShouldBeInThePast.shouldBeInThePast(actual, this.comparisonStrategy));
        }
    }

    public void assertIsToday(AssertionInfo info, Date actual) {
        this.assertNotNull(info, actual);
        Date todayWithoutTime = DateUtil.truncateTime(DateUtil.now());
        Date actualWithoutTime = DateUtil.truncateTime(actual);
        if (!this.areEqual(actualWithoutTime, todayWithoutTime)) {
            throw this.failures.failure(info, ShouldBeToday.shouldBeToday(actual, this.comparisonStrategy));
        }
    }

    public void assertIsInTheFuture(AssertionInfo info, Date actual) {
        this.assertNotNull(info, actual);
        if (!this.isAfter(actual, DateUtil.now())) {
            throw this.failures.failure(info, ShouldBeInTheFuture.shouldBeInTheFuture(actual, this.comparisonStrategy));
        }
    }

    public void assertIsBeforeYear(AssertionInfo info, Date actual, int year) {
        this.assertNotNull(info, actual);
        if (DateUtil.yearOf(actual) >= year) {
            throw this.failures.failure(info, ShouldBeBeforeYear.shouldBeBeforeYear(actual, year));
        }
    }

    public void assertIsAfterYear(AssertionInfo info, Date actual, int year) {
        this.assertNotNull(info, actual);
        if (DateUtil.yearOf(actual) <= year) {
            throw this.failures.failure(info, ShouldBeAfterYear.shouldBeAfterYear(actual, year));
        }
    }

    public void assertHasYear(AssertionInfo info, Date actual, int year) {
        this.assertNotNull(info, actual);
        if (DateUtil.yearOf(actual) != year) {
            throw this.failures.failure(info, ShouldHaveDateField.shouldHaveDateField(actual, "year", year));
        }
    }

    public void assertHasMonth(AssertionInfo info, Date actual, int month) {
        this.assertNotNull(info, actual);
        if (DateUtil.monthOf(actual) != month) {
            throw this.failures.failure(info, ShouldHaveDateField.shouldHaveDateField(actual, "month", month));
        }
    }

    public void assertHasDayOfMonth(AssertionInfo info, Date actual, int dayOfMonth) {
        this.assertNotNull(info, actual);
        if (DateUtil.dayOfMonthOf(actual) != dayOfMonth) {
            throw this.failures.failure(info, ShouldHaveDateField.shouldHaveDateField(actual, "day of month", dayOfMonth));
        }
    }

    public void assertHasDayOfWeek(AssertionInfo info, Date actual, int dayOfWeek) {
        this.assertNotNull(info, actual);
        if (DateUtil.dayOfWeekOf(actual) != dayOfWeek) {
            throw this.failures.failure(info, ShouldHaveDateField.shouldHaveDateField(actual, "day of week", dayOfWeek));
        }
    }

    public void assertHasHourOfDay(AssertionInfo info, Date actual, int hourOfDay) {
        this.assertNotNull(info, actual);
        if (DateUtil.hourOfDayOf(actual) != hourOfDay) {
            throw this.failures.failure(info, ShouldHaveDateField.shouldHaveDateField(actual, "hour", hourOfDay));
        }
    }

    public void assertHasMinute(AssertionInfo info, Date actual, int minute) {
        this.assertNotNull(info, actual);
        if (DateUtil.minuteOf(actual) != minute) {
            throw this.failures.failure(info, ShouldHaveDateField.shouldHaveDateField(actual, "minute", minute));
        }
    }

    public void assertHasSecond(AssertionInfo info, Date actual, int second) {
        this.assertNotNull(info, actual);
        if (DateUtil.secondOf(actual) != second) {
            throw this.failures.failure(info, ShouldHaveDateField.shouldHaveDateField(actual, "second", second));
        }
    }

    public void assertHasMillisecond(AssertionInfo info, Date actual, int millisecond) {
        this.assertNotNull(info, actual);
        if (DateUtil.millisecondOf(actual) != millisecond) {
            throw this.failures.failure(info, ShouldHaveDateField.shouldHaveDateField(actual, "millisecond", millisecond));
        }
    }

    public void assertIsInSameYearAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameYear(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameYear.shouldBeInSameYear(actual, other));
        }
    }

    private static boolean areInSameYear(Date actual, Date other) {
        return DateUtil.yearOf(actual) == DateUtil.yearOf(other);
    }

    public void assertIsInSameMonthAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameMonth(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameMonth.shouldBeInSameMonth(actual, other));
        }
    }

    private static boolean areInSameMonth(Date actual, Date other) {
        return Dates.areInSameYear(actual, other) && DateUtil.monthOf(actual) == DateUtil.monthOf(other);
    }

    public void assertIsInSameDayAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameDayOfMonth(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameDay.shouldBeInSameDay(actual, other));
        }
    }

    private static boolean areInSameDayOfMonth(Date actual, Date other) {
        return Dates.areInSameMonth(actual, other) && DateUtil.dayOfMonthOf(actual) == DateUtil.dayOfMonthOf(other);
    }

    public void assertIsInSameHourAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameHour(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameHour.shouldBeInSameHour(actual, other));
        }
    }

    public void assertIsInSameHourWindowAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameHourWindow(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameHourWindow.shouldBeInSameHourWindow(actual, other));
        }
    }

    private static boolean areInSameHourWindow(Date actual, Date other) {
        return DateUtil.timeDifference(actual, other) < TimeUnit.HOURS.toMillis(1L);
    }

    private static boolean areInSameHour(Date actual, Date other) {
        return Dates.areInSameDayOfMonth(actual, other) && DateUtil.hourOfDayOf(actual) == DateUtil.hourOfDayOf(other);
    }

    public void assertIsInSameMinuteAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameMinute(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameMinute.shouldBeInSameMinute(actual, other));
        }
    }

    public void assertIsInSameMinuteWindowAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameMinuteWindow(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameMinuteWindow.shouldBeInSameMinuteWindow(actual, other));
        }
    }

    private static boolean areInSameMinute(Date actual, Date other) {
        return Dates.areInSameHour(actual, other) && DateUtil.minuteOf(actual) == DateUtil.minuteOf(other);
    }

    private static boolean areInSameMinuteWindow(Date actual, Date other) {
        return DateUtil.timeDifference(actual, other) < TimeUnit.MINUTES.toMillis(1L);
    }

    public void assertIsInSameSecondAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameSecond(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameSecond.shouldBeInSameSecond(actual, other));
        }
    }

    public void assertIsInSameSecondWindowAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameSecondWindow(actual, other)) {
            throw this.failures.failure(info, ShouldBeInSameSecondWindow.shouldBeInSameSecondWindow(actual, other));
        }
    }

    private static boolean areInSameSecondWindow(Date actual, Date other) {
        return DateUtil.timeDifference(actual, other) < TimeUnit.SECONDS.toMillis(1L);
    }

    private static boolean areInSameSecond(Date actual, Date other) {
        return Dates.areInSameMinute(actual, other) && DateUtil.secondOf(actual) == DateUtil.secondOf(other);
    }

    public void assertIsCloseTo(AssertionInfo info, Date actual, Date other, long deltaInMilliseconds) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        long difference = Math.abs(actual.getTime() - other.getTime());
        if (difference > deltaInMilliseconds) {
            throw this.failures.failure(info, ShouldBeCloseTo.shouldBeCloseTo(actual, other, deltaInMilliseconds, difference));
        }
    }

    public void assertHasTime(AssertionInfo info, Date actual, long timestamp) {
        this.assertNotNull(info, actual);
        if (actual.getTime() != timestamp) {
            throw this.failures.failure(info, ShouldHaveTime.shouldHaveTime(actual, timestamp));
        }
    }

    public void assertHasSameTime(AssertionInfo info, Date actual, Date expected) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(expected);
        if (actual.getTime() != expected.getTime()) {
            throw this.failures.failure(info, ShouldHaveSameTime.shouldHaveSameTime(actual, expected));
        }
    }

    public void hasSameTimeAs(AssertionInfo info, Date actual, Date date) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(date);
        this.assertHasSameTime(info, actual, date);
    }

    private static void dateParameterIsNotNull(Date date) {
        java.util.Objects.requireNonNull(date, "The date to compare actual with should not be null");
    }

    private static void startDateParameterIsNotNull(Date start) {
        java.util.Objects.requireNonNull(start, "The start date of period to compare actual with should not be null");
    }

    private static void endDateParameterIsNotNull(Date end) {
        java.util.Objects.requireNonNull(end, "The end date of period to compare actual with should not be null");
    }

    private void assertNotNull(AssertionInfo info, Date actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private boolean isBeforeOrEqualTo(Date actual, Date other) {
        return this.comparisonStrategy.isLessThanOrEqualTo(actual, other);
    }

    private boolean areEqual(Date actual, Date other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    private boolean isAfterOrEqualTo(Date actual, Date other) {
        return this.comparisonStrategy.isGreaterThanOrEqualTo(actual, other);
    }

    private boolean isBefore(Date actual, Date other) {
        return this.comparisonStrategy.isLessThan(actual, other);
    }

    private boolean isAfter(Date actual, Date other) {
        return this.comparisonStrategy.isGreaterThan(actual, other);
    }
}

