/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.message.BodyLimitSettings;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends JPanel
implements Disposable,
UiCompatibleDataProvider,
CommitMessageUi,
CommitMessageI {
    public static final Key<CommitMessage> DATA_KEY = Key.create((String)"Vcs.CommitMessage.Panel");
    public static final Key<Supplier<Iterable<Change>>> CHANGES_SUPPLIER_KEY = Key.create((String)"Vcs.CommitMessage.CompletionContext");
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @Nullable
    @Nls
    private final String myMessagePlaceholder;
    @NotNull
    private static final EditorCustomization COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION = editor -> {
        editor.setBackgroundColor(null);
        editor.setColorsScheme(CommitMessage.getCommitMessageColorScheme(editor));
    };
    @NotNull
    private final EditorTextField myEditorField;
    @Nullable
    private final TitledSeparator mySeparator;

    @NotNull
    private static EditorColorsScheme getCommitMessageColorScheme(EditorEx editor) {
        boolean isEditorDark;
        boolean isLaFDark = ColorUtil.isDark((Color)UIUtil.getPanelBackground());
        EditorColorsScheme colorsScheme = isLaFDark == (isEditorDark = EditorColorsManager.getInstance().isDarkEditor()) ? EditorColorsManager.getInstance().getGlobalScheme() : EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        colorsScheme = editor.createBoundColorSchemeDelegate(colorsScheme);
        colorsScheme.setEditorFontSize(UISettingsUtils.getInstance().getScaledEditorFontSize());
        EditorColorsScheme editorColorsScheme = colorsScheme;
        if (editorColorsScheme == null) {
            CommitMessage.$$$reportNull$$$0(0);
        }
        return editorColorsScheme;
    }

    public CommitMessage(@NotNull Project project) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(1);
        }
        this(project, true, true, true);
    }

    public CommitMessage(@NotNull Project project, boolean withSeparator, boolean showToolbar, boolean runInspections) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(2);
        }
        this(project, withSeparator, showToolbar, runInspections, null);
    }

    public CommitMessage(@NotNull Project project, boolean withSeparator, boolean showToolbar, boolean runInspections, @Nullable @Nls String messagePlaceholder) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.myMessagePlaceholder = messagePlaceholder;
        this.myEditorField = CommitMessage.createCommitMessageEditor(project, runInspections);
        this.myEditorField.getDocument().putUserData(DATA_KEY, (Object)this);
        this.myEditorField.setPlaceholder((CharSequence)this.myMessagePlaceholder);
        this.myEditorField.setShowPlaceholderWhenFocused(true);
        this.myEditorField.getAccessibleContext().setAccessibleName(VcsBundle.message((String)"commit.message.editor.accessible.name", (Object[])new Object[0]));
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 0);
        this.myLoadingPanel.add((Component)this.myEditorField, (Object)"Center");
        this.add((Component)this.myLoadingPanel, "Center");
        if (withSeparator) {
            this.mySeparator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myEditorField.getComponent());
            BorderLayoutPanel separatorPanel = JBUI.Panels.simplePanel().addToBottom((Component)this.mySeparator).addToTop(Box.createVerticalGlue());
            BorderLayoutPanel labelPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)separatorPanel).withBorder(BorderFactory.createEmptyBorder());
            if (showToolbar) {
                labelPanel.addToRight((Component)this.createToolbar(true));
            }
            this.add((Component)labelPanel, "North");
        } else {
            this.mySeparator = null;
            if (showToolbar) {
                this.add((Component)this.createToolbar(false), "East");
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.updateOnInspectionProfileChanged(project);
    }

    public void stopLoading() {
        this.myLoadingPanel.stopLoading();
        this.myEditorField.setEnabled(true);
        this.myEditorField.setPlaceholder((CharSequence)this.myMessagePlaceholder);
    }

    public void startLoading() {
        this.myEditorField.setEnabled(false);
        this.myEditorField.setPlaceholder(null);
        this.myLoadingPanel.startLoading();
    }

    private void updateOnInspectionProfileChanged(@NotNull Project project) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(4);
        }
        project.getMessageBus().connect((Disposable)this).subscribe(CommitMessageInspectionProfile.TOPIC, () -> {
            Editor editor = this.myEditorField.getEditor();
            if (editor instanceof EditorEx) {
                RightMarginCustomization.customize(project, (EditorEx)editor);
            }
        });
    }

    @Override
    public void updateUI() {
        Editor editor;
        super.updateUI();
        Editor editor2 = editor = this.myEditorField != null ? this.myEditorField.getEditor() : null;
        if (editor instanceof EditorEx) {
            COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION.customize((EditorEx)editor);
        }
    }

    @NotNull
    public JComponent createToolbar(boolean horizontal) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CommitMessage", CommitMessage.getToolbarActions(), horizontal);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        toolbar.setTargetComponent((JComponent)this);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            CommitMessage.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            CommitMessage.$$$reportNull$$$0(6);
        }
        Editor editor = this.myEditorField.getEditor();
        sink.set(VcsDataKeys.COMMIT_MESSAGE_CONTROL, (Object)this);
        sink.set(VcsDataKeys.COMMIT_MESSAGE_DOCUMENT, (Object)(editor == null ? null : editor.getDocument()));
    }

    public void setSeparatorText(@NlsContexts.Separator @NotNull String text) {
        if (text == null) {
            CommitMessage.$$$reportNull$$$0(7);
        }
        if (this.mySeparator != null) {
            this.mySeparator.setText(text);
        }
    }

    public void setCommitMessage(@Nullable String currentDescription) {
        this.setText(currentDescription);
    }

    @NotNull
    private static EditorTextField createCommitMessageEditor(@NotNull Project project, boolean runInspections) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(8);
        }
        HashSet<Object> features = new HashSet<Object>();
        features.add(new RightMarginCustomization(project));
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        features.add(COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION);
        if (runInspections) {
            features.add(ErrorStripeEditorCustomization.ENABLED);
            features.add(new InspectionCustomization(project));
        } else {
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        }
        EditorTextField editorField = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        editorField.setFontInheritedFromLAF(false);
        EditorTextField editorTextField = editorField;
        if (editorTextField == null) {
            CommitMessage.$$$reportNull$$$0(9);
        }
        return editorTextField;
    }

    public static boolean isCommitMessage(@NotNull PsiElement element) {
        Document document;
        if (element == null) {
            CommitMessage.$$$reportNull$$$0(10);
        }
        return (document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile())) != null && CommitMessage.isCommitMessage(document);
    }

    public static boolean isCommitMessage(@NotNull Document document) {
        if (document == null) {
            CommitMessage.$$$reportNull$$$0(11);
        }
        return document.getUserData(DATA_KEY) != null;
    }

    @Nullable
    public static Editor getEditor(@NotNull Document document) {
        CommitMessage commitMessage;
        if (document == null) {
            CommitMessage.$$$reportNull$$$0(12);
        }
        return (commitMessage = (CommitMessage)document.getUserData(DATA_KEY)) != null ? commitMessage.getEditorField().getEditor() : null;
    }

    @NotNull
    private static ActionGroup getToolbarActions() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
        if (actionGroup == null) {
            CommitMessage.$$$reportNull$$$0(13);
        }
        return actionGroup;
    }

    @NotNull
    public EditorTextField getEditorField() {
        EditorTextField editorTextField = this.myEditorField;
        if (editorTextField == null) {
            CommitMessage.$$$reportNull$$$0(14);
        }
        return editorTextField;
    }

    @NotNull
    public String getText() {
        String string = this.getComment();
        if (string == null) {
            CommitMessage.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setText(@Nullable String initialMessage) {
        this.myEditorField.setText(initialMessage == null ? "" : StringUtil.convertLineSeparators((String)initialMessage));
    }

    public void focus() {
        this.requestFocusInMessage();
    }

    @NotNull
    public String getComment() {
        String string = StringUtil.trimTrailing((String)this.myEditorField.getDocument().getCharsSequence().toString());
        if (string == null) {
            CommitMessage.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void requestFocusInMessage() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorField, true));
        this.myEditorField.selectAll();
    }

    @RequiresEdt
    public void setChangesSupplier(@NotNull Supplier<Iterable<Change>> changesSupplier) {
        if (changesSupplier == null) {
            CommitMessage.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myEditorField.getDocument().putUserData(CHANGES_SUPPLIER_KEY, changesSupplier);
    }

    public void dispose() {
        this.removeAll();
        this.myEditorField.getDocument().putUserData(DATA_KEY, null);
        this.myEditorField.getDocument().putUserData(CHANGES_SUPPLIER_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 10, 11, 12, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ui/CommitMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessageColorScheme";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorField";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateOnInspectionProfileChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSeparatorText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessageEditor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCommitMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setChangesSupplier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 10, 11, 12, 17 -> new IllegalArgumentException(string);
        };
    }

    private static final class RightMarginCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        private RightMarginCustomization(@NotNull Project project) {
            if (project == null) {
                RightMarginCustomization.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void customize(@NotNull EditorEx editor) {
            if (editor == null) {
                RightMarginCustomization.$$$reportNull$$$0(1);
            }
            RightMarginCustomization.customize(this.myProject, editor);
        }

        private static void customize(@NotNull Project project, @NotNull EditorEx editor) {
            if (project == null) {
                RightMarginCustomization.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                RightMarginCustomization.$$$reportNull$$$0(3);
            }
            BodyLimitSettings settings = CommitMessageInspectionProfile.getBodyLimitSettings(project);
            editor.getSettings().setRightMargin(settings.getRightMargin());
            editor.getSettings().setRightMarginShown(settings.isShowRightMargin());
            editor.getSettings().setWrapWhenTypingReachesRightMargin(settings.isWrapOnTyping());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$RightMarginCustomization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InspectionCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        InspectionCustomization(@NotNull Project project) {
            if (project == null) {
                InspectionCustomization.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void customize(@NotNull EditorEx editor) {
            PsiFile file;
            if (editor == null) {
                InspectionCustomization.$$$reportNull$$$0(1);
            }
            if ((file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor.getDocument())) != null) {
                InspectionProfileWrapper.setCustomInspectionProfileWrapperTemporarily((PsiFile)file, profile -> new InspectionProfileWrapper((InspectionProfileImpl)CommitMessageInspectionProfile.getInstance(this.myProject)));
            }
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, (Object)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$InspectionCustomization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class CommitMessageTrafficLightRendererContributor
    implements TrafficLightRendererContributor {
        CommitMessageTrafficLightRendererContributor() {
        }

        @Nullable
        public TrafficLightRenderer createRenderer(@NotNull Editor editor, @Nullable PsiFile psiFile) {
            Project project;
            if (editor == null) {
                CommitMessageTrafficLightRendererContributor.$$$reportNull$$$0(0);
            }
            if ((project = editor.getProject()) == null || !CommitMessage.isCommitMessage(editor.getDocument())) {
                return null;
            }
            return new ConditionalTrafficLightRenderer(project, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ui/CommitMessage$CommitMessageTrafficLightRendererContributor", "createRenderer"));
        }
    }

    private static final class ConditionalTrafficLightRenderer
    extends TrafficLightRenderer {
        ConditionalTrafficLightRenderer(@NotNull Project project, @NotNull Editor editor) {
            if (project == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(1);
            }
            super(project, editor);
        }

        public void refresh(@NotNull EditorMarkupModel editorMarkupModel) {
            if (editorMarkupModel == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(2);
            }
            super.refresh(editorMarkupModel);
            editorMarkupModel.setTrafficLightIconVisible(this.hasHighSeverities(this.getErrorCounts()));
        }

        @NotNull
        public AnalyzerStatus getStatus() {
            AnalyzerStatus analyzerStatus = super.getStatus().withNavigation(false);
            if (analyzerStatus == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(3);
            }
            return analyzerStatus;
        }

        private boolean hasHighSeverities(int @NotNull [] errorCounts) {
            if (errorCounts == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(4);
            }
            HighlightSeverity minSeverity = ((HighlightDisplayLevel)ObjectUtils.notNull((Object)HighlightDisplayLevel.find((String)"TYPO"), (Object)HighlightDisplayLevel.DO_NOT_SHOW)).getSeverity();
            SeverityRegistrar registrar = SeverityRegistrar.getSeverityRegistrar((Project)this.getProject());
            for (int i = 0; i < errorCounts.length; ++i) {
                if (errorCounts[i] <= 0 || registrar.compare(registrar.getSeverityByIndex(i), minSeverity) <= 0) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorMarkupModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ui/CommitMessage$ConditionalTrafficLightRenderer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorCounts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$ConditionalTrafficLightRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "refresh";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "hasHighSeverities";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

