import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import 'react';
import '@grafana/data';
import { stylesFactory, useTheme2, ReactUtils, Tooltip, Icon, Field } from '@grafana/ui';
import { Space } from '../Space.js';

const EditorField = (props) => {
  var _a;
  const { label, optional, tooltip, children, width, ...fieldProps } = props;
  const theme = useTheme2();
  const styles = getStyles(theme, width);
  const childInputId = (fieldProps == null ? undefined : fieldProps.htmlFor) || ((_a = ReactUtils) == null ? undefined : _a.getChildId(children));
  const labelEl = /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs("label", { className: styles.label, htmlFor: childInputId, children: [
      label,
      optional && /* @__PURE__ */ jsx("span", { className: styles.optional, children: " - optional" }),
      tooltip && /* @__PURE__ */ jsx(Tooltip, { placement: "top", content: tooltip, theme: "info", children: /* @__PURE__ */ jsx(Icon, { name: "info-circle", size: "sm", className: styles.icon }) })
    ] }),
    /* @__PURE__ */ jsx(Space, { v: 0.5 })
  ] });
  return /* @__PURE__ */ jsx("div", { className: styles.root, children: /* @__PURE__ */ jsx(Field, { className: styles.field, label: labelEl, ...fieldProps, children }) });
};
const getStyles = stylesFactory((theme, width) => {
  return {
    root: css({
      minWidth: theme.spacing(width != null ? width : 0)
    }),
    label: css({
      fontSize: 12,
      fontWeight: theme.typography.fontWeightMedium
    }),
    optional: css({
      fontStyle: "italic",
      color: theme.colors.text.secondary
    }),
    field: css({
      marginBottom: 0
      // GrafanaUI/Field has a bottom margin which we must remove
    }),
    icon: css({
      color: theme.colors.text.secondary,
      marginLeft: theme.spacing(1),
      ":hover": {
        color: theme.colors.text.primary
      }
    })
  };
});

export { EditorField };
//# sourceMappingURL=EditorField.js.map
