import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import 'react';
import { css, cx } from '@emotion/css';
import { InlineField, Input } from '@grafana/ui';
import { ConfigSection } from '../ConfigSection/ConfigSection.js';
import '@grafana/data';

const ConnectionSettings = ({
  config,
  onChange,
  description,
  urlPlaceholder,
  urlTooltip,
  urlLabel,
  className
}) => {
  const isValidUrl = config.url !== undefined && /^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/.test(config.url);
  const styles = {
    container: css({
      maxWidth: 578
    })
  };
  return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(ConfigSection, { title: "Connection", description, className: cx(styles.container, className), children: /* @__PURE__ */ jsx(
    InlineField,
    {
      htmlFor: "connection-url",
      label: urlLabel || "URL",
      labelWidth: 24,
      tooltip: urlTooltip || /* @__PURE__ */ jsxs(Fragment, { children: [
        "Specify a complete HTTP URL",
        /* @__PURE__ */ jsx("br", {}),
        "(for example https://example.com:8080)"
      ] }),
      grow: true,
      disabled: config.readOnly,
      required: true,
      invalid: !isValidUrl && !config.readOnly,
      error: isValidUrl ? "" : "Please enter a valid URL",
      interactive: true,
      children: /* @__PURE__ */ jsx(
        Input,
        {
          id: "connection-url",
          "aria-label": "Data source connection URL",
          onChange: (event) => onChange({
            ...config,
            url: event.currentTarget.value
          }),
          value: config.url || "",
          placeholder: urlPlaceholder || "URL"
        }
      )
    }
  ) }) });
};

export { ConnectionSettings };
//# sourceMappingURL=ConnectionSettings.js.map
