import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useTheme2, Checkbox, Tooltip, Icon } from '@grafana/ui';

const TLSSettingsSection = ({
  children,
  enabled,
  label,
  tooltipText,
  onToggle,
  readOnly
}) => {
  const { colors, spacing } = useTheme2();
  const styles = {
    container: css({
      marginTop: 3
    }),
    checkboxContainer: css({
      display: "flex",
      alignItems: "center"
    }),
    infoIcon: css({
      marginTop: -2,
      marginLeft: 5,
      color: colors.text.secondary
    }),
    content: css({
      margin: spacing(1, 0, 2, 3)
    })
  };
  return /* @__PURE__ */ jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsxs("div", { className: styles.checkboxContainer, children: [
      /* @__PURE__ */ jsx(Checkbox, { value: enabled, label, onChange: () => onToggle(!enabled), disabled: readOnly }),
      /* @__PURE__ */ jsx(Tooltip, { placement: "top", content: tooltipText, interactive: true, children: /* @__PURE__ */ jsx(Icon, { name: "info-circle", className: styles.infoIcon, size: "sm" }) })
    ] }),
    enabled && children && /* @__PURE__ */ jsx("div", { className: styles.content, children })
  ] });
};

export { TLSSettingsSection };
//# sourceMappingURL=TLSSettingsSection.js.map
