/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.SPARC_ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.SPARC_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class SPARC64_ElfRelocationHandler
extends SPARC_ElfRelocationHandler {
    @Override
    public boolean canRelocate(ElfHeader elf) {
        boolean handleMachine = elf.e_machine() == 43;
        return handleMachine && elf.is64Bit();
    }

    @Override
    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, SPARC_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        long addend = relocation.getAddend();
        long pc = relocationAddress.getOffset();
        int oldIntValue = memory.getInt(relocationAddress);
        long newValue = 0L;
        int mask = 0;
        int byteLength = 8;
        switch (type) {
            case R_SPARC_RELATIVE: {
                newValue = elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                memory.setLong(relocationAddress, newValue);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_SPARC_COPY: {
                int symbolIndex = relocation.getSymbolIndex();
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case R_SPARC_SIZE64: {
                newValue = sym.getSize() + addend;
                memory.setLong(relocationAddress, newValue);
                break;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_SPARC_HI22: {
                newValue = (int)(symbolValue + addend >>> 10);
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldIntValue &= ~mask) | (int)(newValue &= (long)mask));
                byteLength = 4;
                break;
            }
            case R_SPARC_OLO10: {
                newValue = (int)(symbolValue + addend & 0x3FFL) + (int)(relocation.getRelocationInfo() << 32 >> 40);
                mask = 8191;
                memory.setInt(relocationAddress, (oldIntValue &= ~mask) | (int)(newValue &= (long)mask));
                byteLength = 4;
                break;
            }
            case R_SPARC_GLOB_DAT: {
                newValue = symbolValue + addend;
                memory.setLong(relocationAddress, newValue);
                break;
            }
            case R_SPARC_64: {
                newValue = symbolValue + addend;
                memory.setLong(relocationAddress, newValue);
                break;
            }
            case R_SPARC_DISP64: {
                newValue = symbolValue + addend - pc;
                memory.setLong(relocationAddress, newValue);
                break;
            }
            case R_SPARC_UA64: 
            case R_SPARC_REGISTER: {
                newValue = symbolValue + addend;
                memory.setLong(relocationAddress, newValue);
                break;
            }
            case R_SPARC_H34: {
                newValue = (int)(symbolValue + addend >>> 12);
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldIntValue &= ~mask) | (int)(newValue &= (long)mask));
                byteLength = 4;
                break;
            }
            case R_SPARC_JMP_SLOT: {
                int sparc_sethi_g1 = 0x3000000;
                int sparc_sethi_g5 = 0xB000000;
                int sparc_or_g5_immed_g5 = -1978572800;
                int sparc_or_g1_immed_g1 = -2112856064;
                int sparc_sllx_g1_0x20 = -2094501856;
                int sparc_jmpl_g1_g5 = -2118107131;
                int sparc_nop = 0x1000000;
                newValue = symbolValue + addend;
                long hh = newValue >> 42;
                long hl = newValue >> 32 & 0x3FFL;
                long lh = (newValue & 0xFFFFFFFFFFFFFFFFL) >> 10;
                long ll = newValue & 0x3FFL;
                memory.setInt(relocationAddress, (int)(0x3000000L | hh));
                memory.setInt(relocationAddress.add(4L), (int)(0xB000000L | lh));
                memory.setInt(relocationAddress.add(8L), (int)(0xFFFFFFFF82106000L | hl));
                memory.setInt(relocationAddress.add(12L), (int)(0xFFFFFFFF8A116000L | ll));
                memory.setInt(relocationAddress.add(16L), -2094501856);
                memory.setInt(relocationAddress.add(20L), -2118107131);
                memory.setInt(relocationAddress.add(24L), 0x1000000);
                break;
            }
            default: {
                return super.relocate(elfRelocationContext, relocation, type, relocationAddress, sym, symbolAddr, symbolValue, symbolName);
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

