/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.code.DataDBAdapterV0;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class DataDBAdapter {
    static final String DATA_TABLE_NAME = "Data";
    static final Schema DATA_SCHEMA = new Schema(0, "Address", new Field[]{LongField.INSTANCE}, new String[]{"Data Type ID"});
    static final int DATA_TYPE_ID_COL = 0;

    DataDBAdapter() {
    }

    static DataDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new DataDBAdapterV0(dbHandle, addrMap, true);
        }
        try {
            DataDBAdapterV0 adapter = new DataDBAdapterV0(dbHandle, addrMap, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            DataDBAdapter adapter = DataDBAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == OpenMode.UPGRADE) {
                adapter = DataDBAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static DataDBAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws VersionException, IOException {
        return new DataDBAdapterV0(handle, addrMap.getOldAddressMap(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataDBAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, DataDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Data...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            DataDBAdapterV0 tmpAdapter = new DataDBAdapterV0(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.getRecords();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getKey());
                rec.setKey(addrMap.getKey(addr, true));
                ((DataDBAdapter)tmpAdapter).putRecord(rec);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable(DATA_TABLE_NAME);
            DataDBAdapterV0 newAdapter = new DataDBAdapterV0(dbHandle, addrMap, true);
            iter = ((DataDBAdapter)tmpAdapter).getRecords();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = iter.next();
                ((DataDBAdapter)newAdapter).putRecord(rec);
                monitor.setProgress((long)(++count));
            }
            DataDBAdapterV0 dataDBAdapterV0 = newAdapter;
            return dataDBAdapterV0;
        }
    }

    abstract DBRecord getRecordAtOrAfter(Address var1) throws IOException;

    abstract DBRecord getRecordAfter(Address var1) throws IOException;

    abstract DBRecord getRecord(Address var1) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract DBRecord getRecordBefore(Address var1) throws IOException;

    abstract RecordIterator getRecords(Address var1, boolean var2) throws IOException;

    abstract RecordIterator getRecords(Address var1, Address var2, boolean var3) throws IOException;

    abstract void deleteRecord(long var1) throws IOException;

    abstract DBRecord createData(Address var1, long var2) throws IOException;

    abstract int getRecordCount() throws IOException;

    abstract DBRecord getRecordAtOrBefore(Address var1) throws IOException;

    abstract AddressKeyIterator getKeys(Address var1, Address var2, boolean var3) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract boolean deleteRecords(Address var1, Address var2) throws IOException;

    abstract void putRecord(DBRecord var1) throws IOException;

    abstract AddressKeyIterator getKeys(AddressSetView var1, boolean var2) throws IOException;

    abstract RecordIterator getRecords(AddressSetView var1, boolean var2) throws IOException;

    abstract void moveAddressRange(Address var1, Address var2, long var3, TaskMonitor var5) throws CancelledException, IOException;
}

