/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;

public class FixedHandle {
    public AddressSpace space;
    public int size;
    public AddressSpace offset_space;
    public long offset_offset;
    public int offset_size;
    public AddressSpace temp_space;
    public long temp_offset;
    public boolean fixable = true;

    public boolean isInvalid() {
        return this.space == null;
    }

    public void setInvalid() {
        this.space = null;
    }

    public boolean isDynamic() {
        return this.offset_space != null;
    }

    public Varnode getDynamicOffset() {
        if (this.space == null || this.offset_space == null) {
            return null;
        }
        return new Varnode(this.offset_space.getAddress(this.offset_offset), this.offset_size);
    }

    public Varnode getDynamicTemp() {
        if (this.space == null || this.offset_space == null) {
            return null;
        }
        return new Varnode(this.temp_space.getAddress(this.temp_offset), this.size);
    }

    public Varnode getStaticVarnode() {
        if (this.space == null) {
            return null;
        }
        if (this.offset_space != null && this.offset_space.getType() != 0) {
            return null;
        }
        return new Varnode(this.space.getAddress(this.offset_offset), this.size);
    }

    public int hashCode() {
        return (int)(this.offset_offset ^ this.offset_offset >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FixedHandle)) {
            return false;
        }
        FixedHandle other = (FixedHandle)obj;
        return other.space == this.space && other.size == this.size && other.offset_space == this.offset_space && other.offset_offset == this.offset_offset && other.offset_size == this.offset_size && other.temp_space == this.temp_space && other.temp_offset == this.temp_offset;
    }
}

