/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.impl;

import ghidra.feature.vt.api.db.AssociationDatabaseManager;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.impl.MarkupItemStorage;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.address.Address;

public class MarkupItemStorageImpl
implements MarkupItemStorage {
    private final AssociationDatabaseManager associationDBM;
    private final VTAssociation association;
    private final Address sourceAddress;
    private Address destinationAddress;
    private Stringable sourceValue;
    private Stringable destinationValue;
    private String destinationAddressSource;
    private VTMarkupItemStatus status = VTMarkupItemStatus.UNAPPLIED;
    private String statusDescription = null;
    private final VTMarkupType markupType;

    public MarkupItemStorageImpl(VTAssociation association, VTMarkupType markupType, Address sourceAddress) {
        this(association, markupType, sourceAddress, null, null);
    }

    public MarkupItemStorageImpl(VTAssociation association, VTMarkupType markupType, Address sourceAddress, Address destinationAddress, String destinationAddressSource) {
        this.association = association;
        this.markupType = markupType;
        this.associationDBM = ((VTAssociationDB)association).getAssociationDatabaseManager();
        this.sourceAddress = sourceAddress;
        this.destinationAddress = destinationAddress;
        this.destinationAddressSource = destinationAddressSource;
    }

    @Override
    public VTMarkupType getMarkupType() {
        return this.markupType;
    }

    @Override
    public VTAssociation getAssociation() {
        return this.association;
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    @Override
    public Address getDestinationAddress() {
        return this.destinationAddress;
    }

    @Override
    public String getDestinationAddressSource() {
        return this.destinationAddressSource;
    }

    @Override
    public VTMarkupItemStatus getStatus() {
        return this.status;
    }

    @Override
    public String getStatusDescription() {
        return this.statusDescription;
    }

    @Override
    public Stringable getSourceValue() {
        return this.sourceValue;
    }

    @Override
    public Stringable getDestinationValue() {
        return this.destinationValue;
    }

    @Override
    public void setSourceDestinationValues(Stringable sourceValue, Stringable destinationValue) {
        this.sourceValue = sourceValue;
        this.destinationValue = destinationValue;
    }

    @Override
    public MarkupItemStorage setStatus(VTMarkupItemStatus status) {
        this.status = status;
        return this.associationDBM.addMarkupItem(this);
    }

    @Override
    public MarkupItemStorage setApplyFailed(String message) {
        this.status = VTMarkupItemStatus.FAILED_APPLY;
        this.statusDescription = message;
        return this.associationDBM.addMarkupItem(this);
    }

    @Override
    public MarkupItemStorage reset() {
        return this;
    }

    @Override
    public MarkupItemStorage setDestinationAddress(Address destinationAddress, String addressSource) {
        this.destinationAddress = destinationAddress;
        this.destinationAddressSource = addressSource;
        if ("User Defined".equals(addressSource)) {
            return this.associationDBM.addMarkupItem(this);
        }
        return this;
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append('\n').append(this.getClass().getSimpleName()).append('\n');
        buffy.append('\t').append("Source Address          = ").append(this.sourceAddress).append('\n');
        buffy.append('\t').append("Markup Type             = ").append(this.markupType).append('\n');
        buffy.append('\t').append("Status                  = ").append((Object)this.getStatus()).append('\n');
        buffy.append('\t').append("Status Description      = ").append(this.getStatusDescription()).append('\n');
        buffy.append('\t').append("Source Value            = ").append(this.getSourceValue()).append('\n');
        buffy.append('\t').append("Association             = ").append(this.getAssociation()).append('\n');
        return buffy.toString();
    }
}

