/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.quickmethod;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader;
import ghidra.file.formats.android.oat.quickmethod.QuickMethodFrameInfo;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OatQuickMethodHeader_LollipopMR1
extends OatQuickMethodHeader {
    private int mapping_table_offset_;
    private int vmap_table_offset_;
    private int gc_map_offset_;
    private QuickMethodFrameInfo frame_info_;
    private int code_size_;

    OatQuickMethodHeader_LollipopMR1(BinaryReader reader) throws IOException {
        this.mapping_table_offset_ = reader.readNextInt();
        this.vmap_table_offset_ = reader.readNextInt();
        this.gc_map_offset_ = reader.readNextInt();
        this.frame_info_ = new QuickMethodFrameInfo(reader);
        this.code_size_ = reader.readNextInt();
    }

    public int getMappingTableOffset() {
        return this.mapping_table_offset_;
    }

    public int getVmapTableOffset() {
        return this.vmap_table_offset_;
    }

    public int getGcMapOffset() {
        return this.gc_map_offset_;
    }

    public QuickMethodFrameInfo getFrameInfo() {
        return this.frame_info_;
    }

    @Override
    public int getCodeSize() {
        return this.code_size_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(OatQuickMethodHeader_LollipopMR1.class.getSimpleName(), 0);
        structure.add(DWORD, "mapping_table_offset_", null);
        structure.add(DWORD, "vmap_table_offset_", null);
        structure.add(DWORD, "gc_map_offset_", null);
        structure.add(this.frame_info_.toDataType(), "frame_info_", null);
        structure.add(DWORD, "code_size_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

