/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigField;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigMethodRef;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexMemberRefParent;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliTableMemberRef
extends CliAbstractTable {
    public CliTableMemberRef(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliMemberRefRow row = new CliMemberRefRow(CliIndexMemberRefParent.readCodedIndex(reader, stream), this.readStringIndex(reader), this.readBlobIndex(reader));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        for (CliAbstractTableRow row : this.rows) {
            CliMemberRefRow memberRow = (CliMemberRefRow)row;
            Address sigAddr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), memberRow.signatureIndex);
            CliBlob sigBlob = this.metadataStream.getBlobStream().getBlob(memberRow.signatureIndex);
            if (CliSigField.isFieldSig(sigBlob)) {
                CliSigField fieldSig = new CliSigField(sigBlob);
                this.metadataStream.getBlobStream().updateBlob(fieldSig, sigAddr, program);
                continue;
            }
            CliSigMethodRef methodSig = new CliSigMethodRef(sigBlob);
            this.metadataStream.getBlobStream().updateBlob(methodSig, sigAddr, program);
        }
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "MemberRef Row", 0);
        rowDt.add(CliIndexMemberRefParent.toDataType(this.metadataStream), "Class", "index-MemberRefParent coded");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Signature", "index into Blob heap");
        return rowDt;
    }

    public class CliMemberRefRow
    extends CliAbstractTableRow {
        public int classIndex;
        public int nameIndex;
        public int signatureIndex;

        public CliMemberRefRow(int classIndex, int nameIndex, int signatureIndex) {
            this.classIndex = classIndex;
            this.nameIndex = nameIndex;
            this.signatureIndex = signatureIndex;
        }

        @Override
        public String getRepresentation() {
            String classRep;
            try {
                classRep = CliTableMemberRef.this.getRowRepresentationSafe(CliIndexMemberRefParent.getTableName(this.classIndex), CliIndexMemberRefParent.getRowIndex(this.classIndex));
            }
            catch (InvalidInputException e) {
                classRep = Integer.toHexString(this.classIndex);
            }
            String sigRep = Integer.toHexString(this.signatureIndex);
            CliBlob sigBlob = CliTableMemberRef.this.metadataStream.getBlobStream().getBlob(this.signatureIndex);
            try {
                if (CliSigField.isFieldSig(sigBlob)) {
                    CliSigField fieldSig = new CliSigField(sigBlob);
                    sigRep = fieldSig.getRepresentation();
                } else {
                    CliSigMethodRef methodSig = new CliSigMethodRef(sigBlob);
                    sigRep = methodSig.getRepresentation();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return String.format("Class(%s) Member(%s) Signature %s", classRep, CliTableMemberRef.this.metadataStream.getStringsStream().getString(this.nameIndex), sigRep);
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            String classRep;
            try {
                classRep = CliTableMemberRef.this.getRowShortRepSafe(CliIndexMemberRefParent.getTableName(this.classIndex), CliIndexMemberRefParent.getRowIndex(this.classIndex));
            }
            catch (InvalidInputException e) {
                classRep = Integer.toHexString(this.classIndex);
            }
            String sigRep = Integer.toHexString(this.signatureIndex);
            CliBlob sigBlob = stream.getBlobStream().getBlob(this.signatureIndex);
            try {
                if (CliSigField.isFieldSig(sigBlob)) {
                    CliSigField fieldSig = new CliSigField(sigBlob);
                    sigRep = fieldSig.getShortRepresentation(stream);
                } else {
                    CliSigMethodRef methodSig = new CliSigMethodRef(sigBlob);
                    sigRep = methodSig.getRepresentation();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return String.format("%s.%s %s", classRep, stream.getStringsStream().getString(this.nameIndex), sigRep);
        }
    }
}

