/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.util.PseudoInstruction;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InvalidPrototype;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.ProgramContextImpl;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JitPassage
extends PcodeProgram {
    private final List<Instruction> instructions;
    private final AddrCtx entry;
    private final PcodeUseropLibrary<Object> decodeLibrary;
    private final Map<PcodeOp, PBranch> branches;
    private final Map<PcodeOp, AddrCtx> entries;
    private final Register contextreg;
    private final ProgramContextImpl defaultContext;

    public static boolean hasFallthrough(PcodeOp op) {
        if (op instanceof NopPcodeOp) {
            return true;
        }
        return switch (op.getOpcode()) {
            case 4, 6 -> false;
            case 7, 8, 10 -> false;
            case 0 -> false;
            case 5 -> true;
            default -> true;
        };
    }

    protected static RegisterValue getInCtx(InstructionContext insCtx) {
        ProcessorContextView procCtx = insCtx.getProcessorContext();
        Register contextreg = procCtx.getBaseContextRegister();
        if (contextreg == Register.NO_CONTEXT) {
            return null;
        }
        return procCtx.getRegisterValue(contextreg);
    }

    protected static RegisterValue getInCtx(Instruction instruction) {
        return JitPassage.getInCtx(instruction.getInstructionContext());
    }

    public static DecodeErrorInstruction decodeError(Language language, Address address, RegisterValue ctx, String message) {
        try {
            return new DecodeErrorInstruction(language, address, ctx, message);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public JitPassage(SleighLanguage language, AddrCtx entry, List<PcodeOp> code, PcodeUseropLibrary<Object> decodeLibrary, List<Instruction> instructions, Map<PcodeOp, PBranch> branches, Map<PcodeOp, AddrCtx> entries) {
        super(language, code, decodeLibrary.getSymbols(language));
        this.entry = entry;
        this.decodeLibrary = decodeLibrary;
        this.instructions = instructions;
        this.branches = branches;
        this.entries = entries;
        this.contextreg = language.getContextBaseRegister();
        if (this.contextreg != Register.NO_CONTEXT) {
            this.defaultContext = new ProgramContextImpl((Language)language);
            language.applyContextSettings((DefaultProgramContext)this.defaultContext);
        } else {
            this.defaultContext = null;
        }
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public List<PcodeOp> getCode() {
        return super.getCode();
    }

    public AddrCtx getEntry() {
        return this.entry;
    }

    public PcodeUseropLibrary<Object> getDecodeLibrary() {
        return this.decodeLibrary;
    }

    public Map<PcodeOp, PBranch> getBranches() {
        return this.branches;
    }

    @Override
    public String toString() {
        return "<" + this.getClass().getSimpleName() + ":\n  " + this.instructions.stream().map(i -> "(" + String.valueOf(JitPassage.getInCtx(i)) + ") " + i.getAddressString(false, true) + " " + i.toString()).collect(Collectors.joining("\n  ")) + "\n>\n" + this.format(true);
    }

    public AddrCtx getOpEntry(PcodeOp op) {
        return this.entries.get(op);
    }

    public String getErrorMessage(PcodeOp op) {
        Branch branch;
        Branch branch2 = branch = (Branch)this.branches.get(op);
        int n = 0;
        ErrBranch err = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ErrBranch.class}, (Object)branch2, n)) {
            case -1 -> throw new AssertionError((Object)("No branch record for op: " + String.valueOf(op)));
            case 0 -> (ErrBranch)branch2;
            default -> throw new AssertionError((Object)("Wrong branch type " + String.valueOf(branch) + " for op: " + String.valueOf(op)));
        };
        return err.message;
    }

    public static class NopPcodeOp
    extends DecodedPcodeOp {
        public NopPcodeOp(AddrCtx at, int seq) {
            super(at, new SequenceNumber(at.address, seq), 0, new Varnode[0], null);
        }
    }

    public static class DecodeErrorInstruction
    extends PseudoInstruction {
        private final String message;

        public DecodeErrorInstruction(Language language, Address address, RegisterValue ctx, String message) throws AddressOverflowException {
            super(address, (InstructionPrototype)new DecodeErrorPrototype(language), (MemBuffer)new ByteMemBufferImpl(address, new byte[]{0}, language.isBigEndian()), (ProcessorContext)new DecodeErrorProcessorContext(language, ctx));
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        static class DecodeErrorPrototype
        extends InvalidPrototype {
            public DecodeErrorPrototype(Language language) {
                super(language);
            }

            public PcodeOp[] getPcode(InstructionContext context, PcodeOverride override) {
                return new PcodeOp[]{new DecodeErrorPcodeOp(AddrCtx.fromInstructionContext(context))};
            }
        }

        static class DecodeErrorProcessorContext
        implements ProcessorContext {
            private final Language language;
            private final RegisterValue ctx;

            public DecodeErrorProcessorContext(Language language, RegisterValue ctx) {
                this.language = language;
                this.ctx = ctx;
            }

            public Register getBaseContextRegister() {
                return this.language.getContextBaseRegister();
            }

            public List<Register> getRegisters() {
                return this.language.getRegisters();
            }

            public Register getRegister(String name) {
                return this.language.getRegister(name);
            }

            public BigInteger getValue(Register register, boolean signed) {
                if (register == this.language.getContextBaseRegister()) {
                    return signed ? this.ctx.getSignedValue() : this.ctx.getUnsignedValue();
                }
                return null;
            }

            public RegisterValue getRegisterValue(Register register) {
                if (register == this.language.getContextBaseRegister()) {
                    return this.ctx;
                }
                return null;
            }

            public boolean hasValue(Register register) {
                return register == this.language.getContextBaseRegister();
            }

            public void setValue(Register register, BigInteger value) throws ContextChangeException {
            }

            public void setRegisterValue(RegisterValue value) throws ContextChangeException {
            }

            public void clearRegister(Register register) throws ContextChangeException {
            }
        }
    }

    public static final class AddrCtx
    implements Comparable<AddrCtx> {
        public static final AddrCtx NOWHERE = new AddrCtx(null, Address.NO_ADDRESS);
        public final BigInteger biCtx;
        public final RegisterValue rvCtx;
        public final Address address;

        public static AddrCtx fromInstructionContext(InstructionContext insCtx) {
            return new AddrCtx(JitPassage.getInCtx(insCtx), insCtx.getAddress());
        }

        public static AddrCtx fromInstruction(Instruction instruction) {
            return AddrCtx.fromInstructionContext(instruction.getInstructionContext());
        }

        public AddrCtx(RegisterValue ctx, Address address) {
            this.biCtx = ctx == null ? BigInteger.ZERO : ctx.getUnsignedValue();
            this.rvCtx = ctx;
            this.address = Objects.requireNonNull(address);
        }

        public String toString() {
            return "AddrCtx[ctx=%s,addr=%s]".formatted(this.rvCtx, this.address);
        }

        public int hashCode() {
            return Objects.hash(this.biCtx, this.address);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AddrCtx)) {
                return false;
            }
            AddrCtx that = (AddrCtx)obj;
            return this.biCtx.equals(that.biCtx) && this.address.equals((Object)that.address);
        }

        @Override
        public int compareTo(AddrCtx that) {
            int c = this.biCtx.compareTo(that.biCtx);
            if (c != 0) {
                return c;
            }
            c = this.address.compareTo((Object)that.address);
            if (c != 0) {
                return c;
            }
            return 0;
        }
    }

    public static interface Branch {
        public PcodeOp from();

        default public boolean isFall() {
            return false;
        }

        default public String describeTo() {
            return this.toString();
        }
    }

    public record ErrBranch(PcodeOp from, String message) implements SBranch,
    PBranch
    {
    }

    public static class DecodeErrorPcodeOp
    extends DecodedPcodeOp {
        public DecodeErrorPcodeOp(AddrCtx at) {
            super(at, new SequenceNumber(at.address, 0), 0, new Varnode[0], null);
        }
    }

    public static class EntryPcodeOp
    extends PcodeOp {
        public EntryPcodeOp(AddrCtx entry) {
            super(Address.NO_ADDRESS, 0, 4, new Varnode[]{new Varnode(entry.address, 0)});
        }
    }

    public static class ExitPcodeOp
    extends PcodeOp {
        public static ExitPcodeOp exit(AddrCtx at) {
            return new ExitPcodeOp(4, at);
        }

        public static ExitPcodeOp cond(AddrCtx at) {
            return new ExitPcodeOp(5, at);
        }

        private ExitPcodeOp(int opcode, AddrCtx at) {
            super(new SequenceNumber(at.address, 0), opcode, new Varnode[]{new Varnode(at.address, 0)}, null);
        }
    }

    public static class DecodedPcodeOp
    extends PcodeOp {
        private final AddrCtx at;

        DecodedPcodeOp(AddrCtx at, SequenceNumber seqnum, int opcode, Varnode[] inputs, Varnode output) {
            super(seqnum, opcode, inputs, output);
            this.at = at;
        }

        public DecodedPcodeOp(AddrCtx at, PcodeOp original) {
            this(at, original.getSeqnum(), original.getOpcode(), original.getInputs(), original.getOutput());
        }

        public AddrCtx getAt() {
            return this.at;
        }

        public Address getCounter() {
            return this.at.address;
        }

        public RegisterValue getContext() {
            return this.at.rvCtx;
        }

        public boolean isInstructionStart() {
            SequenceNumber seq = this.getSeqnum();
            return seq.getTime() == 0 && seq.getTarget().equals((Object)this.at.address);
        }
    }

    public record RIndBranch(PcodeOp from, RegisterValue flowCtx, Reachability reach) implements IndBranch,
    RBranch
    {
    }

    public record SIndBranch(PcodeOp from, RegisterValue flowCtx) implements IndBranch,
    SBranch
    {
        public RIndBranch withReach(Reachability reach) {
            return new RIndBranch(this.from, this.flowCtx, reach);
        }
    }

    public static interface IndBranch
    extends Branch {
        public RegisterValue flowCtx();
    }

    public record RExtBranch(PcodeOp from, AddrCtx to, Reachability reach) implements ExtBranch,
    RBranch
    {
        public RIntBranch toIntBranch(PcodeOp to) {
            return new RIntBranch(this.from, to, false, this.reach);
        }
    }

    public record SExtBranch(PcodeOp from, AddrCtx to) implements ExtBranch,
    SBranch
    {
        public RExtBranch withReach(Reachability reach) {
            return new RExtBranch(this.from, this.to, reach);
        }
    }

    public static interface ExtBranch
    extends Branch {
        public AddrCtx to();
    }

    public record RIntBranch(PcodeOp from, PcodeOp to, boolean isFall, Reachability reach) implements IntBranch,
    RBranch
    {
    }

    public record SIntBranch(PcodeOp from, PcodeOp to, boolean isFall) implements IntBranch,
    SBranch
    {
        public RIntBranch withReach(Reachability reach) {
            return new RIntBranch(this.from, this.to, this.isFall, reach);
        }
    }

    public static interface IntBranch
    extends Branch {
        public PcodeOp to();
    }

    public static enum Reachability {
        WITHOUT_CTXMOD{

            @Override
            public Reachability combine(Reachability that) {
                Reachability reachability = that;
                int n = 0;
                return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WITHOUT_CTXMOD", "MAYBE_CTXMOD", "WITH_CTXMOD"}, (Reachability)reachability, n)) {
                    default -> throw new MatchException(null, null);
                    case -1 -> this;
                    case 0 -> WITHOUT_CTXMOD;
                    case 1 -> MAYBE_CTXMOD;
                    case 2 -> MAYBE_CTXMOD;
                };
            }

            @Override
            public boolean canReachWithoutCtxMod() {
                return true;
            }
        }
        ,
        MAYBE_CTXMOD{

            @Override
            public Reachability combine(Reachability that) {
                return MAYBE_CTXMOD;
            }

            @Override
            public boolean canReachWithoutCtxMod() {
                return true;
            }
        }
        ,
        WITH_CTXMOD{

            @Override
            public Reachability combine(Reachability that) {
                Reachability reachability = that;
                int n = 0;
                return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WITHOUT_CTXMOD", "MAYBE_CTXMOD", "WITH_CTXMOD"}, (Reachability)reachability, n)) {
                    default -> throw new MatchException(null, null);
                    case -1 -> this;
                    case 0 -> MAYBE_CTXMOD;
                    case 1 -> MAYBE_CTXMOD;
                    case 2 -> WITH_CTXMOD;
                };
            }

            @Override
            public boolean canReachWithoutCtxMod() {
                return false;
            }
        };


        public abstract Reachability combine(Reachability var1);

        public abstract boolean canReachWithoutCtxMod();
    }

    public static interface RBranch
    extends PBranch {
        public Reachability reach();
    }

    public static interface PBranch
    extends Branch {
    }

    public static interface SBranch
    extends Branch {
    }
}

