/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class ThreadPcodeExecutorState<T>
implements PcodeExecutorState<T> {
    protected final PcodeExecutorState<T> sharedState;
    protected final PcodeExecutorState<T> localState;
    protected final PcodeArithmetic<T> arithmetic;

    public ThreadPcodeExecutorState(PcodeExecutorState<T> sharedState, PcodeExecutorState<T> localState) {
        assert (Objects.equals(sharedState.getLanguage(), localState.getLanguage()));
        assert (Objects.equals(sharedState.getArithmetic(), localState.getArithmetic()));
        this.sharedState = sharedState;
        this.localState = localState;
        this.arithmetic = sharedState.getArithmetic();
    }

    @Override
    public Language getLanguage() {
        return this.sharedState.getLanguage();
    }

    @Override
    public PcodeArithmetic<T> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
        return this.localState.streamPieces();
    }

    @Override
    public ThreadPcodeExecutorState<T> fork(PcodeStateCallbacks cb) {
        return new ThreadPcodeExecutorState<T>(this.sharedState.fork(cb), this.localState.fork(cb));
    }

    protected boolean isThreadLocalSpace(AddressSpace space) {
        return space.isRegisterSpace() || space.isUniqueSpace();
    }

    @Override
    public void setVar(AddressSpace space, T offset, int size, boolean quantize, T val) {
        if (this.isThreadLocalSpace(space)) {
            this.localState.setVar(space, offset, size, quantize, val);
            return;
        }
        this.sharedState.setVar(space, offset, size, quantize, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, T offset, int size, T val) {
        if (this.isThreadLocalSpace(space)) {
            this.localState.setVarInternal(space, offset, size, val);
        }
        this.sharedState.setVarInternal(space, offset, size, val);
    }

    @Override
    public void setVar(AddressSpace space, long offset, int size, boolean quantize, T val) {
        if (this.isThreadLocalSpace(space)) {
            this.localState.setVar(space, offset, size, quantize, val);
            return;
        }
        this.sharedState.setVar(space, offset, size, quantize, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, long offset, int size, T val) {
        if (this.isThreadLocalSpace(space)) {
            this.localState.setVarInternal(space, offset, size, val);
        }
        this.sharedState.setVarInternal(space, offset, size, val);
    }

    @Override
    public T getVar(AddressSpace space, T offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        if (this.isThreadLocalSpace(space)) {
            return this.localState.getVar(space, offset, size, quantize, reason);
        }
        return this.sharedState.getVar(space, offset, size, quantize, reason);
    }

    @Override
    public T getVarInternal(AddressSpace space, T offset, int size, PcodeExecutorStatePiece.Reason reason) {
        if (this.isThreadLocalSpace(space)) {
            return this.localState.getVarInternal(space, offset, size, reason);
        }
        return this.sharedState.getVarInternal(space, offset, size, reason);
    }

    @Override
    public T getVar(AddressSpace space, long offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        if (this.isThreadLocalSpace(space)) {
            return this.localState.getVar(space, offset, size, quantize, reason);
        }
        return this.sharedState.getVar(space, offset, size, quantize, reason);
    }

    @Override
    public T getVarInternal(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        if (this.isThreadLocalSpace(space)) {
            return this.localState.getVarInternal(space, offset, size, reason);
        }
        return this.sharedState.getVarInternal(space, offset, size, reason);
    }

    @Override
    public Map<Register, T> getRegisterValues() {
        HashMap result = new HashMap();
        result.putAll(this.localState.getRegisterValues());
        result.putAll(this.sharedState.getRegisterValues());
        return result;
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        assert (!this.isThreadLocalSpace(address.getAddressSpace()));
        return this.sharedState.getConcreteBuffer(address, purpose);
    }

    public PcodeExecutorState<T> getSharedState() {
        return this.sharedState;
    }

    public PcodeExecutorState<T> getLocalState() {
        return this.localState;
    }

    @Override
    public void clear() {
        this.localState.clear();
    }
}

