/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import generic.theme.GColor;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.decompiler.ClangCommentToken;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangOpToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.DecompilerMarginService;
import ghidra.app.decompiler.component.margin.DecompilerMarginProvider;
import ghidra.app.decompiler.component.margin.LineNumberDecompilerMarginProvider;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.breakpoint.BreakpointsDecompilerMarginProvider;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerPlaceBreakpointDialog;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.functiongraph.FunctionGraphMarginService;
import ghidra.app.plugin.core.marker.MarginProviderSupplier;
import ghidra.app.plugin.core.marker.MarkerMarginProvider;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.viewer.listingpanel.MarkerClickedListener;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.debug.api.breakpoint.LogicalBreakpointsChangeListener;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.target.Target;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceVariableSnapProgramView;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

@PluginInfo(shortDescription="Debugger breakpoint marker service plugin", description="Marks logical breakpoints and provides actions in the listings", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerLogicalBreakpointService.class, MarkerService.class})
public class DebuggerBreakpointMarkerPlugin
extends Plugin {
    private static final Color COLOR_BREAKPOINT_ENABLED_MARKER = new GColor("color.debugger.plugin.resources.breakpoint.marker.enabled");
    private static final Color COLOR_BREAKPOINT_DISABLED_MARKER = new GColor("color.debugger.plugin.resources.breakpoint.marker.disabled");
    private static final Color COLOR_BREAKPOINT_INEFF_EN_MARKER = new GColor("color.debugger.plugin.resources.breakpoint.marker.enabled.ineffective");
    private static final Color COLOR_BREAKPOINT_INEFF_DIS_MARKER = new GColor("color.debugger.plugin.resources.breakpoint.marker.disabled.ineffective");
    private MarkerService markerService;
    DebuggerLogicalBreakpointService breakpointService;
    @AutoServiceConsumed
    private DebuggerTargetService targetService;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    private DebuggerControlService controlService;
    DecompilerMarginService decompilerMarginService;
    private FunctionGraphMarginService functionGraphMarginService;
    private final AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Colors.Enabled Breakpoint Markers Have Background"}, description="Whether or not to color background for memory at an enabled breakpoint", help=@HelpInfo(anchor="colors"))
    private boolean breakpointEnabledColoringBackground = true;
    @AutoOptionDefined(name={"Colors.Disabled Breakpoint Markers Have Background"}, description="Whether or not to color background for memory at a disabled breakpoint", help=@HelpInfo(anchor="colors"))
    private boolean breakpointDisabledColoringBackground = false;
    @AutoOptionDefined(name={"Colors.Ineffective Enabled Breakpoint Markers Have Background"}, description="Whether or not to color background for memory at an enabled, but ineffective, breakpoint", help=@HelpInfo(anchor="colors"))
    private boolean breakpointIneffEnColoringBackground = true;
    @AutoOptionDefined(name={"Colors.Ineffective Disabled Breakpoint Markers Have Background"}, description="Whether or not to color background for memory at an disabled, but ineffective, breakpoint", help=@HelpInfo(anchor="colors"))
    private boolean breakpointIneffDisColoringBackground = false;
    private final AutoOptions.Wiring autoOptionsWiring;
    private final Map<Program, BreakpointMarkerSets> markersByProgram = new HashMap<Program, BreakpointMarkerSets>();
    private final LogicalBreakpointsChangeListener updateMarksListener = new UpdateMarksBreakpointRecordChangeListener();
    private final MarkerClickedListener markerClickedListener = new ToggleBreakpointsMarkerClickedListener();
    private final AsyncDebouncer<Void> updateDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 50L);
    SetBreakpointAction actionSetSoftwareBreakpoint;
    SetBreakpointAction actionSetExecuteBreakpoint;
    SetBreakpointAction actionSetReadWriteBreakpoint;
    SetBreakpointAction actionSetReadBreakpoint;
    SetBreakpointAction actionSetWriteBreakpoint;
    ToggleBreakpointAction actionToggleBreakpoint;
    EnableBreakpointAction actionEnableBreakpoint;
    DisableBreakpointAction actionDisableBreakpoint;
    ClearBreakpointAction actionClearBreakpoint;
    DebuggerPlaceBreakpointDialog placeBreakpointDialog = new DebuggerPlaceBreakpointDialog();
    BreakpointsDecompilerMarginProvider decompilerMarginProvider;
    private MarginProviderSupplier functionGraphMarginSupplier = new DefaultMarginProviderSupplier();

    protected static ProgramLocation getSingleLocationFromContext(ActionContext context) {
        ClangToken clangToken;
        DecompilerActionContext ctx;
        if (context == null) {
            return null;
        }
        if (context instanceof DecompilerActionContext && !((ctx = (DecompilerActionContext)context).getSourceComponent() instanceof LineNumberDecompilerMarginProvider) && (clangToken = ctx.getTokenAtCursor()) instanceof ClangVariableToken) {
            Address address;
            ClangVariableToken tok = (ClangVariableToken)clangToken;
            Varnode varnode = tok.getVarnode();
            Address address2 = address = varnode == null ? null : varnode.getAddress();
            if (address != null && address.isMemoryAddress()) {
                return new ProgramLocation(ctx.getProgram(), address);
            }
        }
        if (context instanceof ProgramLocationActionContext) {
            ProgramSelection sel;
            AddressRange range;
            ctx = (ProgramLocationActionContext)context;
            if (ctx.hasSelection() && (range = (sel = ctx.getSelection()).getRangeContaining(ctx.getAddress())) != null) {
                return new ProgramLocation(ctx.getProgram(), range.getMinAddress());
            }
            return ctx.getLocation();
        }
        Object obj = context.getContextObject();
        if (obj instanceof MarkerLocation) {
            MarkerLocation ml = (MarkerLocation)obj;
            return new ProgramLocation(ml.getProgram(), ml.getAddr());
        }
        return null;
    }

    protected static List<Address> getAddressesFromLine(ClangLine line) {
        TreeSet<Address> result = new TreeSet<Address>();
        for (int i = 0; i < line.getNumTokens(); ++i) {
            Address min;
            ClangOpToken opTok;
            ClangVariableToken varTok;
            ClangToken tok = line.getToken(i);
            if (tok instanceof ClangLabelToken || tok instanceof ClangCommentToken || tok instanceof ClangVariableToken && (varTok = (ClangVariableToken)tok).getPcodeOp() != null && varTok.getPcodeOp().getOpcode() == 7 || tok instanceof ClangOpToken && (opTok = (ClangOpToken)tok).getPcodeOp() != null && opTok.getPcodeOp().getOpcode() == 7 || (min = tok.getMinAddress()) == null) continue;
            result.add(min);
        }
        return List.copyOf(result);
    }

    protected static List<ProgramLocation> getLocationsFromLine(Program program, ClangLine line) {
        ArrayList<ProgramLocation> result = new ArrayList<ProgramLocation>();
        for (Address addr : DebuggerBreakpointMarkerPlugin.getAddressesFromLine(line)) {
            result.add(new ProgramLocation(program, addr));
        }
        return result;
    }

    protected static List<ProgramLocation> nearestLocationsToLine(Program program, int index, List<ClangLine> lines) {
        if (index < 0) {
            return null;
        }
        for (int n = index; n < lines.size(); ++n) {
            ClangLine clangLine = lines.get(n);
            List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromLine(program, clangLine);
            if (locs == null || locs.isEmpty()) continue;
            return locs;
        }
        return null;
    }

    protected static List<ProgramLocation> getLocationsFromContext(ActionContext context) {
        if (context == null) {
            return null;
        }
        if (context instanceof DecompilerActionContext) {
            DecompilerActionContext ctx = (DecompilerActionContext)context;
            int lineNumber = ctx.getLineNumber();
            return DebuggerBreakpointMarkerPlugin.nearestLocationsToLine(ctx.getProgram(), lineNumber - 1, ctx.getDecompilerPanel().getLines());
        }
        ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getSingleLocationFromContext(context);
        return loc == null ? null : List.of(loc);
    }

    protected static long computeLengthFromContext(ActionContext context) {
        if (context == null) {
            return 1L;
        }
        if (context instanceof ProgramLocationActionContext) {
            ProgramSelection sel;
            AddressRange range;
            ProgramLocationActionContext ctx = (ProgramLocationActionContext)context;
            if (ctx.hasSelection() && (range = (sel = ctx.getSelection()).getRangeContaining(ctx.getAddress())) != null) {
                return range.getLength();
            }
            CodeUnit cu = ctx.getCodeUnit();
            if (cu instanceof Data) {
                return cu.getLength();
            }
        }
        return 1L;
    }

    protected static boolean contextHasLocation(ActionContext context) {
        List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
        return locs != null && !locs.isEmpty();
    }

    protected static Trace getTraceFromContext(ActionContext context) {
        List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
        if (locs == null || locs.isEmpty()) {
            return null;
        }
        Program progOrView = locs.get(0).getProgram();
        if (progOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)progOrView;
            return view.getTrace();
        }
        return null;
    }

    protected static boolean contextHasTrace(ActionContext context) {
        return DebuggerBreakpointMarkerPlugin.getTraceFromContext(context) != null;
    }

    protected static long computeDefaultLength(ActionContext context, Collection<TraceBreakpointKind> selected) {
        if (selected.isEmpty() || selected.contains(TraceBreakpointKind.HW_EXECUTE) || selected.contains(TraceBreakpointKind.SW_EXECUTE)) {
            return 1L;
        }
        return DebuggerBreakpointMarkerPlugin.computeLengthFromContext(context);
    }

    protected static Set<TraceBreakpointKind> computeDefaultKinds(ActionContext ctx, Collection<TraceBreakpointKind> supported) {
        if (supported.isEmpty()) {
            return Set.of();
        }
        long length = DebuggerBreakpointMarkerPlugin.computeLengthFromContext(ctx);
        if (length == 1L) {
            ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getSingleLocationFromContext(ctx);
            Listing listing = loc.getProgram().getListing();
            CodeUnit cu = listing.getCodeUnitContaining(loc.getAddress());
            if (cu instanceof Instruction) {
                if (supported.contains(TraceBreakpointKind.SW_EXECUTE)) {
                    return Set.of(TraceBreakpointKind.SW_EXECUTE);
                }
                if (supported.contains(TraceBreakpointKind.HW_EXECUTE)) {
                    return Set.of(TraceBreakpointKind.HW_EXECUTE);
                }
                return Set.of();
            }
            Data data = (Data)cu;
            if (!data.isDefined()) {
                if (supported.size() == 1) {
                    return Set.copyOf(supported);
                }
                return Set.of();
            }
        }
        HashSet<TraceBreakpointKind> result = new HashSet<TraceBreakpointKind>(Set.of(TraceBreakpointKind.READ, TraceBreakpointKind.WRITE));
        result.retainAll(supported);
        return result;
    }

    protected Color colorForState(LogicalBreakpoint.State state) {
        return state.isEnabled() ? (state.isEffective() ? COLOR_BREAKPOINT_ENABLED_MARKER : COLOR_BREAKPOINT_INEFF_EN_MARKER) : (state.isEffective() ? COLOR_BREAKPOINT_DISABLED_MARKER : COLOR_BREAKPOINT_INEFF_DIS_MARKER);
    }

    protected boolean stateColorsBackground(LogicalBreakpoint.State state) {
        return state.isEnabled() ? (state.isEffective() ? this.breakpointEnabledColoringBackground : this.breakpointIneffEnColoringBackground) : (state.isEffective() ? this.breakpointDisabledColoringBackground : this.breakpointIneffDisColoringBackground);
    }

    protected static LogicalBreakpoint.State computeState(LogicalBreakpoint breakpoint, Program programOrView) {
        if (programOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)programOrView;
            return breakpoint.computeStateForTrace(view.getTrace());
        }
        return breakpoint.computeState();
    }

    protected Set<LogicalBreakpoint> collectBreakpoints(Collection<ProgramLocation> locs) {
        return locs.stream().flatMap(l -> this.breakpointService.getBreakpointsAt(l).stream()).collect(Collectors.toSet());
    }

    protected LogicalBreakpoint.State computeState(List<ProgramLocation> locs) {
        if (locs.isEmpty()) {
            return LogicalBreakpoint.State.NONE;
        }
        Set<LogicalBreakpoint> col = this.collectBreakpoints(locs);
        return this.breakpointService.computeState(col, locs.get(0));
    }

    public DebuggerBreakpointMarkerPlugin(PluginTool tool) {
        super(tool);
        this.decompilerMarginProvider = new BreakpointsDecompilerMarginProvider(this);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)this);
        this.updateDebouncer.addListener(__ -> SwingUtilities.invokeLater(() -> this.updateAllMarks()));
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    protected void dispose() {
        super.dispose();
        if (this.markerService != null) {
            this.markerService.setMarkerClickedListener(null);
        }
    }

    @AutoOptionConsumed(name={"Colors.Enabled Breakpoint Markers Have Background"})
    private void setEnabledBreakpointMarkerBackground(boolean breakpointColoringBackground) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setEnabledColoringBackground(breakpointColoringBackground);
        }
    }

    @AutoOptionConsumed(name={"Colors.Disabled Breakpoint Markers Have Background"})
    private void setDisabledBreakpointMarkerBackground(boolean breakpointColoringBackground) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setDisabledColoringBackground(breakpointColoringBackground);
        }
    }

    @AutoOptionConsumed(name={"Colors.Ineffective Enabled Breakpoint Markers Have Background"})
    private void setIneffectiveEBreakpointMarkerBackground(boolean breakpointColoringBackground) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setIneffectiveEnabledColoringBackground(breakpointColoringBackground);
        }
    }

    @AutoOptionConsumed(name={"Colors.Ineffective Disabled Breakpoint Markers Have Background"})
    private void setIneffectiveDBreakpointMarkerBackground(boolean breakpointColoringBackground) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setIneffectiveDisabledColoringBackground(breakpointColoringBackground);
        }
    }

    protected Set<Trace> getTracesFromContext(ActionContext context) {
        Trace single = DebuggerBreakpointMarkerPlugin.getTraceFromContext(context);
        if (single != null) {
            return Set.of(single);
        }
        if (this.mappingService == null) {
            return Set.of();
        }
        ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getSingleLocationFromContext(context);
        assert (!(loc.getProgram() instanceof TraceProgramView));
        if (loc == null) {
            return Set.of();
        }
        Set mappedLocs = this.mappingService.getOpenMappedLocations(loc);
        if (mappedLocs == null || mappedLocs.isEmpty()) {
            return Set.of();
        }
        HashSet<Trace> result = new HashSet<Trace>();
        for (TraceLocation tloc : mappedLocs) {
            result.add(tloc.getTrace());
        }
        return result;
    }

    protected boolean contextCanManipulateBreakpoints(ActionContext ctx) {
        return this.breakpointService != null && DebuggerBreakpointMarkerPlugin.contextHasLocation(ctx);
    }

    protected Set<TraceBreakpointKind> getSupportedKindsFromTrace(Trace trace) {
        ControlMode mode;
        ControlMode controlMode = mode = this.controlService == null ? ControlMode.DEFAULT : this.controlService.getCurrentMode(trace);
        if (mode.useEmulatedBreakpoints()) {
            return EnumSet.allOf(TraceBreakpointKind.class);
        }
        if (this.targetService == null) {
            return Set.of();
        }
        Target target = this.targetService.getTarget(trace);
        if (target == null) {
            return Set.of();
        }
        return target.getSupportedBreakpointKinds();
    }

    protected Set<TraceBreakpointKind> getSupportedKindsFromContext(ActionContext context) {
        Set<Trace> traces = this.getTracesFromContext(context);
        if (traces.isEmpty()) {
            return EnumSet.allOf(TraceBreakpointKind.class);
        }
        HashSet<TraceBreakpointKind> result = new HashSet<TraceBreakpointKind>();
        for (Trace t : traces) {
            result.addAll(this.getSupportedKindsFromTrace(t));
            if (result.size() != TraceBreakpointKind.COUNT) continue;
            return result;
        }
        return result;
    }

    protected void doToggleBreakpointsAt(String title, ActionContext context) {
        ProgramLocation loc;
        if (this.breakpointService == null) {
            return;
        }
        List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
        if (locs == null || locs.isEmpty()) {
            return;
        }
        Set<LogicalBreakpoint> col = this.collectBreakpoints(locs);
        String status = this.breakpointService.generateStatusToggleAt(col, loc = locs.get(0));
        if (status != null) {
            this.tool.setStatusInfo(status, true);
        }
        this.breakpointService.toggleBreakpointsAt(col, loc, () -> {
            Set<TraceBreakpointKind> supported = this.getSupportedKindsFromContext(context);
            if (supported.isEmpty()) {
                this.breakpointError(title, "It seems this target does not support breakpoints.");
                return CompletableFuture.completedFuture(Set.of());
            }
            Set<TraceBreakpointKind> kinds = DebuggerBreakpointMarkerPlugin.computeDefaultKinds(context, supported);
            long length = DebuggerBreakpointMarkerPlugin.computeDefaultLength(context, kinds);
            this.placeBreakpointDialog.prompt(this.tool, this.breakpointService, title, loc, length, kinds, "");
            return CompletableFuture.completedFuture(Set.of());
        }).exceptionally(ex -> {
            this.breakpointError(title, "Could not toggle breakpoints", (Throwable)ex);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BreakpointMarkerSets createMarkers(Program program) {
        Map<Program, BreakpointMarkerSets> map = this.markersByProgram;
        synchronized (map) {
            BreakpointMarkerSets newSets = new BreakpointMarkerSets(program);
            BreakpointMarkerSets oldSets = this.markersByProgram.put(program, newSets);
            assert (oldSets == null);
            return newSets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMarkers(Program program) {
        Map<Program, BreakpointMarkerSets> map = this.markersByProgram;
        synchronized (map) {
            BreakpointMarkerSets oldSets = this.markersByProgram.remove(program);
            if (oldSets != null) {
                oldSets.dispose();
            }
        }
    }

    protected void doMarks(BreakpointMarkerSets marks, Map<Address, Set<LogicalBreakpoint>> byAddress, Function<LogicalBreakpoint, LogicalBreakpoint.State> stateFunc) {
        for (Map.Entry<Address, Set<LogicalBreakpoint>> bEnt : byAddress.entrySet()) {
            HashMap<Long, LogicalBreakpoint.State> byLength = new HashMap<Long, LogicalBreakpoint.State>();
            for (LogicalBreakpoint lb : bEnt.getValue()) {
                byLength.compute(lb.getLength(), (l, e) -> (e == null ? LogicalBreakpoint.State.NONE : e).sameAdddress((LogicalBreakpoint.State)stateFunc.apply(lb)));
            }
            Address start = bEnt.getKey();
            for (Map.Entry sEnt : byLength.entrySet()) {
                Address end = start.add((Long)sEnt.getKey() - 1L);
                DualMarkerSet set = marks.getMarkerSet((LogicalBreakpoint.State)sEnt.getValue());
                if (set == null) continue;
                set.add(start, end);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAllMarks() {
        Map<Program, BreakpointMarkerSets> map = this.markersByProgram;
        synchronized (map) {
            for (BreakpointMarkerSets breakpointMarkerSets : this.markersByProgram.values()) {
                breakpointMarkerSets.clear();
            }
            if (this.breakpointService == null) {
                return;
            }
            for (Map.Entry entry : this.markersByProgram.entrySet()) {
                Program program = (Program)entry.getKey();
                BreakpointMarkerSets marks = (BreakpointMarkerSets)entry.getValue();
                if (program instanceof TraceProgramView) {
                    TraceProgramView view = (TraceProgramView)program;
                    Trace trace = view.getTrace();
                    this.doMarks(marks, this.breakpointService.getBreakpoints(trace), lb -> lb.computeStateForTrace(trace));
                    continue;
                }
                this.doMarks(marks, this.breakpointService.getBreakpoints(program), lb -> lb.computeStateForProgram(program));
            }
        }
    }

    @AutoServiceConsumed
    private void setMarkerService(MarkerService markerService) {
        if (this.markerService != null) {
            this.markerService.setMarkerClickedListener(null);
        }
        this.markerService = markerService;
        if (this.markerService != null) {
            this.markerService.setMarkerClickedListener(this.markerClickedListener);
        }
    }

    @AutoServiceConsumed
    private void setLogicalBreakpointService(DebuggerLogicalBreakpointService breakpointService) {
        if (this.breakpointService != null) {
            this.breakpointService.removeChangeListener(this.updateMarksListener);
        }
        this.breakpointService = breakpointService;
        if (this.breakpointService != null) {
            this.breakpointService.addChangeListener(this.updateMarksListener);
            this.updateAllMarks();
        }
    }

    @AutoServiceConsumed
    private void setDecompilerMarginService(DecompilerMarginService decompilerMarginService) {
        if (this.decompilerMarginService != null) {
            this.decompilerMarginService.removeMarginProvider((DecompilerMarginProvider)this.decompilerMarginProvider);
        }
        this.decompilerMarginService = decompilerMarginService;
        if (this.decompilerMarginService != null) {
            this.decompilerMarginService.addMarginProvider((DecompilerMarginProvider)this.decompilerMarginProvider);
        }
    }

    @AutoServiceConsumed
    private void setFunctionGraphMarginService(FunctionGraphMarginService functionGraphMarginService) {
        if (this.functionGraphMarginService != null) {
            this.functionGraphMarginService.removeMarkerProviderSupplier(this.functionGraphMarginSupplier);
        }
        this.functionGraphMarginService = functionGraphMarginService;
        if (this.functionGraphMarginService != null) {
            this.functionGraphMarginService.addMarkerProviderSupplier(this.functionGraphMarginSupplier);
        }
    }

    protected void createActions() {
        this.actionSetSoftwareBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.SW_EXECUTE));
        this.actionSetExecuteBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.HW_EXECUTE));
        this.actionSetReadWriteBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.READ, TraceBreakpointKind.WRITE));
        this.actionSetReadBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.READ));
        this.actionSetWriteBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.WRITE));
        this.actionToggleBreakpoint = new ToggleBreakpointAction();
        this.actionEnableBreakpoint = new EnableBreakpointAction();
        this.actionDisableBreakpoint = new DisableBreakpointAction();
        this.actionClearBreakpoint = new ClearBreakpointAction();
        this.tool.setMenuGroup(new String[]{"Set Breakpoint"}, "Dbg6. Breakpoints");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent evt = (ProgramOpenedPluginEvent)event;
            this.createMarkers(evt.getProgram());
            this.updateAllMarks();
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent evt = (ProgramClosedPluginEvent)event;
            this.removeMarkers(evt.getProgram());
        } else if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent evt = (TraceOpenedPluginEvent)event;
            TraceVariableSnapProgramView view = evt.getTrace().getProgramView();
            this.createMarkers((Program)view);
            this.updateAllMarks();
        } else if (event instanceof TraceClosedPluginEvent) {
            Map<Program, BreakpointMarkerSets> copyOfMarkers;
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            Trace trace = evt.getTrace();
            Map<Program, BreakpointMarkerSets> map = this.markersByProgram;
            synchronized (map) {
                copyOfMarkers = Map.copyOf(this.markersByProgram);
            }
            for (Map.Entry entry : copyOfMarkers.entrySet()) {
                TraceProgramView view;
                Program program = (Program)entry.getKey();
                if (!(program instanceof TraceProgramView) || (view = (TraceProgramView)program).getTrace() != trace) continue;
                this.removeMarkers((Program)view);
            }
        }
    }

    protected void breakpointError(String title, String message) {
        if (this.consoleService == null) {
            Msg.showError((Object)((Object)this), null, (String)title, (Object)message);
            return;
        }
        this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, message);
    }

    protected void breakpointError(String title, String message, Throwable ex) {
        if (this.consoleService == null) {
            Msg.showError((Object)((Object)this), null, (String)title, (Object)message, (Throwable)ex);
            return;
        }
        Msg.error((Object)((Object)this), (Object)message, (Throwable)ex);
        this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, message, ex);
    }

    private class UpdateMarksBreakpointRecordChangeListener
    implements LogicalBreakpointsChangeListener {
        private UpdateMarksBreakpointRecordChangeListener() {
        }

        public void breakpointAdded(LogicalBreakpoint breakpoint) {
            DebuggerBreakpointMarkerPlugin.this.updateDebouncer.contact(null);
        }

        public void breakpointUpdated(LogicalBreakpoint breakpoint) {
            DebuggerBreakpointMarkerPlugin.this.updateDebouncer.contact(null);
        }

        public void breakpointRemoved(LogicalBreakpoint breakpoint) {
            DebuggerBreakpointMarkerPlugin.this.updateDebouncer.contact(null);
        }
    }

    private class ToggleBreakpointsMarkerClickedListener
    implements MarkerClickedListener {
        private ToggleBreakpointsMarkerClickedListener() {
        }

        public void markerDoubleClicked(MarkerLocation location) {
            ProgramLocationActionContext context = new ProgramLocationActionContext(null, location.getProgram(), new ProgramLocation(location.getProgram(), location.getAddr()), null, null);
            if (DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints((ActionContext)context)) {
                DebuggerBreakpointMarkerPlugin.this.doToggleBreakpointsAt("Toggle Breakpoint", (ActionContext)context);
            }
        }
    }

    private class DefaultMarginProviderSupplier
    implements MarginProviderSupplier {
        private DefaultMarginProviderSupplier() {
        }

        public MarkerMarginProvider createMarginProvider() {
            if (DebuggerBreakpointMarkerPlugin.this.markerService != null) {
                return DebuggerBreakpointMarkerPlugin.this.markerService.createMarginProvider();
            }
            return null;
        }
    }

    protected class BreakpointMarkerSets {
        final Program program;
        final Map<LogicalBreakpoint.State, DualMarkerSet> sets = new HashMap<LogicalBreakpoint.State, DualMarkerSet>();

        protected BreakpointMarkerSets(Program program) {
            this.program = program;
            if (!(program instanceof TraceProgramView)) {
                BookmarkManager manager = program.getBookmarkManager();
                manager.defineType("BreakpointEnabled", DebuggerResources.ICON_BLANK, COLOR_BREAKPOINT_ENABLED_MARKER, 49);
                manager.defineType("BreakpointDisabled", DebuggerResources.ICON_BLANK, COLOR_BREAKPOINT_DISABLED_MARKER, 49);
            }
            for (LogicalBreakpoint.State state : LogicalBreakpoint.State.values()) {
                this.getMarkerSet(state);
            }
        }

        DualMarkerSet getMarkerSet(LogicalBreakpoint.State state) {
            return this.sets.computeIfAbsent(state, this::doGetMarkerSet);
        }

        DualMarkerSet doGetMarkerSet(LogicalBreakpoint.State state) {
            if (state.icon == null) {
                return null;
            }
            return new DualMarkerSet(DebuggerBreakpointMarkerPlugin.this.markerService, state.display, state.display, this.program, 50, true, true, DebuggerBreakpointMarkerPlugin.this.stateColorsBackground(state), DebuggerBreakpointMarkerPlugin.this.colorForState(state), state.icon, true);
        }

        public void setEnabledColoringBackground(boolean coloringBackground) {
            for (LogicalBreakpoint.State state : LogicalBreakpoint.State.values()) {
                if (state == LogicalBreakpoint.State.NONE || !state.isEnabled() || !state.isEffective()) continue;
                this.getMarkerSet(state).setColoringBackground(coloringBackground);
            }
        }

        public void setDisabledColoringBackground(boolean coloringBackground) {
            for (LogicalBreakpoint.State state : LogicalBreakpoint.State.values()) {
                if (state == LogicalBreakpoint.State.NONE || state.isEnabled() || !state.isEffective()) continue;
                this.getMarkerSet(state).setColoringBackground(coloringBackground);
            }
        }

        public void setIneffectiveEnabledColoringBackground(boolean coloringBackground) {
            for (LogicalBreakpoint.State state : LogicalBreakpoint.State.values()) {
                if (state == LogicalBreakpoint.State.NONE || !state.isEnabled() || state.isEffective()) continue;
                this.getMarkerSet(state).setColoringBackground(coloringBackground);
            }
        }

        public void setIneffectiveDisabledColoringBackground(boolean coloringBackground) {
            for (LogicalBreakpoint.State state : LogicalBreakpoint.State.values()) {
                if (state == LogicalBreakpoint.State.NONE || state.isEnabled() || state.isEffective()) continue;
                this.getMarkerSet(state).setColoringBackground(coloringBackground);
            }
        }

        public void dispose() {
            for (LogicalBreakpoint.State state : LogicalBreakpoint.State.values()) {
                DualMarkerSet set = this.sets.get(state);
                if (set == null) continue;
                set.remove(DebuggerBreakpointMarkerPlugin.this.markerService, this.program);
            }
        }

        public void clear() {
            for (LogicalBreakpoint.State state : LogicalBreakpoint.State.values()) {
                DualMarkerSet set = this.sets.get(state);
                if (set == null) continue;
                set.clearAll();
            }
        }
    }

    protected static class DualMarkerSet {
        private static final String SUFFIX = " (Point)";
        final MarkerSet area;
        final MarkerSet point;

        public DualMarkerSet(MarkerService service, String name, String description, Program program, int priority, boolean showMarks, boolean showNavigation, boolean colorBackground, Color color, Icon icon, boolean preferred) {
            MarkerSet areaExisting = service.getMarkerSet(name, program);
            this.area = areaExisting != null ? areaExisting : service.createAreaMarker(name, description, program, priority - 1, showMarks, showNavigation, colorBackground, color, preferred);
            MarkerSet pointExisting = service.getMarkerSet(name + SUFFIX, program);
            this.point = pointExisting != null ? pointExisting : service.createPointMarker(name + SUFFIX, description, program, priority, showMarks, showNavigation, false, color, icon, preferred);
        }

        public void add(Address start, Address end) {
            this.area.add(start, end);
            this.point.add(start);
        }

        public void clearAll() {
            this.area.clearAll();
            this.point.clearAll();
        }

        public void setMarkerColor(Color color) {
            this.area.setMarkerColor(color);
            this.point.setMarkerColor(color);
        }

        public void setColoringBackground(boolean coloringBackground) {
            this.area.setColoringBackground(coloringBackground);
        }

        public void remove(MarkerService service, Program program) {
            service.removeMarker(this.area, program);
            service.removeMarker(this.point, program);
        }
    }

    protected class SetBreakpointAction
    extends DebuggerResources.AbstractSetBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";
        private final Set<TraceBreakpointKind> kinds;

        public SetBreakpointAction(Set<TraceBreakpointKind> kinds) {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.kinds = kinds;
            this.setPopupMenuData(new MenuData(new String[]{"Set Breakpoint", TraceBreakpointKind.TraceBreakpointKindSet.encode(kinds)}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return;
            }
            ProgramLocation location = DebuggerBreakpointMarkerPlugin.getSingleLocationFromContext(context);
            long length = DebuggerBreakpointMarkerPlugin.computeDefaultLength(context, this.kinds);
            DebuggerBreakpointMarkerPlugin.this.placeBreakpointDialog.prompt(DebuggerBreakpointMarkerPlugin.this.tool, DebuggerBreakpointMarkerPlugin.this.breakpointService, "Set Breakpoint", location, length, this.kinds, "");
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return false;
            }
            ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getSingleLocationFromContext(context);
            Program program = loc.getProgram();
            if (!(program instanceof TraceProgramView)) {
                return true;
            }
            TraceProgramView view = (TraceProgramView)program;
            Set<TraceBreakpointKind> supported = DebuggerBreakpointMarkerPlugin.this.getSupportedKindsFromTrace(view.getTrace());
            return supported.containsAll(this.kinds);
        }
    }

    protected class ToggleBreakpointAction
    extends AbstractToggleBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public ToggleBreakpointAction() {
            super(DebuggerBreakpointMarkerPlugin.this, DebuggerBreakpointMarkerPlugin.this);
            this.setKeyBindingData(new KeyBindingData(75, 0));
            this.setPopupMenuData(new MenuData(new String[]{"Toggle Breakpoint"}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerBreakpointMarkerPlugin.this.doToggleBreakpointsAt("Toggle Breakpoint", context);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context);
        }
    }

    protected class EnableBreakpointAction
    extends DebuggerResources.AbstractEnableBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public EnableBreakpointAction() {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.setPopupMenuData(new MenuData(new String[]{"Enable Breakpoint"}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            Trace trace;
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return;
            }
            List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
            Set<LogicalBreakpoint> col = DebuggerBreakpointMarkerPlugin.this.collectBreakpoints(locs);
            String status = DebuggerBreakpointMarkerPlugin.this.breakpointService.generateStatusEnable(col, trace = DebuggerBreakpointMarkerPlugin.getTraceFromContext(context));
            if (status != null) {
                DebuggerBreakpointMarkerPlugin.this.tool.setStatusInfo(status, true);
            }
            DebuggerBreakpointMarkerPlugin.this.breakpointService.enableAll(col, trace).exceptionally(ex -> {
                DebuggerBreakpointMarkerPlugin.this.breakpointError("Enable Breakpoint", "Could not enable breakpoint", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return false;
            }
            List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
            LogicalBreakpoint.State state = DebuggerBreakpointMarkerPlugin.this.computeState(locs);
            return state != LogicalBreakpoint.State.ENABLED && state != LogicalBreakpoint.State.NONE;
        }
    }

    protected class DisableBreakpointAction
    extends DebuggerResources.AbstractDisableBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public DisableBreakpointAction() {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.setPopupMenuData(new MenuData(new String[]{"Disable Breakpoint"}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return;
            }
            List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
            Set<LogicalBreakpoint> col = DebuggerBreakpointMarkerPlugin.this.collectBreakpoints(locs);
            DebuggerBreakpointMarkerPlugin.this.breakpointService.disableAll(col, DebuggerBreakpointMarkerPlugin.getTraceFromContext(context)).exceptionally(ex -> {
                DebuggerBreakpointMarkerPlugin.this.breakpointError("Disable Breakpoint", "Could not disable breakpoint", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return false;
            }
            List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
            LogicalBreakpoint.State state = DebuggerBreakpointMarkerPlugin.this.computeState(locs);
            return state != LogicalBreakpoint.State.DISABLED && state != LogicalBreakpoint.State.NONE;
        }
    }

    protected class ClearBreakpointAction
    extends DebuggerResources.AbstractClearBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public ClearBreakpointAction() {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.setPopupMenuData(new MenuData(new String[]{"Clear Breakpoint"}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return;
            }
            List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
            Set<LogicalBreakpoint> col = DebuggerBreakpointMarkerPlugin.this.collectBreakpoints(locs);
            DebuggerBreakpointMarkerPlugin.this.breakpointService.deleteAll(col, DebuggerBreakpointMarkerPlugin.getTraceFromContext(context)).exceptionally(ex -> {
                DebuggerBreakpointMarkerPlugin.this.breakpointError("Clear Breakpoint", "Could not delete breakpoint", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return false;
            }
            List<ProgramLocation> locs = DebuggerBreakpointMarkerPlugin.getLocationsFromContext(context);
            LogicalBreakpoint.State state = DebuggerBreakpointMarkerPlugin.this.computeState(locs);
            return state != LogicalBreakpoint.State.NONE;
        }
    }

    public abstract class AbstractToggleBreakpointAction
    extends DockingAction {
        public static final String NAME = "Toggle Breakpoint";
        public static final Icon ICON = LogicalBreakpoint.ICON_MARKER_MIXED;
        public static final String HELP_ANCHOR = "toggle_breakpoint";

        public AbstractToggleBreakpointAction(DebuggerBreakpointMarkerPlugin this$0, Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Set, enable, or disable a breakpoint");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }
}

