/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph.panel.model.column;

import datagraph.data.graph.panel.model.column.PointerColumnRenderer;
import datagraph.data.graph.panel.model.column.ValueColumnRenderer;
import datagraph.data.graph.panel.model.row.DataRowObject;
import docking.widgets.trable.GTrableCellRenderer;
import docking.widgets.trable.GTrableColumn;
import docking.widgets.trable.GTrableColumnModel;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExpandedDataColumnModel
extends GTrableColumnModel<DataRowObject> {
    protected void populateColumns(List<GTrableColumn<DataRowObject, ?>> columnList) {
        columnList.add(new TypeColumn());
        columnList.add(new NameColumn());
        columnList.add(new ValueColumn());
        columnList.add(new PointerButtonColumn());
    }

    public boolean isPointerButtonColumn(int column) {
        return column == 3;
    }

    private static class TypeColumn
    extends GTrableColumn<DataRowObject, String> {
        private TypeColumn() {
        }

        public String getValue(DataRowObject row) {
            return row.getDataType();
        }

        protected int getPreferredWidth() {
            return 120;
        }
    }

    private static class NameColumn
    extends GTrableColumn<DataRowObject, String> {
        private NameColumn() {
        }

        public String getValue(DataRowObject row) {
            return row.getName();
        }

        protected int getPreferredWidth() {
            return 150;
        }
    }

    private static class ValueColumn
    extends GTrableColumn<DataRowObject, String> {
        private GTrableCellRenderer<String> renderer = new ValueColumnRenderer();

        private ValueColumn() {
        }

        public String getValue(DataRowObject row) {
            Object value = row.getValue();
            if (!StringUtils.isBlank((CharSequence)value)) {
                value = " = " + (String)value;
            }
            return value;
        }

        protected int getPreferredWidth() {
            return 100;
        }

        public GTrableCellRenderer<String> getRenderer() {
            return this.renderer;
        }
    }

    private static class PointerButtonColumn
    extends GTrableColumn<DataRowObject, Boolean> {
        private GTrableCellRenderer<Boolean> renderer = new PointerColumnRenderer();

        private PointerButtonColumn() {
        }

        public Boolean getValue(DataRowObject row) {
            return row.hasOutgoingReferences();
        }

        protected int getPreferredWidth() {
            return 24;
        }

        public boolean isResizable() {
            return false;
        }

        public GTrableCellRenderer<Boolean> getRenderer() {
            return this.renderer;
        }
    }
}

