/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.DebuggerSearchRegionFactory;
import ghidra.app.plugin.core.debug.gui.action.DebuggerReadsMemoryTrait;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.bytesource.SearchRegion;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public class DebuggerByteSource
implements AddressableByteSource {
    private final PluginTool tool;
    private final TraceProgramView view;
    private final Target target;
    private final DebuggerReadsMemoryTrait readsMem;

    public DebuggerByteSource(PluginTool tool, TraceProgramView view, Target target, DebuggerReadsMemoryTrait readsMem) {
        this.tool = tool;
        this.view = view;
        this.target = target;
        this.readsMem = readsMem;
    }

    public int getBytes(Address address, byte[] bytes, int length) {
        AddressSet set = new AddressSet(address, address.add((long)(length - 1)));
        try {
            this.readsMem.getAutoSpec().readMemory(this.tool, DebuggerCoordinates.NOWHERE.view(this.view).target(this.target), (AddressSetView)set).get(10000L, TimeUnit.MILLISECONDS);
            return this.view.getMemory().getBytes(address, bytes, 0, length);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InterruptedException | ExecutionException | TimeoutException e) {
            return 0;
        }
    }

    public List<SearchRegion> getSearchableRegions() {
        AddressFactory factory = this.view.getTrace().getBaseAddressFactory();
        List<AddressSpace> spaces = Stream.of(factory.getPhysicalSpaces()).filter(s -> s.getType() != 7).toList();
        if (spaces.size() == 1) {
            return DebuggerSearchRegionFactory.ALL.stream().map(f -> f.createRegion(null)).toList();
        }
        Stream<AddressSpace> concat = Stream.concat(Stream.of((AddressSpace)null), spaces.stream());
        return concat.flatMap(s -> DebuggerSearchRegionFactory.ALL.stream().map(f -> f.createRegion((AddressSpace)s))).toList();
    }

    public void invalidate() {
        try (Transaction tx = this.view.getTrace().openTransaction("Invalidate memory");){
            TraceMemoryManager mm = this.view.getTrace().getMemoryManager();
            for (AddressSpace space : this.view.getTrace().getBaseAddressFactory().getAddressSpaces()) {
                TraceMemorySpace ms;
                if (!space.isMemorySpace() || (ms = mm.getMemorySpace(space, false)) == null) continue;
                ms.setState(this.view.getSnap(), space.getMinAddress(), space.getMaxAddress(), TraceMemoryState.UNKNOWN);
            }
        }
    }
}

