/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.hfs;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.hfs.HFSPlusFileSystem;
import ghidra.file.formats.ios.hfs.HFSPlusVolumeHeader;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class HFSPlusFileSystemFactory
implements GFileSystemFactoryByteProvider<HFSPlusFileSystem>,
GFileSystemProbeByteProvider {
    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        return HFSPlusVolumeHeader.probe(byteProvider);
    }

    public HFSPlusFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        HFSPlusFileSystem fs = new HFSPlusFileSystem(targetFSRL, fsService);
        try {
            fs.mount(byteProvider, monitor);
            return fs;
        }
        catch (IOException ioe) {
            fs.close();
            throw ioe;
        }
    }
}

