/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.engine.value.ImmutableUnitValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import org.w3c.api.DOMSyntaxException;
import org.w3c.api.DOMTypeException;
import org.w3c.css.om.typed.CSSUnitValue;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class FloatValue
extends NumericValue
implements CSSNumberValue,
CSSUnitValue {
    private static final long serialVersionUID = 1L;
    private float floatValue;
    private short unitType;
    private boolean calculated = false;
    private boolean specified = true;

    public static String getCssText(short unit, float value) {
        if (unit == 255) {
            throw new DOMException(12, "");
        }
        String s = String.valueOf(value);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s + CSSUnit.dimensionUnitString((short)unit);
    }

    public static FloatValue createConstant(short unit, float value) {
        return new ImmutableUnitValue(unit, value);
    }

    public FloatValue(short unitType, float floatValue) {
        this.unitType = unitType;
        this.floatValue = floatValue;
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.NUMERIC;
    }

    @Override
    public short getUnitType() {
        return this.unitType;
    }

    @Override
    public float getFloatValue() {
        return this.floatValue;
    }

    public double getValue() {
        return this.floatValue;
    }

    public void setValue(double value) {
        this.floatValue = (float)value;
        if (this.handler != null) {
            this.handler.valueChanged(this);
        }
    }

    public void setValue(String cssText) throws DOMException {
        this.setCssText(cssText);
    }

    public String getUnit() {
        return CSSUnit.dimensionUnitString((short)this.unitType);
    }

    public String getCssText() {
        return FloatValue.getCssText(this.unitType, this.floatValue);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSParser parser = new CSSParser();
        try {
            LexicalUnit lu = parser.parsePropertyValue((Reader)new StringReader(cssText));
            if (lu.getNextLexicalUnit() != null) {
                throw new DOMSyntaxException("Invalid number " + cssText);
            }
            switch (lu.getLexicalUnitType()) {
                case INTEGER: {
                    this.floatValue = lu.getIntegerValue();
                    this.unitType = 0;
                    break;
                }
                case REAL: {
                    this.floatValue = lu.getFloatValue();
                    this.unitType = 0;
                    break;
                }
                case PERCENTAGE: {
                    this.floatValue = lu.getFloatValue();
                    this.unitType = (short)2;
                    break;
                }
                case DIMENSION: {
                    this.floatValue = lu.getFloatValue();
                    this.unitType = lu.getCssUnit();
                    break;
                }
                default: {
                    throw new DOMTypeException("Invalid unit value: " + cssText);
                }
            }
        }
        catch (IOException lu) {
        }
        catch (CSSParseException e) {
            throw new DOMSyntaxException((Throwable)e);
        }
        if (this.handler != null) {
            this.handler.valueChanged(this);
        }
    }

    @Override
    public boolean isCalculatedNumber() {
        return this.calculated;
    }

    public void setCalculatedNumber(boolean calculated) {
        this.calculated = calculated;
        this.specified = this.specified && !calculated;
    }

    @Override
    public void setExpectInteger() throws DOMException {
        if (this.getUnitType() != 0) {
            super.setExpectInteger();
        } else if (this.calculated) {
            this.floatValue = Math.round(this.floatValue);
        } else if (!this.isInteger()) {
            super.setExpectInteger();
        }
    }

    private boolean isInteger() {
        return Math.rint(this.floatValue) == (double)this.floatValue;
    }

    public void roundToInteger() throws DOMException {
        this.setExpectInteger();
        this.floatValue = Math.round(this.floatValue);
    }

    public boolean isNegativeNumber() {
        return this.floatValue < 0.0f;
    }

    @Override
    public boolean isNumberZero() {
        return this.floatValue == 0.0f;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(Float.valueOf(this.floatValue), this.unitType);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FloatValue)) {
            return false;
        }
        FloatValue other = (FloatValue)obj;
        return other.unitType == this.unitType && Float.floatToIntBits(this.floatValue) == Float.floatToIntBits(other.floatValue);
    }

    public CSSUnitValue to(String unit) {
        short destUnit = UnitStringToId.unitFromString((String)unit);
        float destValue = NumberValue.floatValueConversion((float)this.floatValue, (short)this.unitType, (short)destUnit);
        FloatValue toVal = new FloatValue(destUnit, destValue);
        return toVal;
    }

    @Override
    short getCSSUnit() {
        return this.unitType;
    }

    @Override
    public FloatValue clone() {
        return (FloatValue)super.clone();
    }
}

