/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class NodeNumberingControlGroup
implements ControlGroup {
    static final String NODE_NUMBERING = "nodenumbering";
    private RevertingProperty mSetNodeNumbering;
    private BooleanProperty mNodeNumbering;
    private NodeNumberingChangeListener propertyChangeListener;

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeNumbering = new RevertingProperty();
        this.mNodeNumbering = new BooleanProperty(NODE_NUMBERING);
        this.propertyChangeListener = new NodeNumberingChangeListener(this.mSetNodeNumbering, (IPropertyControl)this.mNodeNumbering);
        this.mSetNodeNumbering.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeNumbering.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeNumbering.appendToForm(formBuilder);
        this.mSetNodeNumbering.appendToForm(formBuilder);
    }

    private class NodeNumberingChangeListener
    extends ControlGroupChangeListener {
        public NodeNumberingChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setNodeNumbering(node, enabled ? Boolean.valueOf(NodeNumberingControlGroup.this.mNodeNumbering.getBooleanValue()) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            Boolean nodeNumbering = NodeStyleModel.getNodeNumbering((NodeModel)node);
            Boolean viewNodeNumbering = styleController.getNodeNumbering(node);
            NodeNumberingControlGroup.this.mSetNodeNumbering.setValue(nodeNumbering != null);
            NodeNumberingControlGroup.this.mNodeNumbering.setValue(viewNodeNumbering.booleanValue());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeNumberingControlGroup.this.mSetNodeNumbering);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeNumberingControlGroup.this.mNodeNumbering);
        }
    }
}

