/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.componentpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import net.infonode.gui.colorprovider.BackgroundColorProvider;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.componentpainter.AbstractComponentPainter;
import net.infonode.util.Direction;

public class SolidColorComponentPainter
extends AbstractComponentPainter {
    private static final long serialVersionUID = 1L;
    public static final SolidColorComponentPainter BACKGROUND_COLOR_PAINTER = new SolidColorComponentPainter(BackgroundColorProvider.INSTANCE);
    private ColorProvider colorProvider;

    public SolidColorComponentPainter(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    @Override
    public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
        g.setColor(this.colorProvider.getColor(component));
        g.fillRect(x, y, width, height);
    }

    @Override
    public boolean isOpaque(Component component) {
        return this.colorProvider.getColor(component).getAlpha() == 255;
    }

    @Override
    public Color getColor(Component component) {
        return this.colorProvider.getColor(component);
    }
}

