/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai;

import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.swing.JTabbedPane;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.SetBooleanPropertyAction;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeIterator;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.freeplane.plugin.ai.chat.AIChatPanel;
import org.freeplane.plugin.ai.edits.AIEdits;
import org.freeplane.plugin.ai.edits.AiEditsPersistenceBuilder;
import org.freeplane.plugin.ai.edits.AiEditsSettings;
import org.freeplane.plugin.ai.edits.AiEditsStateIconProvider;
import org.freeplane.plugin.ai.edits.ClearAiMarkersInMapAction;
import org.freeplane.plugin.ai.edits.ClearAiMarkersInSelectionAction;
import org.freeplane.plugin.ai.mcpserver.ModelContextProtocolServer;
import org.freeplane.plugin.ai.tools.AIToolSetBuilder;
import org.freeplane.plugin.ai.tools.utilities.ToolCaller;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String PREFERENCES_RESOURCE = "preferences.xml";
    private static final String SYSTEM_MESSAGE_PROPERTY = "ai_system_message";
    private static final String OPENROUTER_KEY_PROPERTY = "ai_openrouter_key";
    private static final String GEMINI_KEY_PROPERTY = "ai_gemini_key";
    private static final String OLLAMA_API_KEY_PROPERTY = "ai_ollama_api_key";
    private static final String MCP_TOKEN_PROPERTY = "ai_mcp_token";
    private ModelContextProtocolServer modelContextProtocolServer;
    private AIChatPanel aiChatPanel;

    public void start(BundleContext context) throws Exception {
        this.registerMindMapModeExtension(context);
    }

    private void registerMindMapModeExtension(BundleContext context) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("mode", new String[]{"MindMap"});
        context.registerService(IModeControllerExtensionProvider.class.getName(), (Object)new IModeControllerExtensionProvider(){

            public void installExtension(ModeController modeController, CommandLineOptions options) {
                this.addPluginDefaults();
                this.registerAiEditsFeatures(modeController);
                JTabbedPane tabs = UITools.getFreeplaneTabbedPanel();
                Activator.this.aiChatPanel = new AIChatPanel();
                tabs.addTab("", ResourceController.getResourceController().getIcon("/images/panelTabs/aiTab.svg?useAccentColor=true"), Activator.this.aiChatPanel, TextUtils.getText((String)"ai_panel"));
                this.startModelContextProtocolServer(Activator.this.aiChatPanel, modeController);
                this.addPreferencesToOptionPanel();
            }

            private void addPreferencesToOptionPanel() {
                URL preferences = this.getClass().getResource(Activator.PREFERENCES_RESOURCE);
                if (preferences == null) {
                    throw new RuntimeException("cannot open preferences");
                }
                Controller controller = Controller.getCurrentController();
                MModeController modeController = (MModeController)controller.getModeController();
                modeController.getOptionPanelBuilder().load(preferences);
            }

            private void addPluginDefaults() {
                URL defaults = this.getClass().getResource("defaults.properties");
                Objects.requireNonNull(defaults, "cannot open defaults");
                Properties properties = new Properties();
                ResourceController.loadProperties((Properties)properties, (URL)defaults);
                ResourceController resourceController = ResourceController.getResourceController();
                resourceController.addDefaults((Map)properties);
                properties.keySet().stream().filter(key -> !"ai_edits_state_icon_visible".equals(key)).forEach(key -> resourceController.securePropertyForReadingAndModification((String)key));
                this.markSecretsForSeparatePersistence(resourceController);
                this.setSystemMessageDefault(resourceController);
            }

            private void markSecretsForSeparatePersistence(ResourceController resourceController) {
                resourceController.persistPropertyInSecretsFile(Activator.OPENROUTER_KEY_PROPERTY);
                resourceController.persistPropertyInSecretsFile(Activator.GEMINI_KEY_PROPERTY);
                resourceController.persistPropertyInSecretsFile(Activator.OLLAMA_API_KEY_PROPERTY);
                resourceController.persistPropertyInSecretsFile(Activator.MCP_TOKEN_PROPERTY);
            }

            private void setSystemMessageDefault(ResourceController resourceController) {
                resourceController.securePropertyForReadingAndModification(Activator.SYSTEM_MESSAGE_PROPERTY);
            }

            private void registerAiEditsFeatures(ModeController modeController) {
                MapController mapController;
                AiEditsSettings aiEditsSettings = new AiEditsSettings();
                IconController iconController = (IconController)modeController.getExtension(IconController.class);
                if (iconController != null) {
                    iconController.addStateIconProvider((IStateIconProvider)new AiEditsStateIconProvider(aiEditsSettings));
                }
                if ((mapController = modeController.getMapController()) != null) {
                    AiEditsPersistenceBuilder persistenceBuilder = new AiEditsPersistenceBuilder(aiEditsSettings);
                    persistenceBuilder.registerBy(mapController.getReadManager(), mapController.getWriteManager());
                }
                modeController.addAction((AFreeplaneAction)new ClearAiMarkersInMapAction());
                modeController.addAction((AFreeplaneAction)new ClearAiMarkersInSelectionAction());
                modeController.addAction((AFreeplaneAction)new SetBooleanPropertyAction("ai_edits_state_icon_visible"));
                this.registerAiEditsIconRefreshListener();
            }

            private void registerAiEditsIconRefreshListener() {
                ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

                    public void propertyChanged(String propertyName, String newValue, String oldValue) {
                        if (!"ai_edits_state_icon_visible".equals(propertyName)) {
                            return;
                        }
                        this.refreshAiEditsStateIcons();
                    }
                });
            }

            private void refreshAiEditsStateIcons() {
                Controller controller = Controller.getCurrentController();
                if (controller == null || controller.getModeController() == null) {
                    return;
                }
                if (controller.getMap() == null || controller.getMap().getRootNode() == null) {
                    return;
                }
                IconController iconController = (IconController)controller.getModeController().getExtension(IconController.class);
                if (iconController == null) {
                    return;
                }
                MapController mapController = controller.getModeController().getMapController();
                NodeModel rootNode = controller.getMap().getRootNode();
                NodeIterator iterator = NodeIterator.of((Object)rootNode, NodeModel::getChildren);
                while (iterator.hasNext()) {
                    NodeModel node = (NodeModel)iterator.next();
                    mapController.nodeRefresh(node, AIEdits.class, null, null);
                }
            }

            private void startModelContextProtocolServer(AIChatPanel aiChatPanel, ModeController modeController) {
                if (Activator.this.modelContextProtocolServer == null) {
                    Controller controller = modeController.getController();
                    if (controller == null || controller.getViewController() == null) {
                        LogUtils.severe((String)"Cannot start MCP server: view controller is not available.");
                        return;
                    }
                    Activator.this.modelContextProtocolServer = new ModelContextProtocolServer(new AIToolSetBuilder().toolCallSummaryHandler(aiChatPanel.toolCallSummaryHandler()).toolCaller(ToolCaller.MCP).build(), controller.getViewController());
                    ResourceController resourceController = ResourceController.getResourceController();
                    resourceController.addPropertyChangeListener((IFreeplanePropertyListener)Activator.this.modelContextProtocolServer);
                }
            }
        }, properties);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.aiChatPanel != null) {
            this.aiChatPanel.persistCurrentChatIfNeeded();
        }
        if (this.modelContextProtocolServer != null) {
            this.modelContextProtocolServer.stop();
        }
    }
}

