/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.qm;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.querylog.QueryLogViewer;
import org.jkiss.dbeaver.ui.views.qm.QueryManagerViewFilter;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class QueryManagerView
extends ViewPart {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.queryManager";
    private CustomSashForm sash;
    private QueryLogViewer queryLogViewer;

    public void createPartControl(Composite parent) {
        QueryManagerViewFilter filter = (QueryManagerViewFilter)GeneralUtils.adapt((Object)((Object)this), QueryManagerViewFilter.class);
        if (filter != null) {
            this.sash = new CustomSashForm(parent, 256);
            this.sash.setLayout((Layout)new FillLayout());
            this.sash.setLayoutData((Object)new GridData(1808));
            this.sash.setNoHideLeft(true);
            this.sash.addCustomSashFormListener(new CustomSashForm.ICustomSashFormListener(){
                private boolean wasVisible = false;

                public void dividerMoved(int firstControlWeight, int secondControlWeight) {
                    boolean nowVisible = QueryManagerView.this.isFilterPanelVisible();
                    if (this.wasVisible != nowVisible) {
                        ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.qm.filter"});
                        this.wasVisible = nowVisible;
                    }
                }
            });
            this.createViewer((Composite)this.sash);
            filter.createControl((Composite)this.sash, this.queryLogViewer);
            this.sash.setWeights(new int[]{65, 35});
            this.sash.hideDown();
        } else {
            this.createViewer(parent);
        }
    }

    private void createViewer(@NotNull Composite parent) {
        Composite group = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.queryLogViewer = new QueryLogViewer(group, this.getSite(), null, true, false);
        UIUtils.setHelp((Control)group, (String)"view-query-manager");
    }

    public void setFocus() {
        this.queryLogViewer.getControl().setFocus();
    }

    public boolean isFilterPanelAvailable() {
        return this.sash != null;
    }

    public boolean isFilterPanelVisible() {
        return this.sash != null && !this.sash.isDownHidden();
    }

    public void setFilterPanelVisible(boolean visible) {
        if (this.sash == null) {
            throw new IllegalStateException();
        }
        if (visible) {
            this.sash.showDown();
        } else {
            this.sash.hideDown();
        }
    }

    public void clearLog() {
        this.queryLogViewer.clearLog();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast(new WorkbenchAdapter(this){

                public String getLabel(Object o) {
                    return "Query Manager";
                }
            });
        }
        return (T)super.getAdapter(adapter);
    }
}

