/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.session.PostgreSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.utils.CommonUtils;

public class PostgreSessionManager
implements DBAServerSessionManager<PostgreSession>,
DBAServerSessionManagerSQL {
    public static final String PROP_KILL_QUERY = "killQuery";
    public static final String OPTION_SHOW_IDLE = "showIdle";
    public static final String OPTION_QUERY_CANCEL = "isQueryCancel";
    private final PostgreDataSource dataSource;

    public PostgreSessionManager(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<PostgreSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
            ArrayList<PostgreSession> arrayList;
            block15: {
                JDBCResultSet dbResult = dbStat.executeQuery();
                try {
                    ArrayList<PostgreSession> sessions = new ArrayList<PostgreSession>();
                    while (dbResult.next()) {
                        sessions.add(new PostgreSession((ResultSet)dbResult));
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block15;
                }
                catch (Throwable throwable) {
                    if (dbResult != null) {
                        try {
                            dbResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbResult.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(@NotNull DBCSession session, @NotNull String sessionId, @NotNull Map<String, Object> options) throws DBException {
        try (JDBCStatement dbStat = ((JDBCSession)session).createStatement();){
            if (options != null && CommonUtils.toBoolean((Object)options.get(OPTION_QUERY_CANCEL))) {
                dbStat.execute("SELECT pg_catalog.pg_cancel_backend(" + sessionId + ")");
            } else {
                dbStat.execute("SELECT pg_catalog.pg_terminate_backend(" + sessionId + ")");
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    @NotNull
    public Map<String, Object> getTerminateOptions() {
        return Map.of();
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        StringBuilder sql = new StringBuilder("SELECT sa.* FROM pg_catalog.pg_stat_activity sa");
        if (!CommonUtils.getOption(options, (String)OPTION_SHOW_IDLE)) {
            sql.append(" where sa.state is null or sa.state not like 'idle%'");
        }
        return sql.toString();
    }
}

