/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.dashboard.DBDashboard;
import org.jkiss.dbeaver.model.dashboard.DBDashboardItem;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public class DashboardConfiguration
implements DBDashboard {
    public static final String REF_PREFIX = "ref#";
    private static final Log log = Log.getLog(DashboardConfiguration.class);
    @NotNull
    private final DBPProject project;
    @Nullable
    private IFile dashboardFile;
    private final DBPDataSourceContainer dataSourceContainer;
    private String dashboardId;
    private String dashboardName;
    private final List<DashboardItemViewSettings> items = new ArrayList<DashboardItemViewSettings>();
    private boolean openConnectionOnActivate;
    private boolean useSeparateConnection;
    private boolean initDefaultCharts = true;

    DashboardConfiguration(@NotNull DBPProject project, @Nullable DBPDataSourceContainer dataSourceContainer, @Nullable String dashboardId) {
        this.project = project;
        this.dataSourceContainer = dataSourceContainer;
        this.dashboardId = dashboardId;
    }

    DashboardConfiguration(@NotNull DBPProject project, @NotNull IFile dashboardFile) {
        this.project = project;
        this.dataSourceContainer = null;
        this.dashboardId = dashboardFile.getFullPath().toString();
        this.dashboardFile = dashboardFile;
    }

    @NotNull
    public String getDashboardId() {
        return this.dashboardId;
    }

    @NotNull
    public String getDashboardName() {
        return this.dashboardName;
    }

    @NotNull
    public List<DBDashboardItem> getDashboardItems() {
        return this.items.stream().map(DashboardItemViewSettings::getDashboardItem).collect(Collectors.toList());
    }

    public void setDashboardName(String dashboardName) {
        this.dashboardName = dashboardName;
    }

    public String getTitle() {
        return CommonUtils.isEmpty((String)this.dashboardName) ? this.dashboardId : this.dashboardName;
    }

    @NotNull
    public DBPProject getProject() {
        return this.project;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public List<DashboardItemViewSettings> getDashboardItemConfigs() {
        return new ArrayList<DashboardItemViewSettings>(this.items);
    }

    public boolean isOpenConnectionOnActivate() {
        return this.openConnectionOnActivate;
    }

    public void setOpenConnectionOnActivate(boolean openConnectionOnActivate) {
        this.openConnectionOnActivate = openConnectionOnActivate;
    }

    public boolean isUseSeparateConnection() {
        return this.useSeparateConnection;
    }

    public void setUseSeparateConnection(boolean useSeparateConnection) {
        this.useSeparateConnection = useSeparateConnection;
    }

    public boolean isInitDefaultCharts() {
        return this.initDefaultCharts;
    }

    public void setInitDefaultCharts(boolean initDefaultCharts) {
        this.initDefaultCharts = initDefaultCharts;
    }

    public DashboardItemViewSettings getItemConfig(String itemId) {
        for (DashboardItemViewSettings item : this.items) {
            if (!item.getItemId().equals(itemId)) continue;
            return item;
        }
        return null;
    }

    public DashboardItemViewSettings readDashboardItemConfiguration(DashboardItemConfiguration item) {
        DashboardItemViewSettings itemConfig = this.getItemConfig(item.getId());
        if (itemConfig != null) {
            return itemConfig;
        }
        try {
            DashboardItemViewSettings itemViewConfiguration = new DashboardItemViewSettings(this, item, this.items.size());
            this.items.add(itemViewConfiguration);
            return itemViewConfiguration;
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    public boolean removeItemConfiguration(DashboardItemViewSettings item) {
        return this.items.remove(item);
    }

    public void removeItem(String itemID) {
        int decValue = 0;
        int i = 0;
        while (i < this.items.size()) {
            DashboardItemViewSettings item = this.items.get(i);
            if (item.getItemId().equals(itemID)) {
                this.items.remove(i);
                ++decValue;
                continue;
            }
            item.setIndex(item.getIndex() - decValue);
            ++i;
        }
    }

    public void updateItemConfig(DashboardItemViewSettings config) {
        DashboardItemViewSettings curConfig = this.getItemConfig(config.getItemId());
        if (curConfig == null) {
            this.items.add(config);
        } else {
            curConfig.copyFrom(config);
        }
    }

    public void clearItems() {
        this.items.clear();
    }

    void serializeConfig(XMLBuilder xml) throws IOException {
        try (XMLBuilder.Element ignored = xml.startElement("dashboards");){
            if (!CommonUtils.isEmpty((String)this.dashboardId)) {
                xml.addAttribute("id", this.dashboardId);
            }
            if (!CommonUtils.isEmpty((String)this.dashboardName)) {
                xml.addAttribute("name", this.dashboardName);
            }
            try (XMLBuilder.Element ignored2 = xml.startElement("view");){
                if (this.openConnectionOnActivate) {
                    xml.addAttribute("openConnectionOnActivate", this.openConnectionOnActivate);
                }
                if (this.useSeparateConnection) {
                    xml.addAttribute("useSeparateConnection", this.useSeparateConnection);
                }
                if (!this.initDefaultCharts) {
                    xml.addAttribute("initDefaultCharts", this.initDefaultCharts);
                }
            }
            for (DashboardItemViewSettings itemConfig : this.items) {
                XMLBuilder.Element ignored3 = xml.startElement("dashboard");
                try {
                    itemConfig.serialize(xml);
                }
                finally {
                    if (ignored3 == null) continue;
                    ignored3.close();
                }
            }
        }
    }

    void loadConfiguration(Element rootElement) {
        if (rootElement != null) {
            try {
                if (CommonUtils.isEmpty((String)this.dashboardId)) {
                    this.dashboardId = rootElement.getAttribute("id");
                }
                if (CommonUtils.isEmpty((String)this.dashboardId)) {
                    this.dashboardId = "default";
                }
                this.dashboardName = rootElement.getAttribute("name");
                if (CommonUtils.isEmpty((String)this.dashboardName)) {
                    this.dashboardName = "Default";
                }
                for (Element viewElement : XMLUtils.getChildElementList((Element)rootElement, (String)"view")) {
                    this.openConnectionOnActivate = CommonUtils.getBoolean((String)viewElement.getAttribute("openConnectionOnActivate"), (boolean)this.openConnectionOnActivate);
                    this.useSeparateConnection = CommonUtils.getBoolean((String)viewElement.getAttribute("useSeparateConnection"), (boolean)this.useSeparateConnection);
                    this.initDefaultCharts = CommonUtils.getBoolean((String)viewElement.getAttribute("initDefaultCharts"), (boolean)this.initDefaultCharts);
                }
                for (Element dbElement : XMLUtils.getChildElementList((Element)rootElement, (String)"dashboard")) {
                    String dashboardId = dbElement.getAttribute("id");
                    DashboardItemViewSettings itemConfig = new DashboardItemViewSettings(this, dashboardId, dbElement);
                    this.items.add(itemConfig);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error loading dashboard view configuration", (Throwable)e);
            }
            this.items.sort(Comparator.comparingInt(DashboardItemViewSettings::getIndex));
        }
    }

    public static String getViewId(DBPProject project, DBPDataSourceContainer dataSourceContainer, String id) {
        StringBuilder viewId = new StringBuilder();
        viewId.append(REF_PREFIX).append(Parameter.project.name()).append("=").append(project.getName());
        if (dataSourceContainer != null) {
            viewId.append(",").append(Parameter.datasource.name()).append("=").append(dataSourceContainer.getId());
        }
        if (id != null) {
            viewId.append(",").append(Parameter.id.name()).append("=").append(id);
        }
        return viewId.toString();
    }

    public static enum Parameter {
        project,
        datasource,
        id;

    }
}

