/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.task;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.PrintStreamProgressMonitor;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.sql.task.SQLToolRunListener;
import org.jkiss.dbeaver.model.sql.task.SQLToolRunStatisticsGenerator;
import org.jkiss.dbeaver.model.sql.task.SQLToolStatistics;
import org.jkiss.dbeaver.model.sql.task.SQLToolStatisticsSimple;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class SQLToolExecuteHandler<OBJECT_TYPE extends DBSObject, SETTINGS extends SQLToolExecuteSettings<OBJECT_TYPE>>
implements DBTTaskHandler {
    private final DBCStatistics statistics = new DBCStatistics();

    @NotNull
    public final DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        SETTINGS settings = this.createToolSettings();
        ((SQLToolExecuteSettings)settings).loadConfiguration(runnableContext, task.getProperties(), task.getProject());
        this.executeWithSettings(runnableContext, task, locale, log, logStream, listener, settings);
        return DBTTaskRunStatus.makeStatisticsStatus((DBCStatistics)this.statistics);
    }

    private void executeWithSettings(@NotNull DBRRunnableContext runnableContext, DBTTask task, @NotNull Locale locale, @NotNull Log log, PrintStream logStream, @NotNull DBTTaskExecutionListener listener, SETTINGS settings) throws DBException {
        Throwable error = null;
        try {
            runnableContext.run(true, true, monitor -> {
                try {
                    this.executeTool((DBRProgressMonitor)new PrintStreamProgressMonitor(monitor, logStream), task, settings, log, logStream, listener);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException e) {
            log.debug((Object)"SQL tools canceled");
        }
        if (error != null) {
            log.error((Object)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTool(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, Log log, PrintStream outLog, DBTTaskExecutionListener listener) throws DBException, IOException {
        List objectList = ((SQLToolExecuteSettings)settings).getObjectList();
        Exception lastError = null;
        listener.taskStarted(task);
        try {
            monitor.beginTask("Execute tool '" + task.getType().getName() + "'", objectList.size());
            List<Throwable> warnings = ((SQLToolExecuteSettings)settings).getWarnings();
            if (!warnings.isEmpty()) {
                Throwable throwable = warnings.get(0);
                throw new DBCException("Tool execution error: " + throwable.getMessage(), throwable);
            }
            for (DBSObject object : objectList) {
                monitor.subTask("Process [" + DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI) + "]");
                try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)("Execute " + task.getType().getName()));){
                    ArrayList<DBEPersistAction> queries = new ArrayList<DBEPersistAction>();
                    this.generateObjectQueries(session, settings, queries, object);
                    DBCExecutionContext context = session.getExecutionContext();
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    boolean isAutoCommitModeSwitchedOn = true;
                    try {
                        if (this.isRunInAutoCommit() && txnManager != null && !txnManager.isAutoCommit()) {
                            isAutoCommitModeSwitchedOn = false;
                            txnManager.setAutoCommit(monitor, true);
                        }
                        for (DBEPersistAction action : queries) {
                            if (monitor.isCanceled()) {
                                break;
                            }
                            if (!CommonUtils.isEmpty((String)action.getTitle())) {
                                monitor.subTask(action.getTitle());
                            }
                            try {
                                String script;
                                if (action instanceof SQLDatabasePersistActionComment || CommonUtils.isEmpty((String)(script = action.getScript()))) continue;
                                DBCStatement statement = session.prepareStatement(DBCStatementType.SCRIPT, script, false, false, false);
                                try {
                                    long startTime = System.currentTimeMillis();
                                    statement.executeStatement();
                                    long execTime = System.currentTimeMillis() - startTime;
                                    if (listener instanceof SQLToolRunListener && action.getType() != DBEPersistAction.ActionType.INITIALIZER && action.getType() != DBEPersistAction.ActionType.FINALIZER) {
                                        SQLToolStatisticsSimple statisticsSimple = new SQLToolStatisticsSimple((DBPObject)object, false);
                                        if (this instanceof SQLToolRunStatisticsGenerator) {
                                            List<SQLToolStatistics<DBSObject>> executeStatistics = ((SQLToolRunStatisticsGenerator)((Object)this)).getExecuteStatistics(object, settings, action, session, statement);
                                            monitor.subTask("\tFinished in " + RuntimeUtils.formatExecutionTime((long)execTime));
                                            if (!CommonUtils.isEmpty(executeStatistics)) {
                                                for (SQLToolStatistics<DBSObject> stat : executeStatistics) {
                                                    stat.setExecutionTime(execTime);
                                                }
                                                ((SQLToolRunListener)listener).handleActionStatistics((DBPObject)object, action, session, executeStatistics);
                                            } else {
                                                ((SQLToolRunListener)listener).handleActionStatistics((DBPObject)object, action, session, Collections.singletonList(statisticsSimple));
                                            }
                                        } else {
                                            ((SQLToolRunListener)listener).handleActionStatistics((DBPObject)object, action, session, Collections.singletonList(statisticsSimple));
                                        }
                                    }
                                    this.statistics.addStatementsCount();
                                    this.statistics.addExecuteTime(execTime);
                                    try {
                                        long updateCount = statement.getUpdateRowCount();
                                        if (updateCount < 0L) continue;
                                        this.statistics.addRowsUpdated(updateCount);
                                    }
                                    catch (DBCException e) {
                                        log.warn((Object)"Can't obtain update count", (Throwable)e);
                                    }
                                }
                                finally {
                                    if (statement == null) continue;
                                    statement.close();
                                }
                            }
                            catch (Exception e) {
                                lastError = e;
                                log.debug((Object)"Error executing query", (Throwable)e);
                                outLog.println("Error executing query\n" + e.getMessage());
                                if (!(listener instanceof SQLToolRunListener)) continue;
                                SQLToolStatisticsSimple errorStat = new SQLToolStatisticsSimple((DBPObject)object, true);
                                errorStat.setStatusMessage(e.getMessage());
                                ((SQLToolRunListener)listener).handleActionStatistics((DBPObject)object, action, session, Collections.singletonList(errorStat));
                            }
                            finally {
                                monitor.worked(1);
                            }
                        }
                    }
                    finally {
                        if (!isAutoCommitModeSwitchedOn) {
                            try {
                                txnManager.setAutoCommit(monitor, false);
                            }
                            catch (DBCException e) {
                                log.debug((Object)"Cannot set auto-commit status", (Throwable)e);
                            }
                        }
                    }
                }
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            lastError = e;
            log.debug((Object)e);
            outLog.println("Process error\n" + e.getMessage());
        }
        finally {
            monitor.done();
        }
        listener.taskFinished(task, null, (Throwable)lastError, settings);
        outLog.println("Tool execution finished");
        outLog.flush();
    }

    public String generateScript(DBRProgressMonitor monitor, SETTINGS settings) throws DBException {
        ArrayList<DBEPersistAction> queries = new ArrayList<DBEPersistAction>();
        List objectList = ((SQLToolExecuteSettings)settings).getObjectList();
        for (DBSObject object : objectList) {
            DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)"Generate tool queries");
            try {
                this.generateObjectQueries(session, settings, queries, object);
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
        Object script = queries.stream().map(DBEPersistAction::getScript).collect(Collectors.joining(";\n"));
        if (!((String)(script = ((String)script).trim())).isEmpty()) {
            script = (String)script + ";\n";
        }
        return script;
    }

    @NotNull
    public abstract SETTINGS createToolSettings();

    public abstract void generateObjectQueries(DBCSession var1, SETTINGS var2, List<DBEPersistAction> var3, OBJECT_TYPE var4) throws DBCException;

    public boolean isRunInSeparateTransaction() {
        return false;
    }

    public boolean isRunInAutoCommit() {
        return false;
    }

    public boolean isNeedConfirmation() {
        return false;
    }

    public boolean isOpenTargetObjectsOnFinish() {
        return false;
    }

    public boolean needsRefreshOnFinish() {
        return false;
    }
}

