/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.CommandElement;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class QuickAccessEntry {
    boolean firstInCategory;
    boolean lastInCategory;
    QuickAccessElement element;
    QuickAccessProvider provider;
    int[][] elementMatchRegions;
    int[][] providerMatchRegions;
    private final int matchQuality;
    public static final int MATCH_PERFECT = 0;
    public static final int MATCH_EXCELLENT = 5;
    public static final int MATCH_GOOD = 10;
    public static final int MATCH_PARTIAL = 15;

    public QuickAccessEntry(QuickAccessElement element, QuickAccessProvider provider, int[][] elementMatchRegions, int[][] providerMatchRegions, int matchQuality) {
        this.element = element;
        this.provider = provider;
        this.elementMatchRegions = elementMatchRegions;
        this.providerMatchRegions = providerMatchRegions;
        this.matchQuality = matchQuality;
    }

    Image getImage(QuickAccessElement element, ResourceManager resourceManager) {
        Image image = this.findOrCreateImage(element.getImageDescriptor(), resourceManager);
        if (image == null) {
            image = WorkbenchImages.getImage("IMG_OBJ_ELEMENT");
        }
        return image;
    }

    private Image findOrCreateImage(ImageDescriptor imageDescriptor, ResourceManager resourceManager) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = (Image)resourceManager.find((DeviceResourceDescriptor)imageDescriptor);
        if (image == null) {
            try {
                image = (Image)resourceManager.create((DeviceResourceDescriptor)imageDescriptor);
            }
            catch (DeviceResourceException e) {
                WorkbenchPlugin.log(e);
            }
        }
        return image;
    }

    public void measure(Event event, TextLayout textLayout, ResourceManager resourceManager, TextStyle boldStyle) {
        Table table = ((TableItem)event.item).getParent();
        textLayout.setFont(table.getFont());
        event.width = 0;
        switch (event.index) {
            case 0: {
                if (this.firstInCategory || this.providerMatchRegions.length > 0) {
                    textLayout.setText(this.provider.getName());
                    if (boldStyle == null) break;
                    int[][] nArray = this.providerMatchRegions;
                    int n = this.providerMatchRegions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int[] matchRegion = nArray[n2];
                        textLayout.setStyle(boldStyle, matchRegion[0], matchRegion[1]);
                        ++n2;
                    }
                    break;
                }
                textLayout.setText("");
                break;
            }
            case 1: {
                textLayout.setText(this.element.getLabel());
                Image image = this.getImage(this.element, resourceManager);
                Rectangle imageRect = image.getBounds();
                Rectangle textBounds = textLayout.getBounds();
                int iconSize = imageRect.height;
                if (iconSize > 16 && iconSize >= 2 * textBounds.height) {
                    iconSize = textBounds.height;
                }
                event.height = Math.max(event.height, iconSize + 3);
                event.width += iconSize + 4;
                if (boldStyle == null) break;
                int[][] nArray = this.elementMatchRegions;
                int n = this.elementMatchRegions.length;
                int n3 = 0;
                while (n3 < n) {
                    int[] matchRegion = nArray[n3];
                    textLayout.setStyle(boldStyle, matchRegion[0], matchRegion[1]);
                    ++n3;
                }
                break;
            }
        }
        Rectangle rect = textLayout.getBounds();
        event.width += rect.width + 4;
        event.height = Math.max(event.height, rect.height + 2);
    }

    public void paint(Event event, TextLayout textLayout, ResourceManager resourceManager, TextStyle boldStyle, Color grayColor) {
        Table table = ((TableItem)event.item).getParent();
        textLayout.setFont(table.getFont());
        switch (event.index) {
            case 0: {
                if (!this.firstInCategory && this.providerMatchRegions.length <= 0) break;
                textLayout.setText(this.provider.getName());
                if (boldStyle != null) {
                    int[][] nArray = this.providerMatchRegions;
                    int n = this.providerMatchRegions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int[] matchRegion = nArray[n2];
                        textLayout.setStyle(boldStyle, matchRegion[0], matchRegion[1]);
                        ++n2;
                    }
                }
                if (grayColor != null && this.providerMatchRegions.length > 0 && !this.firstInCategory) {
                    event.gc.setForeground(grayColor);
                }
                Rectangle availableBounds = ((TableItem)event.item).getTextBounds(event.index);
                Rectangle requiredBounds = textLayout.getBounds();
                textLayout.draw(event.gc, availableBounds.x + 1, availableBounds.y + (availableBounds.height - requiredBounds.height) / 2);
                break;
            }
            case 1: {
                CommandElement commandElement;
                String binding;
                String label = this.element.getLabel();
                QuickAccessElement quickAccessElement = this.element;
                if (quickAccessElement instanceof CommandElement && (binding = (commandElement = (CommandElement)quickAccessElement).getBinding()) != null) {
                    StyleRange[] styleRanges;
                    StyledString styledString = StyledCellLabelProvider.styleDecoratedString((String)label, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)new StyledString(commandElement.getCommand()));
                    StyleRange[] styleRangeArray = styleRanges = styledString.getStyleRanges();
                    int n = styleRanges.length;
                    int n3 = 0;
                    while (n3 < n) {
                        StyleRange styleRange = styleRangeArray[n3];
                        textLayout.setStyle((TextStyle)styleRange, styleRange.start, styleRange.start + styleRange.length);
                        ++n3;
                    }
                }
                Image image = this.getImage(this.element, resourceManager);
                Rectangle availableBounds = ((TableItem)event.item).getTextBounds(event.index);
                Rectangle requiredBounds = textLayout.getBounds();
                Rectangle imageBounds = image.getBounds();
                int maxImageSize = availableBounds.height - 3;
                int destHeight = Math.min(imageBounds.height, maxImageSize);
                int destWidth = destHeight * imageBounds.width / imageBounds.height;
                int startX = (maxImageSize - destWidth) / 2;
                int startY = (availableBounds.height - 1 - destHeight) / 2;
                event.gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, availableBounds.x + startX, availableBounds.y + startY, destWidth, destHeight);
                textLayout.setText(label);
                if (boldStyle != null) {
                    int[][] nArray = this.elementMatchRegions;
                    int n = this.elementMatchRegions.length;
                    int n4 = 0;
                    while (n4 < n) {
                        int[] matchRegion = nArray[n4];
                        textLayout.setStyle(boldStyle, matchRegion[0], matchRegion[1]);
                        ++n4;
                    }
                }
                textLayout.draw(event.gc, availableBounds.x + maxImageSize + 4, availableBounds.y + (availableBounds.height - requiredBounds.height) / 2);
            }
        }
        if (this.lastInCategory) {
            if (grayColor != null) {
                event.gc.setForeground(grayColor);
            }
            Rectangle bounds = ((TableItem)event.item).getBounds(event.index);
            event.gc.drawLine(Math.max(0, bounds.x - 1), bounds.y + bounds.height - 1, bounds.x + bounds.width, bounds.y + bounds.height - 1);
        }
    }

    public void erase(Event event) {
        event.detail &= 0xFFFFFFEF;
    }

    public int getMatchQuality() {
        return this.matchQuality;
    }
}

