/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;

public class AllColumns
extends ASTNodeAccessImpl
implements Expression {
    protected ExpressionList<Column> exceptColumns;
    protected List<SelectItem<?>> replaceExpressions;
    private String exceptKeyword;

    public AllColumns(ExpressionList<Column> exceptColumns, List<SelectItem<?>> replaceExpressions) {
        this.exceptColumns = exceptColumns;
        this.replaceExpressions = replaceExpressions;
        this.exceptKeyword = exceptColumns != null ? "Except" : null;
    }

    public AllColumns(ExpressionList<Column> exceptColumns, List<SelectItem<?>> replaceExpressions, String exceptKeyword) {
        this.exceptColumns = exceptColumns;
        this.replaceExpressions = replaceExpressions;
        this.exceptKeyword = exceptKeyword;
    }

    public AllColumns() {
        this(null, null);
    }

    public ExpressionList<Column> getExceptColumns() {
        return this.exceptColumns;
    }

    public AllColumns setExceptColumns(ExpressionList<Column> exceptColumns) {
        this.exceptColumns = exceptColumns;
        return this;
    }

    public ExpressionList<Column> addExceptColumn(Column column) {
        if (this.exceptColumns == null) {
            this.exceptColumns = new ExpressionList((Expression[])new Column[0]);
        }
        this.exceptColumns.add(column);
        return this.exceptColumns;
    }

    public List<SelectItem<?>> getReplaceExpressions() {
        return this.replaceExpressions;
    }

    public AllColumns setReplaceExpressions(List<SelectItem<?>> replaceExpressions) {
        this.replaceExpressions = replaceExpressions;
        return this;
    }

    public List<SelectItem<?>> addReplaceExpression(SelectItem<?> selectItem) {
        if (this.replaceExpressions == null) {
            this.replaceExpressions = new ArrayList();
        }
        this.replaceExpressions.add(selectItem);
        return this.replaceExpressions;
    }

    public String getExceptKeyword() {
        return this.exceptKeyword;
    }

    public AllColumns setExceptKeyword(String exceptKeyword) {
        this.exceptKeyword = exceptKeyword;
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("*");
        if (this.exceptColumns != null && !this.exceptColumns.isEmpty()) {
            builder.append(" ").append(this.exceptKeyword).append("( ");
            this.exceptColumns.appendTo(builder);
            builder.append(" )");
        }
        if (this.replaceExpressions != null && !this.replaceExpressions.isEmpty()) {
            builder.append(" REPLACE( ");
            builder.append(Select.getStringList(this.replaceExpressions));
            builder.append(" )");
        }
        return builder;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }
}

