/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableRemapper;
import proguard.classfile.util.SimplifiedVisitor;

public class VariableEditor
extends SimplifiedVisitor
implements AttributeVisitor {
    private boolean modified;
    private boolean[] deleted = new boolean[64];
    private int[] variableMap = new int[64];
    private final VariableRemapper variableRemapper = new VariableRemapper();

    public void reset(int maxLocals) {
        if (this.deleted.length < maxLocals) {
            this.deleted = new boolean[maxLocals];
        } else {
            Arrays.fill(this.deleted, 0, maxLocals, false);
        }
        this.modified = false;
    }

    public void deleteVariable(int variableIndex) {
        this.deleted[variableIndex] = true;
        this.modified = true;
    }

    public boolean isDeleted(int instructionOffset) {
        return this.deleted[instructionOffset];
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.modified) {
            return;
        }
        int oldMaxLocals = codeAttribute.u2maxLocals;
        if (this.variableMap.length < oldMaxLocals) {
            this.variableMap = new int[oldMaxLocals];
        }
        int newVariableIndex = 0;
        for (int oldVariableIndex = 0; oldVariableIndex < oldMaxLocals; ++oldVariableIndex) {
            this.variableMap[oldVariableIndex] = this.deleted[oldVariableIndex] ? -1 : newVariableIndex++;
        }
        this.variableRemapper.setVariableMap(this.variableMap);
        this.variableRemapper.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.u2maxLocals = newVariableIndex;
    }
}

