/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.OverseerElectionContext;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElector {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String ELECTION_NODE = "/election";
    public static final Pattern LEADER_SEQ = Pattern.compile(".*?/?.*?-n_(\\d+)");
    private static final Pattern SESSION_ID = Pattern.compile(".*?/?(.*?-.*?)-n_\\d+");
    private static final Pattern NODE_NAME = Pattern.compile(".*?/?(.*?-)(.*?)-n_\\d+");
    protected SolrZkClient zkClient;
    private volatile ElectionContext context;
    private ElectionWatcher watcher;
    private Map<ZkController.ContextKey, ElectionContext> electionContexts;
    private ZkController.ContextKey contextKey;

    public LeaderElector(SolrZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public LeaderElector(SolrZkClient zkClient, ZkController.ContextKey key, Map<ZkController.ContextKey, ElectionContext> electionContexts) {
        this.zkClient = zkClient;
        this.electionContexts = electionContexts;
        this.contextKey = key;
    }

    public ElectionContext getContext() {
        return this.context;
    }

    private void checkIfIamLeader(ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        String node;
        Object toDelete2;
        context.checkIfIamLeaderFired();
        String holdElectionPath = context.electionPath + ELECTION_NODE;
        List seqs = this.zkClient.getChildren(holdElectionPath, null, true);
        LeaderElector.sortSeqs(seqs);
        String leaderSeqNodeName = context.leaderSeqPath.substring(context.leaderSeqPath.lastIndexOf(47) + 1);
        if (!seqs.contains(leaderSeqNodeName)) {
            log.warn("Our node is no longer in line to be leader");
            return;
        }
        String prefix = this.zkClient.getZooKeeper().getSessionId() + "-" + context.id + "-";
        Iterator it = seqs.iterator();
        while (it.hasNext()) {
            String elec = (String)it.next();
            if (elec.equals(leaderSeqNodeName) || !elec.startsWith(prefix)) continue;
            try {
                toDelete2 = holdElectionPath + "/" + elec;
                log.warn("Deleting duplicate registration: {}", toDelete2);
                this.zkClient.delete((String)toDelete2, -1, true);
            }
            catch (KeeperException.NoNodeException toDelete2) {
                // empty catch block
            }
            it.remove();
        }
        if (leaderSeqNodeName.equals(seqs.get(0))) {
            try {
                if (this.zkClient.isClosed()) {
                    return;
                }
                this.runIamLeaderProcess(context, replacement);
            }
            catch (KeeperException.NodeExistsException e) {
                log.error("node exists", (Throwable)e);
                this.retryElection(context, false);
                return;
            }
        }
        String toWatch = (String)seqs.get(0);
        toDelete2 = seqs.iterator();
        while (toDelete2.hasNext() && !leaderSeqNodeName.equals(node = (String)toDelete2.next())) {
            toWatch = node;
        }
        try {
            String watchedNode = holdElectionPath + "/" + toWatch;
            this.watcher = new ElectionWatcher(context.leaderSeqPath, watchedNode, LeaderElector.getSeq(context.leaderSeqPath), context);
            this.zkClient.getData(watchedNode, (Watcher)this.watcher, null, true);
            log.debug("Watching path {} to know if I could be the leader", (Object)watchedNode);
        }
        catch (KeeperException.SessionExpiredException e) {
            throw e;
        }
        catch (KeeperException.NoNodeException e) {
            this.checkIfIamLeader(context, true);
        }
        catch (KeeperException e) {
            log.warn("Failed setting watch", (Throwable)e);
            this.checkIfIamLeader(context, true);
        }
    }

    protected void runIamLeaderProcess(ElectionContext context, boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        context.runLeaderProcess(weAreReplacement, 0);
    }

    public static int getSeq(String nStringSequence) {
        int seq = 0;
        Matcher m = LEADER_SEQ.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        seq = Integer.parseInt(m.group(1));
        return seq;
    }

    private String getNodeId(String nStringSequence) {
        Matcher m = SESSION_ID.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String id = m.group(1);
        return id;
    }

    public static String getNodeName(String nStringSequence) {
        Matcher m = NODE_NAME.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String result = m.group(2);
        return result;
    }

    public int joinElection(ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        return this.joinElection(context, replacement, false);
    }

    public int joinElection(ElectionContext context, boolean replacement, boolean joinAtHead) throws KeeperException, InterruptedException, IOException {
        context.joinedElectionFired();
        String shardsElectZkPath = context.electionPath + ELECTION_NODE;
        long sessionId = this.zkClient.getZooKeeper().getSessionId();
        String id = sessionId + "-" + context.id;
        Object leaderSeqPath = null;
        boolean cont = true;
        int tries = 0;
        while (cont) {
            try {
                if (joinAtHead) {
                    log.debug("Node {} trying to join election at the head", (Object)id);
                    List<String> nodes = OverseerTaskProcessor.getSortedElectionNodes(this.zkClient, shardsElectZkPath);
                    if (nodes.size() < 2) {
                        leaderSeqPath = this.zkClient.create(shardsElectZkPath + "/" + id + "-n_", null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
                    } else {
                        String firstInLine = nodes.get(1);
                        log.debug("The current head: {}", (Object)firstInLine);
                        Matcher m = LEADER_SEQ.matcher(firstInLine);
                        if (!m.matches()) {
                            throw new IllegalStateException("Could not find regex match in:" + firstInLine);
                        }
                        leaderSeqPath = shardsElectZkPath + "/" + id + "-n_" + m.group(1);
                        this.zkClient.create((String)leaderSeqPath, null, CreateMode.EPHEMERAL, false);
                    }
                } else {
                    leaderSeqPath = this.zkClient.create(shardsElectZkPath + "/" + id + "-n_", null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
                }
                log.debug("Joined leadership election with path: {}", leaderSeqPath);
                context.leaderSeqPath = leaderSeqPath;
                cont = false;
            }
            catch (KeeperException.ConnectionLossException e) {
                List entries = this.zkClient.getChildren(shardsElectZkPath, null, true);
                boolean foundId = false;
                for (String entry : entries) {
                    String nodeId = this.getNodeId(entry);
                    if (!id.equals(nodeId)) continue;
                    foundId = true;
                    break;
                }
                if (foundId) continue;
                cont = true;
                if (tries++ > 20) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (KeeperException.NoNodeException e) {
                if (tries++ > 20) {
                    context = null;
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                cont = true;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.checkIfIamLeader(context, replacement);
        return LeaderElector.getSeq(context.leaderSeqPath);
    }

    public void setup(ElectionContext context) throws InterruptedException, KeeperException {
        String electZKPath = context.electionPath + ELECTION_NODE;
        if (context instanceof OverseerElectionContext) {
            ZkMaintenanceUtils.ensureExists((String)electZKPath, (SolrZkClient)this.zkClient);
        } else {
            ZkMaintenanceUtils.ensureExists((String)electZKPath, (byte[])null, (CreateMode)CreateMode.PERSISTENT, (SolrZkClient)this.zkClient, (int)2);
        }
        this.context = context;
    }

    public static void sortSeqs(List<String> seqs) {
        seqs.sort(Comparator.comparingInt(LeaderElector::getSeq).thenComparing(Function.identity()));
    }

    void retryElection(ElectionContext context, boolean joinAtHead) throws KeeperException, InterruptedException, IOException {
        ElectionWatcher watcher = this.watcher;
        ElectionContext ctx = context.copy();
        if (this.electionContexts != null) {
            this.electionContexts.put(this.contextKey, ctx);
        }
        if (watcher != null) {
            watcher.cancel();
        }
        this.context.cancelElection();
        this.context.close();
        this.context = ctx;
        this.joinElection(ctx, true, joinAtHead);
    }

    private class ElectionWatcher
    implements Watcher {
        final String myNode;
        final String watchedNode;
        final ElectionContext context;
        private boolean canceled = false;

        private ElectionWatcher(String myNode, String watchedNode, int seq, ElectionContext context) {
            this.myNode = myNode;
            this.watchedNode = watchedNode;
            this.context = context;
        }

        void cancel() {
            this.canceled = true;
        }

        public void process(WatchedEvent event) {
            block8: {
                if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                    return;
                }
                if (this.canceled) {
                    log.debug("This watcher is not active anymore {}", (Object)this.myNode);
                    try {
                        LeaderElector.this.zkClient.delete(this.myNode, -1, true);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                    }
                    catch (Exception e) {
                        log.warn("My watched node still exists and can't remove {}", (Object)this.myNode, (Object)e);
                    }
                    return;
                }
                try {
                    LeaderElector.this.checkIfIamLeader(this.context, true);
                }
                catch (AlreadyClosedException e) {
                }
                catch (Exception e) {
                    if (LeaderElector.this.zkClient.isClosed()) break block8;
                    log.warn("", (Throwable)e);
                }
            }
        }
    }
}

