/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.extractmethod;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodDecorator;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.intentions.PyTypeHintGenerationUtil;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyRefactoringUiService;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.extractmethod.PyExtractMethodSettings;
import com.jetbrains.python.refactoring.extractmethod.PyVariableData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyExtractMethodUtil {
    public static final String NAME = "extract.method.name";
    private static final String ADD_TYPE_ANNOTATIONS_VALUE_KEY = "settings.extract.method.addTypeAnnotations";
    private static final boolean ADD_TYPE_ANNOTATIONS_DEFAULT = true;

    private PyExtractMethodUtil() {
    }

    public static void extractFromStatements(@NotNull Project project, @NotNull Editor editor, @NotNull PyCodeFragment fragment, @NotNull PsiElement statement1, @NotNull PsiElement statement2) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(1);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(2);
        }
        if (statement1 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(3);
        }
        if (statement2 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(4);
        }
        PyExtractMethodUtil.extractFromStatements(project, editor, fragment, statement1, statement2, true);
    }

    public static List<SmartPsiFileRange> extractFromStatements(@NotNull Project project, @NotNull Editor editor, @NotNull PyCodeFragment fragment, @NotNull PsiElement statement1, @NotNull PsiElement statement2, Boolean processDuplicates) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(6);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(7);
        }
        if (statement1 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(8);
        }
        if (statement2 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(9);
        }
        ArrayList<SmartPsiFileRange> pointers = new ArrayList<SmartPsiFileRange>();
        if (!fragment.getOutputVariables().isEmpty() && fragment.isReturnInstructionInside()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyPsiBundle.message("refactoring.extract.method.error.local.variable.modifications.and.returns", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return pointers;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)statement1, PyFunction.class);
        PyUtil.MethodFlags flags = function == null ? null : PyUtil.MethodFlags.of(function);
        boolean isClassMethod = flags != null && flags.isClassMethod();
        boolean isStaticMethod = flags != null && flags.isStaticMethod();
        List elementsRange = PsiTreeUtil.getElementsOfRange((PsiElement)statement1, (PsiElement)statement2);
        if (elementsRange.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyPsiBundle.message("refactoring.extract.method.error.empty.fragment", new Object[0]), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
            return pointers;
        }
        PyExtractMethodSettings methodSettings = PyExtractMethodUtil.getNameAndVariableData(project, fragment, statement1, isClassMethod, isStaticMethod);
        if (methodSettings == null) {
            return pointers;
        }
        PsiFile file = statement1.getContainingFile();
        AbstractVariableData[] variableData = methodSettings.getAbstractVariableData();
        SimpleDuplicatesFinder finder = new SimpleDuplicatesFinder(statement1, statement2, fragment.getOutputVariables(), variableData);
        CommandProcessor.getInstance().executeCommand(project, () -> PyExtractMethodUtil.lambda$extractFromStatements$4(statement1, statement2, project, fragment, elementsRange, methodSettings, flags, isClassMethod, isStaticMethod, (PyVariableData[])variableData, finder, processDuplicates, pointers, file, editor), PyPsiBundle.message("refactoring.extract.method", new Object[0]), null);
        return pointers;
    }

    @NotNull
    private static List<SimpleMatch> collectDuplicates(@NotNull SimpleDuplicatesFinder finder, @NotNull PsiElement originalScopeAnchor, @NotNull PyFunction generatedMethod) {
        if (finder == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(10);
        }
        if (originalScopeAnchor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(11);
        }
        if (generatedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(12);
        }
        List<PsiElement> scopes = PyExtractMethodUtil.collectScopes(originalScopeAnchor, generatedMethod);
        List list = ExtractMethodHelper.collectDuplicates((SimpleDuplicatesFinder)finder, scopes, (PsiElement)generatedMethod);
        if (list == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> collectScopes(@NotNull PsiElement anchor, @NotNull PyFunction generatedMethod) {
        ScopeOwner owner;
        if (anchor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(14);
        }
        if (generatedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(15);
        }
        if ((owner = ScopeUtil.getScopeOwner(anchor)) instanceof PsiFile) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PyExtractMethodUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        ArrayList<PsiElement> scope = new ArrayList<PsiElement>();
        if (owner instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)owner;
            scope.add((PsiElement)pyFunction.getStatementList());
            PyClass containingClass = pyFunction.getContainingClass();
            if (containingClass != null) {
                for (PyFunction function : containingClass.getMethods()) {
                    if (function.equals((Object)owner) || function.equals((Object)generatedMethod)) continue;
                    scope.add((PsiElement)function.getStatementList());
                }
            }
        }
        ArrayList<PsiElement> arrayList = scope;
        if (arrayList == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static void processDuplicates(@NotNull List<SimpleMatch> duplicates, @NotNull PsiElement replacement, @NotNull Editor editor) {
        if (duplicates == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(18);
        }
        if (replacement == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(20);
        }
        ExtractMethodHelper.replaceDuplicates((PsiElement)replacement, (Editor)editor, pair -> PyExtractMethodUtil.replaceElements((SimpleMatch)pair.first, ((PsiElement)pair.second).copy()), duplicates);
    }

    private static void processGlobalWrites(@NotNull PyFunction function, @NotNull PyCodeFragment fragment) {
        if (function == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(21);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(22);
        }
        Set<String> globalWrites = fragment.getGlobalWrites();
        LinkedHashSet<String> newGlobalNames = new LinkedHashSet<String>();
        Scope scope = ControlFlowCache.getScope((ScopeOwner)function);
        for (String name : globalWrites) {
            if (scope.isGlobal(name)) continue;
            newGlobalNames.add(name);
        }
        if (!newGlobalNames.isEmpty()) {
            PyElementGenerator generator = PyElementGenerator.getInstance((Project)function.getProject());
            PyGlobalStatement globalStatement = (PyGlobalStatement)generator.createFromText(LanguageLevel.forElement((PsiElement)function), PyGlobalStatement.class, "global " + StringUtil.join(newGlobalNames, (String)", "));
            PyStatementList statementList = function.getStatementList();
            statementList.addBefore((PsiElement)globalStatement, statementList.getFirstChild());
        }
    }

    private static void processNonlocalWrites(@NotNull PyFunction function, @NotNull PyCodeFragment fragment) {
        if (function == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(23);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(24);
        }
        Set<String> nonlocalWrites = fragment.getNonlocalWrites();
        LinkedHashSet<String> newNonlocalNames = new LinkedHashSet<String>();
        Scope scope = ControlFlowCache.getScope((ScopeOwner)function);
        for (String name : nonlocalWrites) {
            if (scope.isNonlocal(name)) continue;
            newNonlocalNames.add(name);
        }
        if (!newNonlocalNames.isEmpty()) {
            PyElementGenerator generator = PyElementGenerator.getInstance((Project)function.getProject());
            PyNonlocalStatement nonlocalStatement = (PyNonlocalStatement)generator.createFromText(LanguageLevel.forElement((PsiElement)function), PyNonlocalStatement.class, "nonlocal " + StringUtil.join(newNonlocalNames, (String)", "));
            PyStatementList statementList = function.getStatementList();
            statementList.addBefore((PsiElement)nonlocalStatement, statementList.getFirstChild());
        }
    }

    private static void appendSelf(@NotNull PsiElement firstElement, @NotNull StringBuilder builder, boolean staticMethod) {
        if (firstElement == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(25);
        }
        if (builder == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(26);
        }
        if (staticMethod) {
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)firstElement, PyClass.class);
            assert (containingClass != null);
            builder.append(containingClass.getName());
        } else {
            builder.append(PyUtil.getFirstParameterName((PyFunction)PsiTreeUtil.getParentOfType((PsiElement)firstElement, PyFunction.class)));
        }
        builder.append(".");
    }

    public static void extractFromExpression(@NotNull Project project, @NotNull Editor editor, @NotNull PyCodeFragment fragment, @NotNull PsiElement expression) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(27);
        }
        if (editor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(28);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(29);
        }
        if (expression == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(30);
        }
        PyExtractMethodUtil.extractFromExpression(project, editor, fragment, expression, true);
    }

    public static List<SmartPsiFileRange> extractFromExpression(@NotNull Project project, @NotNull Editor editor, @NotNull PyCodeFragment fragment, @NotNull PsiElement expression, Boolean processDuplicates) {
        boolean isStaticMethod;
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(31);
        }
        if (editor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(32);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(33);
        }
        if (expression == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(34);
        }
        ArrayList<SmartPsiFileRange> pointers = new ArrayList<SmartPsiFileRange>();
        if (!fragment.getOutputVariables().isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyPsiBundle.message("refactoring.extract.method.error.local.variable.modifications", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return pointers;
        }
        if (fragment.isReturnInstructionInside()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyPsiBundle.message("refactoring.extract.method.error.returns", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return pointers;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class);
        PyUtil.MethodFlags flags = function == null ? null : PyUtil.MethodFlags.of(function);
        boolean isClassMethod = flags != null && flags.isClassMethod();
        PyExtractMethodSettings methodSettings = PyExtractMethodUtil.getNameAndVariableData(project, fragment, expression, isClassMethod, isStaticMethod = flags != null && flags.isClassMethod());
        if (methodSettings == null) {
            return pointers;
        }
        AbstractVariableData[] variableData = methodSettings.getAbstractVariableData();
        SimpleDuplicatesFinder finder = new SimpleDuplicatesFinder(expression, expression, fragment.getOutputVariables(), variableData);
        if (fragment.getOutputVariables().isEmpty()) {
            CommandProcessor.getInstance().executeCommand(project, () -> PyExtractMethodUtil.lambda$extractFromExpression$11(fragment, methodSettings, expression, flags, project, isClassMethod, isStaticMethod, (PyVariableData[])variableData, finder, processDuplicates, pointers, editor), PyPsiBundle.message("refactoring.extract.method", new Object[0]), null);
        }
        return pointers;
    }

    private static void processDuplicatesAndAddImports(@NotNull Project project, @NotNull Editor editor, @NotNull Boolean processDuplicates, @NotNull List<SmartPsiFileRange> pointers, @NotNull PyExtractMethodSettings methodSettings, @NotNull PyFunction insertedMethod, @NotNull List<SimpleMatch> duplicates, PsiElement insertedCallElement, @NotNull PsiFile file, @NotNull SmartPointerManager pointerManager) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(35);
        }
        if (editor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(36);
        }
        if (processDuplicates == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(37);
        }
        if (pointers == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(38);
        }
        if (methodSettings == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(39);
        }
        if (insertedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(40);
        }
        if (duplicates == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(41);
        }
        if (file == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(42);
        }
        if (pointerManager == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(43);
        }
        if (insertedCallElement == null) {
            return;
        }
        pointers.add(0, pointerManager.createSmartPsiFileRangePointer(file, insertedMethod.getNameIdentifier().getTextRange()));
        pointers.add(pointerManager.createSmartPsiFileRangePointer(file, insertedCallElement.getTextRange()));
        if (processDuplicates.booleanValue()) {
            PyExtractMethodUtil.processDuplicates(duplicates, insertedCallElement, editor);
        }
        if (PyExtractMethodUtil.getAddTypeAnnotations(project)) {
            TypeEvalContext context = TypeEvalContext.userInitiated((Project)project, (PsiFile)file);
            HashSet<String> allTypesAsStrings = new HashSet<String>();
            for (PyType type : methodSettings.getAllTypes()) {
                for (PyType type2 : PyTypeUtil.collectTypeComponentsFromType(type, context)) {
                    String typeFqn;
                    if (type2 != null && type2.getDeclarationElement() != null && !type2.getDeclarationElement().isValid() || !Strings.isNotEmpty((String)(typeFqn = PythonDocumentationProvider.getFullyQualifiedTypeHint(type2, context)))) continue;
                    allTypesAsStrings.add(typeFqn);
                }
            }
            WriteAction.run(() -> PyTypeHintGenerationUtil.addImportsForTypeAnnotations(allTypesAsStrings, (PsiElement)insertedMethod));
        }
    }

    private static void setSelectionAndCaret(@NotNull Editor editor, @Nullable PsiElement callElement) {
        if (editor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(44);
        }
        editor.getSelectionModel().removeSelection();
        if (callElement != null) {
            int offset = callElement.getTextOffset();
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    @NotNull
    private static PsiElement replaceElements(@NotNull List<PsiElement> elementsRange, @NotNull PsiElement callElement) {
        if (elementsRange == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(45);
        }
        if (callElement == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(46);
        }
        callElement = elementsRange.get(0).replace(callElement);
        if (elementsRange.size() > 1) {
            callElement.getParent().deleteChildRange(elementsRange.get(1), elementsRange.get(elementsRange.size() - 1));
        }
        PsiElement psiElement = callElement;
        if (psiElement == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(47);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement replaceElements(@NotNull SimpleMatch match, @NotNull PsiElement element) {
        if (match == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(48);
        }
        if (element == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(49);
        }
        List elementsRange = PsiTreeUtil.getElementsOfRange((PsiElement)match.getStartElement(), (PsiElement)match.getEndElement());
        Map changedParameters = match.getChangedParameters();
        PsiElement callElement = element;
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)callElement.getProject());
        if (element instanceof PyAssignmentStatement) {
            PyExpression[] targets;
            PyExpression value = ((PyAssignmentStatement)element).getAssignedValue();
            if (value != null) {
                callElement = value;
            }
            if ((targets = ((PyAssignmentStatement)element).getTargets()).length == 1) {
                String output = match.getChangedOutput();
                PyExpression text = ((PyAssignmentStatement)generator.createFromText(LanguageLevel.forElement((PsiElement)callElement), PyAssignmentStatement.class, output + " = 1")).getTargets()[0];
                targets[0].replace((PsiElement)text);
            }
        }
        if (element instanceof PyExpressionStatement) {
            callElement = ((PyExpressionStatement)element).getExpression();
        }
        if (callElement instanceof PyCallExpression) {
            Set keys = changedParameters.keySet();
            PyArgumentList argumentList = ((PyCallExpression)callElement).getArgumentList();
            if (argumentList != null) {
                for (PyExpression arg : argumentList.getArguments()) {
                    String argText = arg.getText();
                    if (argText == null || !keys.contains(argText)) continue;
                    arg.replace((PsiElement)generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)callElement), (String)changedParameters.get(argText)));
                }
            }
        }
        return PyExtractMethodUtil.replaceElements(elementsRange, element);
    }

    @NotNull
    private static String createCallArgsString(PyVariableData @NotNull [] variableDatas) {
        if (variableDatas == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(50);
        }
        String string = StringUtil.join((Collection)ContainerUtil.mapNotNull((Object[])variableDatas, data -> data.isPassAsParameter() ? data.getOriginalName() : null), (String)",");
        if (string == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    private static void processParameters(@NotNull Project project, @NotNull PyFunction generatedMethod, @NotNull PyExtractMethodSettings methodSettings, boolean isMethod, boolean isClassMethod, boolean isStaticMethod) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(52);
        }
        if (generatedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(53);
        }
        if (methodSettings == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(54);
        }
        Map<String, String> map = PyExtractMethodUtil.createMap(methodSettings.getAbstractVariableData());
        for (PyParameter parameter : generatedMethod.getParameterList().getParameters()) {
            String name = parameter.getName();
            String newName = map.get(name);
            if (name == null || newName == null || name.equals(newName)) continue;
            HashMap<PyParameter, String> allRenames = new HashMap<PyParameter, String>();
            allRenames.put(parameter, newName);
            UsageInfo[] usages = RenameUtil.findUsages((PsiElement)parameter, (String)newName, (boolean)false, (boolean)false, allRenames);
            try {
                RenameUtil.doRename((PsiElement)parameter, (String)newName, (UsageInfo[])usages, (Project)project, (RefactoringElementListener)new RefactoringElementListenerComposite());
            }
            catch (IncorrectOperationException e) {
                RenameUtil.showErrorMessage((IncorrectOperationException)e, (PsiElement)parameter, (Project)project);
                return;
            }
        }
        PyFunctionBuilder builder = new PyFunctionBuilder("foo", (PsiElement)generatedMethod);
        if (isClassMethod) {
            builder.parameter("cls");
        } else if (isMethod && !isStaticMethod) {
            builder.parameter("self");
        }
        for (PyVariableData data : methodSettings.getAbstractVariableData()) {
            if (!data.isPassAsParameter()) continue;
            String typeName = methodSettings.isUseTypeAnnotations() ? data.getTypeName() : null;
            builder.parameter(data.getName(), typeName);
        }
        PyParameterList pyParameterList = builder.buildFunction().getParameterList();
        generatedMethod.getParameterList().replace((PsiElement)pyParameterList);
    }

    @NotNull
    private static Map<String, String> createMap(PyVariableData @NotNull [] variableData) {
        if (variableData == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(55);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (PyVariableData data : variableData) {
            map.put(data.getOriginalName(), data.getName());
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(56);
        }
        return hashMap;
    }

    @NotNull
    private static PyFunction insertGeneratedMethod(@NotNull PsiElement anchor, @NotNull PyFunction generatedMethod) {
        PsiElement result;
        PsiNamedElement parent;
        Pair data;
        if (anchor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(57);
        }
        if (generatedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(58);
        }
        if ((data = (Pair)anchor.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) != null) {
            anchor = (PsiElement)data.first;
        }
        if ((parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{PyFile.class, PyClass.class, PyFunction.class})) instanceof PyFunction) {
            result = parent.getParent().addAfter((PsiElement)generatedMethod, (PsiElement)parent);
        } else {
            PsiNamedElement target = parent instanceof PyClass ? ((PyClass)parent).getStatementList() : parent;
            PsiElement insertionAnchor = PyPsiUtils.getParentRightBefore((PsiElement)anchor, (PsiElement)target);
            assert (insertionAnchor != null);
            List comments = PyPsiUtils.getPrecedingComments((PsiElement)insertionAnchor);
            result = insertionAnchor.getParent().addBefore((PsiElement)generatedMethod, !comments.isEmpty() ? (PsiElement)comments.get(0) : insertionAnchor);
        }
        result.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                CodeEditUtil.setNodeGenerated((ASTNode)element.getNode(), (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$1", "visitElement"));
            }
        });
        PyFunction pyFunction = (PyFunction)result;
        if (pyFunction == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(59);
        }
        return pyFunction;
    }

    @NotNull
    private static PyFunction generateMethodFromExpression(@NotNull PyExtractMethodSettings methodSettings, @NotNull PsiElement expression, @Nullable PyUtil.MethodFlags flags, boolean isAsync) {
        String expressionText;
        if (methodSettings == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(60);
        }
        if (expression == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(61);
        }
        PyFunctionBuilder builder = new PyFunctionBuilder(methodSettings.getMethodName(), expression);
        PyExtractMethodUtil.addDecorators(builder, flags);
        PyExtractMethodUtil.addParametersAndReturnType(builder, methodSettings);
        if (isAsync) {
            builder.makeAsync();
        }
        String text = PyExtractMethodUtil.needToWrapInParenthesis(expression, expressionText = expression.getText()) ? String.format("(%s)", expressionText) : expressionText;
        builder.statement("return " + text);
        PyFunction pyFunction = builder.buildFunction();
        if (pyFunction == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(62);
        }
        return pyFunction;
    }

    private static boolean needToWrapInParenthesis(@NotNull PsiElement expression, @NotNull String expressionText) {
        if (expression == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(63);
        }
        if (expressionText == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(64);
        }
        if (expression instanceof PyYieldExpression) {
            return true;
        }
        if (expression instanceof PyGeneratorExpression) {
            PsiElement firstChild = expression.getFirstChild();
            return firstChild != null && firstChild.getNode().getElementType() != PyTokenTypes.LPAR;
        }
        return PyExtractMethodUtil.hasLineBreakOutsideBraces(expressionText);
    }

    private static boolean hasLineBreakOutsideBraces(@NotNull String text) {
        IElementType tokenType;
        if (text == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(65);
        }
        int parensCount = 0;
        int bracketsCount = 0;
        int bracesCount = 0;
        PythonLexer lexer = new PythonLexer();
        lexer.start((CharSequence)text);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (PyTokenTypes.BACKSLASH.equals(tokenType)) {
                lexer.advance();
                if (!PyTokenTypes.LINE_BREAK.equals(lexer.getTokenType())) continue;
                lexer.advance();
                continue;
            }
            if (PyTokenTypes.LPAR.equals(tokenType)) {
                ++parensCount;
            } else if (PyTokenTypes.RPAR.equals(tokenType)) {
                --parensCount;
            } else if (PyTokenTypes.LBRACKET.equals(tokenType)) {
                ++bracketsCount;
            } else if (PyTokenTypes.RBRACKET.equals(tokenType)) {
                --bracketsCount;
            } else if (PyTokenTypes.LBRACE.equals(tokenType)) {
                ++bracesCount;
            } else if (PyTokenTypes.RBRACE.equals(tokenType)) {
                --bracesCount;
            } else if (PyTokenTypes.LINE_BREAK.equals(tokenType) && parensCount <= 0 && bracketsCount <= 0 && bracesCount <= 0) {
                return true;
            }
            lexer.advance();
        }
        return false;
    }

    @NotNull
    private static PyFunction generateMethodFromElements(@NotNull PyExtractMethodSettings methodSettings, @NotNull List<PsiElement> elementsRange, @Nullable PyUtil.MethodFlags flags, boolean isAsync) {
        if (methodSettings == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(66);
        }
        if (elementsRange == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(67);
        }
        assert (!elementsRange.isEmpty()) : "Empty statements list was selected!";
        PyFunctionBuilder builder = new PyFunctionBuilder(methodSettings.getMethodName(), elementsRange.get(0));
        if (isAsync) {
            builder.makeAsync();
        }
        PyExtractMethodUtil.addDecorators(builder, flags);
        PyExtractMethodUtil.addParametersAndReturnType(builder, methodSettings);
        PyFunction method = builder.buildFunction();
        PyStatementList statementList = method.getStatementList();
        for (PsiElement element : elementsRange) {
            statementList.add(element);
        }
        PsiElement child = statementList.getFirstChild();
        if (child != null) {
            child.delete();
        }
        PyStatementList last = statementList;
        while (last != null) {
            if (!((last = last.getLastChild()) instanceof PsiWhiteSpace)) continue;
            last.delete();
        }
        PyFunction pyFunction = method;
        if (pyFunction == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(68);
        }
        return pyFunction;
    }

    private static void addDecorators(@NotNull PyFunctionBuilder builder, @Nullable PyUtil.MethodFlags flags) {
        if (builder == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(69);
        }
        if (flags != null) {
            if (flags.isClassMethod()) {
                builder.decorate("classmethod");
            } else if (flags.isStaticMethod()) {
                builder.decorate("staticmethod");
            }
        }
    }

    private static void addParametersAndReturnType(@NotNull PyFunctionBuilder builder, PyExtractMethodSettings methodSettings) {
        if (builder == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(70);
        }
        for (PyVariableData data : methodSettings.getAbstractVariableData()) {
            String typeName = methodSettings.isUseTypeAnnotations() ? data.getTypeName() : null;
            builder.parameter(data.getOriginalName(), typeName);
        }
        if (methodSettings.isUseTypeAnnotations()) {
            builder.returnType(methodSettings.getReturnTypeName());
        }
    }

    @Nullable
    private static PyExtractMethodSettings getNameAndVariableData(@NotNull Project project, final @NotNull PyCodeFragment fragment, @NotNull PsiElement element, final boolean isClassMethod, final boolean isStaticMethod) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(71);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(72);
        }
        if (element == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(73);
        }
        PyExtractMethodValidator validator = new PyExtractMethodValidator(element, project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String error;
            String name = System.getProperty(NAME);
            if (name == null) {
                name = "foo";
            }
            if ((error = validator.check(name)) != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(error);
                }
                if (!((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)RefactoringBundle.message((String)"warning.title"), (String)(error + ". " + RefactoringBundle.message((String)"do.you.wish.to.continue"))).icon(UIUtil.getWarningIcon())).ask(project)) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(error);
                }
            }
            ArrayList<PyVariableData> data = new ArrayList<PyVariableData>();
            for (String in : fragment.getInputVariables()) {
                PyVariableData d = new PyVariableData();
                d.name = in + "_new";
                d.originalName = in;
                d.passAsParameter = true;
                d.typeName = fragment.getInputTypeName(in);
                d.type = fragment.getInputType(in);
                data.add(d);
            }
            return new PyExtractMethodSettings(name, data.toArray(new PyVariableData[0]), fragment.getOutputType(), fragment.getOutputTypes(), PyExtractMethodUtil.getAddTypeAnnotations(project));
        }
        final boolean isMethod = PyPsiUtils.isMethodContext((PsiElement)element);
        ExtractMethodDecorator<Object> decorator = new ExtractMethodDecorator<Object>(){

            @NotNull
            public String createMethodSignature(@NotNull ExtractMethodSettings settings) {
                if (settings == null) {
                    2.$$$reportNull$$$0(0);
                }
                PyExtractMethodSettings pySettings = (PyExtractMethodSettings)settings;
                ArrayList<Pair<@NotNull String, @Nullable String>> parameters = new ArrayList<Pair<String, String>>();
                if (isClassMethod) {
                    parameters.add(Pair.create((Object)"cls", null));
                } else if (isMethod && !isStaticMethod) {
                    parameters.add(Pair.create((Object)"self", null));
                }
                for (PyVariableData variableData : pySettings.getAbstractVariableData()) {
                    if (!variableData.passAsParameter) continue;
                    parameters.add(Pair.create((Object)variableData.name, (Object)(pySettings.isUseTypeAnnotations() ? variableData.typeName : null)));
                }
                StringBuilder builder = new StringBuilder();
                PyFunctionBuilder.appendMethodSignature(builder, fragment.isAsync(), pySettings.getMethodName(), parameters, pySettings.isUseTypeAnnotations() ? pySettings.getReturnTypeName() : null);
                String string = builder.toString();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMethodSignature";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createMethodSignature";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        PyExtractMethodSettings extractMethodSettings = PyRefactoringUiService.getInstance().showExtractMethodDialog(project, "method_name", fragment, ArrayUtilRt.EMPTY_OBJECT_ARRAY, validator, decorator, (FileType)PythonFileType.INSTANCE, "python.reference.extractMethod");
        return extractMethodSettings;
    }

    @NotNull
    public static String getRefactoringId() {
        return "refactoring.python.extract.method";
    }

    public static boolean checkNoNameClashes(@NotNull Project project, @NotNull PsiElement element, @NotNull String name) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(74);
        }
        if (element == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(75);
        }
        if (name == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(76);
        }
        return new PyExtractMethodValidator(element, project).check(name) == null;
    }

    public static void setAddTypeAnnotations(Project project, boolean value) {
        PropertiesComponent.getInstance((Project)project).setValue(ADD_TYPE_ANNOTATIONS_VALUE_KEY, value, true);
    }

    public static boolean getAddTypeAnnotations(Project project) {
        boolean selected = PropertiesComponent.getInstance((Project)project).getBoolean(ADD_TYPE_ANNOTATIONS_VALUE_KEY, true);
        return selected;
    }

    private static /* synthetic */ void lambda$extractFromExpression$11(PyCodeFragment fragment, PyExtractMethodSettings methodSettings, PsiElement expression, PyUtil.MethodFlags flags, Project project, boolean isClassMethod, boolean isStaticMethod, PyVariableData[] variableData, SimpleDuplicatesFinder finder, Boolean processDuplicates, List pointers, Editor editor) {
        boolean isAsync = fragment.isAsync();
        PyFunction generatedMethod = PyExtractMethodUtil.generateMethodFromExpression(methodSettings, expression, flags, isAsync);
        PyFunction insertedMethod = (PyFunction)WriteAction.compute(() -> PyExtractMethodUtil.insertGeneratedMethod(expression, generatedMethod));
        boolean isMethod = PyPsiUtils.isMethodContext((PsiElement)expression);
        WriteAction.run(() -> PyExtractMethodUtil.processParameters(project, insertedMethod, methodSettings, isMethod, isClassMethod, isStaticMethod));
        StringBuilder builder = new StringBuilder();
        if (isAsync) {
            builder.append("async ");
        }
        builder.append("def f():\n    ");
        if (isAsync) {
            builder.append("await ");
        } else if (fragment.isYieldInside()) {
            builder.append("yield from ");
        } else {
            builder.append("return ");
        }
        if (isMethod) {
            PyExtractMethodUtil.appendSelf(expression, builder, isStaticMethod);
        }
        builder.append(methodSettings.getMethodName());
        builder.append("(").append(PyExtractMethodUtil.createCallArgsString(variableData)).append(")");
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)project);
        PyFunction function1 = (PyFunction)generator.createFromText(LanguageLevel.forElement((PsiElement)expression), PyFunction.class, builder.toString());
        PyStatement generated = function1.getStatementList().getStatements()[0];
        Object callElement = generated instanceof PyReturnStatement ? ((PyReturnStatement)generated).getExpression() : (generated instanceof PyExpressionStatement ? ((PyExpressionStatement)generated).getExpression() : null);
        PyPsiUtils.assertValid((PsiElement)expression);
        List duplicates = PyExtractMethodUtil.collectDuplicates(finder, expression, insertedMethod);
        if (expression instanceof PyReferenceExpression) {
            duplicates = ContainerUtil.filter(duplicates, it -> it.getStartElement() == it.getEndElement() && expression.getText().equals(it.getStartElement().getText()));
        }
        PsiElement insertedCallElement = null;
        PsiFile file = expression.getContainingFile();
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        if (processDuplicates.booleanValue()) {
            pointers.addAll(ContainerUtil.map((Collection)duplicates, p -> pointerManager.createSmartPsiFileRangePointer(file, p.getStartElement().getTextRange())));
        }
        if (callElement != null) {
            insertedCallElement = (PsiElement)WriteAction.compute(() -> PyExtractMethodUtil.lambda$extractFromExpression$10(expression, (PsiElement)callElement));
            PyExtractMethodUtil.processDuplicatesAndAddImports(project, editor, processDuplicates, pointers, methodSettings, insertedMethod, duplicates, insertedCallElement, file, pointerManager);
        }
        PyExtractMethodUtil.setSelectionAndCaret(editor, insertedCallElement);
    }

    private static /* synthetic */ PsiElement lambda$extractFromExpression$10(PsiElement expression, PsiElement callElement) throws RuntimeException {
        return PyReplaceExpressionUtil.replaceExpression(expression, callElement);
    }

    private static /* synthetic */ void lambda$extractFromStatements$4(PsiElement statement1, PsiElement statement2, Project project, PyCodeFragment fragment, List elementsRange, PyExtractMethodSettings methodSettings, PyUtil.MethodFlags flags, boolean isClassMethod, boolean isStaticMethod, PyVariableData[] variableData, SimpleDuplicatesFinder finder, Boolean processDuplicates, List pointers, PsiFile file, Editor editor) {
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements(new PsiElement[]{statement1, statement2});
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyExtractMethodUtil.getRefactoringId(), beforeData);
        StringBuilder builder = new StringBuilder();
        boolean isAsync = fragment.isAsync();
        if (isAsync) {
            builder.append("async ");
        }
        builder.append("def f():\n    ");
        ArrayList<PsiElement> newMethodElements = new ArrayList<PsiElement>(elementsRange);
        boolean hasOutputVariables = !fragment.getOutputVariables().isEmpty();
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)project);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)statement1);
        if (hasOutputVariables) {
            String outputVariables = StringUtil.join((Collection)fragment.getOutputVariables(), (String)", ");
            String newMethodText = String.valueOf(builder) + "return " + outputVariables;
            builder.append(outputVariables);
            PyFunction function1 = (PyFunction)generator.createFromText(languageLevel, PyFunction.class, newMethodText);
            PyStatement returnStatement = function1.getStatementList().getStatements()[0];
            newMethodElements.add((PsiElement)returnStatement);
        }
        PyFunction generatedMethod = PyExtractMethodUtil.generateMethodFromElements(methodSettings, newMethodElements, flags, isAsync);
        PyFunction insertedMethod = (PyFunction)WriteAction.compute(() -> PyExtractMethodUtil.insertGeneratedMethod(statement1, generatedMethod));
        PsiElement firstElement = (PsiElement)elementsRange.get(0);
        boolean isMethod = PyPsiUtils.isMethodContext((PsiElement)firstElement);
        WriteAction.run(() -> {
            PyExtractMethodUtil.processParameters(project, insertedMethod, methodSettings, isMethod, isClassMethod, isStaticMethod);
            PyExtractMethodUtil.processGlobalWrites(insertedMethod, fragment);
            PyExtractMethodUtil.processNonlocalWrites(insertedMethod, fragment);
        });
        if (hasOutputVariables) {
            builder.append(" = ");
        } else if (fragment.isReturnInstructionInside()) {
            builder.append("return ");
        }
        if (isAsync) {
            builder.append("await ");
        } else if (fragment.isYieldInside()) {
            builder.append("yield from ");
        }
        if (isMethod) {
            PyExtractMethodUtil.appendSelf(firstElement, builder, isStaticMethod);
        }
        builder.append(methodSettings.getMethodName()).append("(");
        builder.append(PyExtractMethodUtil.createCallArgsString(variableData)).append(")");
        PyFunction function1 = (PyFunction)generator.createFromText(languageLevel, PyFunction.class, builder.toString());
        PyStatement callElement = function1.getStatementList().getStatements()[0];
        PyPsiUtils.assertValid((PsiElement)statement1);
        PyPsiUtils.assertValid((PsiElement)statement2);
        List<SimpleMatch> duplicates = PyExtractMethodUtil.collectDuplicates(finder, statement1, insertedMethod);
        PsiElement insertedCallElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)WriteAction.compute(() -> PyExtractMethodUtil.lambda$extractFromStatements$2(elementsRange, (PsiElement)callElement))));
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        if (processDuplicates.booleanValue()) {
            pointers.addAll(ContainerUtil.map(duplicates, p -> pointerManager.createSmartPsiFileRangePointer(file, p.getStartElement().getTextRange())));
        }
        PyExtractMethodUtil.processDuplicatesAndAddImports(project, editor, processDuplicates, pointers, methodSettings, insertedMethod, duplicates, insertedCallElement, file, pointerManager);
        PyExtractMethodUtil.setSelectionAndCaret(editor, insertedCallElement);
        RefactoringEventData afterData = new RefactoringEventData();
        afterData.addElement((PsiElement)insertedMethod);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyExtractMethodUtil.getRefactoringId(), afterData);
    }

    private static /* synthetic */ PsiElement lambda$extractFromStatements$2(List elementsRange, PsiElement callElement) throws RuntimeException {
        return PyExtractMethodUtil.replaceElements(elementsRange, callElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 16, 17, 47, 51, 56, 59, 62, 68 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 20: 
            case 28: 
            case 32: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: 
            case 22: 
            case 24: 
            case 29: 
            case 33: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScopeAnchor";
                break;
            }
            case 12: 
            case 15: 
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethod";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 47: 
            case 51: 
            case 56: 
            case 59: 
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil";
                break;
            }
            case 14: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 18: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 26: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 30: 
            case 34: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processDuplicates";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 39: 
            case 54: 
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSettings";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedMethod";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerManager";
                break;
            }
            case 45: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsRange";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 49: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDatas";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableData";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionText";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDuplicates";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectScopes";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElements";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallArgsString";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "insertGeneratedMethod";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodFromExpression";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodFromElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractFromStatements";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectDuplicates";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 47: 
            case 51: 
            case 56: 
            case 59: 
            case 62: 
            case 68: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectScopes";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalWrites";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processNonlocalWrites";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendSelf";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "extractFromExpression";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicatesAndAddImports";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionAndCaret";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "replaceElements";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createCallArgsString";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processParameters";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "insertGeneratedMethod";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodFromExpression";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "needToWrapInParenthesis";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreakOutsideBraces";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodFromElements";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addDecorators";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addParametersAndReturnType";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getNameAndVariableData";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "checkNoNameClashes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 16, 17, 47, 51, 56, 59, 62, 68 -> new IllegalStateException(string);
        };
    }

    private static class PyExtractMethodValidator
    implements ExtractMethodValidator {
        private final Project myProject;
        @Nullable
        private final Function<String, Boolean> myFunction;

        PyExtractMethodValidator(PsiElement element, Project project) {
            this.myProject = project;
            ScopeOwner parent = ScopeUtil.getScopeOwner(element);
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)parent);
            if (scopeOwner instanceof PyClass) {
                PyClass enclosingClass = (PyClass)scopeOwner;
                this.myFunction = s -> {
                    if (enclosingClass.findMethodByName(s, true, null) != null) {
                        return false;
                    }
                    Scope classScope = ControlFlowCache.getScope((ScopeOwner)enclosingClass);
                    return !classScope.containsDeclaration((String)s);
                };
            } else {
                this.myFunction = s -> {
                    ScopeOwner owner = parent;
                    while (owner != null) {
                        Scope scope;
                        if (!(owner instanceof PyClass) && (scope = ControlFlowCache.getScope(owner)).containsDeclaration((String)s)) {
                            return false;
                        }
                        owner = ScopeUtil.getScopeOwner((PsiElement)owner);
                    }
                    return true;
                };
            }
        }

        @Nullable
        public String check(String name) {
            if (this.myFunction != null && !((Boolean)this.myFunction.fun((Object)name)).booleanValue()) {
                return PyPsiBundle.message("refactoring.extract.method.error.name.clash", new Object[0]);
            }
            return null;
        }

        public boolean isValidName(@NotNull String name) {
            if (name == null) {
                PyExtractMethodValidator.$$$reportNull$$$0(0);
            }
            return LanguageNamesValidation.isIdentifier((Language)PythonLanguage.getInstance(), (String)name, (Project)this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$PyExtractMethodValidator", "isValidName"));
        }
    }
}

