/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery.transport.model;

import java.io.IOException;
import java.util.Collections;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.sql.directquery.rest.model.WriteDirectQueryResourcesRequest;

public class WriteDirectQueryResourcesActionRequest
extends ActionRequest {
    private final WriteDirectQueryResourcesRequest directQueryRequest;

    public WriteDirectQueryResourcesActionRequest(WriteDirectQueryResourcesRequest directQueryRequest) {
        this.directQueryRequest = directQueryRequest;
    }

    public WriteDirectQueryResourcesActionRequest(StreamInput in) throws IOException {
        WriteDirectQueryResourcesRequest request = new WriteDirectQueryResourcesRequest();
        request.setDataSource(in.readOptionalString());
        String resourceTypeStr = in.readOptionalString();
        if (resourceTypeStr != null) {
            request.setResourceTypeFromString(resourceTypeStr);
        }
        request.setResourceName(in.readOptionalString());
        request.setRequest(in.readOptionalString());
        request.setRequestOptions(in.readMap(StreamInput::readString, StreamInput::readString));
        this.directQueryRequest = request;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.directQueryRequest.getDataSource());
        out.writeOptionalString(this.directQueryRequest.getResourceType() != null ? this.directQueryRequest.getResourceType().name() : null);
        out.writeOptionalString(this.directQueryRequest.getResourceName());
        out.writeOptionalString(this.directQueryRequest.getRequest());
        if (this.directQueryRequest.getRequestOptions() != null) {
            out.writeMap(this.directQueryRequest.getRequestOptions(), StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeMap(Collections.emptyMap(), StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    @Generated
    public WriteDirectQueryResourcesRequest getDirectQueryRequest() {
        return this.directQueryRequest;
    }
}

