/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.interceptor;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.transport.grpc.spi.GrpcInterceptorProvider;

public class GrpcInterceptorChain
implements ServerInterceptor {
    private static final Logger logger = LogManager.getLogger(GrpcInterceptorChain.class);
    private static final ServerCall.Listener<Object> EMPTY_LISTENER = new ServerCall.Listener<Object>(){};
    private final List<GrpcInterceptorProvider.OrderedGrpcInterceptor> interceptors = new ArrayList<GrpcInterceptorProvider.OrderedGrpcInterceptor>();
    private final ThreadContext threadContext;

    public GrpcInterceptorChain(ThreadContext threadContext) {
        this.threadContext = Objects.requireNonNull(threadContext, "ThreadContext cannot be null");
    }

    public GrpcInterceptorChain(ThreadContext threadContext, List<GrpcInterceptorProvider.OrderedGrpcInterceptor> interceptors) {
        this.threadContext = Objects.requireNonNull(threadContext, "ThreadContext cannot be null");
        this.interceptors.addAll((Collection<GrpcInterceptorProvider.OrderedGrpcInterceptor>)Objects.requireNonNull(interceptors));
    }

    public void addInterceptors(List<GrpcInterceptorProvider.OrderedGrpcInterceptor> interceptors) {
        this.interceptors.addAll((Collection<GrpcInterceptorProvider.OrderedGrpcInterceptor>)Objects.requireNonNull(interceptors));
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCallHandler currentHandler = next;
        int i = this.interceptors.size() - 1;
        while (i >= 0) {
            final GrpcInterceptorProvider.OrderedGrpcInterceptor interceptor = this.interceptors.get(i);
            final ServerCallHandler nextHandler = currentHandler;
            final int index = i--;
            currentHandler = new ServerCallHandler<ReqT, RespT>(){

                public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> call, Metadata headers) {
                    try {
                        return interceptor.getInterceptor().interceptCall(call, headers, nextHandler);
                    }
                    catch (StatusRuntimeException sre) {
                        logger.error("Interceptor at index [{}] failed with status [{}]: {}", (Object)index, (Object)sre.getStatus().getCode(), (Object)sre.getMessage());
                        call.close(sre.getStatus(), headers);
                        return GrpcInterceptorChain.emptyListener();
                    }
                    catch (Exception e) {
                        logger.error("Interceptor at index [{}] failed unexpectedly: {}", (Object)index, (Object)e.getMessage());
                        call.close(Status.INTERNAL.withDescription("Interceptor failure: " + e.getMessage()), headers);
                        return GrpcInterceptorChain.emptyListener();
                    }
                }
            };
        }
        ServerCall.Listener delegate = currentHandler.startCall(call, headers);
        final Supplier contextSupplier = this.threadContext.newRestorableContext(false);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(this, delegate){

            private void runWithThreadContext(Runnable r) {
                try (ThreadContext.StoredContext ignored = (ThreadContext.StoredContext)contextSupplier.get();){
                    r.run();
                }
            }

            public void onMessage(ReqT message) {
                this.runWithThreadContext(() -> super.onMessage(message));
            }

            public void onHalfClose() {
                this.runWithThreadContext(() -> super.onHalfClose());
            }

            public void onReady() {
                this.runWithThreadContext(() -> super.onReady());
            }

            public void onCancel() {
                this.runWithThreadContext(() -> super.onCancel());
            }

            public void onComplete() {
                this.runWithThreadContext(() -> super.onComplete());
            }
        };
    }

    private static <ReqT> ServerCall.Listener<ReqT> emptyListener() {
        return EMPTY_LISTENER;
    }
}

