/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.SetOnce;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.EncryptedBlobStore;
import org.opensearch.common.lifecycle.Lifecycle;
import org.opensearch.repositories.RepositoryException;
import org.opensearch.repositories.blobstore.BlobStoreRepository;

public class BlobStoreProvider {
    private static final Logger logger = LogManager.getLogger(BlobStoreProvider.class);
    protected final Lifecycle lifecycle;
    protected final RepositoryMetadata metadata;
    protected final Object lock;
    protected final BlobStoreRepository repository;
    private final SetOnce<BlobStore> blobStore = new SetOnce();
    private final SetOnce<BlobStore> serverSideEncryptedBlobStore = new SetOnce();

    public BlobStoreProvider(BlobStoreRepository repository, RepositoryMetadata metadata, Lifecycle lifecycle, Object lock) {
        this.lifecycle = lifecycle;
        this.metadata = metadata;
        this.lock = lock;
        this.repository = repository;
    }

    protected BlobStore blobStore(boolean serverSideEncryptionEnabled) {
        if (serverSideEncryptionEnabled) {
            return this.createBlobStore(this.serverSideEncryptedBlobStore, true);
        }
        return this.createBlobStore(this.blobStore, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobStore createBlobStore(SetOnce<BlobStore> blobStore, boolean serverSideEncryption) {
        BlobStore store = (BlobStore)blobStore.get();
        logger.debug("blob store fetched = " + String.valueOf(store));
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = (BlobStore)blobStore.get();
                if (store == null) {
                    store = this.initBlobStore();
                    if (!serverSideEncryption && this.metadata.cryptoMetadata() != null) {
                        store = new EncryptedBlobStore(store, this.metadata.cryptoMetadata());
                    }
                    blobStore.set((Object)store);
                }
            }
        }
        return store;
    }

    public BlobStore getBlobStore(boolean serverSideEncryptionEnabled) {
        if (serverSideEncryptionEnabled) {
            return (BlobStore)this.serverSideEncryptedBlobStore.get();
        }
        return (BlobStore)this.blobStore.get();
    }

    protected BlobStore initBlobStore() {
        if (!this.lifecycle.started()) {
            throw new RepositoryException(this.metadata.name(), "repository is not in started state" + String.valueOf(this.lifecycle.state()));
        }
        try {
            return this.repository.createBlobStore();
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(this.metadata.name(), "cannot create blob store", e);
        }
    }

    public void close() {
        try {
            if (this.blobStore.get() != null) {
                ((BlobStore)this.blobStore.get()).close();
            }
            if (this.serverSideEncryptedBlobStore.get() != null) {
                ((BlobStore)this.serverSideEncryptedBlobStore.get()).close();
            }
        }
        catch (Exception t) {
            logger.warn("cannot close blob store", (Throwable)t);
        }
    }
}

