/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.service;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.emojipicker.Emoji;
import org.jetbrains.plugins.emojipicker.EmojiCategory;
import org.jetbrains.plugins.emojipicker.EmojiSearchIndex;
import org.jetbrains.plugins.emojipicker.EmojiSkinTone;
import org.jetbrains.plugins.emojipicker.messages.EmojipickerBundle;
import org.xml.sax.SAXException;

@Service
@com.intellij.openapi.components.State(name="EmojiPickerState", category=SettingsCategory.CODE, exportable=true, storages={@Storage(value="emoji.picker.xml", roamingType=RoamingType.DISABLED)})
public final class EmojiService
implements PersistentStateComponent<State> {
    private final List<Emoji> myEmoji;
    private final List<EmojiCategory> myCategories;
    private final EmojiCategory myRecentlyUsedCategory = new EmojiCategory("RecentlyUsed", new CopyOnWriteArrayList<Emoji>());
    private volatile SearchIndex myEmojiSearchIndex;
    @Nls
    private final String[] myEmojiNames;
    private volatile EmojiSkinTone mySkinTone = EmojiSkinTone.NO_TONE;
    private volatile boolean dirty;

    private EmojiService() throws Exception {
        String[] emojiNames;
        SearchIndex searchIndex;
        List emoji;
        Path configDir = PathManager.getConfigDir().resolve("emoji-picker");
        final Path serializedEmojiPath = configDir.resolve("emoji");
        final Path serializedIndexPath = configDir.resolve("index");
        final Path serializedNamesPath = configDir.resolve("names");
        this.myCategories = new ArrayList<EmojiCategory>();
        try {
            try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(serializedEmojiPath, new OpenOption[0]));){
                emoji = (List)in.readObject();
                this.myCategories.add(this.myRecentlyUsedCategory);
                this.myCategories.addAll((List)in.readObject());
            }
            in = new ObjectInputStream(Files.newInputStream(serializedIndexPath, new OpenOption[0]));
            try {
                EmojiSearchIndex index = (EmojiSearchIndex)in.readObject();
                if (index.getTotalEmojiIndices() == 0) {
                    throw new CorruptedException(serializedIndexPath);
                }
                searchIndex = new SearchIndex(index);
            }
            finally {
                in.close();
            }
            in = new ObjectInputStream(Files.newInputStream(serializedNamesPath, new OpenOption[0]));
            try {
                emojiNames = (String[])in.readObject();
            }
            finally {
                in.close();
            }
        }
        catch (IOException | ClassNotFoundException ignore) {
            Files.createDirectories(configDir, new FileAttribute[0]);
            final EmojiData emojiData = EmojiData.read();
            emoji = emojiData.myEmoji;
            this.myCategories.clear();
            this.myCategories.add(this.myRecentlyUsedCategory);
            this.myCategories.addAll(emojiData.myCategories);
            final @Nls String[] names = emojiNames = new String[emoji.size()];
            final CldrData cldr = new CldrData(emojiData);
            final Locale baseLocale = Locale.ENGLISH;
            cldr.read(baseLocale, emojiNames);
            searchIndex = new SearchIndex(cldr.indexTree.buildIndex());
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, EmojipickerBundle.message("message.EmojiPicker.Initializing", new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedEmojiPath, StandardOpenOption.CREATE));){
                            out.writeObject(emojiData.myEmoji);
                            out.writeObject(emojiData.myCategories);
                        }
                        out = new ObjectOutputStream(Files.newOutputStream(serializedNamesPath, StandardOpenOption.CREATE));
                        try {
                            out.writeObject(names);
                        }
                        finally {
                            out.close();
                        }
                        indicator.setText(EmojipickerBundle.message("message.EmojiPicker.BuildingIndex", new Object[0]));
                        indicator.setIndeterminate(false);
                        Locale[] locales = Locale.getAvailableLocales();
                        double multiplier = 1.0 / (double)locales.length;
                        for (int i = 0; i < locales.length; ++i) {
                            indicator.setFraction((double)i * multiplier);
                            if (locales[i].equals(baseLocale)) continue;
                            cldr.read(locales[i], null);
                        }
                        indicator.setIndeterminate(true);
                        SearchIndex searchIndex = new SearchIndex(cldr.indexTree.buildIndex());
                        indicator.setText(EmojipickerBundle.message("message.EmojiPicker.SavingIndexData", new Object[0]));
                        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedIndexPath, StandardOpenOption.CREATE));){
                            out.writeObject(searchIndex.myIndex);
                        }
                        EmojiService.this.myEmojiSearchIndex = searchIndex;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    catch (SAXException e) {
                        throw new RuntimeException(e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/emojipicker/service/EmojiService$1", "run"));
                }
            });
        }
        this.myEmoji = emoji;
        this.myEmojiSearchIndex = searchIndex;
        this.myEmojiNames = emojiNames;
    }

    public List<EmojiCategory> getCategories() {
        return this.myCategories;
    }

    @Nls
    public String findNameForEmoji(Emoji emoji) {
        return emoji == null ? null : this.myEmojiNames[emoji.getId()];
    }

    public List<Emoji> findEmojiByPrefix(@NonNls String prefix) {
        return this.myEmojiSearchIndex.lookupEmoji(prefix);
    }

    public void saveRecentlyUsedEmoji(Emoji emoji) {
        this.myRecentlyUsedCategory.getEmoji().remove(emoji);
        while (this.myRecentlyUsedCategory.getEmoji().size() >= 32) {
            this.myRecentlyUsedCategory.getEmoji().remove(this.myRecentlyUsedCategory.getEmoji().size() - 1);
        }
        this.myRecentlyUsedCategory.getEmoji().add(0, emoji);
        this.dirty = true;
    }

    public EmojiSkinTone getCurrentSkinTone() {
        return this.mySkinTone;
    }

    public void setCurrentSkinTone(EmojiSkinTone skinTone) {
        this.mySkinTone = skinTone;
        this.dirty = true;
    }

    @Nullable
    public State getState() {
        if (!this.dirty) {
            return null;
        }
        this.dirty = false;
        return new State(this.mySkinTone, ContainerUtil.map(this.myRecentlyUsedCategory.getEmoji(), Emoji::getId));
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            EmojiService.$$$reportNull$$$0(0);
        }
        if (state.mySkinTone != null) {
            this.mySkinTone = state.mySkinTone;
        }
        if (state.myRecentlyUsedEmoji != null && !state.myRecentlyUsedEmoji.isEmpty()) {
            this.myRecentlyUsedCategory.getEmoji().clear();
            this.myRecentlyUsedCategory.getEmoji().addAll(ContainerUtil.map(state.myRecentlyUsedEmoji, this.myEmoji::get));
        }
    }

    public static EmojiService getInstance() {
        return (EmojiService)ApplicationManager.getApplication().getService(EmojiService.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/emojipicker/service/EmojiService", "loadState"));
    }

    private final class SearchIndex {
        private final EmojiSearchIndex myIndex;
        private final boolean[] myIdMap;

        private SearchIndex(EmojiSearchIndex index) {
            this.myIndex = index;
            this.myIdMap = new boolean[index.getTotalEmojiIndices()];
        }

        synchronized List<Emoji> lookupEmoji(@NonNls String prefix) {
            if (this.myIndex.lookupIds(this.myIdMap, prefix.toLowerCase())) {
                ArrayList<Emoji> result = new ArrayList<Emoji>(100);
                for (int i = 0; i < this.myIdMap.length; ++i) {
                    if (!this.myIdMap[i]) continue;
                    result.add(EmojiService.this.myEmoji.get(i));
                }
                return result;
            }
            return List.of();
        }
    }

    private static final class EmojiData {
        private final List<Emoji> myEmoji = new ArrayList<Emoji>();
        private final List<EmojiCategory> myCategories = new ArrayList<EmojiCategory>();
        private final Map<@NonNls String, Integer> indicesMap = new HashMap<String, Integer>();

        private EmojiData() {
        }

        private static EmojiData read() throws IOException {
            Set<@NonNls String> tonedEmojiSet = EmojiData.readToned();
            EmojiData emojiData = new EmojiData();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(EmojiService.class.getClassLoader().getResourceAsStream("data/emoji.txt")), StandardCharsets.UTF_8));){
                String s;
                EmojiCategory category = null;
                while ((s = reader.readLine()) != null) {
                    if (s.isBlank()) {
                        category = null;
                        continue;
                    }
                    if (category == null) {
                        category = new EmojiCategory(s, new ArrayList<Emoji>());
                        emojiData.myCategories.add(category);
                        continue;
                    }
                    int id = emojiData.myEmoji.size();
                    Emoji emoji = new Emoji(id, s, tonedEmojiSet.contains(s));
                    emojiData.myEmoji.add(emoji);
                    category.getEmoji().add(emoji);
                    emojiData.indicesMap.put(s, id);
                }
            }
            return emojiData;
        }

        private static Set<@NonNls String> readToned() throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(EmojiService.class.getClassLoader().getResourceAsStream("data/toned.txt")), StandardCharsets.UTF_8));){
                Set<String> set = reader.lines().collect(Collectors.toSet());
                return set;
            }
        }
    }

    private static final class CldrData {
        private final EmojiData emojiData;
        private final EmojiSearchIndex.PrefixTree indexTree = new EmojiSearchIndex.PrefixTree();

        private CldrData(EmojiData emojiData) {
            this.emojiData = emojiData;
        }

        private void read(@NotNull Locale locale, @Nls String[] names) throws IOException, SAXException {
            byte[] derived;
            byte[] annotations;
            if (locale == null) {
                CldrData.$$$reportNull$$$0(0);
            }
            @NonNls Object l = locale.getLanguage();
            if (!locale.getScript().isEmpty()) {
                l = (String)l + "_" + locale.getScript();
            }
            if (!locale.getCountry().isEmpty()) {
                l = (String)l + "_" + locale.getCountry();
            }
            if ((annotations = ResourceUtil.getResourceAsBytes((String)("data/cldr/annotations/" + (String)l + ".xml"), (ClassLoader)EmojiService.class.getClassLoader())) != null) {
                this.read(annotations, locale, names);
            }
            if ((derived = ResourceUtil.getResourceAsBytes((String)("data/cldr/annotationsDerived/" + (String)l + ".xml"), (ClassLoader)EmojiService.class.getClassLoader())) != null) {
                this.read(derived, locale, names);
            }
        }

        private void read(byte[] in, Locale locale, @Nls String[] names) {
            XmlElement document = XmlDomReader.readXmlAsModel((byte[])in);
            XmlElement annotationsNode = document.getChild("annotations");
            for (XmlElement node : (annotationsNode != null ? annotationsNode : document).children("annotation")) {
                @NonNls String emoji = node.getAttributeValue("cp");
                Integer index = this.emojiData.indicesMap.get(emoji);
                if (index == null) continue;
                @NonNls String value = Objects.requireNonNull(node.content);
                if (node.getAttributeValue("type") == null) {
                    for (String keyword : value.split("\\|")) {
                        this.indexTree.add(keyword.strip().toLowerCase(), index);
                    }
                    continue;
                }
                if (names == null) continue;
                @Nls String name = value.substring(0, 1).toUpperCase(locale) + value.substring(1);
                names[index.intValue()] = name;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "org/jetbrains/plugins/emojipicker/service/EmojiService$CldrData", "read"));
        }
    }

    static final class State {
        public EmojiSkinTone mySkinTone;
        public List<Integer> myRecentlyUsedEmoji;

        private State() {
            this(EmojiSkinTone.NO_TONE, List.of());
        }

        private State(EmojiSkinTone tone, List<Integer> emoji) {
            this.mySkinTone = tone;
            this.myRecentlyUsedEmoji = emoji;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return Objects.equals((Object)this.mySkinTone, (Object)state.mySkinTone) && Objects.equals(this.myRecentlyUsedEmoji, state.myRecentlyUsedEmoji);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mySkinTone, this.myRecentlyUsedEmoji});
        }
    }
}

